/*
 * FCML - Free Code Manipulation Library.
 * Copyright (C) 2010-2015 Slawomir Wojtasiak
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <fcml_assembler.h>
#include "instructions_v_t.h"
#include "instructions_base_t.h"

fcml_bool fcml_tf_instructions_v_suite_init(void) {
    return FCML_TRUE;
}

fcml_bool fcml_tf_instructions_v_suite_cleanup(void) {
    return FCML_TRUE;
}

void fcml_tf_instruction_VBROADCASTSS(void) {

    FCML_I32_M("vbroadcastss xmm2,dword ptr [ecx+eax]", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x18, 0x14, 0x01), FCML_MI(0xc4, 0xe2, 0x79, 0x18, 0x14, 0x01));
    FCML_I32_M("vbroadcastss ymm2,dword ptr [ecx+eax]", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x18, 0x14, 0x01), FCML_MI(0xc4, 0xe2, 0x7d, 0x18, 0x14, 0x01));

    FCML_I32_FAILED( "FAIL", 0xC4, 0xE2, 0x49, 0x19, 0x14, 0x01 );
    FCML_I32_M("vbroadcastsd ymm2,mmword ptr [ecx+eax]", 2, FCML_MI(0x62, 0xf2, 0xfd, 0x28, 0x19, 0x14, 0x01), FCML_MI(0xc4, 0xe2, 0x7d, 0x19, 0x14, 0x01));

    FCML_I32("vbroadcastsd ymm2{k5}{z},mmword ptr [ecx+eax]", 0x62, 0xf2, 0xfd, 0xad, 0x19, 0x14, 0x01);
    FCML_I32("vbroadcastsd ymm2{k6},mmword ptr [ecx+eax]", 0x62, 0xf2, 0xfd, 0x2e, 0x19, 0x14, 0x01);
    FCML_I32("vbroadcastsd ymm2{k5}{z},xmm3", 0x62, 0xf2, 0xfd, 0xad, 0x19, 0xd3);
    FCML_I32_M("vbroadcastsd ymm2,xmm3", 2, FCML_MI(0x62, 0xf2, 0xfd, 0x28, 0x19, 0xd3), FCML_MI(0xc4, 0xe2, 0x7d, 0x19, 0xd3));
    FCML_I32("vbroadcastsd ymm2{k5}{z},mmword ptr [ecx+00000020h]", 0x62, 0xf2, 0xfd, 0xad, 0x19, 0x51, 0x04);

    FCML_I64("vbroadcastsd zmm2{k5}{z},mmword ptr [rcx+rax]", 0x62, 0xf2, 0xfd, 0xcd, 0x19, 0x14, 0x01);
    FCML_I64("vbroadcastsd zmm2{k6},mmword ptr [rcx+rax]", 0x62, 0xf2, 0xfd, 0x4e, 0x19, 0x14, 0x01);
    FCML_I64("vbroadcastsd zmm2{k5}{z},xmm3", 0x62, 0xf2, 0xfd, 0xcd, 0x19, 0xd3);
    FCML_I64("vbroadcastsd zmm2,xmm3", 0x62, 0xf2, 0xfd, 0x48, 0x19, 0xd3);

    FCML_I32( "vbroadcastf128 ymm2,oword ptr [ecx+eax]", 0xC4, 0xE2, 0x7D, 0x1A, 0x14, 0x01 );

    FCML_I32( "vbroadcasti128 ymm2,oword ptr [ecx+eax]", 0xC4, 0xE2, 0x7D, 0x5A, 0x14, 0x01 );

    FCML_I32_M("vbroadcastss xmm0,xmm1", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x18, 0xc1), FCML_MI(0xc4, 0xe2, 0x79, 0x18, 0xc1));
    FCML_I32_M("vbroadcastss ymm0,xmm1", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x18, 0xc1), FCML_MI(0xc4, 0xe2, 0x7d, 0x18, 0xc1));

    FCML_I32_M("vbroadcastsd ymm0,xmm1", 2, FCML_MI(0x62, 0xf2, 0xfd, 0x28, 0x19, 0xc1), FCML_MI(0xc4, 0xe2, 0x7d, 0x19, 0xc1));

    FCML_A64_M("vbroadcastss (%rcx,%rax),%xmm2", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x18, 0x14, 0x01), FCML_MI(0xc4, 0xe2, 0x79, 0x18, 0x14, 0x01));
    FCML_A64_M("vbroadcastss (%rcx,%rax),%ymm2", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x18, 0x14, 0x01), FCML_MI(0xc4, 0xe2, 0x7d, 0x18, 0x14, 0x01));
    FCML_A64_M("vbroadcastsd (%rcx,%rax),%ymm2", 2, FCML_MI(0x62, 0xf2, 0xfd, 0x28, 0x19, 0x14, 0x01), FCML_MI(0xc4, 0xe2, 0x7d, 0x19, 0x14, 0x01));
    FCML_A64( "vbroadcastf128 (%rcx,%rax),%ymm2", 0xc4, 0xe2, 0x7d, 0x1a, 0x14, 0x01 );
    FCML_A64( "vbroadcasti128 (%rcx,%rax),%ymm2", 0xc4, 0xe2, 0x7d, 0x5a, 0x14, 0x01 );
    FCML_A64_M("vbroadcastss %xmm1,%xmm0", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x18, 0xc1), FCML_MI(0xc4, 0xe2, 0x79, 0x18, 0xc1));
    FCML_A64_M("vbroadcastss %xmm1,%ymm0", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x18, 0xc1), FCML_MI(0xc4, 0xe2, 0x7d, 0x18, 0xc1));
    FCML_A64_M("vbroadcastsd %xmm1,%ymm0", 2, FCML_MI(0x62, 0xf2, 0xfd, 0x28, 0x19, 0xc1), FCML_MI(0xc4, 0xe2, 0x7d, 0x19, 0xc1));

    FCML_I32("vbroadcastf32x2 ymm2{k5}{z},mmword ptr [ecx+eax]", 0x62, 0xf2, 0x7D, 0xad, 0x19, 0x14, 0x01);
    FCML_I32("vbroadcastf32x2 ymm2{k6},mmword ptr [ecx+eax]", 0x62, 0xf2, 0x7D, 0x2e, 0x19, 0x14, 0x01);
    FCML_I32("vbroadcastf32x2 ymm2{k5}{z},xmm3", 0x62, 0xf2, 0x7D, 0xad, 0x19, 0xd3);
    FCML_I32("vbroadcastf32x2 ymm2,xmm3", 0x62, 0xf2, 0x7d, 0x28, 0x19, 0xd3);
    FCML_I32("vbroadcastf32x2 ymm2{k5}{z},mmword ptr [ecx+00000020h]", 0x62, 0xf2, 0x7d, 0xad, 0x19, 0x51, 0x04);

    FCML_I64("vbroadcastf32x2 zmm2{k5}{z},mmword ptr [rcx+rax]", 0x62, 0xf2, 0x7D, 0xcd, 0x19, 0x14, 0x01);
    FCML_I64("vbroadcastf32x2 zmm2{k6},mmword ptr [rcx+rax]", 0x62, 0xf2, 0x7D, 0x4e, 0x19, 0x14, 0x01);
    FCML_I64("vbroadcastf32x2 zmm2{k5}{z},xmm3", 0x62, 0xf2, 0x7D, 0xcd, 0x19, 0xd3);
    FCML_I64("vbroadcastf32x2 zmm2,xmm3", 0x62, 0xf2, 0x7D, 0x48, 0x19, 0xd3);

    FCML_I32("vbroadcastf32x4 ymm2{k5}{z},xmmword ptr [ecx+eax]", 0x62, 0xf2, 0x7d, 0xad, 0x1a, 0x14, 0x01);
    FCML_I32("vbroadcastf32x4 ymm2{k6},xmmword ptr [ecx+eax]", 0x62, 0xf2, 0x7d, 0x2e, 0x1a, 0x14, 0x01);
    FCML_I64("vbroadcastf32x4 zmm2{k5}{z},xmmword ptr [rcx+rax]", 0x62, 0xf2, 0x7d, 0xcd, 0x1a, 0x14, 0x01);
    FCML_I64("vbroadcastf32x4 zmm2{k6},xmmword ptr [rcx+rax]", 0x62, 0xf2, 0x7d, 0x4e, 0x1a, 0x14, 0x01);
    FCML_I32("vbroadcastf32x4 ymm2{k5}{z},xmmword ptr [ecx+00000020h]", 0x62, 0xf2, 0x7d, 0xad, 0x1a, 0x51, 0x02);

    FCML_I64("vbroadcastf32x8 zmm2{k5}{z},ymmword ptr [rcx+rax]", 0x62, 0xf2, 0x7d, 0xcd, 0x1b, 0x14, 0x01);
    FCML_I64("vbroadcastf32x8 zmm2{k6},ymmword ptr [rcx+rax]", 0x62, 0xf2, 0x7d, 0x4e, 0x1b, 0x14, 0x01);
    FCML_I64("vbroadcastf32x8 zmm2{k6},ymmword ptr [rcx+0000000000000020h]", 0x62, 0xf2, 0x7d, 0x4e, 0x1b, 0x51, 0x01);

    FCML_I32("vbroadcastf64x2 ymm2{k5}{z},xmmword ptr [ecx+eax]", 0x62, 0xf2, 0xfd, 0xad, 0x1a, 0x14, 0x01);
    FCML_I32("vbroadcastf64x2 ymm2{k6},xmmword ptr [ecx+eax]", 0x62, 0xf2, 0xfd, 0x2e, 0x1a, 0x14, 0x01);
    FCML_I64("vbroadcastf64x2 zmm2{k5}{z},xmmword ptr [rcx+rax]", 0x62, 0xf2, 0xfd, 0xcd, 0x1a, 0x14, 0x01);
    FCML_I64("vbroadcastf64x2 zmm2{k6},xmmword ptr [rcx+rax]", 0x62, 0xf2, 0xfd, 0x4e, 0x1a, 0x14, 0x01);
    FCML_I64("vbroadcastf64x2 zmm2{k6},xmmword ptr [rcx+0000000000000020h]", 0x62, 0xf2, 0xfd, 0x4e, 0x1a, 0x51, 0x02);

    FCML_I64("vbroadcastf64x4 zmm2{k5}{z},ymmword ptr [rcx+rax]", 0x62, 0xf2, 0xfd, 0xcd, 0x1b, 0x14, 0x01);
    FCML_I64("vbroadcastf64x4 zmm2{k6},ymmword ptr [rcx+rax]", 0x62, 0xf2, 0xfd, 0x4e, 0x1b, 0x14, 0x01);
    FCML_I64("vbroadcastf64x4 zmm2{k6},ymmword ptr [rcx+0000000000000020h]", 0x62, 0xf2, 0xfd, 0x4e, 0x1b, 0x51, 0x01);

    FCML_I32("vbroadcastss xmm2{k5}{z},dword ptr [ecx+eax]", 0x62, 0xf2, 0x7d, 0x8d, 0x18, 0x14, 0x01);
    FCML_I32("vbroadcastss xmm2{k6},dword ptr [ecx+eax]", 0x62, 0xf2, 0x7d, 0x0e, 0x18, 0x14, 0x01);
    FCML_I32("vbroadcastss xmm2{k5}{z},xmm3", 0x62, 0xf2, 0x7d, 0x8d, 0x18, 0xd3);
    FCML_I32_M("vbroadcastss xmm2,xmm3", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x18, 0xd3), FCML_MI(0xc4, 0xe2, 0x79, 0x18, 0xd3));
    FCML_I32("vbroadcastss ymm2{k5}{z},dword ptr [ecx+00000020h]", 0x62, 0xf2, 0x7d, 0xad, 0x18, 0x51, 0x08);

    FCML_I64("vbroadcastss ymm2{k5}{z},dword ptr [rcx+rax]", 0x62, 0xf2, 0x7d, 0xad, 0x18, 0x14, 0x01);
    FCML_I64("vbroadcastss ymm2{k6},dword ptr [rcx+rax]", 0x62, 0xf2, 0x7d, 0x2e, 0x18, 0x14, 0x01);
    FCML_I64("vbroadcastss ymm2{k5}{z},xmm3", 0x62, 0xf2, 0x7d, 0xad, 0x18, 0xd3);
}

void fcml_tf_instruction_VCOMPRESSPD(void) {
    FCML_I64("vcompresspd xmm2{k5}{z},xmm13", 0x62, 0x72, 0xfd, 0x8d, 0x8a, 0xea);
    FCML_I64("vcompresspd ymm2{k5}{z},ymm13", 0x62, 0x72, 0xfd, 0xad, 0x8a, 0xea);
    FCML_I64("vcompresspd zmm2{k5}{z},zmm13", 0x62, 0x72, 0xfd, 0xcd, 0x8a, 0xea);
    FCML_I64("vcompresspd ymm2{k5},ymm13", 0x62, 0x72, 0xfd, 0x2d, 0x8a, 0xea);
    FCML_I64("vcompresspd zmm2{k5},zmm13", 0x62, 0x72, 0xfd, 0x4d, 0x8a, 0xea);
    FCML_I64("vcompresspd ymm2,ymm13", 0x62, 0x72, 0xfd, 0x28, 0x8a, 0xea);
    FCML_I64("vcompresspd zmm2{k5},zmm13", 0x62, 0x72, 0xfd, 0x4d, 0x8a, 0xea);
    FCML_I64("vcompresspd xmmword ptr [rcx+rax],xmm13", 0x62, 0x72, 0xfd, 0x08, 0x8a, 0x2c, 0x01);
    FCML_I64("vcompresspd ymmword ptr [rcx+rax],ymm13", 0x62, 0x72, 0xfd, 0x28, 0x8a, 0x2c, 0x01);
    FCML_I64("vcompresspd zmmword ptr [rcx+rax],zmm13", 0x62, 0x72, 0xfd, 0x48, 0x8a, 0x2c, 0x01);
    FCML_I64("vcompresspd zmmword ptr [rcx+0000000000000040h],zmm13", 0x62, 0x72, 0xfd, 0x48, 0x8a, 0x69, 0x08);
}

void fcml_tf_instruction_VCOMPRESSPS(void) {
    FCML_I64("vcompressps xmm2{k5}{z},xmm13", 0x62, 0x72, 0x7d, 0x8d, 0x8a, 0xea);
    FCML_I64("vcompressps ymm2{k5}{z},ymm13", 0x62, 0x72, 0x7d, 0xad, 0x8a, 0xea);
    FCML_I64("vcompressps zmm2{k5}{z},zmm13", 0x62, 0x72, 0x7d, 0xcd, 0x8a, 0xea);
    FCML_I64("vcompressps ymm2{k5},ymm13", 0x62, 0x72, 0x7d, 0x2d, 0x8a, 0xea);
    FCML_I64("vcompressps zmm2{k5},zmm13", 0x62, 0x72, 0x7d, 0x4d, 0x8a, 0xea);
    FCML_I64("vcompressps ymm2,ymm13", 0x62, 0x72, 0x7d, 0x28, 0x8a, 0xea);
    FCML_I64("vcompressps zmm2{k5},zmm13", 0x62, 0x72, 0x7d, 0x4d, 0x8a, 0xea);
    FCML_I64("vcompressps xmmword ptr [rcx+rax],xmm13", 0x62, 0x72, 0x7d, 0x08, 0x8a, 0x2c, 0x01);
    FCML_I64("vcompressps ymmword ptr [rcx+rax],ymm13", 0x62, 0x72, 0x7d, 0x28, 0x8a, 0x2c, 0x01);
    FCML_I64("vcompressps zmmword ptr [rcx+rax],zmm13", 0x62, 0x72, 0x7d, 0x48, 0x8a, 0x2c, 0x01);
    FCML_I64("vcompressps zmmword ptr [rcx+0000000000000040h],zmm13", 0x62, 0x72, 0x7d, 0x48, 0x8a, 0x69, 0x10);
}

void fcml_tf_instruction_VCVTPD2QQ(void) {
    FCML_I64("vcvtpd2qq xmm3,xmm0", 0x62, 0xf1, 0xfd, 0x08, 0x7b, 0xd8);
    FCML_I32("vcvtpd2qq xmm3,xmm0", 0x62, 0xf1, 0xfd, 0x08, 0x7b, 0xd8);
    FCML_I32("vcvtpd2qq ymm0,ymmword ptr [eax]", 0x62, 0xf1, 0xfd, 0x28, 0x7b, 0x00);
    FCML_A64("vcvtpd2qq %xmm0,%xmm3", 0x62, 0xf1, 0xfd, 0x08, 0x7b, 0xd8);
    FCML_A64("vcvtpd2qq %xmm0,%xmm3", 0x62, 0xf1, 0xfd, 0x08, 0x7b, 0xd8);
    FCML_A64("vcvtpd2qq (%rax),%ymm0", 0x62, 0xf1, 0xfd, 0x28, 0x7b, 0x00);

    /* {k} */
    FCML_I64("vcvtpd2qq ymm10{k1},ymmword ptr [r9+r8]", 0x62, 0x11, 0xfd, 0x29, 0x7b, 0x14, 0x01);
    FCML_A64("vcvtpd2qq (%r9,%r8),%ymm10{%k1}", 0x62, 0x11, 0xfd, 0x29, 0x7b, 0x14, 0x01);
    FCML_I64("vcvtpd2qq xmm10{k1},xmmword ptr [r9+r8]", 0x62, 0x11, 0xfd, 0x09, 0x7b, 0x14, 0x01);
    FCML_A64("vcvtpd2qq (%r9,%r8),%xmm10{%k1}", 0x62, 0x11, 0xfd, 0x09, 0x7b, 0x14, 0x01);
    FCML_I64("vcvtpd2qq zmm1{k1},zmmword ptr [r9+r8]", 0x62, 0x91, 0xfd, 0x49, 0x7b, 0x0c, 0x01);
    FCML_A64("vcvtpd2qq (%r9,%r8),%zmm1{%k1}", 0x62, 0x91, 0xfd, 0x49, 0x7b, 0x0c, 0x01);

    /* {k}{z} */
    FCML_I64("vcvtpd2qq ymm10{k1}{z},ymmword ptr [r9+r8]", 0x62, 0x11, 0xfd, 0xa9, 0x7b, 0x14, 0x01);

    /* {bcast} */
    FCML_I64("vcvtpd2qq zmm31,mmword ptr [rsi]{1to8}", 0x62, 0x61, 0xfd, 0x58, 0x7b, 0x3e);

    /* {k}{z}{bcast} */
    FCML_I64("vcvtpd2qq ymm31{k7}{z},mmword ptr [rsi]{1to4}", 0x62, 0x61, 0xfd, 0xbf, 0x7b, 0x3e);
    FCML_A64("vcvtpd2qq (%rsi){1to4},%ymm31{%k7}{z}", 0x62, 0x61, 0xfd, 0xbf, 0x7b, 0x3e);

    /* {rn} */
    FCML_I64("vcvtpd2qq zmm31{k7}{z},zmm4,{rn-sae}", 0x62, 0x61, 0xfd, 0x9f, 0x7b, 0xfc);

    /* Compressed disp8 */
    FCML_I64("vcvtpd2qq xmm1{k4}{z},mmword ptr [rsp+0000000000000020h]{1to2}", 0x62, 0xf1, 0xfd, 0x9c, 0x7b, 0x4c, 0x24, 0x04);
    FCML_I64("vcvtpd2qq xmm1{k4}{z},mmword ptr [rsp+00000000000001d0h]{1to2}", 0x62, 0xf1, 0xfd, 0x9c, 0x7b, 0x4c, 0x24, 0x3a);
    FCML_I32("vcvtpd2qq xmm1{k4}{z},mmword ptr [esp+00000020h]{1to2}", 0x62, 0xf1, 0xfd, 0x9c, 0x7b, 0x4c, 0x24, 0x04);
}

void fcml_tf_instruction_VCVTPS2UDQ(void) {
    FCML_I64("vcvtps2udq xmm3,xmm0", 0x62, 0xf1, 0x7c, 0x08, 0x79, 0xd8);
    FCML_I32("vcvtps2udq xmm3,xmm0", 0x62, 0xf1, 0x7c, 0x08, 0x79, 0xd8);
    FCML_I32("vcvtps2udq ymm0,ymmword ptr [eax]", 0x62, 0xf1, 0x7c, 0x28, 0x79, 0x00);
    FCML_A64("vcvtps2udq %xmm0,%xmm3", 0x62, 0xf1, 0x7c, 0x08, 0x79, 0xd8);
    FCML_A64("vcvtps2udq %xmm0,%xmm3", 0x62, 0xf1, 0x7c, 0x08, 0x79, 0xd8);
    FCML_A64("vcvtps2udq (%rax),%ymm0", 0x62, 0xf1, 0x7c, 0x28, 0x79, 0x00);

    /* {k} */
    FCML_I64("vcvtps2udq ymm10{k1},ymmword ptr [r9+r8]", 0x62, 0x11, 0x7c, 0x29, 0x79, 0x14, 0x01);
    FCML_A64("vcvtps2udq (%r9,%r8),%ymm10{%k1}", 0x62, 0x11, 0x7c, 0x29, 0x79, 0x14, 0x01);
    FCML_I64("vcvtps2udq xmm10{k1},xmmword ptr [r9+r8]", 0x62, 0x11, 0x7c, 0x09, 0x79, 0x14, 0x01);
    FCML_A64("vcvtps2udq (%r9,%r8),%xmm10{%k1}", 0x62, 0x11, 0x7c, 0x09, 0x79, 0x14, 0x01);
    FCML_I64("vcvtps2udq zmm1{k1},zmmword ptr [r9+r8]", 0x62, 0x91, 0x7c, 0x49, 0x79, 0x0c, 0x01);
    FCML_A64("vcvtps2udq (%r9,%r8),%zmm1{%k1}", 0x62, 0x91, 0x7c, 0x49, 0x79, 0x0c, 0x01);

    /* {k}{z} */
    FCML_I64("vcvtps2udq ymm10{k1}{z},ymmword ptr [r9+r8]", 0x62, 0x11, 0x7c, 0xa9, 0x79, 0x14, 0x01);

    /* {bcast} */
    FCML_I64("vcvtps2udq zmm31,dword ptr [rsi]{1to16}", 0x62, 0x61, 0x7c, 0x58, 0x79, 0x3e);

    /* {k}{z}{bcast} */
    FCML_I64("vcvtps2udq ymm31{k7}{z},dword ptr [rsi]{1to8}", 0x62, 0x61, 0x7c, 0xbf, 0x79, 0x3e);
    FCML_A64("vcvtps2udq (%rsi){1to8},%ymm31{%k7}{z}", 0x62, 0x61, 0x7c, 0xbf, 0x79, 0x3e);

    /* {rn} */
    FCML_I64("vcvtps2udq zmm31{k7}{z},zmm4,{rn-sae}", 0x62, 0x61, 0x7c, 0x9f, 0x79, 0xfc);

    /* Compressed disp8 */
    FCML_I64("vcvtps2udq xmm1{k4}{z},dword ptr [rsp+0000000000000020h]{1to4}", 0x62, 0xf1, 0x7c, 0x9c, 0x79, 0x4c, 0x24, 0x08);
    FCML_I64("vcvtps2udq xmm1{k4}{z},dword ptr [rsp+00000000000001d0h]{1to4}", 0x62, 0xf1, 0x7c, 0x9c, 0x79, 0x4c, 0x24, 0x74);
    FCML_I32("vcvtps2udq xmm1{k4}{z},dword ptr [esp+00000020h]{1to4}", 0x62, 0xf1, 0x7c, 0x9c, 0x79, 0x4c, 0x24, 0x08);
}

void fcml_tf_instruction_VCVTPD2UDQ(void) {
    FCML_I64("vcvtpd2udq xmm3,xmm0", 0x62, 0xf1, 0xfc, 0x08, 0x79, 0xd8);
    FCML_I32("vcvtpd2udq xmm3,xmm0", 0x62, 0xf1, 0xfc, 0x08, 0x79, 0xd8);
    FCML_I32("vcvtpd2udq xmm0,ymmword ptr [eax]", 0x62, 0xf1, 0xfc, 0x28, 0x79, 0x00);
    FCML_A64("vcvtpd2udqx %xmm0,%xmm3", 0x62, 0xf1, 0xfc, 0x08, 0x79, 0xd8);
    FCML_A64("vcvtpd2udqx %xmm0,%xmm3", 0x62, 0xf1, 0xfc, 0x08, 0x79, 0xd8);
    FCML_A64("vcvtpd2udqx (%rax),%xmm0", 0x62, 0xf1, 0xfc, 0x08, 0x79, 0x00);
    FCML_I64("vcvtpd2udq xmm10{k1},ymmword ptr [r9+r8]", 0x62, 0x11, 0xfc, 0x29, 0x79, 0x14, 0x01);
    FCML_A64("vcvtpd2udq (%r9,%r8),%ymm10{%k1}", 0x62, 0x11, 0xfc, 0x49, 0x79, 0x14, 0x01);
    FCML_I64("vcvtpd2udq xmm10{k1},xmmword ptr [r9+r8]", 0x62, 0x11, 0xfc, 0x09, 0x79, 0x14, 0x01);
    FCML_A64("vcvtpd2udqx (%r9,%r8),%xmm10{%k1}", 0x62, 0x11, 0xfc, 0x09, 0x79, 0x14, 0x01);
    FCML_I64("vcvtpd2udq ymm1{k1},zmmword ptr [r9+r8]", 0x62, 0x91, 0xfc, 0x49, 0x79, 0x0c, 0x01);
    FCML_A64("vcvtpd2udq (%r9,%r8),%ymm1{%k1}", 0x62, 0x91, 0xfc, 0x49, 0x79, 0x0c, 0x01);
    FCML_I64("vcvtpd2udq xmm10{k1}{z},ymmword ptr [r9+r8]", 0x62, 0x11, 0xfc, 0xa9, 0x79, 0x14, 0x01);
    FCML_A64("vcvtpd2udq (%rsi){1to8},%ymm31", 0x62, 0x61, 0xfc, 0x58, 0x79, 0x3e);
    FCML_A64("vcvtpd2udq (%rsi){1to8},%ymm31", 0x62, 0x61, 0xfc, 0x58, 0x79, 0x3e);
    FCML_I64("vcvtpd2udq ymm31,mmword ptr [rsi]{1to8}", 0x62, 0x61, 0xfc, 0x58, 0x79, 0x3e);
    FCML_I64("vcvtpd2udq xmm31{k7}{z},mmword ptr [rsi]{1to4}", 0x62, 0x61, 0xfc, 0xbf, 0x79, 0x3e);
    FCML_A64("vcvtpd2udqx (%rsi){1to2},%xmm31{%k7}{z}", 0x62, 0x61, 0xfc, 0x9f, 0x79, 0x3e);
    FCML_A64("vcvtpd2udqy (%rsi){1to4},%xmm31{%k7}{z}", 0x62, 0x61, 0xfc, 0xbf, 0x79, 0x3e);
    FCML_I64("vcvtpd2udq ymm31{k7}{z},zmm4,{rn-sae}", 0x62, 0x61, 0xfc, 0x9f, 0x79, 0xfc);
    FCML_I64_A("vcvtpd2udq xmm1{k4}{z},mmword ptr [rsp+0000000000000020h]{1to2}", 0x62, 0xf1, 0xfc, 0x9c, 0x79, 0x4c, 0x24, 0x04);
    FCML_I64_A("vcvtpd2udq xmm1{k4}{z},mmword ptr [rsp+00000000000001d0h]{1to2}", 0x62, 0xf1, 0xfc, 0x9c, 0x79, 0x4c, 0x24, 0x3a);
    FCML_I32_A("vcvtpd2udq xmm1{k4}{z},mmword ptr [esp+00000020h]{1to2}", 0x62, 0xf1, 0xfc, 0x9c, 0x79, 0x4c, 0x24, 0x04);
}

void fcml_tf_instruction_VCVTTPD2UDQ(void) {
    FCML_I64("vcvttpd2udq xmm3,xmm0", 0x62, 0xf1, 0xfc, 0x08, 0x78, 0xd8);
    FCML_I32("vcvttpd2udq xmm3,xmm0", 0x62, 0xf1, 0xfc, 0x08, 0x78, 0xd8);
    FCML_I32("vcvttpd2udq xmm0,ymmword ptr [eax]", 0x62, 0xf1, 0xfc, 0x28, 0x78, 0x00);
    FCML_A64("vcvttpd2udqx %xmm0,%xmm3", 0x62, 0xf1, 0xfc, 0x08, 0x78, 0xd8);
    FCML_A64("vcvttpd2udqx %xmm0,%xmm3", 0x62, 0xf1, 0xfc, 0x08, 0x78, 0xd8);
    FCML_A64("vcvttpd2udqx (%rax),%xmm0", 0x62, 0xf1, 0xfc, 0x08, 0x78, 0x00);
    FCML_I64("vcvttpd2udq xmm10{k1},ymmword ptr [r9+r8]", 0x62, 0x11, 0xfc, 0x29, 0x78, 0x14, 0x01);
    FCML_A64("vcvttpd2udq (%r9,%r8),%ymm10{%k1}", 0x62, 0x11, 0xfc, 0x49, 0x78, 0x14, 0x01);
    FCML_I64("vcvttpd2udq xmm10{k1},xmmword ptr [r9+r8]", 0x62, 0x11, 0xfc, 0x09, 0x78, 0x14, 0x01);
    FCML_A64("vcvttpd2udqx (%r9,%r8),%xmm10{%k1}", 0x62, 0x11, 0xfc, 0x09, 0x78, 0x14, 0x01);
    FCML_I64("vcvttpd2udq ymm1{k1},zmmword ptr [r9+r8]", 0x62, 0x91, 0xfc, 0x49, 0x78, 0x0c, 0x01);
    FCML_A64("vcvttpd2udq (%r9,%r8),%ymm1{%k1}", 0x62, 0x91, 0xfc, 0x49, 0x78, 0x0c, 0x01);
    FCML_I64("vcvttpd2udq xmm10{k1}{z},ymmword ptr [r9+r8]", 0x62, 0x11, 0xfc, 0xa9, 0x78, 0x14, 0x01);
    FCML_A64("vcvttpd2udq (%rsi){1to8},%ymm31", 0x62, 0x61, 0xfc, 0x58, 0x78, 0x3e);
    FCML_A64("vcvttpd2udq (%rsi){1to8},%ymm31", 0x62, 0x61, 0xfc, 0x58, 0x78, 0x3e);
    FCML_I64("vcvttpd2udq ymm31,mmword ptr [rsi]{1to8}", 0x62, 0x61, 0xfc, 0x58, 0x78, 0x3e);
    FCML_I64("vcvttpd2udq xmm31{k7}{z},mmword ptr [rsi]{1to4}", 0x62, 0x61, 0xfc, 0xbf, 0x78, 0x3e);
    FCML_A64("vcvttpd2udqx (%rsi){1to2},%xmm31{%k7}{z}", 0x62, 0x61, 0xfc, 0x9f, 0x78, 0x3e);
    FCML_A64("vcvttpd2udqy (%rsi){1to4},%xmm31{%k7}{z}", 0x62, 0x61, 0xfc, 0xbf, 0x78, 0x3e);
    FCML_I64("vcvttpd2udq ymm31{k7}{z},zmm4,{rn-sae}", 0x62, 0x61, 0xfc, 0x9f, 0x78, 0xfc);
    FCML_I64_A("vcvttpd2udq xmm1{k4}{z},mmword ptr [rsp+0000000000000020h]{1to2}", 0x62, 0xf1, 0xfc, 0x9c, 0x78, 0x4c, 0x24, 0x04);
    FCML_I64_A("vcvttpd2udq xmm1{k4}{z},mmword ptr [rsp+00000000000001d0h]{1to2}", 0x62, 0xf1, 0xfc, 0x9c, 0x78, 0x4c, 0x24, 0x3a);
    FCML_I32_A("vcvttpd2udq xmm1{k4}{z},mmword ptr [esp+00000020h]{1to2}", 0x62, 0xf1, 0xfc, 0x9c, 0x78, 0x4c, 0x24, 0x04);
}

void fcml_tf_instruction_VCVTUQQ2PS(void) {
    FCML_I64("vcvtuqq2ps xmm3,xmm0", 0x62, 0xf1, 0xff, 0x08, 0x7a, 0xd8);
    FCML_I32("vcvtuqq2ps xmm3,xmm0", 0x62, 0xf1, 0xff, 0x08, 0x7a, 0xd8);
    FCML_I32("vcvtuqq2ps xmm0,ymmword ptr [eax]", 0x62, 0xf1, 0xff, 0x28, 0x7a, 0x00);
    FCML_A64("vcvtuqq2psx %xmm0,%xmm3", 0x62, 0xf1, 0xff, 0x08, 0x7a, 0xd8);
    FCML_A64("vcvtuqq2psx %xmm0,%xmm3", 0x62, 0xf1, 0xff, 0x08, 0x7a, 0xd8);
    FCML_A64("vcvtuqq2psx (%rax),%xmm0", 0x62, 0xf1, 0xff, 0x08, 0x7a, 0x00);
    FCML_I64("vcvtuqq2ps xmm10{k1},ymmword ptr [r9+r8]", 0x62, 0x11, 0xff, 0x29, 0x7a, 0x14, 0x01);
    FCML_A64("vcvtuqq2ps (%r9,%r8),%ymm10{%k1}", 0x62, 0x11, 0xff, 0x49, 0x7a, 0x14, 0x01);
    FCML_I64("vcvtuqq2ps xmm10{k1},xmmword ptr [r9+r8]", 0x62, 0x11, 0xff, 0x09, 0x7a, 0x14, 0x01);
    FCML_A64("vcvtuqq2psx (%r9,%r8),%xmm10{%k1}", 0x62, 0x11, 0xff, 0x09, 0x7a, 0x14, 0x01);
    FCML_I64("vcvtuqq2ps ymm1{k1},zmmword ptr [r9+r8]", 0x62, 0x91, 0xff, 0x49, 0x7a, 0x0c, 0x01);
    FCML_A64("vcvtuqq2ps (%r9,%r8),%ymm1{%k1}", 0x62, 0x91, 0xff, 0x49, 0x7a, 0x0c, 0x01);
    FCML_I64("vcvtuqq2ps xmm10{k1}{z},ymmword ptr [r9+r8]", 0x62, 0x11, 0xff, 0xa9, 0x7a, 0x14, 0x01);
    FCML_A64("vcvtuqq2ps (%rsi){1to8},%ymm31", 0x62, 0x61, 0xff, 0x58, 0x7a, 0x3e);
    FCML_A64("vcvtuqq2ps (%rsi){1to8},%ymm31", 0x62, 0x61, 0xff, 0x58, 0x7a, 0x3e);
    FCML_I64("vcvtuqq2ps ymm31,mmword ptr [rsi]{1to8}", 0x62, 0x61, 0xff, 0x58, 0x7a, 0x3e);
    FCML_I64("vcvtuqq2ps xmm31{k7}{z},mmword ptr [rsi]{1to4}", 0x62, 0x61, 0xff, 0xbf, 0x7a, 0x3e);
    FCML_A64("vcvtuqq2psx (%rsi){1to2},%xmm31{%k7}{z}", 0x62, 0x61, 0xff, 0x9f, 0x7a, 0x3e);
    FCML_A64("vcvtuqq2psy (%rsi){1to4},%xmm31{%k7}{z}", 0x62, 0x61, 0xff, 0xbf, 0x7a, 0x3e);
    FCML_I64("vcvtuqq2ps ymm31{k7}{z},zmm4,{rn-sae}", 0x62, 0x61, 0xff, 0x9f, 0x7a, 0xfc);
    FCML_I64("vcvtuqq2ps xmm1{k4}{z},mmword ptr [rsp+0000000000000020h]{1to2}", 0x62, 0xf1, 0xff, 0x9c, 0x7a, 0x4c, 0x24, 0x04);
    FCML_I64("vcvtuqq2ps xmm1{k4}{z},mmword ptr [rsp+00000000000001d0h]{1to2}", 0x62, 0xf1, 0xff, 0x9c, 0x7a, 0x4c, 0x24, 0x3a);
    FCML_I32("vcvtuqq2ps xmm1{k4}{z},mmword ptr [esp+00000020h]{1to2}", 0x62, 0xf1, 0xff, 0x9c, 0x7a, 0x4c, 0x24, 0x04);
}

void fcml_tf_instruction_VCVTUSI2SD(void) {
    FCML_I64_D("vcvtusi2sd xmm1,xmm2,qword ptr [rsp+0000000000000040h]", 0x62, 0xf1, 0xef, 0x08, 0x7b, 0x4c, 0x24, 0x08)
    FCML_I64_D("vcvtusi2sd xmm1,xmm2,dword ptr [rsp+0000000000000040h]", 0x62, 0xf1, 0x6f, 0x08, 0x7b, 0x4c, 0x24, 0x08)
    FCML_I64("vcvtusi2sd xmm3,xmm0,dword ptr [rax]", 0x62, 0xf1, 0x7f, 0x08, 0x7b, 0x18);
    FCML_I32("vcvtusi2sd xmm3,xmm0,dword ptr [eax]", 0x62, 0xf1, 0x7f, 0x08, 0x7b, 0x18);
    FCML_I64_A("vcvtusi2sd xmm3,xmm0,ebx", 0x62, 0xf1, 0x7f, 0x08, 0x7b, 0xdb);
    FCML_I32_A("vcvtusi2sd xmm3,xmm0,ebx", 0x62, 0xf1, 0x7f, 0x08, 0x7b, 0xdb);
    FCML_I64_A("vcvtusi2sd xmm3,xmm0,rdx", 0x62, 0xf1, 0xff, 0x08, 0x7b, 0xda);
    FCML_I64_A_FAILED("vcvtusi2sd xmm3,xmm10,ecx,{rn-sae}", 0x62, 0xf1, 0xAE, 0x18, 0x7b, 0xd9);
    FCML_I64_A("vcvtusi2sd xmm3,xmm10,rcx,{rn-sae}", 0x62, 0xf1, 0xaf, 0x18, 0x7b, 0xd9);
    FCML_A64_D("vcvtusi2sd {rn-sae},%rcx,%xmm10,%xmm3", 0x62, 0xf1, 0xaf, 0x18, 0x7b, 0xd9);
}

void fcml_tf_instruction_VCVTUSI2SS(void) {
    FCML_I64_D("vcvtusi2ss xmm1,xmm2,qword ptr [rsp+0000000000000040h]", 0x62, 0xf1, 0xee, 0x08, 0x7b, 0x4c, 0x24, 0x08)
    FCML_I64_D("vcvtusi2ss xmm1,xmm2,dword ptr [rsp+0000000000000040h]", 0x62, 0xf1, 0x6E, 0x08, 0x7b, 0x4c, 0x24, 0x08)
    FCML_I64("vcvtusi2ss xmm3,xmm0,dword ptr [rax]", 0x62, 0xf1, 0x7E, 0x08, 0x7b, 0x18);
    FCML_I32("vcvtusi2ss xmm3,xmm0,dword ptr [eax]", 0x62, 0xf1, 0x7E, 0x08, 0x7b, 0x18);
    FCML_I64_A("vcvtusi2ss xmm3,xmm0,ebx", 0x62, 0xf1, 0x7E, 0x08, 0x7b, 0xdb);
    FCML_I32_A("vcvtusi2ss xmm3,xmm0,ebx", 0x62, 0xf1, 0x7E, 0x08, 0x7b, 0xdb);
    FCML_I64_A("vcvtusi2ss xmm3,xmm0,rdx", 0x62, 0xf1, 0xfe, 0x08, 0x7b, 0xda);
    FCML_I64("vcvtusi2ss xmm3,xmm10,ecx,{rn-sae}", 0x62, 0xf1, 0x2e, 0x18, 0x7b, 0xd9);
    FCML_I64_A("vcvtusi2ss xmm3,xmm10,rcx,{rn-sae}", 0x62, 0xf1, 0xAE, 0x18, 0x7b, 0xd9);
    FCML_A64_D("vcvtusi2ss {rn-sae},%rcx,%xmm10,%xmm3", 0x62, 0xf1, 0xAE, 0x18, 0x7b, 0xd9);
}

void fcml_tf_instruction_VCVTQQ2PS(void) {
    FCML_I64("vcvtqq2ps xmm3,xmm0", 0x62, 0xf1, 0xfc, 0x08, 0x5b, 0xd8);
    FCML_I32("vcvtqq2ps xmm3,xmm0", 0x62, 0xf1, 0xfc, 0x08, 0x5b, 0xd8);
    FCML_I32("vcvtqq2ps xmm0,ymmword ptr [eax]", 0x62, 0xf1, 0xfc, 0x28, 0x5b, 0x00);
    FCML_A64("vcvtqq2psx %xmm0,%xmm3", 0x62, 0xf1, 0xfc, 0x08, 0x5b, 0xd8);
    FCML_A64("vcvtqq2psx %xmm0,%xmm3", 0x62, 0xf1, 0xfc, 0x08, 0x5b, 0xd8);
    FCML_A64("vcvtqq2psx (%rax),%xmm0", 0x62, 0xf1, 0xfc, 0x08, 0x5b, 0x00);
    FCML_I64("vcvtqq2ps xmm10{k1},ymmword ptr [r9+r8]", 0x62, 0x11, 0xfc, 0x29, 0x5b, 0x14, 0x01);
    FCML_A64("vcvtqq2ps (%r9,%r8),%ymm10{%k1}", 0x62, 0x11, 0xfc, 0x49, 0x5b, 0x14, 0x01);
    FCML_I64("vcvtqq2ps xmm10{k1},xmmword ptr [r9+r8]", 0x62, 0x11, 0xfc, 0x09, 0x5b, 0x14, 0x01);
    FCML_A64("vcvtqq2psx (%r9,%r8),%xmm10{%k1}", 0x62, 0x11, 0xfc, 0x09, 0x5b, 0x14, 0x01);
    FCML_I64("vcvtqq2ps ymm1{k1},zmmword ptr [r9+r8]", 0x62, 0x91, 0xfc, 0x49, 0x5b, 0x0c, 0x01);
    FCML_A64("vcvtqq2ps (%r9,%r8),%ymm1{%k1}", 0x62, 0x91, 0xfc, 0x49, 0x5b, 0x0c, 0x01);
    FCML_I64("vcvtqq2ps xmm10{k1}{z},ymmword ptr [r9+r8]", 0x62, 0x11, 0xfc, 0xa9, 0x5b, 0x14, 0x01);
    FCML_A64("vcvtqq2ps (%rsi){1to8},%ymm31", 0x62, 0x61, 0xfc, 0x58, 0x5b, 0x3e);
    FCML_A64("vcvtqq2ps (%rsi){1to8},%ymm31", 0x62, 0x61, 0xfc, 0x58, 0x5b, 0x3e);
    FCML_I64("vcvtqq2ps ymm31,mmword ptr [rsi]{1to8}", 0x62, 0x61, 0xfc, 0x58, 0x5b, 0x3e);
    FCML_I64("vcvtqq2ps xmm31{k7}{z},mmword ptr [rsi]{1to4}", 0x62, 0x61, 0xfc, 0xbf, 0x5b, 0x3e);
    FCML_A64("vcvtqq2psx (%rsi){1to2},%xmm31{%k7}{z}", 0x62, 0x61, 0xfc, 0x9f, 0x5b, 0x3e);
    FCML_A64("vcvtqq2psy (%rsi){1to4},%xmm31{%k7}{z}", 0x62, 0x61, 0xfc, 0xbf, 0x5b, 0x3e);
    FCML_I64("vcvtqq2ps ymm31{k7}{z},zmm4,{rn-sae}", 0x62, 0x61, 0xfc, 0x9f, 0x5b, 0xfc);
    FCML_I64("vcvtqq2ps xmm1{k4}{z},mmword ptr [rsp+0000000000000020h]{1to2}", 0x62, 0xf1, 0xfc, 0x9c, 0x5b, 0x4c, 0x24, 0x04);
    FCML_I64("vcvtqq2ps xmm1{k4}{z},mmword ptr [rsp+00000000000001d0h]{1to2}", 0x62, 0xf1, 0xfc, 0x9c, 0x5b, 0x4c, 0x24, 0x3a);
    FCML_I32("vcvtqq2ps xmm1{k4}{z},mmword ptr [esp+00000020h]{1to2}", 0x62, 0xf1, 0xfc, 0x9c, 0x5b, 0x4c, 0x24, 0x04);
}

void fcml_tf_instruction_VCVTSD2USI(void) {
    FCML_I64("vcvtsd2usi eax,xmm0", 0x62, 0xf1, 0x7f, 0x08, 0x79, 0xc0);
    FCML_I64("vcvtsd2usi eax,mmword ptr [rdx]", 0x62, 0xf1, 0x7f, 0x08, 0x79, 0x02);
    FCML_I64("vcvtsd2usi rax,xmm0", 0x62, 0xf1, 0xff, 0x08, 0x79, 0xc0);
    FCML_I64("vcvtsd2usi rax,mmword ptr [rdx]", 0x62, 0xf1, 0xff, 0x08, 0x79, 0x02);
    FCML_I64("vcvtsd2usi eax,xmm0,{rn-sae}", 0x62, 0xf1, 0x7f, 0x18, 0x79, 0xc0);
    FCML_I64("vcvtsd2usi eax,mmword ptr [rsp+0000000000000020h]", 0x62, 0xf1, 0x7f, 0x08, 0x79, 0x44, 0x24, 0x04);
    FCML_I32("vcvtsd2usi eax,mmword ptr [edx]", 0x62, 0xf1, 0x7f, 0x08, 0x79, 0x02);
    FCML_I32("vcvtsd2usi rax,mmword ptr [edx]", 0x62, 0xf1, 0xff, 0x08, 0x79, 0x02);
    FCML_A32("vcvtsd2usi (%edx),%eax", 0x62, 0xf1, 0x7f, 0x08, 0x79, 0x02);
    FCML_A32("vcvtsd2usi (%edx),%rax", 0x62, 0xf1, 0xff, 0x08, 0x79, 0x02);
}

void fcml_tf_instruction_VCVTSS2USI(void) {
    FCML_I64("vcvtss2usi eax,xmm0", 0x62, 0xf1, 0x7e, 0x08, 0x79, 0xc0);
    FCML_I64("vcvtss2usi eax,dword ptr [rdx]", 0x62, 0xf1, 0x7e, 0x08, 0x79, 0x02);
    FCML_I64("vcvtss2usi rax,xmm0", 0x62, 0xf1, 0xfe, 0x08, 0x79, 0xc0);
    FCML_I64("vcvtss2usi rax,dword ptr [rdx]", 0x62, 0xf1, 0xfe, 0x08, 0x79, 0x02);
    FCML_I64("vcvtss2usi eax,xmm0,{rn-sae}", 0x62, 0xf1, 0x7e, 0x18, 0x79, 0xc0);
    FCML_I64("vcvtss2usi eax,dword ptr [rsp+0000000000000010h]", 0x62, 0xf1, 0x7e, 0x08, 0x79, 0x44, 0x24, 0x04);
    FCML_I32("vcvtss2usi eax,dword ptr [edx]", 0x62, 0xf1, 0x7e, 0x08, 0x79, 0x02);
    FCML_I32("vcvtss2usi rax,dword ptr [edx]", 0x62, 0xf1, 0xfe, 0x08, 0x79, 0x02);
    FCML_A32("vcvtss2usi (%edx),%eax", 0x62, 0xf1, 0x7e, 0x08, 0x79, 0x02);
    FCML_A32("vcvtss2usi (%edx),%rax", 0x62, 0xf1, 0xfe, 0x08, 0x79, 0x02);
}

void fcml_tf_instruction_VCVTTSD2USI(void) {
    FCML_I64("vcvttsd2usi eax,xmm0", 0x62, 0xf1, 0x7f, 0x08, 0x78, 0xc0);
    FCML_I64("vcvttsd2usi eax,mmword ptr [rdx]", 0x62, 0xf1, 0x7f, 0x08, 0x78, 0x02);
    FCML_I64("vcvttsd2usi rax,xmm0", 0x62, 0xf1, 0xff, 0x08, 0x78, 0xc0);
    FCML_I64("vcvttsd2usi rax,mmword ptr [rdx]", 0x62, 0xf1, 0xff, 0x08, 0x78, 0x02);
    FCML_I64("vcvttsd2usi eax,xmm0,{sae}", 0x62, 0xf1, 0x7f, 0x18, 0x78, 0xc0);
    FCML_I64("vcvttsd2usi eax,mmword ptr [rsp+0000000000000020h]", 0x62, 0xf1, 0x7f, 0x08, 0x78, 0x44, 0x24, 0x04);
    FCML_I32("vcvttsd2usi eax,mmword ptr [edx]", 0x62, 0xf1, 0x7f, 0x08, 0x78, 0x02);
    FCML_I32("vcvttsd2usi rax,mmword ptr [edx]", 0x62, 0xf1, 0xff, 0x08, 0x78, 0x02);
    FCML_A32("vcvttsd2usi (%edx),%eax", 0x62, 0xf1, 0x7f, 0x08, 0x78, 0x02);
    FCML_A32("vcvttsd2usi (%edx),%rax", 0x62, 0xf1, 0xff, 0x08, 0x78, 0x02);
}

void fcml_tf_instruction_VCVTTSS2USI(void) {
    FCML_I64("vcvttss2usi eax,xmm0", 0x62, 0xf1, 0x7e, 0x08, 0x78, 0xc0);
    FCML_I64("vcvttss2usi eax,dword ptr [rdx]", 0x62, 0xf1, 0x7e, 0x08, 0x78, 0x02);
    FCML_I64("vcvttss2usi rax,xmm0", 0x62, 0xf1, 0xfe, 0x08, 0x78, 0xc0);
    FCML_I64("vcvttss2usi rax,dword ptr [rdx]", 0x62, 0xf1, 0xfe, 0x08, 0x78, 0x02);
    FCML_I64("vcvttss2usi eax,xmm0,{sae}", 0x62, 0xf1, 0x7e, 0x18, 0x78, 0xc0);
    FCML_I64("vcvttss2usi eax,dword ptr [rsp+0000000000000010h]", 0x62, 0xf1, 0x7e, 0x08, 0x78, 0x44, 0x24, 0x04);
    FCML_I32("vcvttss2usi eax,dword ptr [edx]", 0x62, 0xf1, 0x7e, 0x08, 0x78, 0x02);
    FCML_I32("vcvttss2usi rax,dword ptr [edx]", 0x62, 0xf1, 0xfe, 0x08, 0x78, 0x02);
    FCML_A32("vcvttss2usi (%edx),%eax", 0x62, 0xf1, 0x7e, 0x08, 0x78, 0x02);
    FCML_A32("vcvttss2usi (%edx),%rax", 0x62, 0xf1, 0xfe, 0x08, 0x78, 0x02);
}

void fcml_tf_instruction_VCVTTPD2QQ(void) {
    FCML_I32("vcvttpd2qq xmm0,xmmword ptr [eax]", 0x62, 0xf1, 0xfd, 0x08, 0x7a, 0x00);
    FCML_I32("vcvttpd2qq xmm0,xmm0", 0x62, 0xf1, 0xfd, 0x08, 0x7a, 0xc0);

    FCML_I32("vcvttpd2qq ymm0,ymmword ptr [eax]", 0x62, 0xf1, 0xfd, 0x28, 0x7a, 0x00);
    FCML_I64("vcvttpd2qq ymm0,ymm0", 0x62, 0xf1, 0xfd, 0x28, 0x7a, 0xc0);

    FCML_A64("vcvttpd2qq (%rax),%xmm0", 0x62, 0xf1, 0xfd, 0x08, 0x7a, 0x00);
    FCML_A64("vcvttpd2qq %xmm0,%xmm0", 0x62, 0xf1, 0xfd, 0x08, 0x7a, 0xc0);
    FCML_A64("vcvttpd2qq (%rax),%ymm0", 0x62, 0xf1, 0xfd, 0x28, 0x7a, 0x00);
    FCML_A64("vcvttpd2qq %ymm0,%ymm0", 0x62, 0xf1, 0xfd, 0x28, 0x7a, 0xc0);

    FCML_I64("vcvttpd2qq xmm3,xmm0", 0x62, 0xf1, 0xfd, 0x08, 0x7a, 0xd8);
    FCML_I32("vcvttpd2qq xmm3,xmm0", 0x62, 0xf1, 0xfd, 0x08, 0x7a, 0xd8);
    FCML_A64("vcvttpd2qq %xmm0,%xmm3", 0x62, 0xf1, 0xfd, 0x08, 0x7a, 0xd8);
    FCML_A64("vcvttpd2qq %xmm0,%xmm3", 0x62, 0xf1, 0xfd, 0x08, 0x7a, 0xd8);
    FCML_A64("vcvttpd2qq (%rax),%xmm0", 0x62, 0xf1, 0xfd, 0x08, 0x7a, 0x00);

    FCML_I64("vcvttpd2qq xmm10{k1},xmmword ptr [r9+r8]", 0x62, 0x11, 0xfd, 0x09, 0x7a, 0x14, 0x01);
    FCML_A64("vcvttpd2qq (%r9,%r8),%xmm10{%k1}", 0x62, 0x11, 0xfd, 0x09, 0x7a, 0x14, 0x01);
    FCML_I64("vcvttpd2qq ymm10{k1},ymmword ptr [r9+r8]", 0x62, 0x11, 0xfd, 0x29, 0x7a, 0x14, 0x01);
    FCML_A64("vcvttpd2qq (%r9,%r8),%ymm10{%k1}", 0x62, 0x11, 0xfd, 0x29, 0x7a, 0x14, 0x01);
    FCML_I64("vcvttpd2qq zmm1{k1},zmmword ptr [r9+r8]", 0x62, 0x91, 0xfd, 0x49, 0x7a, 0x0c, 0x01);
    FCML_A64("vcvttpd2qq (%r9,%r8),%zmm1{%k1}", 0x62, 0x91, 0xfd, 0x49, 0x7a, 0x0c, 0x01);

    FCML_I64("vcvttpd2qq zmm31{k7}{z},zmm4,{sae}", 0x62, 0x61, 0xfd, 0x9f, 0x7a, 0xfc);

    FCML_I64("vcvttpd2qq xmm1{k4}{z},xmmword ptr [rsp+0000000000000040h]", 0x62, 0xf1, 0xfd, 0x8c, 0x7a, 0x4c, 0x24, 0x04);
    FCML_I64("vcvttpd2qq xmm1{k4}{z},mmword ptr [rsp+0000000000000040h]{1to2}", 0x62, 0xf1, 0xfd, 0x9c, 0x7a, 0x4c, 0x24, 0x08);
}

void fcml_tf_instruction_VCVTUQQ2PD(void) {
    FCML_I32("vcvtuqq2pd xmm0,xmmword ptr [eax]", 0x62, 0xf1, 0xfe, 0x08, 0x7a, 0x00);
    FCML_I32("vcvtuqq2pd xmm0,xmm0", 0x62, 0xf1, 0xfe, 0x08, 0x7a, 0xc0);

    FCML_I32("vcvtuqq2pd ymm0,ymmword ptr [eax]", 0x62, 0xf1, 0xfe, 0x28, 0x7a, 0x00);
    FCML_I64("vcvtuqq2pd ymm0,ymm0", 0x62, 0xf1, 0xfe, 0x28, 0x7a, 0xc0);

    FCML_A64("vcvtuqq2pd (%rax),%xmm0", 0x62, 0xf1, 0xfe, 0x08, 0x7a, 0x00);
    FCML_A64("vcvtuqq2pd %xmm0,%xmm0", 0x62, 0xf1, 0xfe, 0x08, 0x7a, 0xc0);
    FCML_A64("vcvtuqq2pd (%rax),%ymm0", 0x62, 0xf1, 0xfe, 0x28, 0x7a, 0x00);
    FCML_A64("vcvtuqq2pd %ymm0,%ymm0", 0x62, 0xf1, 0xfe, 0x28, 0x7a, 0xc0);

    FCML_I64("vcvtuqq2pd xmm3,xmm0", 0x62, 0xf1, 0xfe, 0x08, 0x7a, 0xd8);
    FCML_I32("vcvtuqq2pd xmm3,xmm0", 0x62, 0xf1, 0xfe, 0x08, 0x7a, 0xd8);
    FCML_A64("vcvtuqq2pd %xmm0,%xmm3", 0x62, 0xf1, 0xfe, 0x08, 0x7a, 0xd8);
    FCML_A64("vcvtuqq2pd %xmm0,%xmm3", 0x62, 0xf1, 0xfe, 0x08, 0x7a, 0xd8);
    FCML_A64("vcvtuqq2pd (%rax),%xmm0", 0x62, 0xf1, 0xfe, 0x08, 0x7a, 0x00);

    FCML_I64("vcvtuqq2pd xmm10{k1},xmmword ptr [r9+r8]", 0x62, 0x11, 0xfe, 0x09, 0x7a, 0x14, 0x01);
    FCML_A64("vcvtuqq2pd (%r9,%r8),%xmm10{%k1}", 0x62, 0x11, 0xfe, 0x09, 0x7a, 0x14, 0x01);
    FCML_I64("vcvtuqq2pd ymm10{k1},ymmword ptr [r9+r8]", 0x62, 0x11, 0xfe, 0x29, 0x7a, 0x14, 0x01);
    FCML_A64("vcvtuqq2pd (%r9,%r8),%ymm10{%k1}", 0x62, 0x11, 0xfe, 0x29, 0x7a, 0x14, 0x01);
    FCML_I64("vcvtuqq2pd zmm1{k1},zmmword ptr [r9+r8]", 0x62, 0x91, 0xfe, 0x49, 0x7a, 0x0c, 0x01);
    FCML_A64("vcvtuqq2pd (%r9,%r8),%zmm1{%k1}", 0x62, 0x91, 0xfe, 0x49, 0x7a, 0x0c, 0x01);

    FCML_I64("vcvtuqq2pd zmm31{k7}{z},zmm4,{rn-sae}", 0x62, 0x61, 0xfe, 0x9f, 0x7a, 0xfc);

    FCML_I64("vcvtuqq2pd xmm1{k4}{z},xmmword ptr [rsp+0000000000000040h]", 0x62, 0xf1, 0xfe, 0x8c, 0x7a, 0x4c, 0x24, 0x04);
    FCML_I64("vcvtuqq2pd xmm1{k4}{z},mmword ptr [rsp+0000000000000040h]{1to2}", 0x62, 0xf1, 0xfe, 0x9c, 0x7a, 0x4c, 0x24, 0x08);
}

void fcml_tf_instruction_VCVTTPD2UQQ(void) {
    FCML_I32("vcvttpd2uqq xmm0,xmmword ptr [eax]", 0x62, 0xf1, 0xfd, 0x08, 0x78, 0x00);
    FCML_I32("vcvttpd2uqq xmm0,xmm0", 0x62, 0xf1, 0xfd, 0x08, 0x78, 0xc0);

    FCML_I32("vcvttpd2uqq ymm0,ymmword ptr [eax]", 0x62, 0xf1, 0xfd, 0x28, 0x78, 0x00);
    FCML_I64("vcvttpd2uqq ymm0,ymm0", 0x62, 0xf1, 0xfd, 0x28, 0x78, 0xc0);

    FCML_A64("vcvttpd2uqq (%rax),%xmm0", 0x62, 0xf1, 0xfd, 0x08, 0x78, 0x00);
    FCML_A64("vcvttpd2uqq %xmm0,%xmm0", 0x62, 0xf1, 0xfd, 0x08, 0x78, 0xc0);
    FCML_A64("vcvttpd2uqq (%rax),%ymm0", 0x62, 0xf1, 0xfd, 0x28, 0x78, 0x00);
    FCML_A64("vcvttpd2uqq %ymm0,%ymm0", 0x62, 0xf1, 0xfd, 0x28, 0x78, 0xc0);

    FCML_I64("vcvttpd2uqq xmm3,xmm0", 0x62, 0xf1, 0xfd, 0x08, 0x78, 0xd8);
    FCML_I32("vcvttpd2uqq xmm3,xmm0", 0x62, 0xf1, 0xfd, 0x08, 0x78, 0xd8);
    FCML_A64("vcvttpd2uqq %xmm0,%xmm3", 0x62, 0xf1, 0xfd, 0x08, 0x78, 0xd8);
    FCML_A64("vcvttpd2uqq %xmm0,%xmm3", 0x62, 0xf1, 0xfd, 0x08, 0x78, 0xd8);
    FCML_A64("vcvttpd2uqq (%rax),%xmm0", 0x62, 0xf1, 0xfd, 0x08, 0x78, 0x00);

    FCML_I64("vcvttpd2uqq xmm10{k1},xmmword ptr [r9+r8]", 0x62, 0x11, 0xfd, 0x09, 0x78, 0x14, 0x01);
    FCML_A64("vcvttpd2uqq (%r9,%r8),%xmm10{%k1}", 0x62, 0x11, 0xfd, 0x09, 0x78, 0x14, 0x01);
    FCML_I64("vcvttpd2uqq ymm10{k1},ymmword ptr [r9+r8]", 0x62, 0x11, 0xfd, 0x29, 0x78, 0x14, 0x01);
    FCML_A64("vcvttpd2uqq (%r9,%r8),%ymm10{%k1}", 0x62, 0x11, 0xfd, 0x29, 0x78, 0x14, 0x01);
    FCML_I64("vcvttpd2uqq zmm1{k1},zmmword ptr [r9+r8]", 0x62, 0x91, 0xfd, 0x49, 0x78, 0x0c, 0x01);
    FCML_A64("vcvttpd2uqq (%r9,%r8),%zmm1{%k1}", 0x62, 0x91, 0xfd, 0x49, 0x78, 0x0c, 0x01);

    FCML_I64("vcvttpd2uqq zmm31{k7}{z},zmm4,{sae}", 0x62, 0x61, 0xfd, 0x9f, 0x78, 0xfc);

    FCML_I64("vcvttpd2uqq xmm1{k4}{z},xmmword ptr [rsp+0000000000000040h]", 0x62, 0xf1, 0xfd, 0x8c, 0x78, 0x4c, 0x24, 0x04);
    FCML_I64("vcvttpd2uqq xmm1{k4}{z},mmword ptr [rsp+0000000000000040h]{1to2}", 0x62, 0xf1, 0xfd, 0x9c, 0x78, 0x4c, 0x24, 0x08);
}

void fcml_tf_instruction_VCVTTPS2UDQ(void) {
    FCML_I32("vcvttps2udq xmm0,xmmword ptr [eax]", 0x62, 0xf1, 0x7c, 0x08, 0x78, 0x00);
    FCML_I32("vcvttps2udq xmm0,xmm0", 0x62, 0xf1, 0x7c, 0x08, 0x78, 0xc0);

    FCML_I32("vcvttps2udq ymm0,ymmword ptr [eax]", 0x62, 0xf1, 0x7c, 0x28, 0x78, 0x00);
    FCML_I64("vcvttps2udq ymm0,ymm0", 0x62, 0xf1, 0x7c, 0x28, 0x78, 0xc0);

    FCML_A64("vcvttps2udq (%rax),%xmm0", 0x62, 0xf1, 0x7c, 0x08, 0x78, 0x00);
    FCML_A64("vcvttps2udq %xmm0,%xmm0", 0x62, 0xf1, 0x7c, 0x08, 0x78, 0xc0);
    FCML_A64("vcvttps2udq (%rax),%ymm0", 0x62, 0xf1, 0x7c, 0x28, 0x78, 0x00);
    FCML_A64("vcvttps2udq %ymm0,%ymm0", 0x62, 0xf1, 0x7c, 0x28, 0x78, 0xc0);

    FCML_I64("vcvttps2udq xmm3,xmm0", 0x62, 0xf1, 0x7c, 0x08, 0x78, 0xd8);
    FCML_I32("vcvttps2udq xmm3,xmm0", 0x62, 0xf1, 0x7c, 0x08, 0x78, 0xd8);
    FCML_A64("vcvttps2udq %xmm0,%xmm3", 0x62, 0xf1, 0x7c, 0x08, 0x78, 0xd8);
    FCML_A64("vcvttps2udq %xmm0,%xmm3", 0x62, 0xf1, 0x7c, 0x08, 0x78, 0xd8);
    FCML_A64("vcvttps2udq (%rax),%xmm0", 0x62, 0xf1, 0x7c, 0x08, 0x78, 0x00);

    FCML_I64("vcvttps2udq xmm10{k1},xmmword ptr [r9+r8]", 0x62, 0x11, 0x7c, 0x09, 0x78, 0x14, 0x01);
    FCML_A64("vcvttps2udq (%r9,%r8),%xmm10{%k1}", 0x62, 0x11, 0x7c, 0x09, 0x78, 0x14, 0x01);
    FCML_I64("vcvttps2udq ymm10{k1},ymmword ptr [r9+r8]", 0x62, 0x11, 0x7c, 0x29, 0x78, 0x14, 0x01);
    FCML_A64("vcvttps2udq (%r9,%r8),%ymm10{%k1}", 0x62, 0x11, 0x7c, 0x29, 0x78, 0x14, 0x01);
    FCML_I64("vcvttps2udq zmm1{k1},zmmword ptr [r9+r8]", 0x62, 0x91, 0x7c, 0x49, 0x78, 0x0c, 0x01);
    FCML_A64("vcvttps2udq (%r9,%r8),%zmm1{%k1}", 0x62, 0x91, 0x7c, 0x49, 0x78, 0x0c, 0x01);

    FCML_I64("vcvttps2udq zmm31{k7}{z},zmm4,{sae}", 0x62, 0x61, 0x7c, 0x9f, 0x78, 0xfc);

    FCML_I64("vcvttps2udq xmm1{k4}{z},xmmword ptr [rsp+0000000000000040h]", 0x62, 0xf1, 0x7c, 0x8c, 0x78, 0x4c, 0x24, 0x04);
    FCML_I64("vcvttps2udq xmm1{k4}{z},dword ptr [rsp+0000000000000020h]{1to4}", 0x62, 0xf1, 0x7c, 0x9c, 0x78, 0x4c, 0x24, 0x08);
}

void fcml_tf_instruction_VCVTUDQ2PS(void) {
    FCML_I32("vcvtudq2ps xmm0,xmmword ptr [eax]", 0x62, 0xf1, 0x7f, 0x08, 0x7a, 0x00);
    FCML_I32("vcvtudq2ps xmm0,xmm0", 0x62, 0xf1, 0x7f, 0x08, 0x7a, 0xc0);

    FCML_I32("vcvtudq2ps ymm0,ymmword ptr [eax]", 0x62, 0xf1, 0x7f, 0x28, 0x7a, 0x00);
    FCML_I64("vcvtudq2ps ymm0,ymm0", 0x62, 0xf1, 0x7f, 0x28, 0x7a, 0xc0);

    FCML_A64("vcvtudq2ps (%rax),%xmm0", 0x62, 0xf1, 0x7f, 0x08, 0x7a, 0x00);
    FCML_A64("vcvtudq2ps %xmm0,%xmm0", 0x62, 0xf1, 0x7f, 0x08, 0x7a, 0xc0);
    FCML_A64("vcvtudq2ps (%rax),%ymm0", 0x62, 0xf1, 0x7f, 0x28, 0x7a, 0x00);
    FCML_A64("vcvtudq2ps %ymm0,%ymm0", 0x62, 0xf1, 0x7f, 0x28, 0x7a, 0xc0);

    FCML_I64("vcvtudq2ps xmm3,xmm0", 0x62, 0xf1, 0x7f, 0x08, 0x7a, 0xd8);
    FCML_I32("vcvtudq2ps xmm3,xmm0", 0x62, 0xf1, 0x7f, 0x08, 0x7a, 0xd8);
    FCML_A64("vcvtudq2ps %xmm0,%xmm3", 0x62, 0xf1, 0x7f, 0x08, 0x7a, 0xd8);
    FCML_A64("vcvtudq2ps %xmm0,%xmm3", 0x62, 0xf1, 0x7f, 0x08, 0x7a, 0xd8);
    FCML_A64("vcvtudq2ps (%rax),%xmm0", 0x62, 0xf1, 0x7f, 0x08, 0x7a, 0x00);

    FCML_I64("vcvtudq2ps xmm10{k1},xmmword ptr [r9+r8]", 0x62, 0x11, 0x7f, 0x09, 0x7a, 0x14, 0x01);
    FCML_A64("vcvtudq2ps (%r9,%r8),%xmm10{%k1}", 0x62, 0x11, 0x7f, 0x09, 0x7a, 0x14, 0x01);
    FCML_I64("vcvtudq2ps ymm10{k1},ymmword ptr [r9+r8]", 0x62, 0x11, 0x7f, 0x29, 0x7a, 0x14, 0x01);
    FCML_A64("vcvtudq2ps (%r9,%r8),%ymm10{%k1}", 0x62, 0x11, 0x7f, 0x29, 0x7a, 0x14, 0x01);
    FCML_I64("vcvtudq2ps zmm1{k1},zmmword ptr [r9+r8]", 0x62, 0x91, 0x7f, 0x49, 0x7a, 0x0c, 0x01);
    FCML_A64("vcvtudq2ps (%r9,%r8),%zmm1{%k1}", 0x62, 0x91, 0x7f, 0x49, 0x7a, 0x0c, 0x01);

    FCML_I64("vcvtudq2ps zmm31{k7}{z},zmm4,{rn-sae}", 0x62, 0x61, 0x7f, 0x9f, 0x7a, 0xfc);

    FCML_I64("vcvtudq2ps xmm1{k4}{z},xmmword ptr [rsp+0000000000000040h]", 0x62, 0xf1, 0x7f, 0x8c, 0x7a, 0x4c, 0x24, 0x04);
    FCML_I64("vcvtudq2ps xmm1{k4}{z},dword ptr [rsp+0000000000000020h]{1to4}", 0x62, 0xf1, 0x7f, 0x9c, 0x7a, 0x4c, 0x24, 0x08);
}

void fcml_tf_instruction_VCVTTPS2QQ(void) {
    FCML_I32("vcvttps2qq xmm0,mmword ptr [eax]", 0x62, 0xf1, 0x7d, 0x08, 0x7a, 0x00);
    FCML_I32("vcvttps2qq xmm0,xmm0", 0x62, 0xf1, 0x7d, 0x08, 0x7a, 0xc0);

    FCML_I32("vcvttps2qq ymm0,xmmword ptr [eax]", 0x62, 0xf1, 0x7d, 0x28, 0x7a, 0x00);
    FCML_I64("vcvttps2qq ymm0,xmm0", 0x62, 0xf1, 0x7d, 0x28, 0x7a, 0xc0);

    FCML_A64("vcvttps2qq (%rax),%xmm0", 0x62, 0xf1, 0x7d, 0x08, 0x7a, 0x00);
    FCML_A64("vcvttps2qq %xmm0,%xmm0", 0x62, 0xf1, 0x7d, 0x08, 0x7a, 0xc0);
    FCML_A64("vcvttps2qq (%rax),%ymm0", 0x62, 0xf1, 0x7d, 0x28, 0x7a, 0x00);
    FCML_A64("vcvttps2qq %xmm0,%ymm0", 0x62, 0xf1, 0x7d, 0x28, 0x7a, 0xc0);

    FCML_I64("vcvttps2qq xmm3,xmm0", 0x62, 0xf1, 0x7d, 0x08, 0x7a, 0xd8);
    FCML_I32("vcvttps2qq xmm3,xmm0", 0x62, 0xf1, 0x7d, 0x08, 0x7a, 0xd8);
    FCML_A64("vcvttps2qq %xmm0,%xmm3", 0x62, 0xf1, 0x7d, 0x08, 0x7a, 0xd8);
    FCML_A64("vcvttps2qq %xmm0,%xmm3", 0x62, 0xf1, 0x7d, 0x08, 0x7a, 0xd8);
    FCML_A64("vcvttps2qq (%rax),%xmm0", 0x62, 0xf1, 0x7d, 0x08, 0x7a, 0x00);

    FCML_I64("vcvttps2qq xmm10{k1},mmword ptr [r9+r8]", 0x62, 0x11, 0x7d, 0x09, 0x7a, 0x14, 0x01);
    FCML_A64("vcvttps2qq (%r9,%r8),%xmm10{%k1}", 0x62, 0x11, 0x7d, 0x09, 0x7a, 0x14, 0x01);
    FCML_I64("vcvttps2qq ymm10{k1},xmmword ptr [r9+r8]", 0x62, 0x11, 0x7d, 0x29, 0x7a, 0x14, 0x01);
    FCML_A64("vcvttps2qq (%r9,%r8),%ymm10{%k1}", 0x62, 0x11, 0x7d, 0x29, 0x7a, 0x14, 0x01);
    FCML_I64("vcvttps2qq zmm1{k1},ymmword ptr [r9+r8]", 0x62, 0x91, 0x7d, 0x49, 0x7a, 0x0c, 0x01);
    FCML_A64("vcvttps2qq (%r9,%r8),%zmm1{%k1}", 0x62, 0x91, 0x7d, 0x49, 0x7a, 0x0c, 0x01);

    FCML_I64("vcvttps2qq zmm31{k7}{z},ymm4,{sae}", 0x62, 0x61, 0x7d, 0x9f, 0x7a, 0xfc);

    FCML_I64("vcvttps2qq xmm1{k4}{z},mmword ptr [rsp+0000000000000020h]", 0x62, 0xf1, 0x7d, 0x8c, 0x7a, 0x4c, 0x24, 0x04);
    FCML_I64("vcvttps2qq xmm1{k4}{z},dword ptr [rsp+0000000000000020h]{1to2}", 0x62, 0xf1, 0x7d, 0x9c, 0x7a, 0x4c, 0x24, 0x08);
}

void fcml_tf_instruction_VCVTTPS2UQQ(void) {
    FCML_I32("vcvttps2uqq xmm0,mmword ptr [eax]", 0x62, 0xf1, 0x7d, 0x08, 0x78, 0x00);
    FCML_I32("vcvttps2uqq xmm0,xmm0", 0x62, 0xf1, 0x7d, 0x08, 0x78, 0xc0);

    FCML_I32("vcvttps2uqq ymm0,xmmword ptr [eax]", 0x62, 0xf1, 0x7d, 0x28, 0x78, 0x00);
    FCML_I64("vcvttps2uqq ymm0,xmm0", 0x62, 0xf1, 0x7d, 0x28, 0x78, 0xc0);

    FCML_A64("vcvttps2uqq (%rax),%xmm0", 0x62, 0xf1, 0x7d, 0x08, 0x78, 0x00);
    FCML_A64("vcvttps2uqq %xmm0,%xmm0", 0x62, 0xf1, 0x7d, 0x08, 0x78, 0xc0);
    FCML_A64("vcvttps2uqq (%rax),%ymm0", 0x62, 0xf1, 0x7d, 0x28, 0x78, 0x00);
    FCML_A64("vcvttps2uqq %xmm0,%ymm0", 0x62, 0xf1, 0x7d, 0x28, 0x78, 0xc0);

    FCML_I64("vcvttps2uqq xmm3,xmm0", 0x62, 0xf1, 0x7d, 0x08, 0x78, 0xd8);
    FCML_I32("vcvttps2uqq xmm3,xmm0", 0x62, 0xf1, 0x7d, 0x08, 0x78, 0xd8);
    FCML_A64("vcvttps2uqq %xmm0,%xmm3", 0x62, 0xf1, 0x7d, 0x08, 0x78, 0xd8);
    FCML_A64("vcvttps2uqq %xmm0,%xmm3", 0x62, 0xf1, 0x7d, 0x08, 0x78, 0xd8);
    FCML_A64("vcvttps2uqq (%rax),%xmm0", 0x62, 0xf1, 0x7d, 0x08, 0x78, 0x00);

    FCML_I64("vcvttps2uqq xmm10{k1},mmword ptr [r9+r8]", 0x62, 0x11, 0x7d, 0x09, 0x78, 0x14, 0x01);
    FCML_A64("vcvttps2uqq (%r9,%r8),%xmm10{%k1}", 0x62, 0x11, 0x7d, 0x09, 0x78, 0x14, 0x01);
    FCML_I64("vcvttps2uqq ymm10{k1},xmmword ptr [r9+r8]", 0x62, 0x11, 0x7d, 0x29, 0x78, 0x14, 0x01);
    FCML_A64("vcvttps2uqq (%r9,%r8),%ymm10{%k1}", 0x62, 0x11, 0x7d, 0x29, 0x78, 0x14, 0x01);
    FCML_I64("vcvttps2uqq zmm1{k1},ymmword ptr [r9+r8]", 0x62, 0x91, 0x7d, 0x49, 0x78, 0x0c, 0x01);
    FCML_A64("vcvttps2uqq (%r9,%r8),%zmm1{%k1}", 0x62, 0x91, 0x7d, 0x49, 0x78, 0x0c, 0x01);

    FCML_I64_A("vcvttps2uqq zmm31{k7}{z},ymm4,{sae}", 0x62, 0x61, 0x7d, 0x9f, 0x78, 0xfc);

    FCML_I64("vcvttps2uqq xmm1{k4}{z},mmword ptr [rsp+0000000000000020h]", 0x62, 0xf1, 0x7d, 0x8c, 0x78, 0x4c, 0x24, 0x04);
    FCML_I64("vcvttps2uqq xmm1{k4}{z},dword ptr [rsp+0000000000000020h]{1to2}", 0x62, 0xf1, 0x7d, 0x9c, 0x78, 0x4c, 0x24, 0x08);
}

void fcml_tf_instruction_VCVTUDQ2PD(void) {
    FCML_I32("vcvtudq2pd xmm0,mmword ptr [eax]", 0x62, 0xf1, 0x7e, 0x08, 0x7a, 0x00);
    FCML_I32("vcvtudq2pd xmm0,xmm0", 0x62, 0xf1, 0x7e, 0x08, 0x7a, 0xc0);

    FCML_I32("vcvtudq2pd ymm0,xmmword ptr [eax]", 0x62, 0xf1, 0x7e, 0x28, 0x7a, 0x00);
    FCML_I64("vcvtudq2pd ymm0,xmm0", 0x62, 0xf1, 0x7e, 0x28, 0x7a, 0xc0);

    FCML_A64("vcvtudq2pd (%rax),%xmm0", 0x62, 0xf1, 0x7e, 0x08, 0x7a, 0x00);
    FCML_A64("vcvtudq2pd %xmm0,%xmm0", 0x62, 0xf1, 0x7e, 0x08, 0x7a, 0xc0);
    FCML_A64("vcvtudq2pd (%rax),%ymm0", 0x62, 0xf1, 0x7e, 0x28, 0x7a, 0x00);
    FCML_A64("vcvtudq2pd %xmm0,%ymm0", 0x62, 0xf1, 0x7e, 0x28, 0x7a, 0xc0);

    FCML_I64("vcvtudq2pd xmm3,xmm0", 0x62, 0xf1, 0x7e, 0x08, 0x7a, 0xd8);
    FCML_I32("vcvtudq2pd xmm3,xmm0", 0x62, 0xf1, 0x7e, 0x08, 0x7a, 0xd8);
    FCML_A64("vcvtudq2pd %xmm0,%xmm3", 0x62, 0xf1, 0x7e, 0x08, 0x7a, 0xd8);
    FCML_A64("vcvtudq2pd %xmm0,%xmm3", 0x62, 0xf1, 0x7e, 0x08, 0x7a, 0xd8);
    FCML_A64("vcvtudq2pd (%rax),%xmm0", 0x62, 0xf1, 0x7e, 0x08, 0x7a, 0x00);

    FCML_I64("vcvtudq2pd xmm10{k1},mmword ptr [r9+r8]", 0x62, 0x11, 0x7e, 0x09, 0x7a, 0x14, 0x01);
    FCML_A64("vcvtudq2pd (%r9,%r8),%xmm10{%k1}", 0x62, 0x11, 0x7e, 0x09, 0x7a, 0x14, 0x01);
    FCML_I64("vcvtudq2pd ymm10{k1},xmmword ptr [r9+r8]", 0x62, 0x11, 0x7e, 0x29, 0x7a, 0x14, 0x01);
    FCML_A64("vcvtudq2pd (%r9,%r8),%ymm10{%k1}", 0x62, 0x11, 0x7e, 0x29, 0x7a, 0x14, 0x01);
    FCML_I64("vcvtudq2pd zmm1{k1},ymmword ptr [r9+r8]", 0x62, 0x91, 0x7e, 0x49, 0x7a, 0x0c, 0x01);
    FCML_A64("vcvtudq2pd (%r9,%r8),%zmm1{%k1}", 0x62, 0x91, 0x7e, 0x49, 0x7a, 0x0c, 0x01);

    FCML_I64("vcvtudq2pd xmm1{k4}{z},mmword ptr [rsp+0000000000000020h]", 0x62, 0xf1, 0x7e, 0x8c, 0x7a, 0x4c, 0x24, 0x04);
    FCML_I64("vcvtudq2pd xmm1{k4}{z},dword ptr [rsp+0000000000000020h]{1to2}", 0x62, 0xf1, 0x7e, 0x9c, 0x7a, 0x4c, 0x24, 0x08);
}

void fcml_tf_instruction_VCVTPD2UQQ(void) {
    FCML_I64("vcvtpd2uqq xmm3,xmm0", 0x62, 0xf1, 0xfd, 0x08, 0x79, 0xd8);
    FCML_I32("vcvtpd2uqq xmm3,xmm0", 0x62, 0xf1, 0xfd, 0x08, 0x79, 0xd8);
    FCML_I32("vcvtpd2uqq ymm0,ymmword ptr [eax]", 0x62, 0xf1, 0xfd, 0x28, 0x79, 0x00);
    FCML_A64("vcvtpd2uqq %xmm0,%xmm3", 0x62, 0xf1, 0xfd, 0x08, 0x79, 0xd8);
    FCML_A64("vcvtpd2uqq %xmm0,%xmm3", 0x62, 0xf1, 0xfd, 0x08, 0x79, 0xd8);
    FCML_A64("vcvtpd2uqq (%rax),%ymm0", 0x62, 0xf1, 0xfd, 0x28, 0x79, 0x00);

    /* {k} */
    FCML_I64("vcvtpd2uqq ymm10{k1},ymmword ptr [r9+r8]", 0x62, 0x11, 0xfd, 0x29, 0x79, 0x14, 0x01);
    FCML_A64("vcvtpd2uqq (%r9,%r8),%ymm10{%k1}", 0x62, 0x11, 0xfd, 0x29, 0x79, 0x14, 0x01);
    FCML_I64("vcvtpd2uqq xmm10{k1},xmmword ptr [r9+r8]", 0x62, 0x11, 0xfd, 0x09, 0x79, 0x14, 0x01);
    FCML_A64("vcvtpd2uqq (%r9,%r8),%xmm10{%k1}", 0x62, 0x11, 0xfd, 0x09, 0x79, 0x14, 0x01);
    FCML_I64("vcvtpd2uqq zmm1{k1},zmmword ptr [r9+r8]", 0x62, 0x91, 0xfd, 0x49, 0x79, 0x0c, 0x01);
    FCML_A64("vcvtpd2uqq (%r9,%r8),%zmm1{%k1}", 0x62, 0x91, 0xfd, 0x49, 0x79, 0x0c, 0x01);

    /* {k}{z} */
    FCML_I64("vcvtpd2uqq ymm10{k1}{z},ymmword ptr [r9+r8]", 0x62, 0x11, 0xfd, 0xa9, 0x79, 0x14, 0x01);

    /* {bcast} */
    FCML_I64("vcvtpd2uqq zmm31,mmword ptr [rsi]{1to8}", 0x62, 0x61, 0xfd, 0x58, 0x79, 0x3e);

    /* {k}{z}{bcast} */
    FCML_I64("vcvtpd2uqq ymm31{k7}{z},mmword ptr [rsi]{1to4}", 0x62, 0x61, 0xfd, 0xbf, 0x79, 0x3e);
    FCML_A64("vcvtpd2uqq (%rsi){1to4},%ymm31{%k7}{z}", 0x62, 0x61, 0xfd, 0xbf, 0x79, 0x3e);

    /* {rn} */
    FCML_I64("vcvtpd2uqq zmm31{k7}{z},zmm4,{rn-sae}", 0x62, 0x61, 0xfd, 0x9f, 0x79, 0xfc);

    /* Compressed disp8 */
    FCML_I64("vcvtpd2uqq xmm1{k4}{z},mmword ptr [rsp+0000000000000020h]{1to2}", 0x62, 0xf1, 0xfd, 0x9c, 0x79, 0x4c, 0x24, 0x04);
    FCML_I64("vcvtpd2uqq xmm1{k4}{z},mmword ptr [rsp+00000000000001d0h]{1to2}", 0x62, 0xf1, 0xfd, 0x9c, 0x79, 0x4c, 0x24, 0x3a);
    FCML_I32("vcvtpd2uqq xmm1{k4}{z},mmword ptr [esp+00000020h]{1to2}", 0x62, 0xf1, 0xfd, 0x9c, 0x79, 0x4c, 0x24, 0x04);
}

void fcml_tf_instruction_VCVTQQ2PD(void) {

    FCML_I64("vcvtqq2pd xmm3,xmm0", 0x62, 0xf1, 0xfe, 0x08, 0xe6, 0xd8);
    FCML_I32("vcvtqq2pd xmm3,xmm0", 0x62, 0xf1, 0xfe, 0x08, 0xe6, 0xd8);
    FCML_I32("vcvtqq2pd ymm0,ymmword ptr [eax]", 0x62, 0xf1, 0xfe, 0x28, 0xe6, 0x00);
    FCML_A64("vcvtqq2pd %xmm0,%xmm3", 0x62, 0xf1, 0xfe, 0x08, 0xe6, 0xd8);
    FCML_A64("vcvtqq2pd %xmm0,%xmm3", 0x62, 0xf1, 0xfe, 0x08, 0xe6, 0xd8);
    FCML_A64("vcvtqq2pd (%rax),%ymm0", 0x62, 0xf1, 0xfe, 0x28, 0xe6, 0x00);

    /* {k} */
    FCML_I64("vcvtqq2pd ymm10{k1},ymmword ptr [r9+r8]", 0x62, 0x11, 0xfe, 0x29, 0xe6, 0x14, 0x01);
    FCML_A64("vcvtqq2pd (%r9,%r8),%ymm10{%k1}", 0x62, 0x11, 0xfe, 0x29, 0xe6, 0x14, 0x01);
    FCML_I64("vcvtqq2pd xmm10{k1},xmmword ptr [r9+r8]", 0x62, 0x11, 0xfe, 0x09, 0xe6, 0x14, 0x01);
    FCML_A64("vcvtqq2pd (%r9,%r8),%xmm10{%k1}", 0x62, 0x11, 0xfe, 0x09, 0xe6, 0x14, 0x01);
    FCML_I64("vcvtqq2pd zmm1{k1},zmmword ptr [r9+r8]", 0x62, 0x91, 0xfe, 0x49, 0xe6, 0x0c, 0x01);
    FCML_A64("vcvtqq2pd (%r9,%r8),%zmm1{%k1}", 0x62, 0x91, 0xfe, 0x49, 0xe6, 0x0c, 0x01);

    /* {k}{z} */
    FCML_I64("vcvtqq2pd ymm10{k1}{z},ymmword ptr [r9+r8]", 0x62, 0x11, 0xfe, 0xa9, 0xe6, 0x14, 0x01);

    /* {bcast} */
    FCML_I64("vcvtqq2pd zmm31,mmword ptr [rsi]{1to8}", 0x62, 0x61, 0xfe, 0x58, 0xe6, 0x3e);

    /* {k}{z}{bcast} */
    FCML_I64("vcvtqq2pd ymm31{k7}{z},mmword ptr [rsi]{1to4}", 0x62, 0x61, 0xfe, 0xbf, 0xe6, 0x3e);
    FCML_A64("vcvtqq2pd (%rsi){1to4},%ymm31{%k7}{z}", 0x62, 0x61, 0xfe, 0xbf, 0xe6, 0x3e);

    /* {rn} */
    FCML_I64("vcvtqq2pd zmm31{k7}{z},zmm4,{rn-sae}", 0x62, 0x61, 0xfe, 0x9f, 0xe6, 0xfc);

    /* Compressed disp8 */
    FCML_I64("vcvtqq2pd xmm1{k4}{z},mmword ptr [rsp+0000000000000020h]{1to2}", 0x62, 0xf1, 0xfe, 0x9c, 0xe6, 0x4c, 0x24, 0x04);
    FCML_I64("vcvtqq2pd xmm1{k4}{z},mmword ptr [rsp+00000000000001d0h]{1to2}", 0x62, 0xf1, 0xfe, 0x9c, 0xe6, 0x4c, 0x24, 0x3a);
    FCML_I32("vcvtqq2pd xmm1{k4}{z},mmword ptr [esp+00000020h]{1to2}", 0x62, 0xf1, 0xfe, 0x9c, 0xe6, 0x4c, 0x24, 0x04);
}

void fcml_tf_instruction_VPBROADCASTB(void) {

    FCML_I32_M("vpbroadcastb xmm0,byte ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x78, 0x00), FCML_MI(0xc4, 0xe2, 0x79, 0x78, 0x00));
    FCML_I32_M("vpbroadcastb ymm0,byte ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x78, 0x00), FCML_MI(0xc4, 0xe2, 0x7d, 0x78, 0x00));
    FCML_I64_M("vpbroadcastb xmm0,xmm1", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x78, 0xc1), FCML_MI(0xc4, 0xe2, 0x79, 0x78, 0xc1));
    FCML_I64_M("vpbroadcastb ymm0,xmm1", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x78, 0xc1), FCML_MI(0xc4, 0xe2, 0x7d, 0x78, 0xc1));
    FCML_I64("vpbroadcastb ymm0{k1}{z},xmm1", 0x62, 0xf2, 0x7d, 0xa9, 0x78, 0xc1);

    FCML_I64("vpbroadcastb xmm0,al", 0x62, 0xf2, 0x7d, 0x08, 0x7a, 0xc0);
    FCML_I64("vpbroadcastb ymm0,ah", 0x62, 0xf2, 0x7d, 0x28, 0x7a, 0xc4);
    FCML_I64("vpbroadcastb zmm0,r10l", 0x62, 0xd2, 0x7d, 0x48, 0x7a, 0xc2);

    FCML_I32_M("vpbroadcastw xmm0,word ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x79, 0x00), FCML_MI(0xc4, 0xe2, 0x79, 0x79, 0x00));
    FCML_I32_M("vpbroadcastw ymm0,word ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x79, 0x00), FCML_MI(0xc4, 0xe2, 0x7d, 0x79, 0x00));
    FCML_I64_M("vpbroadcastw xmm0,xmm1", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x79, 0xc1), FCML_MI(0xc4, 0xe2, 0x79, 0x79, 0xc1));
    FCML_I64_M("vpbroadcastw ymm0,xmm1", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x79, 0xc1), FCML_MI(0xc4, 0xe2, 0x7d, 0x79, 0xc1));
    FCML_I64("vpbroadcastw ymm0{k1}{z},xmm1", 0x62, 0xf2, 0x7d, 0xa9, 0x79, 0xc1);

    FCML_I64("vpbroadcastw xmm0,ax", 0x62, 0xf2, 0x7d, 0x08, 0x7b, 0xc0);
    FCML_I64("vpbroadcastw ymm0,bx", 0x62, 0xf2, 0x7d, 0x28, 0x7b, 0xc3);
    FCML_I64("vpbroadcastw zmm0,r10w", 0x62, 0xd2, 0x7d, 0x48, 0x7b, 0xc2);

    FCML_I32_M("vpbroadcastd xmm0,dword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x58, 0x00), FCML_MI(0xc4, 0xe2, 0x79, 0x58, 0x00));
    FCML_I32_M("vpbroadcastd ymm0,dword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x58, 0x00), FCML_MI(0xc4, 0xe2, 0x7d, 0x58, 0x00));
    FCML_I64_M("vpbroadcastd xmm0,xmm1", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x58, 0xc1), FCML_MI(0xc4, 0xe2, 0x79, 0x58, 0xc1));
    FCML_I64_M("vpbroadcastd ymm0,xmm1", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x58, 0xc1), FCML_MI(0xc4, 0xe2, 0x7d, 0x58, 0xc1));
    FCML_I64("vpbroadcastd ymm0{k1}{z},xmm1", 0x62, 0xf2, 0x7d, 0xa9, 0x58, 0xc1);

    FCML_I64("vpbroadcastd xmm0,eax", 0x62, 0xf2, 0x7d, 0x08, 0x7c, 0xc0);
    FCML_I64("vpbroadcastd ymm0,ebx", 0x62, 0xf2, 0x7d, 0x28, 0x7c, 0xc3);
    FCML_I64("vpbroadcastd zmm0,r10d", 0x62, 0xd2, 0x7d, 0x48, 0x7c, 0xc2);

    FCML_I32_M("vpbroadcastq xmm0,mmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0xfd, 0x08, 0x59, 0x00), FCML_MI(0xc4, 0xe2, 0x79, 0x59, 0x00));
    FCML_I32_M("vpbroadcastq ymm0,mmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0xfd, 0x28, 0x59, 0x00), FCML_MI(0xc4, 0xe2, 0x7d, 0x59, 0x00));
    FCML_I64_M("vpbroadcastq xmm0,xmm1", 2, FCML_MI(0x62, 0xf2, 0xfd, 0x08, 0x59, 0xc1), FCML_MI(0xc4, 0xe2, 0x79, 0x59, 0xc1));
    FCML_I64_M("vpbroadcastq ymm0,xmm1", 2, FCML_MI(0x62, 0xf2, 0xfd, 0x28, 0x59, 0xc1), FCML_MI(0xc4, 0xe2, 0x7d, 0x59, 0xc1));
    FCML_I64("vpbroadcastq ymm0{k5}{z},xmm1", 0x62, 0xf2, 0xfd, 0xad, 0x59, 0xc1);

    FCML_I64("vpbroadcastq xmm0,rax", 0x62, 0xf2, 0xfd, 0x08, 0x7c, 0xc0);
    FCML_I64("vpbroadcastq ymm0,rbx", 0x62, 0xf2, 0xfd, 0x28, 0x7c, 0xc3);
    FCML_I64("vpbroadcastq zmm0,r10", 0x62, 0xd2, 0xfd, 0x48, 0x7c, 0xc2);
    FCML_I32_A_FAILED("vpbroadcastq ymm0,rbx", 0x62, 0xf2, 0xfd, 0x28, 0x7c, 0xc3);

    FCML_A64_M("vpbroadcastb %xmm1,%xmm0", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x78, 0xc1), FCML_MI(0xc4, 0xe2, 0x79, 0x78, 0xc1));
    FCML_A64_M("vpbroadcastb %xmm1,%ymm0", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x78, 0xc1), FCML_MI(0xc4, 0xe2, 0x7d, 0x78, 0xc1));
    FCML_A64_M("vpbroadcastw %xmm1,%xmm0", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x79, 0xc1), FCML_MI(0xc4, 0xe2, 0x79, 0x79, 0xc1));
    FCML_A64_M("vpbroadcastw %xmm1,%ymm0", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x79, 0xc1), FCML_MI(0xc4, 0xe2, 0x7d, 0x79, 0xc1));
    FCML_A64_M("vpbroadcastd %xmm1,%xmm0", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x58, 0xc1), FCML_MI(0xc4, 0xe2, 0x79, 0x58, 0xc1));
    FCML_A64_M("vpbroadcastd %xmm1,%ymm0", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x58, 0xc1), FCML_MI(0xc4, 0xe2, 0x7d, 0x58, 0xc1));
    FCML_A64_M("vpbroadcastq %xmm1,%xmm0", 2, FCML_MI(0x62, 0xf2, 0xfd, 0x08, 0x59, 0xc1), FCML_MI(0xc4, 0xe2, 0x79, 0x59, 0xc1));
    FCML_A64_M("vpbroadcastq %xmm1,%ymm0", 2, FCML_MI(0x62, 0xf2, 0xfd, 0x28, 0x59, 0xc1), FCML_MI(0xc4, 0xe2, 0x7d, 0x59, 0xc1));
    FCML_A64_M("vpbroadcastb (%rax),%xmm0", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x78, 0x00), FCML_MI(0xc4, 0xe2, 0x79, 0x78, 0x00));
    FCML_A64_M("vpbroadcastb (%rax),%ymm0", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x78, 0x00), FCML_MI(0xc4, 0xe2, 0x7d, 0x78, 0x00));
}

void fcml_tf_instruction_VDBPSADBW(void) {
    /* xmm1, xmm2, m128, imm8 */
    FCML_A64("vdbpsadbw $0x14,(%rax),%xmm7,%xmm15", 0x62, 0x73, 0x45, 0x08, 0x42, 0x38, 0x14);
    FCML_I64("vdbpsadbw xmm15,xmm7,xmmword ptr [rax],14h", 0x62, 0x73, 0x45, 0x08, 0x42, 0x38, 0x14);
    FCML_A32("vdbpsadbw $0x14,(%eax),%xmm6,%xmm7", 0x62, 0xf3, 0x4d, 0x08, 0x42, 0x38, 0x14);
    FCML_I32("vdbpsadbw xmm7,xmm6,xmmword ptr [eax],14h", 0x62, 0xf3, 0x4d, 0x08, 0x42, 0x38, 0x14);
    /* ymm1, ymm2, m256 */
    FCML_A64("vdbpsadbw $0x14,(%rax),%ymm7,%ymm15", 0x62, 0x73, 0x45, 0x28, 0x42, 0x38, 0x14);
    FCML_I64("vdbpsadbw ymm15,ymm7,ymmword ptr [rax],14h", 0x62, 0x73, 0x45, 0x28, 0x42, 0x38, 0x14);
    FCML_A32("vdbpsadbw $0x14,(%eax),%ymm5,%ymm7", 0x62, 0xf3, 0x55, 0x28, 0x42, 0x38, 0x14);
    FCML_I32("vdbpsadbw ymm7,ymm5,ymmword ptr [eax],14h", 0x62, 0xf3, 0x55, 0x28, 0x42, 0x38, 0x14);
    /* zmm1, zmm2, m512 */
    FCML_A64("vdbpsadbw $0x14,(%rax),%zmm7,%zmm15", 0x62, 0x73, 0x45, 0x48, 0x42, 0x38, 0x14);
    FCML_I64("vdbpsadbw zmm15,zmm7,zmmword ptr [rax],14h", 0x62, 0x73, 0x45, 0x48, 0x42, 0x38, 0x14);
    FCML_A32("vdbpsadbw $0x14,(%eax),%zmm3,%zmm7", 0x62, 0xf3, 0x65, 0x48, 0x42, 0x38, 0x14);
    FCML_I32("vdbpsadbw zmm7,zmm3,zmmword ptr [eax],14h", 0x62, 0xf3, 0x65, 0x48, 0x42, 0x38, 0x14);
    /* xmm1, xmm2, xmm3 */
    FCML_A64("vdbpsadbw $0x14,%xmm1,%xmm7,%xmm15", 0x62, 0x73, 0x45, 0x08, 0x42, 0xf9, 0x14);
    FCML_I64("vdbpsadbw xmm15,xmm7,xmm1,14h", 0x62, 0x73, 0x45, 0x08, 0x42, 0xf9, 0x14);
    FCML_A32("vdbpsadbw $0x14,%xmm1,%xmm2,%xmm7", 0x62, 0xf3, 0x6d, 0x08, 0x42, 0xf9, 0x14);
    FCML_I32("vdbpsadbw xmm7,xmm2,xmm1,14h", 0x62, 0xf3, 0x6d, 0x08, 0x42, 0xf9, 0x14);
    /* ymm1, ymm2, ymm3 */
    FCML_A64("vdbpsadbw $0x14,%ymm6,%ymm7,%ymm14", 0x62, 0x73, 0x45, 0x28, 0x42, 0xf6, 0x14);
    FCML_I64("vdbpsadbw ymm14,ymm7,ymm6,14h", 0x62, 0x73, 0x45, 0x28, 0x42, 0xf6, 0x14);
    FCML_A32("vdbpsadbw $0x14,%ymm5,%ymm3,%ymm6", 0x62, 0xf3, 0x65, 0x28, 0x42, 0xf5, 0x14);
    FCML_I32("vdbpsadbw ymm6,ymm3,ymm5,14h", 0x62, 0xf3, 0x65, 0x28, 0x42, 0xf5, 0x14);
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vdbpsadbw $0x14,%zmm4,%zmm15,%zmm6", 0x62, 0xf3, 0x05, 0x48, 0x42, 0xf4, 0x14);
    FCML_I64("vdbpsadbw zmm6,zmm15,zmm4,14h", 0x62, 0xf3, 0x05, 0x48, 0x42, 0xf4, 0x14);
    FCML_A32("vdbpsadbw $0x14,%zmm4,%zmm6,%zmm6", 0x62, 0xf3, 0x4d, 0x48, 0x42, 0xf4, 0x14);
    FCML_I32("vdbpsadbw zmm6,zmm6,zmm4,14h", 0x62, 0xf3, 0x4d, 0x48, 0x42, 0xf4, 0x14);
    /* disp8 */
    FCML_I32("vdbpsadbw zmm1,zmm2,zmmword ptr [esp+00000200h],14h", 0x62, 0xf3, 0x6d, 0x48, 0x42, 0x4c, 0x24, 0x08, 0x14);
    FCML_A32("vdbpsadbw $0x14,0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf3, 0x6d, 0x48, 0x42, 0x4c, 0x24, 0x08, 0x14);
    FCML_I64("vdbpsadbw zmm1,zmm2,zmmword ptr [rsp+0000000000000200h],14h", 0x62, 0xf3, 0x6d, 0x48, 0x42, 0x4c, 0x24, 0x08, 0x14);
    FCML_A64("vdbpsadbw $0x14,0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf3, 0x6d, 0x48, 0x42, 0x4c, 0x24, 0x08, 0x14);
    FCML_I32("vdbpsadbw ymm1,ymm2,ymmword ptr [esp+00000100h],14h", 0x62, 0xf3, 0x6d, 0x28, 0x42, 0x4c, 0x24, 0x08, 0x14);
    FCML_A32("vdbpsadbw $0x14,0x00000100(%esp),%ymm2,%ymm1", 0x62, 0xf3, 0x6d, 0x28, 0x42, 0x4c, 0x24, 0x08, 0x14);
    FCML_I64("vdbpsadbw ymm1,ymm2,ymmword ptr [rsp+0000000000000100h],14h", 0x62, 0xf3, 0x6d, 0x28, 0x42, 0x4c, 0x24, 0x08, 0x14);
    FCML_A64("vdbpsadbw $0x14,0x0000000000000100(%rsp),%ymm2,%ymm1", 0x62, 0xf3, 0x6d, 0x28, 0x42, 0x4c, 0x24, 0x08, 0x14);
    FCML_I32("vdbpsadbw xmm1,xmm2,xmmword ptr [esp+00000080h],14h", 0x62, 0xf3, 0x6d, 0x08, 0x42, 0x4c, 0x24, 0x08, 0x14);
    FCML_A32("vdbpsadbw $0x14,0x00000080(%esp),%xmm2,%xmm1", 0x62, 0xf3, 0x6d, 0x08, 0x42, 0x4c, 0x24, 0x08, 0x14);
    FCML_I64("vdbpsadbw xmm1,xmm2,xmmword ptr [rsp+0000000000000080h],14h", 0x62, 0xf3, 0x6d, 0x08, 0x42, 0x4c, 0x24, 0x08, 0x14);
    FCML_A64("vdbpsadbw $0x14,0x0000000000000080(%rsp),%xmm2,%xmm1", 0x62, 0xf3, 0x6d, 0x08, 0x42, 0x4c, 0x24, 0x08, 0x14);
    /* {k}{z} */
    FCML_A64("vdbpsadbw $0x14,(%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x13, 0x0d, 0x8c, 0x42, 0x14, 0x01, 0x14);
    FCML_I64("vdbpsadbw xmm10{k4}{z},xmm14,xmmword ptr [r9+r8],14h", 0x62, 0x13, 0x0d, 0x8c, 0x42, 0x14, 0x01, 0x14);
    FCML_A32("vdbpsadbw $0x14,(%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf3, 0x45, 0x8d, 0x42, 0x14, 0x01, 0x14);
    FCML_I32("vdbpsadbw xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax],14h", 0x62, 0xf3, 0x45, 0x8d, 0x42, 0x14, 0x01, 0x14);
    FCML_A64("vdbpsadbw $0x14,(%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x13, 0x0d, 0xac, 0x42, 0x14, 0x01, 0x14);
    FCML_I64("vdbpsadbw ymm10{k4}{z},ymm14,ymmword ptr [r9+r8],14h", 0x62, 0x13, 0x0d, 0xac, 0x42, 0x14, 0x01, 0x14);
    FCML_A32("vdbpsadbw $0x14,(%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf3, 0x45, 0xad, 0x42, 0x14, 0x01, 0x14);
    FCML_I32("vdbpsadbw ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax],14h", 0x62, 0xf3, 0x45, 0xad, 0x42, 0x14, 0x01, 0x14);
    FCML_A64("vdbpsadbw $0x14,(%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x13, 0x0d, 0xcc, 0x42, 0x14, 0x01, 0x14);
    FCML_I64("vdbpsadbw zmm10{k4}{z},zmm14,zmmword ptr [r9+r8],14h", 0x62, 0x13, 0x0d, 0xcc, 0x42, 0x14, 0x01, 0x14);
    FCML_A32("vdbpsadbw $0x14,(%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf3, 0x45, 0xcd, 0x42, 0x14, 0x01, 0x14);
    FCML_I32("vdbpsadbw zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax],14h", 0x62, 0xf3, 0x45, 0xcd, 0x42, 0x14, 0x01, 0x14);
    /* {k} */
    FCML_A64("vdbpsadbw $0x14,(%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x13, 0x0d, 0x0c, 0x42, 0x14, 0x01, 0x14);
    FCML_I64("vdbpsadbw xmm10{k4},xmm14,xmmword ptr [r9+r8],14h", 0x62, 0x13, 0x0d, 0x0c, 0x42, 0x14, 0x01, 0x14);
    FCML_A32("vdbpsadbw $0x14,(%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf3, 0x45, 0x0d, 0x42, 0x14, 0x01, 0x14);
    FCML_I32("vdbpsadbw xmm2{k5},xmm7,xmmword ptr [ecx+eax],14h", 0x62, 0xf3, 0x45, 0x0d, 0x42, 0x14, 0x01, 0x14);
    FCML_A64("vdbpsadbw $0x14,(%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x13, 0x0d, 0x2c, 0x42, 0x14, 0x01, 0x14);
    FCML_I64("vdbpsadbw ymm10{k4},ymm14,ymmword ptr [r9+r8],14h", 0x62, 0x13, 0x0d, 0x2c, 0x42, 0x14, 0x01, 0x14);
    FCML_A32("vdbpsadbw $0x14,(%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf3, 0x45, 0x2d, 0x42, 0x14, 0x01, 0x14);
    FCML_I32("vdbpsadbw ymm2{k5},ymm7,ymmword ptr [ecx+eax],14h", 0x62, 0xf3, 0x45, 0x2d, 0x42, 0x14, 0x01, 0x14);
    FCML_A64("vdbpsadbw $0x14,(%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x13, 0x0d, 0x4c, 0x42, 0x14, 0x01, 0x14);
    FCML_I64("vdbpsadbw zmm10{k4},zmm14,zmmword ptr [r9+r8],14h", 0x62, 0x13, 0x0d, 0x4c, 0x42, 0x14, 0x01, 0x14);
    FCML_A32("vdbpsadbw $0x14,(%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf3, 0x45, 0x4d, 0x42, 0x14, 0x01, 0x14);
    FCML_I32("vdbpsadbw zmm2{k5},zmm7,zmmword ptr [ecx+eax],14h", 0x62, 0xf3, 0x45, 0x4d, 0x42, 0x14, 0x01, 0x14);
}

void fcml_tf_instruction_VEXPANDPD(void) {
    FCML_I32("vexpandpd xmm3,xmm0", 0x62, 0xf2, 0xfd, 0x08, 0x88, 0xd8);
    FCML_I64("vexpandpd xmm3,xmm0", 0x62, 0xf2, 0xfd, 0x08, 0x88, 0xd8);
    FCML_I32("vexpandpd xmm0,xmmword ptr [eax]", 0x62, 0xf2, 0xfd, 0x08, 0x88, 0x00);
    FCML_I64("vexpandpd xmm0,xmm3", 0x62, 0xf2, 0xfd, 0x08, 0x88, 0xc3);
    FCML_I32("vexpandpd xmm0,xmm3", 0x62, 0xf2, 0xfd, 0x08, 0x88, 0xc3);

    FCML_I32("vexpandpd xmm0,xmmword ptr [eax]", 0x62, 0xf2, 0xfd, 0x08, 0x88, 0x00);
    FCML_A64("vexpandpd (%rax),%xmm0", 0x62, 0xf2, 0xfd, 0x08, 0x88, 0x00);

    FCML_A64("vexpandpd 0x0000000000000020(%rax),%xmm0", 0x62, 0xf2, 0xfd, 0x08, 0x88, 0x40, 0x04);

    FCML_A64("vexpandpd (%r9,%r8),%xmm1{%k1}{z}", 0x62, 0x92, 0xfd, 0x89, 0x88, 0x0c, 0x01);
    FCML_I64("vexpandpd xmm1{k1},xmmword ptr [r9+r8]", 0x62, 0x92, 0xfd, 0x09, 0x88, 0x0c, 0x01);

    FCML_A64("vexpandpd %xmm2,%xmm1{%k1}{z}", 0x62, 0xf2, 0xfd, 0x89, 0x88, 0xca);
    FCML_A64("vexpandpd %ymm2,%ymm1{%k1}{z}", 0x62, 0xf2, 0xfd, 0xa9, 0x88, 0xca);
    FCML_A64("vexpandpd %zmm2,%zmm1{%k1}{z}", 0x62, 0xf2, 0xfd, 0xc9, 0x88, 0xca);

    FCML_I64("vexpandpd xmm1{k1}{z},xmm2", 0x62, 0xf2, 0xfd, 0x89, 0x88, 0xca);
    FCML_I64("vexpandpd ymm1{k1}{z},ymm2", 0x62, 0xf2, 0xfd, 0xa9, 0x88, 0xca);
    FCML_I64("vexpandpd zmm1{k1}{z},zmm2", 0x62, 0xf2, 0xfd, 0xc9, 0x88, 0xca);
}

void fcml_tf_instruction_VEXPANDPS(void) {
    FCML_I32("vexpandps xmm3,xmm0", 0x62, 0xf2, 0x7D, 0x08, 0x88, 0xd8);
    FCML_I64("vexpandps xmm3,xmm0", 0x62, 0xf2, 0x7D, 0x08, 0x88, 0xd8);
    FCML_I32("vexpandps xmm0,xmmword ptr [eax]", 0x62, 0xf2, 0x7D, 0x08, 0x88, 0x00);
    FCML_I64("vexpandps xmm0,xmm3", 0x62, 0xf2, 0x7D, 0x08, 0x88, 0xc3);
    FCML_I32("vexpandps xmm0,xmm3", 0x62, 0xf2, 0x7D, 0x08, 0x88, 0xc3);

    FCML_I32("vexpandps xmm0,xmmword ptr [eax]", 0x62, 0xf2, 0x7D, 0x08, 0x88, 0x00);
    FCML_A64("vexpandps (%rax),%xmm0", 0x62, 0xf2, 0x7D, 0x08, 0x88, 0x00);

    FCML_A64("vexpandps 0x0000000000000020(%rax),%xmm0", 0x62, 0xf2, 0x7D, 0x08, 0x88, 0x40, 0x08);

    FCML_A64("vexpandps (%r9,%r8),%xmm1{%k1}{z}", 0x62, 0x92, 0x7D, 0x89, 0x88, 0x0c, 0x01);
    FCML_I64("vexpandps xmm1{k1},xmmword ptr [r9+r8]", 0x62, 0x92, 0x7D, 0x09, 0x88, 0x0c, 0x01);

    FCML_A64("vexpandps %xmm2,%xmm1{%k1}{z}", 0x62, 0xf2, 0x7D, 0x89, 0x88, 0xca);
    FCML_A64("vexpandps %ymm2,%ymm1{%k1}{z}", 0x62, 0xf2, 0x7D, 0xa9, 0x88, 0xca);
    FCML_A64("vexpandps %zmm2,%zmm1{%k1}{z}", 0x62, 0xf2, 0x7D, 0xc9, 0x88, 0xca);

    FCML_I64("vexpandps xmm1{k1}{z},xmm2", 0x62, 0xf2, 0x7D, 0x89, 0x88, 0xca);
    FCML_I64("vexpandps ymm1{k1}{z},ymm2", 0x62, 0xf2, 0x7D, 0xa9, 0x88, 0xca);
    FCML_I64("vexpandps zmm1{k1}{z},zmm2", 0x62, 0xf2, 0x7D, 0xc9, 0x88, 0xca);
}

void fcml_tf_instruction_VEXTRACTF128(void) {

    FCML_I32( "vextractf128 xmmword ptr [ecx+eax],ymm2,20h", 0xC4, 0xE3, 0x7D, 0x19, 0x14, 0x01, 0x20 );
    FCML_I64( "vextractf128 xmm0,ymm0,20h", 0xC4, 0xE3, 0x7D, 0x19, 0xC0, 0x20 );

    FCML_A64( "vextractf128 $0x20,%ymm2,(%rcx,%rax)", 0xc4, 0xe3, 0x7d, 0x19, 0x14, 0x01, 0x20 );
    FCML_A64( "vextractf128 $0x20,%ymm0,%xmm0", 0xc4, 0xe3, 0x7d, 0x19, 0xc0, 0x20 );
}

void fcml_tf_instruction_VEXTRACTF32X4(void) {
    FCML_I32("vextractf32x4 xmmword ptr [ecx+eax],ymm2,20h", 0x62, 0xf3, 0x7d, 0x28, 0x19, 0x14, 0x01, 0x20);
    FCML_I64("vextractf32x4 xmm0,ymm0,20h", 0x62, 0xf3, 0x7d, 0x28, 0x19, 0xc0, 0x20);
    FCML_I32("vextractf32x4 xmmword ptr [ecx+eax],zmm2,20h", 0x62, 0xf3, 0x7d, 0x48, 0x19, 0x14, 0x01, 0x20);
    FCML_I64("vextractf32x4 xmm0,zmm0,20h", 0x62, 0xf3, 0x7d, 0x48, 0x19, 0xc0, 0x20);
    FCML_I32("vextractf32x4 xmmword ptr [ecx+eax]{k3},ymm2,20h", 0x62, 0xf3, 0x7d, 0x2b, 0x19, 0x14, 0x01, 0x20);
    FCML_I64("vextractf32x4 xmm0{k3}{z},ymm0,20h", 0x62, 0xf3, 0x7d, 0xab, 0x19, 0xc0, 0x20);
    FCML_I32("vextractf32x4 xmmword ptr [esp+00000020h],ymm0,20h", 0x62, 0xf3, 0x7d, 0x28, 0x19, 0x44, 0x24, 0x02, 0x20);

    FCML_A32("vextractf32x4 $0x20,%ymm2,(%ecx,%eax)", 0x62, 0xf3, 0x7d, 0x28, 0x19, 0x14, 0x01, 0x20);
    FCML_A64("vextractf32x4 $0x20,%ymm0,%xmm0", 0x62, 0xf3, 0x7d, 0x28, 0x19, 0xc0, 0x20);
    FCML_A32("vextractf32x4 $0x20,%zmm2,(%ecx,%eax)", 0x62, 0xf3, 0x7d, 0x48, 0x19, 0x14, 0x01, 0x20);
    FCML_A64("vextractf32x4 $0x20,%zmm0,%xmm0", 0x62, 0xf3, 0x7d, 0x48, 0x19, 0xc0, 0x20);
    FCML_A32("vextractf32x4 $0x20,%ymm2,(%ecx,%eax){%k3}", 0x62, 0xf3, 0x7d, 0x2b, 0x19, 0x14, 0x01, 0x20);
    FCML_A64("vextractf32x4 $0x20,%ymm0,%xmm0{%k3}{z}", 0x62, 0xf3, 0x7d, 0xab, 0x19, 0xc0, 0x20);
    FCML_A32("vextractf32x4 $0x20,%ymm0,0x00000020(%esp)", 0x62, 0xf3, 0x7d, 0x28, 0x19, 0x44, 0x24, 0x02, 0x20);
}

void fcml_tf_instruction_VEXTRACTF64X2(void) {
    FCML_I32("vextractf64x2 xmmword ptr [ecx+eax],ymm2,20h", 0x62, 0xf3, 0xfd, 0x28, 0x19, 0x14, 0x01, 0x20);
    FCML_I64("vextractf64x2 xmm0,ymm0,20h", 0x62, 0xf3, 0xfd, 0x28, 0x19, 0xc0, 0x20);
    FCML_I32("vextractf64x2 xmmword ptr [ecx+eax],zmm2,20h", 0x62, 0xf3, 0xfd, 0x48, 0x19, 0x14, 0x01, 0x20);
    FCML_I64("vextractf64x2 xmm0,zmm0,20h", 0x62, 0xf3, 0xfd, 0x48, 0x19, 0xc0, 0x20);
    FCML_I32("vextractf64x2 xmmword ptr [ecx+eax]{k3},ymm2,20h", 0x62, 0xf3, 0xfd, 0x2b, 0x19, 0x14, 0x01, 0x20);
    FCML_I64("vextractf64x2 xmm0{k3}{z},ymm0,20h", 0x62, 0xf3, 0xfd, 0xab, 0x19, 0xc0, 0x20);
    FCML_I32("vextractf64x2 xmmword ptr [esp+00000020h],ymm0,20h", 0x62, 0xf3, 0xfd, 0x28, 0x19, 0x44, 0x24, 0x02, 0x20);

    FCML_A32("vextractf64x2 $0x20,%ymm2,(%ecx,%eax)", 0x62, 0xf3, 0xfd, 0x28, 0x19, 0x14, 0x01, 0x20);
    FCML_A64("vextractf64x2 $0x20,%ymm0,%xmm0", 0x62, 0xf3, 0xfd, 0x28, 0x19, 0xc0, 0x20);
    FCML_A32("vextractf64x2 $0x20,%zmm2,(%ecx,%eax)", 0x62, 0xf3, 0xfd, 0x48, 0x19, 0x14, 0x01, 0x20);
    FCML_A64("vextractf64x2 $0x20,%zmm0,%xmm0", 0x62, 0xf3, 0xfd, 0x48, 0x19, 0xc0, 0x20);
    FCML_A32("vextractf64x2 $0x20,%ymm2,(%ecx,%eax){%k3}", 0x62, 0xf3, 0xfd, 0x2b, 0x19, 0x14, 0x01, 0x20);
    FCML_A64("vextractf64x2 $0x20,%ymm0,%xmm0{%k3}{z}", 0x62, 0xf3, 0xfd, 0xab, 0x19, 0xc0, 0x20);
    FCML_A32("vextractf64x2 $0x20,%ymm0,0x00000020(%esp)", 0x62, 0xf3, 0xfd, 0x28, 0x19, 0x44, 0x24, 0x02, 0x20);
}

void fcml_tf_instruction_VEXTRACTF32X8(void) {
    FCML_I32("vextractf32x8 ymmword ptr [ecx+eax],zmm2,20h", 0x62, 0xf3, 0x7d, 0x48, 0x1b, 0x14, 0x01, 0x20);
    FCML_I64("vextractf32x8 ymm0,zmm0,20h", 0x62, 0xf3, 0x7d, 0x48, 0x1b, 0xc0, 0x20);
    FCML_I32("vextractf32x8 ymmword ptr [ecx+eax]{k3},zmm2,20h", 0x62, 0xf3, 0x7d, 0x4B, 0x1b, 0x14, 0x01, 0x20);
    FCML_I64("vextractf32x8 ymm0{k3}{z},zmm0,20h", 0x62, 0xf3, 0x7d, 0xcb, 0x1b, 0xc0, 0x20);
    FCML_I32("vextractf32x8 ymmword ptr [esp+00000020h],zmm0,20h", 0x62, 0xf3, 0x7d, 0x48, 0x1b, 0x44, 0x24, 0x01, 0x20);

    FCML_A32("vextractf32x8 $0x20,%zmm2,(%ecx,%eax)", 0x62, 0xf3, 0x7d, 0x48, 0x1b, 0x14, 0x01, 0x20);
    FCML_A64("vextractf32x8 $0x20,%zmm0,%ymm0", 0x62, 0xf3, 0x7d, 0x48, 0x1b, 0xc0, 0x20);
    FCML_A32("vextractf32x8 $0x20,%zmm2,(%ecx,%eax){%k3}", 0x62, 0xf3, 0x7d, 0x4B, 0x1b, 0x14, 0x01, 0x20);
    FCML_A64("vextractf32x8 $0x20,%zmm0,%ymm0{%k3}{z}", 0x62, 0xf3, 0x7d, 0xcb, 0x1b, 0xc0, 0x20);
    FCML_A32("vextractf32x8 $0x20,%zmm0,0x00000020(%esp)", 0x62, 0xf3, 0x7d, 0x48, 0x1b, 0x44, 0x24, 0x01, 0x20);
}

void fcml_tf_instruction_VEXTRACTF64X4(void) {
    FCML_I32("vextractf64x4 ymmword ptr [ecx+eax],zmm2,20h", 0x62, 0xf3, 0xfd, 0x48, 0x1b, 0x14, 0x01, 0x20);
    FCML_I64("vextractf64x4 ymm0,zmm0,20h", 0x62, 0xf3, 0xfd, 0x48, 0x1b, 0xc0, 0x20);
    FCML_I32("vextractf64x4 ymmword ptr [ecx+eax]{k3},zmm2,20h", 0x62, 0xf3, 0xfd, 0x4B, 0x1b, 0x14, 0x01, 0x20);
    FCML_I64("vextractf64x4 ymm0{k3}{z},zmm0,20h", 0x62, 0xf3, 0xfd, 0xcb, 0x1b, 0xc0, 0x20);
    FCML_I32("vextractf64x4 ymmword ptr [esp+00000020h],zmm0,20h", 0x62, 0xf3, 0xfd, 0x48, 0x1b, 0x44, 0x24, 0x01, 0x20);

    FCML_A32("vextractf64x4 $0x20,%zmm2,(%ecx,%eax)", 0x62, 0xf3, 0xfd, 0x48, 0x1b, 0x14, 0x01, 0x20);
    FCML_A64("vextractf64x4 $0x20,%zmm0,%ymm0", 0x62, 0xf3, 0xfd, 0x48, 0x1b, 0xc0, 0x20);
    FCML_A32("vextractf64x4 $0x20,%zmm2,(%ecx,%eax){%k3}", 0x62, 0xf3, 0xfd, 0x4B, 0x1b, 0x14, 0x01, 0x20);
    FCML_A64("vextractf64x4 $0x20,%zmm0,%ymm0{%k3}{z}", 0x62, 0xf3, 0xfd, 0xcb, 0x1b, 0xc0, 0x20);
    FCML_A32("vextractf64x4 $0x20,%zmm0,0x00000020(%esp)", 0x62, 0xf3, 0xfd, 0x48, 0x1b, 0x44, 0x24, 0x01, 0x20);
}

void fcml_tf_instruction_VEXTRACTI32X4(void) {
    FCML_I32("vextracti32x4 xmmword ptr [ecx+eax],ymm2,20h", 0x62, 0xf3, 0x7d, 0x28, 0x39, 0x14, 0x01, 0x20);
    FCML_I64("vextracti32x4 xmm0,ymm0,20h", 0x62, 0xf3, 0x7d, 0x28, 0x39, 0xc0, 0x20);
    FCML_I32("vextracti32x4 xmmword ptr [ecx+eax],zmm2,20h", 0x62, 0xf3, 0x7d, 0x48, 0x39, 0x14, 0x01, 0x20);
    FCML_I64("vextracti32x4 xmm0,zmm0,20h", 0x62, 0xf3, 0x7d, 0x48, 0x39, 0xc0, 0x20);
    FCML_I32("vextracti32x4 xmmword ptr [ecx+eax]{k3},ymm2,20h", 0x62, 0xf3, 0x7d, 0x2b, 0x39, 0x14, 0x01, 0x20);
    FCML_I64("vextracti32x4 xmm0{k3}{z},ymm0,20h", 0x62, 0xf3, 0x7d, 0xab, 0x39, 0xc0, 0x20);
    FCML_I32("vextracti32x4 xmmword ptr [esp+00000020h],ymm0,20h", 0x62, 0xf3, 0x7d, 0x28, 0x39, 0x44, 0x24, 0x02, 0x20);

    FCML_A32("vextracti32x4 $0x20,%ymm2,(%ecx,%eax)", 0x62, 0xf3, 0x7d, 0x28, 0x39, 0x14, 0x01, 0x20);
    FCML_A64("vextracti32x4 $0x20,%ymm0,%xmm0", 0x62, 0xf3, 0x7d, 0x28, 0x39, 0xc0, 0x20);
    FCML_A32("vextracti32x4 $0x20,%zmm2,(%ecx,%eax)", 0x62, 0xf3, 0x7d, 0x48, 0x39, 0x14, 0x01, 0x20);
    FCML_A64("vextracti32x4 $0x20,%zmm0,%xmm0", 0x62, 0xf3, 0x7d, 0x48, 0x39, 0xc0, 0x20);
    FCML_A32("vextracti32x4 $0x20,%ymm2,(%ecx,%eax){%k3}", 0x62, 0xf3, 0x7d, 0x2b, 0x39, 0x14, 0x01, 0x20);
    FCML_A64("vextracti32x4 $0x20,%ymm0,%xmm0{%k3}{z}", 0x62, 0xf3, 0x7d, 0xab, 0x39, 0xc0, 0x20);
    FCML_A32("vextracti32x4 $0x20,%ymm0,0x00000020(%esp)", 0x62, 0xf3, 0x7d, 0x28, 0x39, 0x44, 0x24, 0x02, 0x20);
}

void fcml_tf_instruction_VEXTRACTI64X2(void) {
    FCML_I32("vextracti64x2 xmmword ptr [ecx+eax],ymm2,20h", 0x62, 0xf3, 0xfd, 0x28, 0x39, 0x14, 0x01, 0x20);
    FCML_I64("vextracti64x2 xmm0,ymm0,20h", 0x62, 0xf3, 0xfd, 0x28, 0x39, 0xc0, 0x20);
    FCML_I32("vextracti64x2 xmmword ptr [ecx+eax],zmm2,20h", 0x62, 0xf3, 0xfd, 0x48, 0x39, 0x14, 0x01, 0x20);
    FCML_I64("vextracti64x2 xmm0,zmm0,20h", 0x62, 0xf3, 0xfd, 0x48, 0x39, 0xc0, 0x20);
    FCML_I32("vextracti64x2 xmmword ptr [ecx+eax]{k3},ymm2,20h", 0x62, 0xf3, 0xfd, 0x2b, 0x39, 0x14, 0x01, 0x20);
    FCML_I64("vextracti64x2 xmm0{k3}{z},ymm0,20h", 0x62, 0xf3, 0xfd, 0xab, 0x39, 0xc0, 0x20);
    FCML_I32("vextracti64x2 xmmword ptr [esp+00000020h],ymm0,20h", 0x62, 0xf3, 0xfd, 0x28, 0x39, 0x44, 0x24, 0x02, 0x20);

    FCML_A32("vextracti64x2 $0x20,%ymm2,(%ecx,%eax)", 0x62, 0xf3, 0xfd, 0x28, 0x39, 0x14, 0x01, 0x20);
    FCML_A64("vextracti64x2 $0x20,%ymm0,%xmm0", 0x62, 0xf3, 0xfd, 0x28, 0x39, 0xc0, 0x20);
    FCML_A32("vextracti64x2 $0x20,%zmm2,(%ecx,%eax)", 0x62, 0xf3, 0xfd, 0x48, 0x39, 0x14, 0x01, 0x20);
    FCML_A64("vextracti64x2 $0x20,%zmm0,%xmm0", 0x62, 0xf3, 0xfd, 0x48, 0x39, 0xc0, 0x20);
    FCML_A32("vextracti64x2 $0x20,%ymm2,(%ecx,%eax){%k3}", 0x62, 0xf3, 0xfd, 0x2b, 0x39, 0x14, 0x01, 0x20);
    FCML_A64("vextracti64x2 $0x20,%ymm0,%xmm0{%k3}{z}", 0x62, 0xf3, 0xfd, 0xab, 0x39, 0xc0, 0x20);
    FCML_A32("vextracti64x2 $0x20,%ymm0,0x00000020(%esp)", 0x62, 0xf3, 0xfd, 0x28, 0x39, 0x44, 0x24, 0x02, 0x20);
}

void fcml_tf_instruction_VEXTRACTI32X8(void) {
    FCML_I32("vextracti32x8 ymmword ptr [ecx+eax],zmm2,20h", 0x62, 0xf3, 0x7d, 0x48, 0x3b, 0x14, 0x01, 0x20);
    FCML_I64("vextracti32x8 ymm0,zmm0,20h", 0x62, 0xf3, 0x7d, 0x48, 0x3b, 0xc0, 0x20);
    FCML_I32("vextracti32x8 ymmword ptr [ecx+eax]{k3},zmm2,20h", 0x62, 0xf3, 0x7d, 0x4B, 0x3b, 0x14, 0x01, 0x20);
    FCML_I64("vextracti32x8 ymm0{k3}{z},zmm0,20h", 0x62, 0xf3, 0x7d, 0xcb, 0x3b, 0xc0, 0x20);
    FCML_I32("vextracti32x8 ymmword ptr [esp+00000020h],zmm0,20h", 0x62, 0xf3, 0x7d, 0x48, 0x3b, 0x44, 0x24, 0x01, 0x20);

    FCML_A32("vextracti32x8 $0x20,%zmm2,(%ecx,%eax)", 0x62, 0xf3, 0x7d, 0x48, 0x3b, 0x14, 0x01, 0x20);
    FCML_A64("vextracti32x8 $0x20,%zmm0,%ymm0", 0x62, 0xf3, 0x7d, 0x48, 0x3b, 0xc0, 0x20);
    FCML_A32("vextracti32x8 $0x20,%zmm2,(%ecx,%eax){%k3}", 0x62, 0xf3, 0x7d, 0x4B, 0x3b, 0x14, 0x01, 0x20);
    FCML_A64("vextracti32x8 $0x20,%zmm0,%ymm0{%k3}{z}", 0x62, 0xf3, 0x7d, 0xcb, 0x3b, 0xc0, 0x20);
    FCML_A32("vextracti32x8 $0x20,%zmm0,0x00000020(%esp)", 0x62, 0xf3, 0x7d, 0x48, 0x3b, 0x44, 0x24, 0x01, 0x20);
}

void fcml_tf_instruction_VEXTRACTI64X4(void) {
    FCML_I32("vextracti64x4 ymmword ptr [ecx+eax],zmm2,20h", 0x62, 0xf3, 0xfd, 0x48, 0x3b, 0x14, 0x01, 0x20);
    FCML_I64("vextracti64x4 ymm0,zmm0,20h", 0x62, 0xf3, 0xfd, 0x48, 0x3b, 0xc0, 0x20);
    FCML_I32("vextracti64x4 ymmword ptr [ecx+eax]{k3},zmm2,20h", 0x62, 0xf3, 0xfd, 0x4B, 0x3b, 0x14, 0x01, 0x20);
    FCML_I64("vextracti64x4 ymm0{k3}{z},zmm0,20h", 0x62, 0xf3, 0xfd, 0xcb, 0x3b, 0xc0, 0x20);
    FCML_I32("vextracti64x4 ymmword ptr [esp+00000020h],zmm0,20h", 0x62, 0xf3, 0xfd, 0x48, 0x3b, 0x44, 0x24, 0x01, 0x20);

    FCML_A32("vextracti64x4 $0x20,%zmm2,(%ecx,%eax)", 0x62, 0xf3, 0xfd, 0x48, 0x3b, 0x14, 0x01, 0x20);
    FCML_A64("vextracti64x4 $0x20,%zmm0,%ymm0", 0x62, 0xf3, 0xfd, 0x48, 0x3b, 0xc0, 0x20);
    FCML_A32("vextracti64x4 $0x20,%zmm2,(%ecx,%eax){%k3}", 0x62, 0xf3, 0xfd, 0x4B, 0x3b, 0x14, 0x01, 0x20);
    FCML_A64("vextracti64x4 $0x20,%zmm0,%ymm0{%k3}{z}", 0x62, 0xf3, 0xfd, 0xcb, 0x3b, 0xc0, 0x20);
    FCML_A32("vextracti64x4 $0x20,%zmm0,0x00000020(%esp)", 0x62, 0xf3, 0xfd, 0x48, 0x3b, 0x44, 0x24, 0x01, 0x20);
}

void fcml_tf_instruction_VINSERTF128(void) {

    FCML_I64( "vinsertf128 ymm8,ymm14,xmmword ptr [r8],20h", 0xC4, 0x43, 0x0D, 0x18, 0x00, 0x20 );
    FCML_I32( "vinsertf128 ymm0,ymm6,xmmword ptr [eax],20h", 0xC4, 0xE3, 0x4D, 0x18, 0x00, 0x20 );
    FCML_I32( "vinsertf128 ymm0,ymm6,xmm0,20h", 0xC4, 0xE3, 0x4D, 0x18, 0xC0, 0x20 );

    FCML_A64( "vinsertf128 $0x20,(%r8),%ymm14,%ymm8", 0xc4, 0x43, 0x0d, 0x18, 0x00, 0x20 );
    FCML_A64( "vinsertf128 $0x20,%xmm0,%ymm6,%ymm0", 0xc4, 0xe3, 0x4d, 0x18, 0xc0, 0x20 );
}

void fcml_tf_instruction_VMASKMOVPS_VMASKMOVPD(void) {

    FCML_I64( "vmaskmovps xmm3,xmm2,xmmword ptr [rax]", 0xC4, 0xE2, 0x69, 0x2C, 0x18 );
    FCML_I32( "vmaskmovps ymm3,ymm2,ymmword ptr [eax]", 0xC4, 0xE2, 0x6D, 0x2C, 0x18 );

    FCML_A64( "vmaskmovps (%rax),%xmm2,%xmm3", 0xc4, 0xe2, 0x69, 0x2c, 0x18 );

    FCML_I64( "vmaskmovpd xmm3,xmm2,xmmword ptr [rax]", 0xC4, 0xE2, 0x69, 0x2D, 0x18 );
    FCML_I32( "vmaskmovpd ymm3,ymm2,ymmword ptr [eax]", 0xC4, 0xE2, 0x6D, 0x2D, 0x18 );

    FCML_A64( "vmaskmovpd (%rax),%xmm2,%xmm3", 0xc4, 0xe2, 0x69, 0x2d, 0x18 );

    FCML_I64( "vmaskmovps xmmword ptr [rax],xmm2,xmm3", 0xC4, 0xE2, 0x69, 0x2E, 0x18 );
    FCML_I32( "vmaskmovps ymmword ptr [eax],ymm2,ymm3", 0xC4, 0xE2, 0x6D, 0x2E, 0x18 );

    FCML_A64( "vmaskmovps %xmm3,%xmm2,(%rax)", 0xc4, 0xe2, 0x69, 0x2e, 0x18 );

    FCML_I64( "vmaskmovpd xmmword ptr [rax],xmm2,xmm3", 0xC4, 0xE2, 0x69, 0x2F, 0x18 );
    FCML_I32( "vmaskmovpd ymmword ptr [eax],ymm2,ymm3", 0xC4, 0xE2, 0x6D, 0x2F, 0x18 );

    FCML_A64( "vmaskmovpd %xmm3,%xmm2,(%rax)", 0xc4, 0xe2, 0x69, 0x2f, 0x18 );
}

void fcml_tf_instruction_VPMASKMOVD_VPMASKMOVQ(void) {

    FCML_I64( "vpmaskmovd xmm3,xmm2,xmmword ptr [rax]", 0xC4, 0xE2, 0x69, 0x8C, 0x18 );
    FCML_I32( "vpmaskmovd ymm3,ymm2,ymmword ptr [eax]", 0xC4, 0xE2, 0x6D, 0x8C, 0x18 );
    FCML_I64( "vpmaskmovq xmm3,xmm2,xmmword ptr [rax]", 0xC4, 0xE2, 0xE9, 0x8C, 0x18 );
    FCML_I64( "vpmaskmovq ymm3,ymm2,ymmword ptr [rax]", 0xC4, 0xE2, 0xED, 0x8C, 0x18 );

    FCML_A64( "vpmaskmovq (%rax),%xmm2,%xmm3", 0xc4, 0xe2, 0xe9, 0x8c, 0x18 );
    FCML_A64( "vpmaskmovq (%rax),%ymm2,%ymm3", 0xc4, 0xe2, 0xed, 0x8c, 0x18 );

    FCML_I64( "vpmaskmovd xmmword ptr [rax],xmm2,xmm3", 0xC4, 0xE2, 0x69, 0x8E, 0x18 );
    FCML_I32( "vpmaskmovd ymmword ptr [eax],ymm2,ymm3", 0xC4, 0xE2, 0x6D, 0x8E, 0x18 );
    FCML_I64( "vpmaskmovq xmmword ptr [rax],xmm2,xmm3", 0xC4, 0xE2, 0xE9, 0x8E, 0x18 );
    FCML_I64( "vpmaskmovq ymmword ptr [rax],ymm2,ymm3", 0xC4, 0xE2, 0xED, 0x8E, 0x18 );

    FCML_A64( "vpmaskmovq %xmm3,%xmm2,(%rax)", 0xc4, 0xe2, 0xe9, 0x8e, 0x18 );
    FCML_A64( "vpmaskmovq %ymm3,%ymm2,(%rax)", 0xc4, 0xe2, 0xed, 0x8e, 0x18 );
}

void fcml_tf_instruction_VPBLENDD(void) {

    FCML_I64( "vpblendd xmm0,xmm0,xmmword ptr [rax],0ffh", 0xC4, 0xE3, 0x79, 0x02, 0x00, 0xFF );
    FCML_I32( "vpblendd xmm0,xmm0,xmm1,0ffh", 0xC4, 0xE3, 0x79, 0x02, 0xC1, 0xFF );

    FCML_I64( "vpblendd ymm0,ymm0,ymmword ptr [rax],0ffh", 0xC4, 0xE3, 0x7D, 0x02, 0x00, 0xFF );
    FCML_I32( "vpblendd ymm0,ymm0,ymm1,0ffh", 0xC4, 0xE3, 0x7D, 0x02, 0xC1, 0xFF );

    FCML_A64( "vpblendd $0xff,(%rax),%xmm0,%xmm0", 0xc4, 0xe3, 0x79, 0x02, 0x00, 0xff );
    FCML_A64( "vpblendd $0xff,%xmm1,%xmm0,%xmm0", 0xc4, 0xe3, 0x79, 0x02, 0xc1, 0xff );
    FCML_A64( "vpblendd $0xff,(%rax),%ymm0,%ymm0", 0xc4, 0xe3, 0x7d, 0x02, 0x00, 0xff );
    FCML_A64( "vpblendd $0xff,%ymm1,%ymm0,%ymm0", 0xc4, 0xe3, 0x7d, 0x02, 0xc1, 0xff );
}

void fcml_tf_instruction_VCVTPH2PS(void) {

    FCML_I32_M("vcvtph2ps xmm0,mmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x13, 0x00), FCML_MI(0xc4, 0xe2, 0x79, 0x13, 0x00));
    FCML_I32_M("vcvtph2ps xmm0,xmm0", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x13, 0xc0), FCML_MI(0xc4, 0xe2, 0x79, 0x13, 0xc0));

    FCML_I32_M("vcvtph2ps ymm0,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x13, 0x00), FCML_MI(0xc4, 0xe2, 0x7d, 0x13, 0x00));
    FCML_I64_M("vcvtph2ps ymm0,xmm0", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x13, 0xc0), FCML_MI(0xc4, 0xe2, 0x7d, 0x13, 0xc0));

    FCML_A64_M("vcvtph2ps (%rax),%xmm0", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x13, 0x00), FCML_MI(0xc4, 0xe2, 0x79, 0x13, 0x00));
    FCML_A64_M("vcvtph2ps %xmm0,%xmm0", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x13, 0xc0), FCML_MI(0xc4, 0xe2, 0x79, 0x13, 0xc0));
    FCML_A64_M("vcvtph2ps (%rax),%ymm0", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x13, 0x00), FCML_MI(0xc4, 0xe2, 0x7d, 0x13, 0x00));
    FCML_A64_M("vcvtph2ps %xmm0,%ymm0", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x28, 0x13, 0xc0), FCML_MI(0xc4, 0xe2, 0x7d, 0x13, 0xc0));

    FCML_I64_M("vcvtph2ps xmm3,xmm0", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x13, 0xd8), FCML_MI(0xc4, 0xe2, 0x79, 0x13, 0xd8));
    FCML_I32_M("vcvtph2ps xmm3,xmm0", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x13, 0xd8), FCML_MI(0xc4, 0xe2, 0x79, 0x13, 0xd8));
    FCML_A64_M("vcvtph2ps %xmm0,%xmm3", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x13, 0xd8), FCML_MI(0xc4, 0xe2, 0x79, 0x13, 0xd8));
    FCML_A64_M("vcvtph2ps %xmm0,%xmm3", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x13, 0xd8), FCML_MI(0xc4, 0xe2, 0x79, 0x13, 0xd8));
    FCML_A64_M("vcvtph2ps (%rax),%xmm0", 2, FCML_MI(0x62, 0xf2, 0x7d, 0x08, 0x13, 0x00), FCML_MI(0xc4, 0xe2, 0x79, 0x13, 0x00));

    FCML_I64("vcvtph2ps xmm10{k1},mmword ptr [r9+r8]", 0x62, 0x12, 0x7d, 0x09, 0x13, 0x14, 0x01);
    FCML_A64("vcvtph2ps (%r9,%r8),%xmm10{%k1}", 0x62, 0x12, 0x7d, 0x09, 0x13, 0x14, 0x01);
    FCML_I64("vcvtph2ps ymm10{k1},xmmword ptr [r9+r8]", 0x62, 0x12, 0x7d, 0x29, 0x13, 0x14, 0x01);
    FCML_A64("vcvtph2ps (%r9,%r8),%ymm10{%k1}", 0x62, 0x12, 0x7d, 0x29, 0x13, 0x14, 0x01);
    FCML_I64("vcvtph2ps zmm1{k1},ymmword ptr [r9+r8]", 0x62, 0x92, 0x7d, 0x49, 0x13, 0x0c, 0x01);
    FCML_A64("vcvtph2ps (%r9,%r8),%zmm1{%k1}", 0x62, 0x92, 0x7d, 0x49, 0x13, 0x0c, 0x01);

    FCML_I64("vcvtph2ps zmm31{k7}{z},ymm4,{sae}", 0x62, 0x62, 0x7d, 0x9f, 0x13, 0xfc);

    FCML_I64("vcvtph2ps xmm1{k4}{z},mmword ptr [rsp+0000000000000020h]", 0x62, 0xf2, 0x7d, 0x8c, 0x13, 0x4c, 0x24, 0x04);
}

void fcml_tf_instruction_VCVTPS2QQ(void) {
    FCML_I32("vcvtps2qq xmm0,mmword ptr [eax]", 0x62, 0xf1, 0x7d, 0x08, 0x7b, 0x00);
    FCML_I32("vcvtps2qq xmm0,xmm0", 0x62, 0xf1, 0x7d, 0x08, 0x7b, 0xc0);

    FCML_I32("vcvtps2qq ymm0,xmmword ptr [eax]", 0x62, 0xf1, 0x7d, 0x28, 0x7b, 0x00);
    FCML_I64("vcvtps2qq ymm0,xmm0", 0x62, 0xf1, 0x7d, 0x28, 0x7b, 0xc0);

    FCML_A64("vcvtps2qq (%rax),%xmm0", 0x62, 0xf1, 0x7d, 0x08, 0x7b, 0x00);
    FCML_A64("vcvtps2qq %xmm0,%xmm0", 0x62, 0xf1, 0x7d, 0x08, 0x7b, 0xc0);
    FCML_A64("vcvtps2qq (%rax),%ymm0", 0x62, 0xf1, 0x7d, 0x28, 0x7b, 0x00);
    FCML_A64("vcvtps2qq %xmm0,%ymm0", 0x62, 0xf1, 0x7d, 0x28, 0x7b, 0xc0);

    FCML_I64("vcvtps2qq xmm3,xmm0", 0x62, 0xf1, 0x7d, 0x08, 0x7b, 0xd8);
    FCML_I32("vcvtps2qq xmm3,xmm0", 0x62, 0xf1, 0x7d, 0x08, 0x7b, 0xd8);
    FCML_A64("vcvtps2qq %xmm0,%xmm3", 0x62, 0xf1, 0x7d, 0x08, 0x7b, 0xd8);
    FCML_A64("vcvtps2qq %xmm0,%xmm3", 0x62, 0xf1, 0x7d, 0x08, 0x7b, 0xd8);
    FCML_A64("vcvtps2qq (%rax),%xmm0", 0x62, 0xf1, 0x7d, 0x08, 0x7b, 0x00);

    FCML_I64("vcvtps2qq xmm10{k1},mmword ptr [r9+r8]", 0x62, 0x11, 0x7d, 0x09, 0x7b, 0x14, 0x01);
    FCML_A64("vcvtps2qq (%r9,%r8),%xmm10{%k1}", 0x62, 0x11, 0x7d, 0x09, 0x7b, 0x14, 0x01);
    FCML_I64("vcvtps2qq ymm10{k1},xmmword ptr [r9+r8]", 0x62, 0x11, 0x7d, 0x29, 0x7b, 0x14, 0x01);
    FCML_A64("vcvtps2qq (%r9,%r8),%ymm10{%k1}", 0x62, 0x11, 0x7d, 0x29, 0x7b, 0x14, 0x01);
    FCML_I64("vcvtps2qq zmm1{k1},ymmword ptr [r9+r8]", 0x62, 0x91, 0x7d, 0x49, 0x7b, 0x0c, 0x01);
    FCML_A64("vcvtps2qq (%r9,%r8),%zmm1{%k1}", 0x62, 0x91, 0x7d, 0x49, 0x7b, 0x0c, 0x01);

    FCML_I64("vcvtps2qq zmm31{k7}{z},ymm4,{rn-sae}", 0x62, 0x61, 0x7d, 0x9f, 0x7b, 0xfc);

    FCML_I64("vcvtps2qq xmm1{k4}{z},mmword ptr [rsp+0000000000000020h]", 0x62, 0xf1, 0x7d, 0x8c, 0x7b, 0x4c, 0x24, 0x04);
    FCML_I64("vcvtps2qq xmm1{k4}{z},dword ptr [rsp+0000000000000020h]{1to2}", 0x62, 0xf1, 0x7d, 0x9c, 0x7b, 0x4c, 0x24, 0x08);
}

void fcml_tf_instruction_VCVTPS2UQQ(void) {
    FCML_I32("vcvtps2uqq xmm0,mmword ptr [eax]", 0x62, 0xf1, 0x7d, 0x08, 0x79, 0x00);
    FCML_I32("vcvtps2uqq xmm0,xmm0", 0x62, 0xf1, 0x7d, 0x08, 0x79, 0xc0);

    FCML_I32("vcvtps2uqq ymm0,xmmword ptr [eax]", 0x62, 0xf1, 0x7d, 0x28, 0x79, 0x00);
    FCML_I64("vcvtps2uqq ymm0,xmm0", 0x62, 0xf1, 0x7d, 0x28, 0x79, 0xc0);

    FCML_A64("vcvtps2uqq (%rax),%xmm0", 0x62, 0xf1, 0x7d, 0x08, 0x79, 0x00);
    FCML_A64("vcvtps2uqq %xmm0,%xmm0", 0x62, 0xf1, 0x7d, 0x08, 0x79, 0xc0);
    FCML_A64("vcvtps2uqq (%rax),%ymm0", 0x62, 0xf1, 0x7d, 0x28, 0x79, 0x00);
    FCML_A64("vcvtps2uqq %xmm0,%ymm0", 0x62, 0xf1, 0x7d, 0x28, 0x79, 0xc0);

    FCML_I64("vcvtps2uqq xmm3,xmm0", 0x62, 0xf1, 0x7d, 0x08, 0x79, 0xd8);
    FCML_I32("vcvtps2uqq xmm3,xmm0", 0x62, 0xf1, 0x7d, 0x08, 0x79, 0xd8);
    FCML_A64("vcvtps2uqq %xmm0,%xmm3", 0x62, 0xf1, 0x7d, 0x08, 0x79, 0xd8);
    FCML_A64("vcvtps2uqq %xmm0,%xmm3", 0x62, 0xf1, 0x7d, 0x08, 0x79, 0xd8);
    FCML_A64("vcvtps2uqq (%rax),%xmm0", 0x62, 0xf1, 0x7d, 0x08, 0x79, 0x00);

    FCML_I64("vcvtps2uqq xmm10{k1},mmword ptr [r9+r8]", 0x62, 0x11, 0x7d, 0x09, 0x79, 0x14, 0x01);
    FCML_A64("vcvtps2uqq (%r9,%r8),%xmm10{%k1}", 0x62, 0x11, 0x7d, 0x09, 0x79, 0x14, 0x01);
    FCML_I64("vcvtps2uqq ymm10{k1},xmmword ptr [r9+r8]", 0x62, 0x11, 0x7d, 0x29, 0x79, 0x14, 0x01);
    FCML_A64("vcvtps2uqq (%r9,%r8),%ymm10{%k1}", 0x62, 0x11, 0x7d, 0x29, 0x79, 0x14, 0x01);
    FCML_I64("vcvtps2uqq zmm1{k1},ymmword ptr [r9+r8]", 0x62, 0x91, 0x7d, 0x49, 0x79, 0x0c, 0x01);
    FCML_A64("vcvtps2uqq (%r9,%r8),%zmm1{%k1}", 0x62, 0x91, 0x7d, 0x49, 0x79, 0x0c, 0x01);

    FCML_I64("vcvtps2uqq zmm31{k7}{z},ymm4,{rn-sae}", 0x62, 0x61, 0x7d, 0x9f, 0x79, 0xfc);

    FCML_I64("vcvtps2uqq xmm1{k4}{z},mmword ptr [rsp+0000000000000020h]", 0x62, 0xf1, 0x7d, 0x8c, 0x79, 0x4c, 0x24, 0x04);
    FCML_I64("vcvtps2uqq xmm1{k4}{z},dword ptr [rsp+0000000000000020h]{1to2}", 0x62, 0xf1, 0x7d, 0x9c, 0x79, 0x4c, 0x24, 0x08);
}

void fcml_tf_instruction_VCVTPS2PH(void) {

    FCML_I32_M("vcvtps2ph mmword ptr [eax],xmm0,0ffh", 2, FCML_MI(0x62, 0xf3, 0x7d, 0x08, 0x1d, 0x00, 0xff), FCML_MI(0xc4, 0xe3, 0x79, 0x1d, 0x00, 0xff));
    FCML_I32_M("vcvtps2ph xmm0,xmm0,0ffh", 2, FCML_MI(0x62, 0xf3, 0x7d, 0x08, 0x1d, 0xc0, 0xff), FCML_MI(0xc4, 0xe3, 0x79, 0x1d, 0xc0, 0xff));

    FCML_I32_M("vcvtps2ph xmmword ptr [eax],ymm0,0ffh", 2, FCML_MI(0x62, 0xf3, 0x7d, 0x28, 0x1d, 0x00, 0xff), FCML_MI(0xc4, 0xe3, 0x7d, 0x1d, 0x00, 0xff));
    FCML_I64_M("vcvtps2ph xmm0,ymm0,0ffh", 2, FCML_MI(0x62, 0xf3, 0x7d, 0x28, 0x1d, 0xc0, 0xff), FCML_MI(0xc4, 0xe3, 0x7d, 0x1d, 0xc0, 0xff));

    FCML_A64_M("vcvtps2ph $0xff,%xmm0,(%rax)", 2, FCML_MI(0x62, 0xf3, 0x7d, 0x08, 0x1d, 0x00, 0xff), FCML_MI(0xc4, 0xe3, 0x79, 0x1d, 0x00, 0xff));
    FCML_A64_M("vcvtps2ph $0xff,%xmm0,%xmm0", 2, FCML_MI(0x62, 0xf3, 0x7d, 0x08, 0x1d, 0xc0, 0xff), FCML_MI(0xc4, 0xe3, 0x79, 0x1d, 0xc0, 0xff));
    FCML_A64_M("vcvtps2ph $0xff,%ymm0,(%rax)", 2, FCML_MI(0x62, 0xf3, 0x7d, 0x28, 0x1d, 0x00, 0xff), FCML_MI(0xc4, 0xe3, 0x7d, 0x1d, 0x00, 0xff));
    FCML_A64_M("vcvtps2ph $0xff,%ymm0,%xmm0", 2, FCML_MI(0x62, 0xf3, 0x7d, 0x28, 0x1d, 0xc0, 0xff), FCML_MI(0xc4, 0xe3, 0x7d, 0x1d, 0xc0, 0xff));

    FCML_I64_M("vcvtps2ph mmword ptr [r9+r8],xmm10,14h", 2, FCML_MI(0x62, 0x13, 0x7d, 0x08, 0x1d, 0x14, 0x01, 0x14), FCML_MI(0xc4, 0x03, 0x79, 0x1d, 0x14, 0x01, 0x14));
    FCML_A64("vcvtps2ph $0xff,%xmm10,(%r9,%r8){%k4}", 0x62, 0x13, 0x7d, 0x0c, 0x1d, 0x14, 0x01, 0xff);
    FCML_I64("vcvtps2ph xmmword ptr [r9+r8]{k6},ymm10,14h", 0x62, 0x13, 0x7d, 0x2e, 0x1d, 0x14, 0x01, 0x14);
    FCML_A64("vcvtps2ph $0xff,%ymm10,(%r9,%r8){%k4}", 0x62, 0x13, 0x7d, 0x2c, 0x1d, 0x14, 0x01, 0xff);

    FCML_I64("vcvtps2ph ymmword ptr [r9+r8]{k6},zmm10,14h", 0x62, 0x13, 0x7d, 0x4e, 0x1d, 0x14, 0x01, 0x14);
    FCML_A64("vcvtps2ph $0xff,%zmm10,(%r9,%r8){%k4}", 0x62, 0x13, 0x7d, 0x4c, 0x1d, 0x14, 0x01, 0xff);

    FCML_I64("vcvtps2ph ymm5{k6}{z},zmm10,{sae},14h", 0x62, 0x73, 0x7d, 0x9e, 0x1d, 0xd5, 0x14);
    FCML_A64("vcvtps2ph $0xff,{sae},%zmm10,%ymm7{%k4}", 0x62, 0x73, 0x7d, 0x1c, 0x1d, 0xd7, 0xff);

    FCML_I64("vcvtps2ph mmword ptr [rsp+0000000000000020h]{k4},xmm10,14h", 0x62, 0x73, 0x7d, 0x0c, 0x1d, 0x54, 0x24, 0x04, 0x14);
}

void fcml_tf_instruction_VERR(void) {

    FCML_I32( "verr word ptr [eax]", 0x0F, 0x00, 0x20 );
    FCML_I32( "verr ax", 0x0F, 0x00, 0xE0 );
    FCML_I32( "verr ax", 0x66, 0x0F, 0x00, 0xE0 );
    FCML_I64( "verr word ptr [rax]", 0x0F, 0x00, 0x20 );

    FCML_I32( "verw word ptr [eax]", 0x0F, 0x00, 0x28 );
    FCML_I32( "verw ax", 0x0F, 0x00, 0xE8 );
    FCML_I32( "verw ax", 0x66, 0x0F, 0x00, 0xE8 );
    FCML_I64( "verw word ptr [rax]", 0x0F, 0x00, 0x28 );

    FCML_A64( "verr (%rax)", 0x0f, 0x00, 0x20 );
    FCML_A64( "verw (%rax)", 0x0f, 0x00, 0x28 );
}

void fcml_tf_instruction_VMLOAD(void) {

    FCML_I32( "vmload eax", 0x0F, 0x01, 0xDA );
    FCML_I32( "vmload ax", 0x67, 0x0F, 0x01, 0xDA );
    FCML_I64( "vmload rax", 0x0F, 0x01, 0xDA );
    FCML_I64( "vmload eax", 0x67, 0x0F, 0x01, 0xDA );

    FCML_A32( "vmload %eax", 0x0F, 0x01, 0xDA );
    FCML_A32_A( "vmload", 0x0F, 0x01, 0xDA );
}

void fcml_tf_instruction_VMMCALL(void) {

    FCML_I32( "vmmcall", 0x0F, 0x01, 0xD9 );
    FCML_I64( "vmmcall", 0x0F, 0x01, 0xD9 );

    FCML_A64( "vmmcall", 0x0f, 0x01, 0xd9 );
}

void fcml_tf_instruction_VMRUN(void) {

    FCML_I32( "vmrun eax", 0x0F, 0x01, 0xD8 );
    FCML_I32( "vmrun ax", 0x67, 0x0F, 0x01, 0xD8 );
    FCML_I64( "vmrun rax", 0x0F, 0x01, 0xD8 );
    FCML_I64( "vmrun eax", 0x67, 0x0F, 0x01, 0xD8 );

    FCML_A64( "vmrun %rax", 0x0f, 0x01, 0xd8 );
    FCML_A64_A( "vmrun", 0x0f, 0x01, 0xd8 );
}

void fcml_tf_instruction_VMSAVE(void) {

    FCML_I32( "vmsave eax", 0x0F, 0x01, 0xDB );
    FCML_I32( "vmsave ax", 0x67, 0x0F, 0x01, 0xDB );
    FCML_I64( "vmsave rax", 0x0F, 0x01, 0xDB );
    FCML_I64( "vmsave eax", 0x67, 0x0F, 0x01, 0xDB );

    FCML_A32( "vmsave %eax", 0x0F, 0x01, 0xDB );
    FCML_A32_A( "vmsave", 0x0F, 0x01, 0xDB );
}

void fcml_tf_instruction_VPERMILPD(void) {
    FCML_I32_M("vpermilpd xmm0,xmm6,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0xcd, 0x08, 0x0d, 0x00), FCML_MI(0xc4, 0xe2, 0x49, 0x0d, 0x00));
    FCML_I32_M("vpermilpd xmm0,xmm6,xmm0", 2, FCML_MI(0x62, 0xf2, 0xcd, 0x08, 0x0d, 0xc0), FCML_MI(0xc4, 0xe2, 0x49, 0x0d, 0xc0));
    FCML_I64_M("vpermilpd ymm0,ymm6,ymmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0xcd, 0x28, 0x0d, 0x00), FCML_MI(0xc4, 0xe2, 0x4d, 0x0d, 0x00));

    FCML_I32_M("vpermilpd xmm0,xmmword ptr [eax],0ffh", 2, FCML_MI(0x62, 0xf3, 0xfd, 0x08, 0x05, 0x00, 0xff), FCML_MI(0xc4, 0xe3, 0x79, 0x05, 0x00, 0xff));
    FCML_I32_M("vpermilpd xmm0,xmm0,0ffh", 2, FCML_MI(0x62, 0xf3, 0xfd, 0x08, 0x05, 0xc0, 0xff), FCML_MI(0xc4, 0xe3, 0x79, 0x05, 0xc0, 0xff));
    FCML_I64_M("vpermilpd ymm0,ymmword ptr [rax],0ffh", 2, FCML_MI(0x62, 0xf3, 0xfd, 0x28, 0x05, 0x00, 0xff), FCML_MI(0xc4, 0xe3, 0x7d, 0x05, 0x00, 0xff));

    FCML_I64("vpermilpd zmm0,zmmword ptr [rax],0ffh", 0x62, 0xf3, 0xfd, 0x48, 0x05, 0x00, 0xff);
    FCML_I32_M("vpermilpd xmm0,xmmword ptr [eax],0ffh", 2, FCML_MI(0x62, 0xf3, 0xfd, 0x08, 0x05, 0x00, 0xff), FCML_MI(0xc4, 0xe3, 0x79, 0x05, 0x00, 0xff));
    FCML_I32("vpermilpd xmm0{k2},xmm0,0ffh", 0x62, 0xf3, 0xfd, 0x0a, 0x05, 0xc0, 0xff);
    FCML_I64("vpermilpd ymm0{k1},ymmword ptr [rax],0ffh", 0x62, 0xf3, 0xfd, 0x29, 0x05, 0x00, 0xff);
    FCML_I64("vpermilpd zmm0{k4}{z},zmmword ptr [rax],0ffh", 0x62, 0xf3, 0xfd, 0xcc, 0x05, 0x00, 0xff);

    FCML_A64_M("vpermilpd (%rax),%xmm6,%xmm0", 2, FCML_MI(0x62, 0xf2, 0xcd, 0x08, 0x0d, 0x00), FCML_MI(0xc4, 0xe2, 0x49, 0x0d, 0x00));
    FCML_A64_M("vpermilpd %xmm0,%xmm6,%xmm0", 2, FCML_MI(0x62, 0xf2, 0xcd, 0x08, 0x0d, 0xc0), FCML_MI(0xc4, 0xe2, 0x49, 0x0d, 0xc0));
    FCML_A64_M("vpermilpd (%rax),%ymm6,%ymm0", 2, FCML_MI(0x62, 0xf2, 0xcd, 0x28, 0x0d, 0x00), FCML_MI(0xc4, 0xe2, 0x4d, 0x0d, 0x00));
    FCML_A64_M("vpermilpd $0xff,(%rax),%xmm0", 2, FCML_MI(0x62, 0xf3, 0xfd, 0x08, 0x05, 0x00, 0xff), FCML_MI(0xc4, 0xe3, 0x79, 0x05, 0x00, 0xff));
    FCML_A64_M("vpermilpd $0xff,%xmm0,%xmm0", 2, FCML_MI(0x62, 0xf3, 0xfd, 0x08, 0x05, 0xc0, 0xff), FCML_MI(0xc4, 0xe3, 0x79, 0x05, 0xc0, 0xff));
    FCML_A64_M("vpermilpd $0xff,(%rax),%ymm0", 2, FCML_MI(0x62, 0xf3, 0xfd, 0x28, 0x05, 0x00, 0xff), FCML_MI(0xc4, 0xe3, 0x7d, 0x05, 0x00, 0xff));

    /* xmm1, xmm2, m128 */
    FCML_A64_M("vpermilpd (%rax),%xmm7,%xmm15", 2, FCML_MI(0x62, 0x72, 0xc5, 0x08, 0x0d, 0x38), FCML_MI(0xc4, 0x62, 0x41, 0x0d, 0x38));
    FCML_I64_M("vpermilpd xmm15,xmm7,xmmword ptr [rax]", 2, FCML_MI(0x62, 0x72, 0xc5, 0x08, 0x0d, 0x38), FCML_MI(0xc4, 0x62, 0x41, 0x0d, 0x38));
    FCML_A32_M("vpermilpd (%eax),%xmm6,%xmm7", 2, FCML_MI(0x62, 0xf2, 0xcd, 0x08, 0x0d, 0x38), FCML_MI(0xc4, 0xe2, 0x49, 0x0d, 0x38));
    FCML_I32_M("vpermilpd xmm7,xmm6,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0xcd, 0x08, 0x0d, 0x38), FCML_MI(0xc4, 0xe2, 0x49, 0x0d, 0x38));
    /* ymm1, ymm2, m256 */
    FCML_A64_M("vpermilpd (%rax),%ymm7,%ymm15", 2, FCML_MI(0x62, 0x72, 0xc5, 0x28, 0x0d, 0x38), FCML_MI(0xc4, 0x62, 0x45, 0x0d, 0x38));
    FCML_I64_M("vpermilpd ymm15,ymm7,ymmword ptr [rax]", 2, FCML_MI(0x62, 0x72, 0xc5, 0x28, 0x0d, 0x38), FCML_MI(0xc4, 0x62, 0x45, 0x0d, 0x38));
    FCML_A32_M("vpermilpd (%eax),%ymm5,%ymm7", 2, FCML_MI(0x62, 0xf2, 0xd5, 0x28, 0x0d, 0x38), FCML_MI(0xc4, 0xe2, 0x55, 0x0d, 0x38));
    FCML_I32_M("vpermilpd ymm7,ymm5,ymmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0xd5, 0x28, 0x0d, 0x38), FCML_MI(0xc4, 0xe2, 0x55, 0x0d, 0x38));
    /* zmm1, zmm2, m512 */
    FCML_A64("vpermilpd (%rax),%zmm7,%zmm15", 0x62, 0x72, 0xc5, 0x48, 0x0d, 0x38);
    FCML_I64("vpermilpd zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x72, 0xc5, 0x48, 0x0d, 0x38);
    FCML_A32("vpermilpd (%eax),%zmm3,%zmm7", 0x62, 0xf2, 0xe5, 0x48, 0x0d, 0x38);
    FCML_I32("vpermilpd zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf2, 0xe5, 0x48, 0x0d, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64_M("vpermilpd %xmm1,%xmm7,%xmm15", 2, FCML_MI(0x62, 0x72, 0xc5, 0x08, 0x0d, 0xf9), FCML_MI(0xc4, 0x62, 0x41, 0x0d, 0xf9));
    FCML_I64_M("vpermilpd xmm15,xmm7,xmm1", 2, FCML_MI(0x62, 0x72, 0xc5, 0x08, 0x0d, 0xf9), FCML_MI(0xc4, 0x62, 0x41, 0x0d, 0xf9));
    FCML_A32_M("vpermilpd %xmm1,%xmm2,%xmm7", 2, FCML_MI(0x62, 0xf2, 0xed, 0x08, 0x0d, 0xf9), FCML_MI(0xc4, 0xe2, 0x69, 0x0d, 0xf9));
    FCML_I32_M("vpermilpd xmm7,xmm2,xmm1", 2, FCML_MI(0x62, 0xf2, 0xed, 0x08, 0x0d, 0xf9), FCML_MI(0xc4, 0xe2, 0x69, 0x0d, 0xf9));
    /* ymm1, ymm2, ymm3 */
    FCML_A64_M("vpermilpd %ymm6,%ymm7,%ymm14", 2, FCML_MI(0x62, 0x72, 0xc5, 0x28, 0x0d, 0xf6), FCML_MI(0xc4, 0x62, 0x45, 0x0d, 0xf6));
    FCML_I64_M("vpermilpd ymm14,ymm7,ymm6", 2, FCML_MI(0x62, 0x72, 0xc5, 0x28, 0x0d, 0xf6), FCML_MI(0xc4, 0x62, 0x45, 0x0d, 0xf6));
    FCML_A32_M("vpermilpd %ymm5,%ymm3,%ymm6", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0x0d, 0xf5), FCML_MI(0xc4, 0xe2, 0x65, 0x0d, 0xf5));
    FCML_I32_M("vpermilpd ymm6,ymm3,ymm5", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0x0d, 0xf5), FCML_MI(0xc4, 0xe2, 0x65, 0x0d, 0xf5));
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpermilpd %zmm4,%zmm15,%zmm6", 0x62, 0xf2, 0x85, 0x48, 0x0d, 0xf4);
    FCML_I64("vpermilpd zmm6,zmm15,zmm4", 0x62, 0xf2, 0x85, 0x48, 0x0d, 0xf4);
    FCML_A32("vpermilpd %zmm4,%zmm6,%zmm6", 0x62, 0xf2, 0xcd, 0x48, 0x0d, 0xf4);
    FCML_I32("vpermilpd zmm6,zmm6,zmm4", 0x62, 0xf2, 0xcd, 0x48, 0x0d, 0xf4);
    /* disp8 */
    FCML_I32("vpermilpd zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf2, 0xed, 0x48, 0x0d, 0x4c, 0x24, 0x08);
    FCML_A32("vpermilpd 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x48, 0x0d, 0x4c, 0x24, 0x08);
    FCML_I64("vpermilpd zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf2, 0xed, 0x48, 0x0d, 0x4c, 0x24, 0x08);
    FCML_A64("vpermilpd 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x48, 0x0d, 0x4c, 0x24, 0x08);
    FCML_I32_M("vpermilpd ymm1,ymm2,ymmword ptr [esp+00000100h]", 2, FCML_MI(0x62, 0xf2, 0xed, 0x28, 0x0d, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x6d, 0x0d, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A32_M("vpermilpd 0x00000100(%esp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf2, 0xed, 0x28, 0x0d, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x6d, 0x0d, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I64_M("vpermilpd ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 2, FCML_MI(0x62, 0xf2, 0xed, 0x28, 0x0d, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x6d, 0x0d, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A64_M("vpermilpd 0x0000000000000100(%rsp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf2, 0xed, 0x28, 0x0d, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x6d, 0x0d, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I32_M("vpermilpd xmm1,xmm2,xmmword ptr [esp+00000080h]", 2, FCML_MI(0x62, 0xf2, 0xed, 0x08, 0x0d, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x69, 0x0d, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A32_M("vpermilpd 0x00000080(%esp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf2, 0xed, 0x08, 0x0d, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x69, 0x0d, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_I64_M("vpermilpd xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 2, FCML_MI(0x62, 0xf2, 0xed, 0x08, 0x0d, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x69, 0x0d, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A64_M("vpermilpd 0x0000000000000080(%rsp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf2, 0xed, 0x08, 0x0d, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x69, 0x0d, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    /* {k}{z} */
    FCML_A64("vpermilpd (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x12, 0x8d, 0x8c, 0x0d, 0x14, 0x01);
    FCML_I64("vpermilpd xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x8c, 0x0d, 0x14, 0x01);
    FCML_A32("vpermilpd (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0x8d, 0x0d, 0x14, 0x01);
    FCML_I32("vpermilpd xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x8d, 0x0d, 0x14, 0x01);
    FCML_A64("vpermilpd (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x12, 0x8d, 0xac, 0x0d, 0x14, 0x01);
    FCML_I64("vpermilpd ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0xac, 0x0d, 0x14, 0x01);
    FCML_A32("vpermilpd (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0xad, 0x0d, 0x14, 0x01);
    FCML_I32("vpermilpd ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0xad, 0x0d, 0x14, 0x01);
    FCML_A64("vpermilpd (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x12, 0x8d, 0xcc, 0x0d, 0x14, 0x01);
    FCML_I64("vpermilpd zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0xcc, 0x0d, 0x14, 0x01);
    FCML_A32("vpermilpd (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0xcd, 0x0d, 0x14, 0x01);
    FCML_I32("vpermilpd zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0xcd, 0x0d, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpermilpd (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x12, 0x8d, 0x0c, 0x0d, 0x14, 0x01);
    FCML_I64("vpermilpd xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x0c, 0x0d, 0x14, 0x01);
    FCML_A32("vpermilpd (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf2, 0xc5, 0x0d, 0x0d, 0x14, 0x01);
    FCML_I32("vpermilpd xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x0d, 0x0d, 0x14, 0x01);
    FCML_A64("vpermilpd (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x12, 0x8d, 0x2c, 0x0d, 0x14, 0x01);
    FCML_I64("vpermilpd ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x2c, 0x0d, 0x14, 0x01);
    FCML_A32("vpermilpd (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf2, 0xc5, 0x2d, 0x0d, 0x14, 0x01);
    FCML_I32("vpermilpd ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x2d, 0x0d, 0x14, 0x01);
    FCML_A64("vpermilpd (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x12, 0x8d, 0x4c, 0x0d, 0x14, 0x01);
    FCML_I64("vpermilpd zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x4c, 0x0d, 0x14, 0x01);
    FCML_A32("vpermilpd (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf2, 0xc5, 0x4d, 0x0d, 0x14, 0x01);
    FCML_I32("vpermilpd zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x4d, 0x0d, 0x14, 0x01);
    /* bcast */
    FCML_I64("vpermilpd zmm31,zmm21,mmword ptr [rsi]{1to8}", 0x62, 0x62, 0xd5, 0x50, 0x0d, 0x3e);
    FCML_A64("vpermilpd (%rsi){1to8},%zmm21,%zmm31", 0x62, 0x62, 0xd5, 0x50, 0x0d, 0x3e);
    FCML_I64("vpermilpd ymm31,ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x62, 0xd5, 0x30, 0x0d, 0x3e);
    FCML_A64("vpermilpd (%rsi){1to4},%ymm21,%ymm31", 0x62, 0x62, 0xd5, 0x30, 0x0d, 0x3e);
    FCML_I64("vpermilpd xmm31,xmm21,mmword ptr [rsi]{1to2}", 0x62, 0x62, 0xd5, 0x10, 0x0d, 0x3e);
    FCML_A64("vpermilpd (%rsi){1to2},%xmm21,%xmm31", 0x62, 0x62, 0xd5, 0x10, 0x0d, 0x3e);
    FCML_A32("vpermilpd (%esi){1to8},%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x58, 0x0d, 0x0e);
    FCML_I32("vpermilpd zmm1,zmm2,mmword ptr [esi]{1to8}", 0x62, 0xf2, 0xed, 0x58, 0x0d, 0x0e);
    /* {k}{z}{bcast} */
    FCML_A64("vpermilpd (%rsi){1to4},%ymm21,%ymm31{%k7}{z}", 0x62, 0x62, 0xd5, 0xb7, 0x0d, 0x3e);
    FCML_I64("vpermilpd ymm31{k7}{z},ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x62, 0xd5, 0xb7, 0x0d, 0x3e);
    /* {bcast} disp8 */
    FCML_I32("vpermilpd zmm1,zmm2,mmword ptr [esp+00000040h]{1to8}", 0x62, 0xf2, 0xed, 0x58, 0x0d, 0x4c, 0x24, 0x08);
    FCML_A32("vpermilpd 0x00000040(%esp){1to8},%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x58, 0x0d, 0x4c, 0x24, 0x08);
    FCML_I64("vpermilpd zmm1,zmm2,mmword ptr [rsp+0000000000000040h]{1to8}", 0x62, 0xf2, 0xed, 0x58, 0x0d, 0x4c, 0x24, 0x08);
    FCML_A64("vpermilpd 0x0000000000000040(%rsp){1to8},%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x58, 0x0d, 0x4c, 0x24, 0x08);
    FCML_I32("vpermilpd ymm1,ymm2,mmword ptr [esp+00000040h]{1to4}", 0x62, 0xf2, 0xed, 0x38, 0x0d, 0x4c, 0x24, 0x08);
    FCML_A32("vpermilpd 0x00000040(%esp){1to4},%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x38, 0x0d, 0x4c, 0x24, 0x08);
    FCML_I64("vpermilpd ymm1,ymm2,mmword ptr [rsp+0000000000000040h]{1to4}", 0x62, 0xf2, 0xed, 0x38, 0x0d, 0x4c, 0x24, 0x08);
    FCML_A64("vpermilpd 0x0000000000000040(%rsp){1to4},%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x38, 0x0d, 0x4c, 0x24, 0x08);
    FCML_I32("vpermilpd xmm1,xmm2,mmword ptr [esp+00000040h]{1to2}", 0x62, 0xf2, 0xed, 0x18, 0x0d, 0x4c, 0x24, 0x08);
    FCML_A32("vpermilpd 0x00000040(%esp){1to2},%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x18, 0x0d, 0x4c, 0x24, 0x08);
    FCML_I64("vpermilpd xmm1,xmm2,mmword ptr [rsp+0000000000000040h]{1to2}", 0x62, 0xf2, 0xed, 0x18, 0x0d, 0x4c, 0x24, 0x08);
    FCML_A64("vpermilpd 0x0000000000000040(%rsp){1to2},%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x18, 0x0d, 0x4c, 0x24, 0x08);
}

void fcml_tf_instruction_VPERMILPS(void) {
    FCML_I32_M("vpermilps xmm0,xmm6,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x4d, 0x08, 0x0c, 0x00), FCML_MI(0xc4, 0xe2, 0x49, 0x0c, 0x00));
    FCML_I32_M("vpermilps xmm0,xmm6,xmm0", 2, FCML_MI(0x62, 0xf2, 0x4d, 0x08, 0x0c, 0xc0), FCML_MI(0xc4, 0xe2, 0x49, 0x0c, 0xc0));
    FCML_I64_M("vpermilps ymm0,ymm6,ymmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0x4d, 0x28, 0x0c, 0x00), FCML_MI(0xc4, 0xe2, 0x4d, 0x0c, 0x00));
    FCML_I32_M("vpermilps xmm0,xmmword ptr [eax],0ffh", 2, FCML_MI(0x62, 0xf3, 0x7d, 0x08, 0x04, 0x00, 0xff), FCML_MI(0xc4, 0xe3, 0x79, 0x04, 0x00, 0xff));
    FCML_I32_M("vpermilps xmm0,xmm0,0ffh", 2, FCML_MI(0x62, 0xf3, 0x7d, 0x08, 0x04, 0xc0, 0xff), FCML_MI(0xc4, 0xe3, 0x79, 0x04, 0xc0, 0xff));
    FCML_I64_M("vpermilps ymm0,ymmword ptr [rax],0ffh", 2, FCML_MI(0x62, 0xf3, 0x7d, 0x28, 0x04, 0x00, 0xff), FCML_MI(0xc4, 0xe3, 0x7d, 0x04, 0x00, 0xff));
    FCML_A64_M("vpermilps (%rax),%xmm6,%xmm0", 2, FCML_MI(0x62, 0xf2, 0x4d, 0x08, 0x0c, 0x00), FCML_MI(0xc4, 0xe2, 0x49, 0x0c, 0x00));
    FCML_A64_M("vpermilps %xmm0,%xmm6,%xmm0", 2, FCML_MI(0x62, 0xf2, 0x4d, 0x08, 0x0c, 0xc0), FCML_MI(0xc4, 0xe2, 0x49, 0x0c, 0xc0));
    FCML_A64_M("vpermilps (%rax),%ymm6,%ymm0", 2, FCML_MI(0x62, 0xf2, 0x4d, 0x28, 0x0c, 0x00), FCML_MI(0xc4, 0xe2, 0x4d, 0x0c, 0x00));
    FCML_A64_M("vpermilps $0xff,(%rax),%xmm0", 2, FCML_MI(0x62, 0xf3, 0x7d, 0x08, 0x04, 0x00, 0xff), FCML_MI(0xc4, 0xe3, 0x79, 0x04, 0x00, 0xff));
    FCML_A64_M("vpermilps $0xff,%xmm0,%xmm0", 2, FCML_MI(0x62, 0xf3, 0x7d, 0x08, 0x04, 0xc0, 0xff), FCML_MI(0xc4, 0xe3, 0x79, 0x04, 0xc0, 0xff));
    FCML_A64_M("vpermilps $0xff,(%rax),%ymm0", 2, FCML_MI(0x62, 0xf3, 0x7d, 0x28, 0x04, 0x00, 0xff), FCML_MI(0xc4, 0xe3, 0x7d, 0x04, 0x00, 0xff));
    /* xmm1, xmm2, m128 */
    FCML_A64_M("vpermilps (%rax),%xmm7,%xmm15", 2, FCML_MI(0x62, 0x72, 0x45, 0x08, 0x0c, 0x38), FCML_MI(0xc4, 0x62, 0x41, 0x0c, 0x38));
    FCML_I64_M("vpermilps xmm15,xmm7,xmmword ptr [rax]", 2, FCML_MI(0x62, 0x72, 0x45, 0x08, 0x0c, 0x38), FCML_MI(0xc4, 0x62, 0x41, 0x0c, 0x38));
    FCML_A32_M("vpermilps (%eax),%xmm6,%xmm7", 2, FCML_MI(0x62, 0xf2, 0x4d, 0x08, 0x0c, 0x38), FCML_MI(0xc4, 0xe2, 0x49, 0x0c, 0x38));
    FCML_I32_M("vpermilps xmm7,xmm6,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x4d, 0x08, 0x0c, 0x38), FCML_MI(0xc4, 0xe2, 0x49, 0x0c, 0x38));
    /* ymm1, ymm2, m256 */
    FCML_A64_M("vpermilps (%rax),%ymm7,%ymm15", 2, FCML_MI(0x62, 0x72, 0x45, 0x28, 0x0c, 0x38), FCML_MI(0xc4, 0x62, 0x45, 0x0c, 0x38));
    FCML_I64_M("vpermilps ymm15,ymm7,ymmword ptr [rax]", 2, FCML_MI(0x62, 0x72, 0x45, 0x28, 0x0c, 0x38), FCML_MI(0xc4, 0x62, 0x45, 0x0c, 0x38));
    FCML_A32_M("vpermilps (%eax),%ymm5,%ymm7", 2, FCML_MI(0x62, 0xf2, 0x55, 0x28, 0x0c, 0x38), FCML_MI(0xc4, 0xe2, 0x55, 0x0c, 0x38));
    FCML_I32_M("vpermilps ymm7,ymm5,ymmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x55, 0x28, 0x0c, 0x38), FCML_MI(0xc4, 0xe2, 0x55, 0x0c, 0x38));
    /* zmm1, zmm2, m512 */
    FCML_A64("vpermilps (%rax),%zmm7,%zmm15", 0x62, 0x72, 0x45, 0x48, 0x0c, 0x38);
    FCML_I64("vpermilps zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x72, 0x45, 0x48, 0x0c, 0x38);
    FCML_A32("vpermilps (%eax),%zmm3,%zmm7", 0x62, 0xf2, 0x65, 0x48, 0x0c, 0x38);
    FCML_I32("vpermilps zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf2, 0x65, 0x48, 0x0c, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64_M("vpermilps (%rax),%xmm7,%xmm15", 2, FCML_MI(0x62, 0x72, 0x45, 0x08, 0x0c, 0x38), FCML_MI(0xc4, 0x62, 0x41, 0x0c, 0x38));
    FCML_I64_M("vpermilps xmm15,xmm7,xmmword ptr [rax]", 2, FCML_MI(0x62, 0x72, 0x45, 0x08, 0x0c, 0x38), FCML_MI(0xc4, 0x62, 0x41, 0x0c, 0x38));
    FCML_A32_M("vpermilps (%eax),%xmm6,%xmm7", 2, FCML_MI(0x62, 0xf2, 0x4d, 0x08, 0x0c, 0x38), FCML_MI(0xc4, 0xe2, 0x49, 0x0c, 0x38));
    FCML_I32_M("vpermilps xmm7,xmm6,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x4d, 0x08, 0x0c, 0x38), FCML_MI(0xc4, 0xe2, 0x49, 0x0c, 0x38));
    /* ymm1, ymm2, ymm3 */
    FCML_A64_M("vpermilps %xmm1,%xmm7,%xmm15", 2, FCML_MI(0x62, 0x72, 0x45, 0x08, 0x0c, 0xf9), FCML_MI(0xc4, 0x62, 0x41, 0x0c, 0xf9));
    FCML_I64_M("vpermilps xmm15,xmm7,xmm1", 2, FCML_MI(0x62, 0x72, 0x45, 0x08, 0x0c, 0xf9), FCML_MI(0xc4, 0x62, 0x41, 0x0c, 0xf9));
    FCML_A32_M("vpermilps %xmm1,%xmm2,%xmm7", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x0c, 0xf9), FCML_MI(0xc4, 0xe2, 0x69, 0x0c, 0xf9));
    FCML_I32_M("vpermilps xmm7,xmm2,xmm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x0c, 0xf9), FCML_MI(0xc4, 0xe2, 0x69, 0x0c, 0xf9));
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpermilps %zmm4,%zmm15,%zmm6", 0x62, 0xf2, 0x05, 0x48, 0x0c, 0xf4);
    FCML_I64("vpermilps zmm6,zmm15,zmm4", 0x62, 0xf2, 0x05, 0x48, 0x0c, 0xf4);
    FCML_A32("vpermilps %zmm4,%zmm6,%zmm6", 0x62, 0xf2, 0x4d, 0x48, 0x0c, 0xf4);
    FCML_I32("vpermilps zmm6,zmm6,zmm4", 0x62, 0xf2, 0x4d, 0x48, 0x0c, 0xf4);
    /* disp8 */
    FCML_I32("vpermilps zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf2, 0x6d, 0x48, 0x0c, 0x4c, 0x24, 0x08);
    FCML_A32("vpermilps 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x48, 0x0c, 0x4c, 0x24, 0x08);
    FCML_I64("vpermilps zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf2, 0x6d, 0x48, 0x0c, 0x4c, 0x24, 0x08);
    FCML_A64("vpermilps 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x48, 0x0c, 0x4c, 0x24, 0x08);
    FCML_I32_M("vpermilps ymm1,ymm2,ymmword ptr [esp+00000100h]", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x28, 0x0c, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x6d, 0x0c, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A32_M("vpermilps 0x00000100(%esp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x28, 0x0c, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x6d, 0x0c, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I64_M("vpermilps ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x28, 0x0c, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x6d, 0x0c, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A64_M("vpermilps 0x0000000000000100(%rsp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x28, 0x0c, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x6d, 0x0c, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I32_M("vpermilps xmm1,xmm2,xmmword ptr [esp+00000080h]", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x0c, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x69, 0x0c, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A32_M("vpermilps 0x00000080(%esp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x0c, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x69, 0x0c, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_I64_M("vpermilps xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x0c, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x69, 0x0c, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A64_M("vpermilps 0x0000000000000080(%rsp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x0c, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x69, 0x0c, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    /* {k}{z} */
    FCML_A64("vpermilps (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x12, 0x0d, 0x8c, 0x0c, 0x14, 0x01);
    FCML_I64("vpermilps xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x8c, 0x0c, 0x14, 0x01);
    FCML_A32("vpermilps (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf2, 0x45, 0x8d, 0x0c, 0x14, 0x01);
    FCML_I32("vpermilps xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x8d, 0x0c, 0x14, 0x01);
    FCML_A64("vpermilps (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x12, 0x0d, 0xac, 0x0c, 0x14, 0x01);
    FCML_I64("vpermilps ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0xac, 0x0c, 0x14, 0x01);
    FCML_A32("vpermilps (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf2, 0x45, 0xad, 0x0c, 0x14, 0x01);
    FCML_I32("vpermilps ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0xad, 0x0c, 0x14, 0x01);
    FCML_A64("vpermilps (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x12, 0x0d, 0xcc, 0x0c, 0x14, 0x01);
    FCML_I64("vpermilps zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0xcc, 0x0c, 0x14, 0x01);
    FCML_A32("vpermilps (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf2, 0x45, 0xcd, 0x0c, 0x14, 0x01);
    FCML_I32("vpermilps zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0xcd, 0x0c, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpermilps (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x12, 0x0d, 0x0c, 0x0c, 0x14, 0x01);
    FCML_I64("vpermilps xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x0c, 0x0c, 0x14, 0x01);
    FCML_A32("vpermilps (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf2, 0x45, 0x0d, 0x0c, 0x14, 0x01);
    FCML_I32("vpermilps xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x0d, 0x0c, 0x14, 0x01);
    FCML_A64("vpermilps (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x12, 0x0d, 0x2c, 0x0c, 0x14, 0x01);
    FCML_I64("vpermilps ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x2c, 0x0c, 0x14, 0x01);
    FCML_A32("vpermilps (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf2, 0x45, 0x2d, 0x0c, 0x14, 0x01);
    FCML_I32("vpermilps ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x2d, 0x0c, 0x14, 0x01);
    FCML_A64("vpermilps (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x12, 0x0d, 0x4c, 0x0c, 0x14, 0x01);
    FCML_I64("vpermilps zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x4c, 0x0c, 0x14, 0x01);
    FCML_A32("vpermilps (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf2, 0x45, 0x4d, 0x0c, 0x14, 0x01);
    FCML_I32("vpermilps zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x4d, 0x0c, 0x14, 0x01);
    /* bcast */
    FCML_I64("vpermilps zmm31,zmm21,dword ptr [rsi]{1to16}", 0x62, 0x62, 0x55, 0x50, 0x0c, 0x3e);
    FCML_A64("vpermilps (%rsi){1to16},%zmm21,%zmm31", 0x62, 0x62, 0x55, 0x50, 0x0c, 0x3e);
    FCML_I64("vpermilps ymm31,ymm21,dword ptr [rsi]{1to8}", 0x62, 0x62, 0x55, 0x30, 0x0c, 0x3e);
    FCML_A64("vpermilps (%rsi){1to8},%ymm21,%ymm31", 0x62, 0x62, 0x55, 0x30, 0x0c, 0x3e);
    FCML_I64("vpermilps xmm31,xmm21,dword ptr [rsi]{1to4}", 0x62, 0x62, 0x55, 0x10, 0x0c, 0x3e);
    FCML_A64("vpermilps (%rsi){1to4},%xmm21,%xmm31", 0x62, 0x62, 0x55, 0x10, 0x0c, 0x3e);
    FCML_A32("vpermilps (%esi){1to16},%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x58, 0x0c, 0x0e);
    FCML_I32("vpermilps zmm1,zmm2,dword ptr [esi]{1to16}", 0x62, 0xf2, 0x6d, 0x58, 0x0c, 0x0e);
    /* {k}{z}{bcast} */
    FCML_A64("vpermilps (%rsi){1to8},%ymm21,%ymm31{%k7}{z}", 0x62, 0x62, 0x55, 0xb7, 0x0c, 0x3e);
    FCML_I64("vpermilps ymm31{k7}{z},ymm21,dword ptr [rsi]{1to8}", 0x62, 0x62, 0x55, 0xb7, 0x0c, 0x3e);
    /* {bcast} disp8 */
    FCML_I32("vpermilps zmm1,zmm2,dword ptr [esp+00000020h]{1to16}", 0x62, 0xf2, 0x6d, 0x58, 0x0c, 0x4c, 0x24, 0x08);
    FCML_A32("vpermilps 0x00000020(%esp){1to16},%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x58, 0x0c, 0x4c, 0x24, 0x08);
    FCML_I64("vpermilps zmm1,zmm2,dword ptr [rsp+0000000000000020h]{1to16}", 0x62, 0xf2, 0x6d, 0x58, 0x0c, 0x4c, 0x24, 0x08);
    FCML_A64("vpermilps 0x0000000000000020(%rsp){1to16},%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x58, 0x0c, 0x4c, 0x24, 0x08);
    FCML_I32("vpermilps ymm1,ymm2,dword ptr [esp+00000020h]{1to8}", 0x62, 0xf2, 0x6d, 0x38, 0x0c, 0x4c, 0x24, 0x08);
    FCML_A32("vpermilps 0x00000020(%esp){1to8},%ymm2,%ymm1", 0x62, 0xf2, 0x6d, 0x38, 0x0c, 0x4c, 0x24, 0x08);
    FCML_I64("vpermilps ymm1,ymm2,dword ptr [rsp+0000000000000020h]{1to8}", 0x62, 0xf2, 0x6d, 0x38, 0x0c, 0x4c, 0x24, 0x08);
    FCML_A64("vpermilps 0x0000000000000020(%rsp){1to8},%ymm2,%ymm1", 0x62, 0xf2, 0x6d, 0x38, 0x0c, 0x4c, 0x24, 0x08);
    FCML_I32("vpermilps xmm1,xmm2,dword ptr [esp+00000020h]{1to4}", 0x62, 0xf2, 0x6d, 0x18, 0x0c, 0x4c, 0x24, 0x08);
    FCML_A32("vpermilps 0x00000020(%esp){1to4},%xmm2,%xmm1", 0x62, 0xf2, 0x6d, 0x18, 0x0c, 0x4c, 0x24, 0x08);
    FCML_I64("vpermilps xmm1,xmm2,dword ptr [rsp+0000000000000020h]{1to4}", 0x62, 0xf2, 0x6d, 0x18, 0x0c, 0x4c, 0x24, 0x08);
    FCML_A64("vpermilps 0x0000000000000020(%rsp){1to4},%xmm2,%xmm1", 0x62, 0xf2, 0x6d, 0x18, 0x0c, 0x4c, 0x24, 0x08);
}

void fcml_tf_instruction_VPSLLVD(void) {
    FCML_I32_M("vpsllvd xmm0,xmm6,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x4d, 0x08, 0x47, 0x00), FCML_MI(0xc4, 0xe2, 0x49, 0x47, 0x00));
    FCML_I32_M("vpsllvd ymm0,ymm6,ymmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x4d, 0x28, 0x47, 0x00), FCML_MI(0xc4, 0xe2, 0x4d, 0x47, 0x00));
    FCML_I32_M("vpsllvd ymm0,ymm6,ymm0", 2, FCML_MI(0x62, 0xf2, 0x4d, 0x28, 0x47, 0xc0), FCML_MI(0xc4, 0xe2, 0x4d, 0x47, 0xc0));
    FCML_A64_M("vpsllvd (%rax),%xmm6,%xmm0", 2, FCML_MI(0x62, 0xf2, 0x4d, 0x08, 0x47, 0x00), FCML_MI(0xc4, 0xe2, 0x49, 0x47, 0x00));
    FCML_A64_M("vpsllvd (%rax),%ymm6,%ymm0", 2, FCML_MI(0x62, 0xf2, 0x4d, 0x28, 0x47, 0x00), FCML_MI(0xc4, 0xe2, 0x4d, 0x47, 0x00));

    /* xmm1, xmm2, m128 */
    FCML_A64_M("vpsllvd (%rax),%xmm7,%xmm15", 2, FCML_MI(0x62, 0x72, 0x45, 0x08, 0x47, 0x38), FCML_MI(0xc4, 0x62, 0x41, 0x47, 0x38));
    FCML_I64_M("vpsllvd xmm15,xmm7,xmmword ptr [rax]", 2, FCML_MI(0x62, 0x72, 0x45, 0x08, 0x47, 0x38), FCML_MI(0xc4, 0x62, 0x41, 0x47, 0x38));
    FCML_A32_M("vpsllvd (%eax),%xmm6,%xmm7", 2, FCML_MI(0x62, 0xf2, 0x4d, 0x08, 0x47, 0x38), FCML_MI(0xc4, 0xe2, 0x49, 0x47, 0x38));
    FCML_I32_M("vpsllvd xmm7,xmm6,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x4d, 0x08, 0x47, 0x38), FCML_MI(0xc4, 0xe2, 0x49, 0x47, 0x38));
    /* ymm1, ymm2, m256 */
    FCML_A64_M("vpsllvd (%rax),%ymm7,%ymm15", 2, FCML_MI(0x62, 0x72, 0x45, 0x28, 0x47, 0x38), FCML_MI(0xc4, 0x62, 0x45, 0x47, 0x38));
    FCML_I64_M("vpsllvd ymm15,ymm7,ymmword ptr [rax]", 2, FCML_MI(0x62, 0x72, 0x45, 0x28, 0x47, 0x38), FCML_MI(0xc4, 0x62, 0x45, 0x47, 0x38));
    FCML_A32_M("vpsllvd (%eax),%ymm5,%ymm7", 2, FCML_MI(0x62, 0xf2, 0x55, 0x28, 0x47, 0x38), FCML_MI(0xc4, 0xe2, 0x55, 0x47, 0x38));
    FCML_I32_M("vpsllvd ymm7,ymm5,ymmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x55, 0x28, 0x47, 0x38), FCML_MI(0xc4, 0xe2, 0x55, 0x47, 0x38));
    /* zmm1, zmm2, m512 */
    FCML_A64("vpsllvd (%rax),%zmm7,%zmm15", 0x62, 0x72, 0x45, 0x48, 0x47, 0x38);
    FCML_I64("vpsllvd zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x72, 0x45, 0x48, 0x47, 0x38);
    FCML_A32("vpsllvd (%eax),%zmm3,%zmm7", 0x62, 0xf2, 0x65, 0x48, 0x47, 0x38);
    FCML_I32("vpsllvd zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf2, 0x65, 0x48, 0x47, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64_M("vpsllvd %xmm1,%xmm7,%xmm15", 2, FCML_MI(0x62, 0x72, 0x45, 0x08, 0x47, 0xf9), FCML_MI(0xc4, 0x62, 0x41, 0x47, 0xf9));
    FCML_I64_M("vpsllvd xmm15,xmm7,xmm1", 2, FCML_MI(0x62, 0x72, 0x45, 0x08, 0x47, 0xf9), FCML_MI(0xc4, 0x62, 0x41, 0x47, 0xf9));
    FCML_A32_M("vpsllvd %xmm1,%xmm2,%xmm7", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x47, 0xf9), FCML_MI(0xc4, 0xe2, 0x69, 0x47, 0xf9));
    FCML_I32_M("vpsllvd xmm7,xmm2,xmm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x47, 0xf9), FCML_MI(0xc4, 0xe2, 0x69, 0x47, 0xf9));
    /* ymm1, ymm2, ymm3 */
    FCML_A64_M("vpsllvd %ymm6,%ymm7,%ymm14", 2, FCML_MI(0x62, 0x72, 0x45, 0x28, 0x47, 0xf6), FCML_MI(0xc4, 0x62, 0x45, 0x47, 0xf6));
    FCML_I64_M("vpsllvd ymm14,ymm7,ymm6", 2, FCML_MI(0x62, 0x72, 0x45, 0x28, 0x47, 0xf6), FCML_MI(0xc4, 0x62, 0x45, 0x47, 0xf6));
    FCML_A32_M("vpsllvd %ymm5,%ymm3,%ymm6", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0x47, 0xf5), FCML_MI(0xc4, 0xe2, 0x65, 0x47, 0xf5));
    FCML_I32_M("vpsllvd ymm6,ymm3,ymm5", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0x47, 0xf5), FCML_MI(0xc4, 0xe2, 0x65, 0x47, 0xf5));
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpsllvd %zmm4,%zmm15,%zmm6", 0x62, 0xf2, 0x05, 0x48, 0x47, 0xf4);
    FCML_I64("vpsllvd zmm6,zmm15,zmm4", 0x62, 0xf2, 0x05, 0x48, 0x47, 0xf4);
    FCML_A32("vpsllvd %zmm4,%zmm6,%zmm6", 0x62, 0xf2, 0x4d, 0x48, 0x47, 0xf4);
    FCML_I32("vpsllvd zmm6,zmm6,zmm4", 0x62, 0xf2, 0x4d, 0x48, 0x47, 0xf4);
    /* disp8 */
    FCML_I32("vpsllvd zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf2, 0x6d, 0x48, 0x47, 0x4c, 0x24, 0x08);
    FCML_A32("vpsllvd 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x48, 0x47, 0x4c, 0x24, 0x08);
    FCML_I64("vpsllvd zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf2, 0x6d, 0x48, 0x47, 0x4c, 0x24, 0x08);
    FCML_A64("vpsllvd 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x48, 0x47, 0x4c, 0x24, 0x08);
    FCML_I32_M("vpsllvd ymm1,ymm2,ymmword ptr [esp+00000100h]", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x28, 0x47, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x6d, 0x47, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A32_M("vpsllvd 0x00000100(%esp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x28, 0x47, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x6d, 0x47, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I64_M("vpsllvd ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x28, 0x47, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x6d, 0x47, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A64_M("vpsllvd 0x0000000000000100(%rsp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x28, 0x47, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x6d, 0x47, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I32_M("vpsllvd xmm1,xmm2,xmmword ptr [esp+00000080h]", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x47, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x69, 0x47, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A32_M("vpsllvd 0x00000080(%esp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x47, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x69, 0x47, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_I64_M("vpsllvd xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x47, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x69, 0x47, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A64_M("vpsllvd 0x0000000000000080(%rsp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x47, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x69, 0x47, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    /* {k}{z} */
    FCML_A64("vpsllvd (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x12, 0x0d, 0x8c, 0x47, 0x14, 0x01);
    FCML_I64("vpsllvd xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x8c, 0x47, 0x14, 0x01);
    FCML_A32("vpsllvd (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf2, 0x45, 0x8d, 0x47, 0x14, 0x01);
    FCML_I32("vpsllvd xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x8d, 0x47, 0x14, 0x01);
    FCML_A64("vpsllvd (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x12, 0x0d, 0xac, 0x47, 0x14, 0x01);
    FCML_I64("vpsllvd ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0xac, 0x47, 0x14, 0x01);
    FCML_A32("vpsllvd (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf2, 0x45, 0xad, 0x47, 0x14, 0x01);
    FCML_I32("vpsllvd ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0xad, 0x47, 0x14, 0x01);
    FCML_A64("vpsllvd (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x12, 0x0d, 0xcc, 0x47, 0x14, 0x01);
    FCML_I64("vpsllvd zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0xcc, 0x47, 0x14, 0x01);
    FCML_A32("vpsllvd (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf2, 0x45, 0xcd, 0x47, 0x14, 0x01);
    FCML_I32("vpsllvd zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0xcd, 0x47, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpsllvd (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x12, 0x0d, 0x0c, 0x47, 0x14, 0x01);
    FCML_I64("vpsllvd xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x0c, 0x47, 0x14, 0x01);
    FCML_A32("vpsllvd (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf2, 0x45, 0x0d, 0x47, 0x14, 0x01);
    FCML_I32("vpsllvd xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x0d, 0x47, 0x14, 0x01);
    FCML_A64("vpsllvd (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x12, 0x0d, 0x2c, 0x47, 0x14, 0x01);
    FCML_I64("vpsllvd ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x2c, 0x47, 0x14, 0x01);
    FCML_A32("vpsllvd (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf2, 0x45, 0x2d, 0x47, 0x14, 0x01);
    FCML_I32("vpsllvd ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x2d, 0x47, 0x14, 0x01);
    FCML_A64("vpsllvd (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x12, 0x0d, 0x4c, 0x47, 0x14, 0x01);
    FCML_I64("vpsllvd zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x4c, 0x47, 0x14, 0x01);
    FCML_A32("vpsllvd (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf2, 0x45, 0x4d, 0x47, 0x14, 0x01);
    FCML_I32("vpsllvd zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x4d, 0x47, 0x14, 0x01);
    /* bcast */
    FCML_I64("vpsllvd zmm31,zmm21,dword ptr [rsi]{1to16}", 0x62, 0x62, 0x55, 0x50, 0x47, 0x3e);
    FCML_A64("vpsllvd (%rsi){1to16},%zmm21,%zmm31", 0x62, 0x62, 0x55, 0x50, 0x47, 0x3e);
    FCML_I64("vpsllvd ymm31,ymm21,dword ptr [rsi]{1to8}", 0x62, 0x62, 0x55, 0x30, 0x47, 0x3e);
    FCML_A64("vpsllvd (%rsi){1to8},%ymm21,%ymm31", 0x62, 0x62, 0x55, 0x30, 0x47, 0x3e);
    FCML_I64("vpsllvd xmm31,xmm21,dword ptr [rsi]{1to4}", 0x62, 0x62, 0x55, 0x10, 0x47, 0x3e);
    FCML_A64("vpsllvd (%rsi){1to4},%xmm21,%xmm31", 0x62, 0x62, 0x55, 0x10, 0x47, 0x3e);
    FCML_A32("vpsllvd (%esi){1to16},%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x58, 0x47, 0x0e);
    FCML_I32("vpsllvd zmm1,zmm2,dword ptr [esi]{1to16}", 0x62, 0xf2, 0x6d, 0x58, 0x47, 0x0e);
    /* {k}{z}{bcast} */
    FCML_A64("vpsllvd (%rsi){1to8},%ymm21,%ymm31{%k7}{z}", 0x62, 0x62, 0x55, 0xb7, 0x47, 0x3e);
    FCML_I64("vpsllvd ymm31{k7}{z},ymm21,dword ptr [rsi]{1to8}", 0x62, 0x62, 0x55, 0xb7, 0x47, 0x3e);
    /* {bcast} disp8 */
    FCML_I32("vpsllvd zmm1,zmm2,dword ptr [esp+00000020h]{1to16}", 0x62, 0xf2, 0x6d, 0x58, 0x47, 0x4c, 0x24, 0x08);
    FCML_A32("vpsllvd 0x00000020(%esp){1to16},%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x58, 0x47, 0x4c, 0x24, 0x08);
    FCML_I64("vpsllvd zmm1,zmm2,dword ptr [rsp+0000000000000020h]{1to16}", 0x62, 0xf2, 0x6d, 0x58, 0x47, 0x4c, 0x24, 0x08);
    FCML_A64("vpsllvd 0x0000000000000020(%rsp){1to16},%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x58, 0x47, 0x4c, 0x24, 0x08);
    FCML_I32("vpsllvd ymm1,ymm2,dword ptr [esp+00000020h]{1to8}", 0x62, 0xf2, 0x6d, 0x38, 0x47, 0x4c, 0x24, 0x08);
    FCML_A32("vpsllvd 0x00000020(%esp){1to8},%ymm2,%ymm1", 0x62, 0xf2, 0x6d, 0x38, 0x47, 0x4c, 0x24, 0x08);
    FCML_I64("vpsllvd ymm1,ymm2,dword ptr [rsp+0000000000000020h]{1to8}", 0x62, 0xf2, 0x6d, 0x38, 0x47, 0x4c, 0x24, 0x08);
    FCML_A64("vpsllvd 0x0000000000000020(%rsp){1to8},%ymm2,%ymm1", 0x62, 0xf2, 0x6d, 0x38, 0x47, 0x4c, 0x24, 0x08);
    FCML_I32("vpsllvd xmm1,xmm2,dword ptr [esp+00000020h]{1to4}", 0x62, 0xf2, 0x6d, 0x18, 0x47, 0x4c, 0x24, 0x08);
    FCML_A32("vpsllvd 0x00000020(%esp){1to4},%xmm2,%xmm1", 0x62, 0xf2, 0x6d, 0x18, 0x47, 0x4c, 0x24, 0x08);
    FCML_I64("vpsllvd xmm1,xmm2,dword ptr [rsp+0000000000000020h]{1to4}", 0x62, 0xf2, 0x6d, 0x18, 0x47, 0x4c, 0x24, 0x08);
    FCML_A64("vpsllvd 0x0000000000000020(%rsp){1to4},%xmm2,%xmm1", 0x62, 0xf2, 0x6d, 0x18, 0x47, 0x4c, 0x24, 0x08);
}

void fcml_tf_instruction_VPSRLVW(void) {
    /* xmm1, xmm2, m128 */
    FCML_A64("vpsrlvw (%rax),%xmm7,%xmm15", 0x62, 0x72, 0xc5, 0x08, 0x10, 0x38);
    FCML_I64("vpsrlvw xmm15,xmm7,xmmword ptr [rax]", 0x62, 0x72, 0xc5, 0x08, 0x10, 0x38);
    FCML_A32("vpsrlvw (%eax),%xmm6,%xmm7", 0x62, 0xf2, 0xcd, 0x08, 0x10, 0x38);
    FCML_I32("vpsrlvw xmm7,xmm6,xmmword ptr [eax]", 0x62, 0xf2, 0xcd, 0x08, 0x10, 0x38);
    /* ymm1, ymm2, m256 */
    FCML_A64("vpsrlvw (%rax),%ymm7,%ymm15", 0x62, 0x72, 0xc5, 0x28, 0x10, 0x38);
    FCML_I64("vpsrlvw ymm15,ymm7,ymmword ptr [rax]", 0x62, 0x72, 0xc5, 0x28, 0x10, 0x38);
    FCML_A32("vpsrlvw (%eax),%ymm5,%ymm7", 0x62, 0xf2, 0xd5, 0x28, 0x10, 0x38);
    FCML_I32("vpsrlvw ymm7,ymm5,ymmword ptr [eax]", 0x62, 0xf2, 0xd5, 0x28, 0x10, 0x38);
    /* zmm1, zmm2, m512 */
    FCML_A64("vpsrlvw (%rax),%zmm7,%zmm15", 0x62, 0x72, 0xc5, 0x48, 0x10, 0x38);
    FCML_I64("vpsrlvw zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x72, 0xc5, 0x48, 0x10, 0x38);
    FCML_A32("vpsrlvw (%eax),%zmm3,%zmm7", 0x62, 0xf2, 0xe5, 0x48, 0x10, 0x38);
    FCML_I32("vpsrlvw zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf2, 0xe5, 0x48, 0x10, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64("vpsrlvw %xmm1,%xmm7,%xmm15", 0x62, 0x72, 0xc5, 0x08, 0x10, 0xf9);
    FCML_I64("vpsrlvw xmm15,xmm7,xmm1", 0x62, 0x72, 0xc5, 0x08, 0x10, 0xf9);
    FCML_A32("vpsrlvw %xmm1,%xmm2,%xmm7", 0x62, 0xf2, 0xed, 0x08, 0x10, 0xf9);
    FCML_I32("vpsrlvw xmm7,xmm2,xmm1", 0x62, 0xf2, 0xed, 0x08, 0x10, 0xf9);
    /* ymm1, ymm2, ymm3 */
    FCML_A64("vpsrlvw %ymm6,%ymm7,%ymm14", 0x62, 0x72, 0xc5, 0x28, 0x10, 0xf6);
    FCML_I64("vpsrlvw ymm14,ymm7,ymm6", 0x62, 0x72, 0xc5, 0x28, 0x10, 0xf6);
    FCML_A32("vpsrlvw %ymm5,%ymm3,%ymm6", 0x62, 0xf2, 0xe5, 0x28, 0x10, 0xf5);
    FCML_I32("vpsrlvw ymm6,ymm3,ymm5", 0x62, 0xf2, 0xe5, 0x28, 0x10, 0xf5);
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpsrlvw %zmm4,%zmm15,%zmm6", 0x62, 0xf2, 0x85, 0x48, 0x10, 0xf4);
    FCML_I64("vpsrlvw zmm6,zmm15,zmm4", 0x62, 0xf2, 0x85, 0x48, 0x10, 0xf4);
    FCML_A32("vpsrlvw %zmm4,%zmm6,%zmm6", 0x62, 0xf2, 0xcd, 0x48, 0x10, 0xf4);
    FCML_I32("vpsrlvw zmm6,zmm6,zmm4", 0x62, 0xf2, 0xcd, 0x48, 0x10, 0xf4);
    /* disp8 */
    FCML_I32("vpsrlvw zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf2, 0xed, 0x48, 0x10, 0x4c, 0x24, 0x08);
    FCML_A32("vpsrlvw 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x48, 0x10, 0x4c, 0x24, 0x08);
    FCML_I64("vpsrlvw zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf2, 0xed, 0x48, 0x10, 0x4c, 0x24, 0x08);
    FCML_A64("vpsrlvw 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x48, 0x10, 0x4c, 0x24, 0x08);
    FCML_I32("vpsrlvw ymm1,ymm2,ymmword ptr [esp+00000100h]", 0x62, 0xf2, 0xed, 0x28, 0x10, 0x4c, 0x24, 0x08);
    FCML_A32("vpsrlvw 0x00000100(%esp),%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x28, 0x10, 0x4c, 0x24, 0x08);
    FCML_I64("vpsrlvw ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 0x62, 0xf2, 0xed, 0x28, 0x10, 0x4c, 0x24, 0x08);
    FCML_A64("vpsrlvw 0x0000000000000100(%rsp),%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x28, 0x10, 0x4c, 0x24, 0x08);
    FCML_I32("vpsrlvw xmm1,xmm2,xmmword ptr [esp+00000080h]", 0x62, 0xf2, 0xed, 0x08, 0x10, 0x4c, 0x24, 0x08);
    FCML_A32("vpsrlvw 0x00000080(%esp),%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x08, 0x10, 0x4c, 0x24, 0x08);
    FCML_I64("vpsrlvw xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 0x62, 0xf2, 0xed, 0x08, 0x10, 0x4c, 0x24, 0x08);
    FCML_A64("vpsrlvw 0x0000000000000080(%rsp),%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x08, 0x10, 0x4c, 0x24, 0x08);
    /* {k}{z} */
    FCML_A64("vpsrlvw (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x12, 0x8d, 0x8c, 0x10, 0x14, 0x01);
    FCML_I64("vpsrlvw xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x8c, 0x10, 0x14, 0x01);
    FCML_A32("vpsrlvw (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0x8d, 0x10, 0x14, 0x01);
    FCML_I32("vpsrlvw xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x8d, 0x10, 0x14, 0x01);
    FCML_A64("vpsrlvw (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x12, 0x8d, 0xac, 0x10, 0x14, 0x01);
    FCML_I64("vpsrlvw ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0xac, 0x10, 0x14, 0x01);
    FCML_A32("vpsrlvw (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0xad, 0x10, 0x14, 0x01);
    FCML_I32("vpsrlvw ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0xad, 0x10, 0x14, 0x01);
    FCML_A64("vpsrlvw (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x12, 0x8d, 0xcc, 0x10, 0x14, 0x01);
    FCML_I64("vpsrlvw zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0xcc, 0x10, 0x14, 0x01);
    FCML_A32("vpsrlvw (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0xcd, 0x10, 0x14, 0x01);
    FCML_I32("vpsrlvw zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0xcd, 0x10, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpsrlvw (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x12, 0x8d, 0x0c, 0x10, 0x14, 0x01);
    FCML_I64("vpsrlvw xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x0c, 0x10, 0x14, 0x01);
    FCML_A32("vpsrlvw (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf2, 0xc5, 0x0d, 0x10, 0x14, 0x01);
    FCML_I32("vpsrlvw xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x0d, 0x10, 0x14, 0x01);
    FCML_A64("vpsrlvw (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x12, 0x8d, 0x2c, 0x10, 0x14, 0x01);
    FCML_I64("vpsrlvw ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x2c, 0x10, 0x14, 0x01);
    FCML_A32("vpsrlvw (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf2, 0xc5, 0x2d, 0x10, 0x14, 0x01);
    FCML_I32("vpsrlvw ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x2d, 0x10, 0x14, 0x01);
    FCML_A64("vpsrlvw (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x12, 0x8d, 0x4c, 0x10, 0x14, 0x01);
    FCML_I64("vpsrlvw zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x4c, 0x10, 0x14, 0x01);
    FCML_A32("vpsrlvw (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf2, 0xc5, 0x4d, 0x10, 0x14, 0x01);
    FCML_I32("vpsrlvw zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x4d, 0x10, 0x14, 0x01);
}

void fcml_tf_instruction_VPSRLVD(void) {

    FCML_I32_M("vpsrlvd xmm0,xmm6,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x4d, 0x08, 0x45, 0x00), FCML_MI(0xc4, 0xe2, 0x49, 0x45, 0x00));
    FCML_I32_M("vpsrlvd ymm0,ymm6,ymmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x4d, 0x28, 0x45, 0x00), FCML_MI(0xc4, 0xe2, 0x4d, 0x45, 0x00));
    FCML_I32_M("vpsrlvd ymm0,ymm6,ymm0", 2, FCML_MI(0x62, 0xf2, 0x4d, 0x28, 0x45, 0xc0), FCML_MI(0xc4, 0xe2, 0x4d, 0x45, 0xc0));
    FCML_A64_M("vpsrlvd (%rax),%xmm6,%xmm0", 2, FCML_MI(0x62, 0xf2, 0x4d, 0x08, 0x45, 0x00), FCML_MI(0xc4, 0xe2, 0x49, 0x45, 0x00));
    FCML_A64_M("vpsrlvd (%rax),%ymm6,%ymm0", 2, FCML_MI(0x62, 0xf2, 0x4d, 0x28, 0x45, 0x00), FCML_MI(0xc4, 0xe2, 0x4d, 0x45, 0x00));
    FCML_A64_M("vpsrlvd %ymm0,%ymm6,%ymm0", 2, FCML_MI(0x62, 0xf2, 0x4d, 0x28, 0x45, 0xc0), FCML_MI(0xc4, 0xe2, 0x4d, 0x45, 0xc0));
    /* xmm1, xmm2, m128 */
    FCML_A64_M("vpsrlvd (%rax),%xmm7,%xmm15", 2, FCML_MI(0x62, 0x72, 0x45, 0x08, 0x45, 0x38), FCML_MI(0xc4, 0x62, 0x41, 0x45, 0x38));
    FCML_I64_M("vpsrlvd xmm15,xmm7,xmmword ptr [rax]", 2, FCML_MI(0x62, 0x72, 0x45, 0x08, 0x45, 0x38), FCML_MI(0xc4, 0x62, 0x41, 0x45, 0x38));
    FCML_A32_M("vpsrlvd (%eax),%xmm6,%xmm7", 2, FCML_MI(0x62, 0xf2, 0x4d, 0x08, 0x45, 0x38), FCML_MI(0xc4, 0xe2, 0x49, 0x45, 0x38));
    FCML_I32_M("vpsrlvd xmm7,xmm6,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x4d, 0x08, 0x45, 0x38), FCML_MI(0xc4, 0xe2, 0x49, 0x45, 0x38));
    /* ymm1, ymm2, m256 */
    FCML_A64_M("vpsrlvd (%rax),%ymm7,%ymm15", 2, FCML_MI(0x62, 0x72, 0x45, 0x28, 0x45, 0x38), FCML_MI(0xc4, 0x62, 0x45, 0x45, 0x38));
    FCML_I64_M("vpsrlvd ymm15,ymm7,ymmword ptr [rax]", 2, FCML_MI(0x62, 0x72, 0x45, 0x28, 0x45, 0x38), FCML_MI(0xc4, 0x62, 0x45, 0x45, 0x38));
    FCML_A32_M("vpsrlvd (%eax),%ymm5,%ymm7", 2, FCML_MI(0x62, 0xf2, 0x55, 0x28, 0x45, 0x38), FCML_MI(0xc4, 0xe2, 0x55, 0x45, 0x38));
    FCML_I32_M("vpsrlvd ymm7,ymm5,ymmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x55, 0x28, 0x45, 0x38), FCML_MI(0xc4, 0xe2, 0x55, 0x45, 0x38));
    /* zmm1, zmm2, m512 */
    FCML_A64("vpsrlvd (%rax),%zmm7,%zmm15", 0x62, 0x72, 0x45, 0x48, 0x45, 0x38);
    FCML_I64("vpsrlvd zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x72, 0x45, 0x48, 0x45, 0x38);
    FCML_A32("vpsrlvd (%eax),%zmm3,%zmm7", 0x62, 0xf2, 0x65, 0x48, 0x45, 0x38);
    FCML_I32("vpsrlvd zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf2, 0x65, 0x48, 0x45, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64_M("vpsrlvd %xmm1,%xmm7,%xmm15", 2, FCML_MI(0x62, 0x72, 0x45, 0x08, 0x45, 0xf9), FCML_MI(0xc4, 0x62, 0x41, 0x45, 0xf9));
    FCML_I64_M("vpsrlvd xmm15,xmm7,xmm1", 2, FCML_MI(0x62, 0x72, 0x45, 0x08, 0x45, 0xf9), FCML_MI(0xc4, 0x62, 0x41, 0x45, 0xf9));
    FCML_A32_M("vpsrlvd %xmm1,%xmm2,%xmm7", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x45, 0xf9), FCML_MI(0xc4, 0xe2, 0x69, 0x45, 0xf9));
    FCML_I32_M("vpsrlvd xmm7,xmm2,xmm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x45, 0xf9), FCML_MI(0xc4, 0xe2, 0x69, 0x45, 0xf9));
    /* ymm1, ymm2, ymm3 */
    FCML_A64_M("vpsrlvd %ymm6,%ymm7,%ymm14", 2, FCML_MI(0x62, 0x72, 0x45, 0x28, 0x45, 0xf6), FCML_MI(0xc4, 0x62, 0x45, 0x45, 0xf6));
    FCML_I64_M("vpsrlvd ymm14,ymm7,ymm6", 2, FCML_MI(0x62, 0x72, 0x45, 0x28, 0x45, 0xf6), FCML_MI(0xc4, 0x62, 0x45, 0x45, 0xf6));
    FCML_A32_M("vpsrlvd %ymm5,%ymm3,%ymm6", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0x45, 0xf5), FCML_MI(0xc4, 0xe2, 0x65, 0x45, 0xf5));
    FCML_I32_M("vpsrlvd ymm6,ymm3,ymm5", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0x45, 0xf5), FCML_MI(0xc4, 0xe2, 0x65, 0x45, 0xf5));
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpsrlvd %zmm4,%zmm15,%zmm6", 0x62, 0xf2, 0x05, 0x48, 0x45, 0xf4);
    FCML_I64("vpsrlvd zmm6,zmm15,zmm4", 0x62, 0xf2, 0x05, 0x48, 0x45, 0xf4);
    FCML_A32("vpsrlvd %zmm4,%zmm6,%zmm6", 0x62, 0xf2, 0x4d, 0x48, 0x45, 0xf4);
    FCML_I32("vpsrlvd zmm6,zmm6,zmm4", 0x62, 0xf2, 0x4d, 0x48, 0x45, 0xf4);
    /* disp8 */
    FCML_I32("vpsrlvd zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf2, 0x6d, 0x48, 0x45, 0x4c, 0x24, 0x08);
    FCML_A32("vpsrlvd 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x48, 0x45, 0x4c, 0x24, 0x08);
    FCML_I64("vpsrlvd zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf2, 0x6d, 0x48, 0x45, 0x4c, 0x24, 0x08);
    FCML_A64("vpsrlvd 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x48, 0x45, 0x4c, 0x24, 0x08);
    FCML_I32_M("vpsrlvd ymm1,ymm2,ymmword ptr [esp+00000100h]", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x28, 0x45, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x6d, 0x45, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A32_M("vpsrlvd 0x00000100(%esp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x28, 0x45, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x6d, 0x45, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I64_M("vpsrlvd ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x28, 0x45, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x6d, 0x45, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A64_M("vpsrlvd 0x0000000000000100(%rsp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x28, 0x45, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x6d, 0x45, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I32_M("vpsrlvd xmm1,xmm2,xmmword ptr [esp+00000080h]", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x45, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x69, 0x45, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A32_M("vpsrlvd 0x00000080(%esp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x45, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x69, 0x45, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_I64_M("vpsrlvd xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x45, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x69, 0x45, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A64_M("vpsrlvd 0x0000000000000080(%rsp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x45, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x69, 0x45, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    /* {k}{z} */
    FCML_A64("vpsrlvd (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x12, 0x0d, 0x8c, 0x45, 0x14, 0x01);
    FCML_I64("vpsrlvd xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x8c, 0x45, 0x14, 0x01);
    FCML_A32("vpsrlvd (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf2, 0x45, 0x8d, 0x45, 0x14, 0x01);
    FCML_I32("vpsrlvd xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x8d, 0x45, 0x14, 0x01);
    FCML_A64("vpsrlvd (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x12, 0x0d, 0xac, 0x45, 0x14, 0x01);
    FCML_I64("vpsrlvd ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0xac, 0x45, 0x14, 0x01);
    FCML_A32("vpsrlvd (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf2, 0x45, 0xad, 0x45, 0x14, 0x01);
    FCML_I32("vpsrlvd ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0xad, 0x45, 0x14, 0x01);
    FCML_A64("vpsrlvd (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x12, 0x0d, 0xcc, 0x45, 0x14, 0x01);
    FCML_I64("vpsrlvd zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0xcc, 0x45, 0x14, 0x01);
    FCML_A32("vpsrlvd (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf2, 0x45, 0xcd, 0x45, 0x14, 0x01);
    FCML_I32("vpsrlvd zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0xcd, 0x45, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpsrlvd (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x12, 0x0d, 0x0c, 0x45, 0x14, 0x01);
    FCML_I64("vpsrlvd xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x0c, 0x45, 0x14, 0x01);
    FCML_A32("vpsrlvd (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf2, 0x45, 0x0d, 0x45, 0x14, 0x01);
    FCML_I32("vpsrlvd xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x0d, 0x45, 0x14, 0x01);
    FCML_A64("vpsrlvd (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x12, 0x0d, 0x2c, 0x45, 0x14, 0x01);
    FCML_I64("vpsrlvd ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x2c, 0x45, 0x14, 0x01);
    FCML_A32("vpsrlvd (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf2, 0x45, 0x2d, 0x45, 0x14, 0x01);
    FCML_I32("vpsrlvd ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x2d, 0x45, 0x14, 0x01);
    FCML_A64("vpsrlvd (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x12, 0x0d, 0x4c, 0x45, 0x14, 0x01);
    FCML_I64("vpsrlvd zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x4c, 0x45, 0x14, 0x01);
    FCML_A32("vpsrlvd (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf2, 0x45, 0x4d, 0x45, 0x14, 0x01);
    FCML_I32("vpsrlvd zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x4d, 0x45, 0x14, 0x01);
    /* bcast */
    FCML_I64("vpsrlvd zmm31,zmm21,dword ptr [rsi]{1to16}", 0x62, 0x62, 0x55, 0x50, 0x45, 0x3e);
    FCML_A64("vpsrlvd (%rsi){1to16},%zmm21,%zmm31", 0x62, 0x62, 0x55, 0x50, 0x45, 0x3e);
    FCML_I64("vpsrlvd ymm31,ymm21,dword ptr [rsi]{1to8}", 0x62, 0x62, 0x55, 0x30, 0x45, 0x3e);
    FCML_A64("vpsrlvd (%rsi){1to8},%ymm21,%ymm31", 0x62, 0x62, 0x55, 0x30, 0x45, 0x3e);
    FCML_I64("vpsrlvd xmm31,xmm21,dword ptr [rsi]{1to4}", 0x62, 0x62, 0x55, 0x10, 0x45, 0x3e);
    FCML_A64("vpsrlvd (%rsi){1to4},%xmm21,%xmm31", 0x62, 0x62, 0x55, 0x10, 0x45, 0x3e);
    FCML_A32("vpsrlvd (%esi){1to16},%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x58, 0x45, 0x0e);
    FCML_I32("vpsrlvd zmm1,zmm2,dword ptr [esi]{1to16}", 0x62, 0xf2, 0x6d, 0x58, 0x45, 0x0e);
    /* {k}{z}{bcast} */
    FCML_A64("vpsrlvd (%rsi){1to8},%ymm21,%ymm31{%k7}{z}", 0x62, 0x62, 0x55, 0xb7, 0x45, 0x3e);
    FCML_I64("vpsrlvd ymm31{k7}{z},ymm21,dword ptr [rsi]{1to8}", 0x62, 0x62, 0x55, 0xb7, 0x45, 0x3e);
    /* {bcast} disp8 */
    FCML_I32("vpsrlvd zmm1,zmm2,dword ptr [esp+00000020h]{1to16}", 0x62, 0xf2, 0x6d, 0x58, 0x45, 0x4c, 0x24, 0x08);
    FCML_A32("vpsrlvd 0x00000020(%esp){1to16},%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x58, 0x45, 0x4c, 0x24, 0x08);
    FCML_I64("vpsrlvd zmm1,zmm2,dword ptr [rsp+0000000000000020h]{1to16}", 0x62, 0xf2, 0x6d, 0x58, 0x45, 0x4c, 0x24, 0x08);
    FCML_A64("vpsrlvd 0x0000000000000020(%rsp){1to16},%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x58, 0x45, 0x4c, 0x24, 0x08);
    FCML_I32("vpsrlvd ymm1,ymm2,dword ptr [esp+00000020h]{1to8}", 0x62, 0xf2, 0x6d, 0x38, 0x45, 0x4c, 0x24, 0x08);
    FCML_A32("vpsrlvd 0x00000020(%esp){1to8},%ymm2,%ymm1", 0x62, 0xf2, 0x6d, 0x38, 0x45, 0x4c, 0x24, 0x08);
    FCML_I64("vpsrlvd ymm1,ymm2,dword ptr [rsp+0000000000000020h]{1to8}", 0x62, 0xf2, 0x6d, 0x38, 0x45, 0x4c, 0x24, 0x08);
    FCML_A64("vpsrlvd 0x0000000000000020(%rsp){1to8},%ymm2,%ymm1", 0x62, 0xf2, 0x6d, 0x38, 0x45, 0x4c, 0x24, 0x08);
    FCML_I32("vpsrlvd xmm1,xmm2,dword ptr [esp+00000020h]{1to4}", 0x62, 0xf2, 0x6d, 0x18, 0x45, 0x4c, 0x24, 0x08);
    FCML_A32("vpsrlvd 0x00000020(%esp){1to4},%xmm2,%xmm1", 0x62, 0xf2, 0x6d, 0x18, 0x45, 0x4c, 0x24, 0x08);
    FCML_I64("vpsrlvd xmm1,xmm2,dword ptr [rsp+0000000000000020h]{1to4}", 0x62, 0xf2, 0x6d, 0x18, 0x45, 0x4c, 0x24, 0x08);
    FCML_A64("vpsrlvd 0x0000000000000020(%rsp){1to4},%xmm2,%xmm1", 0x62, 0xf2, 0x6d, 0x18, 0x45, 0x4c, 0x24, 0x08);
}

void fcml_tf_instruction_VPSRLVQ(void) {

    FCML_I64_M("vpsrlvq xmm0,xmm6,xmmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0xcd, 0x08, 0x45, 0x00), FCML_MI(0xc4, 0xe2, 0xc9, 0x45, 0x00));
    FCML_I64_M("vpsrlvq ymm0,ymm6,ymmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0xcd, 0x28, 0x45, 0x00), FCML_MI(0xc4, 0xe2, 0xcd, 0x45, 0x00));
    FCML_I64_M("vpsrlvq ymm0,ymm6,ymm0", 2, FCML_MI(0x62, 0xf2, 0xcd, 0x28, 0x45, 0xc0), FCML_MI(0xc4, 0xe2, 0xcd, 0x45, 0xc0));
    FCML_A64_M("vpsrlvq (%rax),%xmm6,%xmm0", 2, FCML_MI(0x62, 0xf2, 0xcd, 0x08, 0x45, 0x00), FCML_MI(0xc4, 0xe2, 0xc9, 0x45, 0x00));
    FCML_A64_M("vpsrlvq (%rax),%ymm6,%ymm0", 2, FCML_MI(0x62, 0xf2, 0xcd, 0x28, 0x45, 0x00), FCML_MI(0xc4, 0xe2, 0xcd, 0x45, 0x00));
    FCML_A64_M("vpsrlvq %ymm0,%ymm6,%ymm0", 2, FCML_MI(0x62, 0xf2, 0xcd, 0x28, 0x45, 0xc0), FCML_MI(0xc4, 0xe2, 0xcd, 0x45, 0xc0));

    /* xmm1, xmm2, m128 */
    FCML_A64_M("vpsrlvq (%rax),%xmm7,%xmm15", 2, FCML_MI(0x62, 0x72, 0xc5, 0x08, 0x45, 0x38), FCML_MI(0xc4, 0x62, 0xc1, 0x45, 0x38));
    FCML_I64_M("vpsrlvq xmm15,xmm7,xmmword ptr [rax]", 2, FCML_MI(0x62, 0x72, 0xc5, 0x08, 0x45, 0x38), FCML_MI(0xc4, 0x62, 0xc1, 0x45, 0x38));
    FCML_A32_M("vpsrlvq (%eax),%xmm6,%xmm7", 2, FCML_MI(0x62, 0xf2, 0xcd, 0x08, 0x45, 0x38), FCML_MI(0xc4, 0xe2, 0xc9, 0x45, 0x38));
    FCML_I32_M("vpsrlvq xmm7,xmm6,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0xcd, 0x08, 0x45, 0x38), FCML_MI(0xc4, 0xe2, 0xc9, 0x45, 0x38));
    /* ymm1, ymm2, m256 */
    FCML_A64_M("vpsrlvq (%rax),%ymm7,%ymm15", 2, FCML_MI(0x62, 0x72, 0xc5, 0x28, 0x45, 0x38), FCML_MI(0xc4, 0x62, 0xc5, 0x45, 0x38));
    FCML_I64_M("vpsrlvq ymm15,ymm7,ymmword ptr [rax]", 2, FCML_MI(0x62, 0x72, 0xc5, 0x28, 0x45, 0x38), FCML_MI(0xc4, 0x62, 0xc5, 0x45, 0x38));
    FCML_A32_M("vpsrlvq (%eax),%ymm5,%ymm7", 2, FCML_MI(0x62, 0xf2, 0xd5, 0x28, 0x45, 0x38), FCML_MI(0xc4, 0xe2, 0xd5, 0x45, 0x38));
    FCML_I32_M("vpsrlvq ymm7,ymm5,ymmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0xd5, 0x28, 0x45, 0x38), FCML_MI(0xc4, 0xe2, 0xd5, 0x45, 0x38));
    /* zmm1, zmm2, m512 */
    FCML_A64("vpsrlvq (%rax),%zmm7,%zmm15", 0x62, 0x72, 0xc5, 0x48, 0x45, 0x38);
    FCML_I64("vpsrlvq zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x72, 0xc5, 0x48, 0x45, 0x38);
    FCML_A32("vpsrlvq (%eax),%zmm3,%zmm7", 0x62, 0xf2, 0xe5, 0x48, 0x45, 0x38);
    FCML_I32("vpsrlvq zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf2, 0xe5, 0x48, 0x45, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64_M("vpsrlvq %xmm1,%xmm7,%xmm15", 2, FCML_MI(0x62, 0x72, 0xc5, 0x08, 0x45, 0xf9), FCML_MI(0xc4, 0x62, 0xc1, 0x45, 0xf9));
    FCML_I64_M("vpsrlvq xmm15,xmm7,xmm1", 2, FCML_MI(0x62, 0x72, 0xc5, 0x08, 0x45, 0xf9), FCML_MI(0xc4, 0x62, 0xc1, 0x45, 0xf9));
    FCML_A32_M("vpsrlvq %xmm1,%xmm2,%xmm7", 2, FCML_MI(0x62, 0xf2, 0xed, 0x08, 0x45, 0xf9), FCML_MI(0xc4, 0xe2, 0xe9, 0x45, 0xf9));
    FCML_I32_M("vpsrlvq xmm7,xmm2,xmm1", 2, FCML_MI(0x62, 0xf2, 0xed, 0x08, 0x45, 0xf9), FCML_MI(0xc4, 0xe2, 0xe9, 0x45, 0xf9));
    /* ymm1, ymm2, ymm3 */
    FCML_A64_M("vpsrlvq %ymm6,%ymm7,%ymm14", 2, FCML_MI(0x62, 0x72, 0xc5, 0x28, 0x45, 0xf6), FCML_MI(0xc4, 0x62, 0xc5, 0x45, 0xf6));
    FCML_I64_M("vpsrlvq ymm14,ymm7,ymm6", 2, FCML_MI(0x62, 0x72, 0xc5, 0x28, 0x45, 0xf6), FCML_MI(0xc4, 0x62, 0xc5, 0x45, 0xf6));
    FCML_A32_M("vpsrlvq %ymm5,%ymm3,%ymm6", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0x45, 0xf5), FCML_MI(0xc4, 0xe2, 0xe5, 0x45, 0xf5));
    FCML_I32_M("vpsrlvq ymm6,ymm3,ymm5", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0x45, 0xf5), FCML_MI(0xc4, 0xe2, 0xe5, 0x45, 0xf5));
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpsrlvq %zmm4,%zmm15,%zmm6", 0x62, 0xf2, 0x85, 0x48, 0x45, 0xf4);
    FCML_I64("vpsrlvq zmm6,zmm15,zmm4", 0x62, 0xf2, 0x85, 0x48, 0x45, 0xf4);
    FCML_A32("vpsrlvq %zmm4,%zmm6,%zmm6", 0x62, 0xf2, 0xcd, 0x48, 0x45, 0xf4);
    FCML_I32("vpsrlvq zmm6,zmm6,zmm4", 0x62, 0xf2, 0xcd, 0x48, 0x45, 0xf4);
    /* disp8 */
    FCML_I32("vpsrlvq zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf2, 0xed, 0x48, 0x45, 0x4c, 0x24, 0x08);
    FCML_A32("vpsrlvq 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x48, 0x45, 0x4c, 0x24, 0x08);
    FCML_I64("vpsrlvq zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf2, 0xed, 0x48, 0x45, 0x4c, 0x24, 0x08);
    FCML_A64("vpsrlvq 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x48, 0x45, 0x4c, 0x24, 0x08);
    FCML_I32_M("vpsrlvq ymm1,ymm2,ymmword ptr [esp+00000100h]", 2, FCML_MI(0x62, 0xf2, 0xed, 0x28, 0x45, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0xed, 0x45, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A32_M("vpsrlvq 0x00000100(%esp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf2, 0xed, 0x28, 0x45, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0xed, 0x45, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I64_M("vpsrlvq ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 2, FCML_MI(0x62, 0xf2, 0xed, 0x28, 0x45, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0xed, 0x45, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A64_M("vpsrlvq 0x0000000000000100(%rsp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf2, 0xed, 0x28, 0x45, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0xed, 0x45, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I32_M("vpsrlvq xmm1,xmm2,xmmword ptr [esp+00000080h]", 2, FCML_MI(0x62, 0xf2, 0xed, 0x08, 0x45, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0xe9, 0x45, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A32_M("vpsrlvq 0x00000080(%esp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf2, 0xed, 0x08, 0x45, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0xe9, 0x45, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_I64_M("vpsrlvq xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 2, FCML_MI(0x62, 0xf2, 0xed, 0x08, 0x45, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0xe9, 0x45, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A64_M("vpsrlvq 0x0000000000000080(%rsp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf2, 0xed, 0x08, 0x45, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0xe9, 0x45, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    /* {k}{z} */
    FCML_A64("vpsrlvq (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x12, 0x8d, 0x8c, 0x45, 0x14, 0x01);
    FCML_I64("vpsrlvq xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x8c, 0x45, 0x14, 0x01);
    FCML_A32("vpsrlvq (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0x8d, 0x45, 0x14, 0x01);
    FCML_I32("vpsrlvq xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x8d, 0x45, 0x14, 0x01);
    FCML_A64("vpsrlvq (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x12, 0x8d, 0xac, 0x45, 0x14, 0x01);
    FCML_I64("vpsrlvq ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0xac, 0x45, 0x14, 0x01);
    FCML_A32("vpsrlvq (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0xad, 0x45, 0x14, 0x01);
    FCML_I32("vpsrlvq ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0xad, 0x45, 0x14, 0x01);
    FCML_A64("vpsrlvq (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x12, 0x8d, 0xcc, 0x45, 0x14, 0x01);
    FCML_I64("vpsrlvq zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0xcc, 0x45, 0x14, 0x01);
    FCML_A32("vpsrlvq (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0xcd, 0x45, 0x14, 0x01);
    FCML_I32("vpsrlvq zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0xcd, 0x45, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpsrlvq (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x12, 0x8d, 0x0c, 0x45, 0x14, 0x01);
    FCML_I64("vpsrlvq xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x0c, 0x45, 0x14, 0x01);
    FCML_A32("vpsrlvq (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf2, 0xc5, 0x0d, 0x45, 0x14, 0x01);
    FCML_I32("vpsrlvq xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x0d, 0x45, 0x14, 0x01);
    FCML_A64("vpsrlvq (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x12, 0x8d, 0x2c, 0x45, 0x14, 0x01);
    FCML_I64("vpsrlvq ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x2c, 0x45, 0x14, 0x01);
    FCML_A32("vpsrlvq (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf2, 0xc5, 0x2d, 0x45, 0x14, 0x01);
    FCML_I32("vpsrlvq ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x2d, 0x45, 0x14, 0x01);
    FCML_A64("vpsrlvq (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x12, 0x8d, 0x4c, 0x45, 0x14, 0x01);
    FCML_I64("vpsrlvq zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x4c, 0x45, 0x14, 0x01);
    FCML_A32("vpsrlvq (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf2, 0xc5, 0x4d, 0x45, 0x14, 0x01);
    FCML_I32("vpsrlvq zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x4d, 0x45, 0x14, 0x01);
    /* bcast */
    FCML_I64("vpsrlvq zmm31,zmm21,mmword ptr [rsi]{1to8}", 0x62, 0x62, 0xd5, 0x50, 0x45, 0x3e);
    FCML_A64("vpsrlvq (%rsi){1to8},%zmm21,%zmm31", 0x62, 0x62, 0xd5, 0x50, 0x45, 0x3e);
    FCML_I64("vpsrlvq ymm31,ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x62, 0xd5, 0x30, 0x45, 0x3e);
    FCML_A64("vpsrlvq (%rsi){1to4},%ymm21,%ymm31", 0x62, 0x62, 0xd5, 0x30, 0x45, 0x3e);
    FCML_I64("vpsrlvq xmm31,xmm21,mmword ptr [rsi]{1to2}", 0x62, 0x62, 0xd5, 0x10, 0x45, 0x3e);
    FCML_A64("vpsrlvq (%rsi){1to2},%xmm21,%xmm31", 0x62, 0x62, 0xd5, 0x10, 0x45, 0x3e);
    FCML_A32("vpsrlvq (%esi){1to8},%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x58, 0x45, 0x0e);
    FCML_I32("vpsrlvq zmm1,zmm2,mmword ptr [esi]{1to8}", 0x62, 0xf2, 0xed, 0x58, 0x45, 0x0e);
    /* {k}{z}{bcast} */
    FCML_A64("vpsrlvq (%rsi){1to4},%ymm21,%ymm31{%k7}{z}", 0x62, 0x62, 0xd5, 0xb7, 0x45, 0x3e);
    FCML_I64("vpsrlvq ymm31{k7}{z},ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x62, 0xd5, 0xb7, 0x45, 0x3e);
    /* {bcast} disp8 */
    FCML_I32("vpsrlvq zmm1,zmm2,mmword ptr [esp+00000040h]{1to8}", 0x62, 0xf2, 0xed, 0x58, 0x45, 0x4c, 0x24, 0x08);
    FCML_A32("vpsrlvq 0x00000040(%esp){1to8},%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x58, 0x45, 0x4c, 0x24, 0x08);
    FCML_I64("vpsrlvq zmm1,zmm2,mmword ptr [rsp+0000000000000040h]{1to8}", 0x62, 0xf2, 0xed, 0x58, 0x45, 0x4c, 0x24, 0x08);
    FCML_A64("vpsrlvq 0x0000000000000040(%rsp){1to8},%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x58, 0x45, 0x4c, 0x24, 0x08);
    FCML_I32("vpsrlvq ymm1,ymm2,mmword ptr [esp+00000040h]{1to4}", 0x62, 0xf2, 0xed, 0x38, 0x45, 0x4c, 0x24, 0x08);
    FCML_A32("vpsrlvq 0x00000040(%esp){1to4},%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x38, 0x45, 0x4c, 0x24, 0x08);
    FCML_I64("vpsrlvq ymm1,ymm2,mmword ptr [rsp+0000000000000040h]{1to4}", 0x62, 0xf2, 0xed, 0x38, 0x45, 0x4c, 0x24, 0x08);
    FCML_A64("vpsrlvq 0x0000000000000040(%rsp){1to4},%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x38, 0x45, 0x4c, 0x24, 0x08);
    FCML_I32("vpsrlvq xmm1,xmm2,mmword ptr [esp+00000040h]{1to2}", 0x62, 0xf2, 0xed, 0x18, 0x45, 0x4c, 0x24, 0x08);
    FCML_A32("vpsrlvq 0x00000040(%esp){1to2},%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x18, 0x45, 0x4c, 0x24, 0x08);
    FCML_I64("vpsrlvq xmm1,xmm2,mmword ptr [rsp+0000000000000040h]{1to2}", 0x62, 0xf2, 0xed, 0x18, 0x45, 0x4c, 0x24, 0x08);
    FCML_A64("vpsrlvq 0x0000000000000040(%rsp){1to2},%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x18, 0x45, 0x4c, 0x24, 0x08);
}

void fcml_tf_instruction_VPSRAVW(void) {
    /* xmm1, xmm2, m128 */
    FCML_A64("vpsravw (%rax),%xmm7,%xmm15", 0x62, 0x72, 0xc5, 0x08, 0x11, 0x38);
    FCML_I64("vpsravw xmm15,xmm7,xmmword ptr [rax]", 0x62, 0x72, 0xc5, 0x08, 0x11, 0x38);
    FCML_A32("vpsravw (%eax),%xmm6,%xmm7", 0x62, 0xf2, 0xcd, 0x08, 0x11, 0x38);
    FCML_I32("vpsravw xmm7,xmm6,xmmword ptr [eax]", 0x62, 0xf2, 0xcd, 0x08, 0x11, 0x38);
    /* ymm1, ymm2, m256 */
    FCML_A64("vpsravw (%rax),%ymm7,%ymm15", 0x62, 0x72, 0xc5, 0x28, 0x11, 0x38);
    FCML_I64("vpsravw ymm15,ymm7,ymmword ptr [rax]", 0x62, 0x72, 0xc5, 0x28, 0x11, 0x38);
    FCML_A32("vpsravw (%eax),%ymm5,%ymm7", 0x62, 0xf2, 0xd5, 0x28, 0x11, 0x38);
    FCML_I32("vpsravw ymm7,ymm5,ymmword ptr [eax]", 0x62, 0xf2, 0xd5, 0x28, 0x11, 0x38);
    /* zmm1, zmm2, m512 */
    FCML_A64("vpsravw (%rax),%zmm7,%zmm15", 0x62, 0x72, 0xc5, 0x48, 0x11, 0x38);
    FCML_I64("vpsravw zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x72, 0xc5, 0x48, 0x11, 0x38);
    FCML_A32("vpsravw (%eax),%zmm3,%zmm7", 0x62, 0xf2, 0xe5, 0x48, 0x11, 0x38);
    FCML_I32("vpsravw zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf2, 0xe5, 0x48, 0x11, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64("vpsravw %xmm1,%xmm7,%xmm15", 0x62, 0x72, 0xc5, 0x08, 0x11, 0xf9);
    FCML_I64("vpsravw xmm15,xmm7,xmm1", 0x62, 0x72, 0xc5, 0x08, 0x11, 0xf9);
    FCML_A32("vpsravw %xmm1,%xmm2,%xmm7", 0x62, 0xf2, 0xed, 0x08, 0x11, 0xf9);
    FCML_I32("vpsravw xmm7,xmm2,xmm1", 0x62, 0xf2, 0xed, 0x08, 0x11, 0xf9);
    /* ymm1, ymm2, ymm3 */
    FCML_A64("vpsravw %ymm6,%ymm7,%ymm14", 0x62, 0x72, 0xc5, 0x28, 0x11, 0xf6);
    FCML_I64("vpsravw ymm14,ymm7,ymm6", 0x62, 0x72, 0xc5, 0x28, 0x11, 0xf6);
    FCML_A32("vpsravw %ymm5,%ymm3,%ymm6", 0x62, 0xf2, 0xe5, 0x28, 0x11, 0xf5);
    FCML_I32("vpsravw ymm6,ymm3,ymm5", 0x62, 0xf2, 0xe5, 0x28, 0x11, 0xf5);
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpsravw %zmm4,%zmm15,%zmm6", 0x62, 0xf2, 0x85, 0x48, 0x11, 0xf4);
    FCML_I64("vpsravw zmm6,zmm15,zmm4", 0x62, 0xf2, 0x85, 0x48, 0x11, 0xf4);
    FCML_A32("vpsravw %zmm4,%zmm6,%zmm6", 0x62, 0xf2, 0xcd, 0x48, 0x11, 0xf4);
    FCML_I32("vpsravw zmm6,zmm6,zmm4", 0x62, 0xf2, 0xcd, 0x48, 0x11, 0xf4);
    /* disp8 */
    FCML_I32("vpsravw zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf2, 0xed, 0x48, 0x11, 0x4c, 0x24, 0x08);
    FCML_A32("vpsravw 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x48, 0x11, 0x4c, 0x24, 0x08);
    FCML_I64("vpsravw zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf2, 0xed, 0x48, 0x11, 0x4c, 0x24, 0x08);
    FCML_A64("vpsravw 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x48, 0x11, 0x4c, 0x24, 0x08);
    FCML_I32("vpsravw ymm1,ymm2,ymmword ptr [esp+00000100h]", 0x62, 0xf2, 0xed, 0x28, 0x11, 0x4c, 0x24, 0x08);
    FCML_A32("vpsravw 0x00000100(%esp),%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x28, 0x11, 0x4c, 0x24, 0x08);
    FCML_I64("vpsravw ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 0x62, 0xf2, 0xed, 0x28, 0x11, 0x4c, 0x24, 0x08);
    FCML_A64("vpsravw 0x0000000000000100(%rsp),%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x28, 0x11, 0x4c, 0x24, 0x08);
    FCML_I32("vpsravw xmm1,xmm2,xmmword ptr [esp+00000080h]", 0x62, 0xf2, 0xed, 0x08, 0x11, 0x4c, 0x24, 0x08);
    FCML_A32("vpsravw 0x00000080(%esp),%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x08, 0x11, 0x4c, 0x24, 0x08);
    FCML_I64("vpsravw xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 0x62, 0xf2, 0xed, 0x08, 0x11, 0x4c, 0x24, 0x08);
    FCML_A64("vpsravw 0x0000000000000080(%rsp),%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x08, 0x11, 0x4c, 0x24, 0x08);
    /* {k}{z} */
    FCML_A64("vpsravw (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x12, 0x8d, 0x8c, 0x11, 0x14, 0x01);
    FCML_I64("vpsravw xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x8c, 0x11, 0x14, 0x01);
    FCML_A32("vpsravw (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0x8d, 0x11, 0x14, 0x01);
    FCML_I32("vpsravw xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x8d, 0x11, 0x14, 0x01);
    FCML_A64("vpsravw (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x12, 0x8d, 0xac, 0x11, 0x14, 0x01);
    FCML_I64("vpsravw ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0xac, 0x11, 0x14, 0x01);
    FCML_A32("vpsravw (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0xad, 0x11, 0x14, 0x01);
    FCML_I32("vpsravw ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0xad, 0x11, 0x14, 0x01);
    FCML_A64("vpsravw (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x12, 0x8d, 0xcc, 0x11, 0x14, 0x01);
    FCML_I64("vpsravw zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0xcc, 0x11, 0x14, 0x01);
    FCML_A32("vpsravw (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0xcd, 0x11, 0x14, 0x01);
    FCML_I32("vpsravw zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0xcd, 0x11, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpsravw (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x12, 0x8d, 0x0c, 0x11, 0x14, 0x01);
    FCML_I64("vpsravw xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x0c, 0x11, 0x14, 0x01);
    FCML_A32("vpsravw (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf2, 0xc5, 0x0d, 0x11, 0x14, 0x01);
    FCML_I32("vpsravw xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x0d, 0x11, 0x14, 0x01);
    FCML_A64("vpsravw (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x12, 0x8d, 0x2c, 0x11, 0x14, 0x01);
    FCML_I64("vpsravw ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x2c, 0x11, 0x14, 0x01);
    FCML_A32("vpsravw (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf2, 0xc5, 0x2d, 0x11, 0x14, 0x01);
    FCML_I32("vpsravw ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x2d, 0x11, 0x14, 0x01);
    FCML_A64("vpsravw (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x12, 0x8d, 0x4c, 0x11, 0x14, 0x01);
    FCML_I64("vpsravw zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x4c, 0x11, 0x14, 0x01);
    FCML_A32("vpsravw (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf2, 0xc5, 0x4d, 0x11, 0x14, 0x01);
    FCML_I32("vpsravw zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x4d, 0x11, 0x14, 0x01);
}

void fcml_tf_instruction_VPSRAVD(void) {

    FCML_I32_M("vpsravd xmm0,xmm6,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x4d, 0x08, 0x46, 0x00), FCML_MI(0xc4, 0xe2, 0x49, 0x46, 0x00));
    FCML_I32_M("vpsravd ymm0,ymm6,ymmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x4d, 0x28, 0x46, 0x00), FCML_MI(0xc4, 0xe2, 0x4d, 0x46, 0x00));
    FCML_I32_M("vpsravd ymm0,ymm6,ymm0", 2, FCML_MI(0x62, 0xf2, 0x4d, 0x28, 0x46, 0xc0), FCML_MI(0xc4, 0xe2, 0x4d, 0x46, 0xc0));
    FCML_A64_M("vpsravd (%rax),%xmm6,%xmm0", 2, FCML_MI(0x62, 0xf2, 0x4d, 0x08, 0x46, 0x00), FCML_MI(0xc4, 0xe2, 0x49, 0x46, 0x00));
    FCML_A64_M("vpsravd (%rax),%ymm6,%ymm0", 2, FCML_MI(0x62, 0xf2, 0x4d, 0x28, 0x46, 0x00), FCML_MI(0xc4, 0xe2, 0x4d, 0x46, 0x00));
    FCML_A64_M("vpsravd %ymm0,%ymm6,%ymm0", 2, FCML_MI(0x62, 0xf2, 0x4d, 0x28, 0x46, 0xc0), FCML_MI(0xc4, 0xe2, 0x4d, 0x46, 0xc0));

    /* xmm1, xmm2, m128 */
    FCML_A64_M("vpsravd (%rax),%xmm7,%xmm15", 2, FCML_MI(0x62, 0x72, 0x45, 0x08, 0x46, 0x38), FCML_MI(0xc4, 0x62, 0x41, 0x46, 0x38));
    FCML_I64_M("vpsravd xmm15,xmm7,xmmword ptr [rax]", 2, FCML_MI(0x62, 0x72, 0x45, 0x08, 0x46, 0x38), FCML_MI(0xc4, 0x62, 0x41, 0x46, 0x38));
    FCML_A32_M("vpsravd (%eax),%xmm6,%xmm7", 2, FCML_MI(0x62, 0xf2, 0x4d, 0x08, 0x46, 0x38), FCML_MI(0xc4, 0xe2, 0x49, 0x46, 0x38));
    FCML_I32_M("vpsravd xmm7,xmm6,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x4d, 0x08, 0x46, 0x38), FCML_MI(0xc4, 0xe2, 0x49, 0x46, 0x38));
    /* ymm1, ymm2, m256 */
    FCML_A64_M("vpsravd (%rax),%ymm7,%ymm15", 2, FCML_MI(0x62, 0x72, 0x45, 0x28, 0x46, 0x38), FCML_MI(0xc4, 0x62, 0x45, 0x46, 0x38));
    FCML_I64_M("vpsravd ymm15,ymm7,ymmword ptr [rax]", 2, FCML_MI(0x62, 0x72, 0x45, 0x28, 0x46, 0x38), FCML_MI(0xc4, 0x62, 0x45, 0x46, 0x38));
    FCML_A32_M("vpsravd (%eax),%ymm5,%ymm7", 2, FCML_MI(0x62, 0xf2, 0x55, 0x28, 0x46, 0x38), FCML_MI(0xc4, 0xe2, 0x55, 0x46, 0x38));
    FCML_I32_M("vpsravd ymm7,ymm5,ymmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x55, 0x28, 0x46, 0x38), FCML_MI(0xc4, 0xe2, 0x55, 0x46, 0x38));
     /* zmm1, zmm2, m512 */
    FCML_A64("vpsravd (%rax),%zmm7,%zmm15", 0x62, 0x72, 0x45, 0x48, 0x46, 0x38);
    FCML_I64("vpsravd zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x72, 0x45, 0x48, 0x46, 0x38);
    FCML_A32("vpsravd (%eax),%zmm3,%zmm7", 0x62, 0xf2, 0x65, 0x48, 0x46, 0x38);
    FCML_I32("vpsravd zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf2, 0x65, 0x48, 0x46, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64_M("vpsravd %xmm1,%xmm7,%xmm15", 2, FCML_MI(0x62, 0x72, 0x45, 0x08, 0x46, 0xf9), FCML_MI(0xc4, 0x62, 0x41, 0x46, 0xf9));
    FCML_I64_M("vpsravd xmm15,xmm7,xmm1", 2, FCML_MI(0x62, 0x72, 0x45, 0x08, 0x46, 0xf9), FCML_MI(0xc4, 0x62, 0x41, 0x46, 0xf9));
    FCML_A32_M("vpsravd %xmm1,%xmm2,%xmm7", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x46, 0xf9), FCML_MI(0xc4, 0xe2, 0x69, 0x46, 0xf9));
    FCML_I32_M("vpsravd xmm7,xmm2,xmm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x46, 0xf9), FCML_MI(0xc4, 0xe2, 0x69, 0x46, 0xf9));
     /* ymm1, ymm2, ymm3 */
    FCML_A64_M("vpsravd %ymm6,%ymm7,%ymm14", 2, FCML_MI(0x62, 0x72, 0x45, 0x28, 0x46, 0xf6), FCML_MI(0xc4, 0x62, 0x45, 0x46, 0xf6));
    FCML_I64_M("vpsravd ymm14,ymm7,ymm6", 2, FCML_MI(0x62, 0x72, 0x45, 0x28, 0x46, 0xf6), FCML_MI(0xc4, 0x62, 0x45, 0x46, 0xf6));
    FCML_A32_M("vpsravd %ymm5,%ymm3,%ymm6", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0x46, 0xf5), FCML_MI(0xc4, 0xe2, 0x65, 0x46, 0xf5));
    FCML_I32_M("vpsravd ymm6,ymm3,ymm5", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0x46, 0xf5), FCML_MI(0xc4, 0xe2, 0x65, 0x46, 0xf5));
   /* zmm1, zmm2, zmm3 */
    FCML_A64("vpsravd %zmm4,%zmm15,%zmm6", 0x62, 0xf2, 0x05, 0x48, 0x46, 0xf4);
    FCML_I64("vpsravd zmm6,zmm15,zmm4", 0x62, 0xf2, 0x05, 0x48, 0x46, 0xf4);
    FCML_A32("vpsravd %zmm4,%zmm6,%zmm6", 0x62, 0xf2, 0x4d, 0x48, 0x46, 0xf4);
    FCML_I32("vpsravd zmm6,zmm6,zmm4", 0x62, 0xf2, 0x4d, 0x48, 0x46, 0xf4);
    /* disp8 */
    FCML_I32("vpsravd zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf2, 0x6d, 0x48, 0x46, 0x4c, 0x24, 0x08);
    FCML_A32("vpsravd 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x48, 0x46, 0x4c, 0x24, 0x08);
    FCML_I64("vpsravd zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf2, 0x6d, 0x48, 0x46, 0x4c, 0x24, 0x08);
    FCML_A64("vpsravd 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x48, 0x46, 0x4c, 0x24, 0x08);
    FCML_I32_M("vpsravd ymm1,ymm2,ymmword ptr [esp+00000100h]", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x28, 0x46, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x6d, 0x46, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A32_M("vpsravd 0x00000100(%esp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x28, 0x46, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x6d, 0x46, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I64_M("vpsravd ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x28, 0x46, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x6d, 0x46, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A64_M("vpsravd 0x0000000000000100(%rsp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x28, 0x46, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x6d, 0x46, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I32_M("vpsravd xmm1,xmm2,xmmword ptr [esp+00000080h]", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x46, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x69, 0x46, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A32_M("vpsravd 0x00000080(%esp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x46, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x69, 0x46, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_I64_M("vpsravd xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x46, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x69, 0x46, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A64_M("vpsravd 0x0000000000000080(%rsp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x08, 0x46, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x69, 0x46, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
   /* {k}{z} */
    FCML_A64("vpsravd (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x12, 0x0d, 0x8c, 0x46, 0x14, 0x01);
    FCML_I64("vpsravd xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x8c, 0x46, 0x14, 0x01);
    FCML_A32("vpsravd (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf2, 0x45, 0x8d, 0x46, 0x14, 0x01);
    FCML_I32("vpsravd xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x8d, 0x46, 0x14, 0x01);
    FCML_A64("vpsravd (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x12, 0x0d, 0xac, 0x46, 0x14, 0x01);
    FCML_I64("vpsravd ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0xac, 0x46, 0x14, 0x01);
    FCML_A32("vpsravd (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf2, 0x45, 0xad, 0x46, 0x14, 0x01);
    FCML_I32("vpsravd ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0xad, 0x46, 0x14, 0x01);
    FCML_A64("vpsravd (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x12, 0x0d, 0xcc, 0x46, 0x14, 0x01);
    FCML_I64("vpsravd zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0xcc, 0x46, 0x14, 0x01);
    FCML_A32("vpsravd (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf2, 0x45, 0xcd, 0x46, 0x14, 0x01);
    FCML_I32("vpsravd zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0xcd, 0x46, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpsravd (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x12, 0x0d, 0x0c, 0x46, 0x14, 0x01);
    FCML_I64("vpsravd xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x0c, 0x46, 0x14, 0x01);
    FCML_A32("vpsravd (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf2, 0x45, 0x0d, 0x46, 0x14, 0x01);
    FCML_I32("vpsravd xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x0d, 0x46, 0x14, 0x01);
    FCML_A64("vpsravd (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x12, 0x0d, 0x2c, 0x46, 0x14, 0x01);
    FCML_I64("vpsravd ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x2c, 0x46, 0x14, 0x01);
    FCML_A32("vpsravd (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf2, 0x45, 0x2d, 0x46, 0x14, 0x01);
    FCML_I32("vpsravd ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x2d, 0x46, 0x14, 0x01);
    FCML_A64("vpsravd (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x12, 0x0d, 0x4c, 0x46, 0x14, 0x01);
    FCML_I64("vpsravd zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x4c, 0x46, 0x14, 0x01);
    FCML_A32("vpsravd (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf2, 0x45, 0x4d, 0x46, 0x14, 0x01);
    FCML_I32("vpsravd zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x4d, 0x46, 0x14, 0x01);
    /* bcast */
    FCML_I64("vpsravd zmm31,zmm21,dword ptr [rsi]{1to16}", 0x62, 0x62, 0x55, 0x50, 0x46, 0x3e);
    FCML_A64("vpsravd (%rsi){1to16},%zmm21,%zmm31", 0x62, 0x62, 0x55, 0x50, 0x46, 0x3e);
    FCML_I64("vpsravd ymm31,ymm21,dword ptr [rsi]{1to8}", 0x62, 0x62, 0x55, 0x30, 0x46, 0x3e);
    FCML_A64("vpsravd (%rsi){1to8},%ymm21,%ymm31", 0x62, 0x62, 0x55, 0x30, 0x46, 0x3e);
    FCML_I64("vpsravd xmm31,xmm21,dword ptr [rsi]{1to4}", 0x62, 0x62, 0x55, 0x10, 0x46, 0x3e);
    FCML_A64("vpsravd (%rsi){1to4},%xmm21,%xmm31", 0x62, 0x62, 0x55, 0x10, 0x46, 0x3e);
    FCML_A32("vpsravd (%esi){1to16},%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x58, 0x46, 0x0e);
    FCML_I32("vpsravd zmm1,zmm2,dword ptr [esi]{1to16}", 0x62, 0xf2, 0x6d, 0x58, 0x46, 0x0e);
    /* {k}{z}{bcast} */
    FCML_A64("vpsravd (%rsi){1to8},%ymm21,%ymm31{%k7}{z}", 0x62, 0x62, 0x55, 0xb7, 0x46, 0x3e);
    FCML_I64("vpsravd ymm31{k7}{z},ymm21,dword ptr [rsi]{1to8}", 0x62, 0x62, 0x55, 0xb7, 0x46, 0x3e);
    /* {bcast} disp8 */
    FCML_I32("vpsravd zmm1,zmm2,dword ptr [esp+00000020h]{1to16}", 0x62, 0xf2, 0x6d, 0x58, 0x46, 0x4c, 0x24, 0x08);
    FCML_A32("vpsravd 0x00000020(%esp){1to16},%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x58, 0x46, 0x4c, 0x24, 0x08);
    FCML_I64("vpsravd zmm1,zmm2,dword ptr [rsp+0000000000000020h]{1to16}", 0x62, 0xf2, 0x6d, 0x58, 0x46, 0x4c, 0x24, 0x08);
    FCML_A64("vpsravd 0x0000000000000020(%rsp){1to16},%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x58, 0x46, 0x4c, 0x24, 0x08);
    FCML_I32("vpsravd ymm1,ymm2,dword ptr [esp+00000020h]{1to8}", 0x62, 0xf2, 0x6d, 0x38, 0x46, 0x4c, 0x24, 0x08);
    FCML_A32("vpsravd 0x00000020(%esp){1to8},%ymm2,%ymm1", 0x62, 0xf2, 0x6d, 0x38, 0x46, 0x4c, 0x24, 0x08);
    FCML_I64("vpsravd ymm1,ymm2,dword ptr [rsp+0000000000000020h]{1to8}", 0x62, 0xf2, 0x6d, 0x38, 0x46, 0x4c, 0x24, 0x08);
    FCML_A64("vpsravd 0x0000000000000020(%rsp){1to8},%ymm2,%ymm1", 0x62, 0xf2, 0x6d, 0x38, 0x46, 0x4c, 0x24, 0x08);
    FCML_I32("vpsravd xmm1,xmm2,dword ptr [esp+00000020h]{1to4}", 0x62, 0xf2, 0x6d, 0x18, 0x46, 0x4c, 0x24, 0x08);
    FCML_A32("vpsravd 0x00000020(%esp){1to4},%xmm2,%xmm1", 0x62, 0xf2, 0x6d, 0x18, 0x46, 0x4c, 0x24, 0x08);
    FCML_I64("vpsravd xmm1,xmm2,dword ptr [rsp+0000000000000020h]{1to4}", 0x62, 0xf2, 0x6d, 0x18, 0x46, 0x4c, 0x24, 0x08);
    FCML_A64("vpsravd 0x0000000000000020(%rsp){1to4},%xmm2,%xmm1", 0x62, 0xf2, 0x6d, 0x18, 0x46, 0x4c, 0x24, 0x08);
}

void fcml_tf_instruction_VPSRAVQ(void) {
    /* xmm1, xmm2, m128 */
    FCML_A64("vpsravq (%rax),%xmm7,%xmm15", 0x62, 0x72, 0xc5, 0x08, 0x46, 0x38);
    FCML_I64("vpsravq xmm15,xmm7,xmmword ptr [rax]", 0x62, 0x72, 0xc5, 0x08, 0x46, 0x38);
    FCML_A32("vpsravq (%eax),%xmm6,%xmm7", 0x62, 0xf2, 0xcd, 0x08, 0x46, 0x38);
    FCML_I32("vpsravq xmm7,xmm6,xmmword ptr [eax]", 0x62, 0xf2, 0xcd, 0x08, 0x46, 0x38);
    /* ymm1, ymm2, m256 */
    FCML_A64("vpsravq (%rax),%ymm7,%ymm15", 0x62, 0x72, 0xc5, 0x28, 0x46, 0x38);
    FCML_I64("vpsravq ymm15,ymm7,ymmword ptr [rax]", 0x62, 0x72, 0xc5, 0x28, 0x46, 0x38);
    FCML_A32("vpsravq (%eax),%ymm5,%ymm7", 0x62, 0xf2, 0xd5, 0x28, 0x46, 0x38);
    FCML_I32("vpsravq ymm7,ymm5,ymmword ptr [eax]", 0x62, 0xf2, 0xd5, 0x28, 0x46, 0x38);
    /* zmm1, zmm2, m512 */
    FCML_A64("vpsravq (%rax),%zmm7,%zmm15", 0x62, 0x72, 0xc5, 0x48, 0x46, 0x38);
    FCML_I64("vpsravq zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x72, 0xc5, 0x48, 0x46, 0x38);
    FCML_A32("vpsravq (%eax),%zmm3,%zmm7", 0x62, 0xf2, 0xe5, 0x48, 0x46, 0x38);
    FCML_I32("vpsravq zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf2, 0xe5, 0x48, 0x46, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64("vpsravq %xmm1,%xmm7,%xmm15", 0x62, 0x72, 0xc5, 0x08, 0x46, 0xf9);
    FCML_I64("vpsravq xmm15,xmm7,xmm1", 0x62, 0x72, 0xc5, 0x08, 0x46, 0xf9);
    FCML_A32("vpsravq %xmm1,%xmm2,%xmm7", 0x62, 0xf2, 0xed, 0x08, 0x46, 0xf9);
    FCML_I32("vpsravq xmm7,xmm2,xmm1", 0x62, 0xf2, 0xed, 0x08, 0x46, 0xf9);
    /* ymm1, ymm2, ymm3 */
    FCML_A64("vpsravq %ymm6,%ymm7,%ymm14", 0x62, 0x72, 0xc5, 0x28, 0x46, 0xf6);
    FCML_I64("vpsravq ymm14,ymm7,ymm6", 0x62, 0x72, 0xc5, 0x28, 0x46, 0xf6);
    FCML_A32("vpsravq %ymm5,%ymm3,%ymm6", 0x62, 0xf2, 0xe5, 0x28, 0x46, 0xf5);
    FCML_I32("vpsravq ymm6,ymm3,ymm5", 0x62, 0xf2, 0xe5, 0x28, 0x46, 0xf5);
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpsravq %zmm4,%zmm15,%zmm6", 0x62, 0xf2, 0x85, 0x48, 0x46, 0xf4);
    FCML_I64("vpsravq zmm6,zmm15,zmm4", 0x62, 0xf2, 0x85, 0x48, 0x46, 0xf4);
    FCML_A32("vpsravq %zmm4,%zmm6,%zmm6", 0x62, 0xf2, 0xcd, 0x48, 0x46, 0xf4);
    FCML_I32("vpsravq zmm6,zmm6,zmm4", 0x62, 0xf2, 0xcd, 0x48, 0x46, 0xf4);
    /* disp8 */
    FCML_I32("vpsravq zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf2, 0xed, 0x48, 0x46, 0x4c, 0x24, 0x08);
    FCML_A32("vpsravq 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x48, 0x46, 0x4c, 0x24, 0x08);
    FCML_I64("vpsravq zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf2, 0xed, 0x48, 0x46, 0x4c, 0x24, 0x08);
    FCML_A64("vpsravq 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x48, 0x46, 0x4c, 0x24, 0x08);
    FCML_I32("vpsravq ymm1,ymm2,ymmword ptr [esp+00000100h]", 0x62, 0xf2, 0xed, 0x28, 0x46, 0x4c, 0x24, 0x08);
    FCML_A32("vpsravq 0x00000100(%esp),%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x28, 0x46, 0x4c, 0x24, 0x08);
    FCML_I64("vpsravq ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 0x62, 0xf2, 0xed, 0x28, 0x46, 0x4c, 0x24, 0x08);
    FCML_A64("vpsravq 0x0000000000000100(%rsp),%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x28, 0x46, 0x4c, 0x24, 0x08);
    FCML_I32("vpsravq xmm1,xmm2,xmmword ptr [esp+00000080h]", 0x62, 0xf2, 0xed, 0x08, 0x46, 0x4c, 0x24, 0x08);
    FCML_A32("vpsravq 0x00000080(%esp),%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x08, 0x46, 0x4c, 0x24, 0x08);
    FCML_I64("vpsravq xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 0x62, 0xf2, 0xed, 0x08, 0x46, 0x4c, 0x24, 0x08);
    FCML_A64("vpsravq 0x0000000000000080(%rsp),%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x08, 0x46, 0x4c, 0x24, 0x08);
    /* {k}{z} */
    FCML_A64("vpsravq (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x12, 0x8d, 0x8c, 0x46, 0x14, 0x01);
    FCML_I64("vpsravq xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x8c, 0x46, 0x14, 0x01);
    FCML_A32("vpsravq (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0x8d, 0x46, 0x14, 0x01);
    FCML_I32("vpsravq xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x8d, 0x46, 0x14, 0x01);
    FCML_A64("vpsravq (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x12, 0x8d, 0xac, 0x46, 0x14, 0x01);
    FCML_I64("vpsravq ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0xac, 0x46, 0x14, 0x01);
    FCML_A32("vpsravq (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0xad, 0x46, 0x14, 0x01);
    FCML_I32("vpsravq ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0xad, 0x46, 0x14, 0x01);
    FCML_A64("vpsravq (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x12, 0x8d, 0xcc, 0x46, 0x14, 0x01);
    FCML_I64("vpsravq zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0xcc, 0x46, 0x14, 0x01);
    FCML_A32("vpsravq (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0xcd, 0x46, 0x14, 0x01);
    FCML_I32("vpsravq zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0xcd, 0x46, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpsravq (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x12, 0x8d, 0x0c, 0x46, 0x14, 0x01);
    FCML_I64("vpsravq xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x0c, 0x46, 0x14, 0x01);
    FCML_A32("vpsravq (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf2, 0xc5, 0x0d, 0x46, 0x14, 0x01);
    FCML_I32("vpsravq xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x0d, 0x46, 0x14, 0x01);
    FCML_A64("vpsravq (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x12, 0x8d, 0x2c, 0x46, 0x14, 0x01);
    FCML_I64("vpsravq ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x2c, 0x46, 0x14, 0x01);
    FCML_A32("vpsravq (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf2, 0xc5, 0x2d, 0x46, 0x14, 0x01);
    FCML_I32("vpsravq ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x2d, 0x46, 0x14, 0x01);
    FCML_A64("vpsravq (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x12, 0x8d, 0x4c, 0x46, 0x14, 0x01);
    FCML_I64("vpsravq zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x4c, 0x46, 0x14, 0x01);
    FCML_A32("vpsravq (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf2, 0xc5, 0x4d, 0x46, 0x14, 0x01);
    FCML_I32("vpsravq zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x4d, 0x46, 0x14, 0x01);
    /* bcast */
    FCML_I64("vpsravq zmm31,zmm21,mmword ptr [rsi]{1to8}", 0x62, 0x62, 0xd5, 0x50, 0x46, 0x3e);
    FCML_A64("vpsravq (%rsi){1to8},%zmm21,%zmm31", 0x62, 0x62, 0xd5, 0x50, 0x46, 0x3e);
    FCML_I64("vpsravq ymm31,ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x62, 0xd5, 0x30, 0x46, 0x3e);
    FCML_A64("vpsravq (%rsi){1to4},%ymm21,%ymm31", 0x62, 0x62, 0xd5, 0x30, 0x46, 0x3e);
    FCML_I64("vpsravq xmm31,xmm21,mmword ptr [rsi]{1to2}", 0x62, 0x62, 0xd5, 0x10, 0x46, 0x3e);
    FCML_A64("vpsravq (%rsi){1to2},%xmm21,%xmm31", 0x62, 0x62, 0xd5, 0x10, 0x46, 0x3e);
    FCML_A32("vpsravq (%esi){1to8},%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x58, 0x46, 0x0e);
    FCML_I32("vpsravq zmm1,zmm2,mmword ptr [esi]{1to8}", 0x62, 0xf2, 0xed, 0x58, 0x46, 0x0e);
    /* {k}{z}{bcast} */
    FCML_A64("vpsravq (%rsi){1to4},%ymm21,%ymm31{%k7}{z}", 0x62, 0x62, 0xd5, 0xb7, 0x46, 0x3e);
    FCML_I64("vpsravq ymm31{k7}{z},ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x62, 0xd5, 0xb7, 0x46, 0x3e);
    /* {bcast} disp8 */
    FCML_I32("vpsravq zmm1,zmm2,mmword ptr [esp+00000040h]{1to8}", 0x62, 0xf2, 0xed, 0x58, 0x46, 0x4c, 0x24, 0x08);
    FCML_A32("vpsravq 0x00000040(%esp){1to8},%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x58, 0x46, 0x4c, 0x24, 0x08);
    FCML_I64("vpsravq zmm1,zmm2,mmword ptr [rsp+0000000000000040h]{1to8}", 0x62, 0xf2, 0xed, 0x58, 0x46, 0x4c, 0x24, 0x08);
    FCML_A64("vpsravq 0x0000000000000040(%rsp){1to8},%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x58, 0x46, 0x4c, 0x24, 0x08);
    FCML_I32("vpsravq ymm1,ymm2,mmword ptr [esp+00000040h]{1to4}", 0x62, 0xf2, 0xed, 0x38, 0x46, 0x4c, 0x24, 0x08);
    FCML_A32("vpsravq 0x00000040(%esp){1to4},%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x38, 0x46, 0x4c, 0x24, 0x08);
    FCML_I64("vpsravq ymm1,ymm2,mmword ptr [rsp+0000000000000040h]{1to4}", 0x62, 0xf2, 0xed, 0x38, 0x46, 0x4c, 0x24, 0x08);
    FCML_A64("vpsravq 0x0000000000000040(%rsp){1to4},%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x38, 0x46, 0x4c, 0x24, 0x08);
    FCML_I32("vpsravq xmm1,xmm2,mmword ptr [esp+00000040h]{1to2}", 0x62, 0xf2, 0xed, 0x18, 0x46, 0x4c, 0x24, 0x08);
    FCML_A32("vpsravq 0x00000040(%esp){1to2},%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x18, 0x46, 0x4c, 0x24, 0x08);
    FCML_I64("vpsravq xmm1,xmm2,mmword ptr [rsp+0000000000000040h]{1to2}", 0x62, 0xf2, 0xed, 0x18, 0x46, 0x4c, 0x24, 0x08);
    FCML_A64("vpsravq 0x0000000000000040(%rsp){1to2},%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x18, 0x46, 0x4c, 0x24, 0x08);
}

void fcml_tf_instruction_VPERMD(void) {

    FCML_I32_M("vpermd ymm0,ymm6,ymmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x4d, 0x28, 0x36, 0x00), FCML_MI(0xc4, 0xe2, 0x4d, 0x36, 0x00));
    FCML_I32_M("vpermd ymm0,ymm6,ymm0", 2, FCML_MI(0x62, 0xf2, 0x4d, 0x28, 0x36, 0xc0), FCML_MI(0xc4, 0xe2, 0x4d, 0x36, 0xc0));
    FCML_I64_M("vpermd ymm0,ymm6,ymmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0x4d, 0x28, 0x36, 0x00), FCML_MI(0xc4, 0xe2, 0x4d, 0x36, 0x00));
    FCML_A64_M("vpermd (%rax),%ymm6,%ymm0", 2, FCML_MI(0x62, 0xf2, 0x4d, 0x28, 0x36, 0x00), FCML_MI(0xc4, 0xe2, 0x4d, 0x36, 0x00));
    FCML_A64_M("vpermd %ymm0,%ymm6,%ymm0", 2, FCML_MI(0x62, 0xf2, 0x4d, 0x28, 0x36, 0xc0), FCML_MI(0xc4, 0xe2, 0x4d, 0x36, 0xc0));
    FCML_A64_M("vpermd (%rax),%ymm6,%ymm0", 2, FCML_MI(0x62, 0xf2, 0x4d, 0x28, 0x36, 0x00), FCML_MI(0xc4, 0xe2, 0x4d, 0x36, 0x00));

    /* xmm1, xmm2, m128 */
    FCML_A64_FAILED("vpermd (%rax),%xmm7,%xmm15", 0x62, 0x72, 0x45, 0x08, 0x36, 0x38);
    FCML_I64_FAILED("vpermd xmm15,xmm7,xmmword ptr [rax]", 0x62, 0x72, 0x45, 0x08, 0x36, 0x38);
    FCML_A32_FAILED("vpermd (%eax),%xmm6,%xmm7", 0x62, 0xf2, 0x4d, 0x08, 0x36, 0x38);
    FCML_I32_FAILED("vpermd xmm7,xmm6,xmmword ptr [eax]", 0x62, 0xf2, 0x4d, 0x08, 0x36, 0x38);
    /* ymm1, ymm2, m256 */
    FCML_A64_M("vpermd (%rax),%ymm7,%ymm15", 2, FCML_MI(0x62, 0x72, 0x45, 0x28, 0x36, 0x38), FCML_MI(0xc4, 0x62, 0x45, 0x36, 0x38));
    FCML_I64_M("vpermd ymm15,ymm7,ymmword ptr [rax]", 2, FCML_MI(0x62, 0x72, 0x45, 0x28, 0x36, 0x38), FCML_MI(0xc4, 0x62, 0x45, 0x36, 0x38));
    FCML_A32_M("vpermd (%eax),%ymm5,%ymm7", 2, FCML_MI(0x62, 0xf2, 0x55, 0x28, 0x36, 0x38), FCML_MI(0xc4, 0xe2, 0x55, 0x36, 0x38));
    FCML_I32_M("vpermd ymm7,ymm5,ymmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x55, 0x28, 0x36, 0x38), FCML_MI(0xc4, 0xe2, 0x55, 0x36, 0x38));
    /* zmm1, zmm2, m512 */
    FCML_A64("vpermd (%rax),%zmm7,%zmm15", 0x62, 0x72, 0x45, 0x48, 0x36, 0x38);
    FCML_I64("vpermd zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x72, 0x45, 0x48, 0x36, 0x38);
    FCML_A32("vpermd (%eax),%zmm3,%zmm7", 0x62, 0xf2, 0x65, 0x48, 0x36, 0x38);
    FCML_I32("vpermd zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf2, 0x65, 0x48, 0x36, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64_FAILED("vpermd %xmm1,%xmm7,%xmm15", 0x62, 0x72, 0x45, 0x08, 0x36, 0xf9);
    FCML_I64_FAILED("vpermd xmm15,xmm7,xmm1", 0x62, 0x72, 0x45, 0x08, 0x36, 0xf9);
    FCML_A32_FAILED("vpermd %xmm1,%xmm2,%xmm7", 0x62, 0xf2, 0x6d, 0x08, 0x36, 0xf9);
    FCML_I32_FAILED("vpermd xmm7,xmm2,xmm1", 0x62, 0xf2, 0x6d, 0x08, 0x36, 0xf9);
    /* ymm1, ymm2, ymm3 */
    FCML_A64_M("vpermd %ymm6,%ymm7,%ymm14", 2, FCML_MI(0x62, 0x72, 0x45, 0x28, 0x36, 0xf6), FCML_MI(0xc4, 0x62, 0x45, 0x36, 0xf6));
    FCML_I64_M("vpermd ymm14,ymm7,ymm6", 2, FCML_MI(0x62, 0x72, 0x45, 0x28, 0x36, 0xf6), FCML_MI(0xc4, 0x62, 0x45, 0x36, 0xf6));
    FCML_A32_M("vpermd %ymm5,%ymm3,%ymm6", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0x36, 0xf5), FCML_MI(0xc4, 0xe2, 0x65, 0x36, 0xf5));
    FCML_I32_M("vpermd ymm6,ymm3,ymm5", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0x36, 0xf5), FCML_MI(0xc4, 0xe2, 0x65, 0x36, 0xf5));
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpermd %zmm4,%zmm15,%zmm6", 0x62, 0xf2, 0x05, 0x48, 0x36, 0xf4);
    FCML_I64("vpermd zmm6,zmm15,zmm4", 0x62, 0xf2, 0x05, 0x48, 0x36, 0xf4);
    FCML_A32("vpermd %zmm4,%zmm6,%zmm6", 0x62, 0xf2, 0x4d, 0x48, 0x36, 0xf4);
    FCML_I32("vpermd zmm6,zmm6,zmm4", 0x62, 0xf2, 0x4d, 0x48, 0x36, 0xf4);
    /* disp8 */
    FCML_I32("vpermd zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf2, 0x6d, 0x48, 0x36, 0x4c, 0x24, 0x08);
    FCML_A32("vpermd 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x48, 0x36, 0x4c, 0x24, 0x08);
    FCML_I64("vpermd zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf2, 0x6d, 0x48, 0x36, 0x4c, 0x24, 0x08);
    FCML_A64("vpermd 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x48, 0x36, 0x4c, 0x24, 0x08);
    FCML_I32_M("vpermd ymm1,ymm2,ymmword ptr [esp+00000100h]", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x28, 0x36, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x6d, 0x36, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A32_M("vpermd 0x00000100(%esp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x28, 0x36, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x6d, 0x36, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I64_M("vpermd ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x28, 0x36, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x6d, 0x36, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A64_M("vpermd 0x0000000000000100(%rsp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf2, 0x6d, 0x28, 0x36, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0x6d, 0x36, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I32_FAILED("vpermd xmm1,xmm2,xmmword ptr [esp+00000080h]", 0x62, 0xf2, 0x6d, 0x08, 0x36, 0x4c, 0x24, 0x08);
    FCML_A32_FAILED("vpermd 0x00000080(%esp),%xmm2,%xmm1", 0x62, 0xf2, 0x6d, 0x08, 0x36, 0x4c, 0x24, 0x08);
    FCML_I64_FAILED("vpermd xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 0x62, 0xf2, 0x6d, 0x08, 0x36, 0x4c, 0x24, 0x08);
    FCML_A64_FAILED("vpermd 0x0000000000000080(%rsp),%xmm2,%xmm1", 0x62, 0xf2, 0x6d, 0x08, 0x36, 0x4c, 0x24, 0x08);
    /* {k}{z} */
    FCML_A64_FAILED("vpermd (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x12, 0x0d, 0x8c, 0x36, 0x14, 0x01);
    FCML_I64_FAILED("vpermd xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x8c, 0x36, 0x14, 0x01);
    FCML_A32_FAILED("vpermd (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf2, 0x45, 0x8d, 0x36, 0x14, 0x01);
    FCML_I32_FAILED("vpermd xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x8d, 0x36, 0x14, 0x01);
    FCML_A64("vpermd (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x12, 0x0d, 0xac, 0x36, 0x14, 0x01);
    FCML_I64("vpermd ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0xac, 0x36, 0x14, 0x01);
    FCML_A32("vpermd (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf2, 0x45, 0xad, 0x36, 0x14, 0x01);
    FCML_I32("vpermd ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0xad, 0x36, 0x14, 0x01);
    FCML_A64("vpermd (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x12, 0x0d, 0xcc, 0x36, 0x14, 0x01);
    FCML_I64("vpermd zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0xcc, 0x36, 0x14, 0x01);
    FCML_A32("vpermd (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf2, 0x45, 0xcd, 0x36, 0x14, 0x01);
    FCML_I32("vpermd zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0xcd, 0x36, 0x14, 0x01);
    /* {k} */
    FCML_A64_FAILED("vpermd (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x12, 0x0d, 0x0c, 0x36, 0x14, 0x01);
    FCML_I64_FAILED("vpermd xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x0c, 0x36, 0x14, 0x01);
    FCML_A32_FAILED("vpermd (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf2, 0x45, 0x0d, 0x36, 0x14, 0x01);
    FCML_I32_FAILED("vpermd xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x0d, 0x36, 0x14, 0x01);
    FCML_A64("vpermd (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x12, 0x0d, 0x2c, 0x36, 0x14, 0x01);
    FCML_I64("vpermd ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x2c, 0x36, 0x14, 0x01);
    FCML_A32("vpermd (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf2, 0x45, 0x2d, 0x36, 0x14, 0x01);
    FCML_I32("vpermd ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x2d, 0x36, 0x14, 0x01);
    FCML_A64("vpermd (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x12, 0x0d, 0x4c, 0x36, 0x14, 0x01);
    FCML_I64("vpermd zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x4c, 0x36, 0x14, 0x01);
    FCML_A32("vpermd (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf2, 0x45, 0x4d, 0x36, 0x14, 0x01);
    FCML_I32("vpermd zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x4d, 0x36, 0x14, 0x01);
    /* bcast */
    FCML_I64("vpermd zmm31,zmm21,dword ptr [rsi]{1to16}", 0x62, 0x62, 0x55, 0x50, 0x36, 0x3e);
    FCML_A64("vpermd (%rsi){1to16},%zmm21,%zmm31", 0x62, 0x62, 0x55, 0x50, 0x36, 0x3e);
    FCML_I64("vpermd ymm31,ymm21,dword ptr [rsi]{1to8}", 0x62, 0x62, 0x55, 0x30, 0x36, 0x3e);
    FCML_A64("vpermd (%rsi){1to8},%ymm21,%ymm31", 0x62, 0x62, 0x55, 0x30, 0x36, 0x3e);
    FCML_I64_FAILED("vpermd xmm31,xmm21,dword ptr [rsi]{1to4}", 0x62, 0x62, 0x55, 0x10, 0x36, 0x3e);
    FCML_A64_FAILED("vpermd (%rsi){1to4},%xmm21,%xmm31", 0x62, 0x62, 0x55, 0x10, 0x36, 0x3e);
    FCML_A32("vpermd (%esi){1to16},%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x58, 0x36, 0x0e);
    FCML_I32("vpermd zmm1,zmm2,dword ptr [esi]{1to16}", 0x62, 0xf2, 0x6d, 0x58, 0x36, 0x0e);
    /* {k}{z}{bcast} */
    FCML_A64("vpermd (%rsi){1to8},%ymm21,%ymm31{%k7}{z}", 0x62, 0x62, 0x55, 0xb7, 0x36, 0x3e);
    FCML_I64("vpermd ymm31{k7}{z},ymm21,dword ptr [rsi]{1to8}", 0x62, 0x62, 0x55, 0xb7, 0x36, 0x3e);
    /* {bcast} disp8 */
    FCML_I32("vpermd zmm1,zmm2,dword ptr [esp+00000020h]{1to16}", 0x62, 0xf2, 0x6d, 0x58, 0x36, 0x4c, 0x24, 0x08);
    FCML_A32("vpermd 0x00000020(%esp){1to16},%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x58, 0x36, 0x4c, 0x24, 0x08);
    FCML_I64("vpermd zmm1,zmm2,dword ptr [rsp+0000000000000020h]{1to16}", 0x62, 0xf2, 0x6d, 0x58, 0x36, 0x4c, 0x24, 0x08);
    FCML_A64("vpermd 0x0000000000000020(%rsp){1to16},%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x58, 0x36, 0x4c, 0x24, 0x08);
    FCML_I32("vpermd ymm1,ymm2,dword ptr [esp+00000020h]{1to8}", 0x62, 0xf2, 0x6d, 0x38, 0x36, 0x4c, 0x24, 0x08);
    FCML_A32("vpermd 0x00000020(%esp){1to8},%ymm2,%ymm1", 0x62, 0xf2, 0x6d, 0x38, 0x36, 0x4c, 0x24, 0x08);
    FCML_I64("vpermd ymm1,ymm2,dword ptr [rsp+0000000000000020h]{1to8}", 0x62, 0xf2, 0x6d, 0x38, 0x36, 0x4c, 0x24, 0x08);
    FCML_A64("vpermd 0x0000000000000020(%rsp){1to8},%ymm2,%ymm1", 0x62, 0xf2, 0x6d, 0x38, 0x36, 0x4c, 0x24, 0x08);
    FCML_I32_FAILED("vpermd xmm1,xmm2,dword ptr [esp+00000020h]{1to4}", 0x62, 0xf2, 0x6d, 0x18, 0x36, 0x4c, 0x24, 0x08);
    FCML_A32_FAILED("vpermd 0x00000020(%esp){1to4},%xmm2,%xmm1", 0x62, 0xf2, 0x6d, 0x18, 0x36, 0x4c, 0x24, 0x08);
    FCML_I64_FAILED("vpermd xmm1,xmm2,dword ptr [rsp+0000000000000020h]{1to4}", 0x62, 0xf2, 0x6d, 0x18, 0x36, 0x4c, 0x24, 0x08);
    FCML_A64_FAILED("vpermd 0x0000000000000020(%rsp){1to4},%xmm2,%xmm1", 0x62, 0xf2, 0x6d, 0x18, 0x36, 0x4c, 0x24, 0x08);
}

void fcml_tf_instruction_VPERMW(void) {
    /* xmm1, xmm2, m128 */
    FCML_A64("vpermw (%rax),%xmm7,%xmm15", 0x62, 0x72, 0xc5, 0x08, 0x8d, 0x38);
    FCML_I64("vpermw xmm15,xmm7,xmmword ptr [rax]", 0x62, 0x72, 0xc5, 0x08, 0x8d, 0x38);
    FCML_A32("vpermw (%eax),%xmm6,%xmm7", 0x62, 0xf2, 0xcd, 0x08, 0x8d, 0x38);
    FCML_I32("vpermw xmm7,xmm6,xmmword ptr [eax]", 0x62, 0xf2, 0xcd, 0x08, 0x8d, 0x38);
    /* ymm1, ymm2, m256 */
    FCML_A64("vpermw (%rax),%ymm7,%ymm15", 0x62, 0x72, 0xc5, 0x28, 0x8d, 0x38);
    FCML_I64("vpermw ymm15,ymm7,ymmword ptr [rax]", 0x62, 0x72, 0xc5, 0x28, 0x8d, 0x38);
    FCML_A32("vpermw (%eax),%ymm5,%ymm7", 0x62, 0xf2, 0xd5, 0x28, 0x8d, 0x38);
    FCML_I32("vpermw ymm7,ymm5,ymmword ptr [eax]", 0x62, 0xf2, 0xd5, 0x28, 0x8d, 0x38);
    /* zmm1, zmm2, m512 */
    FCML_A64("vpermw (%rax),%zmm7,%zmm15", 0x62, 0x72, 0xc5, 0x48, 0x8d, 0x38);
    FCML_I64("vpermw zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x72, 0xc5, 0x48, 0x8d, 0x38);
    FCML_A32("vpermw (%eax),%zmm3,%zmm7", 0x62, 0xf2, 0xe5, 0x48, 0x8d, 0x38);
    FCML_I32("vpermw zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf2, 0xe5, 0x48, 0x8d, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64("vpermw %xmm1,%xmm7,%xmm15", 0x62, 0x72, 0xc5, 0x08, 0x8d, 0xf9);
    FCML_I64("vpermw xmm15,xmm7,xmm1", 0x62, 0x72, 0xc5, 0x08, 0x8d, 0xf9);
    FCML_A32("vpermw %xmm1,%xmm2,%xmm7", 0x62, 0xf2, 0xed, 0x08, 0x8d, 0xf9);
    FCML_I32("vpermw xmm7,xmm2,xmm1", 0x62, 0xf2, 0xed, 0x08, 0x8d, 0xf9);
    /* ymm1, ymm2, ymm3 */
    FCML_A64("vpermw %ymm6,%ymm7,%ymm14", 0x62, 0x72, 0xc5, 0x28, 0x8d, 0xf6);
    FCML_I64("vpermw ymm14,ymm7,ymm6", 0x62, 0x72, 0xc5, 0x28, 0x8d, 0xf6);
    FCML_A32("vpermw %ymm5,%ymm3,%ymm6", 0x62, 0xf2, 0xe5, 0x28, 0x8d, 0xf5);
    FCML_I32("vpermw ymm6,ymm3,ymm5", 0x62, 0xf2, 0xe5, 0x28, 0x8d, 0xf5);
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpermw %zmm4,%zmm15,%zmm6", 0x62, 0xf2, 0x85, 0x48, 0x8d, 0xf4);
    FCML_I64("vpermw zmm6,zmm15,zmm4", 0x62, 0xf2, 0x85, 0x48, 0x8d, 0xf4);
    FCML_A32("vpermw %zmm4,%zmm6,%zmm6", 0x62, 0xf2, 0xcd, 0x48, 0x8d, 0xf4);
    FCML_I32("vpermw zmm6,zmm6,zmm4", 0x62, 0xf2, 0xcd, 0x48, 0x8d, 0xf4);
    /* disp8 */
    FCML_I32("vpermw zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf2, 0xed, 0x48, 0x8d, 0x4c, 0x24, 0x08);
    FCML_A32("vpermw 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x48, 0x8d, 0x4c, 0x24, 0x08);
    FCML_I64("vpermw zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf2, 0xed, 0x48, 0x8d, 0x4c, 0x24, 0x08);
    FCML_A64("vpermw 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x48, 0x8d, 0x4c, 0x24, 0x08);
    FCML_I32("vpermw ymm1,ymm2,ymmword ptr [esp+00000100h]", 0x62, 0xf2, 0xed, 0x28, 0x8d, 0x4c, 0x24, 0x08);
    FCML_A32("vpermw 0x00000100(%esp),%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x28, 0x8d, 0x4c, 0x24, 0x08);
    FCML_I64("vpermw ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 0x62, 0xf2, 0xed, 0x28, 0x8d, 0x4c, 0x24, 0x08);
    FCML_A64("vpermw 0x0000000000000100(%rsp),%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x28, 0x8d, 0x4c, 0x24, 0x08);
    FCML_I32("vpermw xmm1,xmm2,xmmword ptr [esp+00000080h]", 0x62, 0xf2, 0xed, 0x08, 0x8d, 0x4c, 0x24, 0x08);
    FCML_A32("vpermw 0x00000080(%esp),%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x08, 0x8d, 0x4c, 0x24, 0x08);
    FCML_I64("vpermw xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 0x62, 0xf2, 0xed, 0x08, 0x8d, 0x4c, 0x24, 0x08);
    FCML_A64("vpermw 0x0000000000000080(%rsp),%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x08, 0x8d, 0x4c, 0x24, 0x08);
    /* {k}{z} */
    FCML_A64("vpermw (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x12, 0x8d, 0x8c, 0x8d, 0x14, 0x01);
    FCML_I64("vpermw xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x8c, 0x8d, 0x14, 0x01);
    FCML_A32("vpermw (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0x8d, 0x8d, 0x14, 0x01);
    FCML_I32("vpermw xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x8d, 0x8d, 0x14, 0x01);
    FCML_A64("vpermw (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x12, 0x8d, 0xac, 0x8d, 0x14, 0x01);
    FCML_I64("vpermw ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0xac, 0x8d, 0x14, 0x01);
    FCML_A32("vpermw (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0xad, 0x8d, 0x14, 0x01);
    FCML_I32("vpermw ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0xad, 0x8d, 0x14, 0x01);
    FCML_A64("vpermw (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x12, 0x8d, 0xcc, 0x8d, 0x14, 0x01);
    FCML_I64("vpermw zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0xcc, 0x8d, 0x14, 0x01);
    FCML_A32("vpermw (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0xcd, 0x8d, 0x14, 0x01);
    FCML_I32("vpermw zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0xcd, 0x8d, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpermw (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x12, 0x8d, 0x0c, 0x8d, 0x14, 0x01);
    FCML_I64("vpermw xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x0c, 0x8d, 0x14, 0x01);
    FCML_A32("vpermw (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf2, 0xc5, 0x0d, 0x8d, 0x14, 0x01);
    FCML_I32("vpermw xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x0d, 0x8d, 0x14, 0x01);
    FCML_A64("vpermw (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x12, 0x8d, 0x2c, 0x8d, 0x14, 0x01);
    FCML_I64("vpermw ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x2c, 0x8d, 0x14, 0x01);
    FCML_A32("vpermw (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf2, 0xc5, 0x2d, 0x8d, 0x14, 0x01);
    FCML_I32("vpermw ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x2d, 0x8d, 0x14, 0x01);
    FCML_A64("vpermw (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x12, 0x8d, 0x4c, 0x8d, 0x14, 0x01);
    FCML_I64("vpermw zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x4c, 0x8d, 0x14, 0x01);
    FCML_A32("vpermw (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf2, 0xc5, 0x4d, 0x8d, 0x14, 0x01);
    FCML_I32("vpermw zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x4d, 0x8d, 0x14, 0x01);
}

void fcml_tf_instruction_VPERMI2B(void) {
    /* xmm1, xmm2, m128 */
    FCML_A64("vpermi2b (%rax),%xmm7,%xmm15", 0x62, 0x72, 0x45, 0x08, 0x75, 0x38);
    FCML_I64("vpermi2b xmm15,xmm7,xmmword ptr [rax]", 0x62, 0x72, 0x45, 0x08, 0x75, 0x38);
    FCML_A32("vpermi2b (%eax),%xmm6,%xmm7", 0x62, 0xf2, 0x4d, 0x08, 0x75, 0x38);
    FCML_I32("vpermi2b xmm7,xmm6,xmmword ptr [eax]", 0x62, 0xf2, 0x4d, 0x08, 0x75, 0x38);
    /* ymm1, ymm2, m256 */
    FCML_A64("vpermi2b (%rax),%ymm7,%ymm15", 0x62, 0x72, 0x45, 0x28, 0x75, 0x38);
    FCML_I64("vpermi2b ymm15,ymm7,ymmword ptr [rax]", 0x62, 0x72, 0x45, 0x28, 0x75, 0x38);
    FCML_A32("vpermi2b (%eax),%ymm5,%ymm7", 0x62, 0xf2, 0x55, 0x28, 0x75, 0x38);
    FCML_I32("vpermi2b ymm7,ymm5,ymmword ptr [eax]", 0x62, 0xf2, 0x55, 0x28, 0x75, 0x38);
    /* zmm1, zmm2, m512 */
    FCML_A64("vpermi2b (%rax),%zmm7,%zmm15", 0x62, 0x72, 0x45, 0x48, 0x75, 0x38);
    FCML_I64("vpermi2b zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x72, 0x45, 0x48, 0x75, 0x38);
    FCML_A32("vpermi2b (%eax),%zmm3,%zmm7", 0x62, 0xf2, 0x65, 0x48, 0x75, 0x38);
    FCML_I32("vpermi2b zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf2, 0x65, 0x48, 0x75, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64("vpermi2b %xmm1,%xmm7,%xmm15", 0x62, 0x72, 0x45, 0x08, 0x75, 0xf9);
    FCML_I64("vpermi2b xmm15,xmm7,xmm1", 0x62, 0x72, 0x45, 0x08, 0x75, 0xf9);
    FCML_A32("vpermi2b %xmm1,%xmm2,%xmm7", 0x62, 0xf2, 0x6d, 0x08, 0x75, 0xf9);
    FCML_I32("vpermi2b xmm7,xmm2,xmm1", 0x62, 0xf2, 0x6d, 0x08, 0x75, 0xf9);
    /* ymm1, ymm2, ymm3 */
    FCML_A64("vpermi2b %ymm6,%ymm7,%ymm14", 0x62, 0x72, 0x45, 0x28, 0x75, 0xf6);
    FCML_I64("vpermi2b ymm14,ymm7,ymm6", 0x62, 0x72, 0x45, 0x28, 0x75, 0xf6);
    FCML_A32("vpermi2b %ymm5,%ymm3,%ymm6", 0x62, 0xf2, 0x65, 0x28, 0x75, 0xf5);
    FCML_I32("vpermi2b ymm6,ymm3,ymm5", 0x62, 0xf2, 0x65, 0x28, 0x75, 0xf5);
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpermi2b %zmm4,%zmm15,%zmm6", 0x62, 0xf2, 0x05, 0x48, 0x75, 0xf4);
    FCML_I64("vpermi2b zmm6,zmm15,zmm4", 0x62, 0xf2, 0x05, 0x48, 0x75, 0xf4);
    FCML_A32("vpermi2b %zmm4,%zmm6,%zmm6", 0x62, 0xf2, 0x4d, 0x48, 0x75, 0xf4);
    FCML_I32("vpermi2b zmm6,zmm6,zmm4", 0x62, 0xf2, 0x4d, 0x48, 0x75, 0xf4);
    /* disp8 */
    FCML_I32("vpermi2b zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf2, 0x6d, 0x48, 0x75, 0x4c, 0x24, 0x08);
    FCML_A32("vpermi2b 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x48, 0x75, 0x4c, 0x24, 0x08);
    FCML_I64("vpermi2b zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf2, 0x6d, 0x48, 0x75, 0x4c, 0x24, 0x08);
    FCML_A64("vpermi2b 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x48, 0x75, 0x4c, 0x24, 0x08);
    FCML_I32("vpermi2b ymm1,ymm2,ymmword ptr [esp+00000100h]", 0x62, 0xf2, 0x6d, 0x28, 0x75, 0x4c, 0x24, 0x08);
    FCML_A32("vpermi2b 0x00000100(%esp),%ymm2,%ymm1", 0x62, 0xf2, 0x6d, 0x28, 0x75, 0x4c, 0x24, 0x08);
    FCML_I64("vpermi2b ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 0x62, 0xf2, 0x6d, 0x28, 0x75, 0x4c, 0x24, 0x08);
    FCML_A64("vpermi2b 0x0000000000000100(%rsp),%ymm2,%ymm1", 0x62, 0xf2, 0x6d, 0x28, 0x75, 0x4c, 0x24, 0x08);
    FCML_I32("vpermi2b xmm1,xmm2,xmmword ptr [esp+00000080h]", 0x62, 0xf2, 0x6d, 0x08, 0x75, 0x4c, 0x24, 0x08);
    FCML_A32("vpermi2b 0x00000080(%esp),%xmm2,%xmm1", 0x62, 0xf2, 0x6d, 0x08, 0x75, 0x4c, 0x24, 0x08);
    FCML_I64("vpermi2b xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 0x62, 0xf2, 0x6d, 0x08, 0x75, 0x4c, 0x24, 0x08);
    FCML_A64("vpermi2b 0x0000000000000080(%rsp),%xmm2,%xmm1", 0x62, 0xf2, 0x6d, 0x08, 0x75, 0x4c, 0x24, 0x08);
    /* {k}{z} */
    FCML_A64("vpermi2b (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x12, 0x0d, 0x8c, 0x75, 0x14, 0x01);
    FCML_I64("vpermi2b xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x8c, 0x75, 0x14, 0x01);
    FCML_A32("vpermi2b (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf2, 0x45, 0x8d, 0x75, 0x14, 0x01);
    FCML_I32("vpermi2b xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x8d, 0x75, 0x14, 0x01);
    FCML_A64("vpermi2b (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x12, 0x0d, 0xac, 0x75, 0x14, 0x01);
    FCML_I64("vpermi2b ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0xac, 0x75, 0x14, 0x01);
    FCML_A32("vpermi2b (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf2, 0x45, 0xad, 0x75, 0x14, 0x01);
    FCML_I32("vpermi2b ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0xad, 0x75, 0x14, 0x01);
    FCML_A64("vpermi2b (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x12, 0x0d, 0xcc, 0x75, 0x14, 0x01);
    FCML_I64("vpermi2b zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0xcc, 0x75, 0x14, 0x01);
    FCML_A32("vpermi2b (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf2, 0x45, 0xcd, 0x75, 0x14, 0x01);
    FCML_I32("vpermi2b zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0xcd, 0x75, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpermi2b (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x12, 0x0d, 0x0c, 0x75, 0x14, 0x01);
    FCML_I64("vpermi2b xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x0c, 0x75, 0x14, 0x01);
    FCML_A32("vpermi2b (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf2, 0x45, 0x0d, 0x75, 0x14, 0x01);
    FCML_I32("vpermi2b xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x0d, 0x75, 0x14, 0x01);
    FCML_A64("vpermi2b (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x12, 0x0d, 0x2c, 0x75, 0x14, 0x01);
    FCML_I64("vpermi2b ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x2c, 0x75, 0x14, 0x01);
    FCML_A32("vpermi2b (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf2, 0x45, 0x2d, 0x75, 0x14, 0x01);
    FCML_I32("vpermi2b ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x2d, 0x75, 0x14, 0x01);
    FCML_A64("vpermi2b (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x12, 0x0d, 0x4c, 0x75, 0x14, 0x01);
    FCML_I64("vpermi2b zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x4c, 0x75, 0x14, 0x01);
    FCML_A32("vpermi2b (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf2, 0x45, 0x4d, 0x75, 0x14, 0x01);
    FCML_I32("vpermi2b zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x4d, 0x75, 0x14, 0x01);
}

void fcml_tf_instruction_VPERMPD(void) {

    FCML_I64_M("vpermpd ymm0,ymmword ptr [rax],0ffh", 2, FCML_MI(0x62, 0xf3, 0xfd, 0x28, 0x01, 0x00, 0xff), FCML_MI(0xc4, 0xe3, 0xfd, 0x01, 0x00, 0xff));
    FCML_I64_M("vpermpd ymm0,ymm0,0ffh", 2, FCML_MI(0x62, 0xf3, 0xfd, 0x28, 0x01, 0xc0, 0xff), FCML_MI(0xc4, 0xe3, 0xfd, 0x01, 0xc0, 0xff));
    FCML_A64_M("vpermpd $0xff,(%rax),%ymm0", 2, FCML_MI(0x62, 0xf3, 0xfd, 0x28, 0x01, 0x00, 0xff), FCML_MI(0xc4, 0xe3, 0xfd, 0x01, 0x00, 0xff));
    FCML_A64_M("vpermpd $0xff,%ymm0,%ymm0", 2, FCML_MI(0x62, 0xf3, 0xfd, 0x28, 0x01, 0xc0, 0xff), FCML_MI(0xc4, 0xe3, 0xfd, 0x01, 0xc0, 0xff));

    FCML_I64("vpermpd zmm0,zmmword ptr [rax],0ffh", 0x62, 0xf3, 0xfd, 0x48, 0x01, 0x00, 0xff);
    FCML_I64("vpermpd zmm0,zmm0,0ffh", 0x62, 0xf3, 0xfd, 0x48, 0x01, 0xc0, 0xff);
    FCML_I64("vpermpd ymm0{k4}{z},ymmword ptr [rax],0ffh", 0x62, 0xf3, 0xfd, 0xac, 0x01, 0x00, 0xff);
    FCML_I64("vpermpd ymm0{k2},ymm0,0ffh", 0x62, 0xf3, 0xfd, 0x2a, 0x01, 0xc0, 0xff);
    FCML_I64("vpermpd zmm0{k4}{z},zmmword ptr [rax],0ffh", 0x62, 0xf3, 0xfd, 0xcc, 0x01, 0x00, 0xff);
    FCML_I64("vpermpd zmm0{k2},zmm0,0ffh", 0x62, 0xf3, 0xfd, 0x4a, 0x01, 0xc0, 0xff);

    FCML_I64("vpermpd zmm0{k4}{z},mmword ptr [rax]{1to8},0ffh", 0x62, 0xf3, 0xfd, 0xdc, 0x01, 0x00, 0xff);
    FCML_I32("vpermpd zmm1,zmmword ptr [esp+00000200h],14h", 0x62, 0xf3, 0xfd, 0x48, 0x01, 0x4c, 0x24, 0x08, 0x14);

    FCML_I64("vpermpd zmm0,zmm4,zmmword ptr [rax]", 0x62, 0xf2, 0xdd, 0x48, 0x16, 0x00);
    FCML_I64("vpermpd zmm0,zmm3,zmm0", 0x62, 0xf2, 0xe5, 0x48, 0x16, 0xc0);
    FCML_I64("vpermpd ymm0{k4}{z},ymm4,ymmword ptr [rax]", 0x62, 0xf2, 0xdd, 0xac, 0x16, 0x00);
    FCML_I64("vpermpd ymm0{k2},ymm7,ymm0", 0x62, 0xf2, 0xc5, 0x2a, 0x16, 0xc0);
    FCML_I64("vpermpd zmm0{k4}{z},zmm30,zmmword ptr [rax]", 0x62, 0xf2, 0x8d, 0xc4, 0x16, 0x00);
    FCML_I64("vpermpd zmm0{k2},zmm27,zmm0", 0x62, 0xf2, 0xa5, 0x42, 0x16, 0xc0);

    FCML_I64("vpermpd zmm0{k4}{z},zmm30,mmword ptr [rax]{1to8}", 0x62, 0xf2, 0x8d, 0xd4, 0x16, 0x00);
    FCML_I32("vpermpd zmm1,zmm6,zmmword ptr [esp+00000200h]", 0x62, 0xf2, 0xcd, 0x48, 0x16, 0x4c, 0x24, 0x08);
}

void fcml_tf_instruction_VPERMQ(void) {
    FCML_I64_M("vpermq ymm0,ymmword ptr [rax],0ffh", 2, FCML_MI(0x62, 0xf3, 0xfd, 0x28, 0x00, 0x00, 0xff), FCML_MI(0xc4, 0xe3, 0xfd, 0x00, 0x00, 0xff));
    FCML_I64_M("vpermq ymm0,ymm0,0ffh", 2, FCML_MI(0x62, 0xf3, 0xfd, 0x28, 0x00, 0xc0, 0xff), FCML_MI(0xc4, 0xe3, 0xfd, 0x00, 0xc0, 0xff));
    FCML_A64_M("vpermq $0xff,(%rax),%ymm0", 2, FCML_MI(0x62, 0xf3, 0xfd, 0x28, 0x00, 0x00, 0xff), FCML_MI(0xc4, 0xe3, 0xfd, 0x00, 0x00, 0xff));
    FCML_A64_M("vpermq $0xff,%ymm0,%ymm0", 2, FCML_MI(0x62, 0xf3, 0xfd, 0x28, 0x00, 0xc0, 0xff), FCML_MI(0xc4, 0xe3, 0xfd, 0x00, 0xc0, 0xff));

    FCML_I64("vpermq zmm0,zmmword ptr [rax],0ffh", 0x62, 0xf3, 0xfd, 0x48, 0x00, 0x00, 0xff);
    FCML_I64("vpermq zmm0,zmm0,0ffh", 0x62, 0xf3, 0xfd, 0x48, 0x00, 0xc0, 0xff);
    FCML_I64("vpermq ymm0{k4}{z},ymmword ptr [rax],0ffh", 0x62, 0xf3, 0xfd, 0xac, 0x00, 0x00, 0xff);
    FCML_I64("vpermq ymm0{k2},ymm0,0ffh", 0x62, 0xf3, 0xfd, 0x2a, 0x00, 0xc0, 0xff);
    FCML_I64("vpermq zmm0{k4}{z},zmmword ptr [rax],0ffh", 0x62, 0xf3, 0xfd, 0xcc, 0x00, 0x00, 0xff);
    FCML_I64("vpermq zmm0{k2},zmm0,0ffh", 0x62, 0xf3, 0xfd, 0x4a, 0x00, 0xc0, 0xff);
    FCML_I64("vpermq zmm0{k4}{z},mmword ptr [rax]{1to8},0ffh", 0x62, 0xf3, 0xfd, 0xdc, 0x00, 0x00, 0xff);
    FCML_I32("vpermq zmm1,zmmword ptr [esp+00000200h],14h", 0x62, 0xf3, 0xfd, 0x48, 0x00, 0x4c, 0x24, 0x08, 0x14);
    FCML_I64("vpermq zmm0,zmm4,zmmword ptr [rax]", 0x62, 0xf2, 0xdd, 0x48, 0x36, 0x00);
    FCML_I64("vpermq zmm0,zmm3,zmm0", 0x62, 0xf2, 0xe5, 0x48, 0x36, 0xc0);
    FCML_I64("vpermq ymm0{k4}{z},ymm4,ymmword ptr [rax]", 0x62, 0xf2, 0xdd, 0xac, 0x36, 0x00);
    FCML_I64("vpermq ymm0{k2},ymm7,ymm0", 0x62, 0xf2, 0xc5, 0x2a, 0x36, 0xc0);
    FCML_I64("vpermq zmm0{k4}{z},zmm30,zmmword ptr [rax]", 0x62, 0xf2, 0x8d, 0xc4, 0x36, 0x00);
    FCML_I64("vpermq zmm0{k2},zmm27,zmm0", 0x62, 0xf2, 0xa5, 0x42, 0x36, 0xc0);
    FCML_I64("vpermq zmm0{k4}{z},zmm30,mmword ptr [rax]{1to8}", 0x62, 0xf2, 0x8d, 0xd4, 0x36, 0x00);
    FCML_I32("vpermq zmm1,zmm6,zmmword ptr [esp+00000200h]", 0x62, 0xf2, 0xcd, 0x48, 0x36, 0x4c, 0x24, 0x08);
}

void fcml_tf_instruction_VPERMPS(void) {
    FCML_I32_M("vpermps ymm0,ymm6,ymmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x4d, 0x28, 0x16, 0x00), FCML_MI(0xc4, 0xe2, 0x4d, 0x16, 0x00));
    FCML_I32_M("vpermps ymm0,ymm6,ymm0", 2, FCML_MI(0x62, 0xf2, 0x4d, 0x28, 0x16, 0xc0), FCML_MI(0xc4, 0xe2, 0x4d, 0x16, 0xc0));
    FCML_I64_M("vpermps ymm0,ymm6,ymmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0x4d, 0x28, 0x16, 0x00), FCML_MI(0xc4, 0xe2, 0x4d, 0x16, 0x00));
    FCML_A64_M("vpermps (%rax),%ymm6,%ymm0", 2, FCML_MI(0x62, 0xf2, 0x4d, 0x28, 0x16, 0x00), FCML_MI(0xc4, 0xe2, 0x4d, 0x16, 0x00));
    FCML_A64_M("vpermps %ymm0,%ymm6,%ymm0", 2, FCML_MI(0x62, 0xf2, 0x4d, 0x28, 0x16, 0xc0), FCML_MI(0xc4, 0xe2, 0x4d, 0x16, 0xc0));
    FCML_A64_M("vpermps (%rax),%ymm6,%ymm0", 2, FCML_MI(0x62, 0xf2, 0x4d, 0x28, 0x16, 0x00), FCML_MI(0xc4, 0xe2, 0x4d, 0x16, 0x00));

    FCML_I64("vpermps zmm0,zmm4,zmmword ptr [rax]", 0x62, 0xf2, 0x5d, 0x48, 0x16, 0x00);
    FCML_I64("vpermps zmm0,zmm3,zmm0", 0x62, 0xf2, 0x65, 0x48, 0x16, 0xc0);
    FCML_I64("vpermps ymm0{k4}{z},ymm4,ymmword ptr [rax]", 0x62, 0xf2, 0x5d, 0xac, 0x16, 0x00);
    FCML_I64("vpermps ymm0{k2},ymm7,ymm0", 0x62, 0xf2, 0x45, 0x2a, 0x16, 0xc0);
    FCML_I64("vpermps zmm0{k4}{z},zmm30,zmmword ptr [rax]", 0x62, 0xf2, 0x0d, 0xc4, 0x16, 0x00);
    FCML_I64("vpermps zmm0{k2},zmm27,zmm0", 0x62, 0xf2, 0x25, 0x42, 0x16, 0xc0);
    FCML_I32("vpermps zmm1,zmm6,zmmword ptr [esp+00000200h]", 0x62, 0xf2, 0x4d, 0x48, 0x16, 0x4c, 0x24, 0x08);

    FCML_I64("vpermps zmm0{k4}{z},zmm30,dword ptr [rax]{1to16}", 0x62, 0xf2, 0x0d, 0xd4, 0x16, 0x00);
}

void fcml_tf_instruction_VPERMT2B(void) {
    /* xmm1, xmm2, m128 */
    FCML_A64("vpermt2b (%rax),%xmm7,%xmm15", 0x62, 0x72, 0x45, 0x08, 0x7d, 0x38);
    FCML_I64("vpermt2b xmm15,xmm7,xmmword ptr [rax]", 0x62, 0x72, 0x45, 0x08, 0x7d, 0x38);
    FCML_A32("vpermt2b (%eax),%xmm6,%xmm7", 0x62, 0xf2, 0x4d, 0x08, 0x7d, 0x38);
    FCML_I32("vpermt2b xmm7,xmm6,xmmword ptr [eax]", 0x62, 0xf2, 0x4d, 0x08, 0x7d, 0x38);
    /* ymm1, ymm2, m256 */
    FCML_A64("vpermt2b (%rax),%ymm7,%ymm15", 0x62, 0x72, 0x45, 0x28, 0x7d, 0x38);
    FCML_I64("vpermt2b ymm15,ymm7,ymmword ptr [rax]", 0x62, 0x72, 0x45, 0x28, 0x7d, 0x38);
    FCML_A32("vpermt2b (%eax),%ymm5,%ymm7", 0x62, 0xf2, 0x55, 0x28, 0x7d, 0x38);
    FCML_I32("vpermt2b ymm7,ymm5,ymmword ptr [eax]", 0x62, 0xf2, 0x55, 0x28, 0x7d, 0x38);
    /* zmm1, zmm2, m512 */
    FCML_A64("vpermt2b (%rax),%zmm7,%zmm15", 0x62, 0x72, 0x45, 0x48, 0x7d, 0x38);
    FCML_I64("vpermt2b zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x72, 0x45, 0x48, 0x7d, 0x38);
    FCML_A32("vpermt2b (%eax),%zmm3,%zmm7", 0x62, 0xf2, 0x65, 0x48, 0x7d, 0x38);
    FCML_I32("vpermt2b zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf2, 0x65, 0x48, 0x7d, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64("vpermt2b %xmm1,%xmm7,%xmm15", 0x62, 0x72, 0x45, 0x08, 0x7d, 0xf9);
    FCML_I64("vpermt2b xmm15,xmm7,xmm1", 0x62, 0x72, 0x45, 0x08, 0x7d, 0xf9);
    FCML_A32("vpermt2b %xmm1,%xmm2,%xmm7", 0x62, 0xf2, 0x6d, 0x08, 0x7d, 0xf9);
    FCML_I32("vpermt2b xmm7,xmm2,xmm1", 0x62, 0xf2, 0x6d, 0x08, 0x7d, 0xf9);
    /* ymm1, ymm2, ymm3 */
    FCML_A64("vpermt2b %ymm6,%ymm7,%ymm14", 0x62, 0x72, 0x45, 0x28, 0x7d, 0xf6);
    FCML_I64("vpermt2b ymm14,ymm7,ymm6", 0x62, 0x72, 0x45, 0x28, 0x7d, 0xf6);
    FCML_A32("vpermt2b %ymm5,%ymm3,%ymm6", 0x62, 0xf2, 0x65, 0x28, 0x7d, 0xf5);
    FCML_I32("vpermt2b ymm6,ymm3,ymm5", 0x62, 0xf2, 0x65, 0x28, 0x7d, 0xf5);
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpermt2b %zmm4,%zmm15,%zmm6", 0x62, 0xf2, 0x05, 0x48, 0x7d, 0xf4);
    FCML_I64("vpermt2b zmm6,zmm15,zmm4", 0x62, 0xf2, 0x05, 0x48, 0x7d, 0xf4);
    FCML_A32("vpermt2b %zmm4,%zmm6,%zmm6", 0x62, 0xf2, 0x4d, 0x48, 0x7d, 0xf4);
    FCML_I32("vpermt2b zmm6,zmm6,zmm4", 0x62, 0xf2, 0x4d, 0x48, 0x7d, 0xf4);
    /* disp8 */
    FCML_I32("vpermt2b zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf2, 0x6d, 0x48, 0x7d, 0x4c, 0x24, 0x08);
    FCML_A32("vpermt2b 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x48, 0x7d, 0x4c, 0x24, 0x08);
    FCML_I64("vpermt2b zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf2, 0x6d, 0x48, 0x7d, 0x4c, 0x24, 0x08);
    FCML_A64("vpermt2b 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x48, 0x7d, 0x4c, 0x24, 0x08);
    FCML_I32("vpermt2b ymm1,ymm2,ymmword ptr [esp+00000100h]", 0x62, 0xf2, 0x6d, 0x28, 0x7d, 0x4c, 0x24, 0x08);
    FCML_A32("vpermt2b 0x00000100(%esp),%ymm2,%ymm1", 0x62, 0xf2, 0x6d, 0x28, 0x7d, 0x4c, 0x24, 0x08);
    FCML_I64("vpermt2b ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 0x62, 0xf2, 0x6d, 0x28, 0x7d, 0x4c, 0x24, 0x08);
    FCML_A64("vpermt2b 0x0000000000000100(%rsp),%ymm2,%ymm1", 0x62, 0xf2, 0x6d, 0x28, 0x7d, 0x4c, 0x24, 0x08);
    FCML_I32("vpermt2b xmm1,xmm2,xmmword ptr [esp+00000080h]", 0x62, 0xf2, 0x6d, 0x08, 0x7d, 0x4c, 0x24, 0x08);
    FCML_A32("vpermt2b 0x00000080(%esp),%xmm2,%xmm1", 0x62, 0xf2, 0x6d, 0x08, 0x7d, 0x4c, 0x24, 0x08);
    FCML_I64("vpermt2b xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 0x62, 0xf2, 0x6d, 0x08, 0x7d, 0x4c, 0x24, 0x08);
    FCML_A64("vpermt2b 0x0000000000000080(%rsp),%xmm2,%xmm1", 0x62, 0xf2, 0x6d, 0x08, 0x7d, 0x4c, 0x24, 0x08);
    /* {k}{z} */
    FCML_A64("vpermt2b (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x12, 0x0d, 0x8c, 0x7d, 0x14, 0x01);
    FCML_I64("vpermt2b xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x8c, 0x7d, 0x14, 0x01);
    FCML_A32("vpermt2b (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf2, 0x45, 0x8d, 0x7d, 0x14, 0x01);
    FCML_I32("vpermt2b xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x8d, 0x7d, 0x14, 0x01);
    FCML_A64("vpermt2b (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x12, 0x0d, 0xac, 0x7d, 0x14, 0x01);
    FCML_I64("vpermt2b ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0xac, 0x7d, 0x14, 0x01);
    FCML_A32("vpermt2b (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf2, 0x45, 0xad, 0x7d, 0x14, 0x01);
    FCML_I32("vpermt2b ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0xad, 0x7d, 0x14, 0x01);
    FCML_A64("vpermt2b (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x12, 0x0d, 0xcc, 0x7d, 0x14, 0x01);
    FCML_I64("vpermt2b zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0xcc, 0x7d, 0x14, 0x01);
    FCML_A32("vpermt2b (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf2, 0x45, 0xcd, 0x7d, 0x14, 0x01);
    FCML_I32("vpermt2b zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0xcd, 0x7d, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpermt2b (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x12, 0x0d, 0x0c, 0x7d, 0x14, 0x01);
    FCML_I64("vpermt2b xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x0c, 0x7d, 0x14, 0x01);
    FCML_A32("vpermt2b (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf2, 0x45, 0x0d, 0x7d, 0x14, 0x01);
    FCML_I32("vpermt2b xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x0d, 0x7d, 0x14, 0x01);
    FCML_A64("vpermt2b (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x12, 0x0d, 0x2c, 0x7d, 0x14, 0x01);
    FCML_I64("vpermt2b ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x2c, 0x7d, 0x14, 0x01);
    FCML_A32("vpermt2b (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf2, 0x45, 0x2d, 0x7d, 0x14, 0x01);
    FCML_I32("vpermt2b ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x2d, 0x7d, 0x14, 0x01);
    FCML_A64("vpermt2b (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x12, 0x0d, 0x4c, 0x7d, 0x14, 0x01);
    FCML_I64("vpermt2b zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x4c, 0x7d, 0x14, 0x01);
    FCML_A32("vpermt2b (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf2, 0x45, 0x4d, 0x7d, 0x14, 0x01);
    FCML_I32("vpermt2b zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x4d, 0x7d, 0x14, 0x01);
}

void fcml_tf_instruction_VPERM2F128(void) {

    FCML_I32( "vperm2f128 ymm0,ymm6,ymmword ptr [eax],0ffh", 0xC4, 0xE3, 0x4D, 0x06, 0x00, 0xFF );
    FCML_I32( "vperm2f128 ymm0,ymm6,ymm0,0ffh", 0xC4, 0xE3, 0x4D, 0x06, 0xC0, 0xFF );
    FCML_I64( "vperm2f128 ymm0,ymm6,ymmword ptr [rax],0ffh", 0xC4, 0xE3, 0x4D, 0x06, 0x00, 0xFF );

    FCML_A64( "vperm2f128 $0xff,(%rax),%ymm6,%ymm0", 0xc4, 0xe3, 0x4d, 0x06, 0x00, 0xff );
    FCML_A64( "vperm2f128 $0xff,%ymm0,%ymm6,%ymm0", 0xc4, 0xe3, 0x4d, 0x06, 0xc0, 0xff );
    FCML_A64( "vperm2f128 $0xff,(%rax),%ymm6,%ymm0", 0xc4, 0xe3, 0x4d, 0x06, 0x00, 0xff );
}

void fcml_tf_instruction_VPERM2I128(void) {

    FCML_I32( "vperm2i128 ymm0,ymm6,ymmword ptr [eax],0ffh", 0xC4, 0xE3, 0x4D, 0x46, 0x00, 0xFF );
    FCML_I32( "vperm2i128 ymm0,ymm6,ymm0,0ffh", 0xC4, 0xE3, 0x4D, 0x46, 0xC0, 0xFF );
    FCML_I64( "vperm2i128 ymm0,ymm6,ymmword ptr [rax],0ffh", 0xC4, 0xE3, 0x4D, 0x46, 0x00, 0xFF );

    FCML_A64( "vperm2i128 $0xff,(%rax),%ymm6,%ymm0", 0xc4, 0xe3, 0x4d, 0x46, 0x00, 0xff );
    FCML_A64( "vperm2i128 $0xff,%ymm0,%ymm6,%ymm0", 0xc4, 0xe3, 0x4d, 0x46, 0xc0, 0xff );
    FCML_A64( "vperm2i128 $0xff,(%rax),%ymm6,%ymm0", 0xc4, 0xe3, 0x4d, 0x46, 0x00, 0xff );
}

void fcml_tf_instruction_VEXTRACTI128(void) {

    FCML_I32( "vextracti128 xmmword ptr [eax],ymm0,0ffh", 0xC4, 0xE3, 0x7D, 0x39, 0x00, 0xFF );
    FCML_I64( "vextracti128 xmm0,ymm0,0ffh", 0xC4, 0xE3, 0x7D, 0x39, 0xC0, 0xFF );

    FCML_A64( "vextracti128 $0xff,%ymm0,(%rax)", 0xc4, 0xe3, 0x7d, 0x39, 0x00, 0xff );
    FCML_A64( "vextracti128 $0xff,%ymm0,%xmm0", 0xc4, 0xe3, 0x7d, 0x39, 0xc0, 0xff );
}

void fcml_tf_instruction_VINSERTI128(void) {

    FCML_I32( "vinserti128 ymm0,ymm6,xmmword ptr [eax],0ffh", 0xC4, 0xE3, 0x4D, 0x38, 0x00, 0xFF );
    FCML_I32( "vinserti128 ymm0,ymm6,xmm0,0ffh", 0xC4, 0xE3, 0x4D, 0x38, 0xC0, 0xFF );
    FCML_I64( "vinserti128 ymm0,ymm6,xmmword ptr [rax],0ffh", 0xC4, 0xE3, 0x4D, 0x38, 0x00, 0xFF );

    FCML_A64( "vinserti128 $0xff,(%rax),%ymm6,%ymm0", 0xc4, 0xe3, 0x4d, 0x38, 0x00, 0xff );
    FCML_A64( "vinserti128 $0xff,%xmm0,%ymm6,%ymm0", 0xc4, 0xe3, 0x4d, 0x38, 0xc0, 0xff );
    FCML_A64( "vinserti128 $0xff,(%rax),%ymm6,%ymm0", 0xc4, 0xe3, 0x4d, 0x38, 0x00, 0xff );
}

void fcml_tf_instruction_VTESTPS(void) {

    FCML_I64( "vtestps xmm1,xmm0", 0xC4, 0xE2, 0x79, 0x0E, 0xC8 );
    FCML_I32( "vtestps xmm1,xmm0", 0xC4, 0xE2, 0x79, 0x0E, 0xC8 );
    FCML_I32( "vtestps xmm0,xmmword ptr [eax]", 0xC4, 0xE2, 0x79, 0x0E, 0x00 );
    FCML_I32( "vtestps ymm0,ymmword ptr [eax]", 0xC4, 0xE2, 0x7D, 0x0E, 0x00 );

    FCML_I64( "vtestpd xmm0,xmm0", 0xC4, 0xE2, 0x79, 0x0f, 0xC0 );
    FCML_I32( "vtestpd xmm0,xmm0", 0xC4, 0xE2, 0x79, 0x0f, 0xC0 );
    FCML_I32( "vtestpd xmm0,xmmword ptr [eax]", 0xC4, 0xE2, 0x79, 0x0F, 0x00 );
    FCML_I32( "vtestpd ymm0,ymmword ptr [eax]", 0xC4, 0xE2, 0x7D, 0x0F, 0x00 );

    FCML_A64( "vtestps %xmm0,%xmm1", 0xc4, 0xe2, 0x79, 0x0e, 0xc8 );
    FCML_A64( "vtestps (%rax),%xmm0", 0xc4, 0xe2, 0x79, 0x0e, 0x00 );
    FCML_A64( "vtestps (%rax),%ymm0", 0xc4, 0xe2, 0x7d, 0x0e, 0x00 );
    FCML_A64( "vtestpd %xmm0,%xmm0", 0xc4, 0xe2, 0x79, 0x0f, 0xc0 );
    FCML_A64( "vtestpd (%rax),%xmm0", 0xc4, 0xe2, 0x79, 0x0f, 0x00 );
    FCML_A64( "vtestpd (%rax),%ymm0", 0xc4, 0xe2, 0x7d, 0x0f, 0x00 );
}

void fcml_tf_instruction_VGATHERDPD(void) {
    FCML_I64_A("vgatherdpd xmm0,dword ptr [rax+xmm5],xmm0", 0xC4, 0xE2, 0xF9, 0x92, 0x04, 0x28);
    FCML_I64_A("vgatherdpd ymm0,dword ptr [rax+xmm5],ymm0", 0xc4, 0xe2, 0xFD, 0x92, 0x04, 0x28);

    FCML_A64("vgatherdpd %xmm0,(%rax,%xmm5),%xmm2", 0xc4, 0xe2, 0xf9, 0x92, 0x14, 0x28);
    FCML_A64("vgatherdpd %ymm0,(%rax,%xmm5),%ymm2", 0xc4, 0xe2, 0xfd, 0x92, 0x14, 0x28);
    FCML_A64_A_FAILED( "vgatherdpd %zmm0,(%rax,%ymm5),%zmm2", 0xc4, 0xe2, 0xf9, 0x92, 0x04, 0x28 );

    FCML_A64("vgatherdpd (%rax,%xmm5),%xmm2{%k2}", 0x62, 0xf2, 0xfd, 0x0a, 0x92, 0x14, 0x28);
    FCML_A64("vgatherdpd (%rax,%xmm5),%ymm2{%k3}", 0x62, 0xf2, 0xfd, 0x2b, 0x92, 0x14, 0x28);
    FCML_A64("vgatherdpd (%rax,%ymm5),%zmm2{%k1}", 0x62, 0xf2, 0xfd, 0x49, 0x92, 0x14, 0x28);

    FCML_I64("vgatherdpd zmm5{k2},dword ptr [rax+ymm5+0000000000000020h]", 0x62, 0xf2, 0xfd, 0x4a, 0x92, 0x6c, 0x28, 0x08);

    // TODO: Generate warnings for unsupported combination of registers for instance xmm1, xmm1, xmm1.
}

void fcml_tf_instruction_VGATHERQPD(void) {
    FCML_I64( "vgatherqpd xmm0,mmword ptr [rax+xmm5],xmm0", 0xC4, 0xE2, 0xF9, 0x93, 0x04, 0x28 );
    FCML_I64( "vgatherqpd ymm0,mmword ptr [rax+ymm5],ymm0", 0xC4, 0xE2, 0xFD, 0x93, 0x04, 0x28 );

    FCML_A64("vgatherqpd (%rax,%xmm5),%xmm2{%k2}", 0x62, 0xf2, 0xfd, 0x0a, 0x93, 0x14, 0x28);
    FCML_A64("vgatherqpd (%rax,%ymm5),%ymm2{%k3}", 0x62, 0xf2, 0xfd, 0x2b, 0x93, 0x14, 0x28);
    FCML_A64("vgatherqpd (%rax,%zmm5),%zmm2{%k1}", 0x62, 0xf2, 0xfd, 0x49, 0x93, 0x14, 0x28);

    FCML_I64("vgatherqpd ymm5{k5},mmword ptr [rax+ymm5+0000000000000040h]", 0x62, 0xf2, 0xfd, 0x2d, 0x93, 0x6c, 0x28, 0x08);
}

void fcml_tf_instruction_VGATHERDPS(void) {
    FCML_I32("vgatherdps xmm0,dword ptr [eax+xmm5],xmm0", 0xc4, 0xe2, 0x79, 0x92, 0x04, 0x28);
    FCML_I32("vgatherdps ymm0,dword ptr [eax+ymm5],ymm0", 0xc4, 0xe2, 0x7d, 0x92, 0x04, 0x28);
    FCML_A64("vgatherdps %xmm0,(%rax,%xmm5),%xmm0", 0xc4, 0xe2, 0x79, 0x92, 0x04, 0x28);
    FCML_A64("vgatherdps %ymm0,(%rax,%ymm5),%ymm0", 0xc4, 0xe2, 0x7d, 0x92, 0x04, 0x28);

    FCML_A64_A_FAILED("vgatherdps %zmm0,(%rax,%zmm5),%zmm0", 0x62, 0xf2, 0x7d, 0x48, 0x92, 0x04, 0x28);

    FCML_A64("vgatherdps (%rax,%xmm5),%xmm2{%k2}", 0x62, 0xf2, 0x7d, 0x0a, 0x92, 0x14, 0x28);
    FCML_A64("vgatherdps (%rax,%ymm5),%ymm2{%k3}", 0x62, 0xf2, 0x7d, 0x2b, 0x92, 0x14, 0x28);
    FCML_A64("vgatherdps (%rax,%zmm5),%zmm2{%k1}", 0x62, 0xf2, 0x7d, 0x49, 0x92, 0x14, 0x28);

    FCML_I64("vgatherdps zmm5{k2},dword ptr [rax+zmm5+0000000000000020h]", 0x62, 0xf2, 0x7d, 0x4a, 0x92, 0x6c, 0x28, 0x08);
}

void fcml_tf_instruction_VGATHERQPS(void) {
    FCML_I32( "vgatherqps xmm0,mmword ptr [eax+xmm5],xmm0", 0xC4, 0xE2, 0x79, 0x93, 0x04, 0x28 );
    FCML_I32( "vgatherqps xmm0,mmword ptr [eax+ymm5],xmm0", 0xC4, 0xE2, 0x7D, 0x93, 0x04, 0x28 );

    FCML_A64( "vgatherqps %xmm0,(%rax,%xmm5),%xmm0", 0xc4, 0xe2, 0x79, 0x93, 0x04, 0x28 );
    FCML_A64( "vgatherqps %xmm0,(%rax,%ymm5),%xmm0", 0xc4, 0xe2, 0x7d, 0x93, 0x04, 0x28 );

    FCML_A64("vgatherqps (%rax,%xmm5),%xmm2{%k2}", 0x62, 0xf2, 0x7d, 0x0a, 0x93, 0x14, 0x28);
    FCML_A64("vgatherqps (%rax,%ymm5),%xmm2{%k3}", 0x62, 0xf2, 0x7d, 0x2b, 0x93, 0x14, 0x28);
    FCML_A64("vgatherqps (%rax,%zmm5),%ymm2{%k1}", 0x62, 0xf2, 0x7d, 0x49, 0x93, 0x14, 0x28);

    FCML_I64("vgatherqps ymm5{k1},mmword ptr [rax+zmm5+0000000000000040h]", 0x62, 0xf2, 0x7d, 0x49, 0x93, 0x6c, 0x28, 0x08);
}

void fcml_tf_instruction_VPGATHERDD(void) {

    FCML_I32( "vpgatherdd xmm0,dword ptr [eax+xmm5],xmm0", 0xC4, 0xE2, 0x79, 0x90, 0x04, 0x28 );
    FCML_I32( "vpgatherdd ymm0,dword ptr [eax+ymm5],ymm0", 0xC4, 0xE2, 0x7D, 0x90, 0x04, 0x28 );

    FCML_A64( "vpgatherdd %xmm0,(%rax,%xmm5),%xmm0", 0xc4, 0xe2, 0x79, 0x90, 0x04, 0x28 );
    FCML_A64( "vpgatherdd %ymm0,(%rax,%ymm5),%ymm0", 0xc4, 0xe2, 0x7d, 0x90, 0x04, 0x28 );

    FCML_A64("vpgatherdd (%rax,%xmm5),%xmm2{%k2}", 0x62, 0xf2, 0x7d, 0x0a, 0x90, 0x14, 0x28);
    FCML_A64("vpgatherdd (%rax,%ymm5),%ymm2{%k3}", 0x62, 0xf2, 0x7d, 0x2b, 0x90, 0x14, 0x28);
    FCML_A64("vpgatherdd (%rax,%zmm5),%zmm2{%k1}", 0x62, 0xf2, 0x7d, 0x49, 0x90, 0x14, 0x28);
    FCML_I64("vpgatherdd zmm5{k1},dword ptr [rax+zmm5+0000000000000020h]", 0x62, 0xf2, 0x7d, 0x49, 0x90, 0x6c, 0x28, 0x08);
}

void fcml_tf_instruction_VPGATHERDQ(void) {

    FCML_I64( "vpgatherdq xmm0,dword ptr [rax+xmm5],xmm0", 0xC4, 0xE2, 0xF9, 0x90, 0x04, 0x28 );
    FCML_I64( "vpgatherdq ymm0,dword ptr [rax+xmm5],ymm0", 0xC4, 0xE2, 0xFD, 0x90, 0x04, 0x28 );

    FCML_I64( "vpgatherqq xmm0,mmword ptr [rax+xmm5],xmm0", 0xC4, 0xE2, 0xF9, 0x91, 0x04, 0x28 );
    FCML_I64( "vpgatherqq ymm0,mmword ptr [rax+ymm5],ymm0", 0xC4, 0xE2, 0xFD, 0x91, 0x04, 0x28 );

    FCML_A64( "vpgatherdq %xmm0,(%rax,%xmm5),%xmm0", 0xc4, 0xe2, 0xf9, 0x90, 0x04, 0x28 );
    FCML_A64( "vpgatherdq %ymm0,(%rax,%xmm5),%ymm0", 0xc4, 0xe2, 0xfd, 0x90, 0x04, 0x28 );
    FCML_A64( "vpgatherqq %xmm0,(%rax,%xmm5),%xmm0", 0xc4, 0xe2, 0xf9, 0x91, 0x04, 0x28 );
    FCML_A64( "vpgatherqq %ymm0,(%rax,%ymm5),%ymm0", 0xc4, 0xe2, 0xfd, 0x91, 0x04, 0x28 );

    FCML_A64("vpgatherdq (%rax,%xmm5),%xmm2{%k2}", 0x62, 0xf2, 0xfd, 0x0a, 0x90, 0x14, 0x28);
    FCML_A64("vpgatherdq (%rax,%xmm5),%ymm2{%k3}", 0x62, 0xf2, 0xfd, 0x2b, 0x90, 0x14, 0x28);
    FCML_A64("vpgatherdq (%rax,%ymm5),%zmm2{%k1}", 0x62, 0xf2, 0xfd, 0x49, 0x90, 0x14, 0x28);
    FCML_I64("vpgatherdq zmm5{k3},dword ptr [rax+ymm5+0000000000000020h]", 0x62, 0xf2, 0xfd, 0x4b, 0x90, 0x6c, 0x28, 0x08);
}

void fcml_tf_instruction_VPGATHERQD(void) {
    FCML_I32("vpgatherqd xmm0,mmword ptr [eax+xmm5],xmm0", 0xc4, 0xe2, 0x79, 0x91, 0x04, 0x28);
    FCML_A64("vpgatherqd %xmm0,(%rax,%xmm5),%xmm0", 0xc4, 0xe2, 0x79, 0x91, 0x04, 0x28);
    FCML_A64("vpgatherqd (%rax,%xmm5),%xmm2{%k2}", 0x62, 0xf2, 0x7d, 0x0a, 0x91, 0x14, 0x28);
    FCML_A64("vpgatherqd (%rax,%ymm5),%ymm2{%k3}", 0x62, 0xf2, 0x7d, 0x2b, 0x91, 0x14, 0x28);
    FCML_A64("vpgatherqd (%rax,%zmm5),%zmm2{%k1}", 0x62, 0xf2, 0x7d, 0x49, 0x91, 0x14, 0x28);
    FCML_I64("vpgatherqd zmm5{k2},mmword ptr [rax+zmm5+0000000000000020h]", 0x62, 0xf2, 0x7d, 0x4a, 0x91, 0x6c, 0x28, 0x04);
}

void fcml_tf_instruction_VPGATHERQQ(void) {
    FCML_I32("vpgatherqq xmm0,mmword ptr [eax+xmm5],xmm0", 0xc4, 0xe2, 0xf9, 0x91, 0x04, 0x28);
    FCML_A64("vpgatherqq %xmm0,(%rax,%xmm5),%xmm0", 0xc4, 0xe2, 0xf9, 0x91, 0x04, 0x28);
    FCML_A64("vpgatherqq (%rax,%xmm5),%xmm2{%k2}", 0x62, 0xf2, 0xfd, 0x0a, 0x91, 0x14, 0x28);
    FCML_A64("vpgatherqq (%rax,%ymm5),%ymm2{%k3}", 0x62, 0xf2, 0xfd, 0x2b, 0x91, 0x14, 0x28);
    FCML_A64("vpgatherqq (%rax,%zmm5),%zmm2{%k1}", 0x62, 0xf2, 0xfd, 0x49, 0x91, 0x14, 0x28);
    FCML_I64("vpgatherqq zmm5{k5},mmword ptr [rax+zmm5+0000000000000020h]", 0x62, 0xf2, 0xfd, 0x4d, 0x91, 0x6c, 0x28, 0x04);
}

void fcml_tf_instruction_VZEROALL(void) {

    FCML_I64( "vzeroall", 0xc5, 0xfc, 0x77 );
    FCML_I32( "vzeroall", 0xc5, 0xfc, 0x77 );

    FCML_A32( "vzeroall", 0xc5, 0xfc, 0x77 );
    FCML_A64( "vzeroall", 0xc5, 0xfc, 0x77 );
}

void fcml_tf_instruction_VZEROUPPER(void) {

    FCML_I64( "vzeroupper", 0xc5, 0xf8, 0x77 );
    FCML_I32( "vzeroupper", 0xc5, 0xf8, 0x77 );

    FCML_A32( "vzeroupper", 0xc5, 0xf8, 0x77 );
    FCML_A64( "vzeroupper", 0xc5, 0xf8, 0x77 );
}

void fcml_tf_instruction_VFMADDPD(void) {

    FCML_I64_M("vfmadd132pd xmm0,xmm3,xmmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0x98, 0x00), FCML_MI(0xc4, 0xe2, 0xe1, 0x98, 0x00));
    FCML_I64_M("vfmadd132pd ymm0,ymm3,ymmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0x98, 0x00), FCML_MI(0xc4, 0xe2, 0xe5, 0x98, 0x00));
    FCML_I64_M("vfmadd132pd ymm0,ymm3,ymm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0x98, 0xc0), FCML_MI(0xc4, 0xe2, 0xe5, 0x98, 0xc0));

    FCML_I64_M("vfmadd213pd xmm0,xmm3,xmmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0xa8, 0x00), FCML_MI(0xc4, 0xe2, 0xe1, 0xa8, 0x00));
    FCML_I64_M("vfmadd213pd ymm0,ymm3,ymmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0xa8, 0x00), FCML_MI(0xc4, 0xe2, 0xe5, 0xa8, 0x00));
    FCML_I64_M("vfmadd213pd ymm0,ymm3,ymm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0xa8, 0xc0), FCML_MI(0xc4, 0xe2, 0xe5, 0xa8, 0xc0));

    FCML_I64_M("vfmadd231pd xmm0,xmm3,xmmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0xb8, 0x00), FCML_MI(0xc4, 0xe2, 0xe1, 0xb8, 0x00));
    FCML_I64_M("vfmadd231pd ymm0,ymm3,ymmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0xb8, 0x00), FCML_MI(0xc4, 0xe2, 0xe5, 0xb8, 0x00));
    FCML_I64_M("vfmadd231pd ymm0,ymm3,ymm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0xb8, 0xc0), FCML_MI(0xc4, 0xe2, 0xe5, 0xb8, 0xc0));

    FCML_I32( "vfmaddpd xmm2,xmm5,xmmword ptr [ecx+eax],xmm2", 0xC4, 0xE3, 0x51, 0x69, 0x14, 0x01, 0x20 );
    FCML_I64( "vfmaddpd ymm2,ymm5,ymmword ptr [rcx+rax],ymm2", 0xC4, 0xE3, 0x55, 0x69, 0x14, 0x01, 0x20 );
    FCML_I64_M( "vfmaddpd ymm0,ymm5,ymm0,ymm2", 2, FCML_MI( 0xc4, 0xe3, 0xd5, 0x69, 0xc2, 0x00 ), FCML_MI( 0xc4, 0xe3, 0x55, 0x69, 0xc0, 0x20 ) );

    FCML_I64( "vfmaddpd xmm2,xmm5,xmm2,xmmword ptr [rcx+rax]", 0xC4, 0xE3, 0xD1, 0x69, 0x14, 0x01, 0x20 );
    FCML_I64( "vfmaddpd ymm2,ymm5,ymm2,ymmword ptr [rcx+rax]", 0xC4, 0xE3, 0xD5, 0x69, 0x14, 0x01, 0x20 );
    FCML_I64_M( "vfmaddpd ymm0,ymm5,ymm2,ymm0", 2, FCML_MI( 0xc4, 0xe3, 0xd5, 0x69, 0xc0, 0x20 ), FCML_MI( 0xc4, 0xe3, 0x55, 0x69, 0xc2, 0x00 ) );

    FCML_A64_M("vfmadd132pd (%rax),%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0x98, 0x00), FCML_MI(0xc4, 0xe2, 0xe1, 0x98, 0x00));
    FCML_A64_M("vfmadd132pd (%rax),%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0x98, 0x00), FCML_MI(0xc4, 0xe2, 0xe5, 0x98, 0x00));
    FCML_A64_M("vfmadd132pd %ymm0,%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0x98, 0xc0), FCML_MI(0xc4, 0xe2, 0xe5, 0x98, 0xc0));
    FCML_A64_M("vfmadd213pd (%rax),%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0xa8, 0x00), FCML_MI(0xc4, 0xe2, 0xe1, 0xa8, 0x00));
    FCML_A64_M("vfmadd213pd (%rax),%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0xa8, 0x00), FCML_MI(0xc4, 0xe2, 0xe5, 0xa8, 0x00));
    FCML_A64_M("vfmadd213pd %ymm0,%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0xa8, 0xc0), FCML_MI(0xc4, 0xe2, 0xe5, 0xa8, 0xc0));
    FCML_A64_M("vfmadd231pd (%rax),%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0xb8, 0x00), FCML_MI(0xc4, 0xe2, 0xe1, 0xb8, 0x00));
    FCML_A64_M("vfmadd231pd (%rax),%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0xb8, 0x00), FCML_MI(0xc4, 0xe2, 0xe5, 0xb8, 0x00));
    FCML_A64_M("vfmadd231pd %ymm0,%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0xb8, 0xc0), FCML_MI(0xc4, 0xe2, 0xe5, 0xb8, 0xc0));

    FCML_A64("vfmadd132pd %xmm5,%xmm3,%xmm0{%k1}{z}", 0x62, 0xf2, 0xe5, 0x89, 0x98, 0xc5);
    FCML_A64("vfmadd213pd (%rax),%xmm3,%xmm0{%k2}", 0x62, 0xf2, 0xe5, 0x0a, 0xa8, 0x00);
    FCML_A64("vfmadd231pd (%rax),%xmm3,%xmm0{%k1}", 0x62, 0xf2, 0xe5, 0x09, 0xb8, 0x00);

    FCML_I64("vfmadd132pd ymm31{k7}{z},ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x62, 0xd5, 0xb7, 0x98, 0x3e);
    FCML_I64("vfmadd213pd ymm31{k7}{z},ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x62, 0xd5, 0xb7, 0xa8, 0x3e);
    FCML_I64("vfmadd231pd ymm31{k7}{z},ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x62, 0xd5, 0xb7, 0xb8, 0x3e);

    FCML_I64_M("vfmadd132pd xmm1,xmm5,xmmword ptr [rsp+0000000000000020h]", 2, FCML_MI(0x62, 0xf2, 0xd5, 0x08, 0x98, 0x4c, 0x24, 0x02), FCML_MI(0xc4, 0xe2, 0xd1, 0x98, 0x4c, 0x24, 0x20));
    FCML_I64_M("vfmadd213pd xmm1,xmm5,xmmword ptr [rsp+0000000000000020h]", 2, FCML_MI(0x62, 0xf2, 0xd5, 0x08, 0xa8, 0x4c, 0x24, 0x02), FCML_MI(0xc4, 0xe2, 0xd1, 0xa8, 0x4c, 0x24, 0x20));
    FCML_I64("vfmadd231pd xmm1{k4},xmm5,xmmword ptr [rsp+0000000000000020h]", 0x62, 0xf2, 0xd5, 0x0c, 0xb8, 0x4c, 0x24, 0x02);

    FCML_A64( "vfmaddpd %xmm2,(%rcx,%rax),%xmm5,%xmm2", 0xc4, 0xe3, 0x51, 0x69, 0x14, 0x01, 0x20 );
    FCML_A64( "vfmaddpd %ymm2,(%rcx,%rax),%ymm5,%ymm2", 0xc4, 0xe3, 0x55, 0x69, 0x14, 0x01, 0x20 );
    FCML_A64( "vfmaddpd (%rcx,%rax),%xmm2,%xmm5,%xmm2", 0xc4, 0xe3, 0xd1, 0x69, 0x14, 0x01, 0x20 );
    FCML_A64( "vfmaddpd (%rcx,%rax),%ymm2,%ymm5,%ymm2", 0xc4, 0xe3, 0xd5, 0x69, 0x14, 0x01, 0x20 );
    FCML_A64_M( "vfmaddpd %ymm2,%ymm0,%ymm5,%ymm0", 2, FCML_MI( 0xc4, 0xe3, 0xd5, 0x69, 0xc2, 0x00 ), FCML_MI( 0xc4, 0xe3, 0x55, 0x69, 0xc0, 0x20 ) );
    FCML_A64_M( "vfmaddpd %ymm2,%ymm0,%ymm5,%ymm0", 2, FCML_MI( 0xc4, 0xe3, 0xd5, 0x69, 0xc2, 0x00 ), FCML_MI( 0xc4, 0xe3, 0x55, 0x69, 0xc0, 0x20 ) );
    FCML_A64_M( "vfmaddpd %ymm0,%ymm2,%ymm5,%ymm0", 2, FCML_MI( 0xc4, 0xe3, 0xd5, 0x69, 0xc0, 0x20 ), FCML_MI( 0xc4, 0xe3, 0x55, 0x69, 0xc2, 0x00 ) );
    FCML_A64_M( "vfmaddpd %ymm0,%ymm2,%ymm5,%ymm0", 2, FCML_MI( 0xc4, 0xe3, 0xd5, 0x69, 0xc0, 0x20 ), FCML_MI( 0xc4, 0xe3, 0x55, 0x69, 0xc2, 0x00 ) );
}

void fcml_tf_instruction_VFMADDPS(void) {

    FCML_I64( "vfmaddps xmm2,xmm5,xmmword ptr [rcx+rax],xmm2", 0xC4, 0xE3, 0x51, 0x68, 0x14, 0x01, 0x20 );
    FCML_I64( "vfmaddps ymm2,ymm5,ymmword ptr [rcx+rax],ymm2", 0xC4, 0xE3, 0x55, 0x68, 0x14, 0x01, 0x20 );
    FCML_I64_M( "vfmaddps ymm0,ymm5,ymm0,ymm2", 2, FCML_MI( 0xc4, 0xe3, 0xd5, 0x68, 0xc2, 0x00 ), FCML_MI( 0xc4, 0xe3, 0x55, 0x68, 0xc0, 0x20 ) );

    FCML_I64( "vfmaddps xmm2,xmm5,xmm2,xmmword ptr [rcx+rax]", 0xC4, 0xE3, 0xD1, 0x68, 0x14, 0x01, 0x20 );
    FCML_I64( "vfmaddps ymm2,ymm5,ymm2,ymmword ptr [rcx+rax]", 0xC4, 0xE3, 0xD5, 0x68, 0x14, 0x01, 0x20 );
    FCML_I64_M( "vfmaddps ymm0,ymm5,ymm0,ymm2", 2, FCML_MI( 0xc4, 0xe3, 0xd5, 0x68, 0xc2, 0x00 ), FCML_MI( 0xc4, 0xe3, 0x55, 0x68, 0xc0, 0x20 ) );

    FCML_I32_M("vfmadd132ps xmm0,xmm3,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0x98, 0x00), FCML_MI(0xc4, 0xe2, 0x61, 0x98, 0x00));
    FCML_I64_M("vfmadd132ps ymm0,ymm3,ymmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0x98, 0x00), FCML_MI(0xc4, 0xe2, 0x65, 0x98, 0x00));
    FCML_I32_M("vfmadd132ps ymm0,ymm3,ymm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0x98, 0xc0), FCML_MI(0xc4, 0xe2, 0x65, 0x98, 0xc0));

    FCML_I32_M("vfmadd213ps xmm0,xmm3,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0xa8, 0x00), FCML_MI(0xc4, 0xe2, 0x61, 0xa8, 0x00));
    FCML_I64_M("vfmadd213ps ymm0,ymm3,ymmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0xa8, 0x00), FCML_MI(0xc4, 0xe2, 0x65, 0xa8, 0x00));
    FCML_I32_M("vfmadd213ps ymm0,ymm3,ymm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0xa8, 0xc0), FCML_MI(0xc4, 0xe2, 0x65, 0xa8, 0xc0));

    FCML_I32_M("vfmadd231ps xmm0,xmm3,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0xb8, 0x00), FCML_MI(0xc4, 0xe2, 0x61, 0xb8, 0x00));
    FCML_I64_M("vfmadd231ps ymm0,ymm3,ymmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0xb8, 0x00), FCML_MI(0xc4, 0xe2, 0x65, 0xb8, 0x00));
    FCML_I32_M("vfmadd231ps ymm0,ymm3,ymm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0xb8, 0xc0), FCML_MI(0xc4, 0xe2, 0x65, 0xb8, 0xc0));

    FCML_I32_M("vfmadd231ps xmm0,xmm3,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0xb8, 0x00), FCML_MI(0xc4, 0xe2, 0x61, 0xb8, 0x00));
    FCML_I64_M("vfmadd231ps ymm0,ymm3,ymmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0xb8, 0x00), FCML_MI(0xc4, 0xe2, 0x65, 0xb8, 0x00));
    FCML_I32_M("vfmadd231ps ymm0,ymm3,ymm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0xb8, 0xc0), FCML_MI(0xc4, 0xe2, 0x65, 0xb8, 0xc0));
    FCML_A64_M("vfmadd132ps (%rax),%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0x98, 0x00), FCML_MI(0xc4, 0xe2, 0x61, 0x98, 0x00));
    FCML_A64_M("vfmadd132ps (%rax),%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0x98, 0x00), FCML_MI(0xc4, 0xe2, 0x65, 0x98, 0x00));
    FCML_A64_M("vfmadd132ps %ymm0,%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0x98, 0xc0), FCML_MI(0xc4, 0xe2, 0x65, 0x98, 0xc0));
    FCML_A64_M("vfmadd213ps (%rax),%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0xa8, 0x00), FCML_MI(0xc4, 0xe2, 0x61, 0xa8, 0x00));
    FCML_A64_M("vfmadd213ps (%rax),%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0xa8, 0x00), FCML_MI(0xc4, 0xe2, 0x65, 0xa8, 0x00));
    FCML_A64_M("vfmadd213ps %ymm0,%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0xa8, 0xc0), FCML_MI(0xc4, 0xe2, 0x65, 0xa8, 0xc0));
    FCML_A64_M("vfmadd231ps (%rax),%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0xb8, 0x00), FCML_MI(0xc4, 0xe2, 0x61, 0xb8, 0x00));
    FCML_A64_M("vfmadd231ps (%rax),%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0xb8, 0x00), FCML_MI(0xc4, 0xe2, 0x65, 0xb8, 0x00));
    FCML_A64_M("vfmadd231ps %ymm0,%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0xb8, 0xc0), FCML_MI(0xc4, 0xe2, 0x65, 0xb8, 0xc0));

    FCML_A64("vfmadd132ps %xmm5,%xmm3,%xmm0{%k1}{z}", 0x62, 0xf2, 0x65, 0x89, 0x98, 0xc5);
    FCML_A64("vfmadd213ps (%rax),%xmm3,%xmm0{%k2}", 0x62, 0xf2, 0x65, 0x0a, 0xa8, 0x00);
    FCML_A64("vfmadd231ps (%rax),%xmm3,%xmm0{%k1}", 0x62, 0xf2, 0x65, 0x09, 0xb8, 0x00);

    FCML_I64("vfmadd132ps ymm31{k7}{z},ymm21,dword ptr [rsi]{1to8}", 0x62, 0x62, 0x55, 0xb7, 0x98, 0x3e);
    FCML_I64("vfmadd213ps ymm31{k7}{z},ymm21,dword ptr [rsi]{1to8}", 0x62, 0x62, 0x55, 0xb7, 0xa8, 0x3e);
    FCML_I64("vfmadd231ps ymm31{k7}{z},ymm21,dword ptr [rsi]{1to8}", 0x62, 0x62, 0x55, 0xb7, 0xb8, 0x3e);

    FCML_I64_M("vfmadd132ps xmm1,xmm5,xmmword ptr [rsp+0000000000000020h]", 2, FCML_MI(0x62, 0xf2, 0x55, 0x08, 0x98, 0x4c, 0x24, 0x02), FCML_MI(0xc4, 0xe2, 0x51, 0x98, 0x4c, 0x24, 0x20));
    FCML_I64_M("vfmadd213ps xmm1,xmm5,xmmword ptr [rsp+0000000000000020h]", 2, FCML_MI(0x62, 0xf2, 0x55, 0x08, 0xa8, 0x4c, 0x24, 0x02), FCML_MI(0xc4, 0xe2, 0x51, 0xa8, 0x4c, 0x24, 0x20));
    FCML_I64("vfmadd231ps xmm1{k4},xmm5,xmmword ptr [rsp+0000000000000020h]", 0x62, 0xf2, 0x55, 0x0c, 0xb8, 0x4c, 0x24, 0x02);

    FCML_A64("vfmadd231ps 0x0000000000000020(%rsp),%xmm5,%xmm1{%k4}", 0x62, 0xf2, 0x55, 0x0c, 0xb8, 0x4c, 0x24, 0x02);

    FCML_A64( "vfmaddps %xmm2,(%rcx,%rax),%xmm5,%xmm2", 0xc4, 0xe3, 0x51, 0x68, 0x14, 0x01, 0x20 );
    FCML_A64( "vfmaddps %ymm2,(%rcx,%rax),%ymm5,%ymm2", 0xc4, 0xe3, 0x55, 0x68, 0x14, 0x01, 0x20 );
    FCML_A64( "vfmaddps (%rcx,%rax),%xmm2,%xmm5,%xmm2", 0xc4, 0xe3, 0xd1, 0x68, 0x14, 0x01, 0x20 );
    FCML_A64( "vfmaddps (%rcx,%rax),%ymm2,%ymm5,%ymm2", 0xc4, 0xe3, 0xd5, 0x68, 0x14, 0x01, 0x20 );
}

void fcml_tf_instruction_VFMADDSD(void) {

    FCML_I64_M("vfmadd132sd xmm0,xmm3,mmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0x99, 0x00), FCML_MI(0xc4, 0xe2, 0xe1, 0x99, 0x00));
    FCML_I64_M("vfmadd213sd xmm0,xmm3,mmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0xa9, 0x00), FCML_MI(0xc4, 0xe2, 0xe1, 0xa9, 0x00));
    FCML_I64_M("vfmadd231sd xmm0,xmm3,mmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0xb9, 0x00), FCML_MI(0xc4, 0xe2, 0xe1, 0xb9, 0x00));

    FCML_I64_M("vfmadd132sd xmm0,xmm3,xmm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0x99, 0xc0), FCML_MI(0xc4, 0xe2, 0xe1, 0x99, 0xc0));
    FCML_I64_M("vfmadd213sd xmm0,xmm3,xmm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0xa9, 0xc0), FCML_MI(0xc4, 0xe2, 0xe1, 0xa9, 0xc0));
    FCML_I64_M("vfmadd231sd xmm0,xmm3,xmm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0xb9, 0xc0), FCML_MI(0xc4, 0xe2, 0xe1, 0xb9, 0xc0));

    FCML_I64( "vfmaddsd xmm2,xmm5,xmmword ptr [rcx+rax],xmm2", 0xC4, 0xE3, 0x51, 0x6B, 0x14, 0x01, 0x20 );
    FCML_I64_M( "vfmaddsd xmm0,xmm5,xmm0,xmm2", 2, FCML_MI( 0xc4, 0xe3, 0xd1, 0x6b, 0xc2, 0x00 ), FCML_MI( 0xc4, 0xe3, 0x51, 0x6b, 0xc0, 0x20 ) );
    FCML_I64( "vfmaddsd xmm2,xmm5,xmm2,xmmword ptr [rcx+rax]", 0xC4, 0xE3, 0xD1, 0x6B, 0x14, 0x01, 0x20 );
    FCML_I64_M( "vfmaddsd xmm0,xmm5,xmm2,xmm0", 2, FCML_MI( 0xc4, 0xe3, 0xd1, 0x6b, 0xc0, 0x20 ), FCML_MI( 0xc4, 0xe3, 0x51, 0x6b, 0xc2, 0x00 ) );

    FCML_A64_M("vfmadd132sd (%rax),%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0x99, 0x00), FCML_MI(0xc4, 0xe2, 0xe1, 0x99, 0x00));
    FCML_A64_M("vfmadd132sd %xmm0,%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0x99, 0xc0), FCML_MI(0xc4, 0xe2, 0xe1, 0x99, 0xc0));
    FCML_A64_M("vfmadd213sd (%rax),%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0xa9, 0x00), FCML_MI(0xc4, 0xe2, 0xe1, 0xa9, 0x00));
    FCML_A64_M("vfmadd213sd %xmm0,%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0xa9, 0xc0), FCML_MI(0xc4, 0xe2, 0xe1, 0xa9, 0xc0));
    FCML_A64_M("vfmadd231sd (%rax),%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0xb9, 0x00), FCML_MI(0xc4, 0xe2, 0xe1, 0xb9, 0x00));
    FCML_A64_M("vfmadd231sd %xmm0,%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0xb9, 0xc0), FCML_MI(0xc4, 0xe2, 0xe1, 0xb9, 0xc0));

    FCML_A64( "vfmaddsd %xmm2,(%rcx,%rax),%xmm5,%xmm2", 0xc4, 0xe3, 0x51, 0x6b, 0x14, 0x01, 0x20 );

    FCML_A64("vfmadd132sd %xmm5,%xmm3,%xmm0{%k1}{z}", 0x62, 0xf2, 0xe5, 0x89, 0x99, 0xc5);
    FCML_A64("vfmadd213sd (%rax),%xmm3,%xmm0{%k2}", 0x62, 0xf2, 0xe5, 0x0a, 0xa9, 0x00);
    FCML_A64("vfmadd231sd (%rax),%xmm3,%xmm0{%k1}", 0x62, 0xf2, 0xe5, 0x09, 0xb9, 0x00);

    FCML_I64_M("vfmadd132sd xmm1,xmm5,mmword ptr [rsp+0000000000000010h]", 2, FCML_MI(0x62, 0xf2, 0xd5, 0x08, 0x99, 0x4c, 0x24, 0x02), FCML_MI(0xc4, 0xe2, 0xd1, 0x99, 0x4c, 0x24, 0x10));
    FCML_I64_M("vfmadd213sd xmm1,xmm5,mmword ptr [rsp+0000000000000010h]", 2, FCML_MI(0x62, 0xf2, 0xd5, 0x08, 0xa9, 0x4c, 0x24, 0x02), FCML_MI(0xc4, 0xe2, 0xd1, 0xa9, 0x4c, 0x24, 0x10));
    FCML_I64("vfmadd231sd xmm1{k4},xmm5,mmword ptr [rsp+0000000000000010h]", 0x62, 0xf2, 0xd5, 0x0c, 0xb9, 0x4c, 0x24, 0x02);

    FCML_I64("vfmadd132sd xmm2,xmm5,xmm4,{rn-sae}", 0x62, 0xf2, 0xd5, 0x18, 0x99, 0xd4);
}

void fcml_tf_instruction_VFMADDSS(void) {

    FCML_I32_M("vfmadd132ss xmm0,xmm3,dword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0x99, 0x00), FCML_MI(0xc4, 0xe2, 0x61, 0x99, 0x00));
    FCML_I64_M("vfmadd132ss xmm0,xmm3,xmm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0x99, 0xc0), FCML_MI(0xc4, 0xe2, 0x61, 0x99, 0xc0));
    FCML_I32_M("vfmadd213ss xmm0,xmm3,dword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0xa9, 0x00), FCML_MI(0xc4, 0xe2, 0x61, 0xa9, 0x00));
    FCML_I64_M("vfmadd213ss xmm0,xmm3,xmm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0xa9, 0xc0), FCML_MI(0xc4, 0xe2, 0x61, 0xa9, 0xc0));
    FCML_I32_M("vfmadd231ss xmm0,xmm3,dword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0xb9, 0x00), FCML_MI(0xc4, 0xe2, 0x61, 0xb9, 0x00));
    FCML_I64_M("vfmadd231ss xmm0,xmm3,xmm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0xb9, 0xc0), FCML_MI(0xc4, 0xe2, 0x61, 0xb9, 0xc0));

    FCML_I64( "vfmaddss xmm2,xmm5,dword ptr [rcx+rax],xmm2", 0xC4, 0xE3, 0x51, 0x6A, 0x14, 0x01, 0x20 );
    FCML_I64_M( "vfmaddss xmm0,xmm5,xmm0,xmm2", 2, FCML_MI( 0xc4, 0xe3, 0xd1, 0x6a, 0xc2, 0x00 ), FCML_MI( 0xc4, 0xe3, 0x51, 0x6a, 0xc0, 0x20 ) );
    FCML_I64( "vfmaddss xmm2,xmm5,xmm2,dword ptr [rcx+rax]", 0xC4, 0xE3, 0xD1, 0x6A, 0x14, 0x01, 0x20 );
    FCML_I64_M( "vfmaddss xmm0,xmm5,xmm2,xmm0", 2, FCML_MI( 0xc4, 0xe3, 0xd1, 0x6a, 0xc0, 0x20 ), FCML_MI( 0xc4, 0xe3, 0x51, 0x6a, 0xc2, 0x00 ) );

    FCML_A64_M("vfmadd132ss (%rax),%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0x99, 0x00), FCML_MI(0xc4, 0xe2, 0x61, 0x99, 0x00));
    FCML_A64_M("vfmadd132ss %xmm0,%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0x99, 0xc0), FCML_MI(0xc4, 0xe2, 0x61, 0x99, 0xc0));
    FCML_A64_M("vfmadd213ss (%rax),%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0xa9, 0x00), FCML_MI(0xc4, 0xe2, 0x61, 0xa9, 0x00));
    FCML_A64_M("vfmadd213ss %xmm0,%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0xa9, 0xc0), FCML_MI(0xc4, 0xe2, 0x61, 0xa9, 0xc0));
    FCML_A64_M("vfmadd231ss (%rax),%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0xb9, 0x00), FCML_MI(0xc4, 0xe2, 0x61, 0xb9, 0x00));
    FCML_A64_M("vfmadd231ss %xmm0,%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0xb9, 0xc0), FCML_MI(0xc4, 0xe2, 0x61, 0xb9, 0xc0));

    FCML_A64("vfmadd132ss %xmm5,%xmm3,%xmm0{%k1}{z}", 0x62, 0xf2, 0x65, 0x89, 0x99, 0xc5);
    FCML_A64("vfmadd213ss (%rax),%xmm3,%xmm0{%k2}", 0x62, 0xf2, 0x65, 0x0a, 0xa9, 0x00);
    FCML_A64("vfmadd231ss (%rax),%xmm3,%xmm0{%k1}", 0x62, 0xf2, 0x65, 0x09, 0xb9, 0x00);

    FCML_I64_M("vfmadd132ss xmm1,xmm5,dword ptr [rsp+0000000000000008h]", 2, FCML_MI(0x62, 0xf2, 0x55, 0x08, 0x99, 0x4c, 0x24, 0x02), FCML_MI(0xc4, 0xe2, 0x51, 0x99, 0x4c, 0x24, 0x08));
    FCML_I64_M("vfmadd213ss xmm1,xmm5,dword ptr [rsp+0000000000000008h]", 2, FCML_MI(0x62, 0xf2, 0x55, 0x08, 0xa9, 0x4c, 0x24, 0x02), FCML_MI(0xc4, 0xe2, 0x51, 0xa9, 0x4c, 0x24, 0x08));
    FCML_I64("vfmadd231ss xmm1{k4},xmm5,dword ptr [rsp+0000000000000008h]", 0x62, 0xf2, 0x55, 0x0c, 0xb9, 0x4c, 0x24, 0x02);

    FCML_I64("vfmadd132ss xmm2,xmm5,xmm4,{rn-sae}", 0x62, 0xf2, 0x55, 0x18, 0x99, 0xd4);
}

void fcml_tf_instruction_VFMADDSUBPD(void) {

    FCML_I64_M("vfmaddsub132pd xmm0,xmm3,xmmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0x96, 0x00), FCML_MI(0xc4, 0xe2, 0xe1, 0x96, 0x00));
    FCML_I64_M("vfmaddsub132pd ymm0,ymm3,ymmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0x96, 0x00), FCML_MI(0xc4, 0xe2, 0xe5, 0x96, 0x00));
    FCML_I64_M("vfmaddsub132pd ymm0,ymm3,ymm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0x96, 0xc0), FCML_MI(0xc4, 0xe2, 0xe5, 0x96, 0xc0));

    FCML_I64_M("vfmaddsub213pd xmm0,xmm3,xmmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0xa6, 0x00), FCML_MI(0xc4, 0xe2, 0xe1, 0xa6, 0x00));
    FCML_I64_M("vfmaddsub213pd ymm0,ymm3,ymmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0xa6, 0x00), FCML_MI(0xc4, 0xe2, 0xe5, 0xa6, 0x00));
    FCML_I64_M("vfmaddsub213pd ymm0,ymm3,ymm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0xa6, 0xc0), FCML_MI(0xc4, 0xe2, 0xe5, 0xa6, 0xc0));

    FCML_I64_M("vfmaddsub231pd xmm0,xmm3,xmmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0xb6, 0x00), FCML_MI(0xc4, 0xe2, 0xe1, 0xb6, 0x00));
    FCML_I64_M("vfmaddsub231pd ymm0,ymm3,ymmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0xb6, 0x00), FCML_MI(0xc4, 0xe2, 0xe5, 0xb6, 0x00));
    FCML_I64_M("vfmaddsub231pd ymm0,ymm3,ymm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0xb6, 0xc0), FCML_MI(0xc4, 0xe2, 0xe5, 0xb6, 0xc0));

    FCML_I32( "vfmaddsubpd xmm2,xmm5,xmmword ptr [ecx+eax],xmm2", 0xC4, 0xE3, 0x51, 0x5D, 0x14, 0x01, 0x20 );
    FCML_I64( "vfmaddsubpd ymm2,ymm5,ymmword ptr [rcx+rax],ymm2", 0xC4, 0xE3, 0x55, 0x5D, 0x14, 0x01, 0x20 );
    FCML_I64_M( "vfmaddsubpd ymm0,ymm5,ymm0,ymm2", 2, FCML_MI( 0xc4, 0xe3, 0xd5, 0x5d, 0xc2, 0x00 ), FCML_MI( 0xc4, 0xe3, 0x55, 0x5d, 0xc0, 0x20 ) );

    FCML_I64( "vfmaddsubpd xmm2,xmm5,xmm2,xmmword ptr [rcx+rax]", 0xC4, 0xE3, 0xD1, 0x5D, 0x14, 0x01, 0x20 );
    FCML_I64( "vfmaddsubpd ymm2,ymm5,ymm2,ymmword ptr [rcx+rax]", 0xC4, 0xE3, 0xD5, 0x5D, 0x14, 0x01, 0x20 );
    FCML_I64_M( "vfmaddsubpd ymm0,ymm5,ymm2,ymm0", 2, FCML_MI( 0xc4, 0xe3, 0xd5, 0x5d, 0xc0, 0x20 ), FCML_MI( 0xc4, 0xe3, 0x55, 0x5d, 0xc2, 0x00 ) );

    FCML_A64_M("vfmaddsub132pd (%rax),%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0x96, 0x00), FCML_MI(0xc4, 0xe2, 0xe1, 0x96, 0x00));
    FCML_A64_M("vfmaddsub132pd (%rax),%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0x96, 0x00), FCML_MI(0xc4, 0xe2, 0xe5, 0x96, 0x00));
    FCML_A64_M("vfmaddsub132pd %ymm0,%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0x96, 0xc0), FCML_MI(0xc4, 0xe2, 0xe5, 0x96, 0xc0));
    FCML_A64_M("vfmaddsub213pd (%rax),%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0xa6, 0x00), FCML_MI(0xc4, 0xe2, 0xe1, 0xa6, 0x00));
    FCML_A64_M("vfmaddsub213pd (%rax),%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0xa6, 0x00), FCML_MI(0xc4, 0xe2, 0xe5, 0xa6, 0x00));
    FCML_A64_M("vfmaddsub213pd %ymm0,%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0xa6, 0xc0), FCML_MI(0xc4, 0xe2, 0xe5, 0xa6, 0xc0));
    FCML_A64_M("vfmaddsub231pd (%rax),%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0xb6, 0x00), FCML_MI(0xc4, 0xe2, 0xe1, 0xb6, 0x00));
    FCML_A64_M("vfmaddsub231pd (%rax),%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0xb6, 0x00), FCML_MI(0xc4, 0xe2, 0xe5, 0xb6, 0x00));
    FCML_A64_M("vfmaddsub231pd %ymm0,%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0xb6, 0xc0), FCML_MI(0xc4, 0xe2, 0xe5, 0xb6, 0xc0));
    FCML_A64( "vfmaddsubpd %xmm2,(%rcx,%rax),%xmm5,%xmm2", 0xc4, 0xe3, 0x51, 0x5d, 0x14, 0x01, 0x20 );
    FCML_A64( "vfmaddsubpd %ymm2,(%rcx,%rax),%ymm5,%ymm2", 0xc4, 0xe3, 0x55, 0x5d, 0x14, 0x01, 0x20 );

    FCML_I64("vfmaddsub132pd ymm31{k7}{z},ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x62, 0xd5, 0xb7, 0x96, 0x3e);
    FCML_I64("vfmaddsub213pd ymm31{k7}{z},ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x62, 0xd5, 0xb7, 0xa6, 0x3e);
    FCML_I64("vfmaddsub231pd ymm31{k7}{z},ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x62, 0xd5, 0xb7, 0xb6, 0x3e);

    FCML_I64_M("vfmaddsub132pd xmm1,xmm5,xmmword ptr [rsp+0000000000000020h]", 2, FCML_MI(0x62, 0xf2, 0xd5, 0x08, 0x96, 0x4c, 0x24, 0x02), FCML_MI(0xc4, 0xe2, 0xd1, 0x96, 0x4c, 0x24, 0x20));
    FCML_I64_M("vfmaddsub213pd xmm1,xmm5,xmmword ptr [rsp+0000000000000020h]", 2, FCML_MI(0x62, 0xf2, 0xd5, 0x08, 0xa6, 0x4c, 0x24, 0x02), FCML_MI(0xc4, 0xe2, 0xd1, 0xa6, 0x4c, 0x24, 0x20));
    FCML_I64("vfmaddsub231pd xmm1{k4},xmm5,xmmword ptr [rsp+0000000000000020h]", 0x62, 0xf2, 0xd5, 0x0c, 0xb6, 0x4c, 0x24, 0x02);

    FCML_I64("vfmaddsub132pd zmm2,zmm5,zmm4,{rn-sae}", 0x62, 0xf2, 0xd5, 0x18, 0x96, 0xd4);
    FCML_I64("vfmaddsub213pd zmm2,zmm5,zmm4,{rn-sae}", 0x62, 0xf2, 0xd5, 0x18, 0xa6, 0xd4);
    FCML_I64("vfmaddsub231pd zmm2,zmm5,zmm4,{rn-sae}", 0x62, 0xf2, 0xd5, 0x18, 0xb6, 0xd4);
}

void fcml_tf_instruction_VFMADDSUBPS(void) {

    FCML_I32_M("vfmaddsub132ps xmm0,xmm3,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0x96, 0x00), FCML_MI(0xc4, 0xe2, 0x61, 0x96, 0x00));
    FCML_I64_M("vfmaddsub132ps ymm0,ymm3,ymmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0x96, 0x00), FCML_MI(0xc4, 0xe2, 0x65, 0x96, 0x00));
    FCML_I32_M("vfmaddsub132ps ymm0,ymm3,ymm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0x96, 0xc0), FCML_MI(0xc4, 0xe2, 0x65, 0x96, 0xc0));

    FCML_I32_M("vfmaddsub213ps xmm0,xmm3,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0xa6, 0x00), FCML_MI(0xc4, 0xe2, 0x61, 0xa6, 0x00));
    FCML_I64_M("vfmaddsub213ps ymm0,ymm3,ymmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0xa6, 0x00), FCML_MI(0xc4, 0xe2, 0x65, 0xa6, 0x00));
    FCML_I32_M("vfmaddsub213ps ymm0,ymm3,ymm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0xa6, 0xc0), FCML_MI(0xc4, 0xe2, 0x65, 0xa6, 0xc0));

    FCML_I32_M("vfmaddsub231ps xmm0,xmm3,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0xb6, 0x00), FCML_MI(0xc4, 0xe2, 0x61, 0xb6, 0x00));
    FCML_I64_M("vfmaddsub231ps ymm0,ymm3,ymmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0xb6, 0x00), FCML_MI(0xc4, 0xe2, 0x65, 0xb6, 0x00));
    FCML_I32_M("vfmaddsub231ps ymm0,ymm3,ymm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0xb6, 0xc0), FCML_MI(0xc4, 0xe2, 0x65, 0xb6, 0xc0));

    FCML_I64( "vfmaddsubps xmm2,xmm5,xmmword ptr [rcx+rax],xmm2", 0xC4, 0xE3, 0x51, 0x5C, 0x14, 0x01, 0x20 );
    FCML_I64( "vfmaddsubps ymm2,ymm5,ymmword ptr [rcx+rax],ymm2", 0xC4, 0xE3, 0x55, 0x5C, 0x14, 0x01, 0x20 );
    FCML_I64_M( "vfmaddsubps ymm0,ymm5,ymm0,ymm2", 2, FCML_MI( 0xc4, 0xe3, 0xd5, 0x5c, 0xc2, 0x00 ), FCML_MI( 0xc4, 0xe3, 0x55, 0x5c, 0xc0, 0x20 ) );

    FCML_I64( "vfmaddsubps xmm2,xmm5,xmm2,xmmword ptr [rcx+rax]", 0xC4, 0xE3, 0xD1, 0x5C, 0x14, 0x01, 0x20 );
    FCML_I64( "vfmaddsubps ymm2,ymm5,ymm2,ymmword ptr [rcx+rax]", 0xC4, 0xE3, 0xD5, 0x5C, 0x14, 0x01, 0x20 );
    FCML_I64_M( "vfmaddsubps ymm0,ymm5,ymm2,ymm0", 2, FCML_MI( 0xc4, 0xe3, 0xd5, 0x5c, 0xc0, 0x20 ), FCML_MI( 0xc4, 0xe3, 0x55, 0x5c, 0xc2, 0x00 ) );

    FCML_A64_M("vfmaddsub132ps (%rax),%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0x96, 0x00), FCML_MI(0xc4, 0xe2, 0x61, 0x96, 0x00));
    FCML_A64_M("vfmaddsub132ps (%rax),%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0x96, 0x00), FCML_MI(0xc4, 0xe2, 0x65, 0x96, 0x00));
    FCML_A64_M("vfmaddsub132ps %ymm0,%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0x96, 0xc0), FCML_MI(0xc4, 0xe2, 0x65, 0x96, 0xc0));
    FCML_A64_M("vfmaddsub213ps (%rax),%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0xa6, 0x00), FCML_MI(0xc4, 0xe2, 0x61, 0xa6, 0x00));
    FCML_A64_M("vfmaddsub213ps (%rax),%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0xa6, 0x00), FCML_MI(0xc4, 0xe2, 0x65, 0xa6, 0x00));
    FCML_A64_M("vfmaddsub213ps %ymm0,%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0xa6, 0xc0), FCML_MI(0xc4, 0xe2, 0x65, 0xa6, 0xc0));
    FCML_A64_M("vfmaddsub231ps (%rax),%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0xb6, 0x00), FCML_MI(0xc4, 0xe2, 0x61, 0xb6, 0x00));
    FCML_A64_M("vfmaddsub231ps (%rax),%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0xb6, 0x00), FCML_MI(0xc4, 0xe2, 0x65, 0xb6, 0x00));
    FCML_A64_M("vfmaddsub231ps %ymm0,%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0xb6, 0xc0), FCML_MI(0xc4, 0xe2, 0x65, 0xb6, 0xc0));

    FCML_A64( "vfmaddsubps %xmm2,(%rcx,%rax),%xmm5,%xmm2", 0xc4, 0xe3, 0x51, 0x5c, 0x14, 0x01, 0x20 );
    FCML_A64( "vfmaddsubps %ymm2,(%rcx,%rax),%ymm5,%ymm2", 0xc4, 0xe3, 0x55, 0x5c, 0x14, 0x01, 0x20 );

    FCML_I64("vfmaddsub132ps ymm31{k7}{z},ymm21,dword ptr [rsi]{1to8}", 0x62, 0x62, 0x55, 0xb7, 0x96, 0x3e);
    FCML_I64("vfmaddsub213ps ymm31{k7}{z},ymm21,dword ptr [rsi]{1to8}", 0x62, 0x62, 0x55, 0xb7, 0xa6, 0x3e);
    FCML_I64("vfmaddsub231ps ymm31{k7}{z},ymm21,dword ptr [rsi]{1to8}", 0x62, 0x62, 0x55, 0xb7, 0xb6, 0x3e);

    FCML_I64_M("vfmaddsub132ps xmm1,xmm5,xmmword ptr [rsp+0000000000000020h]", 2, FCML_MI(0x62, 0xf2, 0x55, 0x08, 0x96, 0x4c, 0x24, 0x02), FCML_MI(0xc4, 0xe2, 0x51, 0x96, 0x4c, 0x24, 0x20));
    FCML_I64_M("vfmaddsub213ps xmm1,xmm5,xmmword ptr [rsp+0000000000000020h]", 2, FCML_MI(0x62, 0xf2, 0x55, 0x08, 0xa6, 0x4c, 0x24, 0x02), FCML_MI(0xc4, 0xe2, 0x51, 0xa6, 0x4c, 0x24, 0x20));
    FCML_I64("vfmaddsub231ps xmm1{k4},xmm5,xmmword ptr [rsp+0000000000000020h]", 0x62, 0xf2, 0x55, 0x0c, 0xb6, 0x4c, 0x24, 0x02);

    FCML_I64("vfmaddsub132ps zmm2,zmm5,zmm4,{rn-sae}", 0x62, 0xf2, 0x55, 0x18, 0x96, 0xd4);
    FCML_I64("vfmaddsub213ps zmm2,zmm5,zmm4,{rn-sae}", 0x62, 0xf2, 0x55, 0x18, 0xa6, 0xd4);
    FCML_I64("vfmaddsub231ps zmm2,zmm5,zmm4,{rn-sae}", 0x62, 0xf2, 0x55, 0x18, 0xb6, 0xd4);
}

void fcml_tf_instruction_VFMSUBADDPD(void) {

    FCML_I64_M("vfmsubadd132pd xmm0,xmm3,xmmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0x97, 0x00), FCML_MI(0xc4, 0xe2, 0xe1, 0x97, 0x00));
    FCML_I64_M("vfmsubadd132pd ymm0,ymm3,ymmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0x97, 0x00), FCML_MI(0xc4, 0xe2, 0xe5, 0x97, 0x00));
    FCML_I64_M("vfmsubadd132pd ymm0,ymm3,ymm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0x97, 0xc0), FCML_MI(0xc4, 0xe2, 0xe5, 0x97, 0xc0));

    FCML_I64_M("vfmsubadd213pd xmm0,xmm3,xmmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0xa7, 0x00), FCML_MI(0xc4, 0xe2, 0xe1, 0xa7, 0x00));
    FCML_I64_M("vfmsubadd213pd ymm0,ymm3,ymmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0xa7, 0x00), FCML_MI(0xc4, 0xe2, 0xe5, 0xa7, 0x00));
    FCML_I64_M("vfmsubadd213pd ymm0,ymm3,ymm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0xa7, 0xc0), FCML_MI(0xc4, 0xe2, 0xe5, 0xa7, 0xc0));

    FCML_I64_M("vfmsubadd231pd xmm0,xmm3,xmmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0xb7, 0x00), FCML_MI(0xc4, 0xe2, 0xe1, 0xb7, 0x00));
    FCML_I64_M("vfmsubadd231pd ymm0,ymm3,ymmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0xb7, 0x00), FCML_MI(0xc4, 0xe2, 0xe5, 0xb7, 0x00));
    FCML_I64_M("vfmsubadd231pd ymm0,ymm3,ymm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0xb7, 0xc0), FCML_MI(0xc4, 0xe2, 0xe5, 0xb7, 0xc0));

    FCML_I32( "vfmsubaddpd xmm2,xmm5,xmmword ptr [ecx+eax],xmm2", 0xC4, 0xE3, 0x51, 0x5F, 0x14, 0x01, 0x20 );
    FCML_I64( "vfmsubaddpd ymm2,ymm5,ymmword ptr [rcx+rax],ymm2", 0xC4, 0xE3, 0x55, 0x5F, 0x14, 0x01, 0x20 );
    FCML_I64_M( "vfmsubaddpd ymm0,ymm5,ymm0,ymm2", 2, FCML_MI( 0xc4, 0xe3, 0xd5, 0x5f, 0xc2, 0x00 ), FCML_MI( 0xc4, 0xe3, 0x55, 0x5f, 0xc0, 0x20 ) );

    FCML_I64( "vfmsubaddpd xmm2,xmm5,xmm2,xmmword ptr [rcx+rax]", 0xC4, 0xE3, 0xD1, 0x5F, 0x14, 0x01, 0x20 );
    FCML_I64( "vfmsubaddpd ymm2,ymm5,ymm2,ymmword ptr [rcx+rax]", 0xC4, 0xE3, 0xD5, 0x5F, 0x14, 0x01, 0x20 );
    FCML_I64_M( "vfmsubaddpd ymm0,ymm5,ymm2,ymm0", 2, FCML_MI( 0xc4, 0xe3, 0xd5, 0x5f, 0xc0, 0x20 ), FCML_MI( 0xc4, 0xe3, 0x55, 0x5f, 0xc2, 0x00 ) );

    FCML_A64_M("vfmsubadd132pd (%rax),%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0x97, 0x00), FCML_MI(0xc4, 0xe2, 0xe1, 0x97, 0x00));
    FCML_A64_M("vfmsubadd132pd (%rax),%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0x97, 0x00), FCML_MI(0xc4, 0xe2, 0xe5, 0x97, 0x00));
    FCML_A64_M("vfmsubadd132pd %ymm0,%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0x97, 0xc0), FCML_MI(0xc4, 0xe2, 0xe5, 0x97, 0xc0));
    FCML_A64_M("vfmsubadd213pd (%rax),%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0xa7, 0x00), FCML_MI(0xc4, 0xe2, 0xe1, 0xa7, 0x00));
    FCML_A64_M("vfmsubadd213pd (%rax),%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0xa7, 0x00), FCML_MI(0xc4, 0xe2, 0xe5, 0xa7, 0x00));
    FCML_A64_M("vfmsubadd213pd %ymm0,%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0xa7, 0xc0), FCML_MI(0xc4, 0xe2, 0xe5, 0xa7, 0xc0));
    FCML_A64_M("vfmsubadd231pd (%rax),%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0xb7, 0x00), FCML_MI(0xc4, 0xe2, 0xe1, 0xb7, 0x00));
    FCML_A64_M("vfmsubadd231pd (%rax),%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0xb7, 0x00), FCML_MI(0xc4, 0xe2, 0xe5, 0xb7, 0x00));
    FCML_A64_M("vfmsubadd231pd %ymm0,%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0xb7, 0xc0), FCML_MI(0xc4, 0xe2, 0xe5, 0xb7, 0xc0));

    FCML_A64( "vfmsubaddpd %xmm2,(%rcx,%rax),%xmm5,%xmm2", 0xc4, 0xe3, 0x51, 0x5f, 0x14, 0x01, 0x20 );
    FCML_A64( "vfmsubaddpd %ymm2,(%rcx,%rax),%ymm5,%ymm2", 0xc4, 0xe3, 0x55, 0x5f, 0x14, 0x01, 0x20 );

    FCML_I64("vfmsubadd132pd ymm31{k7}{z},ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x62, 0xd5, 0xb7, 0x97, 0x3e);
    FCML_I64("vfmsubadd213pd ymm31{k7}{z},ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x62, 0xd5, 0xb7, 0xa7, 0x3e);
    FCML_I64("vfmsubadd231pd ymm31{k7}{z},ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x62, 0xd5, 0xb7, 0xb7, 0x3e);

    FCML_I64_M("vfmsubadd132pd xmm1,xmm5,xmmword ptr [rsp+0000000000000020h]", 2, FCML_MI(0x62, 0xf2, 0xd5, 0x08, 0x97, 0x4c, 0x24, 0x02), FCML_MI(0xc4, 0xe2, 0xd1, 0x97, 0x4c, 0x24, 0x20));
    FCML_I64_M("vfmsubadd213pd xmm1,xmm5,xmmword ptr [rsp+0000000000000020h]", 2, FCML_MI(0x62, 0xf2, 0xd5, 0x08, 0xa7, 0x4c, 0x24, 0x02), FCML_MI(0xc4, 0xe2, 0xd1, 0xa7, 0x4c, 0x24, 0x20));
    FCML_I64("vfmsubadd231pd xmm1{k4},xmm5,xmmword ptr [rsp+0000000000000020h]", 0x62, 0xf2, 0xd5, 0x0c, 0xb7, 0x4c, 0x24, 0x02);

    FCML_I64("vfmsubadd132pd zmm2,zmm5,zmm4,{rn-sae}", 0x62, 0xf2, 0xd5, 0x18, 0x97, 0xd4);
    FCML_I64("vfmsubadd213pd zmm2,zmm5,zmm4,{rn-sae}", 0x62, 0xf2, 0xd5, 0x18, 0xa7, 0xd4);
    FCML_I64("vfmsubadd231pd zmm2,zmm5,zmm4,{rn-sae}", 0x62, 0xf2, 0xd5, 0x18, 0xb7, 0xd4);
}

void fcml_tf_instruction_VFMSUBADDPS(void) {

    FCML_I32_M("vfmsubadd132ps xmm0,xmm3,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0x97, 0x00), FCML_MI(0xc4, 0xe2, 0x61, 0x97, 0x00));
    FCML_I64_M("vfmsubadd132ps ymm0,ymm3,ymmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0x97, 0x00), FCML_MI(0xc4, 0xe2, 0x65, 0x97, 0x00));
    FCML_I32_M("vfmsubadd132ps ymm0,ymm3,ymm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0x97, 0xc0), FCML_MI(0xc4, 0xe2, 0x65, 0x97, 0xc0));

    FCML_I32_M("vfmsubadd213ps xmm0,xmm3,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0xa7, 0x00), FCML_MI(0xc4, 0xe2, 0x61, 0xa7, 0x00));
    FCML_I64_M("vfmsubadd213ps ymm0,ymm3,ymmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0xa7, 0x00), FCML_MI(0xc4, 0xe2, 0x65, 0xa7, 0x00));
    FCML_I32_M("vfmsubadd213ps ymm0,ymm3,ymm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0xa7, 0xc0), FCML_MI(0xc4, 0xe2, 0x65, 0xa7, 0xc0));

    FCML_I32_M("vfmsubadd231ps xmm0,xmm3,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0xb7, 0x00), FCML_MI(0xc4, 0xe2, 0x61, 0xb7, 0x00));
    FCML_I64_M("vfmsubadd231ps ymm0,ymm3,ymmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0xb7, 0x00), FCML_MI(0xc4, 0xe2, 0x65, 0xb7, 0x00));
    FCML_I32_M("vfmsubadd231ps ymm0,ymm3,ymm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0xb7, 0xc0), FCML_MI(0xc4, 0xe2, 0x65, 0xb7, 0xc0));

    FCML_I64( "vfmsubaddps xmm2,xmm5,xmmword ptr [rcx+rax],xmm2", 0xC4, 0xE3, 0x51, 0x5E, 0x14, 0x01, 0x20 );
    FCML_I64( "vfmsubaddps ymm2,ymm5,ymmword ptr [rcx+rax],ymm2", 0xC4, 0xE3, 0x55, 0x5E, 0x14, 0x01, 0x20 );
    FCML_I64_M( "vfmsubaddps ymm0,ymm5,ymm0,ymm2", 2, FCML_MI( 0xc4, 0xe3, 0xd5, 0x5e, 0xc2, 0x00 ), FCML_MI( 0xc4, 0xe3, 0x55, 0x5e, 0xc0, 0x20 ) );

    FCML_I64( "vfmsubaddps xmm2,xmm5,xmm2,xmmword ptr [rcx+rax]", 0xC4, 0xE3, 0xD1, 0x5E, 0x14, 0x01, 0x20 );
    FCML_I64( "vfmsubaddps ymm2,ymm5,ymm2,ymmword ptr [rcx+rax]", 0xC4, 0xE3, 0xD5, 0x5E, 0x14, 0x01, 0x20 );
    FCML_I64_M( "vfmsubaddps ymm0,ymm5,ymm2,ymm0", 2, FCML_MI( 0xc4, 0xe3, 0xd5, 0x5e, 0xc0, 0x20 ), FCML_MI( 0xc4, 0xe3, 0x55, 0x5e, 0xc2, 0x00 ) );

    FCML_A64_M("vfmsubadd132ps (%rax),%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0x97, 0x00), FCML_MI(0xc4, 0xe2, 0x61, 0x97, 0x00));
    FCML_A64_M("vfmsubadd132ps (%rax),%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0x97, 0x00), FCML_MI(0xc4, 0xe2, 0x65, 0x97, 0x00));
    FCML_A64_M("vfmsubadd132ps %ymm0,%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0x97, 0xc0), FCML_MI(0xc4, 0xe2, 0x65, 0x97, 0xc0));
    FCML_A64_M("vfmsubadd213ps (%rax),%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0xa7, 0x00), FCML_MI(0xc4, 0xe2, 0x61, 0xa7, 0x00));
    FCML_A64_M("vfmsubadd213ps (%rax),%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0xa7, 0x00), FCML_MI(0xc4, 0xe2, 0x65, 0xa7, 0x00));
    FCML_A64_M("vfmsubadd213ps %ymm0,%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0xa7, 0xc0), FCML_MI(0xc4, 0xe2, 0x65, 0xa7, 0xc0));
    FCML_A64_M("vfmsubadd231ps (%rax),%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0xb7, 0x00), FCML_MI(0xc4, 0xe2, 0x61, 0xb7, 0x00));
    FCML_A64_M("vfmsubadd231ps (%rax),%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0xb7, 0x00), FCML_MI(0xc4, 0xe2, 0x65, 0xb7, 0x00));
    FCML_A64_M("vfmsubadd231ps %ymm0,%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0xb7, 0xc0), FCML_MI(0xc4, 0xe2, 0x65, 0xb7, 0xc0));

    FCML_A64( "vfmsubaddps %xmm2,(%rcx,%rax),%xmm5,%xmm2", 0xc4, 0xe3, 0x51, 0x5e, 0x14, 0x01, 0x20 );
    FCML_A64( "vfmsubaddps %ymm2,(%rcx,%rax),%ymm5,%ymm2", 0xc4, 0xe3, 0x55, 0x5e, 0x14, 0x01, 0x20 );

    FCML_I64("vfmsubadd132ps ymm31{k7}{z},ymm21,dword ptr [rsi]{1to8}", 0x62, 0x62, 0x55, 0xb7, 0x97, 0x3e);
    FCML_I64("vfmsubadd213ps ymm31{k7}{z},ymm21,dword ptr [rsi]{1to8}", 0x62, 0x62, 0x55, 0xb7, 0xa7, 0x3e);
    FCML_I64("vfmsubadd231ps ymm31{k7}{z},ymm21,dword ptr [rsi]{1to8}", 0x62, 0x62, 0x55, 0xb7, 0xb7, 0x3e);

    FCML_I64_M("vfmsubadd132ps xmm1,xmm5,xmmword ptr [rsp+0000000000000020h]", 2, FCML_MI(0x62, 0xf2, 0x55, 0x08, 0x97, 0x4c, 0x24, 0x02), FCML_MI(0xc4, 0xe2, 0x51, 0x97, 0x4c, 0x24, 0x20));
    FCML_I64_M("vfmsubadd213ps xmm1,xmm5,xmmword ptr [rsp+0000000000000020h]", 2, FCML_MI(0x62, 0xf2, 0x55, 0x08, 0xa7, 0x4c, 0x24, 0x02), FCML_MI(0xc4, 0xe2, 0x51, 0xa7, 0x4c, 0x24, 0x20));
    FCML_I64("vfmsubadd231ps xmm1{k4},xmm5,xmmword ptr [rsp+0000000000000020h]", 0x62, 0xf2, 0x55, 0x0c, 0xb7, 0x4c, 0x24, 0x02);

    FCML_I64("vfmsubadd132ps zmm2,zmm5,zmm4,{rn-sae}", 0x62, 0xf2, 0x55, 0x18, 0x97, 0xd4);
    FCML_I64("vfmsubadd213ps zmm2,zmm5,zmm4,{rn-sae}", 0x62, 0xf2, 0x55, 0x18, 0xa7, 0xd4);
    FCML_I64("vfmsubadd231ps zmm2,zmm5,zmm4,{rn-sae}", 0x62, 0xf2, 0x55, 0x18, 0xb7, 0xd4);
}

void fcml_tf_instruction_VFMSUBPD(void) {

    FCML_I64_M("vfmsub132pd xmm0,xmm3,xmmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0x9a, 0x00), FCML_MI(0xc4, 0xe2, 0xe1, 0x9a, 0x00));
    FCML_I64_M("vfmsub132pd ymm0,ymm3,ymmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0x9a, 0x00), FCML_MI(0xc4, 0xe2, 0xe5, 0x9a, 0x00));
    FCML_I64_M("vfmsub132pd ymm0,ymm3,ymm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0x9a, 0xc0), FCML_MI(0xc4, 0xe2, 0xe5, 0x9a, 0xc0));

    FCML_I64_M("vfmsub231pd xmm0,xmm3,xmmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0xba, 0x00), FCML_MI(0xc4, 0xe2, 0xe1, 0xba, 0x00));
    FCML_I64_M("vfmsub231pd ymm0,ymm3,ymmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0xba, 0x00), FCML_MI(0xc4, 0xe2, 0xe5, 0xba, 0x00));
    FCML_I64_M("vfmsub231pd ymm0,ymm3,ymm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0xba, 0xc0), FCML_MI(0xc4, 0xe2, 0xe5, 0xba, 0xc0));

    FCML_I64_M("vfmsub231pd xmm0,xmm3,xmmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0xba, 0x00), FCML_MI(0xc4, 0xe2, 0xe1, 0xba, 0x00));
    FCML_I64_M("vfmsub231pd ymm0,ymm3,ymmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0xba, 0x00), FCML_MI(0xc4, 0xe2, 0xe5, 0xba, 0x00));
    FCML_I64_M("vfmsub231pd ymm0,ymm3,ymm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0xba, 0xc0), FCML_MI(0xc4, 0xe2, 0xe5, 0xba, 0xc0));

    FCML_I32( "vfmsubpd xmm2,xmm5,xmmword ptr [ecx+eax],xmm2", 0xC4, 0xE3, 0x51, 0x6D, 0x14, 0x01, 0x20 );
    FCML_I64( "vfmsubpd ymm2,ymm5,ymmword ptr [rcx+rax],ymm2", 0xC4, 0xE3, 0x55, 0x6D, 0x14, 0x01, 0x20 );
    FCML_I64_M( "vfmsubpd ymm0,ymm5,ymm0,ymm2", 2, FCML_MI( 0xc4, 0xe3, 0xd5, 0x6d, 0xc2, 0x00 ), FCML_MI( 0xc4, 0xe3, 0x55, 0x6d, 0xc0, 0x20 ) );

    FCML_I64( "vfmsubpd xmm2,xmm5,xmm2,xmmword ptr [rcx+rax]", 0xC4, 0xE3, 0xD1, 0x6D, 0x14, 0x01, 0x20 );
    FCML_I64( "vfmsubpd ymm2,ymm5,ymm2,ymmword ptr [rcx+rax]", 0xC4, 0xE3, 0xD5, 0x6D, 0x14, 0x01, 0x20 );
    FCML_I64_M( "vfmsubpd ymm0,ymm5,ymm2,ymm0", 2, FCML_MI( 0xc4, 0xe3, 0xd5, 0x6d, 0xc0, 0x20 ), FCML_MI( 0xc4, 0xe3, 0x55, 0x6d, 0xc2, 0x00 ) );

    FCML_I64_M("vfmsub231pd xmm0,xmm3,xmmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0xba, 0x00), FCML_MI(0xc4, 0xe2, 0xe1, 0xba, 0x00));
    FCML_I64_M("vfmsub231pd ymm0,ymm3,ymmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0xba, 0x00), FCML_MI(0xc4, 0xe2, 0xe5, 0xba, 0x00));
    FCML_I64_M("vfmsub231pd ymm0,ymm3,ymm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0xba, 0xc0), FCML_MI(0xc4, 0xe2, 0xe5, 0xba, 0xc0));
    FCML_A64_M("vfmsub132pd (%rax),%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0x9a, 0x00), FCML_MI(0xc4, 0xe2, 0xe1, 0x9a, 0x00));
    FCML_A64_M("vfmsub132pd (%rax),%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0x9a, 0x00), FCML_MI(0xc4, 0xe2, 0xe5, 0x9a, 0x00));
    FCML_A64_M("vfmsub132pd %ymm0,%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0x9a, 0xc0), FCML_MI(0xc4, 0xe2, 0xe5, 0x9a, 0xc0));
    FCML_A64_M("vfmsub213pd (%rax),%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0xaa, 0x00), FCML_MI(0xc4, 0xe2, 0xe1, 0xaa, 0x00));
    FCML_A64_M("vfmsub213pd (%rax),%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0xaa, 0x00), FCML_MI(0xc4, 0xe2, 0xe5, 0xaa, 0x00));
    FCML_A64_M("vfmsub213pd %ymm0,%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0xaa, 0xc0), FCML_MI(0xc4, 0xe2, 0xe5, 0xaa, 0xc0));
    FCML_A64_M("vfmsub231pd (%rax),%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0xba, 0x00), FCML_MI(0xc4, 0xe2, 0xe1, 0xba, 0x00));
    FCML_A64_M("vfmsub231pd (%rax),%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0xba, 0x00), FCML_MI(0xc4, 0xe2, 0xe5, 0xba, 0x00));
    FCML_A64_M("vfmsub231pd %ymm0,%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0xba, 0xc0), FCML_MI(0xc4, 0xe2, 0xe5, 0xba, 0xc0));

    FCML_A64( "vfmsubpd %xmm2,(%rcx,%rax),%xmm5,%xmm2", 0xc4, 0xe3, 0x51, 0x6d, 0x14, 0x01, 0x20 );
    FCML_A64( "vfmsubpd %ymm2,(%rcx,%rax),%ymm5,%ymm2", 0xc4, 0xe3, 0x55, 0x6d, 0x14, 0x01, 0x20 );

    FCML_I64("vfmsub132pd ymm31{k7}{z},ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x62, 0xd5, 0xb7, 0x9a, 0x3e);
    FCML_I64("vfmsub231pd ymm31{k7}{z},ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x62, 0xd5, 0xb7, 0xba, 0x3e);
    FCML_I64("vfmsub231pd ymm31{k7}{z},ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x62, 0xd5, 0xb7, 0xba, 0x3e);
    FCML_I64_M("vfmsub132pd xmm1,xmm5,xmmword ptr [rsp+0000000000000020h]", 2, FCML_MI(0x62, 0xf2, 0xd5, 0x08, 0x9a, 0x4c, 0x24, 0x02), FCML_MI(0xc4, 0xe2, 0xd1, 0x9a, 0x4c, 0x24, 0x20));
    FCML_I64_M("vfmsub231pd xmm1,xmm5,xmmword ptr [rsp+0000000000000020h]", 2, FCML_MI(0x62, 0xf2, 0xd5, 0x08, 0xba, 0x4c, 0x24, 0x02), FCML_MI(0xc4, 0xe2, 0xd1, 0xba, 0x4c, 0x24, 0x20));
    FCML_I64("vfmsub231pd xmm1{k4},xmm5,xmmword ptr [rsp+0000000000000020h]", 0x62, 0xf2, 0xd5, 0x0c, 0xba, 0x4c, 0x24, 0x02);
    FCML_I64("vfmsub132pd zmm2,zmm5,zmm4,{rn-sae}", 0x62, 0xf2, 0xd5, 0x18, 0x9a, 0xd4);
    FCML_I64("vfmsub231pd zmm2,zmm5,zmm4,{rn-sae}", 0x62, 0xf2, 0xd5, 0x18, 0xba, 0xd4);
    FCML_I64("vfmsub231pd zmm2,zmm5,zmm4,{rn-sae}", 0x62, 0xf2, 0xd5, 0x18, 0xba, 0xd4);
}

void fcml_tf_instruction_VFMSUBPS(void) {

    FCML_I32_M("vfmsub132ps xmm0,xmm3,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0x9a, 0x00), FCML_MI(0xc4, 0xe2, 0x61, 0x9a, 0x00));
    FCML_I64_M("vfmsub132ps ymm0,ymm3,ymmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0x9a, 0x00), FCML_MI(0xc4, 0xe2, 0x65, 0x9a, 0x00));
    FCML_I32_M("vfmsub132ps ymm0,ymm3,ymm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0x9a, 0xc0), FCML_MI(0xc4, 0xe2, 0x65, 0x9a, 0xc0));

    FCML_I32_M("vfmsub213ps xmm0,xmm3,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0xaa, 0x00), FCML_MI(0xc4, 0xe2, 0x61, 0xaa, 0x00));
    FCML_I64_M("vfmsub213ps ymm0,ymm3,ymmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0xaa, 0x00), FCML_MI(0xc4, 0xe2, 0x65, 0xaa, 0x00));
    FCML_I32_M("vfmsub213ps ymm0,ymm3,ymm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0xaa, 0xc0), FCML_MI(0xc4, 0xe2, 0x65, 0xaa, 0xc0));

    FCML_I32_M("vfmsub231ps xmm0,xmm3,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0xba, 0x00), FCML_MI(0xc4, 0xe2, 0x61, 0xba, 0x00));
    FCML_I64_M("vfmsub231ps ymm0,ymm3,ymmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0xba, 0x00), FCML_MI(0xc4, 0xe2, 0x65, 0xba, 0x00));
    FCML_I32_M("vfmsub231ps ymm0,ymm3,ymm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0xba, 0xc0), FCML_MI(0xc4, 0xe2, 0x65, 0xba, 0xc0));

    FCML_I64( "vfmsubps xmm2,xmm5,xmmword ptr [rcx+rax],xmm2", 0xC4, 0xE3, 0x51, 0x6C, 0x14, 0x01, 0x20 );
    FCML_I64( "vfmsubps ymm2,ymm5,ymmword ptr [rcx+rax],ymm2", 0xC4, 0xE3, 0x55, 0x6C, 0x14, 0x01, 0x20 );
    FCML_I64_M( "vfmsubps ymm0,ymm5,ymm0,ymm2", 2, FCML_MI( 0xc4, 0xe3, 0xd5, 0x6c, 0xc2, 0x00 ), FCML_MI( 0xc4, 0xe3, 0x55, 0x6c, 0xc0, 0x20 ) );

    FCML_I64( "vfmsubps xmm2,xmm5,xmm2,xmmword ptr [rcx+rax]", 0xC4, 0xE3, 0xD1, 0x6C, 0x14, 0x01, 0x20 );
    FCML_I64( "vfmsubps ymm2,ymm5,ymm2,ymmword ptr [rcx+rax]", 0xC4, 0xE3, 0xD5, 0x6C, 0x14, 0x01, 0x20 );
    FCML_I64_M( "vfmsubps ymm0,ymm5,ymm2,ymm0", 2, FCML_MI( 0xc4, 0xe3, 0xd5, 0x6c, 0xc0, 0x20 ), FCML_MI( 0xc4, 0xe3, 0x55, 0x6c, 0xc2, 0x00 ) );

    FCML_A64_M("vfmsub132ps (%rax),%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0x9a, 0x00), FCML_MI(0xc4, 0xe2, 0x61, 0x9a, 0x00));
    FCML_A64_M("vfmsub132ps (%rax),%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0x9a, 0x00), FCML_MI(0xc4, 0xe2, 0x65, 0x9a, 0x00));
    FCML_A64_M("vfmsub132ps %ymm0,%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0x9a, 0xc0), FCML_MI(0xc4, 0xe2, 0x65, 0x9a, 0xc0));
    FCML_A64_M("vfmsub213ps (%rax),%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0xaa, 0x00), FCML_MI(0xc4, 0xe2, 0x61, 0xaa, 0x00));
    FCML_A64_M("vfmsub213ps (%rax),%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0xaa, 0x00), FCML_MI(0xc4, 0xe2, 0x65, 0xaa, 0x00));
    FCML_A64_M("vfmsub213ps %ymm0,%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0xaa, 0xc0), FCML_MI(0xc4, 0xe2, 0x65, 0xaa, 0xc0));
    FCML_A64_M("vfmsub231ps (%rax),%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0xba, 0x00), FCML_MI(0xc4, 0xe2, 0x61, 0xba, 0x00));
    FCML_A64_M("vfmsub231ps (%rax),%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0xba, 0x00), FCML_MI(0xc4, 0xe2, 0x65, 0xba, 0x00));
    FCML_A64_M("vfmsub231ps %ymm0,%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0xba, 0xc0), FCML_MI(0xc4, 0xe2, 0x65, 0xba, 0xc0));

    FCML_A64( "vfmsubps %xmm2,(%rcx,%rax),%xmm5,%xmm2", 0xc4, 0xe3, 0x51, 0x6c, 0x14, 0x01, 0x20 );
    FCML_A64( "vfmsubps %ymm2,(%rcx,%rax),%ymm5,%ymm2", 0xc4, 0xe3, 0x55, 0x6c, 0x14, 0x01, 0x20 );

    FCML_I64("vfmsub132ps ymm31{k7}{z},ymm21,dword ptr [rsi]{1to8}", 0x62, 0x62, 0x55, 0xb7, 0x9a, 0x3e);
    FCML_I64("vfmsub213ps ymm31{k7}{z},ymm21,dword ptr [rsi]{1to8}", 0x62, 0x62, 0x55, 0xb7, 0xaa, 0x3e);
    FCML_I64("vfmsub231ps ymm31{k7}{z},ymm21,dword ptr [rsi]{1to8}", 0x62, 0x62, 0x55, 0xb7, 0xba, 0x3e);

    FCML_I64_M("vfmsub132ps xmm1,xmm5,xmmword ptr [rsp+0000000000000020h]", 2, FCML_MI(0x62, 0xf2, 0x55, 0x08, 0x9a, 0x4c, 0x24, 0x02), FCML_MI(0xc4, 0xe2, 0x51, 0x9a, 0x4c, 0x24, 0x20));
    FCML_I64_M("vfmsub213ps xmm1,xmm5,xmmword ptr [rsp+0000000000000020h]", 2, FCML_MI(0x62, 0xf2, 0x55, 0x08, 0xaa, 0x4c, 0x24, 0x02), FCML_MI(0xc4, 0xe2, 0x51, 0xaa, 0x4c, 0x24, 0x20));
    FCML_I64("vfmsub231ps xmm1{k4},xmm5,xmmword ptr [rsp+0000000000000020h]", 0x62, 0xf2, 0x55, 0x0c, 0xba, 0x4c, 0x24, 0x02);

    FCML_I64("vfmsub132ps zmm2,zmm5,zmm4,{rn-sae}", 0x62, 0xf2, 0x55, 0x18, 0x9a, 0xd4);
    FCML_I64("vfmsub213ps zmm2,zmm5,zmm4,{rn-sae}", 0x62, 0xf2, 0x55, 0x18, 0xaa, 0xd4);
    FCML_I64("vfmsub231ps zmm2,zmm5,zmm4,{rn-sae}", 0x62, 0xf2, 0x55, 0x18, 0xba, 0xd4);
}

void fcml_tf_instruction_VFMSUBSD(void) {

    FCML_I64_M("vfmsub132sd xmm0,xmm3,mmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0x9b, 0x00), FCML_MI(0xc4, 0xe2, 0xe1, 0x9b, 0x00));
    FCML_I64_M("vfmsub132sd xmm0,xmm3,xmm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0x9b, 0xc0), FCML_MI(0xc4, 0xe2, 0xe1, 0x9b, 0xc0));
    FCML_I64_M("vfmsub213sd xmm0,xmm3,mmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0xab, 0x00), FCML_MI(0xc4, 0xe2, 0xe1, 0xab, 0x00));
    FCML_I64_M("vfmsub213sd xmm0,xmm3,xmm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0xab, 0xc0), FCML_MI(0xc4, 0xe2, 0xe1, 0xab, 0xc0));
    FCML_I64_M("vfmsub231sd xmm0,xmm3,mmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0xbb, 0x00), FCML_MI(0xc4, 0xe2, 0xe1, 0xbb, 0x00));
    FCML_I64_M("vfmsub231sd xmm0,xmm3,xmm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0xbb, 0xc0), FCML_MI(0xc4, 0xe2, 0xe1, 0xbb, 0xc0));

    FCML_I32( "vfmsubsd xmm2,xmm5,mmword ptr [ecx+eax],xmm2", 0xC4, 0xE3, 0x51, 0x6F, 0x14, 0x01, 0x20 );
    FCML_I64_M( "vfmsubsd xmm0,xmm5,xmm0,xmm2", 2, FCML_MI( 0xc4, 0xe3, 0xd1, 0x6f, 0xc2, 0x00 ), FCML_MI( 0xc4, 0xe3, 0x51, 0x6f, 0xc0, 0x20 ) );
    FCML_I64( "vfmsubsd xmm2,xmm5,xmm2,mmword ptr [rcx+rax]", 0xC4, 0xE3, 0xD1, 0x6F, 0x14, 0x01, 0x20 );
    FCML_I64_M( "vfmsubsd xmm0,xmm5,xmm2,xmm0", 2, FCML_MI( 0xc4, 0xe3, 0xd1, 0x6f, 0xc0, 0x20 ), FCML_MI( 0xc4, 0xe3, 0x51, 0x6f, 0xc2, 0x00 ) );

    FCML_A64_M("vfmsub132sd (%rax),%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0x9b, 0x00), FCML_MI(0xc4, 0xe2, 0xe1, 0x9b, 0x00));
    FCML_A64_M("vfmsub132sd %xmm0,%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0x9b, 0xc0), FCML_MI(0xc4, 0xe2, 0xe1, 0x9b, 0xc0));
    FCML_A64_M("vfmsub213sd (%rax),%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0xab, 0x00), FCML_MI(0xc4, 0xe2, 0xe1, 0xab, 0x00));
    FCML_A64_M("vfmsub213sd %xmm0,%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0xab, 0xc0), FCML_MI(0xc4, 0xe2, 0xe1, 0xab, 0xc0));
    FCML_A64_M("vfmsub231sd (%rax),%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0xbb, 0x00), FCML_MI(0xc4, 0xe2, 0xe1, 0xbb, 0x00));
    FCML_A64_M("vfmsub231sd %xmm0,%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0xbb, 0xc0), FCML_MI(0xc4, 0xe2, 0xe1, 0xbb, 0xc0));

    FCML_A64( "vfmsubsd %xmm2,(%rcx,%rax),%xmm5,%xmm2", 0xc4, 0xe3, 0x51, 0x6f, 0x14, 0x01, 0x20 );

    FCML_A64("vfmsub132sd %xmm5,%xmm3,%xmm0{%k1}{z}", 0x62, 0xf2, 0xe5, 0x89, 0x9b, 0xc5);
    FCML_A64("vfmsub213sd (%rax),%xmm3,%xmm0{%k2}", 0x62, 0xf2, 0xe5, 0x0a, 0xab, 0x00);
    FCML_A64("vfmsub231sd (%rax),%xmm3,%xmm0{%k1}", 0x62, 0xf2, 0xe5, 0x09, 0xbb, 0x00);

    FCML_I64_M("vfmsub132sd xmm1,xmm5,mmword ptr [rsp+0000000000000010h]", 2, FCML_MI(0x62, 0xf2, 0xd5, 0x08, 0x9b, 0x4c, 0x24, 0x02), FCML_MI(0xc4, 0xe2, 0xd1, 0x9b, 0x4c, 0x24, 0x10));
    FCML_I64_M("vfmsub213sd xmm1,xmm5,mmword ptr [rsp+0000000000000010h]", 2, FCML_MI(0x62, 0xf2, 0xd5, 0x08, 0xab, 0x4c, 0x24, 0x02), FCML_MI(0xc4, 0xe2, 0xd1, 0xab, 0x4c, 0x24, 0x10));
    FCML_I64("vfmsub231sd xmm1{k4},xmm5,mmword ptr [rsp+0000000000000010h]", 0x62, 0xf2, 0xd5, 0x0c, 0xbb, 0x4c, 0x24, 0x02);

    FCML_I64("vfmsub132sd xmm2,xmm5,xmm4,{rn-sae}", 0x62, 0xf2, 0xd5, 0x18, 0x9b, 0xd4);
    FCML_I64("vfmsub213sd xmm2,xmm5,xmm4,{rn-sae}", 0x62, 0xf2, 0xd5, 0x18, 0xab, 0xd4);
    FCML_I64("vfmsub231sd xmm2,xmm5,xmm4,{rn-sae}", 0x62, 0xf2, 0xd5, 0x18, 0xbb, 0xd4);
}

void fcml_tf_instruction_VFMSUBSS(void) {

    FCML_I32_M("vfmsub132ss xmm0,xmm3,dword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0x9b, 0x00), FCML_MI(0xc4, 0xe2, 0x61, 0x9b, 0x00));
    FCML_I64_M("vfmsub132ss xmm0,xmm3,xmm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0x9b, 0xc0), FCML_MI(0xc4, 0xe2, 0x61, 0x9b, 0xc0));
    FCML_I32_M("vfmsub213ss xmm0,xmm3,dword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0xab, 0x00), FCML_MI(0xc4, 0xe2, 0x61, 0xab, 0x00));
    FCML_I64_M("vfmsub213ss xmm0,xmm3,xmm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0xab, 0xc0), FCML_MI(0xc4, 0xe2, 0x61, 0xab, 0xc0));
    FCML_I32_M("vfmsub231ss xmm0,xmm3,dword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0xbb, 0x00), FCML_MI(0xc4, 0xe2, 0x61, 0xbb, 0x00));
    FCML_I64_M("vfmsub231ss xmm0,xmm3,xmm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0xbb, 0xc0), FCML_MI(0xc4, 0xe2, 0x61, 0xbb, 0xc0));

    FCML_I64( "vfmsubss xmm2,xmm5,dword ptr [rcx+rax],xmm2", 0xC4, 0xE3, 0x51, 0x6E, 0x14, 0x01, 0x20 );
    FCML_I64_M( "vfmsubss xmm0,xmm5,xmm0,xmm2", 2, FCML_MI( 0xc4, 0xe3, 0xd1, 0x6e, 0xc2, 0x00 ), FCML_MI( 0xc4, 0xe3, 0x51, 0x6e, 0xc0, 0x20 ) );
    FCML_I64( "vfmsubss xmm2,xmm5,xmm2,dword ptr [rcx+rax]", 0xC4, 0xE3, 0xD1, 0x6E, 0x14, 0x01, 0x20 );
    FCML_I64_M( "vfmsubss xmm0,xmm5,xmm2,xmm0", 2, FCML_MI( 0xc4, 0xe3, 0xd1, 0x6e, 0xc0, 0x20 ), FCML_MI( 0xc4, 0xe3, 0x51, 0x6e, 0xc2, 0x00 ) );

    FCML_A64_M("vfmsub132ss (%rax),%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0x9b, 0x00), FCML_MI(0xc4, 0xe2, 0x61, 0x9b, 0x00));
    FCML_A64_M("vfmsub132ss %xmm0,%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0x9b, 0xc0), FCML_MI(0xc4, 0xe2, 0x61, 0x9b, 0xc0));
    FCML_A64_M("vfmsub213ss (%rax),%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0xab, 0x00), FCML_MI(0xc4, 0xe2, 0x61, 0xab, 0x00));
    FCML_A64_M("vfmsub213ss %xmm0,%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0xab, 0xc0), FCML_MI(0xc4, 0xe2, 0x61, 0xab, 0xc0));
    FCML_A64_M("vfmsub231ss (%rax),%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0xbb, 0x00), FCML_MI(0xc4, 0xe2, 0x61, 0xbb, 0x00));
    FCML_A64_M("vfmsub231ss %xmm0,%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0xbb, 0xc0), FCML_MI(0xc4, 0xe2, 0x61, 0xbb, 0xc0));

    FCML_A64( "vfmsubss %xmm2,(%rcx,%rax),%xmm5,%xmm2", 0xc4, 0xe3, 0x51, 0x6e, 0x14, 0x01, 0x20 );

    FCML_A64("vfmsub132ss %xmm5,%xmm3,%xmm0{%k1}{z}", 0x62, 0xf2, 0x65, 0x89, 0x9b, 0xc5);
    FCML_A64("vfmsub213ss (%rax),%xmm3,%xmm0{%k2}", 0x62, 0xf2, 0x65, 0x0a, 0xab, 0x00);
    FCML_A64("vfmsub231ss (%rax),%xmm3,%xmm0{%k1}", 0x62, 0xf2, 0x65, 0x09, 0xbb, 0x00);

    FCML_I64_M("vfmsub132ss xmm1,xmm5,dword ptr [rsp+0000000000000008h]", 2, FCML_MI(0x62, 0xf2, 0x55, 0x08, 0x9b, 0x4c, 0x24, 0x02), FCML_MI(0xc4, 0xe2, 0x51, 0x9b, 0x4c, 0x24, 0x08));
    FCML_I64_M("vfmsub213ss xmm1,xmm5,dword ptr [rsp+0000000000000008h]", 2, FCML_MI(0x62, 0xf2, 0x55, 0x08, 0xab, 0x4c, 0x24, 0x02), FCML_MI(0xc4, 0xe2, 0x51, 0xab, 0x4c, 0x24, 0x08));
    FCML_I64("vfmsub231ss xmm1{k4},xmm5,dword ptr [rsp+0000000000000008h]", 0x62, 0xf2, 0x55, 0x0c, 0xbb, 0x4c, 0x24, 0x02);

    FCML_I64("vfmsub132ss xmm2,xmm5,xmm4,{rn-sae}", 0x62, 0xf2, 0x55, 0x18, 0x9b, 0xd4);
    FCML_I64("vfmsub213ss xmm2,xmm5,xmm4,{rn-sae}", 0x62, 0xf2, 0x55, 0x18, 0xab, 0xd4);
    FCML_I64("vfmsub231ss xmm2,xmm5,xmm4,{rn-sae}", 0x62, 0xf2, 0x55, 0x18, 0xbb, 0xd4);
}

void fcml_tf_instruction_VFNMADDPD(void) {

    FCML_I64_M("vfnmadd132pd xmm0,xmm3,xmmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0x9c, 0x00), FCML_MI(0xc4, 0xe2, 0xe1, 0x9c, 0x00));
    FCML_I64_M("vfnmadd132pd ymm0,ymm3,ymmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0x9c, 0x00), FCML_MI(0xc4, 0xe2, 0xe5, 0x9c, 0x00));
    FCML_I64_M("vfnmadd132pd ymm0,ymm3,ymm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0x9c, 0xc0), FCML_MI(0xc4, 0xe2, 0xe5, 0x9c, 0xc0));
    FCML_I64_M("vfnmadd213pd xmm0,xmm3,xmmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0xac, 0x00), FCML_MI(0xc4, 0xe2, 0xe1, 0xac, 0x00));
    FCML_I64_M("vfnmadd213pd ymm0,ymm3,ymmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0xac, 0x00), FCML_MI(0xc4, 0xe2, 0xe5, 0xac, 0x00));
    FCML_I64_M("vfnmadd213pd ymm0,ymm3,ymm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0xac, 0xc0), FCML_MI(0xc4, 0xe2, 0xe5, 0xac, 0xc0));
    FCML_I64_M("vfnmadd231pd xmm0,xmm3,xmmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0xbc, 0x00), FCML_MI(0xc4, 0xe2, 0xe1, 0xbc, 0x00));
    FCML_I64_M("vfnmadd231pd ymm0,ymm3,ymmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0xbc, 0x00), FCML_MI(0xc4, 0xe2, 0xe5, 0xbc, 0x00));
    FCML_I64_M("vfnmadd231pd ymm0,ymm3,ymm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0xbc, 0xc0), FCML_MI(0xc4, 0xe2, 0xe5, 0xbc, 0xc0));

    FCML_I32( "vfnmaddpd xmm2,xmm5,xmmword ptr [ecx+eax],xmm2", 0xC4, 0xE3, 0x51, 0x79, 0x14, 0x01, 0x20 );
    FCML_I64( "vfnmaddpd ymm2,ymm5,ymmword ptr [rcx+rax],ymm2", 0xC4, 0xE3, 0x55, 0x79, 0x14, 0x01, 0x20 );
    FCML_I64_M( "vfnmaddpd ymm0,ymm5,ymm0,ymm2", 2, FCML_MI( 0xc4, 0xe3, 0xd5, 0x79, 0xc2, 0x00 ), FCML_MI( 0xc4, 0xe3, 0x55, 0x79, 0xc0, 0x20 ) );

    FCML_I64( "vfnmaddpd xmm2,xmm5,xmm2,xmmword ptr [rcx+rax]", 0xC4, 0xE3, 0xD1, 0x79, 0x14, 0x01, 0x20 );
    FCML_I64( "vfnmaddpd ymm2,ymm5,ymm2,ymmword ptr [rcx+rax]", 0xC4, 0xE3, 0xD5, 0x79, 0x14, 0x01, 0x20 );
    FCML_I64_M( "vfnmaddpd ymm0,ymm5,ymm2,ymm0", 2, FCML_MI( 0xc4, 0xe3, 0xd5, 0x79, 0xc0, 0x20 ), FCML_MI( 0xc4, 0xe3, 0x55, 0x79, 0xc2, 0x00 ) );

    FCML_A64_M("vfnmadd132pd (%rax),%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0x9c, 0x00), FCML_MI(0xc4, 0xe2, 0xe1, 0x9c, 0x00));
    FCML_A64_M("vfnmadd132pd (%rax),%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0x9c, 0x00), FCML_MI(0xc4, 0xe2, 0xe5, 0x9c, 0x00));
    FCML_A64_M("vfnmadd132pd %ymm0,%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0x9c, 0xc0), FCML_MI(0xc4, 0xe2, 0xe5, 0x9c, 0xc0));
    FCML_A64_M("vfnmadd213pd (%rax),%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0xac, 0x00), FCML_MI(0xc4, 0xe2, 0xe1, 0xac, 0x00));
    FCML_A64_M("vfnmadd213pd (%rax),%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0xac, 0x00), FCML_MI(0xc4, 0xe2, 0xe5, 0xac, 0x00));
    FCML_A64_M("vfnmadd213pd %ymm0,%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0xac, 0xc0), FCML_MI(0xc4, 0xe2, 0xe5, 0xac, 0xc0));
    FCML_A64_M("vfnmadd231pd (%rax),%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0xbc, 0x00), FCML_MI(0xc4, 0xe2, 0xe1, 0xbc, 0x00));
    FCML_A64_M("vfnmadd231pd (%rax),%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0xbc, 0x00), FCML_MI(0xc4, 0xe2, 0xe5, 0xbc, 0x00));
    FCML_A64_M("vfnmadd231pd %ymm0,%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0xbc, 0xc0), FCML_MI(0xc4, 0xe2, 0xe5, 0xbc, 0xc0));

    FCML_A64( "vfnmaddpd %xmm2,(%rcx,%rax),%xmm5,%xmm2", 0xc4, 0xe3, 0x51, 0x79, 0x14, 0x01, 0x20 );
    FCML_A64( "vfnmaddpd %ymm2,(%rcx,%rax),%ymm5,%ymm2", 0xc4, 0xe3, 0x55, 0x79, 0x14, 0x01, 0x20 );

    FCML_I64("vfnmadd132pd ymm31{k7}{z},ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x62, 0xd5, 0xb7, 0x9c, 0x3e);
    FCML_I64("vfnmadd213pd ymm31{k7}{z},ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x62, 0xd5, 0xb7, 0xac, 0x3e);
    FCML_I64("vfnmadd231pd ymm31{k7}{z},ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x62, 0xd5, 0xb7, 0xbc, 0x3e);
    FCML_I64_M("vfnmadd132pd xmm1,xmm5,xmmword ptr [rsp+0000000000000020h]", 2, FCML_MI(0x62, 0xf2, 0xd5, 0x08, 0x9c, 0x4c, 0x24, 0x02), FCML_MI(0xc4, 0xe2, 0xd1, 0x9c, 0x4c, 0x24, 0x20));
    FCML_I64_M("vfnmadd213pd xmm1,xmm5,xmmword ptr [rsp+0000000000000020h]", 2, FCML_MI(0x62, 0xf2, 0xd5, 0x08, 0xac, 0x4c, 0x24, 0x02), FCML_MI(0xc4, 0xe2, 0xd1, 0xac, 0x4c, 0x24, 0x20));
    FCML_I64("vfnmadd231pd xmm1{k4},xmm5,xmmword ptr [rsp+0000000000000020h]", 0x62, 0xf2, 0xd5, 0x0c, 0xbc, 0x4c, 0x24, 0x02);
    FCML_I64("vfnmadd132pd zmm2,zmm5,zmm4,{rn-sae}", 0x62, 0xf2, 0xd5, 0x18, 0x9c, 0xd4);
    FCML_I64("vfnmadd213pd zmm2,zmm5,zmm4,{rn-sae}", 0x62, 0xf2, 0xd5, 0x18, 0xac, 0xd4);
    FCML_I64("vfnmadd231pd zmm2,zmm5,zmm4,{rn-sae}", 0x62, 0xf2, 0xd5, 0x18, 0xbc, 0xd4);
}

void fcml_tf_instruction_VFNMADDPS(void) {

    FCML_I32_M("vfnmadd132ps xmm0,xmm3,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0x9c, 0x00), FCML_MI(0xc4, 0xe2, 0x61, 0x9c, 0x00));
    FCML_I64_M("vfnmadd132ps ymm0,ymm3,ymmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0x9c, 0x00), FCML_MI(0xc4, 0xe2, 0x65, 0x9c, 0x00));
    FCML_I32_M("vfnmadd132ps ymm0,ymm3,ymm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0x9c, 0xc0), FCML_MI(0xc4, 0xe2, 0x65, 0x9c, 0xc0));
    FCML_I32_M("vfnmadd213ps xmm0,xmm3,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0xac, 0x00), FCML_MI(0xc4, 0xe2, 0x61, 0xac, 0x00));
    FCML_I64_M("vfnmadd213ps ymm0,ymm3,ymmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0xac, 0x00), FCML_MI(0xc4, 0xe2, 0x65, 0xac, 0x00));
    FCML_I32_M("vfnmadd213ps ymm0,ymm3,ymm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0xac, 0xc0), FCML_MI(0xc4, 0xe2, 0x65, 0xac, 0xc0));
    FCML_I32_M("vfnmadd231ps xmm0,xmm3,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0xbc, 0x00), FCML_MI(0xc4, 0xe2, 0x61, 0xbc, 0x00));
    FCML_I64_M("vfnmadd231ps ymm0,ymm3,ymmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0xbc, 0x00), FCML_MI(0xc4, 0xe2, 0x65, 0xbc, 0x00));
    FCML_I32_M("vfnmadd231ps ymm0,ymm3,ymm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0xbc, 0xc0), FCML_MI(0xc4, 0xe2, 0x65, 0xbc, 0xc0));

    FCML_I64( "vfnmaddps xmm2,xmm5,xmmword ptr [rcx+rax],xmm2", 0xC4, 0xE3, 0x51, 0x78, 0x14, 0x01, 0x20 );
    FCML_I64( "vfnmaddps ymm2,ymm5,ymmword ptr [rcx+rax],ymm2", 0xC4, 0xE3, 0x55, 0x78, 0x14, 0x01, 0x20 );
    FCML_I64_M( "vfnmaddps ymm0,ymm5,ymm0,ymm2", 2, FCML_MI( 0xc4, 0xe3, 0xd5, 0x78, 0xc2, 0x00 ), FCML_MI( 0xc4, 0xe3, 0x55, 0x78, 0xc0, 0x20 ) );

    FCML_I64( "vfnmaddps xmm2,xmm5,xmm2,xmmword ptr [rcx+rax]", 0xC4, 0xE3, 0xD1, 0x78, 0x14, 0x01, 0x20 );
    FCML_I64( "vfnmaddps ymm2,ymm5,ymm2,ymmword ptr [rcx+rax]", 0xC4, 0xE3, 0xD5, 0x78, 0x14, 0x01, 0x20 );
    FCML_I64_M( "vfnmaddps ymm0,ymm5,ymm2,ymm0", 2, FCML_MI( 0xc4, 0xe3, 0xd5, 0x78, 0xc0, 0x20 ), FCML_MI( 0xc4, 0xe3, 0x55, 0x78, 0xc2, 0x00 ) );

    FCML_A64_M("vfnmadd132ps (%rax),%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0x9c, 0x00), FCML_MI(0xc4, 0xe2, 0x61, 0x9c, 0x00));
    FCML_A64_M("vfnmadd132ps (%rax),%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0x9c, 0x00), FCML_MI(0xc4, 0xe2, 0x65, 0x9c, 0x00));
    FCML_A64_M("vfnmadd132ps %ymm0,%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0x9c, 0xc0), FCML_MI(0xc4, 0xe2, 0x65, 0x9c, 0xc0));
    FCML_A64_M("vfnmadd213ps (%rax),%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0xac, 0x00), FCML_MI(0xc4, 0xe2, 0x61, 0xac, 0x00));
    FCML_A64_M("vfnmadd213ps (%rax),%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0xac, 0x00), FCML_MI(0xc4, 0xe2, 0x65, 0xac, 0x00));
    FCML_A64_M("vfnmadd213ps %ymm0,%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0xac, 0xc0), FCML_MI(0xc4, 0xe2, 0x65, 0xac, 0xc0));
    FCML_A64_M("vfnmadd231ps (%rax),%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0xbc, 0x00), FCML_MI(0xc4, 0xe2, 0x61, 0xbc, 0x00));
    FCML_A64_M("vfnmadd231ps (%rax),%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0xbc, 0x00), FCML_MI(0xc4, 0xe2, 0x65, 0xbc, 0x00));
    FCML_A64_M("vfnmadd231ps %ymm0,%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0xbc, 0xc0), FCML_MI(0xc4, 0xe2, 0x65, 0xbc, 0xc0));

    FCML_A64( "vfnmaddps %xmm2,(%rcx,%rax),%xmm5,%xmm2", 0xc4, 0xe3, 0x51, 0x78, 0x14, 0x01, 0x20 );
    FCML_A64( "vfnmaddps %ymm2,(%rcx,%rax),%ymm5,%ymm2", 0xc4, 0xe3, 0x55, 0x78, 0x14, 0x01, 0x20 );

    FCML_I64("vfnmadd132ps ymm31{k7}{z},ymm21,dword ptr [rsi]{1to8}", 0x62, 0x62, 0x55, 0xb7, 0x9c, 0x3e);
    FCML_I64("vfnmadd213ps ymm31{k7}{z},ymm21,dword ptr [rsi]{1to8}", 0x62, 0x62, 0x55, 0xb7, 0xac, 0x3e);
    FCML_I64("vfnmadd231ps ymm31{k7}{z},ymm21,dword ptr [rsi]{1to8}", 0x62, 0x62, 0x55, 0xb7, 0xbc, 0x3e);

    FCML_I64_M("vfnmadd132ps xmm1,xmm5,xmmword ptr [rsp+0000000000000020h]", 2, FCML_MI(0x62, 0xf2, 0x55, 0x08, 0x9c, 0x4c, 0x24, 0x02), FCML_MI(0xc4, 0xe2, 0x51, 0x9c, 0x4c, 0x24, 0x20));
    FCML_I64_M("vfnmadd213ps xmm1,xmm5,xmmword ptr [rsp+0000000000000020h]", 2, FCML_MI(0x62, 0xf2, 0x55, 0x08, 0xac, 0x4c, 0x24, 0x02), FCML_MI(0xc4, 0xe2, 0x51, 0xac, 0x4c, 0x24, 0x20));
    FCML_I64("vfnmadd231ps xmm1{k4},xmm5,xmmword ptr [rsp+0000000000000020h]", 0x62, 0xf2, 0x55, 0x0c, 0xbc, 0x4c, 0x24, 0x02);

    FCML_I64("vfnmadd132ps zmm2,zmm5,zmm4,{rn-sae}", 0x62, 0xf2, 0x55, 0x18, 0x9c, 0xd4);
    FCML_I64("vfnmadd213ps zmm2,zmm5,zmm4,{rn-sae}", 0x62, 0xf2, 0x55, 0x18, 0xac, 0xd4);
    FCML_I64("vfnmadd231ps zmm2,zmm5,zmm4,{rn-sae}", 0x62, 0xf2, 0x55, 0x18, 0xbc, 0xd4);
}

void fcml_tf_instruction_VFNMADDSD(void) {

    FCML_I64_M("vfnmadd132sd xmm0,xmm3,mmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0x9d, 0x00), FCML_MI(0xc4, 0xe2, 0xe1, 0x9d, 0x00));
    FCML_I64_M("vfnmadd132sd xmm0,xmm3,xmm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0x9d, 0xc0), FCML_MI(0xc4, 0xe2, 0xe1, 0x9d, 0xc0));
    FCML_I64_M("vfnmadd213sd xmm0,xmm3,mmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0xad, 0x00), FCML_MI(0xc4, 0xe2, 0xe1, 0xad, 0x00));
    FCML_I64_M("vfnmadd213sd xmm0,xmm3,xmm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0xad, 0xc0), FCML_MI(0xc4, 0xe2, 0xe1, 0xad, 0xc0));
    FCML_I64_M("vfnmadd231sd xmm0,xmm3,mmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0xbd, 0x00), FCML_MI(0xc4, 0xe2, 0xe1, 0xbd, 0x00));
    FCML_I64_M("vfnmadd231sd xmm0,xmm3,xmm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0xbd, 0xc0), FCML_MI(0xc4, 0xe2, 0xe1, 0xbd, 0xc0));

    FCML_I32( "vfnmaddsd xmm2,xmm5,mmword ptr [ecx+eax],xmm2", 0xC4, 0xE3, 0x51, 0x7B, 0x14, 0x01, 0x20 );
    FCML_I64_M( "vfnmaddsd xmm0,xmm5,xmm0,xmm2", 2, FCML_MI( 0xc4, 0xe3, 0xd1, 0x7b, 0xc2, 0x00 ), FCML_MI( 0xc4, 0xe3, 0x51, 0x7b, 0xc0, 0x20 ) );
    FCML_I64( "vfnmaddsd xmm2,xmm5,xmm2,mmword ptr [rcx+rax]", 0xC4, 0xE3, 0xD1, 0x7B, 0x14, 0x01, 0x20 );
    FCML_I64_M( "vfnmaddsd xmm0,xmm5,xmm2,xmm0", 2, FCML_MI( 0xc4, 0xe3, 0xd1, 0x7b, 0xc0, 0x20 ), FCML_MI( 0xc4, 0xe3, 0x51, 0x7b, 0xc2, 0x00 ) );

    FCML_A64_M("vfnmadd132sd (%rax),%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0x9d, 0x00), FCML_MI(0xc4, 0xe2, 0xe1, 0x9d, 0x00));
    FCML_A64_M("vfnmadd132sd %xmm0,%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0x9d, 0xc0), FCML_MI(0xc4, 0xe2, 0xe1, 0x9d, 0xc0));
    FCML_A64_M("vfnmadd213sd (%rax),%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0xad, 0x00), FCML_MI(0xc4, 0xe2, 0xe1, 0xad, 0x00));
    FCML_A64_M("vfnmadd213sd %xmm0,%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0xad, 0xc0), FCML_MI(0xc4, 0xe2, 0xe1, 0xad, 0xc0));
    FCML_A64_M("vfnmadd231sd (%rax),%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0xbd, 0x00), FCML_MI(0xc4, 0xe2, 0xe1, 0xbd, 0x00));
    FCML_A64_M("vfnmadd231sd %xmm0,%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0xbd, 0xc0), FCML_MI(0xc4, 0xe2, 0xe1, 0xbd, 0xc0));

    FCML_A64( "vfnmaddsd %xmm2,(%rcx,%rax),%xmm5,%xmm2", 0xc4, 0xe3, 0x51, 0x7b, 0x14, 0x01, 0x20 );

    FCML_A64("vfnmadd132sd %xmm5,%xmm3,%xmm0{%k1}{z}", 0x62, 0xf2, 0xe5, 0x89, 0x9d, 0xc5);
    FCML_A64("vfnmadd213sd (%rax),%xmm3,%xmm0{%k2}", 0x62, 0xf2, 0xe5, 0x0a, 0xad, 0x00);
    FCML_A64("vfnmadd231sd (%rax),%xmm3,%xmm0{%k1}", 0x62, 0xf2, 0xe5, 0x09, 0xbd, 0x00);

    FCML_I64_M("vfnmadd132sd xmm1,xmm5,mmword ptr [rsp+0000000000000010h]", 2, FCML_MI(0x62, 0xf2, 0xd5, 0x08, 0x9d, 0x4c, 0x24, 0x02), FCML_MI(0xc4, 0xe2, 0xd1, 0x9d, 0x4c, 0x24, 0x10));
    FCML_I64_M("vfnmadd213sd xmm1,xmm5,mmword ptr [rsp+0000000000000010h]", 2, FCML_MI(0x62, 0xf2, 0xd5, 0x08, 0xad, 0x4c, 0x24, 0x02), FCML_MI(0xc4, 0xe2, 0xd1, 0xad, 0x4c, 0x24, 0x10));
    FCML_I64("vfnmadd231sd xmm1{k4},xmm5,mmword ptr [rsp+0000000000000010h]", 0x62, 0xf2, 0xd5, 0x0c, 0xbd, 0x4c, 0x24, 0x02);

    FCML_I64("vfnmadd132sd xmm2,xmm5,xmm4,{rn-sae}", 0x62, 0xf2, 0xd5, 0x18, 0x9d, 0xd4);
    FCML_I64("vfnmadd213sd xmm2,xmm5,xmm4,{rn-sae}", 0x62, 0xf2, 0xd5, 0x18, 0xad, 0xd4);
    FCML_I64("vfnmadd231sd xmm2,xmm5,xmm4,{rn-sae}", 0x62, 0xf2, 0xd5, 0x18, 0xbd, 0xd4);
}

void fcml_tf_instruction_VFNMADDSS(void) {

    FCML_I32_M("vfnmadd132ss xmm0,xmm3,dword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0x9d, 0x00), FCML_MI(0xc4, 0xe2, 0x61, 0x9d, 0x00));
    FCML_I64_M("vfnmadd132ss xmm0,xmm3,xmm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0x9d, 0xc0), FCML_MI(0xc4, 0xe2, 0x61, 0x9d, 0xc0));
    FCML_I32_M("vfnmadd213ss xmm0,xmm3,dword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0xad, 0x00), FCML_MI(0xc4, 0xe2, 0x61, 0xad, 0x00));
    FCML_I64_M("vfnmadd213ss xmm0,xmm3,xmm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0xad, 0xc0), FCML_MI(0xc4, 0xe2, 0x61, 0xad, 0xc0));
    FCML_I32_M("vfnmadd231ss xmm0,xmm3,dword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0xbd, 0x00), FCML_MI(0xc4, 0xe2, 0x61, 0xbd, 0x00));
    FCML_I64_M("vfnmadd231ss xmm0,xmm3,xmm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0xbd, 0xc0), FCML_MI(0xc4, 0xe2, 0x61, 0xbd, 0xc0));

    FCML_I64( "vfnmaddss xmm2,xmm5,dword ptr [rcx+rax],xmm2", 0xC4, 0xE3, 0x51, 0x7A, 0x14, 0x01, 0x20 );
    FCML_I64_M( "vfnmaddss xmm0,xmm5,xmm0,xmm2", 2, FCML_MI( 0xc4, 0xe3, 0xd1, 0x7a, 0xc2, 0x00 ), FCML_MI( 0xc4, 0xe3, 0x51, 0x7a, 0xc0, 0x20 ) );
    FCML_I64( "vfnmaddss xmm2,xmm5,xmm2,dword ptr [rcx+rax]", 0xC4, 0xE3, 0xD1, 0x7A, 0x14, 0x01, 0x20 );
    FCML_I64_M( "vfnmaddss xmm0,xmm5,xmm2,xmm0", 2, FCML_MI( 0xc4, 0xe3, 0xd1, 0x7a, 0xc0, 0x20 ), FCML_MI( 0xc4, 0xe3, 0x51, 0x7a, 0xc2, 0x00 ) );

    FCML_A64_M("vfnmadd132ss (%rax),%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0x9d, 0x00), FCML_MI(0xc4, 0xe2, 0x61, 0x9d, 0x00));
    FCML_A64_M("vfnmadd132ss %xmm0,%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0x9d, 0xc0), FCML_MI(0xc4, 0xe2, 0x61, 0x9d, 0xc0));
    FCML_A64_M("vfnmadd213ss (%rax),%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0xad, 0x00), FCML_MI(0xc4, 0xe2, 0x61, 0xad, 0x00));
    FCML_A64_M("vfnmadd213ss %xmm0,%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0xad, 0xc0), FCML_MI(0xc4, 0xe2, 0x61, 0xad, 0xc0));
    FCML_A64_M("vfnmadd231ss (%rax),%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0xbd, 0x00), FCML_MI(0xc4, 0xe2, 0x61, 0xbd, 0x00));
    FCML_A64_M("vfnmadd231ss %xmm0,%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0xbd, 0xc0), FCML_MI(0xc4, 0xe2, 0x61, 0xbd, 0xc0));

    FCML_A64( "vfnmaddss %xmm2,(%rcx,%rax),%xmm5,%xmm2", 0xc4, 0xe3, 0x51, 0x7a, 0x14, 0x01, 0x20 );

    FCML_A64("vfnmadd132ss %xmm5,%xmm3,%xmm0{%k1}{z}", 0x62, 0xf2, 0x65, 0x89, 0x9d, 0xc5);
    FCML_A64("vfnmadd213ss (%rax),%xmm3,%xmm0{%k2}", 0x62, 0xf2, 0x65, 0x0a, 0xad, 0x00);
    FCML_A64("vfnmadd231ss (%rax),%xmm3,%xmm0{%k1}", 0x62, 0xf2, 0x65, 0x09, 0xbd, 0x00);

    FCML_I64_M("vfnmadd132ss xmm1,xmm5,dword ptr [rsp+0000000000000008h]", 2, FCML_MI(0x62, 0xf2, 0x55, 0x08, 0x9d, 0x4c, 0x24, 0x02), FCML_MI(0xc4, 0xe2, 0x51, 0x9d, 0x4c, 0x24, 0x08));
    FCML_I64_M("vfnmadd213ss xmm1,xmm5,dword ptr [rsp+0000000000000008h]", 2, FCML_MI(0x62, 0xf2, 0x55, 0x08, 0xad, 0x4c, 0x24, 0x02), FCML_MI(0xc4, 0xe2, 0x51, 0xad, 0x4c, 0x24, 0x08));
    FCML_I64("vfnmadd231ss xmm1{k4},xmm5,dword ptr [rsp+0000000000000008h]", 0x62, 0xf2, 0x55, 0x0c, 0xbd, 0x4c, 0x24, 0x02);

    FCML_I64("vfnmadd132ss xmm2,xmm5,xmm4,{rn-sae}", 0x62, 0xf2, 0x55, 0x18, 0x9d, 0xd4);
    FCML_I64("vfnmadd213ss xmm2,xmm5,xmm4,{rn-sae}", 0x62, 0xf2, 0x55, 0x18, 0xad, 0xd4);
    FCML_I64("vfnmadd231ss xmm2,xmm5,xmm4,{rn-sae}", 0x62, 0xf2, 0x55, 0x18, 0xbd, 0xd4);
}

void fcml_tf_instruction_VFNMSUBPD(void) {

    FCML_I64_M("vfnmsub132pd xmm0,xmm3,xmmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0x9e, 0x00), FCML_MI(0xc4, 0xe2, 0xe1, 0x9e, 0x00));
    FCML_I64_M("vfnmsub132pd ymm0,ymm3,ymmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0x9e, 0x00), FCML_MI(0xc4, 0xe2, 0xe5, 0x9e, 0x00));
    FCML_I64_M("vfnmsub132pd ymm0,ymm3,ymm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0x9e, 0xc0), FCML_MI(0xc4, 0xe2, 0xe5, 0x9e, 0xc0));

    FCML_I64_M("vfnmsub213pd ymm0,ymm3,ymmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0xae, 0x00), FCML_MI(0xc4, 0xe2, 0xe5, 0xae, 0x00));
    FCML_I64_M("vfnmsub213pd ymm0,ymm3,ymm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0xae, 0xc0), FCML_MI(0xc4, 0xe2, 0xe5, 0xae, 0xc0));

    FCML_I64_M("vfnmsub231pd xmm0,xmm3,xmmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0xbe, 0x00), FCML_MI(0xc4, 0xe2, 0xe1, 0xbe, 0x00));
    FCML_I64_M("vfnmsub231pd ymm0,ymm3,ymmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0xbe, 0x00), FCML_MI(0xc4, 0xe2, 0xe5, 0xbe, 0x00));
    FCML_I64_M("vfnmsub231pd ymm0,ymm3,ymm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0xbe, 0xc0), FCML_MI(0xc4, 0xe2, 0xe5, 0xbe, 0xc0));

    FCML_I32( "vfnmsubpd xmm2,xmm5,xmmword ptr [ecx+eax],xmm2", 0xC4, 0xE3, 0x51, 0x7D, 0x14, 0x01, 0x20 );
    FCML_I64( "vfnmsubpd ymm2,ymm5,ymmword ptr [rcx+rax],ymm2", 0xC4, 0xE3, 0x55, 0x7D, 0x14, 0x01, 0x20 );
    FCML_I64_M( "vfnmsubpd ymm0,ymm5,ymm0,ymm2", 2, FCML_MI( 0xc4, 0xe3, 0xd5, 0x7d, 0xc2, 0x00 ), FCML_MI( 0xc4, 0xe3, 0x55, 0x7d, 0xc0, 0x20 ) );

    FCML_I64( "vfnmsubpd xmm2,xmm5,xmm2,xmmword ptr [rcx+rax]", 0xC4, 0xE3, 0xD1, 0x7D, 0x14, 0x01, 0x20 );
    FCML_I64( "vfnmsubpd ymm2,ymm5,ymm2,ymmword ptr [rcx+rax]", 0xC4, 0xE3, 0xD5, 0x7D, 0x14, 0x01, 0x20 );
    FCML_I64_M( "vfnmsubpd ymm0,ymm5,ymm2,ymm0", 2, FCML_MI( 0xc4, 0xe3, 0xd5, 0x7d, 0xc0, 0x20 ), FCML_MI( 0xc4, 0xe3, 0x55, 0x7d, 0xc2, 0x00 ) );

    FCML_A64_M("vfnmsub132pd (%rax),%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0x9e, 0x00), FCML_MI(0xc4, 0xe2, 0xe1, 0x9e, 0x00));
    FCML_A64_M("vfnmsub132pd (%rax),%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0x9e, 0x00), FCML_MI(0xc4, 0xe2, 0xe5, 0x9e, 0x00));
    FCML_A64_M("vfnmsub132pd %ymm0,%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0x9e, 0xc0), FCML_MI(0xc4, 0xe2, 0xe5, 0x9e, 0xc0));
    FCML_A64_M("vfnmsub213pd (%rax),%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0xae, 0x00), FCML_MI(0xc4, 0xe2, 0xe1, 0xae, 0x00));
    FCML_A64_M("vfnmsub213pd (%rax),%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0xae, 0x00), FCML_MI(0xc4, 0xe2, 0xe5, 0xae, 0x00));
    FCML_A64_M("vfnmsub213pd %ymm0,%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0xae, 0xc0), FCML_MI(0xc4, 0xe2, 0xe5, 0xae, 0xc0));
    FCML_A64_M("vfnmsub231pd (%rax),%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0xbe, 0x00), FCML_MI(0xc4, 0xe2, 0xe1, 0xbe, 0x00));
    FCML_A64_M("vfnmsub231pd (%rax),%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0xbe, 0x00), FCML_MI(0xc4, 0xe2, 0xe5, 0xbe, 0x00));
    FCML_A64_M("vfnmsub231pd %ymm0,%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0xbe, 0xc0), FCML_MI(0xc4, 0xe2, 0xe5, 0xbe, 0xc0));

    FCML_A64( "vfnmsubpd %xmm2,(%rcx,%rax),%xmm5,%xmm2", 0xc4, 0xe3, 0x51, 0x7d, 0x14, 0x01, 0x20 );
    FCML_A64( "vfnmsubpd %ymm2,(%rcx,%rax),%ymm5,%ymm2", 0xc4, 0xe3, 0x55, 0x7d, 0x14, 0x01, 0x20 );

    FCML_I64("vfnmsub132pd ymm31{k7}{z},ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x62, 0xd5, 0xb7, 0x9e, 0x3e);
    FCML_I64("vfnmsub213pd ymm31{k7}{z},ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x62, 0xd5, 0xb7, 0xae, 0x3e);
    FCML_I64("vfnmsub231pd ymm31{k7}{z},ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x62, 0xd5, 0xb7, 0xbe, 0x3e);
    FCML_I64_M("vfnmsub132pd xmm1,xmm5,xmmword ptr [rsp+0000000000000020h]", 2, FCML_MI(0x62, 0xf2, 0xd5, 0x08, 0x9e, 0x4c, 0x24, 0x02), FCML_MI(0xc4, 0xe2, 0xd1, 0x9e, 0x4c, 0x24, 0x20));
    FCML_I64_M("vfnmsub213pd xmm1,xmm5,xmmword ptr [rsp+0000000000000020h]", 2, FCML_MI(0x62, 0xf2, 0xd5, 0x08, 0xae, 0x4c, 0x24, 0x02), FCML_MI(0xc4, 0xe2, 0xd1, 0xae, 0x4c, 0x24, 0x20));
    FCML_I64("vfnmsub231pd xmm1{k4},xmm5,xmmword ptr [rsp+0000000000000020h]", 0x62, 0xf2, 0xd5, 0x0c, 0xbe, 0x4c, 0x24, 0x02);
    FCML_I64("vfnmsub132pd zmm2,zmm5,zmm4,{rn-sae}", 0x62, 0xf2, 0xd5, 0x18, 0x9e, 0xd4);
    FCML_I64("vfnmsub213pd zmm2,zmm5,zmm4,{rn-sae}", 0x62, 0xf2, 0xd5, 0x18, 0xae, 0xd4);
    FCML_I64("vfnmsub231pd zmm2,zmm5,zmm4,{rn-sae}", 0x62, 0xf2, 0xd5, 0x18, 0xbe, 0xd4);
}

void fcml_tf_instruction_VFNMSUBPS(void) {

    FCML_I32_M("vfnmsub132ps xmm0,xmm3,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0x9e, 0x00), FCML_MI(0xc4, 0xe2, 0x61, 0x9e, 0x00));
    FCML_I64_M("vfnmsub132ps ymm0,ymm3,ymmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0x9e, 0x00), FCML_MI(0xc4, 0xe2, 0x65, 0x9e, 0x00));
    FCML_I32_M("vfnmsub132ps ymm0,ymm3,ymm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0x9e, 0xc0), FCML_MI(0xc4, 0xe2, 0x65, 0x9e, 0xc0));
    FCML_I32_M("vfnmsub213ps xmm0,xmm3,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0xae, 0x00), FCML_MI(0xc4, 0xe2, 0x61, 0xae, 0x00));
    FCML_I64_M("vfnmsub213ps ymm0,ymm3,ymmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0xae, 0x00), FCML_MI(0xc4, 0xe2, 0x65, 0xae, 0x00));
    FCML_I32_M("vfnmsub213ps ymm0,ymm3,ymm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0xae, 0xc0), FCML_MI(0xc4, 0xe2, 0x65, 0xae, 0xc0));
    FCML_I32_M("vfnmsub231ps xmm0,xmm3,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0xbe, 0x00), FCML_MI(0xc4, 0xe2, 0x61, 0xbe, 0x00));
    FCML_I64_M("vfnmsub231ps ymm0,ymm3,ymmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0xbe, 0x00), FCML_MI(0xc4, 0xe2, 0x65, 0xbe, 0x00));
    FCML_I32_M("vfnmsub231ps ymm0,ymm3,ymm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0xbe, 0xc0), FCML_MI(0xc4, 0xe2, 0x65, 0xbe, 0xc0));

    FCML_I64( "vfnmsubps xmm2,xmm5,xmmword ptr [rcx+rax],xmm2", 0xC4, 0xE3, 0x51, 0x7C, 0x14, 0x01, 0x20 );
    FCML_I64( "vfnmsubps ymm2,ymm5,ymmword ptr [rcx+rax],ymm2", 0xC4, 0xE3, 0x55, 0x7C, 0x14, 0x01, 0x20 );
    FCML_I64_M( "vfnmsubps ymm0,ymm5,ymm0,ymm2", 2, FCML_MI( 0xc4, 0xe3, 0xd5, 0x7c, 0xc2, 0x00 ), FCML_MI( 0xc4, 0xe3, 0x55, 0x7c, 0xc0, 0x20 ) );

    FCML_I64( "vfnmsubps xmm2,xmm5,xmm2,xmmword ptr [rcx+rax]", 0xC4, 0xE3, 0xD1, 0x7C, 0x14, 0x01, 0x20 );
    FCML_I64( "vfnmsubps ymm2,ymm5,ymm2,ymmword ptr [rcx+rax]", 0xC4, 0xE3, 0xD5, 0x7C, 0x14, 0x01, 0x20 );
    FCML_I64_M( "vfnmsubps ymm0,ymm5,ymm2,ymm0", 2, FCML_MI( 0xc4, 0xe3, 0xd5, 0x7c, 0xc0, 0x20 ), FCML_MI( 0xc4, 0xe3, 0x55, 0x7c, 0xc2, 0x00 ) );

    FCML_A64_M("vfnmsub132ps (%rax),%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0x9e, 0x00), FCML_MI(0xc4, 0xe2, 0x61, 0x9e, 0x00));
    FCML_A64_M("vfnmsub132ps (%rax),%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0x9e, 0x00), FCML_MI(0xc4, 0xe2, 0x65, 0x9e, 0x00));
    FCML_A64_M("vfnmsub132ps %ymm0,%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0x9e, 0xc0), FCML_MI(0xc4, 0xe2, 0x65, 0x9e, 0xc0));
    FCML_A64_M("vfnmsub213ps (%rax),%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0xae, 0x00), FCML_MI(0xc4, 0xe2, 0x61, 0xae, 0x00));
    FCML_A64_M("vfnmsub213ps (%rax),%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0xae, 0x00), FCML_MI(0xc4, 0xe2, 0x65, 0xae, 0x00));
    FCML_A64_M("vfnmsub213ps %ymm0,%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0xae, 0xc0), FCML_MI(0xc4, 0xe2, 0x65, 0xae, 0xc0));
    FCML_A64_M("vfnmsub231ps (%rax),%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0xbe, 0x00), FCML_MI(0xc4, 0xe2, 0x61, 0xbe, 0x00));
    FCML_A64_M("vfnmsub231ps (%rax),%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0xbe, 0x00), FCML_MI(0xc4, 0xe2, 0x65, 0xbe, 0x00));
    FCML_A64_M("vfnmsub231ps %ymm0,%ymm3,%ymm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x28, 0xbe, 0xc0), FCML_MI(0xc4, 0xe2, 0x65, 0xbe, 0xc0));

    FCML_A64( "vfnmsubps %xmm2,(%rcx,%rax),%xmm5,%xmm2", 0xc4, 0xe3, 0x51, 0x7c, 0x14, 0x01, 0x20 );
    FCML_A64( "vfnmsubps %ymm2,(%rcx,%rax),%ymm5,%ymm2", 0xc4, 0xe3, 0x55, 0x7c, 0x14, 0x01, 0x20 );

    FCML_I64("vfnmsub132ps ymm31{k7}{z},ymm21,dword ptr [rsi]{1to8}", 0x62, 0x62, 0x55, 0xb7, 0x9e, 0x3e);
    FCML_I64("vfnmsub213ps ymm31{k7}{z},ymm21,dword ptr [rsi]{1to8}", 0x62, 0x62, 0x55, 0xb7, 0xae, 0x3e);
    FCML_I64("vfnmsub231ps ymm31{k7}{z},ymm21,dword ptr [rsi]{1to8}", 0x62, 0x62, 0x55, 0xb7, 0xbe, 0x3e);

    FCML_I64_M("vfnmsub132ps xmm1,xmm5,xmmword ptr [rsp+0000000000000020h]", 2, FCML_MI(0x62, 0xf2, 0x55, 0x08, 0x9e, 0x4c, 0x24, 0x02), FCML_MI(0xc4, 0xe2, 0x51, 0x9e, 0x4c, 0x24, 0x20));
    FCML_I64_M("vfnmsub213ps xmm1,xmm5,xmmword ptr [rsp+0000000000000020h]", 2, FCML_MI(0x62, 0xf2, 0x55, 0x08, 0xae, 0x4c, 0x24, 0x02), FCML_MI(0xc4, 0xe2, 0x51, 0xae, 0x4c, 0x24, 0x20));
    FCML_I64("vfnmsub231ps xmm1{k4},xmm5,xmmword ptr [rsp+0000000000000020h]", 0x62, 0xf2, 0x55, 0x0c, 0xbe, 0x4c, 0x24, 0x02);

    FCML_I64("vfnmsub132ps zmm2,zmm5,zmm4,{rn-sae}", 0x62, 0xf2, 0x55, 0x18, 0x9e, 0xd4);
    FCML_I64("vfnmsub213ps zmm2,zmm5,zmm4,{rn-sae}", 0x62, 0xf2, 0x55, 0x18, 0xae, 0xd4);
    FCML_I64("vfnmsub231ps zmm2,zmm5,zmm4,{rn-sae}", 0x62, 0xf2, 0x55, 0x18, 0xbe, 0xd4);
}

void fcml_tf_instruction_VFNMSUBSD(void) {

    FCML_I64_M("vfnmsub132sd xmm0,xmm3,mmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0x9f, 0x00), FCML_MI(0xc4, 0xe2, 0xe1, 0x9f, 0x00));
    FCML_I64_M("vfnmsub132sd xmm0,xmm3,xmm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0x9f, 0xc0), FCML_MI(0xc4, 0xe2, 0xe1, 0x9f, 0xc0));

    FCML_I64_M("vfnmsub213sd xmm0,xmm3,mmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0xaf, 0x00), FCML_MI(0xc4, 0xe2, 0xe1, 0xaf, 0x00));
    FCML_I64_M("vfnmsub213sd xmm0,xmm3,xmm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0xaf, 0xc0), FCML_MI(0xc4, 0xe2, 0xe1, 0xaf, 0xc0));

    FCML_I64_M("vfnmsub231sd xmm0,xmm3,mmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0xbf, 0x00), FCML_MI(0xc4, 0xe2, 0xe1, 0xbf, 0x00));
    FCML_I64_M("vfnmsub231sd xmm0,xmm3,xmm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0xbf, 0xc0), FCML_MI(0xc4, 0xe2, 0xe1, 0xbf, 0xc0));

    FCML_I32( "vfnmsubsd xmm2,xmm5,mmword ptr [ecx+eax],xmm2", 0xC4, 0xE3, 0x51, 0x7F, 0x14, 0x01, 0x20 );
    FCML_I64_M( "vfnmsubsd xmm0,xmm5,xmm0,xmm2", 2, FCML_MI( 0xc4, 0xe3, 0xd1, 0x7f, 0xc2, 0x00 ), FCML_MI( 0xc4, 0xe3, 0x51, 0x7f, 0xc0, 0x20 ) );
    FCML_I64( "vfnmsubsd xmm2,xmm5,xmm2,mmword ptr [rcx+rax]", 0xC4, 0xE3, 0xD1, 0x7F, 0x14, 0x01, 0x20 );
    FCML_I64_M( "vfnmsubsd xmm0,xmm5,xmm2,xmm0", 2, FCML_MI( 0xc4, 0xe3, 0xd1, 0x7f, 0xc0, 0x20 ), FCML_MI( 0xc4, 0xe3, 0x51, 0x7f, 0xc2, 0x00 ) );

    FCML_A64_M("vfnmsub132sd (%rax),%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0x9f, 0x00), FCML_MI(0xc4, 0xe2, 0xe1, 0x9f, 0x00));
    FCML_A64_M("vfnmsub132sd %xmm0,%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0x9f, 0xc0), FCML_MI(0xc4, 0xe2, 0xe1, 0x9f, 0xc0));
    FCML_A64_M("vfnmsub213sd (%rax),%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0xaf, 0x00), FCML_MI(0xc4, 0xe2, 0xe1, 0xaf, 0x00));
    FCML_A64_M("vfnmsub213sd %xmm0,%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0xaf, 0xc0), FCML_MI(0xc4, 0xe2, 0xe1, 0xaf, 0xc0));
    FCML_A64_M("vfnmsub231sd (%rax),%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0xbf, 0x00), FCML_MI(0xc4, 0xe2, 0xe1, 0xbf, 0x00));
    FCML_A64_M("vfnmsub231sd %xmm0,%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x08, 0xbf, 0xc0), FCML_MI(0xc4, 0xe2, 0xe1, 0xbf, 0xc0));

    FCML_A64( "vfnmsubsd %xmm2,(%rcx,%rax),%xmm5,%xmm2", 0xc4, 0xe3, 0x51, 0x7f, 0x14, 0x01, 0x20 );
}

void fcml_tf_instruction_VFNMSUBSS(void) {

    FCML_I32_M("vfnmsub132ss xmm0,xmm3,dword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0x9f, 0x00), FCML_MI(0xc4, 0xe2, 0x61, 0x9f, 0x00));
    FCML_I64_M("vfnmsub132ss xmm0,xmm3,xmm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0x9f, 0xc0), FCML_MI(0xc4, 0xe2, 0x61, 0x9f, 0xc0));

    FCML_I32_M("vfnmsub213ss xmm0,xmm3,dword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0xaf, 0x00), FCML_MI(0xc4, 0xe2, 0x61, 0xaf, 0x00));
    FCML_I64_M("vfnmsub213ss xmm0,xmm3,xmm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0xaf, 0xc0), FCML_MI(0xc4, 0xe2, 0x61, 0xaf, 0xc0));

    FCML_I32_M("vfnmsub231ss xmm0,xmm3,dword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0xbf, 0x00), FCML_MI(0xc4, 0xe2, 0x61, 0xbf, 0x00));
    FCML_I64_M("vfnmsub231ss xmm0,xmm3,xmm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0xbf, 0xc0), FCML_MI(0xc4, 0xe2, 0x61, 0xbf, 0xc0));

    FCML_I64( "vfnmsubss xmm2,xmm5,dword ptr [rcx+rax],xmm2", 0xC4, 0xE3, 0x51, 0x7E, 0x14, 0x01, 0x20 );
    FCML_I64_M( "vfnmsubss xmm0,xmm5,xmm0,xmm2", 2, FCML_MI( 0xc4, 0xe3, 0xd1, 0x7e, 0xc2, 0x00 ), FCML_MI( 0xc4, 0xe3, 0x51, 0x7e, 0xc0, 0x20 ) );
    FCML_I64( "vfnmsubss xmm2,xmm5,xmm2,dword ptr [rcx+rax]", 0xC4, 0xE3, 0xD1, 0x7E, 0x14, 0x01, 0x20 );
    FCML_I64_M( "vfnmsubss xmm0,xmm5,xmm2,xmm0", 2, FCML_MI( 0xc4, 0xe3, 0xd1, 0x7e, 0xc0, 0x20 ), FCML_MI( 0xc4, 0xe3, 0x51, 0x7e, 0xc2, 0x00 ) );

    FCML_A64_M("vfnmsub132ss (%rax),%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0x9f, 0x00), FCML_MI(0xc4, 0xe2, 0x61, 0x9f, 0x00));
    FCML_A64_M("vfnmsub132ss %xmm0,%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0x9f, 0xc0), FCML_MI(0xc4, 0xe2, 0x61, 0x9f, 0xc0));
    FCML_A64_M("vfnmsub213ss (%rax),%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0xaf, 0x00), FCML_MI(0xc4, 0xe2, 0x61, 0xaf, 0x00));
    FCML_A64_M("vfnmsub213ss %xmm0,%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0xaf, 0xc0), FCML_MI(0xc4, 0xe2, 0x61, 0xaf, 0xc0));
    FCML_A64_M("vfnmsub231ss (%rax),%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0xbf, 0x00), FCML_MI(0xc4, 0xe2, 0x61, 0xbf, 0x00));
    FCML_A64_M("vfnmsub231ss %xmm0,%xmm3,%xmm0", 2, FCML_MI(0x62, 0xf2, 0x65, 0x08, 0xbf, 0xc0), FCML_MI(0xc4, 0xe2, 0x61, 0xbf, 0xc0));

    FCML_A64( "vfnmsubss %xmm2,(%rcx,%rax),%xmm5,%xmm2", 0xc4, 0xe3, 0x51, 0x7e, 0x14, 0x01, 0x20 );

    FCML_A64("vfnmsub132ss %xmm5,%xmm3,%xmm0{%k1}{z}", 0x62, 0xf2, 0x65, 0x89, 0x9f, 0xc5);
    FCML_A64("vfnmsub213ss (%rax),%xmm3,%xmm0{%k2}", 0x62, 0xf2, 0x65, 0x0a, 0xaf, 0x00);
    FCML_A64("vfnmsub231ss (%rax),%xmm3,%xmm0{%k1}", 0x62, 0xf2, 0x65, 0x09, 0xbf, 0x00);

    FCML_I64_M("vfnmsub132ss xmm1,xmm5,dword ptr [rsp+0000000000000008h]", 2, FCML_MI(0x62, 0xf2, 0x55, 0x08, 0x9f, 0x4c, 0x24, 0x02), FCML_MI(0xc4, 0xe2, 0x51, 0x9f, 0x4c, 0x24, 0x08));
    FCML_I64_M("vfnmsub213ss xmm1,xmm5,dword ptr [rsp+0000000000000008h]", 2, FCML_MI(0x62, 0xf2, 0x55, 0x08, 0xaf, 0x4c, 0x24, 0x02), FCML_MI(0xc4, 0xe2, 0x51, 0xaf, 0x4c, 0x24, 0x08));
    FCML_I64("vfnmsub231ss xmm1{k4},xmm5,dword ptr [rsp+0000000000000008h]", 0x62, 0xf2, 0x55, 0x0c, 0xbf, 0x4c, 0x24, 0x02);

    FCML_I64("vfnmsub132ss xmm2,xmm5,xmm4,{rn-sae}", 0x62, 0xf2, 0x55, 0x18, 0x9f, 0xd4);
    FCML_I64("vfnmsub213ss xmm2,xmm5,xmm4,{rn-sae}", 0x62, 0xf2, 0x55, 0x18, 0xaf, 0xd4);
    FCML_I64("vfnmsub231ss xmm2,xmm5,xmm4,{rn-sae}", 0x62, 0xf2, 0x55, 0x18, 0xbf, 0xd4);
}

void fcml_tf_instruction_VFRCZPD(void) {

    FCML_I32( "vfrczpd xmm0,xmmword ptr [eax]", 0x8F, 0xE9, 0x78, 0x81, 0x00 );
    FCML_I32( "vfrczpd xmm0,xmm1", 0x8F, 0xE9, 0x78, 0x81, 0xC1 );
    FCML_I32( "vfrczpd ymm0,ymmword ptr [eax]", 0x8F, 0xE9, 0x7C, 0x81, 0x00 );
    FCML_I32( "vfrczpd ymm0,ymm1", 0x8F, 0xE9, 0x7C, 0x81, 0xC1 );
    FCML_I64( "vfrczpd xmm0,xmmword ptr [rax]", 0x8F, 0xE9, 0x78, 0x81, 0x00 );
    FCML_I64( "vfrczpd ymm0,ymmword ptr [rax]", 0x8F, 0xE9, 0x7C, 0x81, 0x00 );

    FCML_A64( "vfrczpd (%rax),%xmm0", 0x8f, 0xe9, 0x78, 0x81, 0x00 );
    FCML_A64( "vfrczpd %xmm1,%xmm0", 0x8f, 0xe9, 0x78, 0x81, 0xc1 );
    FCML_A64( "vfrczpd (%rax),%ymm0", 0x8f, 0xe9, 0x7c, 0x81, 0x00 );
    FCML_A64( "vfrczpd %ymm1,%ymm0", 0x8f, 0xe9, 0x7c, 0x81, 0xc1 );
    FCML_A64( "vfrczpd (%rax),%xmm0", 0x8f, 0xe9, 0x78, 0x81, 0x00 );
    FCML_A64( "vfrczpd (%rax),%ymm0", 0x8f, 0xe9, 0x7c, 0x81, 0x00 );
}

void fcml_tf_instruction_VFRCZPS(void) {

    FCML_I32( "vfrczps xmm0,xmmword ptr [eax]", 0x8F, 0xE9, 0x78, 0x80, 0x00 );
    FCML_I32( "vfrczps xmm0,xmm1", 0x8F, 0xE9, 0x78, 0x80, 0xC1 );
    FCML_I32( "vfrczps ymm0,ymmword ptr [eax]", 0x8F, 0xE9, 0x7C, 0x80, 0x00 );
    FCML_I32( "vfrczps ymm0,ymm1", 0x8F, 0xE9, 0x7C, 0x80, 0xC1 );
    FCML_I64( "vfrczps xmm0,xmmword ptr [rax]", 0x8F, 0xE9, 0x78, 0x80, 0x00 );
    FCML_I64( "vfrczps ymm0,ymmword ptr [rax]", 0x8F, 0xE9, 0x7C, 0x80, 0x00 );

    FCML_A64( "vfrczps (%rax),%xmm0", 0x8f, 0xe9, 0x78, 0x80, 0x00 );
    FCML_A64( "vfrczps %xmm1,%xmm0", 0x8f, 0xe9, 0x78, 0x80, 0xc1 );
    FCML_A64( "vfrczps (%rax),%ymm0", 0x8f, 0xe9, 0x7c, 0x80, 0x00 );
    FCML_A64( "vfrczps %ymm1,%ymm0", 0x8f, 0xe9, 0x7c, 0x80, 0xc1 );
    FCML_A64( "vfrczps (%rax),%xmm0", 0x8f, 0xe9, 0x78, 0x80, 0x00 );
    FCML_A64( "vfrczps (%rax),%ymm0", 0x8f, 0xe9, 0x7c, 0x80, 0x00 );
}

void fcml_tf_instruction_VFRCZSD(void) {

    FCML_I32( "vfrczsd xmm0,mmword ptr [eax]", 0x8F, 0xE9, 0x78, 0x83, 0x00 );
    FCML_I32( "vfrczsd xmm0,xmm1", 0x8F, 0xE9, 0x78, 0x83, 0xC1 );
    FCML_I64( "vfrczsd xmm0,mmword ptr [rax]", 0x8F, 0xE9, 0x78, 0x83, 0x00 );
    FCML_I64( "vfrczsd xmm0,xmm1", 0x8F, 0xE9, 0x78, 0x83, 0xC1 );

    FCML_A64( "vfrczsd (%rax),%xmm0", 0x8f, 0xe9, 0x78, 0x83, 0x00 );
    FCML_A64( "vfrczsd %xmm1,%xmm0", 0x8f, 0xe9, 0x78, 0x83, 0xc1 );
}

void fcml_tf_instruction_VFRCZSS(void) {

    FCML_I32( "vfrczss xmm0,dword ptr [eax]", 0x8F, 0xE9, 0x78, 0x82, 0x00 );
    FCML_I32( "vfrczss xmm0,xmm1", 0x8F, 0xE9, 0x78, 0x82, 0xC1 );
    FCML_I64( "vfrczss xmm0,dword ptr [rax]", 0x8F, 0xE9, 0x78, 0x82, 0x00 );
    FCML_I64( "vfrczss xmm0,xmm1", 0x8F, 0xE9, 0x78, 0x82, 0xC1 );

    FCML_A64( "vfrczss (%rax),%xmm0", 0x8f, 0xe9, 0x78, 0x82, 0x00 );
    FCML_A64( "vfrczss %xmm1,%xmm0", 0x8f, 0xe9, 0x78, 0x82, 0xc1 );
}

void fcml_tf_instruction_VPCMOV(void) {

    FCML_I64( "vpcmov xmm2,xmm5,xmmword ptr [rcx+rax],xmm2", 0x8F, 0xE8, 0x50, 0xA2, 0x14, 0x01, 0x20 );
    FCML_I64( "vpcmov ymm2,ymm5,ymmword ptr [rcx+rax],ymm2", 0x8F, 0xE8, 0x54, 0xA2, 0x14, 0x01, 0x20 );
    FCML_I64_M( "vpcmov ymm0,ymm5,ymm0,ymm2", 2, FCML_MI( 0x8f, 0xe8, 0xd4, 0xa2, 0xc2, 0x00 ), FCML_MI( 0x8f, 0xe8, 0x54, 0xa2, 0xc0, 0x20 ) );

    FCML_I64( "vpcmov xmm2,xmm5,xmm2,xmmword ptr [rcx+rax]", 0x8F, 0xE8, 0xD0, 0xA2, 0x14, 0x01, 0x20 );
    FCML_I64( "vpcmov ymm2,ymm5,ymm2,ymmword ptr [rcx+rax]", 0x8F, 0xE8, 0xD4, 0xA2, 0x14, 0x01, 0x20 );
    FCML_I64_M( "vpcmov ymm0,ymm5,ymm2,ymm0", 2, FCML_MI( 0x8f, 0xe8, 0xd4, 0xa2, 0xc0, 0x20 ), FCML_MI( 0x8f, 0xe8, 0x54, 0xa2, 0xc2, 0x00 ) );

    FCML_A64( "vpcmov %xmm2,(%rcx,%rax),%xmm5,%xmm2", 0x8f, 0xe8, 0x50, 0xa2, 0x14, 0x01, 0x20 );
    FCML_A64( "vpcmov %ymm2,(%rcx,%rax),%ymm5,%ymm2", 0x8f, 0xe8, 0x54, 0xa2, 0x14, 0x01, 0x20 );
    FCML_A64( "vpcmov (%rcx,%rax),%xmm2,%xmm5,%xmm2", 0x8f, 0xe8, 0xd0, 0xa2, 0x14, 0x01, 0x20 );
    FCML_A64( "vpcmov (%rcx,%rax),%ymm2,%ymm5,%ymm2", 0x8f, 0xe8, 0xd4, 0xa2, 0x14, 0x01, 0x20 );
}

void fcml_tf_instruction_VPCOM(void) {

    FCML_I32( "vpcomb xmm2,xmm5,xmmword ptr [ecx+eax],00h", 0x8F, 0xE8, 0x50, 0xCC, 0x14, 0x01, 0x00 );
    FCML_I64_A_FAILED( "vpcomb xmm0,xmm5,xmm0,20h", 0x8F, 0xE8, 0x50, 0xCC, 0xC0, 0x20 );
    FCML_I32_A( "vpcomltb xmm2,xmm5,xmmword ptr [ecx+eax]", 0x8F, 0xE8, 0x50, 0xCC, 0x14, 0x01, 0x00 );
    FCML_I32_A( "vpcomleb xmm2,xmm5,xmmword ptr [ecx+eax]", 0x8F, 0xE8, 0x50, 0xCC, 0x14, 0x01, 0x01 );
    FCML_I32_A( "vpcomgtb xmm2,xmm5,xmmword ptr [ecx+eax]", 0x8F, 0xE8, 0x50, 0xCC, 0x14, 0x01, 0x02 );
    FCML_I32_A( "vpcomgeb xmm2,xmm5,xmmword ptr [ecx+eax]", 0x8F, 0xE8, 0x50, 0xCC, 0x14, 0x01, 0x03 );
    FCML_I32_A( "vpcomeqb xmm2,xmm5,xmmword ptr [ecx+eax]", 0x8F, 0xE8, 0x50, 0xCC, 0x14, 0x01, 0x04 );
    FCML_I32_A( "vpcomneqb xmm2,xmm5,xmmword ptr [ecx+eax]", 0x8F, 0xE8, 0x50, 0xCC, 0x14, 0x01, 0x05 );
    FCML_I32_A( "vpcomfalseb xmm2,xmm5,xmmword ptr [ecx+eax]", 0x8F, 0xE8, 0x50, 0xCC, 0x14, 0x01, 0x06 );
    FCML_I32_A( "vpcomtrueb xmm2,xmm5,xmmword ptr [ecx+eax]", 0x8F, 0xE8, 0x50, 0xCC, 0x14, 0x01, 0x07 );

    FCML_A64_A( "vpcomltb (%rcx,%rax),%xmm5,%xmm2", 0x8f, 0xe8, 0x50, 0xcc, 0x14, 0x01, 0x00 );
    FCML_A64( "vpcomb $0x00,(%rcx,%rax),%xmm5,%xmm2", 0x8f, 0xe8, 0x50, 0xcc, 0x14, 0x01, 0x00 );
    FCML_A64( "vpcomb $0x01,(%rcx,%rax),%xmm5,%xmm2", 0x8f, 0xe8, 0x50, 0xcc, 0x14, 0x01, 0x01 );
    FCML_A64( "vpcomb $0x02,(%rcx,%rax),%xmm5,%xmm2", 0x8f, 0xe8, 0x50, 0xcc, 0x14, 0x01, 0x02 );

    FCML_I32( "vpcomw xmm2,xmm5,xmmword ptr [ecx+eax],00h", 0x8F, 0xE8, 0x50, 0xCD, 0x14, 0x01, 0x00 );
    FCML_I64_A_FAILED( "vpcomw xmm0,xmm5,xmm0,20h", 0x8F, 0xE8, 0x50, 0xCD, 0xC0, 0x20 );
    FCML_I32_A( "vpcomltw xmm2,xmm5,xmmword ptr [ecx+eax]", 0x8F, 0xE8, 0x50, 0xCD, 0x14, 0x01, 0x00 );
    FCML_I32_A( "vpcomlew xmm2,xmm5,xmmword ptr [ecx+eax]", 0x8F, 0xE8, 0x50, 0xCD, 0x14, 0x01, 0x01 );
    FCML_I32_A( "vpcomgtw xmm2,xmm5,xmmword ptr [ecx+eax]", 0x8F, 0xE8, 0x50, 0xCD, 0x14, 0x01, 0x02 );
    FCML_I32_A( "vpcomgew xmm2,xmm5,xmmword ptr [ecx+eax]", 0x8F, 0xE8, 0x50, 0xCD, 0x14, 0x01, 0x03 );
    FCML_I32_A( "vpcomeqw xmm2,xmm5,xmmword ptr [ecx+eax]", 0x8F, 0xE8, 0x50, 0xCD, 0x14, 0x01, 0x04 );
    FCML_I32_A( "vpcomneqw xmm2,xmm5,xmmword ptr [ecx+eax]", 0x8F, 0xE8, 0x50, 0xCD, 0x14, 0x01, 0x05 );
    FCML_I32_A( "vpcomfalsew xmm2,xmm5,xmmword ptr [ecx+eax]", 0x8F, 0xE8, 0x50, 0xCD, 0x14, 0x01, 0x06 );
    FCML_I32_A( "vpcomtruew xmm2,xmm5,xmmword ptr [ecx+eax]", 0x8F, 0xE8, 0x50, 0xCD, 0x14, 0x01, 0x07 );

    FCML_A64( "vpcomw $0x00,(%rcx,%rax),%xmm5,%xmm2", 0x8f, 0xe8, 0x50, 0xcd, 0x14, 0x01, 0x00 );
    FCML_A64( "vpcomw $0x01,(%rcx,%rax),%xmm5,%xmm2", 0x8f, 0xe8, 0x50, 0xcd, 0x14, 0x01, 0x01 );
    FCML_A64( "vpcomw $0x02,(%rcx,%rax),%xmm5,%xmm2", 0x8f, 0xe8, 0x50, 0xcd, 0x14, 0x01, 0x02 );

    FCML_I32( "vpcomd xmm2,xmm5,xmmword ptr [ecx+eax],00h", 0x8F, 0xE8, 0x50, 0xCE, 0x14, 0x01, 0x00 );
    FCML_I64_A_FAILED( "vpcomd xmm0,xmm5,xmm0,20h", 0x8F, 0xE8, 0x50, 0xCE, 0xC0, 0x20 );
    FCML_I32_A( "vpcomltd xmm2,xmm5,xmmword ptr [ecx+eax]", 0x8F, 0xE8, 0x50, 0xCE, 0x14, 0x01, 0x00 );
    FCML_I32_A( "vpcomled xmm2,xmm5,xmmword ptr [ecx+eax]", 0x8F, 0xE8, 0x50, 0xCE, 0x14, 0x01, 0x01 );
    FCML_I32_A( "vpcomgtd xmm2,xmm5,xmmword ptr [ecx+eax]", 0x8F, 0xE8, 0x50, 0xCE, 0x14, 0x01, 0x02 );
    FCML_I32_A( "vpcomged xmm2,xmm5,xmmword ptr [ecx+eax]", 0x8F, 0xE8, 0x50, 0xCE, 0x14, 0x01, 0x03 );
    FCML_I32_A( "vpcomeqd xmm2,xmm5,xmmword ptr [ecx+eax]", 0x8F, 0xE8, 0x50, 0xCE, 0x14, 0x01, 0x04 );
    FCML_I32_A( "vpcomneqd xmm2,xmm5,xmmword ptr [ecx+eax]", 0x8F, 0xE8, 0x50, 0xCE, 0x14, 0x01, 0x05 );
    FCML_I32_A( "vpcomfalsed xmm2,xmm5,xmmword ptr [ecx+eax]", 0x8F, 0xE8, 0x50, 0xCE, 0x14, 0x01, 0x06 );
    FCML_I32_A( "vpcomtrued xmm2,xmm5,xmmword ptr [ecx+eax]", 0x8F, 0xE8, 0x50, 0xCE, 0x14, 0x01, 0x07 );

    FCML_A64( "vpcomd $0x00,(%rcx,%rax),%xmm5,%xmm2", 0x8f, 0xe8, 0x50, 0xce, 0x14, 0x01, 0x00 );
    FCML_A64( "vpcomd $0x01,(%rcx,%rax),%xmm5,%xmm2", 0x8f, 0xe8, 0x50, 0xce, 0x14, 0x01, 0x01 );
    FCML_A64( "vpcomd $0x02,(%rcx,%rax),%xmm5,%xmm2", 0x8f, 0xe8, 0x50, 0xce, 0x14, 0x01, 0x02 );

    FCML_I32( "vpcomq xmm2,xmm5,xmmword ptr [ecx+eax],00h", 0x8F, 0xE8, 0x50, 0xCF, 0x14, 0x01, 0x00 );
    FCML_I64_A_FAILED( "vpcomq xmm0,xmm5,xmm0,20h", 0x8F, 0xE8, 0x50, 0xCF, 0xC0, 0x20 );
    FCML_I32_A( "vpcomltq xmm2,xmm5,xmmword ptr [ecx+eax]", 0x8F, 0xE8, 0x50, 0xCF, 0x14, 0x01, 0x00 );
    FCML_I32_A( "vpcomleq xmm2,xmm5,xmmword ptr [ecx+eax]", 0x8F, 0xE8, 0x50, 0xCF, 0x14, 0x01, 0x01 );
    FCML_I32_A( "vpcomgtq xmm2,xmm5,xmmword ptr [ecx+eax]", 0x8F, 0xE8, 0x50, 0xCF, 0x14, 0x01, 0x02 );
    FCML_I32_A( "vpcomgeq xmm2,xmm5,xmmword ptr [ecx+eax]", 0x8F, 0xE8, 0x50, 0xCF, 0x14, 0x01, 0x03 );
    FCML_I32_A( "vpcomeqq xmm2,xmm5,xmmword ptr [ecx+eax]", 0x8F, 0xE8, 0x50, 0xCF, 0x14, 0x01, 0x04 );
    FCML_I32_A( "vpcomneqq xmm2,xmm5,xmmword ptr [ecx+eax]", 0x8F, 0xE8, 0x50, 0xCF, 0x14, 0x01, 0x05 );
    FCML_I32_A( "vpcomfalseq xmm2,xmm5,xmmword ptr [ecx+eax]", 0x8F, 0xE8, 0x50, 0xCF, 0x14, 0x01, 0x06 );
    FCML_I32_A( "vpcomtrueq xmm2,xmm5,xmmword ptr [ecx+eax]", 0x8F, 0xE8, 0x50, 0xCF, 0x14, 0x01, 0x07 );

    FCML_A64( "vpcomq $0x00,(%rcx,%rax),%xmm5,%xmm2", 0x8f, 0xe8, 0x50, 0xcf, 0x14, 0x01, 0x00 );
    FCML_A64( "vpcomq $0x01,(%rcx,%rax),%xmm5,%xmm2", 0x8f, 0xe8, 0x50, 0xcf, 0x14, 0x01, 0x01 );
    FCML_A64( "vpcomq $0x02,(%rcx,%rax),%xmm5,%xmm2", 0x8f, 0xe8, 0x50, 0xcf, 0x14, 0x01, 0x02 );
}

void fcml_tf_instruction_VPCOMU(void) {

    FCML_I32( "vpcomub xmm2,xmm5,xmmword ptr [ecx+eax],00h", 0x8F, 0xE8, 0x50, 0xEC, 0x14, 0x01, 0x00 );
    FCML_I64_A_FAILED( "vpcomub xmm0,xmm5,xmm0,20h", 0x8F, 0xE8, 0x50, 0xEC, 0xC0, 0x20 );
    FCML_I32_A( "vpcomltub xmm2,xmm5,xmmword ptr [ecx+eax]", 0x8F, 0xE8, 0x50, 0xEC, 0x14, 0x01, 0x00 );
    FCML_I32_A( "vpcomleub xmm2,xmm5,xmmword ptr [ecx+eax]", 0x8F, 0xE8, 0x50, 0xEC, 0x14, 0x01, 0x01 );
    FCML_I32_A( "vpcomgtub xmm2,xmm5,xmmword ptr [ecx+eax]", 0x8F, 0xE8, 0x50, 0xEC, 0x14, 0x01, 0x02 );
    FCML_I32_A( "vpcomgeub xmm2,xmm5,xmmword ptr [ecx+eax]", 0x8F, 0xE8, 0x50, 0xEC, 0x14, 0x01, 0x03 );
    FCML_I32_A( "vpcomequb xmm2,xmm5,xmmword ptr [ecx+eax]", 0x8F, 0xE8, 0x50, 0xEC, 0x14, 0x01, 0x04 );
    FCML_I32_A( "vpcomnequb xmm2,xmm5,xmmword ptr [ecx+eax]", 0x8F, 0xE8, 0x50, 0xEC, 0x14, 0x01, 0x05 );
    FCML_I32_A( "vpcomfalseub xmm2,xmm5,xmmword ptr [ecx+eax]", 0x8F, 0xE8, 0x50, 0xEC, 0x14, 0x01, 0x06 );
    FCML_I32_A( "vpcomtrueub xmm2,xmm5,xmmword ptr [ecx+eax]", 0x8F, 0xE8, 0x50, 0xEC, 0x14, 0x01, 0x07 );

    FCML_A64( "vpcomub $0x00,(%rcx,%rax),%xmm5,%xmm2", 0x8f, 0xe8, 0x50, 0xec, 0x14, 0x01, 0x00 );
    FCML_A64( "vpcomub $0x01,(%rcx,%rax),%xmm5,%xmm2", 0x8f, 0xe8, 0x50, 0xec, 0x14, 0x01, 0x01 );
    FCML_A64( "vpcomub $0x02,(%rcx,%rax),%xmm5,%xmm2", 0x8f, 0xe8, 0x50, 0xec, 0x14, 0x01, 0x02 );
    FCML_A64( "vpcomub $0x03,(%rcx,%rax),%xmm5,%xmm2", 0x8f, 0xe8, 0x50, 0xec, 0x14, 0x01, 0x03 );

    FCML_I32( "vpcomud xmm2,xmm5,xmmword ptr [ecx+eax],00h", 0x8F, 0xE8, 0x50, 0xEE, 0x14, 0x01, 0x00 );
    FCML_I64_A_FAILED( "vpcomud xmm0,xmm5,xmm0,20h", 0x8F, 0xE8, 0x50, 0xEE, 0xC0, 0x20 );
    FCML_I32_A( "vpcomltud xmm2,xmm5,xmmword ptr [ecx+eax]", 0x8F, 0xE8, 0x50, 0xEE, 0x14, 0x01, 0x00 );
    FCML_I32_A( "vpcomleud xmm2,xmm5,xmmword ptr [ecx+eax]", 0x8F, 0xE8, 0x50, 0xEE, 0x14, 0x01, 0x01 );
    FCML_I32_A( "vpcomgtud xmm2,xmm5,xmmword ptr [ecx+eax]", 0x8F, 0xE8, 0x50, 0xEE, 0x14, 0x01, 0x02 );
    FCML_I32_A( "vpcomgeud xmm2,xmm5,xmmword ptr [ecx+eax]", 0x8F, 0xE8, 0x50, 0xEE, 0x14, 0x01, 0x03 );
    FCML_I32_A( "vpcomequd xmm2,xmm5,xmmword ptr [ecx+eax]", 0x8F, 0xE8, 0x50, 0xEE, 0x14, 0x01, 0x04 );
    FCML_I32_A( "vpcomnequd xmm2,xmm5,xmmword ptr [ecx+eax]", 0x8F, 0xE8, 0x50, 0xEE, 0x14, 0x01, 0x05 );
    FCML_I32_A( "vpcomfalseud xmm2,xmm5,xmmword ptr [ecx+eax]", 0x8F, 0xE8, 0x50, 0xEE, 0x14, 0x01, 0x06 );
    FCML_I32_A( "vpcomtrueud xmm2,xmm5,xmmword ptr [ecx+eax]", 0x8F, 0xE8, 0x50, 0xEE, 0x14, 0x01, 0x07 );

    FCML_A64( "vpcomud $0x00,(%rcx,%rax),%xmm5,%xmm2", 0x8f, 0xe8, 0x50, 0xee, 0x14, 0x01, 0x00 );
    FCML_A64( "vpcomud $0x01,(%rcx,%rax),%xmm5,%xmm2", 0x8f, 0xe8, 0x50, 0xee, 0x14, 0x01, 0x01 );
    FCML_A64( "vpcomud $0x02,(%rcx,%rax),%xmm5,%xmm2", 0x8f, 0xe8, 0x50, 0xee, 0x14, 0x01, 0x02 );
    FCML_A64( "vpcomud $0x03,(%rcx,%rax),%xmm5,%xmm2", 0x8f, 0xe8, 0x50, 0xee, 0x14, 0x01, 0x03 );

    FCML_I32( "vpcomuq xmm2,xmm5,xmmword ptr [ecx+eax],00h", 0x8F, 0xE8, 0x50, 0xEF, 0x14, 0x01, 0x00 );
    FCML_I64_A_FAILED( "vpcomuq xmm0,xmm5,xmm0,20h", 0x8F, 0xE8, 0x50, 0xEF, 0xC0, 0x20 );
    FCML_I32_A( "vpcomltuq xmm2,xmm5,xmmword ptr [ecx+eax]", 0x8F, 0xE8, 0x50, 0xEF, 0x14, 0x01, 0x00 );
    FCML_I32_A( "vpcomleuq xmm2,xmm5,xmmword ptr [ecx+eax]", 0x8F, 0xE8, 0x50, 0xEF, 0x14, 0x01, 0x01 );
    FCML_I32_A( "vpcomgtuq xmm2,xmm5,xmmword ptr [ecx+eax]", 0x8F, 0xE8, 0x50, 0xEF, 0x14, 0x01, 0x02 );
    FCML_I32_A( "vpcomgeuq xmm2,xmm5,xmmword ptr [ecx+eax]", 0x8F, 0xE8, 0x50, 0xEF, 0x14, 0x01, 0x03 );
    FCML_I32_A( "vpcomequq xmm2,xmm5,xmmword ptr [ecx+eax]", 0x8F, 0xE8, 0x50, 0xEF, 0x14, 0x01, 0x04 );
    FCML_I32_A( "vpcomnequq xmm2,xmm5,xmmword ptr [ecx+eax]", 0x8F, 0xE8, 0x50, 0xEF, 0x14, 0x01, 0x05 );
    FCML_I32_A( "vpcomfalseuq xmm2,xmm5,xmmword ptr [ecx+eax]", 0x8F, 0xE8, 0x50, 0xEF, 0x14, 0x01, 0x06 );
    FCML_I32_A( "vpcomtrueuq xmm2,xmm5,xmmword ptr [ecx+eax]", 0x8F, 0xE8, 0x50, 0xEF, 0x14, 0x01, 0x07 );

    FCML_A64( "vpcomuq $0x00,(%rcx,%rax),%xmm5,%xmm2", 0x8f, 0xe8, 0x50, 0xef, 0x14, 0x01, 0x00 );
    FCML_A64( "vpcomuq $0x01,(%rcx,%rax),%xmm5,%xmm2", 0x8f, 0xe8, 0x50, 0xef, 0x14, 0x01, 0x01 );
    FCML_A64( "vpcomuq $0x02,(%rcx,%rax),%xmm5,%xmm2", 0x8f, 0xe8, 0x50, 0xef, 0x14, 0x01, 0x02 );
    FCML_A64( "vpcomuq $0x03,(%rcx,%rax),%xmm5,%xmm2", 0x8f, 0xe8, 0x50, 0xef, 0x14, 0x01, 0x03 );

    FCML_I32( "vpcomuw xmm2,xmm5,xmmword ptr [ecx+eax],00h", 0x8F, 0xE8, 0x50, 0xED, 0x14, 0x01, 0x00 );
    FCML_I64_A_FAILED( "vpcomuw xmm0,xmm5,xmm0,20h", 0x8F, 0xE8, 0x50, 0xED, 0xC0, 0x20 );
    FCML_I32_A( "vpcomltuw xmm2,xmm5,xmmword ptr [ecx+eax]", 0x8F, 0xE8, 0x50, 0xED, 0x14, 0x01, 0x00 );
    FCML_I32_A( "vpcomleuw xmm2,xmm5,xmmword ptr [ecx+eax]", 0x8F, 0xE8, 0x50, 0xED, 0x14, 0x01, 0x01 );
    FCML_I32_A( "vpcomgtuw xmm2,xmm5,xmmword ptr [ecx+eax]", 0x8F, 0xE8, 0x50, 0xED, 0x14, 0x01, 0x02 );
    FCML_I32_A( "vpcomgeuw xmm2,xmm5,xmmword ptr [ecx+eax]", 0x8F, 0xE8, 0x50, 0xED, 0x14, 0x01, 0x03 );
    FCML_I32_A( "vpcomequw xmm2,xmm5,xmmword ptr [ecx+eax]", 0x8F, 0xE8, 0x50, 0xED, 0x14, 0x01, 0x04 );
    FCML_I32_A( "vpcomnequw xmm2,xmm5,xmmword ptr [ecx+eax]", 0x8F, 0xE8, 0x50, 0xED, 0x14, 0x01, 0x05 );
    FCML_I32_A( "vpcomfalseuw xmm2,xmm5,xmmword ptr [ecx+eax]", 0x8F, 0xE8, 0x50, 0xED, 0x14, 0x01, 0x06 );
    FCML_I32_A( "vpcomtrueuw xmm2,xmm5,xmmword ptr [ecx+eax]", 0x8F, 0xE8, 0x50, 0xED, 0x14, 0x01, 0x07 );

    FCML_A64( "vpcomuw $0x00,(%rcx,%rax),%xmm5,%xmm2", 0x8f, 0xe8, 0x50, 0xed, 0x14, 0x01, 0x00 );
    FCML_A64( "vpcomuw $0x01,(%rcx,%rax),%xmm5,%xmm2", 0x8f, 0xe8, 0x50, 0xed, 0x14, 0x01, 0x01 );
    FCML_A64( "vpcomuw $0x02,(%rcx,%rax),%xmm5,%xmm2", 0x8f, 0xe8, 0x50, 0xed, 0x14, 0x01, 0x02 );
    FCML_A64( "vpcomuw $0x03,(%rcx,%rax),%xmm5,%xmm2", 0x8f, 0xe8, 0x50, 0xed, 0x14, 0x01, 0x03 );
}

void fcml_tf_instruction_VPHADDBD(void) {

    FCML_I32( "vphaddbd xmm0,xmmword ptr [eax]", 0x8F, 0xE9, 0x78, 0xC2, 0x00 );
    FCML_I32( "vphaddbd xmm0,xmm1", 0x8F, 0xE9, 0x78, 0xC2, 0xC1 );

    FCML_A64( "vphaddbd (%rax),%xmm0", 0x8f, 0xe9, 0x78, 0xc2, 0x00 );
    FCML_A64( "vphaddbd %xmm1,%xmm0", 0x8f, 0xe9, 0x78, 0xc2, 0xc1 );
}

void fcml_tf_instruction_VPHADDBW(void) {

    FCML_I32( "vphaddbw xmm0,xmmword ptr [eax]", 0x8F, 0xE9, 0x78, 0xC1, 0x00 );
    FCML_I32( "vphaddbw xmm0,xmm1", 0x8F, 0xE9, 0x78, 0xC1, 0xC1 );

    FCML_A64( "vphaddbw (%rax),%xmm0", 0x8f, 0xe9, 0x78, 0xc1, 0x00 );
    FCML_A64( "vphaddbw %xmm1,%xmm0", 0x8f, 0xe9, 0x78, 0xc1, 0xc1 );
}

void fcml_tf_instruction_VPHADDBQ(void) {

    FCML_I32( "vphaddbq xmm0,xmmword ptr [eax]", 0x8F, 0xE9, 0x78, 0xC3, 0x00 );
    FCML_I32( "vphaddbq xmm0,xmm1", 0x8F, 0xE9, 0x78, 0xC3, 0xC1 );

    FCML_A64( "vphaddbq (%rax),%xmm0", 0x8f, 0xe9, 0x78, 0xc3, 0x00 );
    FCML_A64( "vphaddbq %xmm1,%xmm0", 0x8f, 0xe9, 0x78, 0xc3, 0xc1 );
}

void fcml_tf_instruction_VPHADDDQ(void) {

    FCML_I32( "vphadddq xmm0,xmmword ptr [eax]", 0x8F, 0xE9, 0x78, 0xCB, 0x00 );
    FCML_I32( "vphadddq xmm0,xmm1", 0x8F, 0xE9, 0x78, 0xCB, 0xC1 );

    FCML_A64( "vphadddq (%rax),%xmm0", 0x8f, 0xe9, 0x78, 0xcb, 0x00 );
    FCML_A64( "vphadddq %xmm1,%xmm0", 0x8f, 0xe9, 0x78, 0xcb, 0xc1 );
}

void fcml_tf_instruction_VPHADDUBD(void) {

    FCML_I32( "vphaddubd xmm0,xmmword ptr [eax]", 0x8F, 0xE9, 0x78, 0xD2, 0x00 );
    FCML_I32( "vphaddubd xmm0,xmm1", 0x8F, 0xE9, 0x78, 0xD2, 0xC1 );

    FCML_A64( "vphaddubd (%rax),%xmm0", 0x8f, 0xe9, 0x78, 0xd2, 0x00 );
    FCML_A64( "vphaddubd %xmm1,%xmm0", 0x8f, 0xe9, 0x78, 0xd2, 0xc1 );
}

void fcml_tf_instruction_VPHADDUBQ(void) {

    FCML_I32( "vphaddubq xmm0,xmmword ptr [eax]", 0x8F, 0xE9, 0x78, 0xD3, 0x00 );
    FCML_I32( "vphaddubq xmm0,xmm1", 0x8F, 0xE9, 0x78, 0xD3, 0xC1 );

    FCML_A64( "vphaddubq (%rax),%xmm0", 0x8f, 0xe9, 0x78, 0xd3, 0x00 );
    FCML_A64( "vphaddubq %xmm1,%xmm0", 0x8f, 0xe9, 0x78, 0xd3, 0xc1 );
}

void fcml_tf_instruction_VPHADDUBW(void) {

    FCML_I32( "vphaddubw xmm0,xmmword ptr [eax]", 0x8F, 0xE9, 0x78, 0xD1, 0x00 );
    FCML_I32( "vphaddubw xmm0,xmm1", 0x8F, 0xE9, 0x78, 0xD1, 0xC1 );

    FCML_A64( "vphaddubw (%rax),%xmm0", 0x8f, 0xe9, 0x78, 0xd1, 0x00 );
    FCML_A64( "vphaddubw %xmm1,%xmm0", 0x8f, 0xe9, 0x78, 0xd1, 0xc1 );
}

void fcml_tf_instruction_VPHADDUDQ(void) {

    FCML_I32( "vphaddudq xmm0,xmmword ptr [eax]", 0x8F, 0xE9, 0x78, 0xDB, 0x00 );
    FCML_I32( "vphaddudq xmm0,xmm1", 0x8F, 0xE9, 0x78, 0xDB, 0xC1 );

    FCML_A64( "vphaddudq (%rax),%xmm0", 0x8f, 0xe9, 0x78, 0xdb, 0x00 );
    FCML_A64( "vphaddudq %xmm1,%xmm0", 0x8f, 0xe9, 0x78, 0xdb, 0xc1 );
}

void fcml_tf_instruction_VPHADDUWD(void) {

    FCML_I32( "vphadduwd xmm0,xmmword ptr [eax]", 0x8F, 0xE9, 0x78, 0xD6, 0x00 );
    FCML_I32( "vphadduwd xmm0,xmm1", 0x8F, 0xE9, 0x78, 0xD6, 0xC1 );

    FCML_A64( "vphadduwd (%rax),%xmm0", 0x8f, 0xe9, 0x78, 0xd6, 0x00 );
    FCML_A64( "vphadduwd %xmm1,%xmm0", 0x8f, 0xe9, 0x78, 0xd6, 0xc1 );
}

void fcml_tf_instruction_VPHADDUWQ(void) {

    FCML_I32( "vphadduwq xmm0,xmmword ptr [eax]", 0x8F, 0xE9, 0x78, 0xD7, 0x00 );
    FCML_I32( "vphadduwq xmm0,xmm1", 0x8F, 0xE9, 0x78, 0xD7, 0xC1 );

    FCML_A64( "vphadduwq (%rax),%xmm0", 0x8f, 0xe9, 0x78, 0xd7, 0x00 );
    FCML_A64( "vphadduwq %xmm1,%xmm0", 0x8f, 0xe9, 0x78, 0xd7, 0xc1 );
}

void fcml_tf_instruction_VPHADDWD(void) {

    FCML_I32( "vphaddwd xmm0,xmmword ptr [eax]", 0x8F, 0xE9, 0x78, 0xC6, 0x00 );
    FCML_I32( "vphaddwd xmm0,xmm1", 0x8F, 0xE9, 0x78, 0xC6, 0xC1 );

    FCML_A64( "vphaddwd (%rax),%xmm0", 0x8f, 0xe9, 0x78, 0xc6, 0x00 );
    FCML_A64( "vphaddwd %xmm1,%xmm0", 0x8f, 0xe9, 0x78, 0xc6, 0xc1 );
}

void fcml_tf_instruction_VPHADDWQ(void) {

    FCML_I32( "vphaddwq xmm0,xmmword ptr [eax]", 0x8F, 0xE9, 0x78, 0xC7, 0x00 );
    FCML_I32( "vphaddwq xmm0,xmm1", 0x8F, 0xE9, 0x78, 0xC7, 0xC1 );

    FCML_A64( "vphaddwq (%rax),%xmm0", 0x8f, 0xe9, 0x78, 0xc7, 0x00 );
    FCML_A64( "vphaddwq %xmm1,%xmm0", 0x8f, 0xe9, 0x78, 0xc7, 0xc1 );
}

void fcml_tf_instruction_VPHSUBBW(void) {

    FCML_I32( "vphsubbw xmm0,xmmword ptr [eax]", 0x8F, 0xE9, 0x78, 0xE1, 0x00 );
    FCML_I32( "vphsubbw xmm0,xmm1", 0x8F, 0xE9, 0x78, 0xE1, 0xC1 );

    FCML_A64( "vphsubbw (%rax),%xmm0", 0x8f, 0xe9, 0x78, 0xe1, 0x00 );
    FCML_A64( "vphsubbw %xmm1,%xmm0", 0x8f, 0xe9, 0x78, 0xe1, 0xc1 );
}

void fcml_tf_instruction_VPHSUBDQ(void) {

    FCML_I32( "vphsubdq xmm0,xmmword ptr [eax]", 0x8F, 0xE9, 0x78, 0xE3, 0x00 );
    FCML_I32( "vphsubdq xmm0,xmm1", 0x8F, 0xE9, 0x78, 0xE3, 0xC1 );

    FCML_A64( "vphsubdq (%rax),%xmm0", 0x8f, 0xe9, 0x78, 0xe3, 0x00 );
    FCML_A64( "vphsubdq %xmm1,%xmm0", 0x8f, 0xe9, 0x78, 0xe3, 0xc1 );
}

void fcml_tf_instruction_VPHSUBWD(void) {

    FCML_I32( "vphsubwd xmm0,xmmword ptr [eax]", 0x8F, 0xE9, 0x78, 0xE2, 0x00 );
    FCML_I32( "vphsubwd xmm0,xmm1", 0x8F, 0xE9, 0x78, 0xE2, 0xC1 );

    FCML_A64( "vphsubwd (%rax),%xmm0", 0x8f, 0xe9, 0x78, 0xe2, 0x00 );
    FCML_A64( "vphsubwd %xmm1,%xmm0", 0x8f, 0xe9, 0x78, 0xe2, 0xc1 );
}

void fcml_tf_instruction_VPMACSDD(void) {

    FCML_I32( "vpmacsdd xmm2,xmm5,xmmword ptr [ecx+eax],xmm2", 0x8F, 0xE8, 0x50, 0x9E, 0x14, 0x01, 0x20 );
    FCML_I64( "vpmacsdd xmm0,xmm5,xmm0,xmm2", 0x8F, 0xE8, 0x50, 0x9E, 0xC0, 0x20 );

    FCML_A64( "vpmacsdd %xmm2,(%rcx,%rax),%xmm5,%xmm2", 0x8f, 0xe8, 0x50, 0x9e, 0x14, 0x01, 0x20 );
    FCML_A64( "vpmacsdd %xmm2,%xmm0,%xmm5,%xmm0", 0x8f, 0xe8, 0x50, 0x9e, 0xc0, 0x20 );
}

void fcml_tf_instruction_VPMACSDQH(void) {

    FCML_I32( "vpmacsdqh xmm2,xmm5,xmmword ptr [ecx+eax],xmm2", 0x8F, 0xE8, 0x50, 0x9F, 0x14, 0x01, 0x20 );
    FCML_I64( "vpmacsdqh xmm0,xmm5,xmm0,xmm2", 0x8F, 0xE8, 0x50, 0x9F, 0xC0, 0x20 );

    FCML_A64( "vpmacsdqh %xmm2,(%rcx,%rax),%xmm5,%xmm2", 0x8f, 0xe8, 0x50, 0x9f, 0x14, 0x01, 0x20 );
    FCML_A64( "vpmacsdqh %xmm2,%xmm0,%xmm5,%xmm0", 0x8f, 0xe8, 0x50, 0x9f, 0xc0, 0x20 );
}

void fcml_tf_instruction_VPMACSDQL(void) {

    FCML_I32( "vpmacsdql xmm2,xmm5,xmmword ptr [ecx+eax],xmm2", 0x8F, 0xE8, 0x50, 0x97, 0x14, 0x01, 0x20 );
    FCML_I64( "vpmacsdql xmm0,xmm5,xmm0,xmm2", 0x8F, 0xE8, 0x50, 0x97, 0xC0, 0x20 );

    FCML_A64( "vpmacsdql %xmm2,(%rcx,%rax),%xmm5,%xmm2", 0x8f, 0xe8, 0x50, 0x97, 0x14, 0x01, 0x20 );
    FCML_A64( "vpmacsdql %xmm2,%xmm0,%xmm5,%xmm0", 0x8f, 0xe8, 0x50, 0x97, 0xc0, 0x20 );
}

void fcml_tf_instruction_VPMACSSDD(void) {

    FCML_I32( "vpmacssdd xmm2,xmm5,xmmword ptr [ecx+eax],xmm2", 0x8F, 0xE8, 0x50, 0x8E, 0x14, 0x01, 0x20 );
    FCML_I64( "vpmacssdd xmm0,xmm5,xmm0,xmm2", 0x8F, 0xE8, 0x50, 0x8E, 0xC0, 0x20 );

    FCML_A64( "vpmacssdd %xmm2,(%rcx,%rax),%xmm5,%xmm2", 0x8f, 0xe8, 0x50, 0x8e, 0x14, 0x01, 0x20 );
    FCML_A64( "vpmacssdd %xmm2,%xmm0,%xmm5,%xmm0", 0x8f, 0xe8, 0x50, 0x8e, 0xc0, 0x20 );
}

void fcml_tf_instruction_VPMACSSDQH(void) {

    FCML_I32( "vpmacssdqh xmm2,xmm5,xmmword ptr [ecx+eax],xmm2", 0x8F, 0xE8, 0x50, 0x8F, 0x14, 0x01, 0x20 );
    FCML_I64( "vpmacssdqh xmm0,xmm5,xmm0,xmm2", 0x8F, 0xE8, 0x50, 0x8F, 0xC0, 0x20 );

    FCML_A64( "vpmacssdqh %xmm2,(%rcx,%rax),%xmm5,%xmm2", 0x8f, 0xe8, 0x50, 0x8f, 0x14, 0x01, 0x20 );
    FCML_A64( "vpmacssdqh %xmm2,%xmm0,%xmm5,%xmm0", 0x8f, 0xe8, 0x50, 0x8f, 0xc0, 0x20 );
}

void fcml_tf_instruction_VPMACSSDQL(void) {

    FCML_I32( "vpmacssdql xmm2,xmm5,xmmword ptr [ecx+eax],xmm2", 0x8F, 0xE8, 0x50, 0x87, 0x14, 0x01, 0x20 );
    FCML_I64( "vpmacssdql xmm0,xmm5,xmm0,xmm2", 0x8F, 0xE8, 0x50, 0x87, 0xC0, 0x20 );

    FCML_A64( "vpmacssdql %xmm2,(%rcx,%rax),%xmm5,%xmm2", 0x8f, 0xe8, 0x50, 0x87, 0x14, 0x01, 0x20 );
    FCML_A64( "vpmacssdql %xmm2,%xmm0,%xmm5,%xmm0", 0x8f, 0xe8, 0x50, 0x87, 0xc0, 0x20 );
}

void fcml_tf_instruction_VPMACSSWD(void) {

    FCML_I32( "vpmacsswd xmm2,xmm5,xmmword ptr [ecx+eax],xmm2", 0x8F, 0xE8, 0x50, 0x86, 0x14, 0x01, 0x20 );
    FCML_I64( "vpmacsswd xmm0,xmm5,xmm0,xmm2", 0x8F, 0xE8, 0x50, 0x86, 0xC0, 0x20 );

    FCML_A64( "vpmacsswd %xmm2,(%rcx,%rax),%xmm5,%xmm2", 0x8f, 0xe8, 0x50, 0x86, 0x14, 0x01, 0x20 );
    FCML_A64( "vpmacsswd %xmm2,%xmm0,%xmm5,%xmm0", 0x8f, 0xe8, 0x50, 0x86, 0xc0, 0x20 );
}

void fcml_tf_instruction_VPMACSSWW(void) {

    FCML_I32( "vpmacssww xmm2,xmm5,xmmword ptr [ecx+eax],xmm2", 0x8F, 0xE8, 0x50, 0x85, 0x14, 0x01, 0x20 );
    FCML_I64( "vpmacssww xmm0,xmm5,xmm0,xmm2", 0x8F, 0xE8, 0x50, 0x85, 0xC0, 0x20 );

    FCML_A64( "vpmacssww %xmm2,(%rcx,%rax),%xmm5,%xmm2", 0x8f, 0xe8, 0x50, 0x85, 0x14, 0x01, 0x20 );
    FCML_A64( "vpmacssww %xmm2,%xmm0,%xmm5,%xmm0", 0x8f, 0xe8, 0x50, 0x85, 0xc0, 0x20 );
}

void fcml_tf_instruction_VPMACSWD(void) {

    FCML_I32( "vpmacswd xmm2,xmm5,xmmword ptr [ecx+eax],xmm2", 0x8F, 0xE8, 0x50, 0x96, 0x14, 0x01, 0x20 );
    FCML_I64( "vpmacswd xmm0,xmm5,xmm0,xmm2", 0x8F, 0xE8, 0x50, 0x96, 0xC0, 0x20 );

    FCML_A64( "vpmacswd %xmm2,(%rcx,%rax),%xmm5,%xmm2", 0x8f, 0xe8, 0x50, 0x96, 0x14, 0x01, 0x20 );
    FCML_A64( "vpmacswd %xmm2,%xmm0,%xmm5,%xmm0", 0x8f, 0xe8, 0x50, 0x96, 0xc0, 0x20 );
}

void fcml_tf_instruction_VPMACSWW(void) {

    FCML_I32( "vpmacsww xmm2,xmm5,xmmword ptr [ecx+eax],xmm2", 0x8F, 0xE8, 0x50, 0x95, 0x14, 0x01, 0x20 );
    FCML_I64( "vpmacsww xmm0,xmm5,xmm0,xmm2", 0x8F, 0xE8, 0x50, 0x95, 0xC0, 0x20 );

    FCML_A64( "vpmacsww %xmm2,(%rcx,%rax),%xmm5,%xmm2", 0x8f, 0xe8, 0x50, 0x95, 0x14, 0x01, 0x20 );
    FCML_A64( "vpmacsww %xmm2,%xmm0,%xmm5,%xmm0", 0x8f, 0xe8, 0x50, 0x95, 0xc0, 0x20 );
}

void fcml_tf_instruction_VPMADCSSWD(void) {

    FCML_I32( "vpmadcsswd xmm2,xmm5,xmmword ptr [ecx+eax],xmm2", 0x8F, 0xE8, 0x50, 0xA6, 0x14, 0x01, 0x20 );
    FCML_I64( "vpmadcsswd xmm0,xmm5,xmm0,xmm2", 0x8F, 0xE8, 0x50, 0xA6, 0xC0, 0x20 );

    FCML_I32( "vpmadcsswd xmm2,xmm5,xmmword ptr [ecx+eax],xmm2", 0x8F, 0xE8, 0x50, 0xA6, 0x14, 0x01, 0x20 );
    FCML_I64( "vpmadcsswd xmm0,xmm5,xmm0,xmm2", 0x8F, 0xE8, 0x50, 0xA6, 0xC0, 0x20 );
}

void fcml_tf_instruction_VPMADCSWD(void) {

    FCML_I32( "vpmadcswd xmm2,xmm5,xmmword ptr [ecx+eax],xmm2", 0x8F, 0xE8, 0x50, 0xB6, 0x14, 0x01, 0x20 );
    FCML_I64( "vpmadcswd xmm0,xmm5,xmm0,xmm2", 0x8F, 0xE8, 0x50, 0xB6, 0xC0, 0x20 );

    FCML_A64( "vpmadcswd %xmm2,(%rcx,%rax),%xmm5,%xmm2", 0x8f, 0xe8, 0x50, 0xb6, 0x14, 0x01, 0x20 );
    FCML_A64( "vpmadcswd %xmm2,%xmm0,%xmm5,%xmm0", 0x8f, 0xe8, 0x50, 0xb6, 0xc0, 0x20 );
}

void fcml_tf_instruction_VPPERM(void) {

    FCML_I32( "vpperm xmm2,xmm5,xmmword ptr [ecx+eax],xmm2", 0x8F, 0xE8, 0x50, 0xA3, 0x14, 0x01, 0x20 );
    FCML_I64_M( "vpperm xmm0,xmm5,xmm0,xmm2", 2, FCML_MI( 0x8f, 0xe8, 0xd0, 0xa3, 0xc2, 0x00 ), FCML_MI( 0x8f, 0xe8, 0x50, 0xa3, 0xc0, 0x20 ) );

    FCML_I64( "vpperm xmm2,xmm5,xmm2,xmmword ptr [rcx+rax]", 0x8F, 0xE8, 0xD0, 0xA3, 0x14, 0x01, 0x20 );
    FCML_I64_M( "vpperm xmm0,xmm5,xmm2,xmm0", 2, FCML_MI( 0x8f, 0xe8, 0xd0, 0xa3, 0xc0, 0x20 ), FCML_MI( 0x8f, 0xe8, 0x50, 0xa3, 0xc2, 0x00 ) );

    FCML_A64( "vpperm %xmm2,(%rcx,%rax),%xmm5,%xmm2", 0x8f, 0xe8, 0x50, 0xa3, 0x14, 0x01, 0x20 );
    FCML_A64( "vpperm (%rcx,%rax),%xmm2,%xmm5,%xmm2", 0x8f, 0xe8, 0xd0, 0xa3, 0x14, 0x01, 0x20 );
}

void fcml_tf_instruction_VPROTD(void) {

    FCML_I64( "vprotd xmm2,xmmword ptr [rcx+rax],xmm5", 0x8F, 0xE9, 0x50, 0x92, 0x14, 0x01 );
    FCML_I64_M( "vprotd xmm0,xmm0,xmm5", 2, FCML_MI( 0x8f, 0xe9, 0xf8, 0x92, 0xc5 ), FCML_MI( 0x8f, 0xe9, 0x50, 0x92, 0xc0 ) );

    FCML_I64( "vprotd xmm2,xmm5,xmmword ptr [rcx+rax]", 0x8F, 0xE9, 0xD0, 0x92, 0x14, 0x01 );
    FCML_I64_M( "vprotd xmm0,xmm5,xmm0", 2, FCML_MI( 0x8f, 0xe9, 0xd0, 0x92, 0xc0 ), FCML_MI( 0x8f, 0xe9, 0x78, 0x92, 0xc5 ) );

    FCML_I32( "vprotd xmm2,xmmword ptr [ecx+eax],20h", 0x8F, 0xE8, 0x78, 0xC2, 0x14, 0x01, 0x20 );
    FCML_I64( "vprotd xmm0,xmm0,20h", 0x8F, 0xE8, 0x78, 0xC2, 0xC0, 0x20 );

    FCML_A64( "vprotd %xmm5,(%rcx,%rax),%xmm2", 0x8f, 0xe9, 0x50, 0x92, 0x14, 0x01 );
    FCML_A64( "vprotd (%rcx,%rax),%xmm5,%xmm2", 0x8f, 0xe9, 0xd0, 0x92, 0x14, 0x01 );
    FCML_A64( "vprotd $0x20,(%rcx,%rax),%xmm2", 0x8f, 0xe8, 0x78, 0xc2, 0x14, 0x01, 0x20 );
    FCML_A64( "vprotd $0x20,%xmm0,%xmm0", 0x8f, 0xe8, 0x78, 0xc2, 0xc0, 0x20 );
}

void fcml_tf_instruction_VPROTB(void) {

    FCML_I32( "vprotb xmm2,xmmword ptr [ecx+eax],xmm5", 0x8F, 0xE9, 0x50, 0x90, 0x14, 0x01 );
    FCML_I64_M( "vprotb xmm0,xmm0,xmm5", 2, FCML_MI( 0x8f, 0xe9, 0xf8, 0x90, 0xc5 ), FCML_MI( 0x8f, 0xe9, 0x50, 0x90, 0xc0 ) );

    FCML_I64( "vprotb xmm2,xmm5,xmmword ptr [rcx+rax]", 0x8F, 0xE9, 0xD0, 0x90, 0x14, 0x01 );
    FCML_I64_M( "vprotb xmm0,xmm5,xmm0", 2, FCML_MI( 0x8f, 0xe9, 0xd0, 0x90, 0xc0 ), FCML_MI( 0x8f, 0xe9, 0x78, 0x90, 0xc5 ) );

    FCML_I32( "vprotb xmm2,xmmword ptr [ecx+eax],20h", 0x8F, 0xE8, 0x78, 0xC0, 0x14, 0x01, 0x20 );
    FCML_I64( "vprotb xmm0,xmm0,20h", 0x8F, 0xE8, 0x78, 0xC0, 0xC0, 0x20 );

    FCML_A64( "vprotb %xmm5,(%rcx,%rax),%xmm2", 0x8f, 0xe9, 0x50, 0x90, 0x14, 0x01 );
    FCML_A64( "vprotb (%rcx,%rax),%xmm5,%xmm2", 0x8f, 0xe9, 0xd0, 0x90, 0x14, 0x01 );
    FCML_A64( "vprotb $0x20,(%rcx,%rax),%xmm2", 0x8f, 0xe8, 0x78, 0xc0, 0x14, 0x01, 0x20 );
    FCML_A64( "vprotb $0x20,%xmm0,%xmm0", 0x8f, 0xe8, 0x78, 0xc0, 0xc0, 0x20 );
}

void fcml_tf_instruction_VPROTQ(void) {

    FCML_I32( "vprotq xmm2,xmmword ptr [ecx+eax],xmm5", 0x8F, 0xE9, 0x50, 0x93, 0x14, 0x01 );
    FCML_I64_M( "vprotq xmm0,xmm0,xmm5", 2, FCML_MI( 0x8f, 0xe9, 0xf8, 0x93, 0xc5 ), FCML_MI( 0x8f, 0xe9, 0x50, 0x93, 0xc0 ) );

    FCML_I64( "vprotq xmm2,xmm5,xmmword ptr [rcx+rax]", 0x8F, 0xE9, 0xD0, 0x93, 0x14, 0x01 );
    FCML_I64_M( "vprotq xmm0,xmm5,xmm0", 2, FCML_MI( 0x8f, 0xe9, 0xd0, 0x93, 0xc0 ), FCML_MI( 0x8f, 0xe9, 0x78, 0x93, 0xc5 ) );

    FCML_I32( "vprotq xmm2,xmmword ptr [ecx+eax],20h", 0x8F, 0xE8, 0x78, 0xC3, 0x14, 0x01, 0x20 );
    FCML_I64( "vprotq xmm0,xmm0,20h", 0x8F, 0xE8, 0x78, 0xC3, 0xC0, 0x20 );

    FCML_A64( "vprotq %xmm5,(%rcx,%rax),%xmm2", 0x8f, 0xe9, 0x50, 0x93, 0x14, 0x01 );
    FCML_A64( "vprotq (%rcx,%rax),%xmm5,%xmm2", 0x8f, 0xe9, 0xd0, 0x93, 0x14, 0x01 );
    FCML_A64( "vprotq $0x20,(%rcx,%rax),%xmm2", 0x8f, 0xe8, 0x78, 0xc3, 0x14, 0x01, 0x20 );
    FCML_A64( "vprotq $0x20,%xmm0,%xmm0", 0x8f, 0xe8, 0x78, 0xc3, 0xc0, 0x20 );
}

void fcml_tf_instruction_VPROTW(void) {

    FCML_I32( "vprotw xmm2,xmmword ptr [ecx+eax],xmm5", 0x8F, 0xE9, 0x50, 0x91, 0x14, 0x01 );
    FCML_I64_M( "vprotw xmm0,xmm0,xmm5", 2, FCML_MI( 0x8f, 0xe9, 0xf8, 0x91, 0xc5 ), FCML_MI( 0x8f, 0xe9, 0x50, 0x91, 0xc0 ) );

    FCML_I64( "vprotw xmm2,xmm5,xmmword ptr [rcx+rax]", 0x8F, 0xE9, 0xD0, 0x91, 0x14, 0x01 );
    FCML_I64_M( "vprotw xmm0,xmm5,xmm0", 2, FCML_MI( 0x8f, 0xe9, 0xd0, 0x91, 0xc0 ), FCML_MI( 0x8f, 0xe9, 0x78, 0x91, 0xc5 ) );

    FCML_I32( "vprotw xmm2,xmmword ptr [ecx+eax],20h", 0x8F, 0xE8, 0x78, 0xC1, 0x14, 0x01, 0x20 );
    FCML_I64( "vprotw xmm0,xmm0,20h", 0x8F, 0xE8, 0x78, 0xC1, 0xC0, 0x20 );

    FCML_A64( "vprotw %xmm5,(%rcx,%rax),%xmm2", 0x8f, 0xe9, 0x50, 0x91, 0x14, 0x01 );
    FCML_A64( "vprotw (%rcx,%rax),%xmm5,%xmm2", 0x8f, 0xe9, 0xd0, 0x91, 0x14, 0x01 );
    FCML_A64( "vprotw $0x20,(%rcx,%rax),%xmm2", 0x8f, 0xe8, 0x78, 0xc1, 0x14, 0x01, 0x20 );
    FCML_A64( "vprotw $0x20,%xmm0,%xmm0", 0x8f, 0xe8, 0x78, 0xc1, 0xc0, 0x20 );
}

void fcml_tf_instruction_VPSHAB(void) {

    FCML_I32( "vpshab xmm2,xmmword ptr [ecx+eax],xmm5", 0x8F, 0xE9, 0x50, 0x98, 0x14, 0x01 );
    FCML_I64_M( "vpshab xmm0,xmm0,xmm5", 2, FCML_MI( 0x8f, 0xe9, 0xf8, 0x98, 0xc5 ), FCML_MI( 0x8f, 0xe9, 0x50, 0x98, 0xc0 ) );

    FCML_I64( "vpshab xmm2,xmm5,xmmword ptr [rcx+rax]", 0x8F, 0xE9, 0xD0, 0x98, 0x14, 0x01 );
    FCML_I64_M( "vpshab xmm0,xmm5,xmm0", 2, FCML_MI( 0x8f, 0xe9, 0xd0, 0x98, 0xc0 ), FCML_MI( 0x8f, 0xe9, 0x78, 0x98, 0xc5 ) );

    FCML_A64( "vpshab %xmm5,(%rcx,%rax),%xmm2", 0x8f, 0xe9, 0x50, 0x98, 0x14, 0x01 );
    FCML_A64( "vpshab (%rcx,%rax),%xmm5,%xmm2", 0x8f, 0xe9, 0xd0, 0x98, 0x14, 0x01 );
    FCML_A64_M( "vpshab %xmm5,%xmm0,%xmm0", 2, FCML_MI( 0x8f, 0xe9, 0xf8, 0x98, 0xc5 ), FCML_MI( 0x8f, 0xe9, 0x50, 0x98, 0xc0 ) );
    FCML_A64_M( "vpshab %xmm0,%xmm5,%xmm0", 2, FCML_MI( 0x8f, 0xe9, 0xd0, 0x98, 0xc0 ), FCML_MI( 0x8f, 0xe9, 0x78, 0x98, 0xc5 ) );
}

void fcml_tf_instruction_VPSHAD(void) {

    FCML_I32( "vpshad xmm2,xmmword ptr [ecx+eax],xmm5", 0x8F, 0xE9, 0x50, 0x9A, 0x14, 0x01 );
    FCML_I64_M( "vpshad xmm0,xmm0,xmm5", 2, FCML_MI( 0x8f, 0xe9, 0xf8, 0x9a, 0xc5 ), FCML_MI( 0x8f, 0xe9, 0x50, 0x9A, 0xc0 ) );

    FCML_I64( "vpshad xmm2,xmm5,xmmword ptr [rcx+rax]", 0x8F, 0xE9, 0xD0, 0x9a, 0x14, 0x01 );
    FCML_I64_M( "vpshad xmm0,xmm5,xmm0", 2, FCML_MI( 0x8f, 0xe9, 0xd0, 0x9a, 0xc0 ), FCML_MI( 0x8f, 0xe9, 0x78, 0x9A, 0xc5 ) );

    FCML_A64( "vpshad %xmm5,(%rcx,%rax),%xmm2", 0x8f, 0xe9, 0x50, 0x9a, 0x14, 0x01 );
    FCML_A64( "vpshad (%rcx,%rax),%xmm5,%xmm2", 0x8f, 0xe9, 0xd0, 0x9a, 0x14, 0x01 );
}

void fcml_tf_instruction_VPSHAQ(void) {

    FCML_I32( "vpshaq xmm2,xmmword ptr [ecx+eax],xmm5", 0x8F, 0xE9, 0x50, 0x9B, 0x14, 0x01 );
    FCML_I64_M( "vpshaq xmm0,xmm0,xmm5", 2, FCML_MI( 0x8f, 0xe9, 0xf8, 0x9b, 0xc5 ), FCML_MI( 0x8f, 0xe9, 0x50, 0x9b, 0xc0 ) );

    FCML_I64( "vpshaq xmm2,xmm5,xmmword ptr [rcx+rax]", 0x8F, 0xE9, 0xD0, 0x9B, 0x14, 0x01 );
    FCML_I64_M( "vpshaq xmm0,xmm5,xmm0", 2, FCML_MI( 0x8f, 0xe9, 0xd0, 0x9b, 0xc0 ), FCML_MI( 0x8f, 0xe9, 0x78, 0x9b, 0xc5 ) );

    FCML_A64( "vpshaq %xmm5,(%rcx,%rax),%xmm2", 0x8f, 0xe9, 0x50, 0x9b, 0x14, 0x01 );
    FCML_A64( "vpshaq (%rcx,%rax),%xmm5,%xmm2", 0x8f, 0xe9, 0xd0, 0x9b, 0x14, 0x01 );
}

void fcml_tf_instruction_VPSHAW(void) {

    FCML_I32( "vpshaw xmm2,xmmword ptr [ecx+eax],xmm5", 0x8F, 0xE9, 0x50, 0x99, 0x14, 0x01 );
    FCML_I64_M( "vpshaw xmm0,xmm0,xmm5", 2, FCML_MI( 0x8f, 0xe9, 0xf8, 0x99, 0xc5 ), FCML_MI( 0x8f, 0xe9, 0x50, 0x99, 0xc0 ) );

    FCML_I64( "vpshaw xmm2,xmmword ptr [rcx+rax],xmm5", 0x8F, 0xE9, 0x50, 0x99, 0x14, 0x01 );
    FCML_I64_M( "vpshaw xmm0,xmm0,xmm5", 2, FCML_MI( 0x8f, 0xe9, 0xf8, 0x99, 0xc5 ), FCML_MI( 0x8f, 0xe9, 0x50, 0x99, 0xc0 ) );

    FCML_A64( "vpshaw %xmm5,(%rcx,%rax),%xmm2", 0x8f, 0xe9, 0x50, 0x99, 0x14, 0x01 );
    FCML_A64( "vpshaw %xmm5,(%rcx,%rax),%xmm2", 0x8f, 0xe9, 0x50, 0x99, 0x14, 0x01 );
}

void fcml_tf_instruction_VPSHLB(void) {

    FCML_I32( "vpshlb xmm2,xmmword ptr [ecx+eax],xmm5", 0x8F, 0xE9, 0x50, 0x94, 0x14, 0x01 );
    FCML_I64_M( "vpshlb xmm0,xmm0,xmm5", 2, FCML_MI( 0x8f, 0xe9, 0xf8, 0x94, 0xc5 ), FCML_MI( 0x8f, 0xe9, 0x50, 0x94, 0xc0 ) );

    FCML_I64( "vpshlb xmm2,xmmword ptr [rcx+rax],xmm5", 0x8F, 0xE9, 0x50, 0x94, 0x14, 0x01 );
    FCML_I64_M( "vpshlb xmm0,xmm0,xmm5", 2, FCML_MI( 0x8f, 0xe9, 0xf8, 0x94, 0xc5 ), FCML_MI( 0x8f, 0xe9, 0x50, 0x94, 0xc0 ) );

    FCML_A64( "vpshlb %xmm5,(%rcx,%rax),%xmm2", 0x8f, 0xe9, 0x50, 0x94, 0x14, 0x01 );
    FCML_A64( "vpshlb %xmm5,(%rcx,%rax),%xmm2", 0x8f, 0xe9, 0x50, 0x94, 0x14, 0x01 );
}

void fcml_tf_instruction_VPSHLD(void) {

    FCML_I32( "vpshld xmm2,xmmword ptr [ecx+eax],xmm5", 0x8F, 0xE9, 0x50, 0x96, 0x14, 0x01 );
    FCML_I64_M( "vpshld xmm0,xmm0,xmm5", 2, FCML_MI( 0x8f, 0xe9, 0xf8, 0x96, 0xc5 ), FCML_MI( 0x8f, 0xe9, 0x50, 0x96, 0xc0 ) );

    FCML_I64( "vpshld xmm2,xmm5,xmmword ptr [rcx+rax]", 0x8F, 0xE9, 0xD0, 0x96, 0x14, 0x01 );
    FCML_I64_M( "vpshld xmm0,xmm5,xmm0", 2, FCML_MI( 0x8f, 0xe9, 0xd0, 0x96, 0xc0 ), FCML_MI( 0x8f, 0xe9, 0x78, 0x96, 0xc5 ) );

    FCML_A64( "vpshld %xmm5,(%rcx,%rax),%xmm2", 0x8f, 0xe9, 0x50, 0x96, 0x14, 0x01 );
    FCML_A64( "vpshld (%rcx,%rax),%xmm5,%xmm2", 0x8f, 0xe9, 0xd0, 0x96, 0x14, 0x01 );
}

void fcml_tf_instruction_VPSHLQ(void) {

    FCML_I32( "vpshlq xmm2,xmmword ptr [ecx+eax],xmm5", 0x8F, 0xE9, 0x50, 0x97, 0x14, 0x01 );
    FCML_I64_M( "vpshlq xmm0,xmm0,xmm5", 2, FCML_MI( 0x8f, 0xe9, 0xf8, 0x97, 0xc5 ), FCML_MI( 0x8f, 0xe9, 0x50, 0x97, 0xc0 ) );

    FCML_I64( "vpshlq xmm2,xmm5,xmmword ptr [rcx+rax]", 0x8F, 0xE9, 0xD0, 0x97, 0x14, 0x01 );
    FCML_I64_M( "vpshlq xmm0,xmm5,xmm0", 2, FCML_MI( 0x8f, 0xe9, 0xd0, 0x97, 0xc0 ), FCML_MI( 0x8f, 0xe9, 0x78, 0x97, 0xc5 ) );

    FCML_A64( "vpshlq %xmm5,(%rcx,%rax),%xmm2", 0x8f, 0xe9, 0x50, 0x97, 0x14, 0x01 );
    FCML_A64( "vpshlq (%rcx,%rax),%xmm5,%xmm2", 0x8f, 0xe9, 0xd0, 0x97, 0x14, 0x01 );
}

void fcml_tf_instruction_VPSHLW(void) {

    FCML_I32( "vpshlw xmm2,xmmword ptr [ecx+eax],xmm5", 0x8F, 0xE9, 0x50, 0x95, 0x14, 0x01 );
    FCML_I64_M( "vpshlw xmm0,xmm0,xmm5", 2, FCML_MI( 0x8f, 0xe9, 0xf8, 0x95, 0xc5 ), FCML_MI( 0x8f, 0xe9, 0x50, 0x95, 0xc0 ) );

    FCML_I64( "vpshlw xmm2,xmm5,xmmword ptr [rcx+rax]", 0x8F, 0xE9, 0xD0, 0x95, 0x14, 0x01 );
    FCML_I64_M( "vpshlw xmm0,xmm5,xmm0", 2, FCML_MI( 0x8f, 0xe9, 0xd0, 0x95, 0xc0 ), FCML_MI( 0x8f, 0xe9, 0x78, 0x95, 0xc5 ) );

    FCML_A64( "vpshlw %xmm5,(%rcx,%rax),%xmm2", 0x8f, 0xe9, 0x50, 0x95, 0x14, 0x01 );
    FCML_A64( "vpshlw (%rcx,%rax),%xmm5,%xmm2", 0x8f, 0xe9, 0xd0, 0x95, 0x14, 0x01 );
}

void fcml_tf_instruction_VMPTRLD(void) {

    FCML_I64( "vmptrld qword ptr [rdx]", 0x0F, 0xC7, 0x32 );
    FCML_I64( "vmptrld qword ptr [edx]", 0x67, 0x0F, 0xC7, 0x32 );
    FCML_I64_A_FAILED( "vmptrld edx", 0x67, 0x0F, 0xC7, 0xF2 );
    FCML_I64_D_FAILED( "vmptrld edx", 0x67, 0x0F, 0xC7, 0xF2 );
    FCML_I32_FAILED( "vmptrld qword ptr [edx]", 0x0F, 0xC7, 0x32 );

    FCML_A64( "vmptrld (%rdx)", 0x0f, 0xc7, 0x32 );
    FCML_A64( "vmptrld (%edx)", 0x67, 0x0f, 0xc7, 0x32 );
}

void fcml_tf_instruction_VMPTRST(void) {

    FCML_I64( "vmptrst qword ptr [rdx]", 0x0F, 0xC7, 0x3A );
    FCML_I64( "vmptrst qword ptr [edx]", 0x67, 0x0F, 0xC7, 0x3A );
    FCML_I64_A_FAILED( "vmptrst edx", 0x67, 0x0F, 0xC7, 0xFA );
    FCML_I32_FAILED( "vmptrst qword ptr [edx]", 0x0F, 0xC7, 0x3A );

    FCML_A64( "vmptrst (%rdx)", 0x0f, 0xc7, 0x3a );
    FCML_A64( "vmptrst (%edx)", 0x67, 0x0f, 0xc7, 0x3a );
}

void fcml_tf_instruction_VMCLEAR(void) {

    FCML_I64( "vmclear qword ptr [rdx]", 0x66, 0x0F, 0xC7, 0x3A );
    FCML_I64( "vmclear qword ptr [edx]", 0x67, 0x66, 0x0F, 0xC7, 0x3A );
    FCML_I64_A_FAILED( "vmclear edx", 0x67, 0x66, 0x0F, 0xC7, 0xFA );
    FCML_I32_FAILED( "vmclear qword ptr [edx]", 0x66, 0x0F, 0xC7, 0x3A );

    FCML_A64( "vmptrst (%rdx)", 0x0f, 0xc7, 0x3a );
    FCML_A64( "vmptrst (%edx)", 0x67, 0x0f, 0xc7, 0x3a );
}

void fcml_tf_instruction_VMREAD(void) {

    FCML_I64( "vmread qword ptr [rdx],rdi", 0x0F, 0x78, 0x3A );
    FCML_I64( "vmread rdx,rdi", 0x0F, 0x78, 0xFA );
    FCML_I32( "vmread dword ptr [edx],edi", 0x0F, 0x78, 0x3A );
    FCML_I32( "vmread edx,edi", 0x0F, 0x78, 0xFA );

    FCML_A64( "vmread %rdi,(%rdx)", 0x0f, 0x78, 0x3a );
}

void fcml_tf_instruction_VMWRITE(void) {

    FCML_I64( "vmwrite rdi,qword ptr [rdx]", 0x0F, 0x79, 0x3A );
    FCML_I64( "vmwrite rdi,rdx", 0x0F, 0x79, 0xFA );
    FCML_I32( "vmwrite edi,dword ptr [edx]", 0x0F, 0x79, 0x3A );
    FCML_I32( "vmwrite edi,edx", 0x0F, 0x79, 0xFA );

    FCML_A64( "vmwrite (%rdx),%rdi", 0x0f, 0x79, 0x3a );
    FCML_A64( "vmwrite %rdx,%rdi", 0x0f, 0x79, 0xfa );
    FCML_A64( "vmwrite (%rdx),%rdi", 0x0f, 0x79, 0x3a );
    FCML_A64( "vmwrite %rdx,%rdi", 0x0f, 0x79, 0xfa );
}

void fcml_tf_instruction_VMLAUNCH(void) {

    FCML_I64( "vmlaunch", 0x0F, 0x01, 0xC2 );
    FCML_I32_FAILED( "vmlaunch", 0x0F, 0x01, 0xC2 );

    FCML_A64( "vmlaunch", 0x0f, 0x01, 0xc2 );
}

void fcml_tf_instruction_VMRESUME(void) {

    FCML_I64( "vmresume", 0x0F, 0x01, 0xC3 );
    FCML_I32_FAILED( "vmresume", 0x0F, 0x01, 0xC3 );

    FCML_A64( "vmresume", 0x0f, 0x01, 0xc3 );
}

void fcml_tf_instruction_VMXON(void) {

    FCML_I64( "vmxon qword ptr [rdx]", 0xF3, 0x0F, 0xC7, 0x32 );
    FCML_I64( "vmxon qword ptr [edx]", 0x67, 0xF3, 0x0F, 0xC7, 0x32 );
    FCML_I64_A_FAILED( "vmxon edx", 0x67, 0xF3, 0x0F, 0xC7, 0xF2 );
    FCML_I32_FAILED( "vmxon qword ptr [edx]", 0xF3, 0x0F, 0xC7, 0x32 );

    FCML_A64( "vmxon (%rdx)", 0xf3, 0x0f, 0xc7, 0x32 );
    FCML_A64( "vmxon (%edx)", 0x67, 0xf3, 0x0f, 0xc7, 0x32 );
}

void fcml_tf_instruction_VMXOFF(void) {

    FCML_I64( "vmxoff", 0x0F, 0x01, 0xC4 );
    FCML_I32_FAILED( "vmxoff", 0x0F, 0x01, 0xC4 );

    FCML_A64( "vmxoff", 0x0f, 0x01, 0xc4 );
}

void fcml_tf_instruction_VMCALL(void) {

    FCML_I64( "vmcall", 0x0F, 0x01, 0xC1 );
    FCML_I32_FAILED( "vmcall", 0x0F, 0x01, 0xC1 );

    FCML_A64( "vmcall", 0x0f, 0x01, 0xc1 );
}

void fcml_tf_instruction_VMFUNC(void) {

    FCML_I64( "vmfunc", 0x0F, 0x01, 0xD4 );
    FCML_I32_FAILED( "vmfunc", 0x0F, 0x01, 0xD4 );

    FCML_A64( "vmfunc", 0x0f, 0x01, 0xd4 );
}

void fcml_tf_instruction_VPERMIL2PS(void) {

    FCML_I32( "vpermil2ps xmm0,xmm4,xmmword ptr [ecx],xmm7,01h", 0xC4, 0xE3, 0x59, 0x48, 0x01, 0x71 );
    FCML_I64( "vpermil2ps xmm0,xmm4,xmm7,xmmword ptr [rcx],01h", 0xC4, 0xE3, 0xD9, 0x48, 0x01, 0x71 );
    FCML_I32( "vpermil2ps ymm0,ymm4,ymmword ptr [ecx],ymm7,01h", 0xC4, 0xE3, 0x5D, 0x48, 0x01, 0x71 );
    FCML_I64( "vpermil2ps ymm0,ymm4,ymm7,ymmword ptr [rcx],01h", 0xC4, 0xE3, 0xDD, 0x48, 0x01, 0x71 );
    FCML_I64( "vpermil2ps ymm0,ymm4,ymm15,ymmword ptr [rcx],01h", 0xC4, 0xE3, 0xDD, 0x48, 0x01, 0xF1 );
    FCML_I64_M( "vpermil2ps ymm0,ymm4,ymm15,ymm1,01h", 2, FCML_MI( 0xc4, 0xe3, 0xdd, 0x48, 0xc1, 0xf1 ), FCML_MI( 0xc4, 0xc3, 0x5d, 0x48, 0xc7, 0x11 ) );
}

void fcml_tf_instruction_VPERMIL2PD(void) {

    FCML_I32( "vpermil2pd xmm0,xmm4,xmmword ptr [ecx],xmm7,01h", 0xC4, 0xE3, 0x59, 0x49, 0x01, 0x71 );
    FCML_I64( "vpermil2pd xmm0,xmm4,xmm7,xmmword ptr [rcx],01h", 0xC4, 0xE3, 0xD9, 0x49, 0x01, 0x71 );
    FCML_I32( "vpermil2pd ymm0,ymm4,ymmword ptr [ecx],ymm7,01h", 0xC4, 0xE3, 0x5D, 0x49, 0x01, 0x71 );
    FCML_I64( "vpermil2pd ymm0,ymm4,ymm7,ymmword ptr [rcx],01h", 0xC4, 0xE3, 0xDD, 0x49, 0x01, 0x71 );
    FCML_I64( "vpermil2pd ymm0,ymm4,ymm15,ymmword ptr [rcx],01h", 0xC4, 0xE3, 0xDD, 0x49, 0x01, 0xF1 );
    FCML_I64_M( "vpermil2pd ymm0,ymm4,ymm15,ymm1,01h", 2, FCML_MI( 0xc4, 0xe3, 0xdd, 0x49, 0xc1, 0xf1 ), FCML_MI( 0xc4, 0xc3, 0x5d, 0x49, 0xc7, 0x11 ) );
}

void fcml_tf_instruction_VALIGND(void) {
    FCML_I64("valignd xmm15,xmm7,xmmword ptr [rax],14h", 0x62, 0x73, 0x45, 0x08, 0x03, 0x38, 0x14);
    FCML_I32("valignd xmm7,xmm6,xmmword ptr [eax],14h", 0x62, 0xf3, 0x4d, 0x08, 0x03, 0x38, 0x14);
    FCML_I64("valignd ymm15,ymm7,ymmword ptr [rax],14h", 0x62, 0x73, 0x45, 0x28, 0x03, 0x38, 0x14);
    FCML_I32("valignd ymm7,ymm5,ymmword ptr [eax],14h", 0x62, 0xf3, 0x55, 0x28, 0x03, 0x38, 0x14);
    FCML_I64("valignd zmm15,zmm7,zmmword ptr [rax],14h", 0x62, 0x73, 0x45, 0x48, 0x03, 0x38, 0x14);
    FCML_I32("valignd zmm7,zmm3,zmmword ptr [eax],14h", 0x62, 0xf3, 0x65, 0x48, 0x03, 0x38, 0x14);
    FCML_I64("valignd xmm15,xmm7,xmm1,14h", 0x62, 0x73, 0x45, 0x08, 0x03, 0xf9, 0x14);
    FCML_I32("valignd xmm7,xmm2,xmm1,14h", 0x62, 0xf3, 0x6d, 0x08, 0x03, 0xf9, 0x14);
    FCML_I64("valignd ymm14,ymm7,ymm6,14h", 0x62, 0x73, 0x45, 0x28, 0x03, 0xf6, 0x14);
    FCML_I32("valignd ymm6,ymm3,ymm5,14h", 0x62, 0xf3, 0x65, 0x28, 0x03, 0xf5, 0x14);
    FCML_I64("valignd zmm6,zmm15,zmm4,14h", 0x62, 0xf3, 0x05, 0x48, 0x03, 0xf4, 0x14);
    FCML_I32("valignd zmm6,zmm6,zmm4,14h", 0x62, 0xf3, 0x4d, 0x48, 0x03, 0xf4, 0x14);
    FCML_I32("valignd zmm1,zmm2,zmmword ptr [esp+00000200h],14h", 0x62, 0xf3, 0x6d, 0x48, 0x03, 0x4c, 0x24, 0x08, 0x14);
    FCML_I64("valignd zmm1,zmm2,zmmword ptr [rsp+0000000000000200h],14h", 0x62, 0xf3, 0x6d, 0x48, 0x03, 0x4c, 0x24, 0x08, 0x14);
    FCML_I32("valignd ymm1,ymm2,ymmword ptr [esp+00000100h],14h", 0x62, 0xf3, 0x6d, 0x28, 0x03, 0x4c, 0x24, 0x08, 0x14);
    FCML_I64("valignd ymm1,ymm2,ymmword ptr [rsp+0000000000000100h],14h", 0x62, 0xf3, 0x6d, 0x28, 0x03, 0x4c, 0x24, 0x08, 0x14);
    FCML_I32("valignd xmm1,xmm2,xmmword ptr [esp+00000080h],14h", 0x62, 0xf3, 0x6d, 0x08, 0x03, 0x4c, 0x24, 0x08, 0x14);
    FCML_I64("valignd xmm1,xmm2,xmmword ptr [rsp+0000000000000080h],14h", 0x62, 0xf3, 0x6d, 0x08, 0x03, 0x4c, 0x24, 0x08, 0x14);
    FCML_I64("valignd xmm10{k4}{z},xmm14,xmmword ptr [r9+r8],14h", 0x62, 0x13, 0x0d, 0x8c, 0x03, 0x14, 0x01, 0x14);
    FCML_I32("valignd xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax],14h", 0x62, 0xf3, 0x45, 0x8d, 0x03, 0x14, 0x01, 0x14);
    FCML_I64("valignd ymm10{k4}{z},ymm14,ymmword ptr [r9+r8],14h", 0x62, 0x13, 0x0d, 0xac, 0x03, 0x14, 0x01, 0x14);
    FCML_I32("valignd ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax],14h", 0x62, 0xf3, 0x45, 0xad, 0x03, 0x14, 0x01, 0x14);
    FCML_I64("valignd zmm10{k4}{z},zmm14,zmmword ptr [r9+r8],14h", 0x62, 0x13, 0x0d, 0xcc, 0x03, 0x14, 0x01, 0x14);
    FCML_I32("valignd zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax],14h", 0x62, 0xf3, 0x45, 0xcd, 0x03, 0x14, 0x01, 0x14);
    FCML_I64("valignd xmm10{k4},xmm14,xmmword ptr [r9+r8],14h", 0x62, 0x13, 0x0d, 0x0c, 0x03, 0x14, 0x01, 0x14);
    FCML_I32("valignd xmm2{k5},xmm7,xmmword ptr [ecx+eax],14h", 0x62, 0xf3, 0x45, 0x0d, 0x03, 0x14, 0x01, 0x14);
    FCML_I64("valignd ymm10{k4},ymm14,ymmword ptr [r9+r8],14h", 0x62, 0x13, 0x0d, 0x2c, 0x03, 0x14, 0x01, 0x14);
    FCML_I32("valignd ymm2{k5},ymm7,ymmword ptr [ecx+eax],14h", 0x62, 0xf3, 0x45, 0x2d, 0x03, 0x14, 0x01, 0x14);
    FCML_I64("valignd zmm10{k4},zmm14,zmmword ptr [r9+r8],14h", 0x62, 0x13, 0x0d, 0x4c, 0x03, 0x14, 0x01, 0x14);
    FCML_I32("valignd zmm2{k5},zmm7,zmmword ptr [ecx+eax],14h", 0x62, 0xf3, 0x45, 0x4d, 0x03, 0x14, 0x01, 0x14);
    FCML_I64("valignd ymm31{k7}{z},ymm21,dword ptr [rsi]{1to8},14h", 0x62, 0x63, 0x55, 0xb7, 0x03, 0x3e, 0x14);
    FCML_I32("valignd zmm1,zmm2,dword ptr [esp+00000040h]{1to16},14h", 0x62, 0xf3, 0x6d, 0x58, 0x03, 0x4c, 0x24, 0x10, 0x14);
    FCML_I64("valignd zmm1,zmm2,dword ptr [rsp+0000000000000040h]{1to16},14h", 0x62, 0xf3, 0x6d, 0x58, 0x03, 0x4c, 0x24, 0x10, 0x14);
    FCML_I32("valignd ymm1,ymm2,dword ptr [esp+00000040h]{1to8},14h", 0x62, 0xf3, 0x6d, 0x38, 0x03, 0x4c, 0x24, 0x10, 0x14);
    FCML_I64("valignd ymm1,ymm2,dword ptr [rsp+0000000000000040h]{1to8},14h", 0x62, 0xf3, 0x6d, 0x38, 0x03, 0x4c, 0x24, 0x10, 0x14);
    FCML_I32("valignd xmm1,xmm2,dword ptr [esp+00000040h]{1to4},14h", 0x62, 0xf3, 0x6d, 0x18, 0x03, 0x4c, 0x24, 0x10, 0x14);
    FCML_I64("valignd xmm1,xmm2,dword ptr [rsp+0000000000000040h]{1to4},14h", 0x62, 0xf3, 0x6d, 0x18, 0x03, 0x4c, 0x24, 0x10, 0x14);
}

void fcml_tf_instruction_VALIGNQ(void) {
    FCML_I64("valignq xmm15,xmm7,xmmword ptr [rax],14h", 0x62, 0x73, 0xc5, 0x08, 0x03, 0x38, 0x14);
    FCML_I32("valignq xmm7,xmm6,xmmword ptr [eax],14h", 0x62, 0xf3, 0xcd, 0x08, 0x03, 0x38, 0x14);
    FCML_I64("valignq ymm15,ymm7,ymmword ptr [rax],14h", 0x62, 0x73, 0xc5, 0x28, 0x03, 0x38, 0x14);
    FCML_I32("valignq ymm7,ymm5,ymmword ptr [eax],14h", 0x62, 0xf3, 0xd5, 0x28, 0x03, 0x38, 0x14);
    FCML_I64("valignq zmm15,zmm7,zmmword ptr [rax],14h", 0x62, 0x73, 0xc5, 0x48, 0x03, 0x38, 0x14);
    FCML_I32("valignq zmm7,zmm3,zmmword ptr [eax],14h", 0x62, 0xf3, 0xe5, 0x48, 0x03, 0x38, 0x14);
    FCML_I64("valignq xmm15,xmm7,xmm1,14h", 0x62, 0x73, 0xc5, 0x08, 0x03, 0xf9, 0x14);
    FCML_I32("valignq xmm7,xmm2,xmm1,14h", 0x62, 0xf3, 0xed, 0x08, 0x03, 0xf9, 0x14);
    FCML_I64("valignq ymm14,ymm7,ymm6,14h", 0x62, 0x73, 0xc5, 0x28, 0x03, 0xf6, 0x14);
    FCML_I32("valignq ymm6,ymm3,ymm5,14h", 0x62, 0xf3, 0xe5, 0x28, 0x03, 0xf5, 0x14);
    FCML_I64("valignq zmm6,zmm15,zmm4,14h", 0x62, 0xf3, 0x85, 0x48, 0x03, 0xf4, 0x14);
    FCML_I32("valignq zmm6,zmm6,zmm4,14h", 0x62, 0xf3, 0xcd, 0x48, 0x03, 0xf4, 0x14);
    FCML_I32("valignq zmm1,zmm2,zmmword ptr [esp+00000200h],14h", 0x62, 0xf3, 0xed, 0x48, 0x03, 0x4c, 0x24, 0x08, 0x14);
    FCML_I64("valignq zmm1,zmm2,zmmword ptr [rsp+0000000000000200h],14h", 0x62, 0xf3, 0xed, 0x48, 0x03, 0x4c, 0x24, 0x08, 0x14);
    FCML_I32("valignq ymm1,ymm2,ymmword ptr [esp+00000100h],14h", 0x62, 0xf3, 0xed, 0x28, 0x03, 0x4c, 0x24, 0x08, 0x14);
    FCML_I64("valignq ymm1,ymm2,ymmword ptr [rsp+0000000000000100h],14h", 0x62, 0xf3, 0xed, 0x28, 0x03, 0x4c, 0x24, 0x08, 0x14);
    FCML_I32("valignq xmm1,xmm2,xmmword ptr [esp+00000080h],14h", 0x62, 0xf3, 0xed, 0x08, 0x03, 0x4c, 0x24, 0x08, 0x14);
    FCML_I64("valignq xmm1,xmm2,xmmword ptr [rsp+0000000000000080h],14h", 0x62, 0xf3, 0xed, 0x08, 0x03, 0x4c, 0x24, 0x08, 0x14);
    FCML_I64("valignq xmm10{k4}{z},xmm14,xmmword ptr [r9+r8],14h", 0x62, 0x13, 0x8d, 0x8c, 0x03, 0x14, 0x01, 0x14);
    FCML_I32("valignq xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax],14h", 0x62, 0xf3, 0xc5, 0x8d, 0x03, 0x14, 0x01, 0x14);
    FCML_I64("valignq ymm10{k4}{z},ymm14,ymmword ptr [r9+r8],14h", 0x62, 0x13, 0x8d, 0xac, 0x03, 0x14, 0x01, 0x14);
    FCML_I32("valignq ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax],14h", 0x62, 0xf3, 0xc5, 0xad, 0x03, 0x14, 0x01, 0x14);
    FCML_I64("valignq zmm10{k4}{z},zmm14,zmmword ptr [r9+r8],14h", 0x62, 0x13, 0x8d, 0xcc, 0x03, 0x14, 0x01, 0x14);
    FCML_I32("valignq zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax],14h", 0x62, 0xf3, 0xc5, 0xcd, 0x03, 0x14, 0x01, 0x14);
    FCML_I64("valignq xmm10{k4},xmm14,xmmword ptr [r9+r8],14h", 0x62, 0x13, 0x8d, 0x0c, 0x03, 0x14, 0x01, 0x14);
    FCML_I32("valignq xmm2{k5},xmm7,xmmword ptr [ecx+eax],14h", 0x62, 0xf3, 0xc5, 0x0d, 0x03, 0x14, 0x01, 0x14);
    FCML_I64("valignq ymm10{k4},ymm14,ymmword ptr [r9+r8],14h", 0x62, 0x13, 0x8d, 0x2c, 0x03, 0x14, 0x01, 0x14);
    FCML_I32("valignq ymm2{k5},ymm7,ymmword ptr [ecx+eax],14h", 0x62, 0xf3, 0xc5, 0x2d, 0x03, 0x14, 0x01, 0x14);
    FCML_I64("valignq zmm10{k4},zmm14,zmmword ptr [r9+r8],14h", 0x62, 0x13, 0x8d, 0x4c, 0x03, 0x14, 0x01, 0x14);
    FCML_I32("valignq zmm2{k5},zmm7,zmmword ptr [ecx+eax],14h", 0x62, 0xf3, 0xc5, 0x4d, 0x03, 0x14, 0x01, 0x14);
    FCML_I64("valignq zmm31,zmm21,mmword ptr [rsi]{1to8},14h", 0x62, 0x63, 0xd5, 0x50, 0x03, 0x3e, 0x14);
    FCML_I64("valignq ymm31,ymm21,mmword ptr [rsi]{1to4},14h", 0x62, 0x63, 0xd5, 0x30, 0x03, 0x3e, 0x14);
    FCML_I64("valignq xmm31,xmm21,mmword ptr [rsi]{1to2},14h", 0x62, 0x63, 0xd5, 0x10, 0x03, 0x3e, 0x14);
    FCML_I32("valignq zmm1,zmm2,mmword ptr [esi]{1to8},14h", 0x62, 0xf3, 0xed, 0x58, 0x03, 0x0e, 0x14);
    FCML_I64("valignq ymm31{k7}{z},ymm21,mmword ptr [rsi]{1to4},14h", 0x62, 0x63, 0xd5, 0xb7, 0x03, 0x3e, 0x14);
    FCML_I32("valignq zmm1,zmm2,mmword ptr [esp+00000040h]{1to8},14h", 0x62, 0xf3, 0xed, 0x58, 0x03, 0x4c, 0x24, 0x08, 0x14);
    FCML_I64("valignq zmm1,zmm2,mmword ptr [rsp+0000000000000040h]{1to8},14h", 0x62, 0xf3, 0xed, 0x58, 0x03, 0x4c, 0x24, 0x08, 0x14);
    FCML_I32("valignq ymm1,ymm2,mmword ptr [esp+00000040h]{1to4},14h", 0x62, 0xf3, 0xed, 0x38, 0x03, 0x4c, 0x24, 0x08, 0x14);
    FCML_I64("valignq ymm1,ymm2,mmword ptr [rsp+0000000000000040h]{1to4},14h", 0x62, 0xf3, 0xed, 0x38, 0x03, 0x4c, 0x24, 0x08, 0x14);
    FCML_I32("valignq xmm1,xmm2,mmword ptr [esp+00000040h]{1to2},14h", 0x62, 0xf3, 0xed, 0x18, 0x03, 0x4c, 0x24, 0x08, 0x14);
    FCML_I64("valignq xmm1,xmm2,mmword ptr [rsp+0000000000000040h]{1to2},14h", 0x62, 0xf3, 0xed, 0x18, 0x03, 0x4c, 0x24, 0x08, 0x14);
}

void fcml_tf_instruction_VBLENDMPD(void) {
    /* xmm1, xmm2, m128 */
    FCML_A64("vblendmpd (%rax),%xmm7,%xmm15", 0x62, 0x72, 0xc5, 0x08, 0x65, 0x38);
    FCML_I64("vblendmpd xmm15,xmm7,xmmword ptr [rax]", 0x62, 0x72, 0xc5, 0x08, 0x65, 0x38);
    FCML_A32("vblendmpd (%eax),%xmm6,%xmm7", 0x62, 0xf2, 0xcd, 0x08, 0x65, 0x38);
    FCML_I32("vblendmpd xmm7,xmm6,xmmword ptr [eax]", 0x62, 0xf2, 0xcd, 0x08, 0x65, 0x38);
    /* ymm1, ymm2, m256 */
    FCML_A64("vblendmpd (%rax),%ymm7,%ymm15", 0x62, 0x72, 0xc5, 0x28, 0x65, 0x38);
    FCML_I64("vblendmpd ymm15,ymm7,ymmword ptr [rax]", 0x62, 0x72, 0xc5, 0x28, 0x65, 0x38);
    FCML_A32("vblendmpd (%eax),%ymm5,%ymm7", 0x62, 0xf2, 0xd5, 0x28, 0x65, 0x38);
    FCML_I32("vblendmpd ymm7,ymm5,ymmword ptr [eax]", 0x62, 0xf2, 0xd5, 0x28, 0x65, 0x38);
    /* zmm1, zmm2, m512 */
    FCML_A64("vblendmpd (%rax),%zmm7,%zmm15", 0x62, 0x72, 0xc5, 0x48, 0x65, 0x38);
    FCML_I64("vblendmpd zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x72, 0xc5, 0x48, 0x65, 0x38);
    FCML_A32("vblendmpd (%eax),%zmm3,%zmm7", 0x62, 0xf2, 0xe5, 0x48, 0x65, 0x38);
    FCML_I32("vblendmpd zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf2, 0xe5, 0x48, 0x65, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64("vblendmpd %xmm1,%xmm7,%xmm15", 0x62, 0x72, 0xc5, 0x08, 0x65, 0xf9);
    FCML_I64("vblendmpd xmm15,xmm7,xmm1", 0x62, 0x72, 0xc5, 0x08, 0x65, 0xf9);
    FCML_A32("vblendmpd %xmm1,%xmm2,%xmm7", 0x62, 0xf2, 0xed, 0x08, 0x65, 0xf9);
    FCML_I32("vblendmpd xmm7,xmm2,xmm1", 0x62, 0xf2, 0xed, 0x08, 0x65, 0xf9);
    /* ymm1, ymm2, ymm3 */
    FCML_A64("vblendmpd %ymm6,%ymm7,%ymm14", 0x62, 0x72, 0xc5, 0x28, 0x65, 0xf6);
    FCML_I64("vblendmpd ymm14,ymm7,ymm6", 0x62, 0x72, 0xc5, 0x28, 0x65, 0xf6);
    FCML_A32("vblendmpd %ymm5,%ymm3,%ymm6", 0x62, 0xf2, 0xe5, 0x28, 0x65, 0xf5);
    FCML_I32("vblendmpd ymm6,ymm3,ymm5", 0x62, 0xf2, 0xe5, 0x28, 0x65, 0xf5);
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vblendmpd %zmm4,%zmm15,%zmm6", 0x62, 0xf2, 0x85, 0x48, 0x65, 0xf4);
    FCML_I64("vblendmpd zmm6,zmm15,zmm4", 0x62, 0xf2, 0x85, 0x48, 0x65, 0xf4);
    FCML_A32("vblendmpd %zmm4,%zmm6,%zmm6", 0x62, 0xf2, 0xcd, 0x48, 0x65, 0xf4);
    FCML_I32("vblendmpd zmm6,zmm6,zmm4", 0x62, 0xf2, 0xcd, 0x48, 0x65, 0xf4);
    /* disp8 */
    FCML_I32("vblendmpd zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf2, 0xed, 0x48, 0x65, 0x4c, 0x24, 0x08);
    FCML_A32("vblendmpd 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x48, 0x65, 0x4c, 0x24, 0x08);
    FCML_I64("vblendmpd zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf2, 0xed, 0x48, 0x65, 0x4c, 0x24, 0x08);
    FCML_A64("vblendmpd 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x48, 0x65, 0x4c, 0x24, 0x08);
    FCML_I32("vblendmpd ymm1,ymm2,ymmword ptr [esp+00000100h]", 0x62, 0xf2, 0xed, 0x28, 0x65, 0x4c, 0x24, 0x08);
    FCML_A32("vblendmpd 0x00000100(%esp),%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x28, 0x65, 0x4c, 0x24, 0x08);
    FCML_I64("vblendmpd ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 0x62, 0xf2, 0xed, 0x28, 0x65, 0x4c, 0x24, 0x08);
    FCML_A64("vblendmpd 0x0000000000000100(%rsp),%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x28, 0x65, 0x4c, 0x24, 0x08);
    FCML_I32("vblendmpd xmm1,xmm2,xmmword ptr [esp+00000080h]", 0x62, 0xf2, 0xed, 0x08, 0x65, 0x4c, 0x24, 0x08);
    FCML_A32("vblendmpd 0x00000080(%esp),%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x08, 0x65, 0x4c, 0x24, 0x08);
    FCML_I64("vblendmpd xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 0x62, 0xf2, 0xed, 0x08, 0x65, 0x4c, 0x24, 0x08);
    FCML_A64("vblendmpd 0x0000000000000080(%rsp),%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x08, 0x65, 0x4c, 0x24, 0x08);
    /* {k}{z} */
    FCML_A64("vblendmpd (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x12, 0x8d, 0x8c, 0x65, 0x14, 0x01);
    FCML_I64("vblendmpd xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x8c, 0x65, 0x14, 0x01);
    FCML_A32("vblendmpd (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0x8d, 0x65, 0x14, 0x01);
    FCML_I32("vblendmpd xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x8d, 0x65, 0x14, 0x01);
    FCML_A64("vblendmpd (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x12, 0x8d, 0xac, 0x65, 0x14, 0x01);
    FCML_I64("vblendmpd ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0xac, 0x65, 0x14, 0x01);
    FCML_A32("vblendmpd (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0xad, 0x65, 0x14, 0x01);
    FCML_I32("vblendmpd ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0xad, 0x65, 0x14, 0x01);
    FCML_A64("vblendmpd (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x12, 0x8d, 0xcc, 0x65, 0x14, 0x01);
    FCML_I64("vblendmpd zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0xcc, 0x65, 0x14, 0x01);
    FCML_A32("vblendmpd (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0xcd, 0x65, 0x14, 0x01);
    FCML_I32("vblendmpd zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0xcd, 0x65, 0x14, 0x01);
    /* {k} */
    FCML_A64("vblendmpd (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x12, 0x8d, 0x0c, 0x65, 0x14, 0x01);
    FCML_I64("vblendmpd xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x0c, 0x65, 0x14, 0x01);
    FCML_A32("vblendmpd (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf2, 0xc5, 0x0d, 0x65, 0x14, 0x01);
    FCML_I32("vblendmpd xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x0d, 0x65, 0x14, 0x01);
    FCML_A64("vblendmpd (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x12, 0x8d, 0x2c, 0x65, 0x14, 0x01);
    FCML_I64("vblendmpd ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x2c, 0x65, 0x14, 0x01);
    FCML_A32("vblendmpd (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf2, 0xc5, 0x2d, 0x65, 0x14, 0x01);
    FCML_I32("vblendmpd ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x2d, 0x65, 0x14, 0x01);
    FCML_A64("vblendmpd (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x12, 0x8d, 0x4c, 0x65, 0x14, 0x01);
    FCML_I64("vblendmpd zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x4c, 0x65, 0x14, 0x01);
    FCML_A32("vblendmpd (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf2, 0xc5, 0x4d, 0x65, 0x14, 0x01);
    FCML_I32("vblendmpd zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x4d, 0x65, 0x14, 0x01);
    /* bcast */
    FCML_I64("vblendmpd zmm31,zmm21,mmword ptr [rsi]{1to8}", 0x62, 0x62, 0xd5, 0x50, 0x65, 0x3e);
    FCML_A64("vblendmpd (%rsi){1to8},%zmm21,%zmm31", 0x62, 0x62, 0xd5, 0x50, 0x65, 0x3e);
    FCML_I64("vblendmpd ymm31,ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x62, 0xd5, 0x30, 0x65, 0x3e);
    FCML_A64("vblendmpd (%rsi){1to4},%ymm21,%ymm31", 0x62, 0x62, 0xd5, 0x30, 0x65, 0x3e);
    FCML_I64("vblendmpd xmm31,xmm21,mmword ptr [rsi]{1to2}", 0x62, 0x62, 0xd5, 0x10, 0x65, 0x3e);
    FCML_A64("vblendmpd (%rsi){1to2},%xmm21,%xmm31", 0x62, 0x62, 0xd5, 0x10, 0x65, 0x3e);
    FCML_A32("vblendmpd (%esi){1to8},%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x58, 0x65, 0x0e);
    FCML_I32("vblendmpd zmm1,zmm2,mmword ptr [esi]{1to8}", 0x62, 0xf2, 0xed, 0x58, 0x65, 0x0e);
    /* {k}{z}{bcast} */
    FCML_A64("vblendmpd (%rsi){1to4},%ymm21,%ymm31{%k7}{z}", 0x62, 0x62, 0xd5, 0xb7, 0x65, 0x3e);
    FCML_I64("vblendmpd ymm31{k7}{z},ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x62, 0xd5, 0xb7, 0x65, 0x3e);
    /* {bcast} disp8 */
    FCML_I32("vblendmpd zmm1,zmm2,mmword ptr [esp+00000040h]{1to8}", 0x62, 0xf2, 0xed, 0x58, 0x65, 0x4c, 0x24, 0x08);
    FCML_A32("vblendmpd 0x00000040(%esp){1to8},%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x58, 0x65, 0x4c, 0x24, 0x08);
    FCML_I64("vblendmpd zmm1,zmm2,mmword ptr [rsp+0000000000000040h]{1to8}", 0x62, 0xf2, 0xed, 0x58, 0x65, 0x4c, 0x24, 0x08);
    FCML_A64("vblendmpd 0x0000000000000040(%rsp){1to8},%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x58, 0x65, 0x4c, 0x24, 0x08);
    FCML_I32("vblendmpd ymm1,ymm2,mmword ptr [esp+00000040h]{1to4}", 0x62, 0xf2, 0xed, 0x38, 0x65, 0x4c, 0x24, 0x08);
    FCML_A32("vblendmpd 0x00000040(%esp){1to4},%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x38, 0x65, 0x4c, 0x24, 0x08);
    FCML_I64("vblendmpd ymm1,ymm2,mmword ptr [rsp+0000000000000040h]{1to4}", 0x62, 0xf2, 0xed, 0x38, 0x65, 0x4c, 0x24, 0x08);
    FCML_A64("vblendmpd 0x0000000000000040(%rsp){1to4},%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x38, 0x65, 0x4c, 0x24, 0x08);
    FCML_I32("vblendmpd xmm1,xmm2,mmword ptr [esp+00000040h]{1to2}", 0x62, 0xf2, 0xed, 0x18, 0x65, 0x4c, 0x24, 0x08);
    FCML_A32("vblendmpd 0x00000040(%esp){1to2},%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x18, 0x65, 0x4c, 0x24, 0x08);
    FCML_I64("vblendmpd xmm1,xmm2,mmword ptr [rsp+0000000000000040h]{1to2}", 0x62, 0xf2, 0xed, 0x18, 0x65, 0x4c, 0x24, 0x08);
    FCML_A64("vblendmpd 0x0000000000000040(%rsp){1to2},%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x18, 0x65, 0x4c, 0x24, 0x08);
}

void fcml_tf_instruction_VBLENDMPS(void) {
    /* xmm1, xmm2, m128 */
    FCML_A64("vblendmps (%rax),%xmm7,%xmm15", 0x62, 0x72, 0x45, 0x08, 0x65, 0x38);
    FCML_I64("vblendmps xmm15,xmm7,xmmword ptr [rax]", 0x62, 0x72, 0x45, 0x08, 0x65, 0x38);
    FCML_A32("vblendmps (%eax),%xmm6,%xmm7", 0x62, 0xf2, 0x4d, 0x08, 0x65, 0x38);
    FCML_I32("vblendmps xmm7,xmm6,xmmword ptr [eax]", 0x62, 0xf2, 0x4d, 0x08, 0x65, 0x38);
    /* ymm1, ymm2, m256 */
    FCML_A64("vblendmps (%rax),%ymm7,%ymm15", 0x62, 0x72, 0x45, 0x28, 0x65, 0x38);
    FCML_I64("vblendmps ymm15,ymm7,ymmword ptr [rax]", 0x62, 0x72, 0x45, 0x28, 0x65, 0x38);
    FCML_A32("vblendmps (%eax),%ymm5,%ymm7", 0x62, 0xf2, 0x55, 0x28, 0x65, 0x38);
    FCML_I32("vblendmps ymm7,ymm5,ymmword ptr [eax]", 0x62, 0xf2, 0x55, 0x28, 0x65, 0x38);
    /* zmm1, zmm2, m512 */
    FCML_A64("vblendmps (%rax),%zmm7,%zmm15", 0x62, 0x72, 0x45, 0x48, 0x65, 0x38);
    FCML_I64("vblendmps zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x72, 0x45, 0x48, 0x65, 0x38);
    FCML_A32("vblendmps (%eax),%zmm3,%zmm7", 0x62, 0xf2, 0x65, 0x48, 0x65, 0x38);
    FCML_I32("vblendmps zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf2, 0x65, 0x48, 0x65, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64("vblendmps %xmm1,%xmm7,%xmm15", 0x62, 0x72, 0x45, 0x08, 0x65, 0xf9);
    FCML_I64("vblendmps xmm15,xmm7,xmm1", 0x62, 0x72, 0x45, 0x08, 0x65, 0xf9);
    FCML_A32("vblendmps %xmm1,%xmm2,%xmm7", 0x62, 0xf2, 0x6d, 0x08, 0x65, 0xf9);
    FCML_I32("vblendmps xmm7,xmm2,xmm1", 0x62, 0xf2, 0x6d, 0x08, 0x65, 0xf9);
    /* ymm1, ymm2, ymm3 */
    FCML_A64("vblendmps %ymm6,%ymm7,%ymm14", 0x62, 0x72, 0x45, 0x28, 0x65, 0xf6);
    FCML_I64("vblendmps ymm14,ymm7,ymm6", 0x62, 0x72, 0x45, 0x28, 0x65, 0xf6);
    FCML_A32("vblendmps %ymm5,%ymm3,%ymm6", 0x62, 0xf2, 0x65, 0x28, 0x65, 0xf5);
    FCML_I32("vblendmps ymm6,ymm3,ymm5", 0x62, 0xf2, 0x65, 0x28, 0x65, 0xf5);
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vblendmps %zmm4,%zmm15,%zmm6", 0x62, 0xf2, 0x05, 0x48, 0x65, 0xf4);
    FCML_I64("vblendmps zmm6,zmm15,zmm4", 0x62, 0xf2, 0x05, 0x48, 0x65, 0xf4);
    FCML_A32("vblendmps %zmm4,%zmm6,%zmm6", 0x62, 0xf2, 0x4d, 0x48, 0x65, 0xf4);
    FCML_I32("vblendmps zmm6,zmm6,zmm4", 0x62, 0xf2, 0x4d, 0x48, 0x65, 0xf4);
    /* disp8 */
    FCML_I32("vblendmps zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf2, 0x6d, 0x48, 0x65, 0x4c, 0x24, 0x08);
    FCML_A32("vblendmps 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x48, 0x65, 0x4c, 0x24, 0x08);
    FCML_I64("vblendmps zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf2, 0x6d, 0x48, 0x65, 0x4c, 0x24, 0x08);
    FCML_A64("vblendmps 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x48, 0x65, 0x4c, 0x24, 0x08);
    FCML_I32("vblendmps ymm1,ymm2,ymmword ptr [esp+00000100h]", 0x62, 0xf2, 0x6d, 0x28, 0x65, 0x4c, 0x24, 0x08);
    FCML_A32("vblendmps 0x00000100(%esp),%ymm2,%ymm1", 0x62, 0xf2, 0x6d, 0x28, 0x65, 0x4c, 0x24, 0x08);
    FCML_I64("vblendmps ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 0x62, 0xf2, 0x6d, 0x28, 0x65, 0x4c, 0x24, 0x08);
    FCML_A64("vblendmps 0x0000000000000100(%rsp),%ymm2,%ymm1", 0x62, 0xf2, 0x6d, 0x28, 0x65, 0x4c, 0x24, 0x08);
    FCML_I32("vblendmps xmm1,xmm2,xmmword ptr [esp+00000080h]", 0x62, 0xf2, 0x6d, 0x08, 0x65, 0x4c, 0x24, 0x08);
    FCML_A32("vblendmps 0x00000080(%esp),%xmm2,%xmm1", 0x62, 0xf2, 0x6d, 0x08, 0x65, 0x4c, 0x24, 0x08);
    FCML_I64("vblendmps xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 0x62, 0xf2, 0x6d, 0x08, 0x65, 0x4c, 0x24, 0x08);
    FCML_A64("vblendmps 0x0000000000000080(%rsp),%xmm2,%xmm1", 0x62, 0xf2, 0x6d, 0x08, 0x65, 0x4c, 0x24, 0x08);
    /* {k}{z} */
    FCML_A64("vblendmps (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x12, 0x0d, 0x8c, 0x65, 0x14, 0x01);
    FCML_I64("vblendmps xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x8c, 0x65, 0x14, 0x01);
    FCML_A32("vblendmps (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf2, 0x45, 0x8d, 0x65, 0x14, 0x01);
    FCML_I32("vblendmps xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x8d, 0x65, 0x14, 0x01);
    FCML_A64("vblendmps (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x12, 0x0d, 0xac, 0x65, 0x14, 0x01);
    FCML_I64("vblendmps ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0xac, 0x65, 0x14, 0x01);
    FCML_A32("vblendmps (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf2, 0x45, 0xad, 0x65, 0x14, 0x01);
    FCML_I32("vblendmps ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0xad, 0x65, 0x14, 0x01);
    FCML_A64("vblendmps (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x12, 0x0d, 0xcc, 0x65, 0x14, 0x01);
    FCML_I64("vblendmps zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0xcc, 0x65, 0x14, 0x01);
    FCML_A32("vblendmps (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf2, 0x45, 0xcd, 0x65, 0x14, 0x01);
    FCML_I32("vblendmps zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0xcd, 0x65, 0x14, 0x01);
    /* {k} */
    FCML_A64("vblendmps (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x12, 0x0d, 0x0c, 0x65, 0x14, 0x01);
    FCML_I64("vblendmps xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x0c, 0x65, 0x14, 0x01);
    FCML_A32("vblendmps (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf2, 0x45, 0x0d, 0x65, 0x14, 0x01);
    FCML_I32("vblendmps xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x0d, 0x65, 0x14, 0x01);
    FCML_A64("vblendmps (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x12, 0x0d, 0x2c, 0x65, 0x14, 0x01);
    FCML_I64("vblendmps ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x2c, 0x65, 0x14, 0x01);
    FCML_A32("vblendmps (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf2, 0x45, 0x2d, 0x65, 0x14, 0x01);
    FCML_I32("vblendmps ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x2d, 0x65, 0x14, 0x01);
    FCML_A64("vblendmps (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x12, 0x0d, 0x4c, 0x65, 0x14, 0x01);
    FCML_I64("vblendmps zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x4c, 0x65, 0x14, 0x01);
    FCML_A32("vblendmps (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf2, 0x45, 0x4d, 0x65, 0x14, 0x01);
    FCML_I32("vblendmps zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x4d, 0x65, 0x14, 0x01);
    /* bcast */
    FCML_I64("vblendmps zmm31,zmm21,dword ptr [rsi]{1to16}", 0x62, 0x62, 0x55, 0x50, 0x65, 0x3e);
    FCML_A64("vblendmps (%rsi){1to16},%zmm21,%zmm31", 0x62, 0x62, 0x55, 0x50, 0x65, 0x3e);
    FCML_I64("vblendmps ymm31,ymm21,dword ptr [rsi]{1to8}", 0x62, 0x62, 0x55, 0x30, 0x65, 0x3e);
    FCML_A64("vblendmps (%rsi){1to8},%ymm21,%ymm31", 0x62, 0x62, 0x55, 0x30, 0x65, 0x3e);
    FCML_I64("vblendmps xmm31,xmm21,dword ptr [rsi]{1to4}", 0x62, 0x62, 0x55, 0x10, 0x65, 0x3e);
    FCML_A64("vblendmps (%rsi){1to4},%xmm21,%xmm31", 0x62, 0x62, 0x55, 0x10, 0x65, 0x3e);
    FCML_A32("vblendmps (%esi){1to16},%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x58, 0x65, 0x0e);
    FCML_I32("vblendmps zmm1,zmm2,dword ptr [esi]{1to16}", 0x62, 0xf2, 0x6d, 0x58, 0x65, 0x0e);
    /* {k}{z}{bcast} */
    FCML_A64("vblendmps (%rsi){1to8},%ymm21,%ymm31{%k7}{z}", 0x62, 0x62, 0x55, 0xb7, 0x65, 0x3e);
    FCML_I64("vblendmps ymm31{k7}{z},ymm21,dword ptr [rsi]{1to8}", 0x62, 0x62, 0x55, 0xb7, 0x65, 0x3e);
    /* {bcast} disp8 */
    FCML_I32("vblendmps zmm1,zmm2,dword ptr [esp+00000020h]{1to16}", 0x62, 0xf2, 0x6d, 0x58, 0x65, 0x4c, 0x24, 0x08);
    FCML_A32("vblendmps 0x00000020(%esp){1to16},%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x58, 0x65, 0x4c, 0x24, 0x08);
    FCML_I64("vblendmps zmm1,zmm2,dword ptr [rsp+0000000000000020h]{1to16}", 0x62, 0xf2, 0x6d, 0x58, 0x65, 0x4c, 0x24, 0x08);
    FCML_A64("vblendmps 0x0000000000000020(%rsp){1to16},%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x58, 0x65, 0x4c, 0x24, 0x08);
    FCML_I32("vblendmps ymm1,ymm2,dword ptr [esp+00000020h]{1to8}", 0x62, 0xf2, 0x6d, 0x38, 0x65, 0x4c, 0x24, 0x08);
    FCML_A32("vblendmps 0x00000020(%esp){1to8},%ymm2,%ymm1", 0x62, 0xf2, 0x6d, 0x38, 0x65, 0x4c, 0x24, 0x08);
    FCML_I64("vblendmps ymm1,ymm2,dword ptr [rsp+0000000000000020h]{1to8}", 0x62, 0xf2, 0x6d, 0x38, 0x65, 0x4c, 0x24, 0x08);
    FCML_A64("vblendmps 0x0000000000000020(%rsp){1to8},%ymm2,%ymm1", 0x62, 0xf2, 0x6d, 0x38, 0x65, 0x4c, 0x24, 0x08);
    FCML_I32("vblendmps xmm1,xmm2,dword ptr [esp+00000020h]{1to4}", 0x62, 0xf2, 0x6d, 0x18, 0x65, 0x4c, 0x24, 0x08);
    FCML_A32("vblendmps 0x00000020(%esp){1to4},%xmm2,%xmm1", 0x62, 0xf2, 0x6d, 0x18, 0x65, 0x4c, 0x24, 0x08);
    FCML_I64("vblendmps xmm1,xmm2,dword ptr [rsp+0000000000000020h]{1to4}", 0x62, 0xf2, 0x6d, 0x18, 0x65, 0x4c, 0x24, 0x08);
    FCML_A64("vblendmps 0x0000000000000020(%rsp){1to4},%xmm2,%xmm1", 0x62, 0xf2, 0x6d, 0x18, 0x65, 0x4c, 0x24, 0x08);
}

void fcml_tf_instruction_VFIXUPIMMPD(void) {
    /* xmm1, xmm2, m128 */
    FCML_A64("vfixupimmpd $0x14,(%rax),%xmm7,%xmm15", 0x62, 0x73, 0xc5, 0x08, 0x54, 0x38, 0x14);
    FCML_I64("vfixupimmpd xmm15,xmm7,xmmword ptr [rax],14h", 0x62, 0x73, 0xc5, 0x08, 0x54, 0x38, 0x14);
    FCML_A32("vfixupimmpd $0x14,(%eax),%xmm6,%xmm7", 0x62, 0xf3, 0xcd, 0x08, 0x54, 0x38, 0x14);
    FCML_I32("vfixupimmpd xmm7,xmm6,xmmword ptr [eax],14h", 0x62, 0xf3, 0xcd, 0x08, 0x54, 0x38, 0x14);
    /* ymm1, ymm2, m256 */
    FCML_A64("vfixupimmpd $0x14,(%rax),%ymm7,%ymm15", 0x62, 0x73, 0xc5, 0x28, 0x54, 0x38, 0x14);
    FCML_I64("vfixupimmpd ymm15,ymm7,ymmword ptr [rax],14h", 0x62, 0x73, 0xc5, 0x28, 0x54, 0x38, 0x14);
    FCML_A32("vfixupimmpd $0x14,(%eax),%ymm5,%ymm7", 0x62, 0xf3, 0xd5, 0x28, 0x54, 0x38, 0x14);
    FCML_I32("vfixupimmpd ymm7,ymm5,ymmword ptr [eax],14h", 0x62, 0xf3, 0xd5, 0x28, 0x54, 0x38, 0x14);
    /* zmm1, zmm2, m512 */
    FCML_A64("vfixupimmpd $0x14,(%rax),%zmm7,%zmm15", 0x62, 0x73, 0xc5, 0x48, 0x54, 0x38, 0x14);
    FCML_I64("vfixupimmpd zmm15,zmm7,zmmword ptr [rax],14h", 0x62, 0x73, 0xc5, 0x48, 0x54, 0x38, 0x14);
    FCML_A32("vfixupimmpd $0x14,(%eax),%zmm3,%zmm7", 0x62, 0xf3, 0xe5, 0x48, 0x54, 0x38, 0x14);
    FCML_I32("vfixupimmpd zmm7,zmm3,zmmword ptr [eax],14h", 0x62, 0xf3, 0xe5, 0x48, 0x54, 0x38, 0x14);
    /* xmm1, xmm2, xmm3 */
    FCML_A64("vfixupimmpd $0x14,%xmm1,%xmm7,%xmm15", 0x62, 0x73, 0xc5, 0x08, 0x54, 0xf9, 0x14);
    FCML_I64("vfixupimmpd xmm15,xmm7,xmm1,14h", 0x62, 0x73, 0xc5, 0x08, 0x54, 0xf9, 0x14);
    FCML_A32("vfixupimmpd $0x14,%xmm1,%xmm2,%xmm7", 0x62, 0xf3, 0xed, 0x08, 0x54, 0xf9, 0x14);
    FCML_I32("vfixupimmpd xmm7,xmm2,xmm1,14h", 0x62, 0xf3, 0xed, 0x08, 0x54, 0xf9, 0x14);
    /* ymm1, ymm2, ymm3 */
    FCML_A64("vfixupimmpd $0x14,%ymm6,%ymm7,%ymm14", 0x62, 0x73, 0xc5, 0x28, 0x54, 0xf6, 0x14);
    FCML_I64("vfixupimmpd ymm14,ymm7,ymm6,14h", 0x62, 0x73, 0xc5, 0x28, 0x54, 0xf6, 0x14);
    FCML_A32("vfixupimmpd $0x14,%ymm5,%ymm3,%ymm6", 0x62, 0xf3, 0xe5, 0x28, 0x54, 0xf5, 0x14);
    FCML_I32("vfixupimmpd ymm6,ymm3,ymm5,14h", 0x62, 0xf3, 0xe5, 0x28, 0x54, 0xf5, 0x14);
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vfixupimmpd $0x14,%zmm4,%zmm15,%zmm6", 0x62, 0xf3, 0x85, 0x48, 0x54, 0xf4, 0x14);
    FCML_I64("vfixupimmpd zmm6,zmm15,zmm4,14h", 0x62, 0xf3, 0x85, 0x48, 0x54, 0xf4, 0x14);
    FCML_A32("vfixupimmpd $0x14,%zmm4,%zmm6,%zmm6", 0x62, 0xf3, 0xcd, 0x48, 0x54, 0xf4, 0x14);
    FCML_I32("vfixupimmpd zmm6,zmm6,zmm4,14h", 0x62, 0xf3, 0xcd, 0x48, 0x54, 0xf4, 0x14);
    /* disp8 */
    FCML_I32("vfixupimmpd zmm1,zmm2,zmmword ptr [esp+00000200h],14h", 0x62, 0xf3, 0xed, 0x48, 0x54, 0x4c, 0x24, 0x08, 0x14);
    FCML_A32("vfixupimmpd $0x14,0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf3, 0xed, 0x48, 0x54, 0x4c, 0x24, 0x08, 0x14);
    FCML_I64("vfixupimmpd zmm1,zmm2,zmmword ptr [rsp+0000000000000200h],14h", 0x62, 0xf3, 0xed, 0x48, 0x54, 0x4c, 0x24, 0x08, 0x14);
    FCML_A64("vfixupimmpd $0x14,0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf3, 0xed, 0x48, 0x54, 0x4c, 0x24, 0x08, 0x14);
    FCML_I32("vfixupimmpd ymm1,ymm2,ymmword ptr [esp+00000100h],14h", 0x62, 0xf3, 0xed, 0x28, 0x54, 0x4c, 0x24, 0x08, 0x14);
    FCML_A32("vfixupimmpd $0x14,0x00000100(%esp),%ymm2,%ymm1", 0x62, 0xf3, 0xed, 0x28, 0x54, 0x4c, 0x24, 0x08, 0x14);
    FCML_I64("vfixupimmpd ymm1,ymm2,ymmword ptr [rsp+0000000000000100h],14h", 0x62, 0xf3, 0xed, 0x28, 0x54, 0x4c, 0x24, 0x08, 0x14);
    FCML_A64("vfixupimmpd $0x14,0x0000000000000100(%rsp),%ymm2,%ymm1", 0x62, 0xf3, 0xed, 0x28, 0x54, 0x4c, 0x24, 0x08, 0x14);
    FCML_I32("vfixupimmpd xmm1,xmm2,xmmword ptr [esp+00000080h],14h", 0x62, 0xf3, 0xed, 0x08, 0x54, 0x4c, 0x24, 0x08, 0x14);
    FCML_A32("vfixupimmpd $0x14,0x00000080(%esp),%xmm2,%xmm1", 0x62, 0xf3, 0xed, 0x08, 0x54, 0x4c, 0x24, 0x08, 0x14);
    FCML_I64("vfixupimmpd xmm1,xmm2,xmmword ptr [rsp+0000000000000080h],14h", 0x62, 0xf3, 0xed, 0x08, 0x54, 0x4c, 0x24, 0x08, 0x14);
    FCML_A64("vfixupimmpd $0x14,0x0000000000000080(%rsp),%xmm2,%xmm1", 0x62, 0xf3, 0xed, 0x08, 0x54, 0x4c, 0x24, 0x08, 0x14);
    /* {k}{z} */
    FCML_A64("vfixupimmpd $0x14,(%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x13, 0x8d, 0x8c, 0x54, 0x14, 0x01, 0x14);
    FCML_I64("vfixupimmpd xmm10{k4}{z},xmm14,xmmword ptr [r9+r8],14h", 0x62, 0x13, 0x8d, 0x8c, 0x54, 0x14, 0x01, 0x14);
    FCML_A32("vfixupimmpd $0x14,(%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf3, 0xc5, 0x8d, 0x54, 0x14, 0x01, 0x14);
    FCML_I32("vfixupimmpd xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax],14h", 0x62, 0xf3, 0xc5, 0x8d, 0x54, 0x14, 0x01, 0x14);
    FCML_A64("vfixupimmpd $0x14,(%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x13, 0x8d, 0xac, 0x54, 0x14, 0x01, 0x14);
    FCML_I64("vfixupimmpd ymm10{k4}{z},ymm14,ymmword ptr [r9+r8],14h", 0x62, 0x13, 0x8d, 0xac, 0x54, 0x14, 0x01, 0x14);
    FCML_A32("vfixupimmpd $0x14,(%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf3, 0xc5, 0xad, 0x54, 0x14, 0x01, 0x14);
    FCML_I32("vfixupimmpd ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax],14h", 0x62, 0xf3, 0xc5, 0xad, 0x54, 0x14, 0x01, 0x14);
    FCML_A64("vfixupimmpd $0x14,(%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x13, 0x8d, 0xcc, 0x54, 0x14, 0x01, 0x14);
    FCML_I64("vfixupimmpd zmm10{k4}{z},zmm14,zmmword ptr [r9+r8],14h", 0x62, 0x13, 0x8d, 0xcc, 0x54, 0x14, 0x01, 0x14);
    FCML_A32("vfixupimmpd $0x14,(%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf3, 0xc5, 0xcd, 0x54, 0x14, 0x01, 0x14);
    FCML_I32("vfixupimmpd zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax],14h", 0x62, 0xf3, 0xc5, 0xcd, 0x54, 0x14, 0x01, 0x14);
    /* {sae} */
    FCML_I64("vfixupimmpd zmm10{k4}{z},zmm14,zmm13,{sae},14h", 0x62, 0x53, 0x8d, 0x9c, 0x54, 0xd5, 0x14);
    /* {k} */
    FCML_A64("vfixupimmpd $0x14,(%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x13, 0x8d, 0x0c, 0x54, 0x14, 0x01, 0x14);
    FCML_I64("vfixupimmpd xmm10{k4},xmm14,xmmword ptr [r9+r8],14h", 0x62, 0x13, 0x8d, 0x0c, 0x54, 0x14, 0x01, 0x14);
    FCML_A32("vfixupimmpd $0x14,(%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf3, 0xc5, 0x0d, 0x54, 0x14, 0x01, 0x14);
    FCML_I32("vfixupimmpd xmm2{k5},xmm7,xmmword ptr [ecx+eax],14h", 0x62, 0xf3, 0xc5, 0x0d, 0x54, 0x14, 0x01, 0x14);
    FCML_A64("vfixupimmpd $0x14,(%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x13, 0x8d, 0x2c, 0x54, 0x14, 0x01, 0x14);
    FCML_I64("vfixupimmpd ymm10{k4},ymm14,ymmword ptr [r9+r8],14h", 0x62, 0x13, 0x8d, 0x2c, 0x54, 0x14, 0x01, 0x14);
    FCML_A32("vfixupimmpd $0x14,(%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf3, 0xc5, 0x2d, 0x54, 0x14, 0x01, 0x14);
    FCML_I32("vfixupimmpd ymm2{k5},ymm7,ymmword ptr [ecx+eax],14h", 0x62, 0xf3, 0xc5, 0x2d, 0x54, 0x14, 0x01, 0x14);
    FCML_A64("vfixupimmpd $0x14,(%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x13, 0x8d, 0x4c, 0x54, 0x14, 0x01, 0x14);
    FCML_I64("vfixupimmpd zmm10{k4},zmm14,zmmword ptr [r9+r8],14h", 0x62, 0x13, 0x8d, 0x4c, 0x54, 0x14, 0x01, 0x14);
    FCML_A32("vfixupimmpd $0x14,(%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf3, 0xc5, 0x4d, 0x54, 0x14, 0x01, 0x14);
    FCML_I32("vfixupimmpd zmm2{k5},zmm7,zmmword ptr [ecx+eax],14h", 0x62, 0xf3, 0xc5, 0x4d, 0x54, 0x14, 0x01, 0x14);
    /* bcast */
    FCML_I64("vfixupimmpd zmm31,zmm21,mmword ptr [rsi]{1to8},14h", 0x62, 0x63, 0xd5, 0x50, 0x54, 0x3e, 0x14);
    FCML_A64("vfixupimmpd $0x14,(%rsi){1to8},%zmm21,%zmm31", 0x62, 0x63, 0xd5, 0x50, 0x54, 0x3e, 0x14);
    FCML_I64("vfixupimmpd ymm31,ymm21,mmword ptr [rsi]{1to4},14h", 0x62, 0x63, 0xd5, 0x30, 0x54, 0x3e, 0x14);
    FCML_A64("vfixupimmpd $0x14,(%rsi){1to4},%ymm21,%ymm31", 0x62, 0x63, 0xd5, 0x30, 0x54, 0x3e, 0x14);
    FCML_I64("vfixupimmpd xmm31,xmm21,mmword ptr [rsi]{1to2},14h", 0x62, 0x63, 0xd5, 0x10, 0x54, 0x3e, 0x14);
    FCML_A64("vfixupimmpd $0x14,(%rsi){1to2},%xmm21,%xmm31", 0x62, 0x63, 0xd5, 0x10, 0x54, 0x3e, 0x14);
    FCML_A32("vfixupimmpd $0x14,(%esi){1to8},%zmm2,%zmm1", 0x62, 0xf3, 0xed, 0x58, 0x54, 0x0e, 0x14);
    FCML_I32("vfixupimmpd zmm1,zmm2,mmword ptr [esi]{1to8},14h", 0x62, 0xf3, 0xed, 0x58, 0x54, 0x0e, 0x14);
    /* {k}{z}{bcast} */
    FCML_A64("vfixupimmpd $0x14,(%rsi){1to4},%ymm21,%ymm31{%k7}{z}", 0x62, 0x63, 0xd5, 0xb7, 0x54, 0x3e, 0x14);
    FCML_I64("vfixupimmpd ymm31{k7}{z},ymm21,mmword ptr [rsi]{1to4},14h", 0x62, 0x63, 0xd5, 0xb7, 0x54, 0x3e, 0x14);
    /* {bcast} disp8 */
    FCML_I32("vfixupimmpd zmm1,zmm2,mmword ptr [esp+00000040h]{1to8},14h", 0x62, 0xf3, 0xed, 0x58, 0x54, 0x4c, 0x24, 0x08, 0x14);
    FCML_A32("vfixupimmpd $0x14,0x00000040(%esp){1to8},%zmm2,%zmm1", 0x62, 0xf3, 0xed, 0x58, 0x54, 0x4c, 0x24, 0x08, 0x14);
    FCML_I64("vfixupimmpd zmm1,zmm2,mmword ptr [rsp+0000000000000040h]{1to8},14h", 0x62, 0xf3, 0xed, 0x58, 0x54, 0x4c, 0x24, 0x08, 0x14);
    FCML_A64("vfixupimmpd $0x14,0x0000000000000040(%rsp){1to8},%zmm2,%zmm1", 0x62, 0xf3, 0xed, 0x58, 0x54, 0x4c, 0x24, 0x08, 0x14);
    FCML_I32("vfixupimmpd ymm1,ymm2,mmword ptr [esp+00000040h]{1to4},14h", 0x62, 0xf3, 0xed, 0x38, 0x54, 0x4c, 0x24, 0x08, 0x14);
    FCML_A32("vfixupimmpd $0x14,0x00000040(%esp){1to4},%ymm2,%ymm1", 0x62, 0xf3, 0xed, 0x38, 0x54, 0x4c, 0x24, 0x08, 0x14);
    FCML_I64("vfixupimmpd ymm1,ymm2,mmword ptr [rsp+0000000000000040h]{1to4},14h", 0x62, 0xf3, 0xed, 0x38, 0x54, 0x4c, 0x24, 0x08, 0x14);
    FCML_A64("vfixupimmpd $0x14,0x0000000000000040(%rsp){1to4},%ymm2,%ymm1", 0x62, 0xf3, 0xed, 0x38, 0x54, 0x4c, 0x24, 0x08, 0x14);
    FCML_I32("vfixupimmpd xmm1,xmm2,mmword ptr [esp+00000040h]{1to2},14h", 0x62, 0xf3, 0xed, 0x18, 0x54, 0x4c, 0x24, 0x08, 0x14);
    FCML_A32("vfixupimmpd $0x14,0x00000040(%esp){1to2},%xmm2,%xmm1", 0x62, 0xf3, 0xed, 0x18, 0x54, 0x4c, 0x24, 0x08, 0x14);
    FCML_I64("vfixupimmpd xmm1,xmm2,mmword ptr [rsp+0000000000000040h]{1to2},14h", 0x62, 0xf3, 0xed, 0x18, 0x54, 0x4c, 0x24, 0x08, 0x14);
    FCML_A64("vfixupimmpd $0x14,0x0000000000000040(%rsp){1to2},%xmm2,%xmm1", 0x62, 0xf3, 0xed, 0x18, 0x54, 0x4c, 0x24, 0x08, 0x14);
}

void fcml_tf_instruction_VFIXUPIMMPS(void) {
    /* xmm1, xmm2, m128 */
    FCML_A64("vfixupimmps $0x14,(%rax),%xmm7,%xmm15", 0x62, 0x73, 0x45, 0x08, 0x54, 0x38, 0x14);
    FCML_I64("vfixupimmps xmm15,xmm7,xmmword ptr [rax],14h", 0x62, 0x73, 0x45, 0x08, 0x54, 0x38, 0x14);
    FCML_A32("vfixupimmps $0x14,(%eax),%xmm6,%xmm7", 0x62, 0xf3, 0x4d, 0x08, 0x54, 0x38, 0x14);
    FCML_I32("vfixupimmps xmm7,xmm6,xmmword ptr [eax],14h", 0x62, 0xf3, 0x4d, 0x08, 0x54, 0x38, 0x14);
    /* ymm1, ymm2, m256 */
    FCML_A64("vfixupimmps $0x14,(%rax),%ymm7,%ymm15", 0x62, 0x73, 0x45, 0x28, 0x54, 0x38, 0x14);
    FCML_I64("vfixupimmps ymm15,ymm7,ymmword ptr [rax],14h", 0x62, 0x73, 0x45, 0x28, 0x54, 0x38, 0x14);
    FCML_A32("vfixupimmps $0x14,(%eax),%ymm5,%ymm7", 0x62, 0xf3, 0x55, 0x28, 0x54, 0x38, 0x14);
    FCML_I32("vfixupimmps ymm7,ymm7,ymmword ptr [eax],14h", 0x62, 0xf3, 0x45, 0x28, 0x54, 0x38, 0x14);
    /* zmm1, zmm2, m512 */
    FCML_A64("vfixupimmps $0x14,(%rax),%zmm7,%zmm15", 0x62, 0x73, 0x45, 0x48, 0x54, 0x38, 0x14);
    FCML_I64("vfixupimmps zmm15,zmm7,zmmword ptr [rax],14h", 0x62, 0x73, 0x45, 0x48, 0x54, 0x38, 0x14);
    FCML_A32("vfixupimmps $0x14,(%eax),%zmm3,%zmm7", 0x62, 0xf3, 0x65, 0x48, 0x54, 0x38, 0x14);
    FCML_I32("vfixupimmps zmm7,zmm3,zmmword ptr [eax],14h", 0x62, 0xf3, 0x65, 0x48, 0x54, 0x38, 0x14);
    /* xmm1, xmm2, xmm3 */
    FCML_A64("vfixupimmps $0x14,%xmm1,%xmm7,%xmm15", 0x62, 0x73, 0x45, 0x08, 0x54, 0xf9, 0x14);
    FCML_I64("vfixupimmps xmm15,xmm7,xmm1,14h", 0x62, 0x73, 0x45, 0x08, 0x54, 0xf9, 0x14);
    FCML_A32("vfixupimmps $0x14,%xmm1,%xmm2,%xmm7", 0x62, 0xf3, 0x6D, 0x08, 0x54, 0xf9, 0x14);
    FCML_I32("vfixupimmps xmm7,xmm2,xmm1,14h", 0x62, 0xf3, 0x6D, 0x08, 0x54, 0xf9, 0x14);
    /* ymm1, ymm2, ymm3 */
    FCML_A64("vfixupimmps $0x14,%ymm6,%ymm7,%ymm14", 0x62, 0x73, 0x45, 0x28, 0x54, 0xf6, 0x14);
    FCML_I64("vfixupimmps ymm14,ymm7,ymm6,14h", 0x62, 0x73, 0x45, 0x28, 0x54, 0xf6, 0x14);
    FCML_A32("vfixupimmps $0x14,%ymm5,%ymm3,%ymm6", 0x62, 0xf3, 0x65, 0x28, 0x54, 0xf5, 0x14);
    FCML_I32("vfixupimmps ymm6,ymm3,ymm5,14h", 0x62, 0xf3, 0x65, 0x28, 0x54, 0xf5, 0x14);
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vfixupimmps $0x14,%zmm4,%zmm15,%zmm6", 0x62, 0xf3, 0x05, 0x48, 0x54, 0xf4, 0x14);
    FCML_I64("vfixupimmps zmm6,zmm15,zmm4,14h", 0x62, 0xf3, 0x05, 0x48, 0x54, 0xf4, 0x14);
    FCML_A32("vfixupimmps $0x14,%zmm4,%zmm6,%zmm6", 0x62, 0xf3, 0x4D, 0x48, 0x54, 0xf4, 0x14);
    FCML_I32("vfixupimmps zmm6,zmm6,zmm4,14h", 0x62, 0xf3, 0x4D, 0x48, 0x54, 0xf4, 0x14);
    /* disp8 */
    FCML_I32("vfixupimmps zmm1,zmm2,zmmword ptr [esp+00000200h],14h", 0x62, 0xf3, 0x6D, 0x48, 0x54, 0x4c, 0x24, 0x08, 0x14);
    FCML_A32("vfixupimmps $0x14,0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf3, 0x6D, 0x48, 0x54, 0x4c, 0x24, 0x08, 0x14);
    FCML_I64("vfixupimmps zmm1,zmm2,zmmword ptr [rsp+0000000000000200h],14h", 0x62, 0xf3, 0x6D, 0x48, 0x54, 0x4c, 0x24, 0x08, 0x14);
    FCML_A64("vfixupimmps $0x14,0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf3, 0x6D, 0x48, 0x54, 0x4c, 0x24, 0x08, 0x14);
    FCML_I32("vfixupimmps ymm1,ymm2,ymmword ptr [esp+00000100h],14h", 0x62, 0xf3, 0x6D, 0x28, 0x54, 0x4c, 0x24, 0x08, 0x14);
    FCML_A32("vfixupimmps $0x14,0x00000100(%esp),%ymm2,%ymm1", 0x62, 0xf3, 0x6D, 0x28, 0x54, 0x4c, 0x24, 0x08, 0x14);
    FCML_I64("vfixupimmps ymm1,ymm2,ymmword ptr [rsp+0000000000000100h],14h", 0x62, 0xf3, 0x6D, 0x28, 0x54, 0x4c, 0x24, 0x08, 0x14);
    FCML_A64("vfixupimmps $0x14,0x0000000000000100(%rsp),%ymm2,%ymm1", 0x62, 0xf3, 0x6D, 0x28, 0x54, 0x4c, 0x24, 0x08, 0x14);
    FCML_I32("vfixupimmps xmm1,xmm2,xmmword ptr [esp+00000080h],14h", 0x62, 0xf3, 0x6D, 0x08, 0x54, 0x4c, 0x24, 0x08, 0x14);
    FCML_A32("vfixupimmps $0x14,0x00000080(%esp),%xmm2,%xmm1", 0x62, 0xf3, 0x6D, 0x08, 0x54, 0x4c, 0x24, 0x08, 0x14);
    FCML_I64("vfixupimmps xmm1,xmm2,xmmword ptr [rsp+0000000000000080h],14h", 0x62, 0xf3, 0x6D, 0x08, 0x54, 0x4c, 0x24, 0x08, 0x14);
    FCML_A64("vfixupimmps $0x14,0x0000000000000080(%rsp),%xmm2,%xmm1", 0x62, 0xf3, 0x6D, 0x08, 0x54, 0x4c, 0x24, 0x08, 0x14);
    /* {k}{z} */
    FCML_A64("vfixupimmps $0x14,(%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x13, 0x0D, 0x8c, 0x54, 0x14, 0x01, 0x14);
    FCML_I64("vfixupimmps xmm10{k4}{z},xmm14,xmmword ptr [r9+r8],14h", 0x62, 0x13, 0x0D, 0x8c, 0x54, 0x14, 0x01, 0x14);
    FCML_A32("vfixupimmps $0x14,(%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf3, 0x45, 0x8d, 0x54, 0x14, 0x01, 0x14);
    FCML_I32("vfixupimmps xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax],14h", 0x62, 0xf3, 0x45, 0x8d, 0x54, 0x14, 0x01, 0x14);
    FCML_A64("vfixupimmps $0x14,(%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x13, 0x0D, 0xac, 0x54, 0x14, 0x01, 0x14);
    FCML_I64("vfixupimmps ymm10{k4}{z},ymm14,ymmword ptr [r9+r8],14h", 0x62, 0x13, 0x0D, 0xac, 0x54, 0x14, 0x01, 0x14);
    FCML_A32("vfixupimmps $0x14,(%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf3, 0x45, 0xad, 0x54, 0x14, 0x01, 0x14);
    FCML_I32("vfixupimmps ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax],14h", 0x62, 0xf3, 0x45, 0xad, 0x54, 0x14, 0x01, 0x14);
    FCML_A64("vfixupimmps $0x14,(%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x13, 0x0D, 0xcc, 0x54, 0x14, 0x01, 0x14);
    FCML_I64("vfixupimmps zmm10{k4}{z},zmm14,zmmword ptr [r9+r8],14h", 0x62, 0x13, 0x0D, 0xcc, 0x54, 0x14, 0x01, 0x14);
    FCML_A32("vfixupimmps $0x14,(%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf3, 0x45, 0xcd, 0x54, 0x14, 0x01, 0x14);
    FCML_I32("vfixupimmps zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax],14h", 0x62, 0xf3, 0x45, 0xcd, 0x54, 0x14, 0x01, 0x14);
    /* {k} */
    FCML_A64("vfixupimmps $0x14,(%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x13, 0x0D, 0x0c, 0x54, 0x14, 0x01, 0x14);
    FCML_I64("vfixupimmps xmm10{k4},xmm14,xmmword ptr [r9+r8],14h", 0x62, 0x13, 0x0D, 0x0c, 0x54, 0x14, 0x01, 0x14);
    FCML_A32("vfixupimmps $0x14,(%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf3, 0x45, 0x0d, 0x54, 0x14, 0x01, 0x14);
    FCML_I32("vfixupimmps xmm2{k5},xmm7,xmmword ptr [ecx+eax],14h", 0x62, 0xf3, 0x45, 0x0d, 0x54, 0x14, 0x01, 0x14);
    FCML_A64("vfixupimmps $0x14,(%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x13, 0x0D, 0x2c, 0x54, 0x14, 0x01, 0x14);
    FCML_I64("vfixupimmps ymm10{k4},ymm14,ymmword ptr [r9+r8],14h", 0x62, 0x13, 0x0D, 0x2c, 0x54, 0x14, 0x01, 0x14);
    FCML_A32("vfixupimmps $0x14,(%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf3, 0x45, 0x2d, 0x54, 0x14, 0x01, 0x14);
    FCML_I32("vfixupimmps ymm2{k5},ymm7,ymmword ptr [ecx+eax],14h", 0x62, 0xf3, 0x45, 0x2d, 0x54, 0x14, 0x01, 0x14);
    FCML_A64("vfixupimmps $0x14,(%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x13, 0x0D, 0x4c, 0x54, 0x14, 0x01, 0x14);
    FCML_I64("vfixupimmps zmm10{k4},zmm14,zmmword ptr [r9+r8],14h", 0x62, 0x13, 0x0D, 0x4c, 0x54, 0x14, 0x01, 0x14);
    FCML_A32("vfixupimmps $0x14,(%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf3, 0x45, 0x4d, 0x54, 0x14, 0x01, 0x14);
    FCML_I32("vfixupimmps zmm2{k5},zmm7,zmmword ptr [ecx+eax],14h", 0x62, 0xf3, 0x45, 0x4d, 0x54, 0x14, 0x01, 0x14);
    /* {sae} */
    FCML_I64("vfixupimmps zmm10{k4}{z},zmm14,zmm13,{sae},14h", 0x62, 0x53, 0x0d, 0x9c, 0x54, 0xd5, 0x14);
    /* bcast */
    FCML_I64("vfixupimmps zmm31,zmm21,dword ptr [rsi]{1to16},14h", 0x62, 0x63, 0x55, 0x50, 0x54, 0x3e, 0x14);
    FCML_A64("vfixupimmps $0x14,(%rsi){1to16},%zmm21,%zmm31", 0x62, 0x63, 0x55, 0x50, 0x54, 0x3e, 0x14);
    FCML_I64("vfixupimmps ymm31,ymm21,dword ptr [rsi]{1to8},14h", 0x62, 0x63, 0x55, 0x30, 0x54, 0x3e, 0x14);
    FCML_A64("vfixupimmps $0x14,(%rsi){1to8},%ymm21,%ymm31", 0x62, 0x63, 0x55, 0x30, 0x54, 0x3e, 0x14);
    FCML_I64("vfixupimmps xmm31,xmm21,dword ptr [rsi]{1to4},14h", 0x62, 0x63, 0x55, 0x10, 0x54, 0x3e, 0x14);
    FCML_A64("vfixupimmps $0x14,(%rsi){1to4},%xmm21,%xmm31", 0x62, 0x63, 0x55, 0x10, 0x54, 0x3e, 0x14);
    FCML_A32("vfixupimmps $0x14,(%esi){1to16},%zmm2,%zmm1", 0x62, 0xf3, 0x6D, 0x58, 0x54, 0x0e, 0x14);
    FCML_I32("vfixupimmps zmm1,zmm2,dword ptr [esi]{1to16},14h", 0x62, 0xf3, 0x6D, 0x58, 0x54, 0x0e, 0x14);
    /* {k}{z}{bcast} */
    FCML_A64("vfixupimmps $0x14,(%rsi){1to8},%ymm21,%ymm31{%k7}{z}", 0x62, 0x63, 0x55, 0xb7, 0x54, 0x3e, 0x14);
    FCML_I64("vfixupimmps ymm31{k7}{z},ymm21,dword ptr [rsi]{1to8},14h", 0x62, 0x63, 0x55, 0xb7, 0x54, 0x3e, 0x14);
    /* {bcast} disp8 */
    FCML_I32("vfixupimmps zmm1,zmm2,dword ptr [esp+00000020h]{1to16},14h", 0x62, 0xf3, 0x6D, 0x58, 0x54, 0x4c, 0x24, 0x08, 0x14);
    FCML_A32("vfixupimmps $0x14,0x00000020(%esp){1to16},%zmm2,%zmm1", 0x62, 0xf3, 0x6D, 0x58, 0x54, 0x4c, 0x24, 0x08, 0x14);
    FCML_I64("vfixupimmps zmm1,zmm2,dword ptr [rsp+0000000000000020h]{1to16},14h", 0x62, 0xf3, 0x6D, 0x58, 0x54, 0x4c, 0x24, 0x08, 0x14);
    FCML_A64("vfixupimmps $0x14,0x0000000000000020(%rsp){1to16},%zmm2,%zmm1", 0x62, 0xf3, 0x6D, 0x58, 0x54, 0x4c, 0x24, 0x08, 0x14);
    FCML_I32("vfixupimmps ymm1,ymm2,dword ptr [esp+00000020h]{1to8},14h", 0x62, 0xf3, 0x6D, 0x38, 0x54, 0x4c, 0x24, 0x08, 0x14);
    FCML_A32("vfixupimmps $0x14,0x00000020(%esp){1to8},%ymm2,%ymm1", 0x62, 0xf3, 0x6D, 0x38, 0x54, 0x4c, 0x24, 0x08, 0x14);
    FCML_I64("vfixupimmps ymm1,ymm2,dword ptr [rsp+0000000000000020h]{1to8},14h", 0x62, 0xf3, 0x6D, 0x38, 0x54, 0x4c, 0x24, 0x08, 0x14);
    FCML_A64("vfixupimmps $0x14,0x0000000000000020(%rsp){1to8},%ymm2,%ymm1", 0x62, 0xf3, 0x6D, 0x38, 0x54, 0x4c, 0x24, 0x08, 0x14);
    FCML_I32("vfixupimmps xmm1,xmm2,dword ptr [esp+00000020h]{1to4},14h", 0x62, 0xf3, 0x6D, 0x18, 0x54, 0x4c, 0x24, 0x08, 0x14);
    FCML_A32("vfixupimmps $0x14,0x00000020(%esp){1to4},%xmm2,%xmm1", 0x62, 0xf3, 0x6D, 0x18, 0x54, 0x4c, 0x24, 0x08, 0x14);
    FCML_I64("vfixupimmps xmm1,xmm2,dword ptr [rsp+0000000000000020h]{1to4},14h", 0x62, 0xf3, 0x6D, 0x18, 0x54, 0x4c, 0x24, 0x08, 0x14);
    FCML_A64("vfixupimmps $0x14,0x0000000000000020(%rsp){1to4},%xmm2,%xmm1", 0x62, 0xf3, 0x6D, 0x18, 0x54, 0x4c, 0x24, 0x08, 0x14);
}

void fcml_tf_instruction_VFIXUPIMMSD(void) {
    FCML_I64("vfixupimmsd xmm3,xmm15,xmm8,14h", 0x62, 0xd3, 0x85, 0x08, 0x55, 0xd8, 0x14);
    FCML_I64("vfixupimmsd xmm3{k5}{z},xmm15,xmm8,14h", 0x62, 0xd3, 0x85, 0x8d, 0x55, 0xd8, 0x14);
    FCML_I64("vfixupimmsd xmm3{k3},xmm15,xmm8,14h", 0x62, 0xd3, 0x85, 0x0b, 0x55, 0xd8, 0x14);
    FCML_I64("vfixupimmsd xmm3{k3},xmm15,xmm8,{sae},14h", 0x62, 0xd3, 0x85, 0x1b, 0x55, 0xd8, 0x14);
    FCML_I64("vfixupimmsd xmm3{k3},xmm15,mmword ptr [rax],14h", 0x62, 0xf3, 0x85, 0x0b, 0x55, 0x18, 0x14);
    FCML_I64("vfixupimmsd xmm3{k3},xmm15,mmword ptr [rsp+0000000000000020h],14h", 0x62, 0xf3, 0x85, 0x0b, 0x55, 0x5c, 0x24, 0x04, 0x14);

    FCML_A64("vfixupimmsd $0x14,%xmm8,%xmm15,%xmm3", 0x62, 0xd3, 0x85, 0x08, 0x55, 0xd8, 0x14);
    FCML_A64("vfixupimmsd $0x14,%xmm8,%xmm15,%xmm3{%k5}{z}", 0x62, 0xd3, 0x85, 0x8d, 0x55, 0xd8, 0x14);
    FCML_A64("vfixupimmsd $0x14,%xmm8,%xmm15,%xmm3{%k3}", 0x62, 0xd3, 0x85, 0x0b, 0x55, 0xd8, 0x14);
    FCML_A64("vfixupimmsd $0x14,{sae},%xmm8,%xmm15,%xmm3{%k3}", 0x62, 0xd3, 0x85, 0x1b, 0x55, 0xd8, 0x14);
    FCML_A64("vfixupimmsd $0x14,(%rax),%xmm15,%xmm3{%k3}", 0x62, 0xf3, 0x85, 0x0b, 0x55, 0x18, 0x14);
    FCML_A64("vfixupimmsd $0x14,0x0000000000000020(%rsp),%xmm15,%xmm3{%k3}", 0x62, 0xf3, 0x85, 0x0b, 0x55, 0x5c, 0x24, 0x04, 0x14);
}

void fcml_tf_instruction_VFIXUPIMMSS(void) {
    FCML_I64("vfixupimmss xmm3,xmm15,xmm8,14h", 0x62, 0xd3, 0x05, 0x08, 0x55, 0xd8, 0x14);
    FCML_I64("vfixupimmss xmm3{k5}{z},xmm15,xmm8,14h", 0x62, 0xd3, 0x05, 0x8d, 0x55, 0xd8, 0x14);
    FCML_I64("vfixupimmss xmm3{k3},xmm15,xmm8,14h", 0x62, 0xd3, 0x05, 0x0b, 0x55, 0xd8, 0x14);
    FCML_I64("vfixupimmss xmm3{k3},xmm15,xmm8,{sae},14h", 0x62, 0xd3, 0x05, 0x1b, 0x55, 0xd8, 0x14);
    FCML_I64("vfixupimmss xmm3{k3},xmm15,dword ptr [rax],14h", 0x62, 0xf3, 0x05, 0x0b, 0x55, 0x18, 0x14);
    FCML_I64("vfixupimmss xmm3{k3},xmm15,dword ptr [rsp+0000000000000010h],14h", 0x62, 0xf3, 0x05, 0x0b, 0x55, 0x5c, 0x24, 0x04, 0x14);

    FCML_A64("vfixupimmss $0x14,%xmm8,%xmm15,%xmm3", 0x62, 0xd3, 0x05, 0x08, 0x55, 0xd8, 0x14);
    FCML_A64("vfixupimmss $0x14,%xmm8,%xmm15,%xmm3{%k5}{z}", 0x62, 0xd3, 0x05, 0x8d, 0x55, 0xd8, 0x14);
    FCML_A64("vfixupimmss $0x14,%xmm8,%xmm15,%xmm3{%k3}", 0x62, 0xd3, 0x05, 0x0b, 0x55, 0xd8, 0x14);
    FCML_A64("vfixupimmss $0x14,{sae},%xmm8,%xmm15,%xmm3{%k3}", 0x62, 0xd3, 0x05, 0x1b, 0x55, 0xd8, 0x14);
    FCML_A64("vfixupimmss $0x14,(%rax),%xmm15,%xmm3{%k3}", 0x62, 0xf3, 0x05, 0x0b, 0x55, 0x18, 0x14);
    FCML_A64("vfixupimmss $0x14,0x0000000000000010(%rsp),%xmm15,%xmm3{%k3}", 0x62, 0xf3, 0x05, 0x0b, 0x55, 0x5c, 0x24, 0x04, 0x14);
}

void fcml_tf_instruction_VFPCLASSPD(void) {
    FCML_A64("vfpclasspd $0x12,%zmm1,%k2{%k1}", 0x62, 0xf3, 0xfd, 0x49, 0x66, 0xd1, 0x12);
    FCML_A32("vfpclasspd $0x12,%zmm1,%k1{%k2}", 0x62, 0xf3, 0xfd, 0x4a, 0x66, 0xc9, 0x12);
    FCML_A64("vfpclasspd $0x12,%zmm1,%k1{%k1}", 0x62, 0xf3, 0xfd, 0x49, 0x66, 0xc9, 0x12);

    FCML_I64("vfpclasspd k2{k1},xmm1,12h", 0x62, 0xf3, 0xfd, 0x09, 0x66, 0xd1, 0x12);
    FCML_I32("vfpclasspd k1{k2},ymm1,12h", 0x62, 0xf3, 0xfd, 0x2a, 0x66, 0xc9, 0x12);
    FCML_I64("vfpclasspd k1{k1},zmm1,12h", 0x62, 0xf3, 0xfd, 0x49, 0x66, 0xc9, 0x12);

    FCML_I64("vfpclasspd k2,xmm1,12h", 0x62, 0xf3, 0xfd, 0x08, 0x66, 0xd1, 0x12);
    FCML_I32("vfpclasspd k1,ymm1,12h", 0x62, 0xf3, 0xfd, 0x28, 0x66, 0xc9, 0x12);
    FCML_I64("vfpclasspd k1,zmm1,12h", 0x62, 0xf3, 0xfd, 0x48, 0x66, 0xc9, 0x12);

    FCML_I64("vfpclasspd k2{k1},xmmword ptr [rsp+0000000000000010h],12h", 0x62, 0xf3, 0xfd, 0x09, 0x66, 0x54, 0x24, 0x01, 0x12);
    FCML_I32("vfpclasspd k1{k2},ymmword ptr [esp+00000010h],12h", 0x62, 0xf3, 0xfd, 0x2a, 0x66, 0x8c, 0x24, 0x10, 0x00, 0x00, 0x00, 0x12);
    FCML_I64("vfpclasspd k1{k1},zmmword ptr [rsp+0000000000000010h],12h", 0x62, 0xf3, 0xfd, 0x49, 0x66, 0x8c, 0x24, 0x10, 0x00, 0x00, 0x00, 0x12);

    FCML_I64("vfpclasspd k2{k1},mmword ptr [rsp+0000000000000010h]{1to8},12h", 0x62, 0xf3, 0xfd, 0x59, 0x66, 0x54, 0x24, 0x02, 0x12);
}

void fcml_tf_instruction_VFPCLASSPS(void) {
    FCML_A64("vfpclassps $0x12,%zmm1,%k2{%k1}", 0x62, 0xf3, 0x7d, 0x49, 0x66, 0xd1, 0x12);
    FCML_A32("vfpclassps $0x12,%zmm1,%k1{%k2}", 0x62, 0xf3, 0x7d, 0x4a, 0x66, 0xc9, 0x12);
    FCML_A64("vfpclassps $0x12,%zmm1,%k1{%k1}", 0x62, 0xf3, 0x7d, 0x49, 0x66, 0xc9, 0x12);

    FCML_I64("vfpclassps k2{k1},xmm1,12h", 0x62, 0xf3, 0x7d, 0x09, 0x66, 0xd1, 0x12);
    FCML_I32("vfpclassps k1{k2},ymm1,12h", 0x62, 0xf3, 0x7d, 0x2a, 0x66, 0xc9, 0x12);
    FCML_I64("vfpclassps k1{k1},zmm1,12h", 0x62, 0xf3, 0x7d, 0x49, 0x66, 0xc9, 0x12);

    FCML_I64("vfpclassps k2,xmm1,12h", 0x62, 0xf3, 0x7d, 0x08, 0x66, 0xd1, 0x12);
    FCML_I32("vfpclassps k1,ymm1,12h", 0x62, 0xf3, 0x7d, 0x28, 0x66, 0xc9, 0x12);
    FCML_I64("vfpclassps k1,zmm1,12h", 0x62, 0xf3, 0x7d, 0x48, 0x66, 0xc9, 0x12);

    FCML_I64("vfpclassps k2{k1},xmmword ptr [rsp+0000000000000010h],12h", 0x62, 0xf3, 0x7d, 0x09, 0x66, 0x54, 0x24, 0x01, 0x12);
    FCML_I32("vfpclassps k1{k2},ymmword ptr [esp+00000010h],12h", 0x62, 0xf3, 0x7d, 0x2a, 0x66, 0x8c, 0x24, 0x10, 0x00, 0x00, 0x00, 0x12);
    FCML_I64("vfpclassps k1{k1},zmmword ptr [rsp+0000000000000010h],12h", 0x62, 0xf3, 0x7d, 0x49, 0x66, 0x8c, 0x24, 0x10, 0x00, 0x00, 0x00, 0x12);
    FCML_I64("vfpclassps k2{k1},dword ptr [rsp+0000000000000010h]{1to4},12h", 0x62, 0xf3, 0x7d, 0x19, 0x66, 0x54, 0x24, 0x04, 0x12);
}

void fcml_tf_instruction_VFPCLASSSD(void) {
    FCML_A64("vfpclasssd $0x12,%xmm1,%k2{%k1}", 0x62, 0xf2, 0xfd, 0x09, 0x67, 0xd1, 0x12);
    FCML_A32("vfpclasssd $0x12,%xmm1,%k1{%k2}", 0x62, 0xf2, 0xfd, 0x0a, 0x67, 0xc9, 0x12);
    FCML_I64("vfpclasssd k2{k1},xmm1,12h", 0x62, 0xf2, 0xfd, 0x09, 0x67, 0xd1, 0x12);
    FCML_I64("vfpclasssd k3{k4},xmm1,12h", 0x62, 0xf2, 0xfd, 0x0c, 0x67, 0xd9, 0x12);
    FCML_I64("vfpclasssd k2,xmm1,12h", 0x62, 0xf2, 0xfd, 0x08, 0x67, 0xd1, 0x12);
    FCML_I64("vfpclasssd k2{k1},mmword ptr [rsp+0000000000000010h],12h", 0x62, 0xf2, 0xfd, 0x09, 0x67, 0x54, 0x24, 0x02, 0x12);
}

void fcml_tf_instruction_VFPCLASSSS(void) {
    FCML_A64("vfpclassss $0x12,%xmm1,%k2{%k1}", 0x62, 0xf2, 0x7d, 0x09, 0x67, 0xd1, 0x12);
    FCML_A32("vfpclassss $0x12,%xmm1,%k1{%k2}", 0x62, 0xf2, 0x7d, 0x0a, 0x67, 0xc9, 0x12);
    FCML_I64("vfpclassss k2{k1},xmm1,12h", 0x62, 0xf2, 0x7d, 0x09, 0x67, 0xd1, 0x12);
    FCML_I64("vfpclassss k3{k4},xmm1,12h", 0x62, 0xf2, 0x7d, 0x0c, 0x67, 0xd9, 0x12);
    FCML_I64("vfpclassss k2,xmm1,12h", 0x62, 0xf2, 0x7d, 0x08, 0x67, 0xd1, 0x12);
    FCML_I64("vfpclassss k2{k1},dword ptr [rsp+0000000000000010h],12h", 0x62, 0xf2, 0x7d, 0x09, 0x67, 0x54, 0x24, 0x04, 0x12);
}

void fcml_tf_instruction_VGETEXPPD(void) {
    FCML_I64("vgetexppd xmm3,xmm0", 0x62, 0xf2, 0xfd, 0x08, 0x42, 0xd8);
    FCML_I32("vgetexppd xmm3,xmm0", 0x62, 0xf2, 0xfd, 0x08, 0x42, 0xd8);
    FCML_I32("vgetexppd ymm0,ymmword ptr [eax]", 0x62, 0xf2, 0xfd, 0x28, 0x42, 0x00);
    FCML_A64("vgetexppd %xmm0,%xmm3", 0x62, 0xf2, 0xfd, 0x08, 0x42, 0xd8);
    FCML_A64("vgetexppd %xmm0,%xmm3", 0x62, 0xf2, 0xfd, 0x08, 0x42, 0xd8);
    FCML_I64("vgetexppd ymm10{k1},ymmword ptr [r9+r8]", 0x62, 0x12, 0xfd, 0x29, 0x42, 0x14, 0x01);
    FCML_A64("vgetexppd (%r9,%r8),%ymm10{%k1}", 0x62, 0x12, 0xfd, 0x29, 0x42, 0x14, 0x01);
    FCML_I64("vgetexppd xmm10{k1},xmmword ptr [r9+r8]", 0x62, 0x12, 0xfd, 0x09, 0x42, 0x14, 0x01);
    FCML_A64("vgetexppd (%r9,%r8),%xmm10{%k1}", 0x62, 0x12, 0xfd, 0x09, 0x42, 0x14, 0x01);
    FCML_I64("vgetexppd zmm1{k1},zmmword ptr [r9+r8]", 0x62, 0x92, 0xfd, 0x49, 0x42, 0x0c, 0x01);
    FCML_A64("vgetexppd (%r9,%r8),%zmm1{%k1}", 0x62, 0x92, 0xfd, 0x49, 0x42, 0x0c, 0x01);
    FCML_I64("vgetexppd ymm10{k1}{z},ymmword ptr [r9+r8]", 0x62, 0x12, 0xfd, 0xa9, 0x42, 0x14, 0x01);
    FCML_I64("vgetexppd zmm31,mmword ptr [rsi]{1to8}", 0x62, 0x62, 0xfd, 0x58, 0x42, 0x3e);
    FCML_I64("vgetexppd ymm31{k7}{z},mmword ptr [rsi]{1to4}", 0x62, 0x62, 0xfd, 0xbf, 0x42, 0x3e);
    FCML_A64("vgetexppd (%rsi){1to4},%ymm31{%k7}{z}", 0x62, 0x62, 0xfd, 0xbf, 0x42, 0x3e);
    FCML_I64("vgetexppd zmm31{k7}{z},zmm4,{sae}", 0x62, 0x62, 0xfd, 0x9f, 0x42, 0xfc);
    FCML_I64("vgetexppd xmm1{k4}{z},mmword ptr [rsp+0000000000000020h]{1to2}", 0x62, 0xf2, 0xfd, 0x9c, 0x42, 0x4c, 0x24, 0x04);
    FCML_I64("vgetexppd xmm1{k4}{z},mmword ptr [rsp+00000000000001d0h]{1to2}", 0x62, 0xf2, 0xfd, 0x9c, 0x42, 0x4c, 0x24, 0x3a);
    FCML_I32("vgetexppd xmm1{k4}{z},mmword ptr [esp+00000020h]{1to2}", 0x62, 0xf2, 0xfd, 0x9c, 0x42, 0x4c, 0x24, 0x04);
}

void fcml_tf_instruction_VGETEXPPS(void) {
    FCML_I64("vgetexpps xmm3,xmm0", 0x62, 0xf2, 0x7d, 0x08, 0x42, 0xd8);
    FCML_I32("vgetexpps xmm3,xmm0", 0x62, 0xf2, 0x7d, 0x08, 0x42, 0xd8);
    FCML_I32("vgetexpps ymm0,ymmword ptr [eax]", 0x62, 0xf2, 0x7d, 0x28, 0x42, 0x00);
    FCML_A64("vgetexpps %xmm0,%xmm3", 0x62, 0xf2, 0x7d, 0x08, 0x42, 0xd8);
    FCML_A64("vgetexpps %xmm0,%xmm3", 0x62, 0xf2, 0x7d, 0x08, 0x42, 0xd8);
    FCML_I64("vgetexpps ymm10{k1},ymmword ptr [r9+r8]", 0x62, 0x12, 0x7d, 0x29, 0x42, 0x14, 0x01);
    FCML_A64("vgetexpps (%r9,%r8),%ymm10{%k1}", 0x62, 0x12, 0x7d, 0x29, 0x42, 0x14, 0x01);
    FCML_I64("vgetexpps xmm10{k1},xmmword ptr [r9+r8]", 0x62, 0x12, 0x7d, 0x09, 0x42, 0x14, 0x01);
    FCML_A64("vgetexpps (%r9,%r8),%xmm10{%k1}", 0x62, 0x12, 0x7d, 0x09, 0x42, 0x14, 0x01);
    FCML_I64("vgetexpps zmm1{k1},zmmword ptr [r9+r8]", 0x62, 0x92, 0x7d, 0x49, 0x42, 0x0c, 0x01);
    FCML_A64("vgetexpps (%r9,%r8),%zmm1{%k1}", 0x62, 0x92, 0x7d, 0x49, 0x42, 0x0c, 0x01);
    FCML_I64("vgetexpps ymm10{k1}{z},ymmword ptr [r9+r8]", 0x62, 0x12, 0x7d, 0xa9, 0x42, 0x14, 0x01);
    FCML_I64("vgetexpps zmm31,dword ptr [rsi]{1to16}", 0x62, 0x62, 0x7d, 0x58, 0x42, 0x3e);
    FCML_I64("vgetexpps ymm31{k7}{z},dword ptr [rsi]{1to8}", 0x62, 0x62, 0x7d, 0xbf, 0x42, 0x3e);
    FCML_I64("vgetexpps zmm31{k7}{z},zmm4,{sae}", 0x62, 0x62, 0x7d, 0x9f, 0x42, 0xfc);
    FCML_I64("vgetexpps xmm1{k4}{z},dword ptr [rsp+0000000000000020h]{1to4}", 0x62, 0xf2, 0x7d, 0x9c, 0x42, 0x4c, 0x24, 0x08);
    FCML_I64("vgetexpps xmm1{k4}{z},dword ptr [rsp+00000000000001d0h]{1to4}", 0x62, 0xf2, 0x7d, 0x9c, 0x42, 0x4c, 0x24, 0x74);
    FCML_I32("vgetexpps xmm1{k4}{z},dword ptr [esp+00000020h]{1to4}", 0x62, 0xf2, 0x7d, 0x9c, 0x42, 0x4c, 0x24, 0x08);
}

void fcml_tf_instruction_VGETEXPSD(void) {
    FCML_I64("vgetexpsd xmm3,xmm12,xmm0", 0x62, 0xf2, 0x9d, 0x08, 0x43, 0xd8);
    FCML_I32("vgetexpsd xmm3,xmm4,xmm0", 0x62, 0xf2, 0xdd, 0x08, 0x43, 0xd8);
    FCML_A64("vgetexpsd %xmm0,%xmm12,%xmm3", 0x62, 0xf2, 0x9d, 0x08, 0x43, 0xd8);
    FCML_A64("vgetexpsd %xmm0,%xmm3,%xmm3", 0x62, 0xf2, 0xe5, 0x08, 0x43, 0xd8);
    FCML_I64("vgetexpsd xmm10{k1},xmm5,mmword ptr [r9+r8]", 0x62, 0x12, 0xd5, 0x09, 0x43, 0x14, 0x01);
    FCML_A64("vgetexpsd (%r9,%r8),%xmm5,%xmm10{%k1}", 0x62, 0x12, 0xd5, 0x09, 0x43, 0x14, 0x01);
    FCML_I64("vgetexpsd xmm31{k7}{z},xmm4,xmm6,{sae}", 0x62, 0x62, 0xdd, 0x9f, 0x43, 0xfe);
}

void fcml_tf_instruction_VGETEXPSS(void) {
    FCML_I64("vgetexpss xmm3,xmm12,xmm0", 0x62, 0xf2, 0x1d, 0x08, 0x43, 0xd8);
    FCML_I32("vgetexpss xmm3,xmm4,xmm0", 0x62, 0xf2, 0x5d, 0x08, 0x43, 0xd8);
    FCML_A64("vgetexpss %xmm0,%xmm12,%xmm3", 0x62, 0xf2, 0x1d, 0x08, 0x43, 0xd8);
    FCML_A64("vgetexpss %xmm0,%xmm3,%xmm3", 0x62, 0xf2, 0x65, 0x08, 0x43, 0xd8);
    FCML_I64("vgetexpss xmm10{k1},xmm5,dword ptr [r9+r8]", 0x62, 0x12, 0x55, 0x09, 0x43, 0x14, 0x01);
    FCML_A64("vgetexpss (%r9,%r8),%xmm5,%xmm10{%k1}", 0x62, 0x12, 0x55, 0x09, 0x43, 0x14, 0x01);
    FCML_I64("vgetexpss xmm31{k7}{z},xmm4,xmm6,{sae}", 0x62, 0x62, 0x5d, 0x9f, 0x43, 0xfe);
}

void fcml_tf_instruction_VGETMANTPD(void) {
    FCML_I64("vgetmantpd xmm3,xmm0,14h", 0x62, 0xf3, 0xfd, 0x08, 0x26, 0xd8, 0x14);
    FCML_I32("vgetmantpd xmm3,xmm0,14h", 0x62, 0xf3, 0xfd, 0x08, 0x26, 0xd8, 0x14);
    FCML_I32("vgetmantpd ymm0,ymmword ptr [eax],14h", 0x62, 0xf3, 0xfd, 0x28, 0x26, 0x00, 0x14);
    FCML_A64("vgetmantpd $0x14,%xmm0,%xmm3", 0x62, 0xf3, 0xfd, 0x08, 0x26, 0xd8, 0x14);
    FCML_A64("vgetmantpd $0x14,%xmm0,%xmm3", 0x62, 0xf3, 0xfd, 0x08, 0x26, 0xd8, 0x14);
    FCML_I64("vgetmantpd ymm10{k1},ymmword ptr [r9+r8],14h", 0x62, 0x13, 0xfd, 0x29, 0x26, 0x14, 0x01, 0x14);
    FCML_A64("vgetmantpd $0x14,(%r9,%r8),%ymm10{%k1}", 0x62, 0x13, 0xfd, 0x29, 0x26, 0x14, 0x01, 0x14);
    FCML_I64("vgetmantpd xmm10{k1},xmmword ptr [r9+r8],14h", 0x62, 0x13, 0xfd, 0x09, 0x26, 0x14, 0x01, 0x14);
    FCML_A64("vgetmantpd $0x14,(%r9,%r8),%xmm10{%k1}", 0x62, 0x13, 0xfd, 0x09, 0x26, 0x14, 0x01, 0x14);
    FCML_I64("vgetmantpd zmm1{k1},zmmword ptr [r9+r8],14h", 0x62, 0x93, 0xfd, 0x49, 0x26, 0x0c, 0x01, 0x14);
    FCML_A64("vgetmantpd $0x14,(%r9,%r8),%zmm1{%k1}", 0x62, 0x93, 0xfd, 0x49, 0x26, 0x0c, 0x01, 0x14);
    FCML_I64("vgetmantpd ymm10{k1}{z},ymmword ptr [r9+r8],14h", 0x62, 0x13, 0xfd, 0xa9, 0x26, 0x14, 0x01, 0x14);
    FCML_I64("vgetmantpd zmm31,mmword ptr [rsi]{1to8},14h", 0x62, 0x63, 0xfd, 0x58, 0x26, 0x3e, 0x14);
    FCML_I64("vgetmantpd ymm31{k7}{z},mmword ptr [rsi]{1to4},14h", 0x62, 0x63, 0xfd, 0xbf, 0x26, 0x3e, 0x14);
    FCML_A64("vgetmantpd $0x14,(%rsi){1to4},%ymm31{%k7}{z}", 0x62, 0x63, 0xfd, 0xbf, 0x26, 0x3e, 0x14);
    FCML_I64("vgetmantpd zmm31{k7}{z},zmm4,{sae},14h", 0x62, 0x63, 0xfd, 0x9f, 0x26, 0xfc, 0x14);
    FCML_I64("vgetmantpd xmm1{k4}{z},mmword ptr [rsp+0000000000000020h]{1to2},14h", 0x62, 0xf3, 0xfd, 0x9c, 0x26, 0x4c, 0x24, 0x04, 0x14);
    FCML_I64("vgetmantpd xmm1{k4}{z},mmword ptr [rsp+00000000000001d0h]{1to2},14h", 0x62, 0xf3, 0xfd, 0x9c, 0x26, 0x4c, 0x24, 0x3a, 0x14);
    FCML_I32("vgetmantpd xmm1{k4}{z},mmword ptr [esp+00000020h]{1to2},14h", 0x62, 0xf3, 0xfd, 0x9c, 0x26, 0x4c, 0x24, 0x04, 0x14);
}

void fcml_tf_instruction_VGETMANTPS(void) {
    FCML_I64("vgetmantps xmm3,xmm0,14h", 0x62, 0xf3, 0x7d, 0x08, 0x26, 0xd8, 0x14);
    FCML_I32("vgetmantps xmm3,xmm0,14h", 0x62, 0xf3, 0x7d, 0x08, 0x26, 0xd8, 0x14);
    FCML_I32("vgetmantps ymm0,ymmword ptr [eax],14h", 0x62, 0xf3, 0x7d, 0x28, 0x26, 0x00, 0x14);
    FCML_A64("vgetmantps $0x14,%xmm0,%xmm3", 0x62, 0xf3, 0x7d, 0x08, 0x26, 0xd8, 0x14);
    FCML_A64("vgetmantps $0x14,%xmm0,%xmm3", 0x62, 0xf3, 0x7d, 0x08, 0x26, 0xd8, 0x14);
    FCML_I64("vgetmantps ymm10{k1},ymmword ptr [r9+r8],14h", 0x62, 0x13, 0x7d, 0x29, 0x26, 0x14, 0x01, 0x14);
    FCML_A64("vgetmantps $0x14,(%r9,%r8),%ymm10{%k1}", 0x62, 0x13, 0x7d, 0x29, 0x26, 0x14, 0x01, 0x14);
    FCML_I64("vgetmantps xmm10{k1},xmmword ptr [r9+r8],14h", 0x62, 0x13, 0x7d, 0x09, 0x26, 0x14, 0x01, 0x14);
    FCML_A64("vgetmantps $0x14,(%r9,%r8),%xmm10{%k1}", 0x62, 0x13, 0x7d, 0x09, 0x26, 0x14, 0x01, 0x14);
    FCML_I64("vgetmantps zmm1{k1},zmmword ptr [r9+r8],14h", 0x62, 0x93, 0x7d, 0x49, 0x26, 0x0c, 0x01, 0x14);
    FCML_A64("vgetmantps $0x14,(%r9,%r8),%zmm1{%k1}", 0x62, 0x93, 0x7d, 0x49, 0x26, 0x0c, 0x01, 0x14);
    FCML_I64("vgetmantps ymm10{k1}{z},ymmword ptr [r9+r8],14h", 0x62, 0x13, 0x7d, 0xa9, 0x26, 0x14, 0x01, 0x14);
    FCML_I64("vgetmantps zmm31,dword ptr [rsi]{1to16},14h", 0x62, 0x63, 0x7d, 0x58, 0x26, 0x3e, 0x14);
    FCML_I64("vgetmantps ymm31{k7}{z},dword ptr [rsi]{1to8},14h", 0x62, 0x63, 0x7d, 0xbf, 0x26, 0x3e, 0x14);
    FCML_I64("vgetmantps zmm31{k7}{z},zmm4,{sae},14h", 0x62, 0x63, 0x7d, 0x9f, 0x26, 0xfc, 0x14);
    FCML_I64("vgetmantps xmm1{k4}{z},dword ptr [rsp+0000000000000020h]{1to4},14h", 0x62, 0xf3, 0x7d, 0x9c, 0x26, 0x4c, 0x24, 0x08, 0x14);
    FCML_I64("vgetmantps xmm1{k4}{z},dword ptr [rsp+00000000000001d0h]{1to4},14h", 0x62, 0xf3, 0x7d, 0x9c, 0x26, 0x4c, 0x24, 0x74, 0x14);
    FCML_I32("vgetmantps xmm1{k4}{z},dword ptr [esp+00000020h]{1to4},14h", 0x62, 0xf3, 0x7d, 0x9c, 0x26, 0x4c, 0x24, 0x08, 0x14);
}

void fcml_tf_instruction_VGETMANTSD(void) {
    FCML_I64("vgetmantsd xmm3,xmm12,xmm0,14h", 0x62, 0xf3, 0x9d, 0x08, 0x27, 0xd8, 0x14);
    FCML_I32("vgetmantsd xmm3,xmm4,xmm0,14h", 0x62, 0xf3, 0xdd, 0x08, 0x27, 0xd8, 0x14);
    FCML_A64("vgetmantsd $0x14,%xmm0,%xmm12,%xmm3", 0x62, 0xf3, 0x9d, 0x08, 0x27, 0xd8, 0x14);
    FCML_A64("vgetmantsd $0x14,%xmm0,%xmm3,%xmm3", 0x62, 0xf3, 0xe5, 0x08, 0x27, 0xd8, 0x14);
    FCML_I64("vgetmantsd xmm10{k1},xmm5,mmword ptr [r9+r8],14h", 0x62, 0x13, 0xd5, 0x09, 0x27, 0x14, 0x01, 0x14);
    FCML_A64("vgetmantsd $0x14,(%r9,%r8),%xmm5,%xmm10{%k1}", 0x62, 0x13, 0xd5, 0x09, 0x27, 0x14, 0x01, 0x14);
    FCML_I64("vgetmantsd xmm31{k7}{z},xmm4,xmm6,{sae},14h", 0x62, 0x63, 0xdd, 0x9f, 0x27, 0xfe, 0x14);
}

void fcml_tf_instruction_VGETMANTSS(void) {
    FCML_I64("vgetmantss xmm3,xmm12,xmm0,14h", 0x62, 0xf3, 0x1d, 0x08, 0x27, 0xd8, 0x14);
    FCML_I32("vgetmantss xmm3,xmm4,xmm0,14h", 0x62, 0xf3, 0x5d, 0x08, 0x27, 0xd8, 0x14);
    FCML_A64("vgetmantss $0x14,%xmm0,%xmm12,%xmm3", 0x62, 0xf3, 0x1d, 0x08, 0x27, 0xd8, 0x14);
    FCML_A64("vgetmantss $0x14,%xmm0,%xmm3,%xmm3", 0x62, 0xf3, 0x65, 0x08, 0x27, 0xd8, 0x14);
    FCML_I64("vgetmantss xmm10{k1},xmm5,dword ptr [r9+r8],14h", 0x62, 0x13, 0x55, 0x09, 0x27, 0x14, 0x01, 0x14);
    FCML_A64("vgetmantss $0x14,(%r9,%r8),%xmm5,%xmm10{%k1}", 0x62, 0x13, 0x55, 0x09, 0x27, 0x14, 0x01, 0x14);
    FCML_I64("vgetmantss xmm31{k7}{z},xmm4,xmm6,{sae},14h", 0x62, 0x63, 0x5d, 0x9f, 0x27, 0xfe, 0x14);
}

void fcml_tf_instruction_VINSERTF32X4(void) {
    FCML_I64("vinsertf32x4 ymm3,ymm12,xmm0,14h", 0x62, 0xf3, 0x1d, 0x28, 0x18, 0xd8, 0x14);
    FCML_I64("vinsertf32x4 ymm3{k2},ymm12,xmm0,14h", 0x62, 0xf3, 0x1d, 0x2a, 0x18, 0xd8, 0x14);
    FCML_I64("vinsertf32x4 ymm3{k2}{z},ymm12,xmm0,14h", 0x62, 0xf3, 0x1d, 0xaa, 0x18, 0xd8, 0x14);
    FCML_I64("vinsertf32x4 ymm3{k2}{z},ymm12,xmmword ptr [r9+r8],14h", 0x62, 0x93, 0x1d, 0xaa, 0x18, 0x1c, 0x01, 0x14);
    FCML_I64("vinsertf32x4 zmm3,zmm12,xmm0,14h", 0x62, 0xf3, 0x1d, 0x48, 0x18, 0xd8, 0x14);
    FCML_I64("vinsertf32x4 zmm3{k2},zmm12,xmm0,14h", 0x62, 0xf3, 0x1d, 0x4a, 0x18, 0xd8, 0x14);
    FCML_I64("vinsertf32x4 zmm3{k2}{z},zmm12,xmm0,14h", 0x62, 0xf3, 0x1d, 0xca, 0x18, 0xd8, 0x14);
    FCML_I64("vinsertf32x4 zmm3{k2}{z},zmm12,xmmword ptr [r9+r8],14h", 0x62, 0x93, 0x1d, 0xca, 0x18, 0x1c, 0x01, 0x14);
    FCML_I64("vinsertf32x4 zmm3{k2}{z},zmm12,xmmword ptr [rsp+00000000000001d0h],14h", 0x62, 0xf3, 0x1d, 0xca, 0x18, 0x5c, 0x24, 0x1d, 0x14);
    FCML_I64("vinsertf32x4 ymm3{k2}{z},ymm12,xmmword ptr [rsp+00000000000001d0h],14h", 0x62, 0xf3, 0x1d, 0xaa, 0x18, 0x5c, 0x24, 0x1d, 0x14);

    FCML_I64_A_FAILED("vinsertf32x4 ymm3{k2},ymm12,ymm0,14h", 0x62, 0xf3, 0x1d, 0x2a, 0x18, 0xd8, 0x14);
    FCML_I64_A_FAILED("vinsertf32x4 zmm3{k2}{z},zmm12,ymmword ptr [r9+r8],14h", 0x62, 0x93, 0x1d, 0xca, 0x18, 0x1c, 0x01, 0x14);
    FCML_I64_A_FAILED("vinsertf32x4 zmm3{k2}{z},zmm12,ymm0,14h", 0x62, 0xf3, 0x1d, 0xca, 0x18, 0xd8, 0x14);
}

void fcml_tf_instruction_VINSERTF64X2(void) {
    FCML_I64("vinsertf64x2 ymm3,ymm12,xmm0,14h", 0x62, 0xf3, 0x9d, 0x28, 0x18, 0xd8, 0x14);
    FCML_I64("vinsertf64x2 ymm3{k2},ymm12,xmm0,14h", 0x62, 0xf3, 0x9d, 0x2a, 0x18, 0xd8, 0x14);
    FCML_I64("vinsertf64x2 ymm3{k2}{z},ymm12,xmm0,14h", 0x62, 0xf3, 0x9d, 0xaa, 0x18, 0xd8, 0x14);
    FCML_I64("vinsertf64x2 ymm3{k2}{z},ymm12,xmmword ptr [r9+r8],14h", 0x62, 0x93, 0x9d, 0xaa, 0x18, 0x1c, 0x01, 0x14);
    FCML_I64("vinsertf64x2 zmm3,zmm12,xmm0,14h", 0x62, 0xf3, 0x9d, 0x48, 0x18, 0xd8, 0x14);
    FCML_I64("vinsertf64x2 zmm3{k2},zmm12,xmm0,14h", 0x62, 0xf3, 0x9d, 0x4a, 0x18, 0xd8, 0x14);
    FCML_I64("vinsertf64x2 zmm3{k2}{z},zmm12,xmm0,14h", 0x62, 0xf3, 0x9d, 0xca, 0x18, 0xd8, 0x14);
    FCML_I64("vinsertf64x2 zmm3{k2}{z},zmm12,xmmword ptr [r9+r8],14h", 0x62, 0x93, 0x9d, 0xca, 0x18, 0x1c, 0x01, 0x14);
    FCML_I64("vinsertf64x2 zmm3{k2}{z},zmm12,xmmword ptr [rsp+00000000000003a0h],14h", 0x62, 0xf3, 0x9d, 0xca, 0x18, 0x5c, 0x24, 0x3a, 0x14);
    FCML_I64("vinsertf64x2 ymm3{k2}{z},ymm12,xmmword ptr [rsp+00000000000003a0h],14h", 0x62, 0xf3, 0x9d, 0xaa, 0x18, 0x5c, 0x24, 0x3a, 0x14);

    FCML_I64_A_FAILED("vinsertf64x2 ymm3{k2},ymm12,ymm0,14h", 0x62, 0xf3, 0x9D, 0x2a, 0x18, 0xd8, 0x14);
    FCML_I64_A_FAILED("vinsertf64x2 zmm3{k2}{z},zmm12,ymmword ptr [r9+r8],14h", 0x62, 0x93, 0x9D, 0xca, 0x18, 0x1c, 0x01, 0x14);
    FCML_I64_A_FAILED("vinsertf64x2 zmm3{k2}{z},zmm12,ymm0,14h", 0x62, 0xf3, 0x9D, 0xca, 0x18, 0xd8, 0x14);
}

void fcml_tf_instruction_VINSERTF32X8(void) {
    FCML_I64("vinsertf32x8 zmm3,zmm12,ymm0,14h", 0x62, 0xf3, 0x1d, 0x48, 0x1a, 0xd8, 0x14);
    FCML_I64("vinsertf32x8 zmm3{k2},zmm12,ymm0,14h", 0x62, 0xf3, 0x1d, 0x4a, 0x1a, 0xd8, 0x14);
    FCML_I64("vinsertf32x8 zmm3{k2}{z},zmm12,ymm0,14h", 0x62, 0xf3, 0x1d, 0xca, 0x1a, 0xd8, 0x14);
    FCML_I64("vinsertf32x8 zmm3{k2}{z},zmm12,ymmword ptr [r9+r8],14h", 0x62, 0x93, 0x1d, 0xca, 0x1a, 0x1c, 0x01, 0x14);
    FCML_I64("vinsertf32x8 zmm3{k2}{z},zmm12,ymmword ptr [rsp+00000000000001d0h],14h", 0x62, 0xf3, 0x1d, 0xca, 0x1a, 0x9c, 0x24, 0xd0, 0x01, 0x00, 0x00, 0x14);

    FCML_I64_A_FAILED("vinsertf32x8 zmm3{k2}{z},zmm12,xmmword ptr [r9+r8],14h", 0x62, 0x93, 0x1d, 0xca, 0x1a, 0x1c, 0x01, 0x14);
    FCML_I64_A_FAILED("vinsertf32x8 zmm3{k2}{z},zmm12,zmm0,14h", 0x62, 0xf3, 0x1d, 0xca, 0x1a, 0xd8, 0x14);
}

void fcml_tf_instruction_VINSERTF64X4(void) {
    FCML_I64("vinsertf64x4 zmm3,zmm12,ymm0,14h", 0x62, 0xf3, 0x9d, 0x48, 0x1a, 0xd8, 0x14);
    FCML_I64("vinsertf64x4 zmm3{k2},zmm12,ymm0,14h", 0x62, 0xf3, 0x9d, 0x4a, 0x1a, 0xd8, 0x14);
    FCML_I64("vinsertf64x4 zmm3{k2}{z},zmm12,ymm0,14h", 0x62, 0xf3, 0x9d, 0xca, 0x1a, 0xd8, 0x14);
    FCML_I64("vinsertf64x4 zmm3{k2}{z},zmm12,ymmword ptr [r9+r8],14h", 0x62, 0x93, 0x9d, 0xca, 0x1a, 0x1c, 0x01, 0x14);
    FCML_I64("vinsertf64x4 zmm3{k2}{z},zmm12,ymmword ptr [rsp+00000000000003a0h],14h", 0x62, 0xf3, 0x9d, 0xca, 0x1a, 0x5c, 0x24, 0x1d, 0x14);

    FCML_I64_A_FAILED("vinsertf64x4 zmm3{k2}{z},zmm12,xmmword ptr [r9+r8],14h", 0x62, 0x93, 0x9D, 0xca, 0x1a, 0x1c, 0x01, 0x14);
    FCML_I64_A_FAILED("vinsertf64x4 zmm3{k2}{z},zmm12,zmm0,14h", 0x62, 0xf3, 0x9D, 0xca, 0x1a, 0xd8, 0x14);
}

void fcml_tf_instruction_VINSERTI32X4(void) {
    FCML_I64("vinserti32x4 ymm3,ymm12,xmm0,14h", 0x62, 0xf3, 0x1d, 0x28, 0x38, 0xd8, 0x14);
    FCML_I64("vinserti32x4 ymm3{k2},ymm12,xmm0,14h", 0x62, 0xf3, 0x1d, 0x2a, 0x38, 0xd8, 0x14);
    FCML_I64("vinserti32x4 ymm3{k2}{z},ymm12,xmm0,14h", 0x62, 0xf3, 0x1d, 0xaa, 0x38, 0xd8, 0x14);
    FCML_I64("vinserti32x4 ymm3{k2}{z},ymm12,xmmword ptr [r9+r8],14h", 0x62, 0x93, 0x1d, 0xaa, 0x38, 0x1c, 0x01, 0x14);
    FCML_I64("vinserti32x4 zmm3,zmm12,xmm0,14h", 0x62, 0xf3, 0x1d, 0x48, 0x38, 0xd8, 0x14);
    FCML_I64("vinserti32x4 zmm3{k2},zmm12,xmm0,14h", 0x62, 0xf3, 0x1d, 0x4a, 0x38, 0xd8, 0x14);
    FCML_I64("vinserti32x4 zmm3{k2}{z},zmm12,xmm0,14h", 0x62, 0xf3, 0x1d, 0xca, 0x38, 0xd8, 0x14);
    FCML_I64("vinserti32x4 zmm3{k2}{z},zmm12,xmmword ptr [r9+r8],14h", 0x62, 0x93, 0x1d, 0xca, 0x38, 0x1c, 0x01, 0x14);
    FCML_I64("vinserti32x4 zmm3{k2}{z},zmm12,xmmword ptr [rsp+00000000000001d0h],14h", 0x62, 0xf3, 0x1d, 0xca, 0x38, 0x5c, 0x24, 0x1d, 0x14);
    FCML_I64("vinserti32x4 ymm3{k2}{z},ymm12,xmmword ptr [rsp+00000000000001d0h],14h", 0x62, 0xf3, 0x1d, 0xaa, 0x38, 0x5c, 0x24, 0x1d, 0x14);

    FCML_I64_A_FAILED("vinserti32x4 ymm3{k2},ymm12,ymm0,14h", 0x62, 0xf3, 0x1d, 0x2a, 0x38, 0xd8, 0x14);
    FCML_I64_A_FAILED("vinserti32x4 zmm3{k2}{z},zmm12,ymmword ptr [r9+r8],14h", 0x62, 0x93, 0x1d, 0xca, 0x38, 0x1c, 0x01, 0x14);
    FCML_I64_A_FAILED("vinserti32x4 zmm3{k2}{z},zmm12,ymm0,14h", 0x62, 0xf3, 0x1d, 0xca, 0x38, 0xd8, 0x14);
}

void fcml_tf_instruction_VINSERTI64X2(void) {
    FCML_I64("vinserti64x2 ymm3,ymm12,xmm0,14h", 0x62, 0xf3, 0x9d, 0x28, 0x38, 0xd8, 0x14);
    FCML_I64("vinserti64x2 ymm3{k2},ymm12,xmm0,14h", 0x62, 0xf3, 0x9d, 0x2a, 0x38, 0xd8, 0x14);
    FCML_I64("vinserti64x2 ymm3{k2}{z},ymm12,xmm0,14h", 0x62, 0xf3, 0x9d, 0xaa, 0x38, 0xd8, 0x14);
    FCML_I64("vinserti64x2 ymm3{k2}{z},ymm12,xmmword ptr [r9+r8],14h", 0x62, 0x93, 0x9d, 0xaa, 0x38, 0x1c, 0x01, 0x14);
    FCML_I64("vinserti64x2 zmm3,zmm12,xmm0,14h", 0x62, 0xf3, 0x9d, 0x48, 0x38, 0xd8, 0x14);
    FCML_I64("vinserti64x2 zmm3{k2},zmm12,xmm0,14h", 0x62, 0xf3, 0x9d, 0x4a, 0x38, 0xd8, 0x14);
    FCML_I64("vinserti64x2 zmm3{k2}{z},zmm12,xmm0,14h", 0x62, 0xf3, 0x9d, 0xca, 0x38, 0xd8, 0x14);
    FCML_I64("vinserti64x2 zmm3{k2}{z},zmm12,xmmword ptr [r9+r8],14h", 0x62, 0x93, 0x9d, 0xca, 0x38, 0x1c, 0x01, 0x14);
    FCML_I64("vinserti64x2 zmm3{k2}{z},zmm12,xmmword ptr [rsp+00000000000003a0h],14h", 0x62, 0xf3, 0x9d, 0xca, 0x38, 0x5c, 0x24, 0x3a, 0x14);
    FCML_I64("vinserti64x2 ymm3{k2}{z},ymm12,xmmword ptr [rsp+00000000000003a0h],14h", 0x62, 0xf3, 0x9d, 0xaa, 0x38, 0x5c, 0x24, 0x3a, 0x14);

    FCML_I64_A_FAILED("vinserti64x2 ymm3{k2},ymm12,ymm0,14h", 0x62, 0xf3, 0x9D, 0x2a, 0x38, 0xd8, 0x14);
    FCML_I64_A_FAILED("vinserti64x2 zmm3{k2}{z},zmm12,ymmword ptr [r9+r8],14h", 0x62, 0x93, 0x9D, 0xca, 0x38, 0x1c, 0x01, 0x14);
    FCML_I64_A_FAILED("vinserti64x2 zmm3{k2}{z},zmm12,ymm0,14h", 0x62, 0xf3, 0x9D, 0xca, 0x38, 0xd8, 0x14);
}

void fcml_tf_instruction_VINSERTI32X8(void) {
    FCML_I64("vinserti32x8 zmm3,zmm12,ymm0,14h", 0x62, 0xf3, 0x1d, 0x48, 0x3a, 0xd8, 0x14);
    FCML_I64("vinserti32x8 zmm3{k2},zmm12,ymm0,14h", 0x62, 0xf3, 0x1d, 0x4a, 0x3a, 0xd8, 0x14);
    FCML_I64("vinserti32x8 zmm3{k2}{z},zmm12,ymm0,14h", 0x62, 0xf3, 0x1d, 0xca, 0x3a, 0xd8, 0x14);
    FCML_I64("vinserti32x8 zmm3{k2}{z},zmm12,ymmword ptr [r9+r8],14h", 0x62, 0x93, 0x1d, 0xca, 0x3a, 0x1c, 0x01, 0x14);
    FCML_I64("vinserti32x8 zmm3{k2}{z},zmm12,ymmword ptr [rsp+00000000000001d0h],14h", 0x62, 0xf3, 0x1d, 0xca, 0x3a, 0x9c, 0x24, 0xd0, 0x01, 0x00, 0x00, 0x14);

    FCML_I64_A_FAILED("vinserti32x8 zmm3{k2}{z},zmm12,xmmword ptr [r9+r8],14h", 0x62, 0x93, 0x1d, 0xca, 0x3a, 0x1c, 0x01, 0x14);
    FCML_I64_A_FAILED("vinserti32x8 zmm3{k2}{z},zmm12,zmm0,14h", 0x62, 0xf3, 0x1d, 0xca, 0x3a, 0xd8, 0x14);
}

void fcml_tf_instruction_VINSERTI64X4(void) {
    FCML_I64("vinserti64x4 zmm3,zmm12,ymm0,14h", 0x62, 0xf3, 0x9d, 0x48, 0x3a, 0xd8, 0x14);
    FCML_I64("vinserti64x4 zmm3{k2},zmm12,ymm0,14h", 0x62, 0xf3, 0x9d, 0x4a, 0x3a, 0xd8, 0x14);
    FCML_I64("vinserti64x4 zmm3{k2}{z},zmm12,ymm0,14h", 0x62, 0xf3, 0x9d, 0xca, 0x3a, 0xd8, 0x14);
    FCML_I64("vinserti64x4 zmm3{k2}{z},zmm12,ymmword ptr [r9+r8],14h", 0x62, 0x93, 0x9d, 0xca, 0x3a, 0x1c, 0x01, 0x14);
    FCML_I64("vinserti64x4 zmm3{k2}{z},zmm12,ymmword ptr [rsp+00000000000003a0h],14h", 0x62, 0xf3, 0x9d, 0xca, 0x3a, 0x5c, 0x24, 0x1d, 0x14);

    FCML_I64_A_FAILED("vinserti64x4 zmm3{k2}{z},zmm12,xmmword ptr [r9+r8],14h", 0x62, 0x93, 0x9D, 0xca, 0x3a, 0x1c, 0x01, 0x14);
    FCML_I64_A_FAILED("vinserti64x4 zmm3{k2}{z},zmm12,zmm0,14h", 0x62, 0xf3, 0x9D, 0xca, 0x3a, 0xd8, 0x14);
}

void fcml_tf_instruction_VPBLENDMB(void) {
    /* xmm1, xmm2, m128 */
    FCML_A64("vpblendmb (%rax),%xmm7,%xmm15", 0x62, 0x72, 0x45, 0x08, 0x66, 0x38);
    FCML_I64("vpblendmb xmm15,xmm7,xmmword ptr [rax]", 0x62, 0x72, 0x45, 0x08, 0x66, 0x38);
    FCML_A32("vpblendmb (%eax),%xmm6,%xmm7", 0x62, 0xf2, 0x4d, 0x08, 0x66, 0x38);
    FCML_I32("vpblendmb xmm7,xmm6,xmmword ptr [eax]", 0x62, 0xf2, 0x4d, 0x08, 0x66, 0x38);
    /* ymm1, ymm2, m256 */
    FCML_A64("vpblendmb (%rax),%ymm7,%ymm15", 0x62, 0x72, 0x45, 0x28, 0x66, 0x38);
    FCML_I64("vpblendmb ymm15,ymm7,ymmword ptr [rax]", 0x62, 0x72, 0x45, 0x28, 0x66, 0x38);
    FCML_A32("vpblendmb (%eax),%ymm5,%ymm7", 0x62, 0xf2, 0x55, 0x28, 0x66, 0x38);
    FCML_I32("vpblendmb ymm7,ymm5,ymmword ptr [eax]", 0x62, 0xf2, 0x55, 0x28, 0x66, 0x38);
    /* zmm1, zmm2, m512 */
    FCML_A64("vpblendmb (%rax),%zmm7,%zmm15", 0x62, 0x72, 0x45, 0x48, 0x66, 0x38);
    FCML_I64("vpblendmb zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x72, 0x45, 0x48, 0x66, 0x38);
    FCML_A32("vpblendmb (%eax),%zmm3,%zmm7", 0x62, 0xf2, 0x65, 0x48, 0x66, 0x38);
    FCML_I32("vpblendmb zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf2, 0x65, 0x48, 0x66, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64("vpblendmb %xmm1,%xmm7,%xmm15", 0x62, 0x72, 0x45, 0x08, 0x66, 0xf9);
    FCML_I64("vpblendmb xmm15,xmm7,xmm1", 0x62, 0x72, 0x45, 0x08, 0x66, 0xf9);
    FCML_A32("vpblendmb %xmm1,%xmm2,%xmm7", 0x62, 0xf2, 0x6d, 0x08, 0x66, 0xf9);
    FCML_I32("vpblendmb xmm7,xmm2,xmm1", 0x62, 0xf2, 0x6d, 0x08, 0x66, 0xf9);
    /* ymm1, ymm2, ymm3 */
    FCML_A64("vpblendmb %ymm6,%ymm7,%ymm14", 0x62, 0x72, 0x45, 0x28, 0x66, 0xf6);
    FCML_I64("vpblendmb ymm14,ymm7,ymm6", 0x62, 0x72, 0x45, 0x28, 0x66, 0xf6);
    FCML_A32("vpblendmb %ymm5,%ymm3,%ymm6", 0x62, 0xf2, 0x65, 0x28, 0x66, 0xf5);
    FCML_I32("vpblendmb ymm6,ymm3,ymm5", 0x62, 0xf2, 0x65, 0x28, 0x66, 0xf5);
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpblendmb %zmm4,%zmm15,%zmm6", 0x62, 0xf2, 0x05, 0x48, 0x66, 0xf4);
    FCML_I64("vpblendmb zmm6,zmm15,zmm4", 0x62, 0xf2, 0x05, 0x48, 0x66, 0xf4);
    FCML_A32("vpblendmb %zmm4,%zmm6,%zmm6", 0x62, 0xf2, 0x4d, 0x48, 0x66, 0xf4);
    FCML_I32("vpblendmb zmm6,zmm6,zmm4", 0x62, 0xf2, 0x4d, 0x48, 0x66, 0xf4);
    /* disp8 */
    FCML_I32("vpblendmb zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf2, 0x6d, 0x48, 0x66, 0x4c, 0x24, 0x08);
    FCML_A32("vpblendmb 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x48, 0x66, 0x4c, 0x24, 0x08);
    FCML_I64("vpblendmb zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf2, 0x6d, 0x48, 0x66, 0x4c, 0x24, 0x08);
    FCML_A64("vpblendmb 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x48, 0x66, 0x4c, 0x24, 0x08);
    FCML_I32("vpblendmb ymm1,ymm2,ymmword ptr [esp+00000100h]", 0x62, 0xf2, 0x6d, 0x28, 0x66, 0x4c, 0x24, 0x08);
    FCML_A32("vpblendmb 0x00000100(%esp),%ymm2,%ymm1", 0x62, 0xf2, 0x6d, 0x28, 0x66, 0x4c, 0x24, 0x08);
    FCML_I64("vpblendmb ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 0x62, 0xf2, 0x6d, 0x28, 0x66, 0x4c, 0x24, 0x08);
    FCML_A64("vpblendmb 0x0000000000000100(%rsp),%ymm2,%ymm1", 0x62, 0xf2, 0x6d, 0x28, 0x66, 0x4c, 0x24, 0x08);
    FCML_I32("vpblendmb xmm1,xmm2,xmmword ptr [esp+00000080h]", 0x62, 0xf2, 0x6d, 0x08, 0x66, 0x4c, 0x24, 0x08);
    FCML_A32("vpblendmb 0x00000080(%esp),%xmm2,%xmm1", 0x62, 0xf2, 0x6d, 0x08, 0x66, 0x4c, 0x24, 0x08);
    FCML_I64("vpblendmb xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 0x62, 0xf2, 0x6d, 0x08, 0x66, 0x4c, 0x24, 0x08);
    FCML_A64("vpblendmb 0x0000000000000080(%rsp),%xmm2,%xmm1", 0x62, 0xf2, 0x6d, 0x08, 0x66, 0x4c, 0x24, 0x08);
    /* {k}{z} */
    FCML_A64("vpblendmb (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x12, 0x0d, 0x8c, 0x66, 0x14, 0x01);
    FCML_I64("vpblendmb xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x8c, 0x66, 0x14, 0x01);
    FCML_A32("vpblendmb (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf2, 0x45, 0x8d, 0x66, 0x14, 0x01);
    FCML_I32("vpblendmb xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x8d, 0x66, 0x14, 0x01);
    FCML_A64("vpblendmb (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x12, 0x0d, 0xac, 0x66, 0x14, 0x01);
    FCML_I64("vpblendmb ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0xac, 0x66, 0x14, 0x01);
    FCML_A32("vpblendmb (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf2, 0x45, 0xad, 0x66, 0x14, 0x01);
    FCML_I32("vpblendmb ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0xad, 0x66, 0x14, 0x01);
    FCML_A64("vpblendmb (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x12, 0x0d, 0xcc, 0x66, 0x14, 0x01);
    FCML_I64("vpblendmb zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0xcc, 0x66, 0x14, 0x01);
    FCML_A32("vpblendmb (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf2, 0x45, 0xcd, 0x66, 0x14, 0x01);
    FCML_I32("vpblendmb zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0xcd, 0x66, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpblendmb (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x12, 0x0d, 0x0c, 0x66, 0x14, 0x01);
    FCML_I64("vpblendmb xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x0c, 0x66, 0x14, 0x01);
    FCML_A32("vpblendmb (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf2, 0x45, 0x0d, 0x66, 0x14, 0x01);
    FCML_I32("vpblendmb xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x0d, 0x66, 0x14, 0x01);
    FCML_A64("vpblendmb (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x12, 0x0d, 0x2c, 0x66, 0x14, 0x01);
    FCML_I64("vpblendmb ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x2c, 0x66, 0x14, 0x01);
    FCML_A32("vpblendmb (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf2, 0x45, 0x2d, 0x66, 0x14, 0x01);
    FCML_I32("vpblendmb ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x2d, 0x66, 0x14, 0x01);
    FCML_A64("vpblendmb (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x12, 0x0d, 0x4c, 0x66, 0x14, 0x01);
    FCML_I64("vpblendmb zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x4c, 0x66, 0x14, 0x01);
    FCML_A32("vpblendmb (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf2, 0x45, 0x4d, 0x66, 0x14, 0x01);
    FCML_I32("vpblendmb zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x4d, 0x66, 0x14, 0x01);
}

void fcml_tf_instruction_VPBLENDMW(void) {
    /* xmm1, xmm2, m128 */
    FCML_A64("vpblendmw (%rax),%xmm7,%xmm15", 0x62, 0x72, 0xc5, 0x08, 0x66, 0x38);
    FCML_I64("vpblendmw xmm15,xmm7,xmmword ptr [rax]", 0x62, 0x72, 0xc5, 0x08, 0x66, 0x38);
    FCML_A32("vpblendmw (%eax),%xmm6,%xmm7", 0x62, 0xf2, 0xcd, 0x08, 0x66, 0x38);
    FCML_I32("vpblendmw xmm7,xmm6,xmmword ptr [eax]", 0x62, 0xf2, 0xcd, 0x08, 0x66, 0x38);
    /* ymm1, ymm2, m256 */
    FCML_A64("vpblendmw (%rax),%ymm7,%ymm15", 0x62, 0x72, 0xc5, 0x28, 0x66, 0x38);
    FCML_I64("vpblendmw ymm15,ymm7,ymmword ptr [rax]", 0x62, 0x72, 0xc5, 0x28, 0x66, 0x38);
    FCML_A32("vpblendmw (%eax),%ymm5,%ymm7", 0x62, 0xf2, 0xd5, 0x28, 0x66, 0x38);
    FCML_I32("vpblendmw ymm7,ymm5,ymmword ptr [eax]", 0x62, 0xf2, 0xd5, 0x28, 0x66, 0x38);
    /* zmm1, zmm2, m512 */
    FCML_A64("vpblendmw (%rax),%zmm7,%zmm15", 0x62, 0x72, 0xc5, 0x48, 0x66, 0x38);
    FCML_I64("vpblendmw zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x72, 0xc5, 0x48, 0x66, 0x38);
    FCML_A32("vpblendmw (%eax),%zmm3,%zmm7", 0x62, 0xf2, 0xe5, 0x48, 0x66, 0x38);
    FCML_I32("vpblendmw zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf2, 0xe5, 0x48, 0x66, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64("vpblendmw %xmm1,%xmm7,%xmm15", 0x62, 0x72, 0xc5, 0x08, 0x66, 0xf9);
    FCML_I64("vpblendmw xmm15,xmm7,xmm1", 0x62, 0x72, 0xc5, 0x08, 0x66, 0xf9);
    FCML_A32("vpblendmw %xmm1,%xmm2,%xmm7", 0x62, 0xf2, 0xed, 0x08, 0x66, 0xf9);
    FCML_I32("vpblendmw xmm7,xmm2,xmm1", 0x62, 0xf2, 0xed, 0x08, 0x66, 0xf9);
    /* ymm1, ymm2, ymm3 */
    FCML_A64("vpblendmw %ymm6,%ymm7,%ymm14", 0x62, 0x72, 0xc5, 0x28, 0x66, 0xf6);
    FCML_I64("vpblendmw ymm14,ymm7,ymm6", 0x62, 0x72, 0xc5, 0x28, 0x66, 0xf6);
    FCML_A32("vpblendmw %ymm5,%ymm3,%ymm6", 0x62, 0xf2, 0xe5, 0x28, 0x66, 0xf5);
    FCML_I32("vpblendmw ymm6,ymm3,ymm5", 0x62, 0xf2, 0xe5, 0x28, 0x66, 0xf5);
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpblendmw %zmm4,%zmm15,%zmm6", 0x62, 0xf2, 0x85, 0x48, 0x66, 0xf4);
    FCML_I64("vpblendmw zmm6,zmm15,zmm4", 0x62, 0xf2, 0x85, 0x48, 0x66, 0xf4);
    FCML_A32("vpblendmw %zmm4,%zmm6,%zmm6", 0x62, 0xf2, 0xcd, 0x48, 0x66, 0xf4);
    FCML_I32("vpblendmw zmm6,zmm6,zmm4", 0x62, 0xf2, 0xcd, 0x48, 0x66, 0xf4);
    /* disp8 */
    FCML_I32("vpblendmw zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf2, 0xed, 0x48, 0x66, 0x4c, 0x24, 0x08);
    FCML_A32("vpblendmw 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x48, 0x66, 0x4c, 0x24, 0x08);
    FCML_I64("vpblendmw zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf2, 0xed, 0x48, 0x66, 0x4c, 0x24, 0x08);
    FCML_A64("vpblendmw 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x48, 0x66, 0x4c, 0x24, 0x08);
    FCML_I32("vpblendmw ymm1,ymm2,ymmword ptr [esp+00000100h]", 0x62, 0xf2, 0xed, 0x28, 0x66, 0x4c, 0x24, 0x08);
    FCML_A32("vpblendmw 0x00000100(%esp),%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x28, 0x66, 0x4c, 0x24, 0x08);
    FCML_I64("vpblendmw ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 0x62, 0xf2, 0xed, 0x28, 0x66, 0x4c, 0x24, 0x08);
    FCML_A64("vpblendmw 0x0000000000000100(%rsp),%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x28, 0x66, 0x4c, 0x24, 0x08);
    FCML_I32("vpblendmw xmm1,xmm2,xmmword ptr [esp+00000080h]", 0x62, 0xf2, 0xed, 0x08, 0x66, 0x4c, 0x24, 0x08);
    FCML_A32("vpblendmw 0x00000080(%esp),%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x08, 0x66, 0x4c, 0x24, 0x08);
    FCML_I64("vpblendmw xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 0x62, 0xf2, 0xed, 0x08, 0x66, 0x4c, 0x24, 0x08);
    FCML_A64("vpblendmw 0x0000000000000080(%rsp),%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x08, 0x66, 0x4c, 0x24, 0x08);
    /* {k}{z} */
    FCML_A64("vpblendmw (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x12, 0x8d, 0x8c, 0x66, 0x14, 0x01);
    FCML_I64("vpblendmw xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x8c, 0x66, 0x14, 0x01);
    FCML_A32("vpblendmw (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0x8d, 0x66, 0x14, 0x01);
    FCML_I32("vpblendmw xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x8d, 0x66, 0x14, 0x01);
    FCML_A64("vpblendmw (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x12, 0x8d, 0xac, 0x66, 0x14, 0x01);
    FCML_I64("vpblendmw ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0xac, 0x66, 0x14, 0x01);
    FCML_A32("vpblendmw (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0xad, 0x66, 0x14, 0x01);
    FCML_I32("vpblendmw ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0xad, 0x66, 0x14, 0x01);
    FCML_A64("vpblendmw (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x12, 0x8d, 0xcc, 0x66, 0x14, 0x01);
    FCML_I64("vpblendmw zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0xcc, 0x66, 0x14, 0x01);
    FCML_A32("vpblendmw (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0xcd, 0x66, 0x14, 0x01);
    FCML_I32("vpblendmw zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0xcd, 0x66, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpblendmw (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x12, 0x8d, 0x0c, 0x66, 0x14, 0x01);
    FCML_I64("vpblendmw xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x0c, 0x66, 0x14, 0x01);
    FCML_A32("vpblendmw (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf2, 0xc5, 0x0d, 0x66, 0x14, 0x01);
    FCML_I32("vpblendmw xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x0d, 0x66, 0x14, 0x01);
    FCML_A64("vpblendmw (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x12, 0x8d, 0x2c, 0x66, 0x14, 0x01);
    FCML_I64("vpblendmw ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x2c, 0x66, 0x14, 0x01);
    FCML_A32("vpblendmw (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf2, 0xc5, 0x2d, 0x66, 0x14, 0x01);
    FCML_I32("vpblendmw ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x2d, 0x66, 0x14, 0x01);
    FCML_A64("vpblendmw (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x12, 0x8d, 0x4c, 0x66, 0x14, 0x01);
    FCML_I64("vpblendmw zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x4c, 0x66, 0x14, 0x01);
    FCML_A32("vpblendmw (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf2, 0xc5, 0x4d, 0x66, 0x14, 0x01);
    FCML_I32("vpblendmw zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x4d, 0x66, 0x14, 0x01);
}

void fcml_tf_instruction_VPBLENDMD(void) {
    /* xmm1, xmm2, m128 */
    FCML_A64("vpblendmd (%rax),%xmm7,%xmm15", 0x62, 0x72, 0x45, 0x08, 0x64, 0x38);
    FCML_I64("vpblendmd xmm15,xmm7,xmmword ptr [rax]", 0x62, 0x72, 0x45, 0x08, 0x64, 0x38);
    FCML_A32("vpblendmd (%eax),%xmm6,%xmm7", 0x62, 0xf2, 0x4d, 0x08, 0x64, 0x38);
    FCML_I32("vpblendmd xmm7,xmm6,xmmword ptr [eax]", 0x62, 0xf2, 0x4d, 0x08, 0x64, 0x38);
    /* ymm1, ymm2, m256 */
    FCML_A64("vpblendmd (%rax),%ymm7,%ymm15", 0x62, 0x72, 0x45, 0x28, 0x64, 0x38);
    FCML_I64("vpblendmd ymm15,ymm7,ymmword ptr [rax]", 0x62, 0x72, 0x45, 0x28, 0x64, 0x38);
    FCML_A32("vpblendmd (%eax),%ymm5,%ymm7", 0x62, 0xf2, 0x55, 0x28, 0x64, 0x38);
    FCML_I32("vpblendmd ymm7,ymm5,ymmword ptr [eax]", 0x62, 0xf2, 0x55, 0x28, 0x64, 0x38);
    /* zmm1, zmm2, m512 */
    FCML_A64("vpblendmd (%rax),%zmm7,%zmm15", 0x62, 0x72, 0x45, 0x48, 0x64, 0x38);
    FCML_I64("vpblendmd zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x72, 0x45, 0x48, 0x64, 0x38);
    FCML_A32("vpblendmd (%eax),%zmm3,%zmm7", 0x62, 0xf2, 0x65, 0x48, 0x64, 0x38);
    FCML_I32("vpblendmd zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf2, 0x65, 0x48, 0x64, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64("vpblendmd %xmm1,%xmm7,%xmm15", 0x62, 0x72, 0x45, 0x08, 0x64, 0xf9);
    FCML_I64("vpblendmd xmm15,xmm7,xmm1", 0x62, 0x72, 0x45, 0x08, 0x64, 0xf9);
    FCML_A32("vpblendmd %xmm1,%xmm2,%xmm7", 0x62, 0xf2, 0x6d, 0x08, 0x64, 0xf9);
    FCML_I32("vpblendmd xmm7,xmm2,xmm1", 0x62, 0xf2, 0x6d, 0x08, 0x64, 0xf9);
    /* ymm1, ymm2, ymm3 */
    FCML_A64("vpblendmd %ymm6,%ymm7,%ymm14", 0x62, 0x72, 0x45, 0x28, 0x64, 0xf6);
    FCML_I64("vpblendmd ymm14,ymm7,ymm6", 0x62, 0x72, 0x45, 0x28, 0x64, 0xf6);
    FCML_A32("vpblendmd %ymm5,%ymm3,%ymm6", 0x62, 0xf2, 0x65, 0x28, 0x64, 0xf5);
    FCML_I32("vpblendmd ymm6,ymm3,ymm5", 0x62, 0xf2, 0x65, 0x28, 0x64, 0xf5);
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpblendmd %zmm4,%zmm15,%zmm6", 0x62, 0xf2, 0x05, 0x48, 0x64, 0xf4);
    FCML_I64("vpblendmd zmm6,zmm15,zmm4", 0x62, 0xf2, 0x05, 0x48, 0x64, 0xf4);
    FCML_A32("vpblendmd %zmm4,%zmm6,%zmm6", 0x62, 0xf2, 0x4d, 0x48, 0x64, 0xf4);
    FCML_I32("vpblendmd zmm6,zmm6,zmm4", 0x62, 0xf2, 0x4d, 0x48, 0x64, 0xf4);
    /* disp8 */
    FCML_I32("vpblendmd zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf2, 0x6d, 0x48, 0x64, 0x4c, 0x24, 0x08);
    FCML_A32("vpblendmd 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x48, 0x64, 0x4c, 0x24, 0x08);
    FCML_I64("vpblendmd zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf2, 0x6d, 0x48, 0x64, 0x4c, 0x24, 0x08);
    FCML_A64("vpblendmd 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x48, 0x64, 0x4c, 0x24, 0x08);
    FCML_I32("vpblendmd ymm1,ymm2,ymmword ptr [esp+00000100h]", 0x62, 0xf2, 0x6d, 0x28, 0x64, 0x4c, 0x24, 0x08);
    FCML_A32("vpblendmd 0x00000100(%esp),%ymm2,%ymm1", 0x62, 0xf2, 0x6d, 0x28, 0x64, 0x4c, 0x24, 0x08);
    FCML_I64("vpblendmd ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 0x62, 0xf2, 0x6d, 0x28, 0x64, 0x4c, 0x24, 0x08);
    FCML_A64("vpblendmd 0x0000000000000100(%rsp),%ymm2,%ymm1", 0x62, 0xf2, 0x6d, 0x28, 0x64, 0x4c, 0x24, 0x08);
    FCML_I32("vpblendmd xmm1,xmm2,xmmword ptr [esp+00000080h]", 0x62, 0xf2, 0x6d, 0x08, 0x64, 0x4c, 0x24, 0x08);
    FCML_A32("vpblendmd 0x00000080(%esp),%xmm2,%xmm1", 0x62, 0xf2, 0x6d, 0x08, 0x64, 0x4c, 0x24, 0x08);
    FCML_I64("vpblendmd xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 0x62, 0xf2, 0x6d, 0x08, 0x64, 0x4c, 0x24, 0x08);
    FCML_A64("vpblendmd 0x0000000000000080(%rsp),%xmm2,%xmm1", 0x62, 0xf2, 0x6d, 0x08, 0x64, 0x4c, 0x24, 0x08);
    /* {k}{z} */
    FCML_A64("vpblendmd (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x12, 0x0d, 0x8c, 0x64, 0x14, 0x01);
    FCML_I64("vpblendmd xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x8c, 0x64, 0x14, 0x01);
    FCML_A32("vpblendmd (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf2, 0x45, 0x8d, 0x64, 0x14, 0x01);
    FCML_I32("vpblendmd xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x8d, 0x64, 0x14, 0x01);
    FCML_A64("vpblendmd (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x12, 0x0d, 0xac, 0x64, 0x14, 0x01);
    FCML_I64("vpblendmd ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0xac, 0x64, 0x14, 0x01);
    FCML_A32("vpblendmd (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf2, 0x45, 0xad, 0x64, 0x14, 0x01);
    FCML_I32("vpblendmd ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0xad, 0x64, 0x14, 0x01);
    FCML_A64("vpblendmd (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x12, 0x0d, 0xcc, 0x64, 0x14, 0x01);
    FCML_I64("vpblendmd zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0xcc, 0x64, 0x14, 0x01);
    FCML_A32("vpblendmd (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf2, 0x45, 0xcd, 0x64, 0x14, 0x01);
    FCML_I32("vpblendmd zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0xcd, 0x64, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpblendmd (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x12, 0x0d, 0x0c, 0x64, 0x14, 0x01);
    FCML_I64("vpblendmd xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x0c, 0x64, 0x14, 0x01);
    FCML_A32("vpblendmd (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf2, 0x45, 0x0d, 0x64, 0x14, 0x01);
    FCML_I32("vpblendmd xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x0d, 0x64, 0x14, 0x01);
    FCML_A64("vpblendmd (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x12, 0x0d, 0x2c, 0x64, 0x14, 0x01);
    FCML_I64("vpblendmd ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x2c, 0x64, 0x14, 0x01);
    FCML_A32("vpblendmd (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf2, 0x45, 0x2d, 0x64, 0x14, 0x01);
    FCML_I32("vpblendmd ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x2d, 0x64, 0x14, 0x01);
    FCML_A64("vpblendmd (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x12, 0x0d, 0x4c, 0x64, 0x14, 0x01);
    FCML_I64("vpblendmd zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x4c, 0x64, 0x14, 0x01);
    FCML_A32("vpblendmd (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf2, 0x45, 0x4d, 0x64, 0x14, 0x01);
    FCML_I32("vpblendmd zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x4d, 0x64, 0x14, 0x01);
    /* bcast */
    FCML_I64("vpblendmd zmm31,zmm21,dword ptr [rsi]{1to16}", 0x62, 0x62, 0x55, 0x50, 0x64, 0x3e);
    FCML_A64("vpblendmd (%rsi){1to16},%zmm21,%zmm31", 0x62, 0x62, 0x55, 0x50, 0x64, 0x3e);
    FCML_I64("vpblendmd ymm31,ymm21,dword ptr [rsi]{1to8}", 0x62, 0x62, 0x55, 0x30, 0x64, 0x3e);
    FCML_A64("vpblendmd (%rsi){1to8},%ymm21,%ymm31", 0x62, 0x62, 0x55, 0x30, 0x64, 0x3e);
    FCML_I64("vpblendmd xmm31,xmm21,dword ptr [rsi]{1to4}", 0x62, 0x62, 0x55, 0x10, 0x64, 0x3e);
    FCML_A64("vpblendmd (%rsi){1to4},%xmm21,%xmm31", 0x62, 0x62, 0x55, 0x10, 0x64, 0x3e);
    FCML_A32("vpblendmd (%esi){1to16},%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x58, 0x64, 0x0e);
    FCML_I32("vpblendmd zmm1,zmm2,dword ptr [esi]{1to16}", 0x62, 0xf2, 0x6d, 0x58, 0x64, 0x0e);
    /* {k}{z}{bcast} */
    FCML_A64("vpblendmd (%rsi){1to8},%ymm21,%ymm31{%k7}{z}", 0x62, 0x62, 0x55, 0xb7, 0x64, 0x3e);
    FCML_I64("vpblendmd ymm31{k7}{z},ymm21,dword ptr [rsi]{1to8}", 0x62, 0x62, 0x55, 0xb7, 0x64, 0x3e);
    /* {bcast} disp8 */
    FCML_I32("vpblendmd zmm1,zmm2,dword ptr [esp+00000020h]{1to16}", 0x62, 0xf2, 0x6d, 0x58, 0x64, 0x4c, 0x24, 0x08);
    FCML_A32("vpblendmd 0x00000020(%esp){1to16},%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x58, 0x64, 0x4c, 0x24, 0x08);
    FCML_I64("vpblendmd zmm1,zmm2,dword ptr [rsp+0000000000000020h]{1to16}", 0x62, 0xf2, 0x6d, 0x58, 0x64, 0x4c, 0x24, 0x08);
    FCML_A64("vpblendmd 0x0000000000000020(%rsp){1to16},%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x58, 0x64, 0x4c, 0x24, 0x08);
    FCML_I32("vpblendmd ymm1,ymm2,dword ptr [esp+00000020h]{1to8}", 0x62, 0xf2, 0x6d, 0x38, 0x64, 0x4c, 0x24, 0x08);
    FCML_A32("vpblendmd 0x00000020(%esp){1to8},%ymm2,%ymm1", 0x62, 0xf2, 0x6d, 0x38, 0x64, 0x4c, 0x24, 0x08);
    FCML_I64("vpblendmd ymm1,ymm2,dword ptr [rsp+0000000000000020h]{1to8}", 0x62, 0xf2, 0x6d, 0x38, 0x64, 0x4c, 0x24, 0x08);
    FCML_A64("vpblendmd 0x0000000000000020(%rsp){1to8},%ymm2,%ymm1", 0x62, 0xf2, 0x6d, 0x38, 0x64, 0x4c, 0x24, 0x08);
    FCML_I32("vpblendmd xmm1,xmm2,dword ptr [esp+00000020h]{1to4}", 0x62, 0xf2, 0x6d, 0x18, 0x64, 0x4c, 0x24, 0x08);
    FCML_A32("vpblendmd 0x00000020(%esp){1to4},%xmm2,%xmm1", 0x62, 0xf2, 0x6d, 0x18, 0x64, 0x4c, 0x24, 0x08);
    FCML_I64("vpblendmd xmm1,xmm2,dword ptr [rsp+0000000000000020h]{1to4}", 0x62, 0xf2, 0x6d, 0x18, 0x64, 0x4c, 0x24, 0x08);
    FCML_A64("vpblendmd 0x0000000000000020(%rsp){1to4},%xmm2,%xmm1", 0x62, 0xf2, 0x6d, 0x18, 0x64, 0x4c, 0x24, 0x08);
}

void fcml_tf_instruction_VPBLENDMQ(void) {
    /* xmm1, xmm2, m128 */
    FCML_A64("vpblendmq (%rax),%xmm7,%xmm15", 0x62, 0x72, 0xc5, 0x08, 0x64, 0x38);
    FCML_I64("vpblendmq xmm15,xmm7,xmmword ptr [rax]", 0x62, 0x72, 0xc5, 0x08, 0x64, 0x38);
    FCML_A32("vpblendmq (%eax),%xmm6,%xmm7", 0x62, 0xf2, 0xcd, 0x08, 0x64, 0x38);
    FCML_I32("vpblendmq xmm7,xmm6,xmmword ptr [eax]", 0x62, 0xf2, 0xcd, 0x08, 0x64, 0x38);
    /* ymm1, ymm2, m256 */
    FCML_A64("vpblendmq (%rax),%ymm7,%ymm15", 0x62, 0x72, 0xc5, 0x28, 0x64, 0x38);
    FCML_I64("vpblendmq ymm15,ymm7,ymmword ptr [rax]", 0x62, 0x72, 0xc5, 0x28, 0x64, 0x38);
    FCML_A32("vpblendmq (%eax),%ymm5,%ymm7", 0x62, 0xf2, 0xd5, 0x28, 0x64, 0x38);
    FCML_I32("vpblendmq ymm7,ymm5,ymmword ptr [eax]", 0x62, 0xf2, 0xd5, 0x28, 0x64, 0x38);
    /* zmm1, zmm2, m512 */
    FCML_A64("vpblendmq (%rax),%zmm7,%zmm15", 0x62, 0x72, 0xc5, 0x48, 0x64, 0x38);
    FCML_I64("vpblendmq zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x72, 0xc5, 0x48, 0x64, 0x38);
    FCML_A32("vpblendmq (%eax),%zmm3,%zmm7", 0x62, 0xf2, 0xe5, 0x48, 0x64, 0x38);
    FCML_I32("vpblendmq zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf2, 0xe5, 0x48, 0x64, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64("vpblendmq %xmm1,%xmm7,%xmm15", 0x62, 0x72, 0xc5, 0x08, 0x64, 0xf9);
    FCML_I64("vpblendmq xmm15,xmm7,xmm1", 0x62, 0x72, 0xc5, 0x08, 0x64, 0xf9);
    FCML_A32("vpblendmq %xmm1,%xmm2,%xmm7", 0x62, 0xf2, 0xed, 0x08, 0x64, 0xf9);
    FCML_I32("vpblendmq xmm7,xmm2,xmm1", 0x62, 0xf2, 0xed, 0x08, 0x64, 0xf9);
    /* ymm1, ymm2, ymm3 */
    FCML_A64("vpblendmq %ymm6,%ymm7,%ymm14", 0x62, 0x72, 0xc5, 0x28, 0x64, 0xf6);
    FCML_I64("vpblendmq ymm14,ymm7,ymm6", 0x62, 0x72, 0xc5, 0x28, 0x64, 0xf6);
    FCML_A32("vpblendmq %ymm5,%ymm3,%ymm6", 0x62, 0xf2, 0xe5, 0x28, 0x64, 0xf5);
    FCML_I32("vpblendmq ymm6,ymm3,ymm5", 0x62, 0xf2, 0xe5, 0x28, 0x64, 0xf5);
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpblendmq %zmm4,%zmm15,%zmm6", 0x62, 0xf2, 0x85, 0x48, 0x64, 0xf4);
    FCML_I64("vpblendmq zmm6,zmm15,zmm4", 0x62, 0xf2, 0x85, 0x48, 0x64, 0xf4);
    FCML_A32("vpblendmq %zmm4,%zmm6,%zmm6", 0x62, 0xf2, 0xcd, 0x48, 0x64, 0xf4);
    FCML_I32("vpblendmq zmm6,zmm6,zmm4", 0x62, 0xf2, 0xcd, 0x48, 0x64, 0xf4);
    /* disp8 */
    FCML_I32("vpblendmq zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf2, 0xed, 0x48, 0x64, 0x4c, 0x24, 0x08);
    FCML_A32("vpblendmq 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x48, 0x64, 0x4c, 0x24, 0x08);
    FCML_I64("vpblendmq zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf2, 0xed, 0x48, 0x64, 0x4c, 0x24, 0x08);
    FCML_A64("vpblendmq 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x48, 0x64, 0x4c, 0x24, 0x08);
    FCML_I32("vpblendmq ymm1,ymm2,ymmword ptr [esp+00000100h]", 0x62, 0xf2, 0xed, 0x28, 0x64, 0x4c, 0x24, 0x08);
    FCML_A32("vpblendmq 0x00000100(%esp),%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x28, 0x64, 0x4c, 0x24, 0x08);
    FCML_I64("vpblendmq ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 0x62, 0xf2, 0xed, 0x28, 0x64, 0x4c, 0x24, 0x08);
    FCML_A64("vpblendmq 0x0000000000000100(%rsp),%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x28, 0x64, 0x4c, 0x24, 0x08);
    FCML_I32("vpblendmq xmm1,xmm2,xmmword ptr [esp+00000080h]", 0x62, 0xf2, 0xed, 0x08, 0x64, 0x4c, 0x24, 0x08);
    FCML_A32("vpblendmq 0x00000080(%esp),%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x08, 0x64, 0x4c, 0x24, 0x08);
    FCML_I64("vpblendmq xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 0x62, 0xf2, 0xed, 0x08, 0x64, 0x4c, 0x24, 0x08);
    FCML_A64("vpblendmq 0x0000000000000080(%rsp),%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x08, 0x64, 0x4c, 0x24, 0x08);
    /* {k}{z} */
    FCML_A64("vpblendmq (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x12, 0x8d, 0x8c, 0x64, 0x14, 0x01);
    FCML_I64("vpblendmq xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x8c, 0x64, 0x14, 0x01);
    FCML_A32("vpblendmq (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0x8d, 0x64, 0x14, 0x01);
    FCML_I32("vpblendmq xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x8d, 0x64, 0x14, 0x01);
    FCML_A64("vpblendmq (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x12, 0x8d, 0xac, 0x64, 0x14, 0x01);
    FCML_I64("vpblendmq ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0xac, 0x64, 0x14, 0x01);
    FCML_A32("vpblendmq (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0xad, 0x64, 0x14, 0x01);
    FCML_I32("vpblendmq ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0xad, 0x64, 0x14, 0x01);
    FCML_A64("vpblendmq (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x12, 0x8d, 0xcc, 0x64, 0x14, 0x01);
    FCML_I64("vpblendmq zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0xcc, 0x64, 0x14, 0x01);
    FCML_A32("vpblendmq (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0xcd, 0x64, 0x14, 0x01);
    FCML_I32("vpblendmq zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0xcd, 0x64, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpblendmq (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x12, 0x8d, 0x0c, 0x64, 0x14, 0x01);
    FCML_I64("vpblendmq xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x0c, 0x64, 0x14, 0x01);
    FCML_A32("vpblendmq (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf2, 0xc5, 0x0d, 0x64, 0x14, 0x01);
    FCML_I32("vpblendmq xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x0d, 0x64, 0x14, 0x01);
    FCML_A64("vpblendmq (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x12, 0x8d, 0x2c, 0x64, 0x14, 0x01);
    FCML_I64("vpblendmq ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x2c, 0x64, 0x14, 0x01);
    FCML_A32("vpblendmq (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf2, 0xc5, 0x2d, 0x64, 0x14, 0x01);
    FCML_I32("vpblendmq ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x2d, 0x64, 0x14, 0x01);
    FCML_A64("vpblendmq (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x12, 0x8d, 0x4c, 0x64, 0x14, 0x01);
    FCML_I64("vpblendmq zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x4c, 0x64, 0x14, 0x01);
    FCML_A32("vpblendmq (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf2, 0xc5, 0x4d, 0x64, 0x14, 0x01);
    FCML_I32("vpblendmq zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x4d, 0x64, 0x14, 0x01);
    /* bcast */
    FCML_I64("vpblendmq zmm31,zmm21,mmword ptr [rsi]{1to8}", 0x62, 0x62, 0xd5, 0x50, 0x64, 0x3e);
    FCML_A64("vpblendmq (%rsi){1to8},%zmm21,%zmm31", 0x62, 0x62, 0xd5, 0x50, 0x64, 0x3e);
    FCML_I64("vpblendmq ymm31,ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x62, 0xd5, 0x30, 0x64, 0x3e);
    FCML_A64("vpblendmq (%rsi){1to4},%ymm21,%ymm31", 0x62, 0x62, 0xd5, 0x30, 0x64, 0x3e);
    FCML_I64("vpblendmq xmm31,xmm21,mmword ptr [rsi]{1to2}", 0x62, 0x62, 0xd5, 0x10, 0x64, 0x3e);
    FCML_A64("vpblendmq (%rsi){1to2},%xmm21,%xmm31", 0x62, 0x62, 0xd5, 0x10, 0x64, 0x3e);
    FCML_A32("vpblendmq (%esi){1to8},%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x58, 0x64, 0x0e);
    FCML_I32("vpblendmq zmm1,zmm2,mmword ptr [esi]{1to8}", 0x62, 0xf2, 0xed, 0x58, 0x64, 0x0e);
    /* {k}{z}{bcast} */
    FCML_A64("vpblendmq (%rsi){1to4},%ymm21,%ymm31{%k7}{z}", 0x62, 0x62, 0xd5, 0xb7, 0x64, 0x3e);
    FCML_I64("vpblendmq ymm31{k7}{z},ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x62, 0xd5, 0xb7, 0x64, 0x3e);
    /* {bcast} disp8 */
    FCML_I32("vpblendmq zmm1,zmm2,mmword ptr [esp+00000040h]{1to8}", 0x62, 0xf2, 0xed, 0x58, 0x64, 0x4c, 0x24, 0x08);
    FCML_A32("vpblendmq 0x00000040(%esp){1to8},%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x58, 0x64, 0x4c, 0x24, 0x08);
    FCML_I64("vpblendmq zmm1,zmm2,mmword ptr [rsp+0000000000000040h]{1to8}", 0x62, 0xf2, 0xed, 0x58, 0x64, 0x4c, 0x24, 0x08);
    FCML_A64("vpblendmq 0x0000000000000040(%rsp){1to8},%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x58, 0x64, 0x4c, 0x24, 0x08);
    FCML_I32("vpblendmq ymm1,ymm2,mmword ptr [esp+00000040h]{1to4}", 0x62, 0xf2, 0xed, 0x38, 0x64, 0x4c, 0x24, 0x08);
    FCML_A32("vpblendmq 0x00000040(%esp){1to4},%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x38, 0x64, 0x4c, 0x24, 0x08);
    FCML_I64("vpblendmq ymm1,ymm2,mmword ptr [rsp+0000000000000040h]{1to4}", 0x62, 0xf2, 0xed, 0x38, 0x64, 0x4c, 0x24, 0x08);
    FCML_A64("vpblendmq 0x0000000000000040(%rsp){1to4},%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x38, 0x64, 0x4c, 0x24, 0x08);
    FCML_I32("vpblendmq xmm1,xmm2,mmword ptr [esp+00000040h]{1to2}", 0x62, 0xf2, 0xed, 0x18, 0x64, 0x4c, 0x24, 0x08);
    FCML_A32("vpblendmq 0x00000040(%esp){1to2},%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x18, 0x64, 0x4c, 0x24, 0x08);
    FCML_I64("vpblendmq xmm1,xmm2,mmword ptr [rsp+0000000000000040h]{1to2}", 0x62, 0xf2, 0xed, 0x18, 0x64, 0x4c, 0x24, 0x08);
    FCML_A64("vpblendmq 0x0000000000000040(%rsp){1to2},%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x18, 0x64, 0x4c, 0x24, 0x08);
}

void fcml_tf_instruction_VBROADCASTI32X2(void) {
    FCML_I64("vbroadcasti32x2 ymm1,mmword ptr [rsp+0000000000000040h]", 0x62, 0xf2, 0x7d, 0x28, 0x59, 0x4c, 0x24, 0x08);
    FCML_A64("vbroadcasti32x2 0x0000000000000040(%rsp),%ymm1", 0x62, 0xf2, 0x7d, 0x28, 0x59, 0x4c, 0x24, 0x08);
    FCML_A64("vbroadcasti32x2 0x0000000000000040(%rsp),%zmm1", 0x62, 0xf2, 0x7d, 0x48, 0x59, 0x4c, 0x24, 0x08);
    FCML_A64("vbroadcasti32x2 0x0000000000000040(%rsp),%zmm1{%k4}", 0x62, 0xf2, 0x7d, 0x4c, 0x59, 0x4c, 0x24, 0x08);
    FCML_A64("vbroadcasti32x2 %xmm10,%xmm1", 0x62, 0xd2, 0x7d, 0x08, 0x59, 0xca);
    FCML_A64("vbroadcasti32x2 %xmm10,%ymm1", 0x62, 0xd2, 0x7d, 0x28, 0x59, 0xca);
    FCML_A64("vbroadcasti32x2 %xmm5,%zmm1", 0x62, 0xf2, 0x7d, 0x48, 0x59, 0xcd);
    FCML_A32("vbroadcasti32x2 %xmm2,%ymm5{%k5}{z}", 0x62, 0xf2, 0x7d, 0xad, 0x59, 0xea);
    FCML_A32("vbroadcasti32x2 %xmm5,%zmm1{%k7}", 0x62, 0xf2, 0x7d, 0x4f, 0x59, 0xcd);
}

void fcml_tf_instruction_VBROADCASTI32X4(void) {
    // TODO: should use mmword instead of oword.
    FCML_I64("vbroadcasti32x4 ymm1,oword ptr [rsp+0000000000000040h]", 0x62, 0xf2, 0x7d, 0x28, 0x5a, 0x4c, 0x24, 0x04);
    FCML_A64("vbroadcasti32x4 0x0000000000000040(%rsp),%ymm1", 0x62, 0xf2, 0x7d, 0x28, 0x5a, 0x4c, 0x24, 0x04);
    FCML_A64("vbroadcasti32x4 0x0000000000000040(%rsp),%zmm1", 0x62, 0xf2, 0x7d, 0x48, 0x5a, 0x4c, 0x24, 0x04);
    FCML_A64("vbroadcasti32x4 0x0000000000000040(%rsp),%zmm1{%k4}", 0x62, 0xf2, 0x7d, 0x4c, 0x5a, 0x4c, 0x24, 0x04);
    FCML_A64("vbroadcasti32x4 0x0000000000000040(%rsp),%zmm1{%k4}{z}", 0x62, 0xf2, 0x7d, 0xcc, 0x5a, 0x4c, 0x24, 0x04);
}

void fcml_tf_instruction_VBROADCASTI64X2(void) {
    FCML_I64("vbroadcasti64x2 ymm1,oword ptr [rsp+0000000000000040h]", 0x62, 0xf2, 0xfd, 0x28, 0x5a, 0x4c, 0x24, 0x04);
    FCML_A64("vbroadcasti64x2 0x0000000000000040(%rsp),%ymm1", 0x62, 0xf2, 0xfd, 0x28, 0x5a, 0x4c, 0x24, 0x04);
    FCML_A64("vbroadcasti64x2 0x0000000000000040(%rsp),%zmm1", 0x62, 0xf2, 0xfd, 0x48, 0x5a, 0x4c, 0x24, 0x04);
    FCML_A64("vbroadcasti64x2 0x0000000000000040(%rsp),%zmm1{%k4}", 0x62, 0xf2, 0xfd, 0x4c, 0x5a, 0x4c, 0x24, 0x04);
    FCML_A64("vbroadcasti64x2 0x0000000000000040(%rsp),%zmm1{%k4}{z}", 0x62, 0xf2, 0xfd, 0xcc, 0x5a, 0x4c, 0x24, 0x04);
}

void fcml_tf_instruction_VBROADCASTI32X8(void) {
    FCML_I64("vbroadcasti32x8 zmm1,qqword [rsp+0000000000000040h]", 0x62, 0xf2, 0x7d, 0x48, 0x5b, 0x4c, 0x24, 0x02);
    FCML_A64("vbroadcasti32x8 0x0000000000000040(%rsp),%zmm1", 0x62, 0xf2, 0x7d, 0x48, 0x5b, 0x4c, 0x24, 0x02);
    FCML_A64("vbroadcasti32x8 0x0000000000000040(%rsp),%zmm1{%k4}", 0x62, 0xf2, 0x7d, 0x4c, 0x5b, 0x4c, 0x24, 0x02);
    FCML_A64("vbroadcasti32x8 0x0000000000000040(%rsp),%zmm1{%k4}{z}", 0x62, 0xf2, 0x7d, 0xcc, 0x5b, 0x4c, 0x24, 0x02);
}

void fcml_tf_instruction_VBROADCASTI64X4(void) {
    FCML_I64("vbroadcasti64x4 zmm1,qqword [rsp+0000000000000040h]", 0x62, 0xf2, 0xfd, 0x48, 0x5b, 0x4c, 0x24, 0x02);
    FCML_A64("vbroadcasti64x4 0x0000000000000040(%rsp),%zmm1", 0x62, 0xf2, 0xfd, 0x48, 0x5b, 0x4c, 0x24, 0x02);
    FCML_A64("vbroadcasti64x4 0x0000000000000040(%rsp),%zmm1{%k4}", 0x62, 0xf2, 0xfd, 0x4c, 0x5b, 0x4c, 0x24, 0x02);
    FCML_A64("vbroadcasti64x4 0x0000000000000040(%rsp),%zmm1{%k4}{z}", 0x62, 0xf2, 0xfd, 0xcc, 0x5b, 0x4c, 0x24, 0x02);
}

void fcml_tf_instruction_VPBROADCASTMB2Q(void) {
    FCML_I64("vpbroadcastmb2q xmm1,k1", 0x62, 0xf2, 0xfe, 0x08, 0x2a, 0xc9);
    FCML_I64("vpbroadcastmb2q ymm1,k2", 0x62, 0xf2, 0xfe, 0x28, 0x2a, 0xca);
    FCML_I64("vpbroadcastmb2q zmm1,k3", 0x62, 0xf2, 0xfe, 0x48, 0x2a, 0xcb);
}

void fcml_tf_instruction_VPBROADCASTMW2D(void) {
    FCML_I64("vpbroadcastmw2d xmm1,k1", 0x62, 0xf2, 0x7e, 0x08, 0x3a, 0xc9);
    FCML_I64("vpbroadcastmw2d ymm1,k2", 0x62, 0xf2, 0x7e, 0x28, 0x3a, 0xca);
    FCML_I64("vpbroadcastmw2d zmm1,k3", 0x62, 0xf2, 0x7e, 0x48, 0x3a, 0xcb);
}

void fcml_tf_instruction_VPCMPB(void) {
    FCML_I64("vpcmpb k1,xmm4,xmm12,45h", 0x62, 0xd3, 0x5d, 0x08, 0x3f, 0xcc, 0x45);
    FCML_I64("vpcmpb k2,ymm4,ymm12,45h", 0x62, 0xd3, 0x5d, 0x28, 0x3f, 0xd4, 0x45);
    FCML_I64("vpcmpb k3,zmm4,zmm12,45h", 0x62, 0xd3, 0x5d, 0x48, 0x3f, 0xdc, 0x45);
    FCML_I64("vpcmpb k1{k2},xmm4,xmm12,45h", 0x62, 0xd3, 0x5d, 0x0a, 0x3f, 0xcc, 0x45);
    FCML_I64("vpcmpb k2{k3},ymm4,ymm12,45h", 0x62, 0xd3, 0x5d, 0x2b, 0x3f, 0xd4, 0x45);
    FCML_I64("vpcmpb k3{k4},zmm4,zmm12,45h", 0x62, 0xd3, 0x5d, 0x4c, 0x3f, 0xdc, 0x45);
    FCML_I64("vpcmpb k1,xmm4,xmmword ptr [rsp+0000000000000040h],45h", 0x62, 0xf3, 0x5d, 0x08, 0x3f, 0x4c, 0x24, 0x04, 0x45);
    FCML_I64("vpcmpb k2,ymm4,ymmword ptr [rsp+0000000000000040h],45h", 0x62, 0xf3, 0x5d, 0x28, 0x3f, 0x54, 0x24, 0x02, 0x45);
    FCML_I64("vpcmpb k3,zmm4,zmmword ptr [rsp+0000000000000040h],45h", 0x62, 0xf3, 0x5d, 0x48, 0x3f, 0x5c, 0x24, 0x01, 0x45);
}

void fcml_tf_instruction_VPCMPUB(void) {
    FCML_I64("vpcmpub k1,xmm4,xmm12,45h", 0x62, 0xd3, 0x5d, 0x08, 0x3e, 0xcc, 0x45);
    FCML_I64("vpcmpub k2,ymm4,ymm12,45h", 0x62, 0xd3, 0x5d, 0x28, 0x3e, 0xd4, 0x45);
    FCML_I64("vpcmpub k3,zmm4,zmm12,45h", 0x62, 0xd3, 0x5d, 0x48, 0x3e, 0xdc, 0x45);
    FCML_I64("vpcmpub k1{k2},xmm4,xmm12,45h", 0x62, 0xd3, 0x5d, 0x0a, 0x3e, 0xcc, 0x45);
    FCML_I64("vpcmpub k2{k3},ymm4,ymm12,45h", 0x62, 0xd3, 0x5d, 0x2b, 0x3e, 0xd4, 0x45);
    FCML_I64("vpcmpub k3{k4},zmm4,zmm12,45h", 0x62, 0xd3, 0x5d, 0x4c, 0x3e, 0xdc, 0x45);
    FCML_I64("vpcmpub k1,xmm4,xmmword ptr [rsp+0000000000000040h],45h", 0x62, 0xf3, 0x5d, 0x08, 0x3e, 0x4c, 0x24, 0x04, 0x45);
    FCML_I64("vpcmpub k2,ymm4,ymmword ptr [rsp+0000000000000040h],45h", 0x62, 0xf3, 0x5d, 0x28, 0x3e, 0x54, 0x24, 0x02, 0x45);
    FCML_I64("vpcmpub k3,zmm4,zmmword ptr [rsp+0000000000000040h],45h", 0x62, 0xf3, 0x5d, 0x48, 0x3e, 0x5c, 0x24, 0x01, 0x45);
}

void fcml_tf_instruction_VPCMPD(void) {
    FCML_I64("vpcmpd k1,xmm4,xmm12,45h", 0x62, 0xd3, 0x5d, 0x08, 0x1f, 0xcc, 0x45);
    FCML_I64("vpcmpd k2,ymm4,ymm12,45h", 0x62, 0xd3, 0x5d, 0x28, 0x1f, 0xd4, 0x45);
    FCML_I64("vpcmpd k3,zmm4,zmm12,45h", 0x62, 0xd3, 0x5d, 0x48, 0x1f, 0xdc, 0x45);
    FCML_I64("vpcmpd k1{k2},xmm4,xmm12,45h", 0x62, 0xd3, 0x5d, 0x0a, 0x1f, 0xcc, 0x45);
    FCML_I64("vpcmpd k2{k3},ymm4,ymm12,45h", 0x62, 0xd3, 0x5d, 0x2b, 0x1f, 0xd4, 0x45);
    FCML_I64("vpcmpd k3{k4},zmm4,zmm12,45h", 0x62, 0xd3, 0x5d, 0x4c, 0x1f, 0xdc, 0x45);
    FCML_I64("vpcmpd k1,xmm4,xmmword ptr [rsp+0000000000000040h],45h", 0x62, 0xf3, 0x5d, 0x08, 0x1f, 0x4c, 0x24, 0x04, 0x45);
    FCML_I64("vpcmpd k2,ymm4,ymmword ptr [rsp+0000000000000040h],45h", 0x62, 0xf3, 0x5d, 0x28, 0x1f, 0x54, 0x24, 0x02, 0x45);
    FCML_I64("vpcmpd k3,zmm4,zmmword ptr [rsp+0000000000000040h],45h", 0x62, 0xf3, 0x5d, 0x48, 0x1f, 0x5c, 0x24, 0x01, 0x45);
    FCML_I64("vpcmpd k1,xmm4,dword ptr [rsp+0000000000000040h]{1to4},45h", 0x62, 0xf3, 0x5d, 0x18, 0x1f, 0x4c, 0x24, 0x10, 0x45);
    FCML_I64("vpcmpd k1,ymm4,dword ptr [rsp+0000000000000040h]{1to8},45h", 0x62, 0xf3, 0x5d, 0x38, 0x1f, 0x4c, 0x24, 0x10, 0x45);
    FCML_I64("vpcmpd k1,zmm4,dword ptr [rsp+0000000000000040h]{1to16},45h", 0x62, 0xf3, 0x5d, 0x58, 0x1f, 0x4c, 0x24, 0x10, 0x45);
}

void fcml_tf_instruction_VPCMPUD(void) {
    FCML_I64("vpcmpud k1,xmm4,xmm12,45h", 0x62, 0xd3, 0x5d, 0x08, 0x1e, 0xcc, 0x45);
    FCML_I64("vpcmpud k2,ymm4,ymm12,45h", 0x62, 0xd3, 0x5d, 0x28, 0x1e, 0xd4, 0x45);
    FCML_I64("vpcmpud k3,zmm4,zmm12,45h", 0x62, 0xd3, 0x5d, 0x48, 0x1e, 0xdc, 0x45);
    FCML_I64("vpcmpud k1{k2},xmm4,xmm12,45h", 0x62, 0xd3, 0x5d, 0x0a, 0x1e, 0xcc, 0x45);
    FCML_I64("vpcmpud k2{k3},ymm4,ymm12,45h", 0x62, 0xd3, 0x5d, 0x2b, 0x1e, 0xd4, 0x45);
    FCML_I64("vpcmpud k3{k4},zmm4,zmm12,45h", 0x62, 0xd3, 0x5d, 0x4c, 0x1e, 0xdc, 0x45);
    FCML_I64("vpcmpud k1,xmm4,xmmword ptr [rsp+0000000000000040h],45h", 0x62, 0xf3, 0x5d, 0x08, 0x1e, 0x4c, 0x24, 0x04, 0x45);
    FCML_I64("vpcmpud k2,ymm4,ymmword ptr [rsp+0000000000000040h],45h", 0x62, 0xf3, 0x5d, 0x28, 0x1e, 0x54, 0x24, 0x02, 0x45);
    FCML_I64("vpcmpud k3,zmm4,zmmword ptr [rsp+0000000000000040h],45h", 0x62, 0xf3, 0x5d, 0x48, 0x1e, 0x5c, 0x24, 0x01, 0x45);
    FCML_I64("vpcmpud k1,xmm4,dword ptr [rsp+0000000000000040h]{1to4},45h", 0x62, 0xf3, 0x5d, 0x18, 0x1e, 0x4c, 0x24, 0x10, 0x45);
    FCML_I64("vpcmpud k1,ymm4,dword ptr [rsp+0000000000000040h]{1to8},45h", 0x62, 0xf3, 0x5d, 0x38, 0x1e, 0x4c, 0x24, 0x10, 0x45);
    FCML_I64("vpcmpud k1,zmm4,dword ptr [rsp+0000000000000040h]{1to16},45h", 0x62, 0xf3, 0x5d, 0x58, 0x1e, 0x4c, 0x24, 0x10, 0x45);
}

void fcml_tf_instruction_VPCMPQ(void) {
    FCML_I64("vpcmpq k1,xmm4,xmm12,45h", 0x62, 0xd3, 0xdd, 0x08, 0x1f, 0xcc, 0x45);
    FCML_I64("vpcmpq k2,ymm4,ymm12,45h", 0x62, 0xd3, 0xdd, 0x28, 0x1f, 0xd4, 0x45);
    FCML_I64("vpcmpq k3,zmm4,zmm12,45h", 0x62, 0xd3, 0xdd, 0x48, 0x1f, 0xdc, 0x45);
    FCML_I64("vpcmpq k1{k2},xmm4,xmm12,45h", 0x62, 0xd3, 0xdd, 0x0a, 0x1f, 0xcc, 0x45);
    FCML_I64("vpcmpq k2{k3},ymm4,ymm12,45h", 0x62, 0xd3, 0xdd, 0x2b, 0x1f, 0xd4, 0x45);
    FCML_I64("vpcmpq k3{k4},zmm4,zmm12,45h", 0x62, 0xd3, 0xdd, 0x4c, 0x1f, 0xdc, 0x45);
    FCML_I64("vpcmpq k1,xmm4,xmmword ptr [rsp+0000000000000040h],45h", 0x62, 0xf3, 0xdd, 0x08, 0x1f, 0x4c, 0x24, 0x04, 0x45);
    FCML_I64("vpcmpq k2,ymm4,ymmword ptr [rsp+0000000000000040h],45h", 0x62, 0xf3, 0xdd, 0x28, 0x1f, 0x54, 0x24, 0x02, 0x45);
    FCML_I64("vpcmpq k3,zmm4,zmmword ptr [rsp+0000000000000040h],45h", 0x62, 0xf3, 0xdd, 0x48, 0x1f, 0x5c, 0x24, 0x01, 0x45);
    FCML_I64("vpcmpq k1,xmm4,mmword ptr [rsp+0000000000000040h]{1to2},45h", 0x62, 0xf3, 0xdd, 0x18, 0x1f, 0x4c, 0x24, 0x08, 0x45);
    FCML_I64("vpcmpq k1,ymm4,mmword ptr [rsp+0000000000000040h]{1to4},45h", 0x62, 0xf3, 0xdd, 0x38, 0x1f, 0x4c, 0x24, 0x08, 0x45);
    FCML_I64("vpcmpq k1,zmm4,mmword ptr [rsp+0000000000000040h]{1to8},45h", 0x62, 0xf3, 0xdd, 0x58, 0x1f, 0x4c, 0x24, 0x08, 0x45);
}

void fcml_tf_instruction_VPCMPUQ(void) {
    FCML_I64("vpcmpuq k1,xmm4,xmm12,45h", 0x62, 0xd3, 0xdd, 0x08, 0x1e, 0xcc, 0x45);
    FCML_I64("vpcmpuq k2,ymm4,ymm12,45h", 0x62, 0xd3, 0xdd, 0x28, 0x1e, 0xd4, 0x45);
    FCML_I64("vpcmpuq k3,zmm4,zmm12,45h", 0x62, 0xd3, 0xdd, 0x48, 0x1e, 0xdc, 0x45);
    FCML_I64("vpcmpuq k1{k2},xmm4,xmm12,45h", 0x62, 0xd3, 0xdd, 0x0a, 0x1e, 0xcc, 0x45);
    FCML_I64("vpcmpuq k2{k3},ymm4,ymm12,45h", 0x62, 0xd3, 0xdd, 0x2b, 0x1e, 0xd4, 0x45);
    FCML_I64("vpcmpuq k3{k4},zmm4,zmm12,45h", 0x62, 0xd3, 0xdd, 0x4c, 0x1e, 0xdc, 0x45);
    FCML_I64("vpcmpuq k1,xmm4,xmmword ptr [rsp+0000000000000040h],45h", 0x62, 0xf3, 0xdd, 0x08, 0x1e, 0x4c, 0x24, 0x04, 0x45);
    FCML_I64("vpcmpuq k2,ymm4,ymmword ptr [rsp+0000000000000040h],45h", 0x62, 0xf3, 0xdd, 0x28, 0x1e, 0x54, 0x24, 0x02, 0x45);
    FCML_I64("vpcmpuq k3,zmm4,zmmword ptr [rsp+0000000000000040h],45h", 0x62, 0xf3, 0xdd, 0x48, 0x1e, 0x5c, 0x24, 0x01, 0x45);
    FCML_I64("vpcmpuq k1,xmm4,mmword ptr [rsp+0000000000000040h]{1to2},45h", 0x62, 0xf3, 0xdd, 0x18, 0x1e, 0x4c, 0x24, 0x08, 0x45);
    FCML_I64("vpcmpuq k1,ymm4,mmword ptr [rsp+0000000000000040h]{1to4},45h", 0x62, 0xf3, 0xdd, 0x38, 0x1e, 0x4c, 0x24, 0x08, 0x45);
    FCML_I64("vpcmpuq k1,zmm4,mmword ptr [rsp+0000000000000040h]{1to8},45h", 0x62, 0xf3, 0xdd, 0x58, 0x1e, 0x4c, 0x24, 0x08, 0x45);
}

void fcml_tf_instruction_VPCMPW(void) {
    FCML_I64("vpcmpw k1,xmm4,xmm12,45h", 0x62, 0xd3, 0xdd, 0x08, 0x3f, 0xcc, 0x45);
    FCML_I64("vpcmpw k2,ymm4,ymm12,45h", 0x62, 0xd3, 0xdd, 0x28, 0x3f, 0xd4, 0x45);
    FCML_I64("vpcmpw k3,zmm4,zmm12,45h", 0x62, 0xd3, 0xdd, 0x48, 0x3f, 0xdc, 0x45);
    FCML_I64("vpcmpw k1{k2},xmm4,xmm12,45h", 0x62, 0xd3, 0xdd, 0x0a, 0x3f, 0xcc, 0x45);
    FCML_I64("vpcmpw k2{k3},ymm4,ymm12,45h", 0x62, 0xd3, 0xdd, 0x2b, 0x3f, 0xd4, 0x45);
    FCML_I64("vpcmpw k3{k4},zmm4,zmm12,45h", 0x62, 0xd3, 0xdd, 0x4c, 0x3f, 0xdc, 0x45);
    FCML_I64("vpcmpw k1,xmm4,xmmword ptr [rsp+0000000000000040h],45h", 0x62, 0xf3, 0xdd, 0x08, 0x3f, 0x4c, 0x24, 0x04, 0x45);
    FCML_I64("vpcmpw k2,ymm4,ymmword ptr [rsp+0000000000000040h],45h", 0x62, 0xf3, 0xdd, 0x28, 0x3f, 0x54, 0x24, 0x02, 0x45);
    FCML_I64("vpcmpw k3,zmm4,zmmword ptr [rsp+0000000000000040h],45h", 0x62, 0xf3, 0xdd, 0x48, 0x3f, 0x5c, 0x24, 0x01, 0x45);
}

void fcml_tf_instruction_VPCMPUW(void) {
    FCML_I64("vpcmpuw k1,xmm4,xmm12,45h", 0x62, 0xd3, 0xdd, 0x08, 0x3e, 0xcc, 0x45);
    FCML_I64("vpcmpuw k2,ymm4,ymm12,45h", 0x62, 0xd3, 0xdd, 0x28, 0x3e, 0xd4, 0x45);
    FCML_I64("vpcmpuw k3,zmm4,zmm12,45h", 0x62, 0xd3, 0xdd, 0x48, 0x3e, 0xdc, 0x45);
    FCML_I64("vpcmpuw k1{k2},xmm4,xmm12,45h", 0x62, 0xd3, 0xdd, 0x0a, 0x3e, 0xcc, 0x45);
    FCML_I64("vpcmpuw k2{k3},ymm4,ymm12,45h", 0x62, 0xd3, 0xdd, 0x2b, 0x3e, 0xd4, 0x45);
    FCML_I64("vpcmpuw k3{k4},zmm4,zmm12,45h", 0x62, 0xd3, 0xdd, 0x4c, 0x3e, 0xdc, 0x45);
    FCML_I64("vpcmpuw k1,xmm4,xmmword ptr [rsp+0000000000000040h],45h", 0x62, 0xf3, 0xdd, 0x08, 0x3e, 0x4c, 0x24, 0x04, 0x45);
    FCML_I64("vpcmpuw k2,ymm4,ymmword ptr [rsp+0000000000000040h],45h", 0x62, 0xf3, 0xdd, 0x28, 0x3e, 0x54, 0x24, 0x02, 0x45);
    FCML_I64("vpcmpuw k3,zmm4,zmmword ptr [rsp+0000000000000040h],45h", 0x62, 0xf3, 0xdd, 0x48, 0x3e, 0x5c, 0x24, 0x01, 0x45);
}

void fcml_tf_instruction_VPCOMPRESSD(void) {
    FCML_I64("vpcompressd xmm1,xmm4", 0x62, 0xf2, 0x7d, 0x08, 0x8b, 0xe1);
    FCML_I64("vpcompressd ymm1,ymm4", 0x62, 0xf2, 0x7d, 0x28, 0x8b, 0xe1);
    FCML_I64("vpcompressd zmm1,zmm4", 0x62, 0xf2, 0x7d, 0x48, 0x8b, 0xe1);
    FCML_I64("vpcompressd xmm1{k2}{z},xmm4", 0x62, 0xf2, 0x7d, 0x8a, 0x8b, 0xe1);
    FCML_I64("vpcompressd ymm1{k2}{z},ymm4", 0x62, 0xf2, 0x7d, 0xaa, 0x8b, 0xe1);
    FCML_I64("vpcompressd zmm1{k2}{z},zmm4", 0x62, 0xf2, 0x7d, 0xca, 0x8b, 0xe1);
    FCML_I64("vpcompressd xmmword ptr [rsp+0000000000000040h],xmm1", 0x62, 0xf2, 0x7d, 0x08, 0x8b, 0x4c, 0x24, 0x10);
    FCML_I64("vpcompressd ymmword ptr [rsp+0000000000000040h],ymm3", 0x62, 0xf2, 0x7d, 0x28, 0x8b, 0x5c, 0x24, 0x10);
    FCML_I64("vpcompressd zmmword ptr [rsp+0000000000000040h],zmm30", 0x62, 0x62, 0x7d, 0x48, 0x8b, 0x74, 0x24, 0x10);
}

void fcml_tf_instruction_VPCOMPRESSQ(void) {
    FCML_I64("vpcompressq xmm1,xmm4", 0x62, 0xf2, 0xfd, 0x08, 0x8b, 0xe1);
    FCML_I64("vpcompressq ymm1,ymm4", 0x62, 0xf2, 0xfd, 0x28, 0x8b, 0xe1);
    FCML_I64("vpcompressq zmm1,zmm4", 0x62, 0xf2, 0xfd, 0x48, 0x8b, 0xe1);
    FCML_I64("vpcompressq xmm1{k2}{z},xmm4", 0x62, 0xf2, 0xfd, 0x8a, 0x8b, 0xe1);
    FCML_I64("vpcompressq ymm1{k2}{z},ymm4", 0x62, 0xf2, 0xfd, 0xaa, 0x8b, 0xe1);
    FCML_I64("vpcompressq zmm1{k2}{z},zmm4", 0x62, 0xf2, 0xfd, 0xca, 0x8b, 0xe1);
    FCML_I64("vpcompressq xmmword ptr [rsp+0000000000000040h],xmm1", 0x62, 0xf2, 0xfd, 0x08, 0x8b, 0x4c, 0x24, 0x08);
    FCML_I64("vpcompressq ymmword ptr [rsp+0000000000000040h],ymm3", 0x62, 0xf2, 0xfd, 0x28, 0x8b, 0x5c, 0x24, 0x08);
    FCML_I64("vpcompressq zmmword ptr [rsp+0000000000000040h],zmm30", 0x62, 0x62, 0xfd, 0x48, 0x8b, 0x74, 0x24, 0x08);
}

void fcml_tf_instruction_VPERMB(void) {
    /* xmm1, xmm2, m128 */
    FCML_A64("vpermb (%rax),%xmm7,%xmm15", 0x62, 0x72, 0x45, 0x08, 0x8d, 0x38);
    FCML_I64("vpermb xmm15,xmm7,xmmword ptr [rax]", 0x62, 0x72, 0x45, 0x08, 0x8d, 0x38);
    FCML_A32("vpermb (%eax),%xmm6,%xmm7", 0x62, 0xf2, 0x4d, 0x08, 0x8d, 0x38);
    FCML_I32("vpermb xmm7,xmm6,xmmword ptr [eax]", 0x62, 0xf2, 0x4d, 0x08, 0x8d, 0x38);
    /* ymm1, ymm2, m256 */
    FCML_A64("vpermb (%rax),%ymm7,%ymm15", 0x62, 0x72, 0x45, 0x28, 0x8d, 0x38);
    FCML_I64("vpermb ymm15,ymm7,ymmword ptr [rax]", 0x62, 0x72, 0x45, 0x28, 0x8d, 0x38);
    FCML_A32("vpermb (%eax),%ymm5,%ymm7", 0x62, 0xf2, 0x55, 0x28, 0x8d, 0x38);
    FCML_I32("vpermb ymm7,ymm5,ymmword ptr [eax]", 0x62, 0xf2, 0x55, 0x28, 0x8d, 0x38);
    /* zmm1, zmm2, m512 */
    FCML_A64("vpermb (%rax),%zmm7,%zmm15", 0x62, 0x72, 0x45, 0x48, 0x8d, 0x38);
    FCML_I64("vpermb zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x72, 0x45, 0x48, 0x8d, 0x38);
    FCML_A32("vpermb (%eax),%zmm3,%zmm7", 0x62, 0xf2, 0x65, 0x48, 0x8d, 0x38);
    FCML_I32("vpermb zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf2, 0x65, 0x48, 0x8d, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64("vpermb %xmm1,%xmm7,%xmm15", 0x62, 0x72, 0x45, 0x08, 0x8d, 0xf9);
    FCML_I64("vpermb xmm15,xmm7,xmm1", 0x62, 0x72, 0x45, 0x08, 0x8d, 0xf9);
    FCML_A32("vpermb %xmm1,%xmm2,%xmm7", 0x62, 0xf2, 0x6d, 0x08, 0x8d, 0xf9);
    FCML_I32("vpermb xmm7,xmm2,xmm1", 0x62, 0xf2, 0x6d, 0x08, 0x8d, 0xf9);
    /* ymm1, ymm2, ymm3 */
    FCML_A64("vpermb %ymm6,%ymm7,%ymm14", 0x62, 0x72, 0x45, 0x28, 0x8d, 0xf6);
    FCML_I64("vpermb ymm14,ymm7,ymm6", 0x62, 0x72, 0x45, 0x28, 0x8d, 0xf6);
    FCML_A32("vpermb %ymm5,%ymm3,%ymm6", 0x62, 0xf2, 0x65, 0x28, 0x8d, 0xf5);
    FCML_I32("vpermb ymm6,ymm3,ymm5", 0x62, 0xf2, 0x65, 0x28, 0x8d, 0xf5);
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpermb %zmm4,%zmm15,%zmm6", 0x62, 0xf2, 0x05, 0x48, 0x8d, 0xf4);
    FCML_I64("vpermb zmm6,zmm15,zmm4", 0x62, 0xf2, 0x05, 0x48, 0x8d, 0xf4);
    FCML_A32("vpermb %zmm4,%zmm6,%zmm6", 0x62, 0xf2, 0x4d, 0x48, 0x8d, 0xf4);
    FCML_I32("vpermb zmm6,zmm6,zmm4", 0x62, 0xf2, 0x4d, 0x48, 0x8d, 0xf4);
    /* disp8 */
    FCML_I32("vpermb zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf2, 0x6d, 0x48, 0x8d, 0x4c, 0x24, 0x08);
    FCML_A32("vpermb 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x48, 0x8d, 0x4c, 0x24, 0x08);
    FCML_I64("vpermb zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf2, 0x6d, 0x48, 0x8d, 0x4c, 0x24, 0x08);
    FCML_A64("vpermb 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x48, 0x8d, 0x4c, 0x24, 0x08);
    FCML_I32("vpermb ymm1,ymm2,ymmword ptr [esp+00000100h]", 0x62, 0xf2, 0x6d, 0x28, 0x8d, 0x4c, 0x24, 0x08);
    FCML_A32("vpermb 0x00000100(%esp),%ymm2,%ymm1", 0x62, 0xf2, 0x6d, 0x28, 0x8d, 0x4c, 0x24, 0x08);
    FCML_I64("vpermb ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 0x62, 0xf2, 0x6d, 0x28, 0x8d, 0x4c, 0x24, 0x08);
    FCML_A64("vpermb 0x0000000000000100(%rsp),%ymm2,%ymm1", 0x62, 0xf2, 0x6d, 0x28, 0x8d, 0x4c, 0x24, 0x08);
    FCML_I32("vpermb xmm1,xmm2,xmmword ptr [esp+00000080h]", 0x62, 0xf2, 0x6d, 0x08, 0x8d, 0x4c, 0x24, 0x08);
    FCML_A32("vpermb 0x00000080(%esp),%xmm2,%xmm1", 0x62, 0xf2, 0x6d, 0x08, 0x8d, 0x4c, 0x24, 0x08);
    FCML_I64("vpermb xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 0x62, 0xf2, 0x6d, 0x08, 0x8d, 0x4c, 0x24, 0x08);
    FCML_A64("vpermb 0x0000000000000080(%rsp),%xmm2,%xmm1", 0x62, 0xf2, 0x6d, 0x08, 0x8d, 0x4c, 0x24, 0x08);
    /* {k}{z} */
    FCML_A64("vpermb (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x12, 0x0d, 0x8c, 0x8d, 0x14, 0x01);
    FCML_I64("vpermb xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x8c, 0x8d, 0x14, 0x01);
    FCML_A32("vpermb (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf2, 0x45, 0x8d, 0x8d, 0x14, 0x01);
    FCML_I32("vpermb xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x8d, 0x8d, 0x14, 0x01);
    FCML_A64("vpermb (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x12, 0x0d, 0xac, 0x8d, 0x14, 0x01);
    FCML_I64("vpermb ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0xac, 0x8d, 0x14, 0x01);
    FCML_A32("vpermb (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf2, 0x45, 0xad, 0x8d, 0x14, 0x01);
    FCML_I32("vpermb ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0xad, 0x8d, 0x14, 0x01);
    FCML_A64("vpermb (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x12, 0x0d, 0xcc, 0x8d, 0x14, 0x01);
    FCML_I64("vpermb zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0xcc, 0x8d, 0x14, 0x01);
    FCML_A32("vpermb (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf2, 0x45, 0xcd, 0x8d, 0x14, 0x01);
    FCML_I32("vpermb zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0xcd, 0x8d, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpermb (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x12, 0x0d, 0x0c, 0x8d, 0x14, 0x01);
    FCML_I64("vpermb xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x0c, 0x8d, 0x14, 0x01);
    FCML_A32("vpermb (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf2, 0x45, 0x0d, 0x8d, 0x14, 0x01);
    FCML_I32("vpermb xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x0d, 0x8d, 0x14, 0x01);
    FCML_A64("vpermb (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x12, 0x0d, 0x2c, 0x8d, 0x14, 0x01);
    FCML_I64("vpermb ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x2c, 0x8d, 0x14, 0x01);
    FCML_A32("vpermb (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf2, 0x45, 0x2d, 0x8d, 0x14, 0x01);
    FCML_I32("vpermb ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x2d, 0x8d, 0x14, 0x01);
    FCML_A64("vpermb (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x12, 0x0d, 0x4c, 0x8d, 0x14, 0x01);
    FCML_I64("vpermb zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x4c, 0x8d, 0x14, 0x01);
    FCML_A32("vpermb (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf2, 0x45, 0x4d, 0x8d, 0x14, 0x01);
    FCML_I32("vpermb zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x4d, 0x8d, 0x14, 0x01);
}

void fcml_tf_instruction_VPERMI2W(void) {
    /* xmm1, xmm2, m128 */
    FCML_A64("vpermi2w (%rax),%xmm7,%xmm15", 0x62, 0x72, 0xc5, 0x08, 0x75, 0x38);
    FCML_I64("vpermi2w xmm15,xmm7,xmmword ptr [rax]", 0x62, 0x72, 0xc5, 0x08, 0x75, 0x38);
    FCML_A32("vpermi2w (%eax),%xmm6,%xmm7", 0x62, 0xf2, 0xcd, 0x08, 0x75, 0x38);
    FCML_I32("vpermi2w xmm7,xmm6,xmmword ptr [eax]", 0x62, 0xf2, 0xcd, 0x08, 0x75, 0x38);
    /* ymm1, ymm2, m256 */
    FCML_A64("vpermi2w (%rax),%ymm7,%ymm15", 0x62, 0x72, 0xc5, 0x28, 0x75, 0x38);
    FCML_I64("vpermi2w ymm15,ymm7,ymmword ptr [rax]", 0x62, 0x72, 0xc5, 0x28, 0x75, 0x38);
    FCML_A32("vpermi2w (%eax),%ymm5,%ymm7", 0x62, 0xf2, 0xd5, 0x28, 0x75, 0x38);
    FCML_I32("vpermi2w ymm7,ymm5,ymmword ptr [eax]", 0x62, 0xf2, 0xd5, 0x28, 0x75, 0x38);
    /* zmm1, zmm2, m512 */
    FCML_A64("vpermi2w (%rax),%zmm7,%zmm15", 0x62, 0x72, 0xc5, 0x48, 0x75, 0x38);
    FCML_I64("vpermi2w zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x72, 0xc5, 0x48, 0x75, 0x38);
    FCML_A32("vpermi2w (%eax),%zmm3,%zmm7", 0x62, 0xf2, 0xe5, 0x48, 0x75, 0x38);
    FCML_I32("vpermi2w zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf2, 0xe5, 0x48, 0x75, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64("vpermi2w %xmm1,%xmm7,%xmm15", 0x62, 0x72, 0xc5, 0x08, 0x75, 0xf9);
    FCML_I64("vpermi2w xmm15,xmm7,xmm1", 0x62, 0x72, 0xc5, 0x08, 0x75, 0xf9);
    FCML_A32("vpermi2w %xmm1,%xmm2,%xmm7", 0x62, 0xf2, 0xed, 0x08, 0x75, 0xf9);
    FCML_I32("vpermi2w xmm7,xmm2,xmm1", 0x62, 0xf2, 0xed, 0x08, 0x75, 0xf9);
    /* ymm1, ymm2, ymm3 */
    FCML_A64("vpermi2w %ymm6,%ymm7,%ymm14", 0x62, 0x72, 0xc5, 0x28, 0x75, 0xf6);
    FCML_I64("vpermi2w ymm14,ymm7,ymm6", 0x62, 0x72, 0xc5, 0x28, 0x75, 0xf6);
    FCML_A32("vpermi2w %ymm5,%ymm3,%ymm6", 0x62, 0xf2, 0xe5, 0x28, 0x75, 0xf5);
    FCML_I32("vpermi2w ymm6,ymm3,ymm5", 0x62, 0xf2, 0xe5, 0x28, 0x75, 0xf5);
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpermi2w %zmm4,%zmm15,%zmm6", 0x62, 0xf2, 0x85, 0x48, 0x75, 0xf4);
    FCML_I64("vpermi2w zmm6,zmm15,zmm4", 0x62, 0xf2, 0x85, 0x48, 0x75, 0xf4);
    FCML_A32("vpermi2w %zmm4,%zmm6,%zmm6", 0x62, 0xf2, 0xcd, 0x48, 0x75, 0xf4);
    FCML_I32("vpermi2w zmm6,zmm6,zmm4", 0x62, 0xf2, 0xcd, 0x48, 0x75, 0xf4);
    /* disp8 */
    FCML_I32("vpermi2w zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf2, 0xed, 0x48, 0x75, 0x4c, 0x24, 0x08);
    FCML_A32("vpermi2w 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x48, 0x75, 0x4c, 0x24, 0x08);
    FCML_I64("vpermi2w zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf2, 0xed, 0x48, 0x75, 0x4c, 0x24, 0x08);
    FCML_A64("vpermi2w 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x48, 0x75, 0x4c, 0x24, 0x08);
    FCML_I32("vpermi2w ymm1,ymm2,ymmword ptr [esp+00000100h]", 0x62, 0xf2, 0xed, 0x28, 0x75, 0x4c, 0x24, 0x08);
    FCML_A32("vpermi2w 0x00000100(%esp),%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x28, 0x75, 0x4c, 0x24, 0x08);
    FCML_I64("vpermi2w ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 0x62, 0xf2, 0xed, 0x28, 0x75, 0x4c, 0x24, 0x08);
    FCML_A64("vpermi2w 0x0000000000000100(%rsp),%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x28, 0x75, 0x4c, 0x24, 0x08);
    FCML_I32("vpermi2w xmm1,xmm2,xmmword ptr [esp+00000080h]", 0x62, 0xf2, 0xed, 0x08, 0x75, 0x4c, 0x24, 0x08);
    FCML_A32("vpermi2w 0x00000080(%esp),%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x08, 0x75, 0x4c, 0x24, 0x08);
    FCML_I64("vpermi2w xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 0x62, 0xf2, 0xed, 0x08, 0x75, 0x4c, 0x24, 0x08);
    FCML_A64("vpermi2w 0x0000000000000080(%rsp),%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x08, 0x75, 0x4c, 0x24, 0x08);
    /* {k}{z} */
    FCML_A64("vpermi2w (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x12, 0x8d, 0x8c, 0x75, 0x14, 0x01);
    FCML_I64("vpermi2w xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x8c, 0x75, 0x14, 0x01);
    FCML_A32("vpermi2w (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0x8d, 0x75, 0x14, 0x01);
    FCML_I32("vpermi2w xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x8d, 0x75, 0x14, 0x01);
    FCML_A64("vpermi2w (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x12, 0x8d, 0xac, 0x75, 0x14, 0x01);
    FCML_I64("vpermi2w ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0xac, 0x75, 0x14, 0x01);
    FCML_A32("vpermi2w (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0xad, 0x75, 0x14, 0x01);
    FCML_I32("vpermi2w ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0xad, 0x75, 0x14, 0x01);
    FCML_A64("vpermi2w (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x12, 0x8d, 0xcc, 0x75, 0x14, 0x01);
    FCML_I64("vpermi2w zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0xcc, 0x75, 0x14, 0x01);
    FCML_A32("vpermi2w (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0xcd, 0x75, 0x14, 0x01);
    FCML_I32("vpermi2w zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0xcd, 0x75, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpermi2w (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x12, 0x8d, 0x0c, 0x75, 0x14, 0x01);
    FCML_I64("vpermi2w xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x0c, 0x75, 0x14, 0x01);
    FCML_A32("vpermi2w (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf2, 0xc5, 0x0d, 0x75, 0x14, 0x01);
    FCML_I32("vpermi2w xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x0d, 0x75, 0x14, 0x01);
    FCML_A64("vpermi2w (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x12, 0x8d, 0x2c, 0x75, 0x14, 0x01);
    FCML_I64("vpermi2w ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x2c, 0x75, 0x14, 0x01);
    FCML_A32("vpermi2w (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf2, 0xc5, 0x2d, 0x75, 0x14, 0x01);
    FCML_I32("vpermi2w ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x2d, 0x75, 0x14, 0x01);
    FCML_A64("vpermi2w (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x12, 0x8d, 0x4c, 0x75, 0x14, 0x01);
    FCML_I64("vpermi2w zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x4c, 0x75, 0x14, 0x01);
    FCML_A32("vpermi2w (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf2, 0xc5, 0x4d, 0x75, 0x14, 0x01);
    FCML_I32("vpermi2w zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x4d, 0x75, 0x14, 0x01);
}

void fcml_tf_instruction_VPERMI2D(void) {
    /* xmm1, xmm2, m128 */
    FCML_A64("vpermi2d (%rax),%xmm7,%xmm15", 0x62, 0x72, 0x45, 0x08, 0x76, 0x38);
    FCML_I64("vpermi2d xmm15,xmm7,xmmword ptr [rax]", 0x62, 0x72, 0x45, 0x08, 0x76, 0x38);
    FCML_A32("vpermi2d (%eax),%xmm6,%xmm7", 0x62, 0xf2, 0x4d, 0x08, 0x76, 0x38);
    FCML_I32("vpermi2d xmm7,xmm6,xmmword ptr [eax]", 0x62, 0xf2, 0x4d, 0x08, 0x76, 0x38);
    /* ymm1, ymm2, m256 */
    FCML_A64("vpermi2d (%rax),%ymm7,%ymm15", 0x62, 0x72, 0x45, 0x28, 0x76, 0x38);
    FCML_I64("vpermi2d ymm15,ymm7,ymmword ptr [rax]", 0x62, 0x72, 0x45, 0x28, 0x76, 0x38);
    FCML_A32("vpermi2d (%eax),%ymm5,%ymm7", 0x62, 0xf2, 0x55, 0x28, 0x76, 0x38);
    FCML_I32("vpermi2d ymm7,ymm5,ymmword ptr [eax]", 0x62, 0xf2, 0x55, 0x28, 0x76, 0x38);
    /* zmm1, zmm2, m512 */
    FCML_A64("vpermi2d (%rax),%zmm7,%zmm15", 0x62, 0x72, 0x45, 0x48, 0x76, 0x38);
    FCML_I64("vpermi2d zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x72, 0x45, 0x48, 0x76, 0x38);
    FCML_A32("vpermi2d (%eax),%zmm3,%zmm7", 0x62, 0xf2, 0x65, 0x48, 0x76, 0x38);
    FCML_I32("vpermi2d zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf2, 0x65, 0x48, 0x76, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64("vpermi2d %xmm1,%xmm7,%xmm15", 0x62, 0x72, 0x45, 0x08, 0x76, 0xf9);
    FCML_I64("vpermi2d xmm15,xmm7,xmm1", 0x62, 0x72, 0x45, 0x08, 0x76, 0xf9);
    FCML_A32("vpermi2d %xmm1,%xmm2,%xmm7", 0x62, 0xf2, 0x6d, 0x08, 0x76, 0xf9);
    FCML_I32("vpermi2d xmm7,xmm2,xmm1", 0x62, 0xf2, 0x6d, 0x08, 0x76, 0xf9);
    /* ymm1, ymm2, ymm3 */
    FCML_A64("vpermi2d %ymm6,%ymm7,%ymm14", 0x62, 0x72, 0x45, 0x28, 0x76, 0xf6);
    FCML_I64("vpermi2d ymm14,ymm7,ymm6", 0x62, 0x72, 0x45, 0x28, 0x76, 0xf6);
    FCML_A32("vpermi2d %ymm5,%ymm3,%ymm6", 0x62, 0xf2, 0x65, 0x28, 0x76, 0xf5);
    FCML_I32("vpermi2d ymm6,ymm3,ymm5", 0x62, 0xf2, 0x65, 0x28, 0x76, 0xf5);
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpermi2d %zmm4,%zmm15,%zmm6", 0x62, 0xf2, 0x05, 0x48, 0x76, 0xf4);
    FCML_I64("vpermi2d zmm6,zmm15,zmm4", 0x62, 0xf2, 0x05, 0x48, 0x76, 0xf4);
    FCML_A32("vpermi2d %zmm4,%zmm6,%zmm6", 0x62, 0xf2, 0x4d, 0x48, 0x76, 0xf4);
    FCML_I32("vpermi2d zmm6,zmm6,zmm4", 0x62, 0xf2, 0x4d, 0x48, 0x76, 0xf4);
    /* disp8 */
    FCML_I32("vpermi2d zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf2, 0x6d, 0x48, 0x76, 0x4c, 0x24, 0x08);
    FCML_A32("vpermi2d 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x48, 0x76, 0x4c, 0x24, 0x08);
    FCML_I64("vpermi2d zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf2, 0x6d, 0x48, 0x76, 0x4c, 0x24, 0x08);
    FCML_A64("vpermi2d 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x48, 0x76, 0x4c, 0x24, 0x08);
    FCML_I32("vpermi2d ymm1,ymm2,ymmword ptr [esp+00000100h]", 0x62, 0xf2, 0x6d, 0x28, 0x76, 0x4c, 0x24, 0x08);
    FCML_A32("vpermi2d 0x00000100(%esp),%ymm2,%ymm1", 0x62, 0xf2, 0x6d, 0x28, 0x76, 0x4c, 0x24, 0x08);
    FCML_I64("vpermi2d ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 0x62, 0xf2, 0x6d, 0x28, 0x76, 0x4c, 0x24, 0x08);
    FCML_A64("vpermi2d 0x0000000000000100(%rsp),%ymm2,%ymm1", 0x62, 0xf2, 0x6d, 0x28, 0x76, 0x4c, 0x24, 0x08);
    FCML_I32("vpermi2d xmm1,xmm2,xmmword ptr [esp+00000080h]", 0x62, 0xf2, 0x6d, 0x08, 0x76, 0x4c, 0x24, 0x08);
    FCML_A32("vpermi2d 0x00000080(%esp),%xmm2,%xmm1", 0x62, 0xf2, 0x6d, 0x08, 0x76, 0x4c, 0x24, 0x08);
    FCML_I64("vpermi2d xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 0x62, 0xf2, 0x6d, 0x08, 0x76, 0x4c, 0x24, 0x08);
    FCML_A64("vpermi2d 0x0000000000000080(%rsp),%xmm2,%xmm1", 0x62, 0xf2, 0x6d, 0x08, 0x76, 0x4c, 0x24, 0x08);
    /* {k}{z} */
    FCML_A64("vpermi2d (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x12, 0x0d, 0x8c, 0x76, 0x14, 0x01);
    FCML_I64("vpermi2d xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x8c, 0x76, 0x14, 0x01);
    FCML_A32("vpermi2d (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf2, 0x45, 0x8d, 0x76, 0x14, 0x01);
    FCML_I32("vpermi2d xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x8d, 0x76, 0x14, 0x01);
    FCML_A64("vpermi2d (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x12, 0x0d, 0xac, 0x76, 0x14, 0x01);
    FCML_I64("vpermi2d ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0xac, 0x76, 0x14, 0x01);
    FCML_A32("vpermi2d (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf2, 0x45, 0xad, 0x76, 0x14, 0x01);
    FCML_I32("vpermi2d ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0xad, 0x76, 0x14, 0x01);
    FCML_A64("vpermi2d (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x12, 0x0d, 0xcc, 0x76, 0x14, 0x01);
    FCML_I64("vpermi2d zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0xcc, 0x76, 0x14, 0x01);
    FCML_A32("vpermi2d (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf2, 0x45, 0xcd, 0x76, 0x14, 0x01);
    FCML_I32("vpermi2d zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0xcd, 0x76, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpermi2d (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x12, 0x0d, 0x0c, 0x76, 0x14, 0x01);
    FCML_I64("vpermi2d xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x0c, 0x76, 0x14, 0x01);
    FCML_A32("vpermi2d (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf2, 0x45, 0x0d, 0x76, 0x14, 0x01);
    FCML_I32("vpermi2d xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x0d, 0x76, 0x14, 0x01);
    FCML_A64("vpermi2d (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x12, 0x0d, 0x2c, 0x76, 0x14, 0x01);
    FCML_I64("vpermi2d ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x2c, 0x76, 0x14, 0x01);
    FCML_A32("vpermi2d (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf2, 0x45, 0x2d, 0x76, 0x14, 0x01);
    FCML_I32("vpermi2d ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x2d, 0x76, 0x14, 0x01);
    FCML_A64("vpermi2d (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x12, 0x0d, 0x4c, 0x76, 0x14, 0x01);
    FCML_I64("vpermi2d zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x4c, 0x76, 0x14, 0x01);
    FCML_A32("vpermi2d (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf2, 0x45, 0x4d, 0x76, 0x14, 0x01);
    FCML_I32("vpermi2d zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x4d, 0x76, 0x14, 0x01);
    /* bcast */
    FCML_I64("vpermi2d zmm31,zmm21,dword ptr [rsi]{1to16}", 0x62, 0x62, 0x55, 0x50, 0x76, 0x3e);
    FCML_A64("vpermi2d (%rsi){1to16},%zmm21,%zmm31", 0x62, 0x62, 0x55, 0x50, 0x76, 0x3e);
    FCML_I64("vpermi2d ymm31,ymm21,dword ptr [rsi]{1to8}", 0x62, 0x62, 0x55, 0x30, 0x76, 0x3e);
    FCML_A64("vpermi2d (%rsi){1to8},%ymm21,%ymm31", 0x62, 0x62, 0x55, 0x30, 0x76, 0x3e);
    FCML_I64("vpermi2d xmm31,xmm21,dword ptr [rsi]{1to4}", 0x62, 0x62, 0x55, 0x10, 0x76, 0x3e);
    FCML_A64("vpermi2d (%rsi){1to4},%xmm21,%xmm31", 0x62, 0x62, 0x55, 0x10, 0x76, 0x3e);
    FCML_A32("vpermi2d (%esi){1to16},%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x58, 0x76, 0x0e);
    FCML_I32("vpermi2d zmm1,zmm2,dword ptr [esi]{1to16}", 0x62, 0xf2, 0x6d, 0x58, 0x76, 0x0e);
    /* {k}{z}{bcast} */
    FCML_A64("vpermi2d (%rsi){1to8},%ymm21,%ymm31{%k7}{z}", 0x62, 0x62, 0x55, 0xb7, 0x76, 0x3e);
    FCML_I64("vpermi2d ymm31{k7}{z},ymm21,dword ptr [rsi]{1to8}", 0x62, 0x62, 0x55, 0xb7, 0x76, 0x3e);
    /* {bcast} disp8 */
    FCML_I32("vpermi2d zmm1,zmm2,dword ptr [esp+00000020h]{1to16}", 0x62, 0xf2, 0x6d, 0x58, 0x76, 0x4c, 0x24, 0x08);
    FCML_A32("vpermi2d 0x00000020(%esp){1to16},%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x58, 0x76, 0x4c, 0x24, 0x08);
    FCML_I64("vpermi2d zmm1,zmm2,dword ptr [rsp+0000000000000020h]{1to16}", 0x62, 0xf2, 0x6d, 0x58, 0x76, 0x4c, 0x24, 0x08);
    FCML_A64("vpermi2d 0x0000000000000020(%rsp){1to16},%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x58, 0x76, 0x4c, 0x24, 0x08);
    FCML_I32("vpermi2d ymm1,ymm2,dword ptr [esp+00000020h]{1to8}", 0x62, 0xf2, 0x6d, 0x38, 0x76, 0x4c, 0x24, 0x08);
    FCML_A32("vpermi2d 0x00000020(%esp){1to8},%ymm2,%ymm1", 0x62, 0xf2, 0x6d, 0x38, 0x76, 0x4c, 0x24, 0x08);
    FCML_I64("vpermi2d ymm1,ymm2,dword ptr [rsp+0000000000000020h]{1to8}", 0x62, 0xf2, 0x6d, 0x38, 0x76, 0x4c, 0x24, 0x08);
    FCML_A64("vpermi2d 0x0000000000000020(%rsp){1to8},%ymm2,%ymm1", 0x62, 0xf2, 0x6d, 0x38, 0x76, 0x4c, 0x24, 0x08);
    FCML_I32("vpermi2d xmm1,xmm2,dword ptr [esp+00000020h]{1to4}", 0x62, 0xf2, 0x6d, 0x18, 0x76, 0x4c, 0x24, 0x08);
    FCML_A32("vpermi2d 0x00000020(%esp){1to4},%xmm2,%xmm1", 0x62, 0xf2, 0x6d, 0x18, 0x76, 0x4c, 0x24, 0x08);
    FCML_I64("vpermi2d xmm1,xmm2,dword ptr [rsp+0000000000000020h]{1to4}", 0x62, 0xf2, 0x6d, 0x18, 0x76, 0x4c, 0x24, 0x08);
    FCML_A64("vpermi2d 0x0000000000000020(%rsp){1to4},%xmm2,%xmm1", 0x62, 0xf2, 0x6d, 0x18, 0x76, 0x4c, 0x24, 0x08);
}

void fcml_tf_instruction_VPERMI2Q(void) {
    /* xmm1, xmm2, m128 */
    FCML_A64("vpermi2q (%rax),%xmm7,%xmm15", 0x62, 0x72, 0xc5, 0x08, 0x76, 0x38);
    FCML_I64("vpermi2q xmm15,xmm7,xmmword ptr [rax]", 0x62, 0x72, 0xc5, 0x08, 0x76, 0x38);
    FCML_A32("vpermi2q (%eax),%xmm6,%xmm7", 0x62, 0xf2, 0xcd, 0x08, 0x76, 0x38);
    FCML_I32("vpermi2q xmm7,xmm6,xmmword ptr [eax]", 0x62, 0xf2, 0xcd, 0x08, 0x76, 0x38);
    /* ymm1, ymm2, m256 */
    FCML_A64("vpermi2q (%rax),%ymm7,%ymm15", 0x62, 0x72, 0xc5, 0x28, 0x76, 0x38);
    FCML_I64("vpermi2q ymm15,ymm7,ymmword ptr [rax]", 0x62, 0x72, 0xc5, 0x28, 0x76, 0x38);
    FCML_A32("vpermi2q (%eax),%ymm5,%ymm7", 0x62, 0xf2, 0xd5, 0x28, 0x76, 0x38);
    FCML_I32("vpermi2q ymm7,ymm5,ymmword ptr [eax]", 0x62, 0xf2, 0xd5, 0x28, 0x76, 0x38);
    /* zmm1, zmm2, m512 */
    FCML_A64("vpermi2q (%rax),%zmm7,%zmm15", 0x62, 0x72, 0xc5, 0x48, 0x76, 0x38);
    FCML_I64("vpermi2q zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x72, 0xc5, 0x48, 0x76, 0x38);
    FCML_A32("vpermi2q (%eax),%zmm3,%zmm7", 0x62, 0xf2, 0xe5, 0x48, 0x76, 0x38);
    FCML_I32("vpermi2q zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf2, 0xe5, 0x48, 0x76, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64("vpermi2q %xmm1,%xmm7,%xmm15", 0x62, 0x72, 0xc5, 0x08, 0x76, 0xf9);
    FCML_I64("vpermi2q xmm15,xmm7,xmm1", 0x62, 0x72, 0xc5, 0x08, 0x76, 0xf9);
    FCML_A32("vpermi2q %xmm1,%xmm2,%xmm7", 0x62, 0xf2, 0xed, 0x08, 0x76, 0xf9);
    FCML_I32("vpermi2q xmm7,xmm2,xmm1", 0x62, 0xf2, 0xed, 0x08, 0x76, 0xf9);
    /* ymm1, ymm2, ymm3 */
    FCML_A64("vpermi2q %ymm6,%ymm7,%ymm14", 0x62, 0x72, 0xc5, 0x28, 0x76, 0xf6);
    FCML_I64("vpermi2q ymm14,ymm7,ymm6", 0x62, 0x72, 0xc5, 0x28, 0x76, 0xf6);
    FCML_A32("vpermi2q %ymm5,%ymm3,%ymm6", 0x62, 0xf2, 0xe5, 0x28, 0x76, 0xf5);
    FCML_I32("vpermi2q ymm6,ymm3,ymm5", 0x62, 0xf2, 0xe5, 0x28, 0x76, 0xf5);
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpermi2q %zmm4,%zmm15,%zmm6", 0x62, 0xf2, 0x85, 0x48, 0x76, 0xf4);
    FCML_I64("vpermi2q zmm6,zmm15,zmm4", 0x62, 0xf2, 0x85, 0x48, 0x76, 0xf4);
    FCML_A32("vpermi2q %zmm4,%zmm6,%zmm6", 0x62, 0xf2, 0xcd, 0x48, 0x76, 0xf4);
    FCML_I32("vpermi2q zmm6,zmm6,zmm4", 0x62, 0xf2, 0xcd, 0x48, 0x76, 0xf4);
    /* disp8 */
    FCML_I32("vpermi2q zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf2, 0xed, 0x48, 0x76, 0x4c, 0x24, 0x08);
    FCML_A32("vpermi2q 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x48, 0x76, 0x4c, 0x24, 0x08);
    FCML_I64("vpermi2q zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf2, 0xed, 0x48, 0x76, 0x4c, 0x24, 0x08);
    FCML_A64("vpermi2q 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x48, 0x76, 0x4c, 0x24, 0x08);
    FCML_I32("vpermi2q ymm1,ymm2,ymmword ptr [esp+00000100h]", 0x62, 0xf2, 0xed, 0x28, 0x76, 0x4c, 0x24, 0x08);
    FCML_A32("vpermi2q 0x00000100(%esp),%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x28, 0x76, 0x4c, 0x24, 0x08);
    FCML_I64("vpermi2q ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 0x62, 0xf2, 0xed, 0x28, 0x76, 0x4c, 0x24, 0x08);
    FCML_A64("vpermi2q 0x0000000000000100(%rsp),%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x28, 0x76, 0x4c, 0x24, 0x08);
    FCML_I32("vpermi2q xmm1,xmm2,xmmword ptr [esp+00000080h]", 0x62, 0xf2, 0xed, 0x08, 0x76, 0x4c, 0x24, 0x08);
    FCML_A32("vpermi2q 0x00000080(%esp),%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x08, 0x76, 0x4c, 0x24, 0x08);
    FCML_I64("vpermi2q xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 0x62, 0xf2, 0xed, 0x08, 0x76, 0x4c, 0x24, 0x08);
    FCML_A64("vpermi2q 0x0000000000000080(%rsp),%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x08, 0x76, 0x4c, 0x24, 0x08);
    /* {k}{z} */
    FCML_A64("vpermi2q (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x12, 0x8d, 0x8c, 0x76, 0x14, 0x01);
    FCML_I64("vpermi2q xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x8c, 0x76, 0x14, 0x01);
    FCML_A32("vpermi2q (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0x8d, 0x76, 0x14, 0x01);
    FCML_I32("vpermi2q xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x8d, 0x76, 0x14, 0x01);
    FCML_A64("vpermi2q (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x12, 0x8d, 0xac, 0x76, 0x14, 0x01);
    FCML_I64("vpermi2q ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0xac, 0x76, 0x14, 0x01);
    FCML_A32("vpermi2q (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0xad, 0x76, 0x14, 0x01);
    FCML_I32("vpermi2q ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0xad, 0x76, 0x14, 0x01);
    FCML_A64("vpermi2q (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x12, 0x8d, 0xcc, 0x76, 0x14, 0x01);
    FCML_I64("vpermi2q zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0xcc, 0x76, 0x14, 0x01);
    FCML_A32("vpermi2q (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0xcd, 0x76, 0x14, 0x01);
    FCML_I32("vpermi2q zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0xcd, 0x76, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpermi2q (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x12, 0x8d, 0x0c, 0x76, 0x14, 0x01);
    FCML_I64("vpermi2q xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x0c, 0x76, 0x14, 0x01);
    FCML_A32("vpermi2q (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf2, 0xc5, 0x0d, 0x76, 0x14, 0x01);
    FCML_I32("vpermi2q xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x0d, 0x76, 0x14, 0x01);
    FCML_A64("vpermi2q (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x12, 0x8d, 0x2c, 0x76, 0x14, 0x01);
    FCML_I64("vpermi2q ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x2c, 0x76, 0x14, 0x01);
    FCML_A32("vpermi2q (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf2, 0xc5, 0x2d, 0x76, 0x14, 0x01);
    FCML_I32("vpermi2q ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x2d, 0x76, 0x14, 0x01);
    FCML_A64("vpermi2q (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x12, 0x8d, 0x4c, 0x76, 0x14, 0x01);
    FCML_I64("vpermi2q zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x4c, 0x76, 0x14, 0x01);
    FCML_A32("vpermi2q (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf2, 0xc5, 0x4d, 0x76, 0x14, 0x01);
    FCML_I32("vpermi2q zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x4d, 0x76, 0x14, 0x01);
    /* bcast */
    FCML_I64("vpermi2q zmm31,zmm21,mmword ptr [rsi]{1to8}", 0x62, 0x62, 0xd5, 0x50, 0x76, 0x3e);
    FCML_A64("vpermi2q (%rsi){1to8},%zmm21,%zmm31", 0x62, 0x62, 0xd5, 0x50, 0x76, 0x3e);
    FCML_I64("vpermi2q ymm31,ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x62, 0xd5, 0x30, 0x76, 0x3e);
    FCML_A64("vpermi2q (%rsi){1to4},%ymm21,%ymm31", 0x62, 0x62, 0xd5, 0x30, 0x76, 0x3e);
    FCML_I64("vpermi2q xmm31,xmm21,mmword ptr [rsi]{1to2}", 0x62, 0x62, 0xd5, 0x10, 0x76, 0x3e);
    FCML_A64("vpermi2q (%rsi){1to2},%xmm21,%xmm31", 0x62, 0x62, 0xd5, 0x10, 0x76, 0x3e);
    FCML_A32("vpermi2q (%esi){1to8},%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x58, 0x76, 0x0e);
    FCML_I32("vpermi2q zmm1,zmm2,mmword ptr [esi]{1to8}", 0x62, 0xf2, 0xed, 0x58, 0x76, 0x0e);
    /* {k}{z}{bcast} */
    FCML_A64("vpermi2q (%rsi){1to4},%ymm21,%ymm31{%k7}{z}", 0x62, 0x62, 0xd5, 0xb7, 0x76, 0x3e);
    FCML_I64("vpermi2q ymm31{k7}{z},ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x62, 0xd5, 0xb7, 0x76, 0x3e);
    /* {bcast} disp8 */
    FCML_I32("vpermi2q zmm1,zmm2,mmword ptr [esp+00000040h]{1to8}", 0x62, 0xf2, 0xed, 0x58, 0x76, 0x4c, 0x24, 0x08);
    FCML_A32("vpermi2q 0x00000040(%esp){1to8},%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x58, 0x76, 0x4c, 0x24, 0x08);
    FCML_I64("vpermi2q zmm1,zmm2,mmword ptr [rsp+0000000000000040h]{1to8}", 0x62, 0xf2, 0xed, 0x58, 0x76, 0x4c, 0x24, 0x08);
    FCML_A64("vpermi2q 0x0000000000000040(%rsp){1to8},%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x58, 0x76, 0x4c, 0x24, 0x08);
    FCML_I32("vpermi2q ymm1,ymm2,mmword ptr [esp+00000040h]{1to4}", 0x62, 0xf2, 0xed, 0x38, 0x76, 0x4c, 0x24, 0x08);
    FCML_A32("vpermi2q 0x00000040(%esp){1to4},%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x38, 0x76, 0x4c, 0x24, 0x08);
    FCML_I64("vpermi2q ymm1,ymm2,mmword ptr [rsp+0000000000000040h]{1to4}", 0x62, 0xf2, 0xed, 0x38, 0x76, 0x4c, 0x24, 0x08);
    FCML_A64("vpermi2q 0x0000000000000040(%rsp){1to4},%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x38, 0x76, 0x4c, 0x24, 0x08);
    FCML_I32("vpermi2q xmm1,xmm2,mmword ptr [esp+00000040h]{1to2}", 0x62, 0xf2, 0xed, 0x18, 0x76, 0x4c, 0x24, 0x08);
    FCML_A32("vpermi2q 0x00000040(%esp){1to2},%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x18, 0x76, 0x4c, 0x24, 0x08);
    FCML_I64("vpermi2q xmm1,xmm2,mmword ptr [rsp+0000000000000040h]{1to2}", 0x62, 0xf2, 0xed, 0x18, 0x76, 0x4c, 0x24, 0x08);
    FCML_A64("vpermi2q 0x0000000000000040(%rsp){1to2},%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x18, 0x76, 0x4c, 0x24, 0x08);
}

void fcml_tf_instruction_VPERMI2PS(void) {
    /* xmm1, xmm2, m128 */
    FCML_A64("vpermi2ps (%rax),%xmm7,%xmm15", 0x62, 0x72, 0x45, 0x08, 0x77, 0x38);
    FCML_I64("vpermi2ps xmm15,xmm7,xmmword ptr [rax]", 0x62, 0x72, 0x45, 0x08, 0x77, 0x38);
    FCML_A32("vpermi2ps (%eax),%xmm6,%xmm7", 0x62, 0xf2, 0x4d, 0x08, 0x77, 0x38);
    FCML_I32("vpermi2ps xmm7,xmm6,xmmword ptr [eax]", 0x62, 0xf2, 0x4d, 0x08, 0x77, 0x38);
    /* ymm1, ymm2, m256 */
    FCML_A64("vpermi2ps (%rax),%ymm7,%ymm15", 0x62, 0x72, 0x45, 0x28, 0x77, 0x38);
    FCML_I64("vpermi2ps ymm15,ymm7,ymmword ptr [rax]", 0x62, 0x72, 0x45, 0x28, 0x77, 0x38);
    FCML_A32("vpermi2ps (%eax),%ymm5,%ymm7", 0x62, 0xf2, 0x55, 0x28, 0x77, 0x38);
    FCML_I32("vpermi2ps ymm7,ymm5,ymmword ptr [eax]", 0x62, 0xf2, 0x55, 0x28, 0x77, 0x38);
    /* zmm1, zmm2, m512 */
    FCML_A64("vpermi2ps (%rax),%zmm7,%zmm15", 0x62, 0x72, 0x45, 0x48, 0x77, 0x38);
    FCML_I64("vpermi2ps zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x72, 0x45, 0x48, 0x77, 0x38);
    FCML_A32("vpermi2ps (%eax),%zmm3,%zmm7", 0x62, 0xf2, 0x65, 0x48, 0x77, 0x38);
    FCML_I32("vpermi2ps zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf2, 0x65, 0x48, 0x77, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64("vpermi2ps %xmm1,%xmm7,%xmm15", 0x62, 0x72, 0x45, 0x08, 0x77, 0xf9);
    FCML_I64("vpermi2ps xmm15,xmm7,xmm1", 0x62, 0x72, 0x45, 0x08, 0x77, 0xf9);
    FCML_A32("vpermi2ps %xmm1,%xmm2,%xmm7", 0x62, 0xf2, 0x6d, 0x08, 0x77, 0xf9);
    FCML_I32("vpermi2ps xmm7,xmm2,xmm1", 0x62, 0xf2, 0x6d, 0x08, 0x77, 0xf9);
    /* ymm1, ymm2, ymm3 */
    FCML_A64("vpermi2ps %ymm6,%ymm7,%ymm14", 0x62, 0x72, 0x45, 0x28, 0x77, 0xf6);
    FCML_I64("vpermi2ps ymm14,ymm7,ymm6", 0x62, 0x72, 0x45, 0x28, 0x77, 0xf6);
    FCML_A32("vpermi2ps %ymm5,%ymm3,%ymm6", 0x62, 0xf2, 0x65, 0x28, 0x77, 0xf5);
    FCML_I32("vpermi2ps ymm6,ymm3,ymm5", 0x62, 0xf2, 0x65, 0x28, 0x77, 0xf5);
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpermi2ps %zmm4,%zmm15,%zmm6", 0x62, 0xf2, 0x05, 0x48, 0x77, 0xf4);
    FCML_I64("vpermi2ps zmm6,zmm15,zmm4", 0x62, 0xf2, 0x05, 0x48, 0x77, 0xf4);
    FCML_A32("vpermi2ps %zmm4,%zmm6,%zmm6", 0x62, 0xf2, 0x4d, 0x48, 0x77, 0xf4);
    FCML_I32("vpermi2ps zmm6,zmm6,zmm4", 0x62, 0xf2, 0x4d, 0x48, 0x77, 0xf4);
    /* disp8 */
    FCML_I32("vpermi2ps zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf2, 0x6d, 0x48, 0x77, 0x4c, 0x24, 0x08);
    FCML_A32("vpermi2ps 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x48, 0x77, 0x4c, 0x24, 0x08);
    FCML_I64("vpermi2ps zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf2, 0x6d, 0x48, 0x77, 0x4c, 0x24, 0x08);
    FCML_A64("vpermi2ps 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x48, 0x77, 0x4c, 0x24, 0x08);
    FCML_I32("vpermi2ps ymm1,ymm2,ymmword ptr [esp+00000100h]", 0x62, 0xf2, 0x6d, 0x28, 0x77, 0x4c, 0x24, 0x08);
    FCML_A32("vpermi2ps 0x00000100(%esp),%ymm2,%ymm1", 0x62, 0xf2, 0x6d, 0x28, 0x77, 0x4c, 0x24, 0x08);
    FCML_I64("vpermi2ps ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 0x62, 0xf2, 0x6d, 0x28, 0x77, 0x4c, 0x24, 0x08);
    FCML_A64("vpermi2ps 0x0000000000000100(%rsp),%ymm2,%ymm1", 0x62, 0xf2, 0x6d, 0x28, 0x77, 0x4c, 0x24, 0x08);
    FCML_I32("vpermi2ps xmm1,xmm2,xmmword ptr [esp+00000080h]", 0x62, 0xf2, 0x6d, 0x08, 0x77, 0x4c, 0x24, 0x08);
    FCML_A32("vpermi2ps 0x00000080(%esp),%xmm2,%xmm1", 0x62, 0xf2, 0x6d, 0x08, 0x77, 0x4c, 0x24, 0x08);
    FCML_I64("vpermi2ps xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 0x62, 0xf2, 0x6d, 0x08, 0x77, 0x4c, 0x24, 0x08);
    FCML_A64("vpermi2ps 0x0000000000000080(%rsp),%xmm2,%xmm1", 0x62, 0xf2, 0x6d, 0x08, 0x77, 0x4c, 0x24, 0x08);
    /* {k}{z} */
    FCML_A64("vpermi2ps (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x12, 0x0d, 0x8c, 0x77, 0x14, 0x01);
    FCML_I64("vpermi2ps xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x8c, 0x77, 0x14, 0x01);
    FCML_A32("vpermi2ps (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf2, 0x45, 0x8d, 0x77, 0x14, 0x01);
    FCML_I32("vpermi2ps xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x8d, 0x77, 0x14, 0x01);
    FCML_A64("vpermi2ps (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x12, 0x0d, 0xac, 0x77, 0x14, 0x01);
    FCML_I64("vpermi2ps ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0xac, 0x77, 0x14, 0x01);
    FCML_A32("vpermi2ps (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf2, 0x45, 0xad, 0x77, 0x14, 0x01);
    FCML_I32("vpermi2ps ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0xad, 0x77, 0x14, 0x01);
    FCML_A64("vpermi2ps (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x12, 0x0d, 0xcc, 0x77, 0x14, 0x01);
    FCML_I64("vpermi2ps zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0xcc, 0x77, 0x14, 0x01);
    FCML_A32("vpermi2ps (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf2, 0x45, 0xcd, 0x77, 0x14, 0x01);
    FCML_I32("vpermi2ps zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0xcd, 0x77, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpermi2ps (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x12, 0x0d, 0x0c, 0x77, 0x14, 0x01);
    FCML_I64("vpermi2ps xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x0c, 0x77, 0x14, 0x01);
    FCML_A32("vpermi2ps (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf2, 0x45, 0x0d, 0x77, 0x14, 0x01);
    FCML_I32("vpermi2ps xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x0d, 0x77, 0x14, 0x01);
    FCML_A64("vpermi2ps (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x12, 0x0d, 0x2c, 0x77, 0x14, 0x01);
    FCML_I64("vpermi2ps ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x2c, 0x77, 0x14, 0x01);
    FCML_A32("vpermi2ps (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf2, 0x45, 0x2d, 0x77, 0x14, 0x01);
    FCML_I32("vpermi2ps ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x2d, 0x77, 0x14, 0x01);
    FCML_A64("vpermi2ps (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x12, 0x0d, 0x4c, 0x77, 0x14, 0x01);
    FCML_I64("vpermi2ps zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x4c, 0x77, 0x14, 0x01);
    FCML_A32("vpermi2ps (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf2, 0x45, 0x4d, 0x77, 0x14, 0x01);
    FCML_I32("vpermi2ps zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x4d, 0x77, 0x14, 0x01);
    /* bcast */
    FCML_I64("vpermi2ps zmm31,zmm21,dword ptr [rsi]{1to16}", 0x62, 0x62, 0x55, 0x50, 0x77, 0x3e);
    FCML_A64("vpermi2ps (%rsi){1to16},%zmm21,%zmm31", 0x62, 0x62, 0x55, 0x50, 0x77, 0x3e);
    FCML_I64("vpermi2ps ymm31,ymm21,dword ptr [rsi]{1to8}", 0x62, 0x62, 0x55, 0x30, 0x77, 0x3e);
    FCML_A64("vpermi2ps (%rsi){1to8},%ymm21,%ymm31", 0x62, 0x62, 0x55, 0x30, 0x77, 0x3e);
    FCML_I64("vpermi2ps xmm31,xmm21,dword ptr [rsi]{1to4}", 0x62, 0x62, 0x55, 0x10, 0x77, 0x3e);
    FCML_A64("vpermi2ps (%rsi){1to4},%xmm21,%xmm31", 0x62, 0x62, 0x55, 0x10, 0x77, 0x3e);
    FCML_A32("vpermi2ps (%esi){1to16},%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x58, 0x77, 0x0e);
    FCML_I32("vpermi2ps zmm1,zmm2,dword ptr [esi]{1to16}", 0x62, 0xf2, 0x6d, 0x58, 0x77, 0x0e);
    /* {k}{z}{bcast} */
    FCML_A64("vpermi2ps (%rsi){1to8},%ymm21,%ymm31{%k7}{z}", 0x62, 0x62, 0x55, 0xb7, 0x77, 0x3e);
    FCML_I64("vpermi2ps ymm31{k7}{z},ymm21,dword ptr [rsi]{1to8}", 0x62, 0x62, 0x55, 0xb7, 0x77, 0x3e);
    /* {bcast} disp8 */
    FCML_I32("vpermi2ps zmm1,zmm2,dword ptr [esp+00000020h]{1to16}", 0x62, 0xf2, 0x6d, 0x58, 0x77, 0x4c, 0x24, 0x08);
    FCML_A32("vpermi2ps 0x00000020(%esp){1to16},%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x58, 0x77, 0x4c, 0x24, 0x08);
    FCML_I64("vpermi2ps zmm1,zmm2,dword ptr [rsp+0000000000000020h]{1to16}", 0x62, 0xf2, 0x6d, 0x58, 0x77, 0x4c, 0x24, 0x08);
    FCML_A64("vpermi2ps 0x0000000000000020(%rsp){1to16},%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x58, 0x77, 0x4c, 0x24, 0x08);
    FCML_I32("vpermi2ps ymm1,ymm2,dword ptr [esp+00000020h]{1to8}", 0x62, 0xf2, 0x6d, 0x38, 0x77, 0x4c, 0x24, 0x08);
    FCML_A32("vpermi2ps 0x00000020(%esp){1to8},%ymm2,%ymm1", 0x62, 0xf2, 0x6d, 0x38, 0x77, 0x4c, 0x24, 0x08);
    FCML_I64("vpermi2ps ymm1,ymm2,dword ptr [rsp+0000000000000020h]{1to8}", 0x62, 0xf2, 0x6d, 0x38, 0x77, 0x4c, 0x24, 0x08);
    FCML_A64("vpermi2ps 0x0000000000000020(%rsp){1to8},%ymm2,%ymm1", 0x62, 0xf2, 0x6d, 0x38, 0x77, 0x4c, 0x24, 0x08);
    FCML_I32("vpermi2ps xmm1,xmm2,dword ptr [esp+00000020h]{1to4}", 0x62, 0xf2, 0x6d, 0x18, 0x77, 0x4c, 0x24, 0x08);
    FCML_A32("vpermi2ps 0x00000020(%esp){1to4},%xmm2,%xmm1", 0x62, 0xf2, 0x6d, 0x18, 0x77, 0x4c, 0x24, 0x08);
    FCML_I64("vpermi2ps xmm1,xmm2,dword ptr [rsp+0000000000000020h]{1to4}", 0x62, 0xf2, 0x6d, 0x18, 0x77, 0x4c, 0x24, 0x08);
    FCML_A64("vpermi2ps 0x0000000000000020(%rsp){1to4},%xmm2,%xmm1", 0x62, 0xf2, 0x6d, 0x18, 0x77, 0x4c, 0x24, 0x08);
}

void fcml_tf_instruction_VPERMI2PD(void) {
    /* xmm1, xmm2, m128 */
    FCML_A64("vpermi2pd (%rax),%xmm7,%xmm15", 0x62, 0x72, 0xc5, 0x08, 0x77, 0x38);
    FCML_I64("vpermi2pd xmm15,xmm7,xmmword ptr [rax]", 0x62, 0x72, 0xc5, 0x08, 0x77, 0x38);
    FCML_A32("vpermi2pd (%eax),%xmm6,%xmm7", 0x62, 0xf2, 0xcd, 0x08, 0x77, 0x38);
    FCML_I32("vpermi2pd xmm7,xmm6,xmmword ptr [eax]", 0x62, 0xf2, 0xcd, 0x08, 0x77, 0x38);
    /* ymm1, ymm2, m256 */
    FCML_A64("vpermi2pd (%rax),%ymm7,%ymm15", 0x62, 0x72, 0xc5, 0x28, 0x77, 0x38);
    FCML_I64("vpermi2pd ymm15,ymm7,ymmword ptr [rax]", 0x62, 0x72, 0xc5, 0x28, 0x77, 0x38);
    FCML_A32("vpermi2pd (%eax),%ymm5,%ymm7", 0x62, 0xf2, 0xd5, 0x28, 0x77, 0x38);
    FCML_I32("vpermi2pd ymm7,ymm5,ymmword ptr [eax]", 0x62, 0xf2, 0xd5, 0x28, 0x77, 0x38);
    /* zmm1, zmm2, m512 */
    FCML_A64("vpermi2pd (%rax),%zmm7,%zmm15", 0x62, 0x72, 0xc5, 0x48, 0x77, 0x38);
    FCML_I64("vpermi2pd zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x72, 0xc5, 0x48, 0x77, 0x38);
    FCML_A32("vpermi2pd (%eax),%zmm3,%zmm7", 0x62, 0xf2, 0xe5, 0x48, 0x77, 0x38);
    FCML_I32("vpermi2pd zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf2, 0xe5, 0x48, 0x77, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64("vpermi2pd %xmm1,%xmm7,%xmm15", 0x62, 0x72, 0xc5, 0x08, 0x77, 0xf9);
    FCML_I64("vpermi2pd xmm15,xmm7,xmm1", 0x62, 0x72, 0xc5, 0x08, 0x77, 0xf9);
    FCML_A32("vpermi2pd %xmm1,%xmm2,%xmm7", 0x62, 0xf2, 0xed, 0x08, 0x77, 0xf9);
    FCML_I32("vpermi2pd xmm7,xmm2,xmm1", 0x62, 0xf2, 0xed, 0x08, 0x77, 0xf9);
    /* ymm1, ymm2, ymm3 */
    FCML_A64("vpermi2pd %ymm6,%ymm7,%ymm14", 0x62, 0x72, 0xc5, 0x28, 0x77, 0xf6);
    FCML_I64("vpermi2pd ymm14,ymm7,ymm6", 0x62, 0x72, 0xc5, 0x28, 0x77, 0xf6);
    FCML_A32("vpermi2pd %ymm5,%ymm3,%ymm6", 0x62, 0xf2, 0xe5, 0x28, 0x77, 0xf5);
    FCML_I32("vpermi2pd ymm6,ymm3,ymm5", 0x62, 0xf2, 0xe5, 0x28, 0x77, 0xf5);
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpermi2pd %zmm4,%zmm15,%zmm6", 0x62, 0xf2, 0x85, 0x48, 0x77, 0xf4);
    FCML_I64("vpermi2pd zmm6,zmm15,zmm4", 0x62, 0xf2, 0x85, 0x48, 0x77, 0xf4);
    FCML_A32("vpermi2pd %zmm4,%zmm6,%zmm6", 0x62, 0xf2, 0xcd, 0x48, 0x77, 0xf4);
    FCML_I32("vpermi2pd zmm6,zmm6,zmm4", 0x62, 0xf2, 0xcd, 0x48, 0x77, 0xf4);
    /* disp8 */
    FCML_I32("vpermi2pd zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf2, 0xed, 0x48, 0x77, 0x4c, 0x24, 0x08);
    FCML_A32("vpermi2pd 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x48, 0x77, 0x4c, 0x24, 0x08);
    FCML_I64("vpermi2pd zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf2, 0xed, 0x48, 0x77, 0x4c, 0x24, 0x08);
    FCML_A64("vpermi2pd 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x48, 0x77, 0x4c, 0x24, 0x08);
    FCML_I32("vpermi2pd ymm1,ymm2,ymmword ptr [esp+00000100h]", 0x62, 0xf2, 0xed, 0x28, 0x77, 0x4c, 0x24, 0x08);
    FCML_A32("vpermi2pd 0x00000100(%esp),%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x28, 0x77, 0x4c, 0x24, 0x08);
    FCML_I64("vpermi2pd ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 0x62, 0xf2, 0xed, 0x28, 0x77, 0x4c, 0x24, 0x08);
    FCML_A64("vpermi2pd 0x0000000000000100(%rsp),%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x28, 0x77, 0x4c, 0x24, 0x08);
    FCML_I32("vpermi2pd xmm1,xmm2,xmmword ptr [esp+00000080h]", 0x62, 0xf2, 0xed, 0x08, 0x77, 0x4c, 0x24, 0x08);
    FCML_A32("vpermi2pd 0x00000080(%esp),%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x08, 0x77, 0x4c, 0x24, 0x08);
    FCML_I64("vpermi2pd xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 0x62, 0xf2, 0xed, 0x08, 0x77, 0x4c, 0x24, 0x08);
    FCML_A64("vpermi2pd 0x0000000000000080(%rsp),%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x08, 0x77, 0x4c, 0x24, 0x08);
    /* {k}{z} */
    FCML_A64("vpermi2pd (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x12, 0x8d, 0x8c, 0x77, 0x14, 0x01);
    FCML_I64("vpermi2pd xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x8c, 0x77, 0x14, 0x01);
    FCML_A32("vpermi2pd (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0x8d, 0x77, 0x14, 0x01);
    FCML_I32("vpermi2pd xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x8d, 0x77, 0x14, 0x01);
    FCML_A64("vpermi2pd (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x12, 0x8d, 0xac, 0x77, 0x14, 0x01);
    FCML_I64("vpermi2pd ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0xac, 0x77, 0x14, 0x01);
    FCML_A32("vpermi2pd (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0xad, 0x77, 0x14, 0x01);
    FCML_I32("vpermi2pd ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0xad, 0x77, 0x14, 0x01);
    FCML_A64("vpermi2pd (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x12, 0x8d, 0xcc, 0x77, 0x14, 0x01);
    FCML_I64("vpermi2pd zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0xcc, 0x77, 0x14, 0x01);
    FCML_A32("vpermi2pd (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0xcd, 0x77, 0x14, 0x01);
    FCML_I32("vpermi2pd zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0xcd, 0x77, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpermi2pd (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x12, 0x8d, 0x0c, 0x77, 0x14, 0x01);
    FCML_I64("vpermi2pd xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x0c, 0x77, 0x14, 0x01);
    FCML_A32("vpermi2pd (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf2, 0xc5, 0x0d, 0x77, 0x14, 0x01);
    FCML_I32("vpermi2pd xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x0d, 0x77, 0x14, 0x01);
    FCML_A64("vpermi2pd (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x12, 0x8d, 0x2c, 0x77, 0x14, 0x01);
    FCML_I64("vpermi2pd ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x2c, 0x77, 0x14, 0x01);
    FCML_A32("vpermi2pd (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf2, 0xc5, 0x2d, 0x77, 0x14, 0x01);
    FCML_I32("vpermi2pd ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x2d, 0x77, 0x14, 0x01);
    FCML_A64("vpermi2pd (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x12, 0x8d, 0x4c, 0x77, 0x14, 0x01);
    FCML_I64("vpermi2pd zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x4c, 0x77, 0x14, 0x01);
    FCML_A32("vpermi2pd (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf2, 0xc5, 0x4d, 0x77, 0x14, 0x01);
    FCML_I32("vpermi2pd zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x4d, 0x77, 0x14, 0x01);
    /* bcast */
    FCML_I64("vpermi2pd zmm31,zmm21,mmword ptr [rsi]{1to8}", 0x62, 0x62, 0xd5, 0x50, 0x77, 0x3e);
    FCML_A64("vpermi2pd (%rsi){1to8},%zmm21,%zmm31", 0x62, 0x62, 0xd5, 0x50, 0x77, 0x3e);
    FCML_I64("vpermi2pd ymm31,ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x62, 0xd5, 0x30, 0x77, 0x3e);
    FCML_A64("vpermi2pd (%rsi){1to4},%ymm21,%ymm31", 0x62, 0x62, 0xd5, 0x30, 0x77, 0x3e);
    FCML_I64("vpermi2pd xmm31,xmm21,mmword ptr [rsi]{1to2}", 0x62, 0x62, 0xd5, 0x10, 0x77, 0x3e);
    FCML_A64("vpermi2pd (%rsi){1to2},%xmm21,%xmm31", 0x62, 0x62, 0xd5, 0x10, 0x77, 0x3e);
    FCML_A32("vpermi2pd (%esi){1to8},%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x58, 0x77, 0x0e);
    FCML_I32("vpermi2pd zmm1,zmm2,mmword ptr [esi]{1to8}", 0x62, 0xf2, 0xed, 0x58, 0x77, 0x0e);
    /* {k}{z}{bcast} */
    FCML_A64("vpermi2pd (%rsi){1to4},%ymm21,%ymm31{%k7}{z}", 0x62, 0x62, 0xd5, 0xb7, 0x77, 0x3e);
    FCML_I64("vpermi2pd ymm31{k7}{z},ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x62, 0xd5, 0xb7, 0x77, 0x3e);
    /* {bcast} disp8 */
    FCML_I32("vpermi2pd zmm1,zmm2,mmword ptr [esp+00000040h]{1to8}", 0x62, 0xf2, 0xed, 0x58, 0x77, 0x4c, 0x24, 0x08);
    FCML_A32("vpermi2pd 0x00000040(%esp){1to8},%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x58, 0x77, 0x4c, 0x24, 0x08);
    FCML_I64("vpermi2pd zmm1,zmm2,mmword ptr [rsp+0000000000000040h]{1to8}", 0x62, 0xf2, 0xed, 0x58, 0x77, 0x4c, 0x24, 0x08);
    FCML_A64("vpermi2pd 0x0000000000000040(%rsp){1to8},%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x58, 0x77, 0x4c, 0x24, 0x08);
    FCML_I32("vpermi2pd ymm1,ymm2,mmword ptr [esp+00000040h]{1to4}", 0x62, 0xf2, 0xed, 0x38, 0x77, 0x4c, 0x24, 0x08);
    FCML_A32("vpermi2pd 0x00000040(%esp){1to4},%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x38, 0x77, 0x4c, 0x24, 0x08);
    FCML_I64("vpermi2pd ymm1,ymm2,mmword ptr [rsp+0000000000000040h]{1to4}", 0x62, 0xf2, 0xed, 0x38, 0x77, 0x4c, 0x24, 0x08);
    FCML_A64("vpermi2pd 0x0000000000000040(%rsp){1to4},%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x38, 0x77, 0x4c, 0x24, 0x08);
    FCML_I32("vpermi2pd xmm1,xmm2,mmword ptr [esp+00000040h]{1to2}", 0x62, 0xf2, 0xed, 0x18, 0x77, 0x4c, 0x24, 0x08);
    FCML_A32("vpermi2pd 0x00000040(%esp){1to2},%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x18, 0x77, 0x4c, 0x24, 0x08);
    FCML_I64("vpermi2pd xmm1,xmm2,mmword ptr [rsp+0000000000000040h]{1to2}", 0x62, 0xf2, 0xed, 0x18, 0x77, 0x4c, 0x24, 0x08);
    FCML_A64("vpermi2pd 0x0000000000000040(%rsp){1to2},%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x18, 0x77, 0x4c, 0x24, 0x08);
}

void fcml_tf_instruction_VPERMT2W(void) {
    /* xmm1, xmm2, m128 */
    FCML_A64("vpermt2w (%rax),%xmm7,%xmm15", 0x62, 0x72, 0xc5, 0x08, 0x7d, 0x38);
    FCML_I64("vpermt2w xmm15,xmm7,xmmword ptr [rax]", 0x62, 0x72, 0xc5, 0x08, 0x7d, 0x38);
    FCML_A32("vpermt2w (%eax),%xmm6,%xmm7", 0x62, 0xf2, 0xcd, 0x08, 0x7d, 0x38);
    FCML_I32("vpermt2w xmm7,xmm6,xmmword ptr [eax]", 0x62, 0xf2, 0xcd, 0x08, 0x7d, 0x38);
    /* ymm1, ymm2, m256 */
    FCML_A64("vpermt2w (%rax),%ymm7,%ymm15", 0x62, 0x72, 0xc5, 0x28, 0x7d, 0x38);
    FCML_I64("vpermt2w ymm15,ymm7,ymmword ptr [rax]", 0x62, 0x72, 0xc5, 0x28, 0x7d, 0x38);
    FCML_A32("vpermt2w (%eax),%ymm5,%ymm7", 0x62, 0xf2, 0xd5, 0x28, 0x7d, 0x38);
    FCML_I32("vpermt2w ymm7,ymm5,ymmword ptr [eax]", 0x62, 0xf2, 0xd5, 0x28, 0x7d, 0x38);
    /* zmm1, zmm2, m512 */
    FCML_A64("vpermt2w (%rax),%zmm7,%zmm15", 0x62, 0x72, 0xc5, 0x48, 0x7d, 0x38);
    FCML_I64("vpermt2w zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x72, 0xc5, 0x48, 0x7d, 0x38);
    FCML_A32("vpermt2w (%eax),%zmm3,%zmm7", 0x62, 0xf2, 0xe5, 0x48, 0x7d, 0x38);
    FCML_I32("vpermt2w zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf2, 0xe5, 0x48, 0x7d, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64("vpermt2w %xmm1,%xmm7,%xmm15", 0x62, 0x72, 0xc5, 0x08, 0x7d, 0xf9);
    FCML_I64("vpermt2w xmm15,xmm7,xmm1", 0x62, 0x72, 0xc5, 0x08, 0x7d, 0xf9);
    FCML_A32("vpermt2w %xmm1,%xmm2,%xmm7", 0x62, 0xf2, 0xed, 0x08, 0x7d, 0xf9);
    FCML_I32("vpermt2w xmm7,xmm2,xmm1", 0x62, 0xf2, 0xed, 0x08, 0x7d, 0xf9);
    /* ymm1, ymm2, ymm3 */
    FCML_A64("vpermt2w %ymm6,%ymm7,%ymm14", 0x62, 0x72, 0xc5, 0x28, 0x7d, 0xf6);
    FCML_I64("vpermt2w ymm14,ymm7,ymm6", 0x62, 0x72, 0xc5, 0x28, 0x7d, 0xf6);
    FCML_A32("vpermt2w %ymm5,%ymm3,%ymm6", 0x62, 0xf2, 0xe5, 0x28, 0x7d, 0xf5);
    FCML_I32("vpermt2w ymm6,ymm3,ymm5", 0x62, 0xf2, 0xe5, 0x28, 0x7d, 0xf5);
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpermt2w %zmm4,%zmm15,%zmm6", 0x62, 0xf2, 0x85, 0x48, 0x7d, 0xf4);
    FCML_I64("vpermt2w zmm6,zmm15,zmm4", 0x62, 0xf2, 0x85, 0x48, 0x7d, 0xf4);
    FCML_A32("vpermt2w %zmm4,%zmm6,%zmm6", 0x62, 0xf2, 0xcd, 0x48, 0x7d, 0xf4);
    FCML_I32("vpermt2w zmm6,zmm6,zmm4", 0x62, 0xf2, 0xcd, 0x48, 0x7d, 0xf4);
    /* disp8 */
    FCML_I32("vpermt2w zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf2, 0xed, 0x48, 0x7d, 0x4c, 0x24, 0x08);
    FCML_A32("vpermt2w 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x48, 0x7d, 0x4c, 0x24, 0x08);
    FCML_I64("vpermt2w zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf2, 0xed, 0x48, 0x7d, 0x4c, 0x24, 0x08);
    FCML_A64("vpermt2w 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x48, 0x7d, 0x4c, 0x24, 0x08);
    FCML_I32("vpermt2w ymm1,ymm2,ymmword ptr [esp+00000100h]", 0x62, 0xf2, 0xed, 0x28, 0x7d, 0x4c, 0x24, 0x08);
    FCML_A32("vpermt2w 0x00000100(%esp),%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x28, 0x7d, 0x4c, 0x24, 0x08);
    FCML_I64("vpermt2w ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 0x62, 0xf2, 0xed, 0x28, 0x7d, 0x4c, 0x24, 0x08);
    FCML_A64("vpermt2w 0x0000000000000100(%rsp),%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x28, 0x7d, 0x4c, 0x24, 0x08);
    FCML_I32("vpermt2w xmm1,xmm2,xmmword ptr [esp+00000080h]", 0x62, 0xf2, 0xed, 0x08, 0x7d, 0x4c, 0x24, 0x08);
    FCML_A32("vpermt2w 0x00000080(%esp),%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x08, 0x7d, 0x4c, 0x24, 0x08);
    FCML_I64("vpermt2w xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 0x62, 0xf2, 0xed, 0x08, 0x7d, 0x4c, 0x24, 0x08);
    FCML_A64("vpermt2w 0x0000000000000080(%rsp),%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x08, 0x7d, 0x4c, 0x24, 0x08);
    /* {k}{z} */
    FCML_A64("vpermt2w (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x12, 0x8d, 0x8c, 0x7d, 0x14, 0x01);
    FCML_I64("vpermt2w xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x8c, 0x7d, 0x14, 0x01);
    FCML_A32("vpermt2w (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0x8d, 0x7d, 0x14, 0x01);
    FCML_I32("vpermt2w xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x8d, 0x7d, 0x14, 0x01);
    FCML_A64("vpermt2w (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x12, 0x8d, 0xac, 0x7d, 0x14, 0x01);
    FCML_I64("vpermt2w ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0xac, 0x7d, 0x14, 0x01);
    FCML_A32("vpermt2w (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0xad, 0x7d, 0x14, 0x01);
    FCML_I32("vpermt2w ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0xad, 0x7d, 0x14, 0x01);
    FCML_A64("vpermt2w (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x12, 0x8d, 0xcc, 0x7d, 0x14, 0x01);
    FCML_I64("vpermt2w zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0xcc, 0x7d, 0x14, 0x01);
    FCML_A32("vpermt2w (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0xcd, 0x7d, 0x14, 0x01);
    FCML_I32("vpermt2w zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0xcd, 0x7d, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpermt2w (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x12, 0x8d, 0x0c, 0x7d, 0x14, 0x01);
    FCML_I64("vpermt2w xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x0c, 0x7d, 0x14, 0x01);
    FCML_A32("vpermt2w (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf2, 0xc5, 0x0d, 0x7d, 0x14, 0x01);
    FCML_I32("vpermt2w xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x0d, 0x7d, 0x14, 0x01);
    FCML_A64("vpermt2w (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x12, 0x8d, 0x2c, 0x7d, 0x14, 0x01);
    FCML_I64("vpermt2w ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x2c, 0x7d, 0x14, 0x01);
    FCML_A32("vpermt2w (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf2, 0xc5, 0x2d, 0x7d, 0x14, 0x01);
    FCML_I32("vpermt2w ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x2d, 0x7d, 0x14, 0x01);
    FCML_A64("vpermt2w (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x12, 0x8d, 0x4c, 0x7d, 0x14, 0x01);
    FCML_I64("vpermt2w zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x4c, 0x7d, 0x14, 0x01);
    FCML_A32("vpermt2w (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf2, 0xc5, 0x4d, 0x7d, 0x14, 0x01);
    FCML_I32("vpermt2w zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x4d, 0x7d, 0x14, 0x01);
}

void fcml_tf_instruction_VPERMT2D(void) {
    /* xmm1, xmm2, m128 */
    FCML_A64("vpermt2d (%rax),%xmm7,%xmm15", 0x62, 0x72, 0x45, 0x08, 0x7e, 0x38);
    FCML_I64("vpermt2d xmm15,xmm7,xmmword ptr [rax]", 0x62, 0x72, 0x45, 0x08, 0x7e, 0x38);
    FCML_A32("vpermt2d (%eax),%xmm6,%xmm7", 0x62, 0xf2, 0x4d, 0x08, 0x7e, 0x38);
    FCML_I32("vpermt2d xmm7,xmm6,xmmword ptr [eax]", 0x62, 0xf2, 0x4d, 0x08, 0x7e, 0x38);
    /* ymm1, ymm2, m256 */
    FCML_A64("vpermt2d (%rax),%ymm7,%ymm15", 0x62, 0x72, 0x45, 0x28, 0x7e, 0x38);
    FCML_I64("vpermt2d ymm15,ymm7,ymmword ptr [rax]", 0x62, 0x72, 0x45, 0x28, 0x7e, 0x38);
    FCML_A32("vpermt2d (%eax),%ymm5,%ymm7", 0x62, 0xf2, 0x55, 0x28, 0x7e, 0x38);
    FCML_I32("vpermt2d ymm7,ymm5,ymmword ptr [eax]", 0x62, 0xf2, 0x55, 0x28, 0x7e, 0x38);
    /* zmm1, zmm2, m512 */
    FCML_A64("vpermt2d (%rax),%zmm7,%zmm15", 0x62, 0x72, 0x45, 0x48, 0x7e, 0x38);
    FCML_I64("vpermt2d zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x72, 0x45, 0x48, 0x7e, 0x38);
    FCML_A32("vpermt2d (%eax),%zmm3,%zmm7", 0x62, 0xf2, 0x65, 0x48, 0x7e, 0x38);
    FCML_I32("vpermt2d zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf2, 0x65, 0x48, 0x7e, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64("vpermt2d %xmm1,%xmm7,%xmm15", 0x62, 0x72, 0x45, 0x08, 0x7e, 0xf9);
    FCML_I64("vpermt2d xmm15,xmm7,xmm1", 0x62, 0x72, 0x45, 0x08, 0x7e, 0xf9);
    FCML_A32("vpermt2d %xmm1,%xmm2,%xmm7", 0x62, 0xf2, 0x6d, 0x08, 0x7e, 0xf9);
    FCML_I32("vpermt2d xmm7,xmm2,xmm1", 0x62, 0xf2, 0x6d, 0x08, 0x7e, 0xf9);
    /* ymm1, ymm2, ymm3 */
    FCML_A64("vpermt2d %ymm6,%ymm7,%ymm14", 0x62, 0x72, 0x45, 0x28, 0x7e, 0xf6);
    FCML_I64("vpermt2d ymm14,ymm7,ymm6", 0x62, 0x72, 0x45, 0x28, 0x7e, 0xf6);
    FCML_A32("vpermt2d %ymm5,%ymm3,%ymm6", 0x62, 0xf2, 0x65, 0x28, 0x7e, 0xf5);
    FCML_I32("vpermt2d ymm6,ymm3,ymm5", 0x62, 0xf2, 0x65, 0x28, 0x7e, 0xf5);
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpermt2d %zmm4,%zmm15,%zmm6", 0x62, 0xf2, 0x05, 0x48, 0x7e, 0xf4);
    FCML_I64("vpermt2d zmm6,zmm15,zmm4", 0x62, 0xf2, 0x05, 0x48, 0x7e, 0xf4);
    FCML_A32("vpermt2d %zmm4,%zmm6,%zmm6", 0x62, 0xf2, 0x4d, 0x48, 0x7e, 0xf4);
    FCML_I32("vpermt2d zmm6,zmm6,zmm4", 0x62, 0xf2, 0x4d, 0x48, 0x7e, 0xf4);
    /* disp8 */
    FCML_I32("vpermt2d zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf2, 0x6d, 0x48, 0x7e, 0x4c, 0x24, 0x08);
    FCML_A32("vpermt2d 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x48, 0x7e, 0x4c, 0x24, 0x08);
    FCML_I64("vpermt2d zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf2, 0x6d, 0x48, 0x7e, 0x4c, 0x24, 0x08);
    FCML_A64("vpermt2d 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x48, 0x7e, 0x4c, 0x24, 0x08);
    FCML_I32("vpermt2d ymm1,ymm2,ymmword ptr [esp+00000100h]", 0x62, 0xf2, 0x6d, 0x28, 0x7e, 0x4c, 0x24, 0x08);
    FCML_A32("vpermt2d 0x00000100(%esp),%ymm2,%ymm1", 0x62, 0xf2, 0x6d, 0x28, 0x7e, 0x4c, 0x24, 0x08);
    FCML_I64("vpermt2d ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 0x62, 0xf2, 0x6d, 0x28, 0x7e, 0x4c, 0x24, 0x08);
    FCML_A64("vpermt2d 0x0000000000000100(%rsp),%ymm2,%ymm1", 0x62, 0xf2, 0x6d, 0x28, 0x7e, 0x4c, 0x24, 0x08);
    FCML_I32("vpermt2d xmm1,xmm2,xmmword ptr [esp+00000080h]", 0x62, 0xf2, 0x6d, 0x08, 0x7e, 0x4c, 0x24, 0x08);
    FCML_A32("vpermt2d 0x00000080(%esp),%xmm2,%xmm1", 0x62, 0xf2, 0x6d, 0x08, 0x7e, 0x4c, 0x24, 0x08);
    FCML_I64("vpermt2d xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 0x62, 0xf2, 0x6d, 0x08, 0x7e, 0x4c, 0x24, 0x08);
    FCML_A64("vpermt2d 0x0000000000000080(%rsp),%xmm2,%xmm1", 0x62, 0xf2, 0x6d, 0x08, 0x7e, 0x4c, 0x24, 0x08);
    /* {k}{z} */
    FCML_A64("vpermt2d (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x12, 0x0d, 0x8c, 0x7e, 0x14, 0x01);
    FCML_I64("vpermt2d xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x8c, 0x7e, 0x14, 0x01);
    FCML_A32("vpermt2d (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf2, 0x45, 0x8d, 0x7e, 0x14, 0x01);
    FCML_I32("vpermt2d xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x8d, 0x7e, 0x14, 0x01);
    FCML_A64("vpermt2d (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x12, 0x0d, 0xac, 0x7e, 0x14, 0x01);
    FCML_I64("vpermt2d ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0xac, 0x7e, 0x14, 0x01);
    FCML_A32("vpermt2d (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf2, 0x45, 0xad, 0x7e, 0x14, 0x01);
    FCML_I32("vpermt2d ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0xad, 0x7e, 0x14, 0x01);
    FCML_A64("vpermt2d (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x12, 0x0d, 0xcc, 0x7e, 0x14, 0x01);
    FCML_I64("vpermt2d zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0xcc, 0x7e, 0x14, 0x01);
    FCML_A32("vpermt2d (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf2, 0x45, 0xcd, 0x7e, 0x14, 0x01);
    FCML_I32("vpermt2d zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0xcd, 0x7e, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpermt2d (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x12, 0x0d, 0x0c, 0x7e, 0x14, 0x01);
    FCML_I64("vpermt2d xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x0c, 0x7e, 0x14, 0x01);
    FCML_A32("vpermt2d (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf2, 0x45, 0x0d, 0x7e, 0x14, 0x01);
    FCML_I32("vpermt2d xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x0d, 0x7e, 0x14, 0x01);
    FCML_A64("vpermt2d (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x12, 0x0d, 0x2c, 0x7e, 0x14, 0x01);
    FCML_I64("vpermt2d ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x2c, 0x7e, 0x14, 0x01);
    FCML_A32("vpermt2d (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf2, 0x45, 0x2d, 0x7e, 0x14, 0x01);
    FCML_I32("vpermt2d ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x2d, 0x7e, 0x14, 0x01);
    FCML_A64("vpermt2d (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x12, 0x0d, 0x4c, 0x7e, 0x14, 0x01);
    FCML_I64("vpermt2d zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x4c, 0x7e, 0x14, 0x01);
    FCML_A32("vpermt2d (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf2, 0x45, 0x4d, 0x7e, 0x14, 0x01);
    FCML_I32("vpermt2d zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x4d, 0x7e, 0x14, 0x01);
    /* bcast */
    FCML_I64("vpermt2d zmm31,zmm21,dword ptr [rsi]{1to16}", 0x62, 0x62, 0x55, 0x50, 0x7e, 0x3e);
    FCML_A64("vpermt2d (%rsi){1to16},%zmm21,%zmm31", 0x62, 0x62, 0x55, 0x50, 0x7e, 0x3e);
    FCML_I64("vpermt2d ymm31,ymm21,dword ptr [rsi]{1to8}", 0x62, 0x62, 0x55, 0x30, 0x7e, 0x3e);
    FCML_A64("vpermt2d (%rsi){1to8},%ymm21,%ymm31", 0x62, 0x62, 0x55, 0x30, 0x7e, 0x3e);
    FCML_I64("vpermt2d xmm31,xmm21,dword ptr [rsi]{1to4}", 0x62, 0x62, 0x55, 0x10, 0x7e, 0x3e);
    FCML_A64("vpermt2d (%rsi){1to4},%xmm21,%xmm31", 0x62, 0x62, 0x55, 0x10, 0x7e, 0x3e);
    FCML_A32("vpermt2d (%esi){1to16},%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x58, 0x7e, 0x0e);
    FCML_I32("vpermt2d zmm1,zmm2,dword ptr [esi]{1to16}", 0x62, 0xf2, 0x6d, 0x58, 0x7e, 0x0e);
    /* {k}{z}{bcast} */
    FCML_A64("vpermt2d (%rsi){1to8},%ymm21,%ymm31{%k7}{z}", 0x62, 0x62, 0x55, 0xb7, 0x7e, 0x3e);
    FCML_I64("vpermt2d ymm31{k7}{z},ymm21,dword ptr [rsi]{1to8}", 0x62, 0x62, 0x55, 0xb7, 0x7e, 0x3e);
    /* {bcast} disp8 */
    FCML_I32("vpermt2d zmm1,zmm2,dword ptr [esp+00000020h]{1to16}", 0x62, 0xf2, 0x6d, 0x58, 0x7e, 0x4c, 0x24, 0x08);
    FCML_A32("vpermt2d 0x00000020(%esp){1to16},%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x58, 0x7e, 0x4c, 0x24, 0x08);
    FCML_I64("vpermt2d zmm1,zmm2,dword ptr [rsp+0000000000000020h]{1to16}", 0x62, 0xf2, 0x6d, 0x58, 0x7e, 0x4c, 0x24, 0x08);
    FCML_A64("vpermt2d 0x0000000000000020(%rsp){1to16},%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x58, 0x7e, 0x4c, 0x24, 0x08);
    FCML_I32("vpermt2d ymm1,ymm2,dword ptr [esp+00000020h]{1to8}", 0x62, 0xf2, 0x6d, 0x38, 0x7e, 0x4c, 0x24, 0x08);
    FCML_A32("vpermt2d 0x00000020(%esp){1to8},%ymm2,%ymm1", 0x62, 0xf2, 0x6d, 0x38, 0x7e, 0x4c, 0x24, 0x08);
    FCML_I64("vpermt2d ymm1,ymm2,dword ptr [rsp+0000000000000020h]{1to8}", 0x62, 0xf2, 0x6d, 0x38, 0x7e, 0x4c, 0x24, 0x08);
    FCML_A64("vpermt2d 0x0000000000000020(%rsp){1to8},%ymm2,%ymm1", 0x62, 0xf2, 0x6d, 0x38, 0x7e, 0x4c, 0x24, 0x08);
    FCML_I32("vpermt2d xmm1,xmm2,dword ptr [esp+00000020h]{1to4}", 0x62, 0xf2, 0x6d, 0x18, 0x7e, 0x4c, 0x24, 0x08);
    FCML_A32("vpermt2d 0x00000020(%esp){1to4},%xmm2,%xmm1", 0x62, 0xf2, 0x6d, 0x18, 0x7e, 0x4c, 0x24, 0x08);
    FCML_I64("vpermt2d xmm1,xmm2,dword ptr [rsp+0000000000000020h]{1to4}", 0x62, 0xf2, 0x6d, 0x18, 0x7e, 0x4c, 0x24, 0x08);
    FCML_A64("vpermt2d 0x0000000000000020(%rsp){1to4},%xmm2,%xmm1", 0x62, 0xf2, 0x6d, 0x18, 0x7e, 0x4c, 0x24, 0x08);
}

void fcml_tf_instruction_VPERMT2Q(void) {
    /* xmm1, xmm2, m128 */
    FCML_A64("vpermt2q (%rax),%xmm7,%xmm15", 0x62, 0x72, 0xc5, 0x08, 0x7e, 0x38);
    FCML_I64("vpermt2q xmm15,xmm7,xmmword ptr [rax]", 0x62, 0x72, 0xc5, 0x08, 0x7e, 0x38);
    FCML_A32("vpermt2q (%eax),%xmm6,%xmm7", 0x62, 0xf2, 0xcd, 0x08, 0x7e, 0x38);
    FCML_I32("vpermt2q xmm7,xmm6,xmmword ptr [eax]", 0x62, 0xf2, 0xcd, 0x08, 0x7e, 0x38);
    /* ymm1, ymm2, m256 */
    FCML_A64("vpermt2q (%rax),%ymm7,%ymm15", 0x62, 0x72, 0xc5, 0x28, 0x7e, 0x38);
    FCML_I64("vpermt2q ymm15,ymm7,ymmword ptr [rax]", 0x62, 0x72, 0xc5, 0x28, 0x7e, 0x38);
    FCML_A32("vpermt2q (%eax),%ymm5,%ymm7", 0x62, 0xf2, 0xd5, 0x28, 0x7e, 0x38);
    FCML_I32("vpermt2q ymm7,ymm5,ymmword ptr [eax]", 0x62, 0xf2, 0xd5, 0x28, 0x7e, 0x38);
    /* zmm1, zmm2, m512 */
    FCML_A64("vpermt2q (%rax),%zmm7,%zmm15", 0x62, 0x72, 0xc5, 0x48, 0x7e, 0x38);
    FCML_I64("vpermt2q zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x72, 0xc5, 0x48, 0x7e, 0x38);
    FCML_A32("vpermt2q (%eax),%zmm3,%zmm7", 0x62, 0xf2, 0xe5, 0x48, 0x7e, 0x38);
    FCML_I32("vpermt2q zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf2, 0xe5, 0x48, 0x7e, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64("vpermt2q %xmm1,%xmm7,%xmm15", 0x62, 0x72, 0xc5, 0x08, 0x7e, 0xf9);
    FCML_I64("vpermt2q xmm15,xmm7,xmm1", 0x62, 0x72, 0xc5, 0x08, 0x7e, 0xf9);
    FCML_A32("vpermt2q %xmm1,%xmm2,%xmm7", 0x62, 0xf2, 0xed, 0x08, 0x7e, 0xf9);
    FCML_I32("vpermt2q xmm7,xmm2,xmm1", 0x62, 0xf2, 0xed, 0x08, 0x7e, 0xf9);
    /* ymm1, ymm2, ymm3 */
    FCML_A64("vpermt2q %ymm6,%ymm7,%ymm14", 0x62, 0x72, 0xc5, 0x28, 0x7e, 0xf6);
    FCML_I64("vpermt2q ymm14,ymm7,ymm6", 0x62, 0x72, 0xc5, 0x28, 0x7e, 0xf6);
    FCML_A32("vpermt2q %ymm5,%ymm3,%ymm6", 0x62, 0xf2, 0xe5, 0x28, 0x7e, 0xf5);
    FCML_I32("vpermt2q ymm6,ymm3,ymm5", 0x62, 0xf2, 0xe5, 0x28, 0x7e, 0xf5);
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpermt2q %zmm4,%zmm15,%zmm6", 0x62, 0xf2, 0x85, 0x48, 0x7e, 0xf4);
    FCML_I64("vpermt2q zmm6,zmm15,zmm4", 0x62, 0xf2, 0x85, 0x48, 0x7e, 0xf4);
    FCML_A32("vpermt2q %zmm4,%zmm6,%zmm6", 0x62, 0xf2, 0xcd, 0x48, 0x7e, 0xf4);
    FCML_I32("vpermt2q zmm6,zmm6,zmm4", 0x62, 0xf2, 0xcd, 0x48, 0x7e, 0xf4);
    /* disp8 */
    FCML_I32("vpermt2q zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf2, 0xed, 0x48, 0x7e, 0x4c, 0x24, 0x08);
    FCML_A32("vpermt2q 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x48, 0x7e, 0x4c, 0x24, 0x08);
    FCML_I64("vpermt2q zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf2, 0xed, 0x48, 0x7e, 0x4c, 0x24, 0x08);
    FCML_A64("vpermt2q 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x48, 0x7e, 0x4c, 0x24, 0x08);
    FCML_I32("vpermt2q ymm1,ymm2,ymmword ptr [esp+00000100h]", 0x62, 0xf2, 0xed, 0x28, 0x7e, 0x4c, 0x24, 0x08);
    FCML_A32("vpermt2q 0x00000100(%esp),%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x28, 0x7e, 0x4c, 0x24, 0x08);
    FCML_I64("vpermt2q ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 0x62, 0xf2, 0xed, 0x28, 0x7e, 0x4c, 0x24, 0x08);
    FCML_A64("vpermt2q 0x0000000000000100(%rsp),%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x28, 0x7e, 0x4c, 0x24, 0x08);
    FCML_I32("vpermt2q xmm1,xmm2,xmmword ptr [esp+00000080h]", 0x62, 0xf2, 0xed, 0x08, 0x7e, 0x4c, 0x24, 0x08);
    FCML_A32("vpermt2q 0x00000080(%esp),%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x08, 0x7e, 0x4c, 0x24, 0x08);
    FCML_I64("vpermt2q xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 0x62, 0xf2, 0xed, 0x08, 0x7e, 0x4c, 0x24, 0x08);
    FCML_A64("vpermt2q 0x0000000000000080(%rsp),%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x08, 0x7e, 0x4c, 0x24, 0x08);
    /* {k}{z} */
    FCML_A64("vpermt2q (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x12, 0x8d, 0x8c, 0x7e, 0x14, 0x01);
    FCML_I64("vpermt2q xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x8c, 0x7e, 0x14, 0x01);
    FCML_A32("vpermt2q (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0x8d, 0x7e, 0x14, 0x01);
    FCML_I32("vpermt2q xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x8d, 0x7e, 0x14, 0x01);
    FCML_A64("vpermt2q (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x12, 0x8d, 0xac, 0x7e, 0x14, 0x01);
    FCML_I64("vpermt2q ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0xac, 0x7e, 0x14, 0x01);
    FCML_A32("vpermt2q (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0xad, 0x7e, 0x14, 0x01);
    FCML_I32("vpermt2q ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0xad, 0x7e, 0x14, 0x01);
    FCML_A64("vpermt2q (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x12, 0x8d, 0xcc, 0x7e, 0x14, 0x01);
    FCML_I64("vpermt2q zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0xcc, 0x7e, 0x14, 0x01);
    FCML_A32("vpermt2q (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0xcd, 0x7e, 0x14, 0x01);
    FCML_I32("vpermt2q zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0xcd, 0x7e, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpermt2q (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x12, 0x8d, 0x0c, 0x7e, 0x14, 0x01);
    FCML_I64("vpermt2q xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x0c, 0x7e, 0x14, 0x01);
    FCML_A32("vpermt2q (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf2, 0xc5, 0x0d, 0x7e, 0x14, 0x01);
    FCML_I32("vpermt2q xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x0d, 0x7e, 0x14, 0x01);
    FCML_A64("vpermt2q (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x12, 0x8d, 0x2c, 0x7e, 0x14, 0x01);
    FCML_I64("vpermt2q ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x2c, 0x7e, 0x14, 0x01);
    FCML_A32("vpermt2q (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf2, 0xc5, 0x2d, 0x7e, 0x14, 0x01);
    FCML_I32("vpermt2q ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x2d, 0x7e, 0x14, 0x01);
    FCML_A64("vpermt2q (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x12, 0x8d, 0x4c, 0x7e, 0x14, 0x01);
    FCML_I64("vpermt2q zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x4c, 0x7e, 0x14, 0x01);
    FCML_A32("vpermt2q (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf2, 0xc5, 0x4d, 0x7e, 0x14, 0x01);
    FCML_I32("vpermt2q zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x4d, 0x7e, 0x14, 0x01);
    /* bcast */
    FCML_I64("vpermt2q zmm31,zmm21,mmword ptr [rsi]{1to8}", 0x62, 0x62, 0xd5, 0x50, 0x7e, 0x3e);
    FCML_A64("vpermt2q (%rsi){1to8},%zmm21,%zmm31", 0x62, 0x62, 0xd5, 0x50, 0x7e, 0x3e);
    FCML_I64("vpermt2q ymm31,ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x62, 0xd5, 0x30, 0x7e, 0x3e);
    FCML_A64("vpermt2q (%rsi){1to4},%ymm21,%ymm31", 0x62, 0x62, 0xd5, 0x30, 0x7e, 0x3e);
    FCML_I64("vpermt2q xmm31,xmm21,mmword ptr [rsi]{1to2}", 0x62, 0x62, 0xd5, 0x10, 0x7e, 0x3e);
    FCML_A64("vpermt2q (%rsi){1to2},%xmm21,%xmm31", 0x62, 0x62, 0xd5, 0x10, 0x7e, 0x3e);
    FCML_A32("vpermt2q (%esi){1to8},%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x58, 0x7e, 0x0e);
    FCML_I32("vpermt2q zmm1,zmm2,mmword ptr [esi]{1to8}", 0x62, 0xf2, 0xed, 0x58, 0x7e, 0x0e);
    /* {k}{z}{bcast} */
    FCML_A64("vpermt2q (%rsi){1to4},%ymm21,%ymm31{%k7}{z}", 0x62, 0x62, 0xd5, 0xb7, 0x7e, 0x3e);
    FCML_I64("vpermt2q ymm31{k7}{z},ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x62, 0xd5, 0xb7, 0x7e, 0x3e);
    /* {bcast} disp8 */
    FCML_I32("vpermt2q zmm1,zmm2,mmword ptr [esp+00000040h]{1to8}", 0x62, 0xf2, 0xed, 0x58, 0x7e, 0x4c, 0x24, 0x08);
    FCML_A32("vpermt2q 0x00000040(%esp){1to8},%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x58, 0x7e, 0x4c, 0x24, 0x08);
    FCML_I64("vpermt2q zmm1,zmm2,mmword ptr [rsp+0000000000000040h]{1to8}", 0x62, 0xf2, 0xed, 0x58, 0x7e, 0x4c, 0x24, 0x08);
    FCML_A64("vpermt2q 0x0000000000000040(%rsp){1to8},%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x58, 0x7e, 0x4c, 0x24, 0x08);
    FCML_I32("vpermt2q ymm1,ymm2,mmword ptr [esp+00000040h]{1to4}", 0x62, 0xf2, 0xed, 0x38, 0x7e, 0x4c, 0x24, 0x08);
    FCML_A32("vpermt2q 0x00000040(%esp){1to4},%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x38, 0x7e, 0x4c, 0x24, 0x08);
    FCML_I64("vpermt2q ymm1,ymm2,mmword ptr [rsp+0000000000000040h]{1to4}", 0x62, 0xf2, 0xed, 0x38, 0x7e, 0x4c, 0x24, 0x08);
    FCML_A64("vpermt2q 0x0000000000000040(%rsp){1to4},%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x38, 0x7e, 0x4c, 0x24, 0x08);
    FCML_I32("vpermt2q xmm1,xmm2,mmword ptr [esp+00000040h]{1to2}", 0x62, 0xf2, 0xed, 0x18, 0x7e, 0x4c, 0x24, 0x08);
    FCML_A32("vpermt2q 0x00000040(%esp){1to2},%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x18, 0x7e, 0x4c, 0x24, 0x08);
    FCML_I64("vpermt2q xmm1,xmm2,mmword ptr [rsp+0000000000000040h]{1to2}", 0x62, 0xf2, 0xed, 0x18, 0x7e, 0x4c, 0x24, 0x08);
    FCML_A64("vpermt2q 0x0000000000000040(%rsp){1to2},%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x18, 0x7e, 0x4c, 0x24, 0x08);
}

void fcml_tf_instruction_VPERMT2PS(void) {
    /* xmm1, xmm2, m128 */
    FCML_A64("vpermt2ps (%rax),%xmm7,%xmm15", 0x62, 0x72, 0x45, 0x08, 0x7f, 0x38);
    FCML_I64("vpermt2ps xmm15,xmm7,xmmword ptr [rax]", 0x62, 0x72, 0x45, 0x08, 0x7f, 0x38);
    FCML_A32("vpermt2ps (%eax),%xmm6,%xmm7", 0x62, 0xf2, 0x4d, 0x08, 0x7f, 0x38);
    FCML_I32("vpermt2ps xmm7,xmm6,xmmword ptr [eax]", 0x62, 0xf2, 0x4d, 0x08, 0x7f, 0x38);
    /* ymm1, ymm2, m256 */
    FCML_A64("vpermt2ps (%rax),%ymm7,%ymm15", 0x62, 0x72, 0x45, 0x28, 0x7f, 0x38);
    FCML_I64("vpermt2ps ymm15,ymm7,ymmword ptr [rax]", 0x62, 0x72, 0x45, 0x28, 0x7f, 0x38);
    FCML_A32("vpermt2ps (%eax),%ymm5,%ymm7", 0x62, 0xf2, 0x55, 0x28, 0x7f, 0x38);
    FCML_I32("vpermt2ps ymm7,ymm5,ymmword ptr [eax]", 0x62, 0xf2, 0x55, 0x28, 0x7f, 0x38);
    /* zmm1, zmm2, m512 */
    FCML_A64("vpermt2ps (%rax),%zmm7,%zmm15", 0x62, 0x72, 0x45, 0x48, 0x7f, 0x38);
    FCML_I64("vpermt2ps zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x72, 0x45, 0x48, 0x7f, 0x38);
    FCML_A32("vpermt2ps (%eax),%zmm3,%zmm7", 0x62, 0xf2, 0x65, 0x48, 0x7f, 0x38);
    FCML_I32("vpermt2ps zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf2, 0x65, 0x48, 0x7f, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64("vpermt2ps %xmm1,%xmm7,%xmm15", 0x62, 0x72, 0x45, 0x08, 0x7f, 0xf9);
    FCML_I64("vpermt2ps xmm15,xmm7,xmm1", 0x62, 0x72, 0x45, 0x08, 0x7f, 0xf9);
    FCML_A32("vpermt2ps %xmm1,%xmm2,%xmm7", 0x62, 0xf2, 0x6d, 0x08, 0x7f, 0xf9);
    FCML_I32("vpermt2ps xmm7,xmm2,xmm1", 0x62, 0xf2, 0x6d, 0x08, 0x7f, 0xf9);
    /* ymm1, ymm2, ymm3 */
    FCML_A64("vpermt2ps %ymm6,%ymm7,%ymm14", 0x62, 0x72, 0x45, 0x28, 0x7f, 0xf6);
    FCML_I64("vpermt2ps ymm14,ymm7,ymm6", 0x62, 0x72, 0x45, 0x28, 0x7f, 0xf6);
    FCML_A32("vpermt2ps %ymm5,%ymm3,%ymm6", 0x62, 0xf2, 0x65, 0x28, 0x7f, 0xf5);
    FCML_I32("vpermt2ps ymm6,ymm3,ymm5", 0x62, 0xf2, 0x65, 0x28, 0x7f, 0xf5);
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpermt2ps %zmm4,%zmm15,%zmm6", 0x62, 0xf2, 0x05, 0x48, 0x7f, 0xf4);
    FCML_I64("vpermt2ps zmm6,zmm15,zmm4", 0x62, 0xf2, 0x05, 0x48, 0x7f, 0xf4);
    FCML_A32("vpermt2ps %zmm4,%zmm6,%zmm6", 0x62, 0xf2, 0x4d, 0x48, 0x7f, 0xf4);
    FCML_I32("vpermt2ps zmm6,zmm6,zmm4", 0x62, 0xf2, 0x4d, 0x48, 0x7f, 0xf4);
    /* disp8 */
    FCML_I32("vpermt2ps zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf2, 0x6d, 0x48, 0x7f, 0x4c, 0x24, 0x08);
    FCML_A32("vpermt2ps 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x48, 0x7f, 0x4c, 0x24, 0x08);
    FCML_I64("vpermt2ps zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf2, 0x6d, 0x48, 0x7f, 0x4c, 0x24, 0x08);
    FCML_A64("vpermt2ps 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x48, 0x7f, 0x4c, 0x24, 0x08);
    FCML_I32("vpermt2ps ymm1,ymm2,ymmword ptr [esp+00000100h]", 0x62, 0xf2, 0x6d, 0x28, 0x7f, 0x4c, 0x24, 0x08);
    FCML_A32("vpermt2ps 0x00000100(%esp),%ymm2,%ymm1", 0x62, 0xf2, 0x6d, 0x28, 0x7f, 0x4c, 0x24, 0x08);
    FCML_I64("vpermt2ps ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 0x62, 0xf2, 0x6d, 0x28, 0x7f, 0x4c, 0x24, 0x08);
    FCML_A64("vpermt2ps 0x0000000000000100(%rsp),%ymm2,%ymm1", 0x62, 0xf2, 0x6d, 0x28, 0x7f, 0x4c, 0x24, 0x08);
    FCML_I32("vpermt2ps xmm1,xmm2,xmmword ptr [esp+00000080h]", 0x62, 0xf2, 0x6d, 0x08, 0x7f, 0x4c, 0x24, 0x08);
    FCML_A32("vpermt2ps 0x00000080(%esp),%xmm2,%xmm1", 0x62, 0xf2, 0x6d, 0x08, 0x7f, 0x4c, 0x24, 0x08);
    FCML_I64("vpermt2ps xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 0x62, 0xf2, 0x6d, 0x08, 0x7f, 0x4c, 0x24, 0x08);
    FCML_A64("vpermt2ps 0x0000000000000080(%rsp),%xmm2,%xmm1", 0x62, 0xf2, 0x6d, 0x08, 0x7f, 0x4c, 0x24, 0x08);
    /* {k}{z} */
    FCML_A64("vpermt2ps (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x12, 0x0d, 0x8c, 0x7f, 0x14, 0x01);
    FCML_I64("vpermt2ps xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x8c, 0x7f, 0x14, 0x01);
    FCML_A32("vpermt2ps (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf2, 0x45, 0x8d, 0x7f, 0x14, 0x01);
    FCML_I32("vpermt2ps xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x8d, 0x7f, 0x14, 0x01);
    FCML_A64("vpermt2ps (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x12, 0x0d, 0xac, 0x7f, 0x14, 0x01);
    FCML_I64("vpermt2ps ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0xac, 0x7f, 0x14, 0x01);
    FCML_A32("vpermt2ps (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf2, 0x45, 0xad, 0x7f, 0x14, 0x01);
    FCML_I32("vpermt2ps ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0xad, 0x7f, 0x14, 0x01);
    FCML_A64("vpermt2ps (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x12, 0x0d, 0xcc, 0x7f, 0x14, 0x01);
    FCML_I64("vpermt2ps zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0xcc, 0x7f, 0x14, 0x01);
    FCML_A32("vpermt2ps (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf2, 0x45, 0xcd, 0x7f, 0x14, 0x01);
    FCML_I32("vpermt2ps zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0xcd, 0x7f, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpermt2ps (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x12, 0x0d, 0x0c, 0x7f, 0x14, 0x01);
    FCML_I64("vpermt2ps xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x0c, 0x7f, 0x14, 0x01);
    FCML_A32("vpermt2ps (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf2, 0x45, 0x0d, 0x7f, 0x14, 0x01);
    FCML_I32("vpermt2ps xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x0d, 0x7f, 0x14, 0x01);
    FCML_A64("vpermt2ps (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x12, 0x0d, 0x2c, 0x7f, 0x14, 0x01);
    FCML_I64("vpermt2ps ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x2c, 0x7f, 0x14, 0x01);
    FCML_A32("vpermt2ps (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf2, 0x45, 0x2d, 0x7f, 0x14, 0x01);
    FCML_I32("vpermt2ps ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x2d, 0x7f, 0x14, 0x01);
    FCML_A64("vpermt2ps (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x12, 0x0d, 0x4c, 0x7f, 0x14, 0x01);
    FCML_I64("vpermt2ps zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x4c, 0x7f, 0x14, 0x01);
    FCML_A32("vpermt2ps (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf2, 0x45, 0x4d, 0x7f, 0x14, 0x01);
    FCML_I32("vpermt2ps zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x4d, 0x7f, 0x14, 0x01);
    /* bcast */
    FCML_I64("vpermt2ps zmm31,zmm21,dword ptr [rsi]{1to16}", 0x62, 0x62, 0x55, 0x50, 0x7f, 0x3e);
    FCML_A64("vpermt2ps (%rsi){1to16},%zmm21,%zmm31", 0x62, 0x62, 0x55, 0x50, 0x7f, 0x3e);
    FCML_I64("vpermt2ps ymm31,ymm21,dword ptr [rsi]{1to8}", 0x62, 0x62, 0x55, 0x30, 0x7f, 0x3e);
    FCML_A64("vpermt2ps (%rsi){1to8},%ymm21,%ymm31", 0x62, 0x62, 0x55, 0x30, 0x7f, 0x3e);
    FCML_I64("vpermt2ps xmm31,xmm21,dword ptr [rsi]{1to4}", 0x62, 0x62, 0x55, 0x10, 0x7f, 0x3e);
    FCML_A64("vpermt2ps (%rsi){1to4},%xmm21,%xmm31", 0x62, 0x62, 0x55, 0x10, 0x7f, 0x3e);
    FCML_A32("vpermt2ps (%esi){1to16},%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x58, 0x7f, 0x0e);
    FCML_I32("vpermt2ps zmm1,zmm2,dword ptr [esi]{1to16}", 0x62, 0xf2, 0x6d, 0x58, 0x7f, 0x0e);
    /* {k}{z}{bcast} */
    FCML_A64("vpermt2ps (%rsi){1to8},%ymm21,%ymm31{%k7}{z}", 0x62, 0x62, 0x55, 0xb7, 0x7f, 0x3e);
    FCML_I64("vpermt2ps ymm31{k7}{z},ymm21,dword ptr [rsi]{1to8}", 0x62, 0x62, 0x55, 0xb7, 0x7f, 0x3e);
    /* {bcast} disp8 */
    FCML_I32("vpermt2ps zmm1,zmm2,dword ptr [esp+00000020h]{1to16}", 0x62, 0xf2, 0x6d, 0x58, 0x7f, 0x4c, 0x24, 0x08);
    FCML_A32("vpermt2ps 0x00000020(%esp){1to16},%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x58, 0x7f, 0x4c, 0x24, 0x08);
    FCML_I64("vpermt2ps zmm1,zmm2,dword ptr [rsp+0000000000000020h]{1to16}", 0x62, 0xf2, 0x6d, 0x58, 0x7f, 0x4c, 0x24, 0x08);
    FCML_A64("vpermt2ps 0x0000000000000020(%rsp){1to16},%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x58, 0x7f, 0x4c, 0x24, 0x08);
    FCML_I32("vpermt2ps ymm1,ymm2,dword ptr [esp+00000020h]{1to8}", 0x62, 0xf2, 0x6d, 0x38, 0x7f, 0x4c, 0x24, 0x08);
    FCML_A32("vpermt2ps 0x00000020(%esp){1to8},%ymm2,%ymm1", 0x62, 0xf2, 0x6d, 0x38, 0x7f, 0x4c, 0x24, 0x08);
    FCML_I64("vpermt2ps ymm1,ymm2,dword ptr [rsp+0000000000000020h]{1to8}", 0x62, 0xf2, 0x6d, 0x38, 0x7f, 0x4c, 0x24, 0x08);
    FCML_A64("vpermt2ps 0x0000000000000020(%rsp){1to8},%ymm2,%ymm1", 0x62, 0xf2, 0x6d, 0x38, 0x7f, 0x4c, 0x24, 0x08);
    FCML_I32("vpermt2ps xmm1,xmm2,dword ptr [esp+00000020h]{1to4}", 0x62, 0xf2, 0x6d, 0x18, 0x7f, 0x4c, 0x24, 0x08);
    FCML_A32("vpermt2ps 0x00000020(%esp){1to4},%xmm2,%xmm1", 0x62, 0xf2, 0x6d, 0x18, 0x7f, 0x4c, 0x24, 0x08);
    FCML_I64("vpermt2ps xmm1,xmm2,dword ptr [rsp+0000000000000020h]{1to4}", 0x62, 0xf2, 0x6d, 0x18, 0x7f, 0x4c, 0x24, 0x08);
    FCML_A64("vpermt2ps 0x0000000000000020(%rsp){1to4},%xmm2,%xmm1", 0x62, 0xf2, 0x6d, 0x18, 0x7f, 0x4c, 0x24, 0x08);
}

void fcml_tf_instruction_VPERMT2PD(void) {
    /* xmm1, xmm2, m128 */
    FCML_A64("vpermt2pd (%rax),%xmm7,%xmm15", 0x62, 0x72, 0xc5, 0x08, 0x7f, 0x38);
    FCML_I64("vpermt2pd xmm15,xmm7,xmmword ptr [rax]", 0x62, 0x72, 0xc5, 0x08, 0x7f, 0x38);
    FCML_A32("vpermt2pd (%eax),%xmm6,%xmm7", 0x62, 0xf2, 0xcd, 0x08, 0x7f, 0x38);
    FCML_I32("vpermt2pd xmm7,xmm6,xmmword ptr [eax]", 0x62, 0xf2, 0xcd, 0x08, 0x7f, 0x38);
    /* ymm1, ymm2, m256 */
    FCML_A64("vpermt2pd (%rax),%ymm7,%ymm15", 0x62, 0x72, 0xc5, 0x28, 0x7f, 0x38);
    FCML_I64("vpermt2pd ymm15,ymm7,ymmword ptr [rax]", 0x62, 0x72, 0xc5, 0x28, 0x7f, 0x38);
    FCML_A32("vpermt2pd (%eax),%ymm5,%ymm7", 0x62, 0xf2, 0xd5, 0x28, 0x7f, 0x38);
    FCML_I32("vpermt2pd ymm7,ymm5,ymmword ptr [eax]", 0x62, 0xf2, 0xd5, 0x28, 0x7f, 0x38);
    /* zmm1, zmm2, m512 */
    FCML_A64("vpermt2pd (%rax),%zmm7,%zmm15", 0x62, 0x72, 0xc5, 0x48, 0x7f, 0x38);
    FCML_I64("vpermt2pd zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x72, 0xc5, 0x48, 0x7f, 0x38);
    FCML_A32("vpermt2pd (%eax),%zmm3,%zmm7", 0x62, 0xf2, 0xe5, 0x48, 0x7f, 0x38);
    FCML_I32("vpermt2pd zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf2, 0xe5, 0x48, 0x7f, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64("vpermt2pd %xmm1,%xmm7,%xmm15", 0x62, 0x72, 0xc5, 0x08, 0x7f, 0xf9);
    FCML_I64("vpermt2pd xmm15,xmm7,xmm1", 0x62, 0x72, 0xc5, 0x08, 0x7f, 0xf9);
    FCML_A32("vpermt2pd %xmm1,%xmm2,%xmm7", 0x62, 0xf2, 0xed, 0x08, 0x7f, 0xf9);
    FCML_I32("vpermt2pd xmm7,xmm2,xmm1", 0x62, 0xf2, 0xed, 0x08, 0x7f, 0xf9);
    /* ymm1, ymm2, ymm3 */
    FCML_A64("vpermt2pd %ymm6,%ymm7,%ymm14", 0x62, 0x72, 0xc5, 0x28, 0x7f, 0xf6);
    FCML_I64("vpermt2pd ymm14,ymm7,ymm6", 0x62, 0x72, 0xc5, 0x28, 0x7f, 0xf6);
    FCML_A32("vpermt2pd %ymm5,%ymm3,%ymm6", 0x62, 0xf2, 0xe5, 0x28, 0x7f, 0xf5);
    FCML_I32("vpermt2pd ymm6,ymm3,ymm5", 0x62, 0xf2, 0xe5, 0x28, 0x7f, 0xf5);
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpermt2pd %zmm4,%zmm15,%zmm6", 0x62, 0xf2, 0x85, 0x48, 0x7f, 0xf4);
    FCML_I64("vpermt2pd zmm6,zmm15,zmm4", 0x62, 0xf2, 0x85, 0x48, 0x7f, 0xf4);
    FCML_A32("vpermt2pd %zmm4,%zmm6,%zmm6", 0x62, 0xf2, 0xcd, 0x48, 0x7f, 0xf4);
    FCML_I32("vpermt2pd zmm6,zmm6,zmm4", 0x62, 0xf2, 0xcd, 0x48, 0x7f, 0xf4);
    /* disp8 */
    FCML_I32("vpermt2pd zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf2, 0xed, 0x48, 0x7f, 0x4c, 0x24, 0x08);
    FCML_A32("vpermt2pd 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x48, 0x7f, 0x4c, 0x24, 0x08);
    FCML_I64("vpermt2pd zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf2, 0xed, 0x48, 0x7f, 0x4c, 0x24, 0x08);
    FCML_A64("vpermt2pd 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x48, 0x7f, 0x4c, 0x24, 0x08);
    FCML_I32("vpermt2pd ymm1,ymm2,ymmword ptr [esp+00000100h]", 0x62, 0xf2, 0xed, 0x28, 0x7f, 0x4c, 0x24, 0x08);
    FCML_A32("vpermt2pd 0x00000100(%esp),%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x28, 0x7f, 0x4c, 0x24, 0x08);
    FCML_I64("vpermt2pd ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 0x62, 0xf2, 0xed, 0x28, 0x7f, 0x4c, 0x24, 0x08);
    FCML_A64("vpermt2pd 0x0000000000000100(%rsp),%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x28, 0x7f, 0x4c, 0x24, 0x08);
    FCML_I32("vpermt2pd xmm1,xmm2,xmmword ptr [esp+00000080h]", 0x62, 0xf2, 0xed, 0x08, 0x7f, 0x4c, 0x24, 0x08);
    FCML_A32("vpermt2pd 0x00000080(%esp),%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x08, 0x7f, 0x4c, 0x24, 0x08);
    FCML_I64("vpermt2pd xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 0x62, 0xf2, 0xed, 0x08, 0x7f, 0x4c, 0x24, 0x08);
    FCML_A64("vpermt2pd 0x0000000000000080(%rsp),%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x08, 0x7f, 0x4c, 0x24, 0x08);
    /* {k}{z} */
    FCML_A64("vpermt2pd (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x12, 0x8d, 0x8c, 0x7f, 0x14, 0x01);
    FCML_I64("vpermt2pd xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x8c, 0x7f, 0x14, 0x01);
    FCML_A32("vpermt2pd (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0x8d, 0x7f, 0x14, 0x01);
    FCML_I32("vpermt2pd xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x8d, 0x7f, 0x14, 0x01);
    FCML_A64("vpermt2pd (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x12, 0x8d, 0xac, 0x7f, 0x14, 0x01);
    FCML_I64("vpermt2pd ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0xac, 0x7f, 0x14, 0x01);
    FCML_A32("vpermt2pd (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0xad, 0x7f, 0x14, 0x01);
    FCML_I32("vpermt2pd ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0xad, 0x7f, 0x14, 0x01);
    FCML_A64("vpermt2pd (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x12, 0x8d, 0xcc, 0x7f, 0x14, 0x01);
    FCML_I64("vpermt2pd zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0xcc, 0x7f, 0x14, 0x01);
    FCML_A32("vpermt2pd (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0xcd, 0x7f, 0x14, 0x01);
    FCML_I32("vpermt2pd zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0xcd, 0x7f, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpermt2pd (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x12, 0x8d, 0x0c, 0x7f, 0x14, 0x01);
    FCML_I64("vpermt2pd xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x0c, 0x7f, 0x14, 0x01);
    FCML_A32("vpermt2pd (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf2, 0xc5, 0x0d, 0x7f, 0x14, 0x01);
    FCML_I32("vpermt2pd xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x0d, 0x7f, 0x14, 0x01);
    FCML_A64("vpermt2pd (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x12, 0x8d, 0x2c, 0x7f, 0x14, 0x01);
    FCML_I64("vpermt2pd ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x2c, 0x7f, 0x14, 0x01);
    FCML_A32("vpermt2pd (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf2, 0xc5, 0x2d, 0x7f, 0x14, 0x01);
    FCML_I32("vpermt2pd ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x2d, 0x7f, 0x14, 0x01);
    FCML_A64("vpermt2pd (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x12, 0x8d, 0x4c, 0x7f, 0x14, 0x01);
    FCML_I64("vpermt2pd zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x4c, 0x7f, 0x14, 0x01);
    FCML_A32("vpermt2pd (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf2, 0xc5, 0x4d, 0x7f, 0x14, 0x01);
    FCML_I32("vpermt2pd zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x4d, 0x7f, 0x14, 0x01);
    /* bcast */
    FCML_I64("vpermt2pd zmm31,zmm21,mmword ptr [rsi]{1to8}", 0x62, 0x62, 0xd5, 0x50, 0x7f, 0x3e);
    FCML_A64("vpermt2pd (%rsi){1to8},%zmm21,%zmm31", 0x62, 0x62, 0xd5, 0x50, 0x7f, 0x3e);
    FCML_I64("vpermt2pd ymm31,ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x62, 0xd5, 0x30, 0x7f, 0x3e);
    FCML_A64("vpermt2pd (%rsi){1to4},%ymm21,%ymm31", 0x62, 0x62, 0xd5, 0x30, 0x7f, 0x3e);
    FCML_I64("vpermt2pd xmm31,xmm21,mmword ptr [rsi]{1to2}", 0x62, 0x62, 0xd5, 0x10, 0x7f, 0x3e);
    FCML_A64("vpermt2pd (%rsi){1to2},%xmm21,%xmm31", 0x62, 0x62, 0xd5, 0x10, 0x7f, 0x3e);
    FCML_A32("vpermt2pd (%esi){1to8},%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x58, 0x7f, 0x0e);
    FCML_I32("vpermt2pd zmm1,zmm2,mmword ptr [esi]{1to8}", 0x62, 0xf2, 0xed, 0x58, 0x7f, 0x0e);
    /* {k}{z}{bcast} */
    FCML_A64("vpermt2pd (%rsi){1to4},%ymm21,%ymm31{%k7}{z}", 0x62, 0x62, 0xd5, 0xb7, 0x7f, 0x3e);
    FCML_I64("vpermt2pd ymm31{k7}{z},ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x62, 0xd5, 0xb7, 0x7f, 0x3e);
    /* {bcast} disp8 */
    FCML_I32("vpermt2pd zmm1,zmm2,mmword ptr [esp+00000040h]{1to8}", 0x62, 0xf2, 0xed, 0x58, 0x7f, 0x4c, 0x24, 0x08);
    FCML_A32("vpermt2pd 0x00000040(%esp){1to8},%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x58, 0x7f, 0x4c, 0x24, 0x08);
    FCML_I64("vpermt2pd zmm1,zmm2,mmword ptr [rsp+0000000000000040h]{1to8}", 0x62, 0xf2, 0xed, 0x58, 0x7f, 0x4c, 0x24, 0x08);
    FCML_A64("vpermt2pd 0x0000000000000040(%rsp){1to8},%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x58, 0x7f, 0x4c, 0x24, 0x08);
    FCML_I32("vpermt2pd ymm1,ymm2,mmword ptr [esp+00000040h]{1to4}", 0x62, 0xf2, 0xed, 0x38, 0x7f, 0x4c, 0x24, 0x08);
    FCML_A32("vpermt2pd 0x00000040(%esp){1to4},%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x38, 0x7f, 0x4c, 0x24, 0x08);
    FCML_I64("vpermt2pd ymm1,ymm2,mmword ptr [rsp+0000000000000040h]{1to4}", 0x62, 0xf2, 0xed, 0x38, 0x7f, 0x4c, 0x24, 0x08);
    FCML_A64("vpermt2pd 0x0000000000000040(%rsp){1to4},%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x38, 0x7f, 0x4c, 0x24, 0x08);
    FCML_I32("vpermt2pd xmm1,xmm2,mmword ptr [esp+00000040h]{1to2}", 0x62, 0xf2, 0xed, 0x18, 0x7f, 0x4c, 0x24, 0x08);
    FCML_A32("vpermt2pd 0x00000040(%esp){1to2},%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x18, 0x7f, 0x4c, 0x24, 0x08);
    FCML_I64("vpermt2pd xmm1,xmm2,mmword ptr [rsp+0000000000000040h]{1to2}", 0x62, 0xf2, 0xed, 0x18, 0x7f, 0x4c, 0x24, 0x08);
    FCML_A64("vpermt2pd 0x0000000000000040(%rsp){1to2},%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x18, 0x7f, 0x4c, 0x24, 0x08);
}

void fcml_tf_instruction_VPEXPANDD(void) {
    FCML_A64("vpexpandd (%rax),%xmm15", 0x62, 0x72, 0x7d, 0x08, 0x89, 0x38);
    FCML_I64("vpexpandd xmm15,xmmword ptr [rax]", 0x62, 0x72, 0x7d, 0x08, 0x89, 0x38);
    FCML_A32("vpexpandd (%eax),%xmm7", 0x62, 0xf2, 0x7d, 0x08, 0x89, 0x38);
    FCML_I32("vpexpandd xmm7,xmmword ptr [eax]", 0x62, 0xf2, 0x7d, 0x08, 0x89, 0x38);
    FCML_A64("vpexpandd (%rax),%ymm15", 0x62, 0x72, 0x7d, 0x28, 0x89, 0x38);
    FCML_I64("vpexpandd ymm15,ymmword ptr [rax]", 0x62, 0x72, 0x7d, 0x28, 0x89, 0x38);
    FCML_A32("vpexpandd (%eax),%ymm7", 0x62, 0xf2, 0x7d, 0x28, 0x89, 0x38);
    FCML_I32("vpexpandd ymm7,ymmword ptr [eax]", 0x62, 0xf2, 0x7d, 0x28, 0x89, 0x38);
    FCML_A64("vpexpandd (%rax),%zmm15", 0x62, 0x72, 0x7d, 0x48, 0x89, 0x38);
    FCML_I64("vpexpandd zmm15,zmmword ptr [rax]", 0x62, 0x72, 0x7d, 0x48, 0x89, 0x38);
    FCML_A32("vpexpandd (%eax),%zmm7", 0x62, 0xf2, 0x7d, 0x48, 0x89, 0x38);
    FCML_I32("vpexpandd zmm7,zmmword ptr [eax]", 0x62, 0xf2, 0x7d, 0x48, 0x89, 0x38);
    FCML_A64("vpexpandd %xmm1,%xmm15", 0x62, 0x72, 0x7d, 0x08, 0x89, 0xf9);
    FCML_I64("vpexpandd xmm15,xmm1", 0x62, 0x72, 0x7d, 0x08, 0x89, 0xf9);
    FCML_A32("vpexpandd %xmm1,%xmm7", 0x62, 0xf2, 0x7d, 0x08, 0x89, 0xf9);
    FCML_I32("vpexpandd xmm7,xmm1", 0x62, 0xf2, 0x7d, 0x08, 0x89, 0xf9);
    FCML_A64("vpexpandd %ymm6,%ymm14", 0x62, 0x72, 0x7d, 0x28, 0x89, 0xf6);
    FCML_I64("vpexpandd ymm14,ymm6", 0x62, 0x72, 0x7d, 0x28, 0x89, 0xf6);
    FCML_A32("vpexpandd %ymm5,%ymm6", 0x62, 0xf2, 0x7d, 0x28, 0x89, 0xf5);
    FCML_I32("vpexpandd ymm6,ymm5", 0x62, 0xf2, 0x7d, 0x28, 0x89, 0xf5);
    FCML_A64("vpexpandd %zmm4,%zmm6", 0x62, 0xf2, 0x7d, 0x48, 0x89, 0xf4);
    FCML_I64("vpexpandd zmm6,zmm4", 0x62, 0xf2, 0x7d, 0x48, 0x89, 0xf4);
    FCML_A32("vpexpandd %zmm4,%zmm6", 0x62, 0xf2, 0x7d, 0x48, 0x89, 0xf4);
    FCML_I32("vpexpandd zmm6,zmm4", 0x62, 0xf2, 0x7d, 0x48, 0x89, 0xf4);
    FCML_I32("vpexpandd zmm1,zmmword ptr [esp+00000200h]", 0x62, 0xf2, 0x7d, 0x48, 0x89, 0x8c, 0x24, 0x00, 0x02, 0x00, 0x00);
    FCML_A32("vpexpandd 0x00000200(%esp),%zmm1", 0x62, 0xf2, 0x7d, 0x48, 0x89, 0x8c, 0x24, 0x00, 0x02, 0x00, 0x00);
    FCML_I64("vpexpandd zmm1,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf2, 0x7d, 0x48, 0x89, 0x8c, 0x24, 0x00, 0x02, 0x00, 0x00);
    FCML_A64("vpexpandd 0x0000000000000200(%rsp),%zmm1", 0x62, 0xf2, 0x7d, 0x48, 0x89, 0x8c, 0x24, 0x00, 0x02, 0x00, 0x00);
    FCML_I32("vpexpandd ymm1,ymmword ptr [esp+00000100h]", 0x62, 0xf2, 0x7d, 0x28, 0x89, 0x4c, 0x24, 0x40);
    FCML_A32("vpexpandd 0x00000100(%esp),%ymm1", 0x62, 0xf2, 0x7d, 0x28, 0x89, 0x4c, 0x24, 0x40);
    FCML_I64("vpexpandd ymm1,ymmword ptr [rsp+0000000000000100h]", 0x62, 0xf2, 0x7d, 0x28, 0x89, 0x4c, 0x24, 0x40);
    FCML_A64("vpexpandd 0x0000000000000100(%rsp),%ymm1", 0x62, 0xf2, 0x7d, 0x28, 0x89, 0x4c, 0x24, 0x40);
    FCML_I32("vpexpandd xmm1,xmmword ptr [esp+00000080h]", 0x62, 0xf2, 0x7d, 0x08, 0x89, 0x4c, 0x24, 0x20);
    FCML_A32("vpexpandd 0x00000080(%esp),%xmm1", 0x62, 0xf2, 0x7d, 0x08, 0x89, 0x4c, 0x24, 0x20);
    FCML_I64("vpexpandd xmm1,xmmword ptr [rsp+0000000000000080h]", 0x62, 0xf2, 0x7d, 0x08, 0x89, 0x4c, 0x24, 0x20);
    FCML_A64("vpexpandd 0x0000000000000080(%rsp),%xmm1", 0x62, 0xf2, 0x7d, 0x08, 0x89, 0x4c, 0x24, 0x20);
    FCML_A64("vpexpandd (%r9,%r8),%xmm10{%k4}{z}", 0x62, 0x12, 0x7d, 0x8c, 0x89, 0x14, 0x01);
    FCML_I64("vpexpandd xmm10{k4}{z},xmmword ptr [r9+r8]", 0x62, 0x12, 0x7d, 0x8c, 0x89, 0x14, 0x01);
    FCML_A32("vpexpandd (%ecx,%eax),%xmm2{%k5}{z}", 0x62, 0xf2, 0x7d, 0x8d, 0x89, 0x14, 0x01);
    FCML_I32("vpexpandd xmm2{k5}{z},xmmword ptr [ecx+eax]", 0x62, 0xf2, 0x7d, 0x8d, 0x89, 0x14, 0x01);
    FCML_A64("vpexpandd (%r9,%r8),%ymm10{%k4}{z}", 0x62, 0x12, 0x7d, 0xac, 0x89, 0x14, 0x01);
    FCML_I64("vpexpandd ymm10{k4}{z},ymmword ptr [r9+r8]", 0x62, 0x12, 0x7d, 0xac, 0x89, 0x14, 0x01);
    FCML_A32("vpexpandd (%ecx,%eax),%ymm2{%k5}{z}", 0x62, 0xf2, 0x7d, 0xad, 0x89, 0x14, 0x01);
    FCML_I32("vpexpandd ymm2{k5}{z},ymmword ptr [ecx+eax]", 0x62, 0xf2, 0x7d, 0xad, 0x89, 0x14, 0x01);
    FCML_A64("vpexpandd (%r9,%r8),%zmm10{%k4}{z}", 0x62, 0x12, 0x7d, 0xcc, 0x89, 0x14, 0x01);
    FCML_I64("vpexpandd zmm10{k4}{z},zmmword ptr [r9+r8]", 0x62, 0x12, 0x7d, 0xcc, 0x89, 0x14, 0x01);
    FCML_A32("vpexpandd (%ecx,%eax),%zmm2{%k5}{z}", 0x62, 0xf2, 0x7d, 0xcd, 0x89, 0x14, 0x01);
    FCML_I32("vpexpandd zmm2{k5}{z},zmmword ptr [ecx+eax]", 0x62, 0xf2, 0x7d, 0xcd, 0x89, 0x14, 0x01);
    FCML_A64("vpexpandd (%r9,%r8),%xmm10{%k4}", 0x62, 0x12, 0x7d, 0x0c, 0x89, 0x14, 0x01);
    FCML_I64("vpexpandd xmm10{k4},xmmword ptr [r9+r8]", 0x62, 0x12, 0x7d, 0x0c, 0x89, 0x14, 0x01);
    FCML_A32("vpexpandd (%ecx,%eax),%xmm2{%k5}", 0x62, 0xf2, 0x7d, 0x0d, 0x89, 0x14, 0x01);
    FCML_I32("vpexpandd xmm2{k5},xmmword ptr [ecx+eax]", 0x62, 0xf2, 0x7d, 0x0d, 0x89, 0x14, 0x01);
    FCML_A64("vpexpandd (%r9,%r8),%ymm10{%k4}", 0x62, 0x12, 0x7d, 0x2c, 0x89, 0x14, 0x01);
    FCML_I64("vpexpandd ymm10{k4},ymmword ptr [r9+r8]", 0x62, 0x12, 0x7d, 0x2c, 0x89, 0x14, 0x01);
    FCML_A32("vpexpandd (%ecx,%eax),%ymm2{%k5}", 0x62, 0xf2, 0x7d, 0x2d, 0x89, 0x14, 0x01);
    FCML_A64("vpexpandd (%r9,%r8),%zmm10{%k4}", 0x62, 0x12, 0x7d, 0x4c, 0x89, 0x14, 0x01);
    FCML_I64("vpexpandd zmm10{k4},zmmword ptr [r9+r8]", 0x62, 0x12, 0x7d, 0x4c, 0x89, 0x14, 0x01);
    FCML_A32("vpexpandd (%ecx,%eax),%zmm2{%k5}", 0x62, 0xf2, 0x7d, 0x4d, 0x89, 0x14, 0x01);
    FCML_I32("vpexpandd zmm2{k5},zmmword ptr [ecx+eax]", 0x62, 0xf2, 0x7d, 0x4d, 0x89, 0x14, 0x01);
}

void fcml_tf_instruction_VPEXPANDQ(void) {
    FCML_A64("vpexpandq (%rax),%xmm15", 0x62, 0x72, 0xfd, 0x08, 0x89, 0x38);
    FCML_I64("vpexpandq xmm15,xmmword ptr [rax]", 0x62, 0x72, 0xfd, 0x08, 0x89, 0x38);
    FCML_A32("vpexpandq (%eax),%xmm7", 0x62, 0xf2, 0xfd, 0x08, 0x89, 0x38);
    FCML_I32("vpexpandq xmm7,xmmword ptr [eax]", 0x62, 0xf2, 0xfd, 0x08, 0x89, 0x38);
    FCML_A64("vpexpandq (%rax),%ymm15", 0x62, 0x72, 0xfd, 0x28, 0x89, 0x38);
    FCML_I64("vpexpandq ymm15,ymmword ptr [rax]", 0x62, 0x72, 0xfd, 0x28, 0x89, 0x38);
    FCML_A32("vpexpandq (%eax),%ymm7", 0x62, 0xf2, 0xfd, 0x28, 0x89, 0x38);
    FCML_I32("vpexpandq ymm7,ymmword ptr [eax]", 0x62, 0xf2, 0xfd, 0x28, 0x89, 0x38);
    FCML_A64("vpexpandq (%rax),%zmm15", 0x62, 0x72, 0xfd, 0x48, 0x89, 0x38);
    FCML_I64("vpexpandq zmm15,zmmword ptr [rax]", 0x62, 0x72, 0xfd, 0x48, 0x89, 0x38);
    FCML_A32("vpexpandq (%eax),%zmm7", 0x62, 0xf2, 0xfd, 0x48, 0x89, 0x38);
    FCML_I32("vpexpandq zmm7,zmmword ptr [eax]", 0x62, 0xf2, 0xfd, 0x48, 0x89, 0x38);
    FCML_A64("vpexpandq %xmm1,%xmm15", 0x62, 0x72, 0xfd, 0x08, 0x89, 0xf9);
    FCML_I64("vpexpandq xmm15,xmm1", 0x62, 0x72, 0xfd, 0x08, 0x89, 0xf9);
    FCML_A32("vpexpandq %xmm1,%xmm7", 0x62, 0xf2, 0xfd, 0x08, 0x89, 0xf9);
    FCML_I32("vpexpandq xmm7,xmm1", 0x62, 0xf2, 0xfd, 0x08, 0x89, 0xf9);
    FCML_A64("vpexpandq %ymm6,%ymm14", 0x62, 0x72, 0xfd, 0x28, 0x89, 0xf6);
    FCML_I64("vpexpandq ymm14,ymm6", 0x62, 0x72, 0xfd, 0x28, 0x89, 0xf6);
    FCML_A32("vpexpandq %ymm5,%ymm6", 0x62, 0xf2, 0xfd, 0x28, 0x89, 0xf5);
    FCML_I32("vpexpandq ymm6,ymm5", 0x62, 0xf2, 0xfd, 0x28, 0x89, 0xf5);
    FCML_A64("vpexpandq %zmm4,%zmm6", 0x62, 0xf2, 0xfd, 0x48, 0x89, 0xf4);
    FCML_I64("vpexpandq zmm6,zmm4", 0x62, 0xf2, 0xfd, 0x48, 0x89, 0xf4);
    FCML_A32("vpexpandq %zmm4,%zmm6", 0x62, 0xf2, 0xfd, 0x48, 0x89, 0xf4);
    FCML_I32("vpexpandq zmm6,zmm4", 0x62, 0xf2, 0xfd, 0x48, 0x89, 0xf4);
    FCML_I32("vpexpandq zmm1,zmmword ptr [esp+00000200h]", 0x62, 0xf2, 0xfd, 0x48, 0x89, 0x4c, 0x24, 0x40);
    FCML_A32("vpexpandq 0x00000200(%esp),%zmm1", 0x62, 0xf2, 0xfd, 0x48, 0x89, 0x4c, 0x24, 0x40);
    FCML_I64("vpexpandq zmm1,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf2, 0xfd, 0x48, 0x89, 0x4c, 0x24, 0x40);
    FCML_A64("vpexpandq 0x0000000000000200(%rsp),%zmm1", 0x62, 0xf2, 0xfd, 0x48, 0x89, 0x4c, 0x24, 0x40);
    FCML_I32("vpexpandq ymm1,ymmword ptr [esp+00000100h]", 0x62, 0xf2, 0xfd, 0x28, 0x89, 0x4c, 0x24, 0x20);
    FCML_A32("vpexpandq 0x00000100(%esp),%ymm1", 0x62, 0xf2, 0xfd, 0x28, 0x89, 0x4c, 0x24, 0x20);
    FCML_I64("vpexpandq ymm1,ymmword ptr [rsp+0000000000000100h]", 0x62, 0xf2, 0xfd, 0x28, 0x89, 0x4c, 0x24, 0x20);
    FCML_A64("vpexpandq 0x0000000000000100(%rsp),%ymm1", 0x62, 0xf2, 0xfd, 0x28, 0x89, 0x4c, 0x24, 0x20);
    FCML_I32("vpexpandq xmm1,xmmword ptr [esp+00000080h]", 0x62, 0xf2, 0xfd, 0x08, 0x89, 0x4c, 0x24, 0x10);
    FCML_A32("vpexpandq 0x00000080(%esp),%xmm1", 0x62, 0xf2, 0xfd, 0x08, 0x89, 0x4c, 0x24, 0x10);
    FCML_I64("vpexpandq xmm1,xmmword ptr [rsp+0000000000000080h]", 0x62, 0xf2, 0xfd, 0x08, 0x89, 0x4c, 0x24, 0x10);
    FCML_A64("vpexpandq 0x0000000000000080(%rsp),%xmm1", 0x62, 0xf2, 0xfd, 0x08, 0x89, 0x4c, 0x24, 0x10);
    FCML_A64("vpexpandq (%r9,%r8),%xmm10{%k4}{z}", 0x62, 0x12, 0xfd, 0x8c, 0x89, 0x14, 0x01);
    FCML_I64("vpexpandq xmm10{k4}{z},xmmword ptr [r9+r8]", 0x62, 0x12, 0xfd, 0x8c, 0x89, 0x14, 0x01);
    FCML_A32("vpexpandq (%ecx,%eax),%xmm2{%k5}{z}", 0x62, 0xf2, 0xfd, 0x8d, 0x89, 0x14, 0x01);
    FCML_I32("vpexpandq xmm2{k5}{z},xmmword ptr [ecx+eax]", 0x62, 0xf2, 0xfd, 0x8d, 0x89, 0x14, 0x01);
    FCML_A64("vpexpandq (%r9,%r8),%ymm10{%k4}{z}", 0x62, 0x12, 0xfd, 0xac, 0x89, 0x14, 0x01);
    FCML_I64("vpexpandq ymm10{k4}{z},ymmword ptr [r9+r8]", 0x62, 0x12, 0xfd, 0xac, 0x89, 0x14, 0x01);
    FCML_A32("vpexpandq (%ecx,%eax),%ymm2{%k5}{z}", 0x62, 0xf2, 0xfd, 0xad, 0x89, 0x14, 0x01);
    FCML_I32("vpexpandq ymm2{k5}{z},ymmword ptr [ecx+eax]", 0x62, 0xf2, 0xfd, 0xad, 0x89, 0x14, 0x01);
    FCML_A64("vpexpandq (%r9,%r8),%zmm10{%k4}{z}", 0x62, 0x12, 0xfd, 0xcc, 0x89, 0x14, 0x01);
    FCML_I64("vpexpandq zmm10{k4}{z},zmmword ptr [r9+r8]", 0x62, 0x12, 0xfd, 0xcc, 0x89, 0x14, 0x01);
    FCML_A32("vpexpandq (%ecx,%eax),%zmm2{%k5}{z}", 0x62, 0xf2, 0xfd, 0xcd, 0x89, 0x14, 0x01);
    FCML_I32("vpexpandq zmm2{k5}{z},zmmword ptr [ecx+eax]", 0x62, 0xf2, 0xfd, 0xcd, 0x89, 0x14, 0x01);
    FCML_A64("vpexpandq (%r9,%r8),%xmm10{%k4}", 0x62, 0x12, 0xfd, 0x0c, 0x89, 0x14, 0x01);
    FCML_I64("vpexpandq xmm10{k4},xmmword ptr [r9+r8]", 0x62, 0x12, 0xfd, 0x0c, 0x89, 0x14, 0x01);
    FCML_A32("vpexpandq (%ecx,%eax),%xmm2{%k5}", 0x62, 0xf2, 0xfd, 0x0d, 0x89, 0x14, 0x01);
    FCML_I32("vpexpandq xmm2{k5},xmmword ptr [ecx+eax]", 0x62, 0xf2, 0xfd, 0x0d, 0x89, 0x14, 0x01);
    FCML_A64("vpexpandq (%r9,%r8),%ymm10{%k4}", 0x62, 0x12, 0xfd, 0x2c, 0x89, 0x14, 0x01);
    FCML_I64("vpexpandq ymm10{k4},ymmword ptr [r9+r8]", 0x62, 0x12, 0xfd, 0x2c, 0x89, 0x14, 0x01);
    FCML_A32("vpexpandq (%ecx,%eax),%ymm2{%k5}", 0x62, 0xf2, 0xfd, 0x2d, 0x89, 0x14, 0x01);
    FCML_A64("vpexpandq (%r9,%r8),%zmm10{%k4}", 0x62, 0x12, 0xfd, 0x4c, 0x89, 0x14, 0x01);
    FCML_I64("vpexpandq zmm10{k4},zmmword ptr [r9+r8]", 0x62, 0x12, 0xfd, 0x4c, 0x89, 0x14, 0x01);
    FCML_A32("vpexpandq (%ecx,%eax),%zmm2{%k5}", 0x62, 0xf2, 0xfd, 0x4d, 0x89, 0x14, 0x01);
    FCML_I32("vpexpandq zmm2{k5},zmmword ptr [ecx+eax]", 0x62, 0xf2, 0xfd, 0x4d, 0x89, 0x14, 0x01);
}

void fcml_tf_instruction_VPLZCNTD(void) {
    FCML_I32("vplzcntd xmm0,xmm0", 0x62, 0xf2, 0x7d, 0x08, 0x44, 0xc0);
    FCML_I32("vplzcntd ymm0,ymm0", 0x62, 0xf2, 0x7d, 0x28, 0x44, 0xc0);
    FCML_I32("vplzcntd ymm0,ymm0", 0x62, 0xf2, 0x7d, 0x28, 0x44, 0xc0);
    FCML_I32("vplzcntd xmm0,xmmword ptr [eax]", 0x62, 0xf2, 0x7d, 0x08, 0x44, 0x00);
    FCML_I32("vplzcntd ymm0,ymmword ptr [eax]", 0x62, 0xf2, 0x7d, 0x28, 0x44, 0x00);
    FCML_I32("vplzcntd zmm0,zmmword ptr [eax]", 0x62, 0xf2, 0x7d, 0x48, 0x44, 0x00);
    FCML_I32("vplzcntd xmm0{k1},xmmword ptr [eax]", 0x62, 0xf2, 0x7d, 0x09, 0x44, 0x00);
    FCML_I32("vplzcntd ymm0{k2},ymmword ptr [eax]", 0x62, 0xf2, 0x7d, 0x2a, 0x44, 0x00);
    FCML_I32("vplzcntd zmm0{k3}{z},zmmword ptr [eax]", 0x62, 0xf2, 0x7d, 0xcb, 0x44, 0x00);
    FCML_I64("vplzcntd xmm1{k4}{z},dword ptr [rsp+0000000000000020h]{1to4}", 0x62, 0xf2, 0x7d, 0x9c, 0x44, 0x4c, 0x24, 0x08);
    FCML_I64("vplzcntd ymm1{k4}{z},dword ptr [rsp+0000000000000020h]{1to8}", 0x62, 0xf2, 0x7d, 0xbc, 0x44, 0x4c, 0x24, 0x08);
    FCML_I64("vplzcntd zmm1{k4}{z},dword ptr [rsp+0000000000000020h]{1to16}", 0x62, 0xf2, 0x7d, 0xdc, 0x44, 0x4c, 0x24, 0x08);
}

void fcml_tf_instruction_VPLZCNTQ(void) {
    FCML_I32("vplzcntq xmm0,xmm0", 0x62, 0xf2, 0xfd, 0x08, 0x44, 0xc0);
    FCML_I32("vplzcntq ymm0,ymm0", 0x62, 0xf2, 0xfd, 0x28, 0x44, 0xc0);
    FCML_I32("vplzcntq ymm0,ymm0", 0x62, 0xf2, 0xfd, 0x28, 0x44, 0xc0);
    FCML_I32("vplzcntq xmm0,xmmword ptr [eax]", 0x62, 0xf2, 0xfd, 0x08, 0x44, 0x00);
    FCML_I32("vplzcntq ymm0,ymmword ptr [eax]", 0x62, 0xf2, 0xfd, 0x28, 0x44, 0x00);
    FCML_I32("vplzcntq zmm0,zmmword ptr [eax]", 0x62, 0xf2, 0xfd, 0x48, 0x44, 0x00);
    FCML_I32("vplzcntq xmm0{k1},xmmword ptr [eax]", 0x62, 0xf2, 0xfd, 0x09, 0x44, 0x00);
    FCML_I32("vplzcntq ymm0{k2},ymmword ptr [eax]", 0x62, 0xf2, 0xfd, 0x2a, 0x44, 0x00);
    FCML_I32("vplzcntq zmm0{k3}{z},zmmword ptr [eax]", 0x62, 0xf2, 0xfd, 0xcb, 0x44, 0x00);
    FCML_I64("vplzcntq xmm1{k4}{z},mmword ptr [rsp+0000000000000020h]{1to2}", 0x62, 0xf2, 0xfd, 0x9c, 0x44, 0x4c, 0x24, 0x04);
    FCML_I64("vplzcntq ymm1{k4}{z},mmword ptr [rsp+0000000000000020h]{1to4}", 0x62, 0xf2, 0xfd, 0xbc, 0x44, 0x4c, 0x24, 0x04);
    FCML_I64("vplzcntq zmm1{k4}{z},mmword ptr [rsp+0000000000000020h]{1to8}", 0x62, 0xf2, 0xfd, 0xdc, 0x44, 0x4c, 0x24, 0x04);
}

void fcml_tf_instruction_VPMADD52HUQ(void) {
    /* xmm1, xmm2, m128 */
    FCML_A64("vpmadd52huq (%rax),%xmm7,%xmm15", 0x62, 0x72, 0xc5, 0x08, 0xb5, 0x38);
    FCML_I64("vpmadd52huq xmm15,xmm7,xmmword ptr [rax]", 0x62, 0x72, 0xc5, 0x08, 0xb5, 0x38);
    FCML_A32("vpmadd52huq (%eax),%xmm6,%xmm7", 0x62, 0xf2, 0xcd, 0x08, 0xb5, 0x38);
    FCML_I32("vpmadd52huq xmm7,xmm6,xmmword ptr [eax]", 0x62, 0xf2, 0xcd, 0x08, 0xb5, 0x38);
    /* ymm1, ymm2, m256 */
    FCML_A64("vpmadd52huq (%rax),%ymm7,%ymm15", 0x62, 0x72, 0xc5, 0x28, 0xb5, 0x38);
    FCML_I64("vpmadd52huq ymm15,ymm7,ymmword ptr [rax]", 0x62, 0x72, 0xc5, 0x28, 0xb5, 0x38);
    FCML_A32("vpmadd52huq (%eax),%ymm5,%ymm7", 0x62, 0xf2, 0xd5, 0x28, 0xb5, 0x38);
    FCML_I32("vpmadd52huq ymm7,ymm5,ymmword ptr [eax]", 0x62, 0xf2, 0xd5, 0x28, 0xb5, 0x38);
    /* zmm1, zmm2, m512 */
    FCML_A64("vpmadd52huq (%rax),%zmm7,%zmm15", 0x62, 0x72, 0xc5, 0x48, 0xb5, 0x38);
    FCML_I64("vpmadd52huq zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x72, 0xc5, 0x48, 0xb5, 0x38);
    FCML_A32("vpmadd52huq (%eax),%zmm3,%zmm7", 0x62, 0xf2, 0xe5, 0x48, 0xb5, 0x38);
    FCML_I32("vpmadd52huq zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf2, 0xe5, 0x48, 0xb5, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64("vpmadd52huq %xmm1,%xmm7,%xmm15", 0x62, 0x72, 0xc5, 0x08, 0xb5, 0xf9);
    FCML_I64("vpmadd52huq xmm15,xmm7,xmm1", 0x62, 0x72, 0xc5, 0x08, 0xb5, 0xf9);
    FCML_A32("vpmadd52huq %xmm1,%xmm2,%xmm7", 0x62, 0xf2, 0xed, 0x08, 0xb5, 0xf9);
    FCML_I32("vpmadd52huq xmm7,xmm2,xmm1", 0x62, 0xf2, 0xed, 0x08, 0xb5, 0xf9);
    /* ymm1, ymm2, ymm3 */
    FCML_A64("vpmadd52huq %ymm6,%ymm7,%ymm14", 0x62, 0x72, 0xc5, 0x28, 0xb5, 0xf6);
    FCML_I64("vpmadd52huq ymm14,ymm7,ymm6", 0x62, 0x72, 0xc5, 0x28, 0xb5, 0xf6);
    FCML_A32("vpmadd52huq %ymm5,%ymm3,%ymm6", 0x62, 0xf2, 0xe5, 0x28, 0xb5, 0xf5);
    FCML_I32("vpmadd52huq ymm6,ymm3,ymm5", 0x62, 0xf2, 0xe5, 0x28, 0xb5, 0xf5);
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpmadd52huq %zmm4,%zmm15,%zmm6", 0x62, 0xf2, 0x85, 0x48, 0xb5, 0xf4);
    FCML_I64("vpmadd52huq zmm6,zmm15,zmm4", 0x62, 0xf2, 0x85, 0x48, 0xb5, 0xf4);
    FCML_A32("vpmadd52huq %zmm4,%zmm6,%zmm6", 0x62, 0xf2, 0xcd, 0x48, 0xb5, 0xf4);
    FCML_I32("vpmadd52huq zmm6,zmm6,zmm4", 0x62, 0xf2, 0xcd, 0x48, 0xb5, 0xf4);
    /* disp8 */
    FCML_I32("vpmadd52huq zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf2, 0xed, 0x48, 0xb5, 0x4c, 0x24, 0x08);
    FCML_A32("vpmadd52huq 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x48, 0xb5, 0x4c, 0x24, 0x08);
    FCML_I64("vpmadd52huq zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf2, 0xed, 0x48, 0xb5, 0x4c, 0x24, 0x08);
    FCML_A64("vpmadd52huq 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x48, 0xb5, 0x4c, 0x24, 0x08);
    FCML_I32("vpmadd52huq ymm1,ymm2,ymmword ptr [esp+00000100h]", 0x62, 0xf2, 0xed, 0x28, 0xb5, 0x4c, 0x24, 0x08);
    FCML_A32("vpmadd52huq 0x00000100(%esp),%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x28, 0xb5, 0x4c, 0x24, 0x08);
    FCML_I64("vpmadd52huq ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 0x62, 0xf2, 0xed, 0x28, 0xb5, 0x4c, 0x24, 0x08);
    FCML_A64("vpmadd52huq 0x0000000000000100(%rsp),%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x28, 0xb5, 0x4c, 0x24, 0x08);
    FCML_I32("vpmadd52huq xmm1,xmm2,xmmword ptr [esp+00000080h]", 0x62, 0xf2, 0xed, 0x08, 0xb5, 0x4c, 0x24, 0x08);
    FCML_A32("vpmadd52huq 0x00000080(%esp),%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x08, 0xb5, 0x4c, 0x24, 0x08);
    FCML_I64("vpmadd52huq xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 0x62, 0xf2, 0xed, 0x08, 0xb5, 0x4c, 0x24, 0x08);
    FCML_A64("vpmadd52huq 0x0000000000000080(%rsp),%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x08, 0xb5, 0x4c, 0x24, 0x08);
    /* {k}{z} */
    FCML_A64("vpmadd52huq (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x12, 0x8d, 0x8c, 0xb5, 0x14, 0x01);
    FCML_I64("vpmadd52huq xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x8c, 0xb5, 0x14, 0x01);
    FCML_A32("vpmadd52huq (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0x8d, 0xb5, 0x14, 0x01);
    FCML_I32("vpmadd52huq xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x8d, 0xb5, 0x14, 0x01);
    FCML_A64("vpmadd52huq (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x12, 0x8d, 0xac, 0xb5, 0x14, 0x01);
    FCML_I64("vpmadd52huq ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0xac, 0xb5, 0x14, 0x01);
    FCML_A32("vpmadd52huq (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0xad, 0xb5, 0x14, 0x01);
    FCML_I32("vpmadd52huq ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0xad, 0xb5, 0x14, 0x01);
    FCML_A64("vpmadd52huq (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x12, 0x8d, 0xcc, 0xb5, 0x14, 0x01);
    FCML_I64("vpmadd52huq zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0xcc, 0xb5, 0x14, 0x01);
    FCML_A32("vpmadd52huq (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0xcd, 0xb5, 0x14, 0x01);
    FCML_I32("vpmadd52huq zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0xcd, 0xb5, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpmadd52huq (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x12, 0x8d, 0x0c, 0xb5, 0x14, 0x01);
    FCML_I64("vpmadd52huq xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x0c, 0xb5, 0x14, 0x01);
    FCML_A32("vpmadd52huq (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf2, 0xc5, 0x0d, 0xb5, 0x14, 0x01);
    FCML_I32("vpmadd52huq xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x0d, 0xb5, 0x14, 0x01);
    FCML_A64("vpmadd52huq (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x12, 0x8d, 0x2c, 0xb5, 0x14, 0x01);
    FCML_I64("vpmadd52huq ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x2c, 0xb5, 0x14, 0x01);
    FCML_A32("vpmadd52huq (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf2, 0xc5, 0x2d, 0xb5, 0x14, 0x01);
    FCML_I32("vpmadd52huq ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x2d, 0xb5, 0x14, 0x01);
    FCML_A64("vpmadd52huq (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x12, 0x8d, 0x4c, 0xb5, 0x14, 0x01);
    FCML_I64("vpmadd52huq zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x4c, 0xb5, 0x14, 0x01);
    FCML_A32("vpmadd52huq (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf2, 0xc5, 0x4d, 0xb5, 0x14, 0x01);
    FCML_I32("vpmadd52huq zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x4d, 0xb5, 0x14, 0x01);
    /* bcast */
    FCML_I64("vpmadd52huq zmm31,zmm21,mmword ptr [rsi]{1to8}", 0x62, 0x62, 0xd5, 0x50, 0xb5, 0x3e);
    FCML_A64("vpmadd52huq (%rsi){1to8},%zmm21,%zmm31", 0x62, 0x62, 0xd5, 0x50, 0xb5, 0x3e);
    FCML_I64("vpmadd52huq ymm31,ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x62, 0xd5, 0x30, 0xb5, 0x3e);
    FCML_A64("vpmadd52huq (%rsi){1to4},%ymm21,%ymm31", 0x62, 0x62, 0xd5, 0x30, 0xb5, 0x3e);
    FCML_I64("vpmadd52huq xmm31,xmm21,mmword ptr [rsi]{1to2}", 0x62, 0x62, 0xd5, 0x10, 0xb5, 0x3e);
    FCML_A64("vpmadd52huq (%rsi){1to2},%xmm21,%xmm31", 0x62, 0x62, 0xd5, 0x10, 0xb5, 0x3e);
    FCML_A32("vpmadd52huq (%esi){1to8},%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x58, 0xb5, 0x0e);
    FCML_I32("vpmadd52huq zmm1,zmm2,mmword ptr [esi]{1to8}", 0x62, 0xf2, 0xed, 0x58, 0xb5, 0x0e);
    /* {k}{z}{bcast} */
    FCML_A64("vpmadd52huq (%rsi){1to4},%ymm21,%ymm31{%k7}{z}", 0x62, 0x62, 0xd5, 0xb7, 0xb5, 0x3e);
    FCML_I64("vpmadd52huq ymm31{k7}{z},ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x62, 0xd5, 0xb7, 0xb5, 0x3e);
    /* {bcast} disp8 */
    FCML_I32("vpmadd52huq zmm1,zmm2,mmword ptr [esp+00000040h]{1to8}", 0x62, 0xf2, 0xed, 0x58, 0xb5, 0x4c, 0x24, 0x08);
    FCML_A32("vpmadd52huq 0x00000040(%esp){1to8},%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x58, 0xb5, 0x4c, 0x24, 0x08);
    FCML_I64("vpmadd52huq zmm1,zmm2,mmword ptr [rsp+0000000000000040h]{1to8}", 0x62, 0xf2, 0xed, 0x58, 0xb5, 0x4c, 0x24, 0x08);
    FCML_A64("vpmadd52huq 0x0000000000000040(%rsp){1to8},%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x58, 0xb5, 0x4c, 0x24, 0x08);
    FCML_I32("vpmadd52huq ymm1,ymm2,mmword ptr [esp+00000040h]{1to4}", 0x62, 0xf2, 0xed, 0x38, 0xb5, 0x4c, 0x24, 0x08);
    FCML_A32("vpmadd52huq 0x00000040(%esp){1to4},%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x38, 0xb5, 0x4c, 0x24, 0x08);
    FCML_I64("vpmadd52huq ymm1,ymm2,mmword ptr [rsp+0000000000000040h]{1to4}", 0x62, 0xf2, 0xed, 0x38, 0xb5, 0x4c, 0x24, 0x08);
    FCML_A64("vpmadd52huq 0x0000000000000040(%rsp){1to4},%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x38, 0xb5, 0x4c, 0x24, 0x08);
    FCML_I32("vpmadd52huq xmm1,xmm2,mmword ptr [esp+00000040h]{1to2}", 0x62, 0xf2, 0xed, 0x18, 0xb5, 0x4c, 0x24, 0x08);
    FCML_A32("vpmadd52huq 0x00000040(%esp){1to2},%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x18, 0xb5, 0x4c, 0x24, 0x08);
    FCML_I64("vpmadd52huq xmm1,xmm2,mmword ptr [rsp+0000000000000040h]{1to2}", 0x62, 0xf2, 0xed, 0x18, 0xb5, 0x4c, 0x24, 0x08);
    FCML_A64("vpmadd52huq 0x0000000000000040(%rsp){1to2},%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x18, 0xb5, 0x4c, 0x24, 0x08);
}

void fcml_tf_instruction_VPMADD52LUQ(void) {
    /* xmm1, xmm2, m128 */
    FCML_A64("vpmadd52luq (%rax),%xmm7,%xmm15", 0x62, 0x72, 0xc5, 0x08, 0xb4, 0x38);
    FCML_I64("vpmadd52luq xmm15,xmm7,xmmword ptr [rax]", 0x62, 0x72, 0xc5, 0x08, 0xb4, 0x38);
    FCML_A32("vpmadd52luq (%eax),%xmm6,%xmm7", 0x62, 0xf2, 0xcd, 0x08, 0xb4, 0x38);
    FCML_I32("vpmadd52luq xmm7,xmm6,xmmword ptr [eax]", 0x62, 0xf2, 0xcd, 0x08, 0xb4, 0x38);
    /* ymm1, ymm2, m256 */
    FCML_A64("vpmadd52luq (%rax),%ymm7,%ymm15", 0x62, 0x72, 0xc5, 0x28, 0xb4, 0x38);
    FCML_I64("vpmadd52luq ymm15,ymm7,ymmword ptr [rax]", 0x62, 0x72, 0xc5, 0x28, 0xb4, 0x38);
    FCML_A32("vpmadd52luq (%eax),%ymm5,%ymm7", 0x62, 0xf2, 0xd5, 0x28, 0xb4, 0x38);
    FCML_I32("vpmadd52luq ymm7,ymm5,ymmword ptr [eax]", 0x62, 0xf2, 0xd5, 0x28, 0xb4, 0x38);
    /* zmm1, zmm2, m512 */
    FCML_A64("vpmadd52luq (%rax),%zmm7,%zmm15", 0x62, 0x72, 0xc5, 0x48, 0xb4, 0x38);
    FCML_I64("vpmadd52luq zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x72, 0xc5, 0x48, 0xb4, 0x38);
    FCML_A32("vpmadd52luq (%eax),%zmm3,%zmm7", 0x62, 0xf2, 0xe5, 0x48, 0xb4, 0x38);
    FCML_I32("vpmadd52luq zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf2, 0xe5, 0x48, 0xb4, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64("vpmadd52luq %xmm1,%xmm7,%xmm15", 0x62, 0x72, 0xc5, 0x08, 0xb4, 0xf9);
    FCML_I64("vpmadd52luq xmm15,xmm7,xmm1", 0x62, 0x72, 0xc5, 0x08, 0xb4, 0xf9);
    FCML_A32("vpmadd52luq %xmm1,%xmm2,%xmm7", 0x62, 0xf2, 0xed, 0x08, 0xb4, 0xf9);
    FCML_I32("vpmadd52luq xmm7,xmm2,xmm1", 0x62, 0xf2, 0xed, 0x08, 0xb4, 0xf9);
    /* ymm1, ymm2, ymm3 */
    FCML_A64("vpmadd52luq %ymm6,%ymm7,%ymm14", 0x62, 0x72, 0xc5, 0x28, 0xb4, 0xf6);
    FCML_I64("vpmadd52luq ymm14,ymm7,ymm6", 0x62, 0x72, 0xc5, 0x28, 0xb4, 0xf6);
    FCML_A32("vpmadd52luq %ymm5,%ymm3,%ymm6", 0x62, 0xf2, 0xe5, 0x28, 0xb4, 0xf5);
    FCML_I32("vpmadd52luq ymm6,ymm3,ymm5", 0x62, 0xf2, 0xe5, 0x28, 0xb4, 0xf5);
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpmadd52luq %zmm4,%zmm15,%zmm6", 0x62, 0xf2, 0x85, 0x48, 0xb4, 0xf4);
    FCML_I64("vpmadd52luq zmm6,zmm15,zmm4", 0x62, 0xf2, 0x85, 0x48, 0xb4, 0xf4);
    FCML_A32("vpmadd52luq %zmm4,%zmm6,%zmm6", 0x62, 0xf2, 0xcd, 0x48, 0xb4, 0xf4);
    FCML_I32("vpmadd52luq zmm6,zmm6,zmm4", 0x62, 0xf2, 0xcd, 0x48, 0xb4, 0xf4);
    /* disp8 */
    FCML_I32("vpmadd52luq zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf2, 0xed, 0x48, 0xb4, 0x4c, 0x24, 0x08);
    FCML_A32("vpmadd52luq 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x48, 0xb4, 0x4c, 0x24, 0x08);
    FCML_I64("vpmadd52luq zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf2, 0xed, 0x48, 0xb4, 0x4c, 0x24, 0x08);
    FCML_A64("vpmadd52luq 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x48, 0xb4, 0x4c, 0x24, 0x08);
    FCML_I32("vpmadd52luq ymm1,ymm2,ymmword ptr [esp+00000100h]", 0x62, 0xf2, 0xed, 0x28, 0xb4, 0x4c, 0x24, 0x08);
    FCML_A32("vpmadd52luq 0x00000100(%esp),%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x28, 0xb4, 0x4c, 0x24, 0x08);
    FCML_I64("vpmadd52luq ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 0x62, 0xf2, 0xed, 0x28, 0xb4, 0x4c, 0x24, 0x08);
    FCML_A64("vpmadd52luq 0x0000000000000100(%rsp),%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x28, 0xb4, 0x4c, 0x24, 0x08);
    FCML_I32("vpmadd52luq xmm1,xmm2,xmmword ptr [esp+00000080h]", 0x62, 0xf2, 0xed, 0x08, 0xb4, 0x4c, 0x24, 0x08);
    FCML_A32("vpmadd52luq 0x00000080(%esp),%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x08, 0xb4, 0x4c, 0x24, 0x08);
    FCML_I64("vpmadd52luq xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 0x62, 0xf2, 0xed, 0x08, 0xb4, 0x4c, 0x24, 0x08);
    FCML_A64("vpmadd52luq 0x0000000000000080(%rsp),%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x08, 0xb4, 0x4c, 0x24, 0x08);
    /* {k}{z} */
    FCML_A64("vpmadd52luq (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x12, 0x8d, 0x8c, 0xb4, 0x14, 0x01);
    FCML_I64("vpmadd52luq xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x8c, 0xb4, 0x14, 0x01);
    FCML_A32("vpmadd52luq (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0x8d, 0xb4, 0x14, 0x01);
    FCML_I32("vpmadd52luq xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x8d, 0xb4, 0x14, 0x01);
    FCML_A64("vpmadd52luq (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x12, 0x8d, 0xac, 0xb4, 0x14, 0x01);
    FCML_I64("vpmadd52luq ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0xac, 0xb4, 0x14, 0x01);
    FCML_A32("vpmadd52luq (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0xad, 0xb4, 0x14, 0x01);
    FCML_I32("vpmadd52luq ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0xad, 0xb4, 0x14, 0x01);
    FCML_A64("vpmadd52luq (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x12, 0x8d, 0xcc, 0xb4, 0x14, 0x01);
    FCML_I64("vpmadd52luq zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0xcc, 0xb4, 0x14, 0x01);
    FCML_A32("vpmadd52luq (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0xcd, 0xb4, 0x14, 0x01);
    FCML_I32("vpmadd52luq zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0xcd, 0xb4, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpmadd52luq (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x12, 0x8d, 0x0c, 0xb4, 0x14, 0x01);
    FCML_I64("vpmadd52luq xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x0c, 0xb4, 0x14, 0x01);
    FCML_A32("vpmadd52luq (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf2, 0xc5, 0x0d, 0xb4, 0x14, 0x01);
    FCML_I32("vpmadd52luq xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x0d, 0xb4, 0x14, 0x01);
    FCML_A64("vpmadd52luq (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x12, 0x8d, 0x2c, 0xb4, 0x14, 0x01);
    FCML_I64("vpmadd52luq ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x2c, 0xb4, 0x14, 0x01);
    FCML_A32("vpmadd52luq (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf2, 0xc5, 0x2d, 0xb4, 0x14, 0x01);
    FCML_I32("vpmadd52luq ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x2d, 0xb4, 0x14, 0x01);
    FCML_A64("vpmadd52luq (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x12, 0x8d, 0x4c, 0xb4, 0x14, 0x01);
    FCML_I64("vpmadd52luq zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x4c, 0xb4, 0x14, 0x01);
    FCML_A32("vpmadd52luq (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf2, 0xc5, 0x4d, 0xb4, 0x14, 0x01);
    FCML_I32("vpmadd52luq zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x4d, 0xb4, 0x14, 0x01);
    /* bcast */
    FCML_I64("vpmadd52luq zmm31,zmm21,mmword ptr [rsi]{1to8}", 0x62, 0x62, 0xd5, 0x50, 0xb4, 0x3e);
    FCML_A64("vpmadd52luq (%rsi){1to8},%zmm21,%zmm31", 0x62, 0x62, 0xd5, 0x50, 0xb4, 0x3e);
    FCML_I64("vpmadd52luq ymm31,ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x62, 0xd5, 0x30, 0xb4, 0x3e);
    FCML_A64("vpmadd52luq (%rsi){1to4},%ymm21,%ymm31", 0x62, 0x62, 0xd5, 0x30, 0xb4, 0x3e);
    FCML_I64("vpmadd52luq xmm31,xmm21,mmword ptr [rsi]{1to2}", 0x62, 0x62, 0xd5, 0x10, 0xb4, 0x3e);
    FCML_A64("vpmadd52luq (%rsi){1to2},%xmm21,%xmm31", 0x62, 0x62, 0xd5, 0x10, 0xb4, 0x3e);
    FCML_A32("vpmadd52luq (%esi){1to8},%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x58, 0xb4, 0x0e);
    FCML_I32("vpmadd52luq zmm1,zmm2,mmword ptr [esi]{1to8}", 0x62, 0xf2, 0xed, 0x58, 0xb4, 0x0e);
    /* {k}{z}{bcast} */
    FCML_A64("vpmadd52luq (%rsi){1to4},%ymm21,%ymm31{%k7}{z}", 0x62, 0x62, 0xd5, 0xb7, 0xb4, 0x3e);
    FCML_I64("vpmadd52luq ymm31{k7}{z},ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x62, 0xd5, 0xb7, 0xb4, 0x3e);
    /* {bcast} disp8 */
    FCML_I32("vpmadd52luq zmm1,zmm2,mmword ptr [esp+00000040h]{1to8}", 0x62, 0xf2, 0xed, 0x58, 0xb4, 0x4c, 0x24, 0x08);
    FCML_A32("vpmadd52luq 0x00000040(%esp){1to8},%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x58, 0xb4, 0x4c, 0x24, 0x08);
    FCML_I64("vpmadd52luq zmm1,zmm2,mmword ptr [rsp+0000000000000040h]{1to8}", 0x62, 0xf2, 0xed, 0x58, 0xb4, 0x4c, 0x24, 0x08);
    FCML_A64("vpmadd52luq 0x0000000000000040(%rsp){1to8},%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x58, 0xb4, 0x4c, 0x24, 0x08);
    FCML_I32("vpmadd52luq ymm1,ymm2,mmword ptr [esp+00000040h]{1to4}", 0x62, 0xf2, 0xed, 0x38, 0xb4, 0x4c, 0x24, 0x08);
    FCML_A32("vpmadd52luq 0x00000040(%esp){1to4},%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x38, 0xb4, 0x4c, 0x24, 0x08);
    FCML_I64("vpmadd52luq ymm1,ymm2,mmword ptr [rsp+0000000000000040h]{1to4}", 0x62, 0xf2, 0xed, 0x38, 0xb4, 0x4c, 0x24, 0x08);
    FCML_A64("vpmadd52luq 0x0000000000000040(%rsp){1to4},%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x38, 0xb4, 0x4c, 0x24, 0x08);
    FCML_I32("vpmadd52luq xmm1,xmm2,mmword ptr [esp+00000040h]{1to2}", 0x62, 0xf2, 0xed, 0x18, 0xb4, 0x4c, 0x24, 0x08);
    FCML_A32("vpmadd52luq 0x00000040(%esp){1to2},%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x18, 0xb4, 0x4c, 0x24, 0x08);
    FCML_I64("vpmadd52luq xmm1,xmm2,mmword ptr [rsp+0000000000000040h]{1to2}", 0x62, 0xf2, 0xed, 0x18, 0xb4, 0x4c, 0x24, 0x08);
    FCML_A64("vpmadd52luq 0x0000000000000040(%rsp){1to2},%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x18, 0xb4, 0x4c, 0x24, 0x08);
}

void fcml_tf_instruction_VPMOVB2M(void) {
    FCML_I64("vpmovb2m k1,xmm2", 0x62, 0xf2, 0x7e, 0x08, 0x29, 0xca);
    FCML_I64("vpmovb2m k1,ymm2", 0x62, 0xf2, 0x7e, 0x28, 0x29, 0xca);
    FCML_I64("vpmovb2m k1,zmm2", 0x62, 0xf2, 0x7e, 0x48, 0x29, 0xca);
}

void fcml_tf_instruction_VPMOVW2M(void) {
    FCML_I64("vpmovw2m k1,xmm2", 0x62, 0xf2, 0xfe, 0x08, 0x29, 0xca);
    FCML_I64("vpmovw2m k1,ymm2", 0x62, 0xf2, 0xfe, 0x28, 0x29, 0xca);
    FCML_I64("vpmovw2m k1,zmm2", 0x62, 0xf2, 0xfe, 0x48, 0x29, 0xca);
}

void fcml_tf_instruction_VPMOVD2M(void) {
    FCML_I64("vpmovd2m k1,xmm2", 0x62, 0xf2, 0x7e, 0x08, 0x39, 0xca);
    FCML_I64("vpmovd2m k1,ymm2", 0x62, 0xf2, 0x7e, 0x28, 0x39, 0xca);
    FCML_I64("vpmovd2m k1,zmm2", 0x62, 0xf2, 0x7e, 0x48, 0x39, 0xca);
}

void fcml_tf_instruction_VPMOVQ2M(void) {
    FCML_I64("vpmovq2m k1,xmm2", 0x62, 0xf2, 0xfe, 0x08, 0x39, 0xca);
    FCML_I64("vpmovq2m k1,ymm2", 0x62, 0xf2, 0xfe, 0x28, 0x39, 0xca);
    FCML_I64("vpmovq2m k1,zmm2", 0x62, 0xf2, 0xfe, 0x48, 0x39, 0xca);
}

void fcml_tf_instruction_VPMOVM2B(void) {
    FCML_I64("vpmovm2b xmm1,k2", 0x62, 0xf2, 0x7e, 0x08, 0x28, 0xca);
    FCML_I64("vpmovm2b ymm1,k2", 0x62, 0xf2, 0x7e, 0x28, 0x28, 0xca);
    FCML_I64("vpmovm2b zmm1,k2", 0x62, 0xf2, 0x7e, 0x48, 0x28, 0xca);
}

void fcml_tf_instruction_VPMOVM2W(void) {
    FCML_I64("vpmovm2w xmm1,k2", 0x62, 0xf2, 0xfe, 0x08, 0x28, 0xca);
    FCML_I64("vpmovm2w ymm1,k2", 0x62, 0xf2, 0xfe, 0x28, 0x28, 0xca);
    FCML_I64("vpmovm2w zmm1,k2", 0x62, 0xf2, 0xfe, 0x48, 0x28, 0xca);
}

void fcml_tf_instruction_VPMOVM2D(void) {
    FCML_I64("vpmovm2d xmm1,k2", 0x62, 0xf2, 0x7e, 0x08, 0x38, 0xca);
    FCML_I64("vpmovm2d ymm1,k2", 0x62, 0xf2, 0x7e, 0x28, 0x38, 0xca);
    FCML_I64("vpmovm2d zmm1,k2", 0x62, 0xf2, 0x7e, 0x48, 0x38, 0xca);
}

void fcml_tf_instruction_VPMOVM2Q(void) {
    FCML_I64("vpmovm2q xmm1,k2", 0x62, 0xf2, 0xfe, 0x08, 0x38, 0xca);
    FCML_I64("vpmovm2q ymm1,k2", 0x62, 0xf2, 0xfe, 0x28, 0x38, 0xca);
    FCML_I64("vpmovm2q zmm1,k2", 0x62, 0xf2, 0xfe, 0x48, 0x38, 0xca);
}

void fcml_tf_instruction_VPMOVDB(void) {
    FCML_I32("vpmovdb xmm0,xmm0", 0x62, 0xf2, 0x7e, 0x08, 0x31, 0xc0);
    FCML_I32("vpmovdb xmm0,ymm0", 0x62, 0xf2, 0x7e, 0x28, 0x31, 0xc0);
    FCML_I32("vpmovdb xmm0,zmm0", 0x62, 0xf2, 0x7e, 0x48, 0x31, 0xc0);
    FCML_I32("vpmovdb xmm0{k1}{z},xmm0", 0x62, 0xf2, 0x7e, 0x89, 0x31, 0xc0);
    FCML_I32("vpmovdb xmm0{k1}{z},ymm0", 0x62, 0xf2, 0x7e, 0xa9, 0x31, 0xc0);
    FCML_I32("vpmovdb xmm0{k1}{z},zmm0", 0x62, 0xf2, 0x7e, 0xc9, 0x31, 0xc0);
    FCML_I32("vpmovdb dword ptr [eax],xmm1", 0x62, 0xf2, 0x7e, 0x08, 0x31, 0x08);
    FCML_I32("vpmovdb mmword ptr [eax],ymm1", 0x62, 0xf2, 0x7e, 0x28, 0x31, 0x08);
    FCML_I32("vpmovdb xmmword ptr [eax],zmm1", 0x62, 0xf2, 0x7e, 0x48, 0x31, 0x08);
    FCML_I32("vpmovdb dword ptr [eax]{k2},xmm1", 0x62, 0xf2, 0x7e, 0x0a, 0x31, 0x08);
    FCML_I32("vpmovdb mmword ptr [eax]{k3},ymm1", 0x62, 0xf2, 0x7e, 0x2b, 0x31, 0x08);
    FCML_I32("vpmovdb xmmword ptr [eax]{k4},zmm1", 0x62, 0xf2, 0x7e, 0x4c, 0x31, 0x08);
}

void fcml_tf_instruction_VPMOVSDB(void) {
    FCML_I32("vpmovsdb xmm0,xmm0", 0x62, 0xf2, 0x7e, 0x08, 0x21, 0xc0);
    FCML_I32("vpmovsdb xmm0,ymm0", 0x62, 0xf2, 0x7e, 0x28, 0x21, 0xc0);
    FCML_I32("vpmovsdb xmm0,zmm0", 0x62, 0xf2, 0x7e, 0x48, 0x21, 0xc0);
    FCML_I32("vpmovsdb xmm0{k1}{z},xmm0", 0x62, 0xf2, 0x7e, 0x89, 0x21, 0xc0);
    FCML_I32("vpmovsdb xmm0{k1}{z},ymm0", 0x62, 0xf2, 0x7e, 0xa9, 0x21, 0xc0);
    FCML_I32("vpmovsdb xmm0{k1}{z},zmm0", 0x62, 0xf2, 0x7e, 0xc9, 0x21, 0xc0);
    FCML_I32("vpmovsdb dword ptr [eax],xmm1", 0x62, 0xf2, 0x7e, 0x08, 0x21, 0x08);
    FCML_I32("vpmovsdb mmword ptr [eax],ymm1", 0x62, 0xf2, 0x7e, 0x28, 0x21, 0x08);
    FCML_I32("vpmovsdb xmmword ptr [eax],zmm1", 0x62, 0xf2, 0x7e, 0x48, 0x21, 0x08);
    FCML_I32("vpmovsdb dword ptr [eax]{k2},xmm1", 0x62, 0xf2, 0x7e, 0x0a, 0x21, 0x08);
    FCML_I32("vpmovsdb mmword ptr [eax]{k3},ymm1", 0x62, 0xf2, 0x7e, 0x2b, 0x21, 0x08);
    FCML_I32("vpmovsdb xmmword ptr [eax]{k4},zmm1", 0x62, 0xf2, 0x7e, 0x4c, 0x21, 0x08);
}

void fcml_tf_instruction_VPMOVUSDB(void) {
    FCML_I32("vpmovusdb xmm0,xmm0", 0x62, 0xf2, 0x7e, 0x08, 0x11, 0xc0);
    FCML_I32("vpmovusdb xmm0,ymm0", 0x62, 0xf2, 0x7e, 0x28, 0x11, 0xc0);
    FCML_I32("vpmovusdb xmm0,zmm0", 0x62, 0xf2, 0x7e, 0x48, 0x11, 0xc0);
    FCML_I32("vpmovusdb xmm0{k1}{z},xmm0", 0x62, 0xf2, 0x7e, 0x89, 0x11, 0xc0);
    FCML_I32("vpmovusdb xmm0{k1}{z},ymm0", 0x62, 0xf2, 0x7e, 0xa9, 0x11, 0xc0);
    FCML_I32("vpmovusdb xmm0{k1}{z},zmm0", 0x62, 0xf2, 0x7e, 0xc9, 0x11, 0xc0);
    FCML_I32("vpmovusdb dword ptr [eax],xmm1", 0x62, 0xf2, 0x7e, 0x08, 0x11, 0x08);
    FCML_I32("vpmovusdb mmword ptr [eax],ymm1", 0x62, 0xf2, 0x7e, 0x28, 0x11, 0x08);
    FCML_I32("vpmovusdb xmmword ptr [eax],zmm1", 0x62, 0xf2, 0x7e, 0x48, 0x11, 0x08);
    FCML_I32("vpmovusdb dword ptr [eax]{k2},xmm1", 0x62, 0xf2, 0x7e, 0x0a, 0x11, 0x08);
    FCML_I32("vpmovusdb mmword ptr [eax]{k3},ymm1", 0x62, 0xf2, 0x7e, 0x2b, 0x11, 0x08);
    FCML_I32("vpmovusdb xmmword ptr [eax]{k4},zmm1", 0x62, 0xf2, 0x7e, 0x4c, 0x11, 0x08);
}

void fcml_tf_instruction_VPMOVDW(void) {
    FCML_I32("vpmovdw xmm0,xmm0", 0x62, 0xf2, 0x7e, 0x08, 0x33, 0xc0);
    FCML_I32("vpmovdw xmm0,ymm0", 0x62, 0xf2, 0x7e, 0x28, 0x33, 0xc0);
    FCML_I32("vpmovdw xmm0,zmm0", 0x62, 0xf2, 0x7e, 0x48, 0x33, 0xc0);
    FCML_I32("vpmovdw xmm0{k1}{z},xmm0", 0x62, 0xf2, 0x7e, 0x89, 0x33, 0xc0);
    FCML_I32("vpmovdw xmm0{k1}{z},ymm0", 0x62, 0xf2, 0x7e, 0xa9, 0x33, 0xc0);
    FCML_I32("vpmovdw xmm0{k1}{z},zmm0", 0x62, 0xf2, 0x7e, 0xc9, 0x33, 0xc0);
    FCML_I32("vpmovdw mmword ptr [eax],xmm1", 0x62, 0xf2, 0x7e, 0x08, 0x33, 0x08);
    FCML_I32("vpmovdw xmmword ptr [eax],ymm1", 0x62, 0xf2, 0x7e, 0x28, 0x33, 0x08);
    FCML_I32("vpmovdw ymmword ptr [eax],zmm1", 0x62, 0xf2, 0x7e, 0x48, 0x33, 0x08);
    FCML_I32("vpmovdw mmword ptr [eax]{k2},xmm1", 0x62, 0xf2, 0x7e, 0x0a, 0x33, 0x08);
    FCML_I32("vpmovdw xmmword ptr [eax]{k3},ymm1", 0x62, 0xf2, 0x7e, 0x2b, 0x33, 0x08);
    FCML_I32("vpmovdw ymmword ptr [eax]{k4},zmm1", 0x62, 0xf2, 0x7e, 0x4c, 0x33, 0x08);
}

void fcml_tf_instruction_VPMOVSDW(void) {
    FCML_I32("vpmovsdw xmm0,xmm0", 0x62, 0xf2, 0x7e, 0x08, 0x23, 0xc0);
    FCML_I32("vpmovsdw xmm0,ymm0", 0x62, 0xf2, 0x7e, 0x28, 0x23, 0xc0);
    FCML_I32("vpmovsdw xmm0,zmm0", 0x62, 0xf2, 0x7e, 0x48, 0x23, 0xc0);
    FCML_I32("vpmovsdw xmm0{k1}{z},xmm0", 0x62, 0xf2, 0x7e, 0x89, 0x23, 0xc0);
    FCML_I32("vpmovsdw xmm0{k1}{z},ymm0", 0x62, 0xf2, 0x7e, 0xa9, 0x23, 0xc0);
    FCML_I32("vpmovsdw xmm0{k1}{z},zmm0", 0x62, 0xf2, 0x7e, 0xc9, 0x23, 0xc0);
    FCML_I32("vpmovsdw mmword ptr [eax],xmm1", 0x62, 0xf2, 0x7e, 0x08, 0x23, 0x08);
    FCML_I32("vpmovsdw xmmword ptr [eax],ymm1", 0x62, 0xf2, 0x7e, 0x28, 0x23, 0x08);
    FCML_I32("vpmovsdw ymmword ptr [eax],zmm1", 0x62, 0xf2, 0x7e, 0x48, 0x23, 0x08);
    FCML_I32("vpmovsdw mmword ptr [eax]{k2},xmm1", 0x62, 0xf2, 0x7e, 0x0a, 0x23, 0x08);
    FCML_I32("vpmovsdw xmmword ptr [eax]{k3},ymm1", 0x62, 0xf2, 0x7e, 0x2b, 0x23, 0x08);
    FCML_I32("vpmovsdw ymmword ptr [eax]{k4},zmm1", 0x62, 0xf2, 0x7e, 0x4c, 0x23, 0x08);
}

void fcml_tf_instruction_VPMOVUSDW(void) {
    FCML_I32("vpmovusdw xmm0,xmm0", 0x62, 0xf2, 0x7e, 0x08, 0x13, 0xc0);
    FCML_I32("vpmovusdw xmm0,ymm0", 0x62, 0xf2, 0x7e, 0x28, 0x13, 0xc0);
    FCML_I32("vpmovusdw xmm0,zmm0", 0x62, 0xf2, 0x7e, 0x48, 0x13, 0xc0);
    FCML_I32("vpmovusdw xmm0{k1}{z},xmm0", 0x62, 0xf2, 0x7e, 0x89, 0x13, 0xc0);
    FCML_I32("vpmovusdw xmm0{k1}{z},ymm0", 0x62, 0xf2, 0x7e, 0xa9, 0x13, 0xc0);
    FCML_I32("vpmovusdw xmm0{k1}{z},zmm0", 0x62, 0xf2, 0x7e, 0xc9, 0x13, 0xc0);
    FCML_I32("vpmovusdw mmword ptr [eax],xmm1", 0x62, 0xf2, 0x7e, 0x08, 0x13, 0x08);
    FCML_I32("vpmovusdw xmmword ptr [eax],ymm1", 0x62, 0xf2, 0x7e, 0x28, 0x13, 0x08);
    FCML_I32("vpmovusdw ymmword ptr [eax],zmm1", 0x62, 0xf2, 0x7e, 0x48, 0x13, 0x08);
    FCML_I32("vpmovusdw mmword ptr [eax]{k2},xmm1", 0x62, 0xf2, 0x7e, 0x0a, 0x13, 0x08);
    FCML_I32("vpmovusdw xmmword ptr [eax]{k3},ymm1", 0x62, 0xf2, 0x7e, 0x2b, 0x13, 0x08);
    FCML_I32("vpmovusdw ymmword ptr [eax]{k4},zmm1", 0x62, 0xf2, 0x7e, 0x4c, 0x13, 0x08);
}

void fcml_tf_instruction_VPMOVQB(void) {
    FCML_I32("vpmovqb xmm0,xmm0", 0x62, 0xf2, 0x7e, 0x08, 0x32, 0xc0);
    FCML_I32("vpmovqb xmm0,ymm0", 0x62, 0xf2, 0x7e, 0x28, 0x32, 0xc0);
    FCML_I32("vpmovqb xmm0,zmm0", 0x62, 0xf2, 0x7e, 0x48, 0x32, 0xc0);
    FCML_I32("vpmovqb xmm0{k1}{z},xmm0", 0x62, 0xf2, 0x7e, 0x89, 0x32, 0xc0);
    FCML_I32("vpmovqb xmm0{k1}{z},ymm0", 0x62, 0xf2, 0x7e, 0xa9, 0x32, 0xc0);
    FCML_I32("vpmovqb xmm0{k1}{z},zmm0", 0x62, 0xf2, 0x7e, 0xc9, 0x32, 0xc0);
    FCML_I32("vpmovqb word ptr [eax],xmm1", 0x62, 0xf2, 0x7e, 0x08, 0x32, 0x08);
    FCML_I32("vpmovqb dword ptr [eax],ymm1", 0x62, 0xf2, 0x7e, 0x28, 0x32, 0x08);
    FCML_I32("vpmovqb mmword ptr [eax],zmm1", 0x62, 0xf2, 0x7e, 0x48, 0x32, 0x08);
    FCML_I32("vpmovqb word ptr [eax]{k2},xmm1", 0x62, 0xf2, 0x7e, 0x0a, 0x32, 0x08);
    FCML_I32("vpmovqb dword ptr [eax]{k3},ymm1", 0x62, 0xf2, 0x7e, 0x2b, 0x32, 0x08);
    FCML_I32("vpmovqb mmword ptr [eax]{k4},zmm1", 0x62, 0xf2, 0x7e, 0x4c, 0x32, 0x08);
}

void fcml_tf_instruction_VPMOVSQB(void) {
    FCML_I32("vpmovsqb xmm0,xmm0", 0x62, 0xf2, 0x7e, 0x08, 0x22, 0xc0);
    FCML_I32("vpmovsqb xmm0,ymm0", 0x62, 0xf2, 0x7e, 0x28, 0x22, 0xc0);
    FCML_I32("vpmovsqb xmm0,zmm0", 0x62, 0xf2, 0x7e, 0x48, 0x22, 0xc0);
    FCML_I32("vpmovsqb xmm0{k1}{z},xmm0", 0x62, 0xf2, 0x7e, 0x89, 0x22, 0xc0);
    FCML_I32("vpmovsqb xmm0{k1}{z},ymm0", 0x62, 0xf2, 0x7e, 0xa9, 0x22, 0xc0);
    FCML_I32("vpmovsqb xmm0{k1}{z},zmm0", 0x62, 0xf2, 0x7e, 0xc9, 0x22, 0xc0);
    FCML_I32("vpmovsqb word ptr [eax],xmm1", 0x62, 0xf2, 0x7e, 0x08, 0x22, 0x08);
    FCML_I32("vpmovsqb dword ptr [eax],ymm1", 0x62, 0xf2, 0x7e, 0x28, 0x22, 0x08);
    FCML_I32("vpmovsqb mmword ptr [eax],zmm1", 0x62, 0xf2, 0x7e, 0x48, 0x22, 0x08);
    FCML_I32("vpmovsqb word ptr [eax]{k2},xmm1", 0x62, 0xf2, 0x7e, 0x0a, 0x22, 0x08);
    FCML_I32("vpmovsqb dword ptr [eax]{k3},ymm1", 0x62, 0xf2, 0x7e, 0x2b, 0x22, 0x08);
    FCML_I32("vpmovsqb mmword ptr [eax]{k4},zmm1", 0x62, 0xf2, 0x7e, 0x4c, 0x22, 0x08);
}

void fcml_tf_instruction_VPMOVUSQB(void) {
    FCML_I32("vpmovusqb xmm0,xmm0", 0x62, 0xf2, 0x7e, 0x08, 0x12, 0xc0);
    FCML_I32("vpmovusqb xmm0,ymm0", 0x62, 0xf2, 0x7e, 0x28, 0x12, 0xc0);
    FCML_I32("vpmovusqb xmm0,zmm0", 0x62, 0xf2, 0x7e, 0x48, 0x12, 0xc0);
    FCML_I32("vpmovusqb xmm0{k1}{z},xmm0", 0x62, 0xf2, 0x7e, 0x89, 0x12, 0xc0);
    FCML_I32("vpmovusqb xmm0{k1}{z},ymm0", 0x62, 0xf2, 0x7e, 0xa9, 0x12, 0xc0);
    FCML_I32("vpmovusqb xmm0{k1}{z},zmm0", 0x62, 0xf2, 0x7e, 0xc9, 0x12, 0xc0);
    FCML_I32("vpmovusqb word ptr [eax],xmm1", 0x62, 0xf2, 0x7e, 0x08, 0x12, 0x08);
    FCML_I32("vpmovusqb dword ptr [eax],ymm1", 0x62, 0xf2, 0x7e, 0x28, 0x12, 0x08);
    FCML_I32("vpmovusqb mmword ptr [eax],zmm1", 0x62, 0xf2, 0x7e, 0x48, 0x12, 0x08);
    FCML_I32("vpmovusqb word ptr [eax]{k2},xmm1", 0x62, 0xf2, 0x7e, 0x0a, 0x12, 0x08);
    FCML_I32("vpmovusqb dword ptr [eax]{k3},ymm1", 0x62, 0xf2, 0x7e, 0x2b, 0x12, 0x08);
    FCML_I32("vpmovusqb mmword ptr [eax]{k4},zmm1", 0x62, 0xf2, 0x7e, 0x4c, 0x12, 0x08);
}

void fcml_tf_instruction_VPMOVQD(void) {
    FCML_I32("vpmovqd xmm0,xmm0", 0x62, 0xf2, 0x7e, 0x08, 0x35, 0xc0);
    FCML_I32("vpmovqd xmm0,ymm0", 0x62, 0xf2, 0x7e, 0x28, 0x35, 0xc0);
    FCML_I32("vpmovqd xmm0,zmm0", 0x62, 0xf2, 0x7e, 0x48, 0x35, 0xc0);
    FCML_I32("vpmovqd xmm0{k1}{z},xmm0", 0x62, 0xf2, 0x7e, 0x89, 0x35, 0xc0);
    FCML_I32("vpmovqd xmm0{k1}{z},ymm0", 0x62, 0xf2, 0x7e, 0xa9, 0x35, 0xc0);
    FCML_I32("vpmovqd xmm0{k1}{z},zmm0", 0x62, 0xf2, 0x7e, 0xc9, 0x35, 0xc0);
    FCML_I32("vpmovqd xmmword ptr [eax],xmm1", 0x62, 0xf2, 0x7e, 0x08, 0x35, 0x08);
    FCML_I32("vpmovqd xmmword ptr [eax],ymm1", 0x62, 0xf2, 0x7e, 0x28, 0x35, 0x08);
    FCML_I32("vpmovqd ymmword ptr [eax],zmm1", 0x62, 0xf2, 0x7e, 0x48, 0x35, 0x08);
    FCML_I32("vpmovqd xmmword ptr [eax]{k2},xmm1", 0x62, 0xf2, 0x7e, 0x0a, 0x35, 0x08);
    FCML_I32("vpmovqd xmmword ptr [eax]{k3},ymm1", 0x62, 0xf2, 0x7e, 0x2b, 0x35, 0x08);
    FCML_I32("vpmovqd ymmword ptr [eax]{k4},zmm1", 0x62, 0xf2, 0x7e, 0x4c, 0x35, 0x08);
}

void fcml_tf_instruction_VPMOVSQD(void) {
    FCML_I32("vpmovsqd xmm0,xmm0", 0x62, 0xf2, 0x7e, 0x08, 0x25, 0xc0);
    FCML_I32("vpmovsqd xmm0,ymm0", 0x62, 0xf2, 0x7e, 0x28, 0x25, 0xc0);
    FCML_I32("vpmovsqd xmm0,zmm0", 0x62, 0xf2, 0x7e, 0x48, 0x25, 0xc0);
    FCML_I32("vpmovsqd xmm0{k1}{z},xmm0", 0x62, 0xf2, 0x7e, 0x89, 0x25, 0xc0);
    FCML_I32("vpmovsqd xmm0{k1}{z},ymm0", 0x62, 0xf2, 0x7e, 0xa9, 0x25, 0xc0);
    FCML_I32("vpmovsqd xmm0{k1}{z},zmm0", 0x62, 0xf2, 0x7e, 0xc9, 0x25, 0xc0);
    FCML_I32("vpmovsqd mmword ptr [eax],xmm1", 0x62, 0xf2, 0x7e, 0x08, 0x25, 0x08);
    FCML_I32("vpmovsqd xmmword ptr [eax],ymm1", 0x62, 0xf2, 0x7e, 0x28, 0x25, 0x08);
    FCML_I32("vpmovsqd ymmword ptr [eax],zmm1", 0x62, 0xf2, 0x7e, 0x48, 0x25, 0x08);
    FCML_I32("vpmovsqd mmword ptr [eax]{k2},xmm1", 0x62, 0xf2, 0x7e, 0x0a, 0x25, 0x08);
    FCML_I32("vpmovsqd xmmword ptr [eax]{k3},ymm1", 0x62, 0xf2, 0x7e, 0x2b, 0x25, 0x08);
    FCML_I32("vpmovsqd ymmword ptr [eax]{k4},zmm1", 0x62, 0xf2, 0x7e, 0x4c, 0x25, 0x08);
}

void fcml_tf_instruction_VPMOVUSQD(void) {
    FCML_I32("vpmovusqd xmm0,xmm0", 0x62, 0xf2, 0x7e, 0x08, 0x15, 0xc0);
    FCML_I32("vpmovusqd xmm0,ymm0", 0x62, 0xf2, 0x7e, 0x28, 0x15, 0xc0);
    FCML_I32("vpmovusqd xmm0,zmm0", 0x62, 0xf2, 0x7e, 0x48, 0x15, 0xc0);
    FCML_I32("vpmovusqd xmm0{k1}{z},xmm0", 0x62, 0xf2, 0x7e, 0x89, 0x15, 0xc0);
    FCML_I32("vpmovusqd xmm0{k1}{z},ymm0", 0x62, 0xf2, 0x7e, 0xa9, 0x15, 0xc0);
    FCML_I32("vpmovusqd xmm0{k1}{z},zmm0", 0x62, 0xf2, 0x7e, 0xc9, 0x15, 0xc0);
    FCML_I32("vpmovusqd mmword ptr [eax],xmm1", 0x62, 0xf2, 0x7e, 0x08, 0x15, 0x08);
    FCML_I32("vpmovusqd xmmword ptr [eax],ymm1", 0x62, 0xf2, 0x7e, 0x28, 0x15, 0x08);
    FCML_I32("vpmovusqd ymmword ptr [eax],zmm1", 0x62, 0xf2, 0x7e, 0x48, 0x15, 0x08);
    FCML_I32("vpmovusqd mmword ptr [eax]{k2},xmm1", 0x62, 0xf2, 0x7e, 0x0a, 0x15, 0x08);
    FCML_I32("vpmovusqd xmmword ptr [eax]{k3},ymm1", 0x62, 0xf2, 0x7e, 0x2b, 0x15, 0x08);
    FCML_I32("vpmovusqd ymmword ptr [eax]{k4},zmm1", 0x62, 0xf2, 0x7e, 0x4c, 0x15, 0x08);
}

void fcml_tf_instruction_VPMOVQW(void) {
    FCML_I32("vpmovqw xmm0,xmm0", 0x62, 0xf2, 0x7e, 0x08, 0x34, 0xc0);
    FCML_I32("vpmovqw xmm0,ymm0", 0x62, 0xf2, 0x7e, 0x28, 0x34, 0xc0);
    FCML_I32("vpmovqw xmm0,zmm0", 0x62, 0xf2, 0x7e, 0x48, 0x34, 0xc0);
    FCML_I32("vpmovqw xmm0{k1}{z},xmm0", 0x62, 0xf2, 0x7e, 0x89, 0x34, 0xc0);
    FCML_I32("vpmovqw xmm0{k1}{z},ymm0", 0x62, 0xf2, 0x7e, 0xa9, 0x34, 0xc0);
    FCML_I32("vpmovqw xmm0{k1}{z},zmm0", 0x62, 0xf2, 0x7e, 0xc9, 0x34, 0xc0);
    FCML_I32("vpmovqw dword ptr [eax],xmm1", 0x62, 0xf2, 0x7e, 0x08, 0x34, 0x08);
    FCML_I32("vpmovqw mmword ptr [eax],ymm1", 0x62, 0xf2, 0x7e, 0x28, 0x34, 0x08);
    FCML_I32("vpmovqw xmmword ptr [eax],zmm1", 0x62, 0xf2, 0x7e, 0x48, 0x34, 0x08);
    FCML_I32("vpmovqw dword ptr [eax]{k2},xmm1", 0x62, 0xf2, 0x7e, 0x0a, 0x34, 0x08);
    FCML_I32("vpmovqw mmword ptr [eax]{k3},ymm1", 0x62, 0xf2, 0x7e, 0x2b, 0x34, 0x08);
    FCML_I32("vpmovqw xmmword ptr [eax]{k4},zmm1", 0x62, 0xf2, 0x7e, 0x4c, 0x34, 0x08);
}

void fcml_tf_instruction_VPMOVSQW(void) {
    FCML_I32("vpmovsqw xmm0,xmm0", 0x62, 0xf2, 0x7e, 0x08, 0x24, 0xc0);
    FCML_I32("vpmovsqw xmm0,ymm0", 0x62, 0xf2, 0x7e, 0x28, 0x24, 0xc0);
    FCML_I32("vpmovsqw xmm0,zmm0", 0x62, 0xf2, 0x7e, 0x48, 0x24, 0xc0);
    FCML_I32("vpmovsqw xmm0{k1}{z},xmm0", 0x62, 0xf2, 0x7e, 0x89, 0x24, 0xc0);
    FCML_I32("vpmovsqw xmm0{k1}{z},ymm0", 0x62, 0xf2, 0x7e, 0xa9, 0x24, 0xc0);
    FCML_I32("vpmovsqw xmm0{k1}{z},zmm0", 0x62, 0xf2, 0x7e, 0xc9, 0x24, 0xc0);
    FCML_I32("vpmovsqw dword ptr [eax],xmm1", 0x62, 0xf2, 0x7e, 0x08, 0x24, 0x08);
    FCML_I32("vpmovsqw mmword ptr [eax],ymm1", 0x62, 0xf2, 0x7e, 0x28, 0x24, 0x08);
    FCML_I32("vpmovsqw xmmword ptr [eax],zmm1", 0x62, 0xf2, 0x7e, 0x48, 0x24, 0x08);
    FCML_I32("vpmovsqw dword ptr [eax]{k2},xmm1", 0x62, 0xf2, 0x7e, 0x0a, 0x24, 0x08);
    FCML_I32("vpmovsqw mmword ptr [eax]{k3},ymm1", 0x62, 0xf2, 0x7e, 0x2b, 0x24, 0x08);
    FCML_I32("vpmovsqw xmmword ptr [eax]{k4},zmm1", 0x62, 0xf2, 0x7e, 0x4c, 0x24, 0x08);
}

void fcml_tf_instruction_VPMOVUSQW(void) {
    FCML_I32("vpmovusqw xmm0,xmm0", 0x62, 0xf2, 0x7e, 0x08, 0x14, 0xc0);
    FCML_I32("vpmovusqw xmm0,ymm0", 0x62, 0xf2, 0x7e, 0x28, 0x14, 0xc0);
    FCML_I32("vpmovusqw xmm0,zmm0", 0x62, 0xf2, 0x7e, 0x48, 0x14, 0xc0);
    FCML_I32("vpmovusqw xmm0{k1}{z},xmm0", 0x62, 0xf2, 0x7e, 0x89, 0x14, 0xc0);
    FCML_I32("vpmovusqw xmm0{k1}{z},ymm0", 0x62, 0xf2, 0x7e, 0xa9, 0x14, 0xc0);
    FCML_I32("vpmovusqw xmm0{k1}{z},zmm0", 0x62, 0xf2, 0x7e, 0xc9, 0x14, 0xc0);
    FCML_I32("vpmovusqw dword ptr [eax],xmm1", 0x62, 0xf2, 0x7e, 0x08, 0x14, 0x08);
    FCML_I32("vpmovusqw mmword ptr [eax],ymm1", 0x62, 0xf2, 0x7e, 0x28, 0x14, 0x08);
    FCML_I32("vpmovusqw xmmword ptr [eax],zmm1", 0x62, 0xf2, 0x7e, 0x48, 0x14, 0x08);
    FCML_I32("vpmovusqw dword ptr [eax]{k2},xmm1", 0x62, 0xf2, 0x7e, 0x0a, 0x14, 0x08);
    FCML_I32("vpmovusqw mmword ptr [eax]{k3},ymm1", 0x62, 0xf2, 0x7e, 0x2b, 0x14, 0x08);
    FCML_I32("vpmovusqw xmmword ptr [eax]{k4},zmm1", 0x62, 0xf2, 0x7e, 0x4c, 0x14, 0x08);
}

void fcml_tf_instruction_VPMOVWB(void) {
    FCML_I32("vpmovwb xmm0,xmm0", 0x62, 0xf2, 0x7e, 0x08, 0x30, 0xc0);
    FCML_I32("vpmovwb xmm0,ymm0", 0x62, 0xf2, 0x7e, 0x28, 0x30, 0xc0);
    FCML_I32("vpmovwb ymm0,zmm0", 0x62, 0xf2, 0x7e, 0x48, 0x30, 0xc0);
    FCML_I32("vpmovwb xmm0{k1}{z},xmm0", 0x62, 0xf2, 0x7e, 0x89, 0x30, 0xc0);
    FCML_I32("vpmovwb xmm0{k1}{z},ymm0", 0x62, 0xf2, 0x7e, 0xa9, 0x30, 0xc0);
    FCML_I32("vpmovwb ymm0{k1}{z},zmm0", 0x62, 0xf2, 0x7e, 0xc9, 0x30, 0xc0);
    FCML_I32("vpmovwb mmword ptr [eax],xmm1", 0x62, 0xf2, 0x7e, 0x08, 0x30, 0x08);
    FCML_I32("vpmovwb xmmword ptr [eax],ymm1", 0x62, 0xf2, 0x7e, 0x28, 0x30, 0x08);
    FCML_I32("vpmovwb ymmword ptr [eax],zmm1", 0x62, 0xf2, 0x7e, 0x48, 0x30, 0x08);
    FCML_I32("vpmovwb mmword ptr [eax]{k2},xmm1", 0x62, 0xf2, 0x7e, 0x0a, 0x30, 0x08);
    FCML_I32("vpmovwb xmmword ptr [eax]{k3},ymm1", 0x62, 0xf2, 0x7e, 0x2b, 0x30, 0x08);
    FCML_I32("vpmovwb ymmword ptr [eax]{k4},zmm1", 0x62, 0xf2, 0x7e, 0x4c, 0x30, 0x08);
}

void fcml_tf_instruction_VPMOVSWB(void) {
    FCML_I32("vpmovswb xmm0,xmm0", 0x62, 0xf2, 0x7e, 0x08, 0x20, 0xc0);
    FCML_I32("vpmovswb xmm0,ymm0", 0x62, 0xf2, 0x7e, 0x28, 0x20, 0xc0);
    FCML_I32("vpmovswb ymm0,zmm0", 0x62, 0xf2, 0x7e, 0x48, 0x20, 0xc0);
    FCML_I32("vpmovswb xmm0{k1}{z},xmm0", 0x62, 0xf2, 0x7e, 0x89, 0x20, 0xc0);
    FCML_I32("vpmovswb xmm0{k1}{z},ymm0", 0x62, 0xf2, 0x7e, 0xa9, 0x20, 0xc0);
    FCML_I32("vpmovswb ymm0{k1}{z},zmm0", 0x62, 0xf2, 0x7e, 0xc9, 0x20, 0xc0);
    FCML_I32("vpmovswb mmword ptr [eax],xmm1", 0x62, 0xf2, 0x7e, 0x08, 0x20, 0x08);
    FCML_I32("vpmovswb xmmword ptr [eax],ymm1", 0x62, 0xf2, 0x7e, 0x28, 0x20, 0x08);
    FCML_I32("vpmovswb ymmword ptr [eax],zmm1", 0x62, 0xf2, 0x7e, 0x48, 0x20, 0x08);
    FCML_I32("vpmovswb mmword ptr [eax]{k2},xmm1", 0x62, 0xf2, 0x7e, 0x0a, 0x20, 0x08);
    FCML_I32("vpmovswb xmmword ptr [eax]{k3},ymm1", 0x62, 0xf2, 0x7e, 0x2b, 0x20, 0x08);
    FCML_I32("vpmovswb ymmword ptr [eax]{k4},zmm1", 0x62, 0xf2, 0x7e, 0x4c, 0x20, 0x08);
}

void fcml_tf_instruction_VPMOVUSWB(void) {
    FCML_I32("vpmovuswb xmm0,xmm0", 0x62, 0xf2, 0x7e, 0x08, 0x10, 0xc0);
    FCML_I32("vpmovuswb xmm0,ymm0", 0x62, 0xf2, 0x7e, 0x28, 0x10, 0xc0);
    FCML_I32("vpmovuswb ymm0,zmm0", 0x62, 0xf2, 0x7e, 0x48, 0x10, 0xc0);
    FCML_I32("vpmovuswb xmm0{k1}{z},xmm0", 0x62, 0xf2, 0x7e, 0x89, 0x10, 0xc0);
    FCML_I32("vpmovuswb xmm0{k1}{z},ymm0", 0x62, 0xf2, 0x7e, 0xa9, 0x10, 0xc0);
    FCML_I32("vpmovuswb ymm0{k1}{z},zmm0", 0x62, 0xf2, 0x7e, 0xc9, 0x10, 0xc0);
    FCML_I32("vpmovuswb mmword ptr [eax],xmm1", 0x62, 0xf2, 0x7e, 0x08, 0x10, 0x08);
    FCML_I32("vpmovuswb xmmword ptr [eax],ymm1", 0x62, 0xf2, 0x7e, 0x28, 0x10, 0x08);
    FCML_I32("vpmovuswb ymmword ptr [eax],zmm1", 0x62, 0xf2, 0x7e, 0x48, 0x10, 0x08);
    FCML_I32("vpmovuswb mmword ptr [eax]{k2},xmm1", 0x62, 0xf2, 0x7e, 0x0a, 0x10, 0x08);
    FCML_I32("vpmovuswb xmmword ptr [eax]{k3},ymm1", 0x62, 0xf2, 0x7e, 0x2b, 0x10, 0x08);
    FCML_I32("vpmovuswb ymmword ptr [eax]{k4},zmm1", 0x62, 0xf2, 0x7e, 0x4c, 0x10, 0x08);
}

void fcml_tf_instruction_VPMULTISHIFTQB(void) {
    /* xmm1, xmm2, m128 */
    FCML_A64("vpmultishiftqb (%rax),%xmm7,%xmm15", 0x62, 0x72, 0xc5, 0x08, 0x83, 0x38);
    FCML_I64("vpmultishiftqb xmm15,xmm7,xmmword ptr [rax]", 0x62, 0x72, 0xc5, 0x08, 0x83, 0x38);
    FCML_A32("vpmultishiftqb (%eax),%xmm6,%xmm7", 0x62, 0xf2, 0xcd, 0x08, 0x83, 0x38);
    FCML_I32("vpmultishiftqb xmm7,xmm6,xmmword ptr [eax]", 0x62, 0xf2, 0xcd, 0x08, 0x83, 0x38);
    /* ymm1, ymm2, m256 */
    FCML_A64("vpmultishiftqb (%rax),%ymm7,%ymm15", 0x62, 0x72, 0xc5, 0x28, 0x83, 0x38);
    FCML_I64("vpmultishiftqb ymm15,ymm7,ymmword ptr [rax]", 0x62, 0x72, 0xc5, 0x28, 0x83, 0x38);
    FCML_A32("vpmultishiftqb (%eax),%ymm5,%ymm7", 0x62, 0xf2, 0xd5, 0x28, 0x83, 0x38);
    FCML_I32("vpmultishiftqb ymm7,ymm5,ymmword ptr [eax]", 0x62, 0xf2, 0xd5, 0x28, 0x83, 0x38);
    /* zmm1, zmm2, m512 */
    FCML_A64("vpmultishiftqb (%rax),%zmm7,%zmm15", 0x62, 0x72, 0xc5, 0x48, 0x83, 0x38);
    FCML_I64("vpmultishiftqb zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x72, 0xc5, 0x48, 0x83, 0x38);
    FCML_A32("vpmultishiftqb (%eax),%zmm3,%zmm7", 0x62, 0xf2, 0xe5, 0x48, 0x83, 0x38);
    FCML_I32("vpmultishiftqb zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf2, 0xe5, 0x48, 0x83, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64("vpmultishiftqb %xmm1,%xmm7,%xmm15", 0x62, 0x72, 0xc5, 0x08, 0x83, 0xf9);
    FCML_I64("vpmultishiftqb xmm15,xmm7,xmm1", 0x62, 0x72, 0xc5, 0x08, 0x83, 0xf9);
    FCML_A32("vpmultishiftqb %xmm1,%xmm2,%xmm7", 0x62, 0xf2, 0xed, 0x08, 0x83, 0xf9);
    FCML_I32("vpmultishiftqb xmm7,xmm2,xmm1", 0x62, 0xf2, 0xed, 0x08, 0x83, 0xf9);
    /* ymm1, ymm2, ymm3 */
    FCML_A64("vpmultishiftqb %ymm6,%ymm7,%ymm14", 0x62, 0x72, 0xc5, 0x28, 0x83, 0xf6);
    FCML_I64("vpmultishiftqb ymm14,ymm7,ymm6", 0x62, 0x72, 0xc5, 0x28, 0x83, 0xf6);
    FCML_A32("vpmultishiftqb %ymm5,%ymm3,%ymm6", 0x62, 0xf2, 0xe5, 0x28, 0x83, 0xf5);
    FCML_I32("vpmultishiftqb ymm6,ymm3,ymm5", 0x62, 0xf2, 0xe5, 0x28, 0x83, 0xf5);
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpmultishiftqb %zmm4,%zmm15,%zmm6", 0x62, 0xf2, 0x85, 0x48, 0x83, 0xf4);
    FCML_I64("vpmultishiftqb zmm6,zmm15,zmm4", 0x62, 0xf2, 0x85, 0x48, 0x83, 0xf4);
    FCML_A32("vpmultishiftqb %zmm4,%zmm6,%zmm6", 0x62, 0xf2, 0xcd, 0x48, 0x83, 0xf4);
    FCML_I32("vpmultishiftqb zmm6,zmm6,zmm4", 0x62, 0xf2, 0xcd, 0x48, 0x83, 0xf4);
    /* disp8 */
    FCML_I32("vpmultishiftqb zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf2, 0xed, 0x48, 0x83, 0x4c, 0x24, 0x08);
    FCML_A32("vpmultishiftqb 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x48, 0x83, 0x4c, 0x24, 0x08);
    FCML_I64("vpmultishiftqb zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf2, 0xed, 0x48, 0x83, 0x4c, 0x24, 0x08);
    FCML_A64("vpmultishiftqb 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x48, 0x83, 0x4c, 0x24, 0x08);
    FCML_I32("vpmultishiftqb ymm1,ymm2,ymmword ptr [esp+00000100h]", 0x62, 0xf2, 0xed, 0x28, 0x83, 0x4c, 0x24, 0x08);
    FCML_A32("vpmultishiftqb 0x00000100(%esp),%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x28, 0x83, 0x4c, 0x24, 0x08);
    FCML_I64("vpmultishiftqb ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 0x62, 0xf2, 0xed, 0x28, 0x83, 0x4c, 0x24, 0x08);
    FCML_A64("vpmultishiftqb 0x0000000000000100(%rsp),%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x28, 0x83, 0x4c, 0x24, 0x08);
    FCML_I32("vpmultishiftqb xmm1,xmm2,xmmword ptr [esp+00000080h]", 0x62, 0xf2, 0xed, 0x08, 0x83, 0x4c, 0x24, 0x08);
    FCML_A32("vpmultishiftqb 0x00000080(%esp),%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x08, 0x83, 0x4c, 0x24, 0x08);
    FCML_I64("vpmultishiftqb xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 0x62, 0xf2, 0xed, 0x08, 0x83, 0x4c, 0x24, 0x08);
    FCML_A64("vpmultishiftqb 0x0000000000000080(%rsp),%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x08, 0x83, 0x4c, 0x24, 0x08);
    /* {k}{z} */
    FCML_A64("vpmultishiftqb (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x12, 0x8d, 0x8c, 0x83, 0x14, 0x01);
    FCML_I64("vpmultishiftqb xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x8c, 0x83, 0x14, 0x01);
    FCML_A32("vpmultishiftqb (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0x8d, 0x83, 0x14, 0x01);
    FCML_I32("vpmultishiftqb xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x8d, 0x83, 0x14, 0x01);
    FCML_A64("vpmultishiftqb (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x12, 0x8d, 0xac, 0x83, 0x14, 0x01);
    FCML_I64("vpmultishiftqb ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0xac, 0x83, 0x14, 0x01);
    FCML_A32("vpmultishiftqb (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0xad, 0x83, 0x14, 0x01);
    FCML_I32("vpmultishiftqb ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0xad, 0x83, 0x14, 0x01);
    FCML_A64("vpmultishiftqb (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x12, 0x8d, 0xcc, 0x83, 0x14, 0x01);
    FCML_I64("vpmultishiftqb zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0xcc, 0x83, 0x14, 0x01);
    FCML_A32("vpmultishiftqb (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0xcd, 0x83, 0x14, 0x01);
    FCML_I32("vpmultishiftqb zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0xcd, 0x83, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpmultishiftqb (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x12, 0x8d, 0x0c, 0x83, 0x14, 0x01);
    FCML_I64("vpmultishiftqb xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x0c, 0x83, 0x14, 0x01);
    FCML_A32("vpmultishiftqb (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf2, 0xc5, 0x0d, 0x83, 0x14, 0x01);
    FCML_I32("vpmultishiftqb xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x0d, 0x83, 0x14, 0x01);
    FCML_A64("vpmultishiftqb (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x12, 0x8d, 0x2c, 0x83, 0x14, 0x01);
    FCML_I64("vpmultishiftqb ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x2c, 0x83, 0x14, 0x01);
    FCML_A32("vpmultishiftqb (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf2, 0xc5, 0x2d, 0x83, 0x14, 0x01);
    FCML_I32("vpmultishiftqb ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x2d, 0x83, 0x14, 0x01);
    FCML_A64("vpmultishiftqb (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x12, 0x8d, 0x4c, 0x83, 0x14, 0x01);
    FCML_I64("vpmultishiftqb zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x4c, 0x83, 0x14, 0x01);
    FCML_A32("vpmultishiftqb (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf2, 0xc5, 0x4d, 0x83, 0x14, 0x01);
    FCML_I32("vpmultishiftqb zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x4d, 0x83, 0x14, 0x01);
    /* bcast */
    FCML_I64("vpmultishiftqb zmm31,zmm21,mmword ptr [rsi]{1to8}", 0x62, 0x62, 0xd5, 0x50, 0x83, 0x3e);
    FCML_A64("vpmultishiftqb (%rsi){1to8},%zmm21,%zmm31", 0x62, 0x62, 0xd5, 0x50, 0x83, 0x3e);
    FCML_I64("vpmultishiftqb ymm31,ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x62, 0xd5, 0x30, 0x83, 0x3e);
    FCML_A64("vpmultishiftqb (%rsi){1to4},%ymm21,%ymm31", 0x62, 0x62, 0xd5, 0x30, 0x83, 0x3e);
    FCML_I64("vpmultishiftqb xmm31,xmm21,mmword ptr [rsi]{1to2}", 0x62, 0x62, 0xd5, 0x10, 0x83, 0x3e);
    FCML_A64("vpmultishiftqb (%rsi){1to2},%xmm21,%xmm31", 0x62, 0x62, 0xd5, 0x10, 0x83, 0x3e);
    FCML_A32("vpmultishiftqb (%esi){1to8},%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x58, 0x83, 0x0e);
    FCML_I32("vpmultishiftqb zmm1,zmm2,mmword ptr [esi]{1to8}", 0x62, 0xf2, 0xed, 0x58, 0x83, 0x0e);
    /* {k}{z}{bcast} */
    FCML_A64("vpmultishiftqb (%rsi){1to4},%ymm21,%ymm31{%k7}{z}", 0x62, 0x62, 0xd5, 0xb7, 0x83, 0x3e);
    FCML_I64("vpmultishiftqb ymm31{k7}{z},ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x62, 0xd5, 0xb7, 0x83, 0x3e);
    /* {bcast} disp8 */
    FCML_I32("vpmultishiftqb zmm1,zmm2,mmword ptr [esp+00000040h]{1to8}", 0x62, 0xf2, 0xed, 0x58, 0x83, 0x4c, 0x24, 0x08);
    FCML_A32("vpmultishiftqb 0x00000040(%esp){1to8},%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x58, 0x83, 0x4c, 0x24, 0x08);
    FCML_I64("vpmultishiftqb zmm1,zmm2,mmword ptr [rsp+0000000000000040h]{1to8}", 0x62, 0xf2, 0xed, 0x58, 0x83, 0x4c, 0x24, 0x08);
    FCML_A64("vpmultishiftqb 0x0000000000000040(%rsp){1to8},%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x58, 0x83, 0x4c, 0x24, 0x08);
    FCML_I32("vpmultishiftqb ymm1,ymm2,mmword ptr [esp+00000040h]{1to4}", 0x62, 0xf2, 0xed, 0x38, 0x83, 0x4c, 0x24, 0x08);
    FCML_A32("vpmultishiftqb 0x00000040(%esp){1to4},%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x38, 0x83, 0x4c, 0x24, 0x08);
    FCML_I64("vpmultishiftqb ymm1,ymm2,mmword ptr [rsp+0000000000000040h]{1to4}", 0x62, 0xf2, 0xed, 0x38, 0x83, 0x4c, 0x24, 0x08);
    FCML_A64("vpmultishiftqb 0x0000000000000040(%rsp){1to4},%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x38, 0x83, 0x4c, 0x24, 0x08);
    FCML_I32("vpmultishiftqb xmm1,xmm2,mmword ptr [esp+00000040h]{1to2}", 0x62, 0xf2, 0xed, 0x18, 0x83, 0x4c, 0x24, 0x08);
    FCML_A32("vpmultishiftqb 0x00000040(%esp){1to2},%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x18, 0x83, 0x4c, 0x24, 0x08);
    FCML_I64("vpmultishiftqb xmm1,xmm2,mmword ptr [rsp+0000000000000040h]{1to2}", 0x62, 0xf2, 0xed, 0x18, 0x83, 0x4c, 0x24, 0x08);
    FCML_A64("vpmultishiftqb 0x0000000000000040(%rsp){1to2},%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x18, 0x83, 0x4c, 0x24, 0x08);
}

void fcml_tf_instruction_VPROLVD(void) {
    /* xmm1, xmm2, m128 */
    FCML_A64("vprolvd (%rax),%xmm7,%xmm15", 0x62, 0x72, 0x45, 0x08, 0x15, 0x38);
    FCML_I64("vprolvd xmm15,xmm7,xmmword ptr [rax]", 0x62, 0x72, 0x45, 0x08, 0x15, 0x38);
    FCML_A32("vprolvd (%eax),%xmm6,%xmm7", 0x62, 0xf2, 0x4d, 0x08, 0x15, 0x38);
    FCML_I32("vprolvd xmm7,xmm6,xmmword ptr [eax]", 0x62, 0xf2, 0x4d, 0x08, 0x15, 0x38);
    /* ymm1, ymm2, m256 */
    FCML_A64("vprolvd (%rax),%ymm7,%ymm15", 0x62, 0x72, 0x45, 0x28, 0x15, 0x38);
    FCML_I64("vprolvd ymm15,ymm7,ymmword ptr [rax]", 0x62, 0x72, 0x45, 0x28, 0x15, 0x38);
    FCML_A32("vprolvd (%eax),%ymm5,%ymm7", 0x62, 0xf2, 0x55, 0x28, 0x15, 0x38);
    FCML_I32("vprolvd ymm7,ymm5,ymmword ptr [eax]", 0x62, 0xf2, 0x55, 0x28, 0x15, 0x38);
    /* zmm1, zmm2, m512 */
    FCML_A64("vprolvd (%rax),%zmm7,%zmm15", 0x62, 0x72, 0x45, 0x48, 0x15, 0x38);
    FCML_I64("vprolvd zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x72, 0x45, 0x48, 0x15, 0x38);
    FCML_A32("vprolvd (%eax),%zmm3,%zmm7", 0x62, 0xf2, 0x65, 0x48, 0x15, 0x38);
    FCML_I32("vprolvd zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf2, 0x65, 0x48, 0x15, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64("vprolvd %xmm1,%xmm7,%xmm15", 0x62, 0x72, 0x45, 0x08, 0x15, 0xf9);
    FCML_I64("vprolvd xmm15,xmm7,xmm1", 0x62, 0x72, 0x45, 0x08, 0x15, 0xf9);
    FCML_A32("vprolvd %xmm1,%xmm2,%xmm7", 0x62, 0xf2, 0x6d, 0x08, 0x15, 0xf9);
    FCML_I32("vprolvd xmm7,xmm2,xmm1", 0x62, 0xf2, 0x6d, 0x08, 0x15, 0xf9);
    /* ymm1, ymm2, ymm3 */
    FCML_A64("vprolvd %ymm6,%ymm7,%ymm14", 0x62, 0x72, 0x45, 0x28, 0x15, 0xf6);
    FCML_I64("vprolvd ymm14,ymm7,ymm6", 0x62, 0x72, 0x45, 0x28, 0x15, 0xf6);
    FCML_A32("vprolvd %ymm5,%ymm3,%ymm6", 0x62, 0xf2, 0x65, 0x28, 0x15, 0xf5);
    FCML_I32("vprolvd ymm6,ymm3,ymm5", 0x62, 0xf2, 0x65, 0x28, 0x15, 0xf5);
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vprolvd %zmm4,%zmm15,%zmm6", 0x62, 0xf2, 0x05, 0x48, 0x15, 0xf4);
    FCML_I64("vprolvd zmm6,zmm15,zmm4", 0x62, 0xf2, 0x05, 0x48, 0x15, 0xf4);
    FCML_A32("vprolvd %zmm4,%zmm6,%zmm6", 0x62, 0xf2, 0x4d, 0x48, 0x15, 0xf4);
    FCML_I32("vprolvd zmm6,zmm6,zmm4", 0x62, 0xf2, 0x4d, 0x48, 0x15, 0xf4);
    /* disp8 */
    FCML_I32("vprolvd zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf2, 0x6d, 0x48, 0x15, 0x4c, 0x24, 0x08);
    FCML_A32("vprolvd 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x48, 0x15, 0x4c, 0x24, 0x08);
    FCML_I64("vprolvd zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf2, 0x6d, 0x48, 0x15, 0x4c, 0x24, 0x08);
    FCML_A64("vprolvd 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x48, 0x15, 0x4c, 0x24, 0x08);
    FCML_I32("vprolvd ymm1,ymm2,ymmword ptr [esp+00000100h]", 0x62, 0xf2, 0x6d, 0x28, 0x15, 0x4c, 0x24, 0x08);
    FCML_A32("vprolvd 0x00000100(%esp),%ymm2,%ymm1", 0x62, 0xf2, 0x6d, 0x28, 0x15, 0x4c, 0x24, 0x08);
    FCML_I64("vprolvd ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 0x62, 0xf2, 0x6d, 0x28, 0x15, 0x4c, 0x24, 0x08);
    FCML_A64("vprolvd 0x0000000000000100(%rsp),%ymm2,%ymm1", 0x62, 0xf2, 0x6d, 0x28, 0x15, 0x4c, 0x24, 0x08);
    FCML_I32("vprolvd xmm1,xmm2,xmmword ptr [esp+00000080h]", 0x62, 0xf2, 0x6d, 0x08, 0x15, 0x4c, 0x24, 0x08);
    FCML_A32("vprolvd 0x00000080(%esp),%xmm2,%xmm1", 0x62, 0xf2, 0x6d, 0x08, 0x15, 0x4c, 0x24, 0x08);
    FCML_I64("vprolvd xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 0x62, 0xf2, 0x6d, 0x08, 0x15, 0x4c, 0x24, 0x08);
    FCML_A64("vprolvd 0x0000000000000080(%rsp),%xmm2,%xmm1", 0x62, 0xf2, 0x6d, 0x08, 0x15, 0x4c, 0x24, 0x08);
    /* {k}{z} */
    FCML_A64("vprolvd (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x12, 0x0d, 0x8c, 0x15, 0x14, 0x01);
    FCML_I64("vprolvd xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x8c, 0x15, 0x14, 0x01);
    FCML_A32("vprolvd (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf2, 0x45, 0x8d, 0x15, 0x14, 0x01);
    FCML_I32("vprolvd xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x8d, 0x15, 0x14, 0x01);
    FCML_A64("vprolvd (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x12, 0x0d, 0xac, 0x15, 0x14, 0x01);
    FCML_I64("vprolvd ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0xac, 0x15, 0x14, 0x01);
    FCML_A32("vprolvd (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf2, 0x45, 0xad, 0x15, 0x14, 0x01);
    FCML_I32("vprolvd ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0xad, 0x15, 0x14, 0x01);
    FCML_A64("vprolvd (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x12, 0x0d, 0xcc, 0x15, 0x14, 0x01);
    FCML_I64("vprolvd zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0xcc, 0x15, 0x14, 0x01);
    FCML_A32("vprolvd (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf2, 0x45, 0xcd, 0x15, 0x14, 0x01);
    FCML_I32("vprolvd zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0xcd, 0x15, 0x14, 0x01);
    /* {k} */
    FCML_A64("vprolvd (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x12, 0x0d, 0x0c, 0x15, 0x14, 0x01);
    FCML_I64("vprolvd xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x0c, 0x15, 0x14, 0x01);
    FCML_A32("vprolvd (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf2, 0x45, 0x0d, 0x15, 0x14, 0x01);
    FCML_I32("vprolvd xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x0d, 0x15, 0x14, 0x01);
    FCML_A64("vprolvd (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x12, 0x0d, 0x2c, 0x15, 0x14, 0x01);
    FCML_I64("vprolvd ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x2c, 0x15, 0x14, 0x01);
    FCML_A32("vprolvd (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf2, 0x45, 0x2d, 0x15, 0x14, 0x01);
    FCML_I32("vprolvd ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x2d, 0x15, 0x14, 0x01);
    FCML_A64("vprolvd (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x12, 0x0d, 0x4c, 0x15, 0x14, 0x01);
    FCML_I64("vprolvd zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x4c, 0x15, 0x14, 0x01);
    FCML_A32("vprolvd (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf2, 0x45, 0x4d, 0x15, 0x14, 0x01);
    FCML_I32("vprolvd zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x4d, 0x15, 0x14, 0x01);
    /* bcast */
    FCML_I64("vprolvd zmm31,zmm21,dword ptr [rsi]{1to16}", 0x62, 0x62, 0x55, 0x50, 0x15, 0x3e);
    FCML_A64("vprolvd (%rsi){1to16},%zmm21,%zmm31", 0x62, 0x62, 0x55, 0x50, 0x15, 0x3e);
    FCML_I64("vprolvd ymm31,ymm21,dword ptr [rsi]{1to8}", 0x62, 0x62, 0x55, 0x30, 0x15, 0x3e);
    FCML_A64("vprolvd (%rsi){1to8},%ymm21,%ymm31", 0x62, 0x62, 0x55, 0x30, 0x15, 0x3e);
    FCML_I64("vprolvd xmm31,xmm21,dword ptr [rsi]{1to4}", 0x62, 0x62, 0x55, 0x10, 0x15, 0x3e);
    FCML_A64("vprolvd (%rsi){1to4},%xmm21,%xmm31", 0x62, 0x62, 0x55, 0x10, 0x15, 0x3e);
    FCML_A32("vprolvd (%esi){1to16},%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x58, 0x15, 0x0e);
    FCML_I32("vprolvd zmm1,zmm2,dword ptr [esi]{1to16}", 0x62, 0xf2, 0x6d, 0x58, 0x15, 0x0e);
    /* {k}{z}{bcast} */
    FCML_A64("vprolvd (%rsi){1to8},%ymm21,%ymm31{%k7}{z}", 0x62, 0x62, 0x55, 0xb7, 0x15, 0x3e);
    FCML_I64("vprolvd ymm31{k7}{z},ymm21,dword ptr [rsi]{1to8}", 0x62, 0x62, 0x55, 0xb7, 0x15, 0x3e);
    /* {bcast} disp8 */
    FCML_I32("vprolvd zmm1,zmm2,dword ptr [esp+00000020h]{1to16}", 0x62, 0xf2, 0x6d, 0x58, 0x15, 0x4c, 0x24, 0x08);
    FCML_A32("vprolvd 0x00000020(%esp){1to16},%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x58, 0x15, 0x4c, 0x24, 0x08);
    FCML_I64("vprolvd zmm1,zmm2,dword ptr [rsp+0000000000000020h]{1to16}", 0x62, 0xf2, 0x6d, 0x58, 0x15, 0x4c, 0x24, 0x08);
    FCML_A64("vprolvd 0x0000000000000020(%rsp){1to16},%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x58, 0x15, 0x4c, 0x24, 0x08);
    FCML_I32("vprolvd ymm1,ymm2,dword ptr [esp+00000020h]{1to8}", 0x62, 0xf2, 0x6d, 0x38, 0x15, 0x4c, 0x24, 0x08);
    FCML_A32("vprolvd 0x00000020(%esp){1to8},%ymm2,%ymm1", 0x62, 0xf2, 0x6d, 0x38, 0x15, 0x4c, 0x24, 0x08);
    FCML_I64("vprolvd ymm1,ymm2,dword ptr [rsp+0000000000000020h]{1to8}", 0x62, 0xf2, 0x6d, 0x38, 0x15, 0x4c, 0x24, 0x08);
    FCML_A64("vprolvd 0x0000000000000020(%rsp){1to8},%ymm2,%ymm1", 0x62, 0xf2, 0x6d, 0x38, 0x15, 0x4c, 0x24, 0x08);
    FCML_I32("vprolvd xmm1,xmm2,dword ptr [esp+00000020h]{1to4}", 0x62, 0xf2, 0x6d, 0x18, 0x15, 0x4c, 0x24, 0x08);
    FCML_A32("vprolvd 0x00000020(%esp){1to4},%xmm2,%xmm1", 0x62, 0xf2, 0x6d, 0x18, 0x15, 0x4c, 0x24, 0x08);
    FCML_I64("vprolvd xmm1,xmm2,dword ptr [rsp+0000000000000020h]{1to4}", 0x62, 0xf2, 0x6d, 0x18, 0x15, 0x4c, 0x24, 0x08);
    FCML_A64("vprolvd 0x0000000000000020(%rsp){1to4},%xmm2,%xmm1", 0x62, 0xf2, 0x6d, 0x18, 0x15, 0x4c, 0x24, 0x08);
}

void fcml_tf_instruction_VPROLVQ(void) {
    /* xmm1, xmm2, m128 */
    FCML_A64("vprolvq (%rax),%xmm7,%xmm15", 0x62, 0x72, 0xc5, 0x08, 0x15, 0x38);
    FCML_I64("vprolvq xmm15,xmm7,xmmword ptr [rax]", 0x62, 0x72, 0xc5, 0x08, 0x15, 0x38);
    FCML_A32("vprolvq (%eax),%xmm6,%xmm7", 0x62, 0xf2, 0xcd, 0x08, 0x15, 0x38);
    FCML_I32("vprolvq xmm7,xmm6,xmmword ptr [eax]", 0x62, 0xf2, 0xcd, 0x08, 0x15, 0x38);
    /* ymm1, ymm2, m256 */
    FCML_A64("vprolvq (%rax),%ymm7,%ymm15", 0x62, 0x72, 0xc5, 0x28, 0x15, 0x38);
    FCML_I64("vprolvq ymm15,ymm7,ymmword ptr [rax]", 0x62, 0x72, 0xc5, 0x28, 0x15, 0x38);
    FCML_A32("vprolvq (%eax),%ymm5,%ymm7", 0x62, 0xf2, 0xd5, 0x28, 0x15, 0x38);
    FCML_I32("vprolvq ymm7,ymm5,ymmword ptr [eax]", 0x62, 0xf2, 0xd5, 0x28, 0x15, 0x38);
    /* zmm1, zmm2, m512 */
    FCML_A64("vprolvq (%rax),%zmm7,%zmm15", 0x62, 0x72, 0xc5, 0x48, 0x15, 0x38);
    FCML_I64("vprolvq zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x72, 0xc5, 0x48, 0x15, 0x38);
    FCML_A32("vprolvq (%eax),%zmm3,%zmm7", 0x62, 0xf2, 0xe5, 0x48, 0x15, 0x38);
    FCML_I32("vprolvq zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf2, 0xe5, 0x48, 0x15, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64("vprolvq %xmm1,%xmm7,%xmm15", 0x62, 0x72, 0xc5, 0x08, 0x15, 0xf9);
    FCML_I64("vprolvq xmm15,xmm7,xmm1", 0x62, 0x72, 0xc5, 0x08, 0x15, 0xf9);
    FCML_A32("vprolvq %xmm1,%xmm2,%xmm7", 0x62, 0xf2, 0xed, 0x08, 0x15, 0xf9);
    FCML_I32("vprolvq xmm7,xmm2,xmm1", 0x62, 0xf2, 0xed, 0x08, 0x15, 0xf9);
    /* ymm1, ymm2, ymm3 */
    FCML_A64("vprolvq %ymm6,%ymm7,%ymm14", 0x62, 0x72, 0xc5, 0x28, 0x15, 0xf6);
    FCML_I64("vprolvq ymm14,ymm7,ymm6", 0x62, 0x72, 0xc5, 0x28, 0x15, 0xf6);
    FCML_A32("vprolvq %ymm5,%ymm3,%ymm6", 0x62, 0xf2, 0xe5, 0x28, 0x15, 0xf5);
    FCML_I32("vprolvq ymm6,ymm3,ymm5", 0x62, 0xf2, 0xe5, 0x28, 0x15, 0xf5);
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vprolvq %zmm4,%zmm15,%zmm6", 0x62, 0xf2, 0x85, 0x48, 0x15, 0xf4);
    FCML_I64("vprolvq zmm6,zmm15,zmm4", 0x62, 0xf2, 0x85, 0x48, 0x15, 0xf4);
    FCML_A32("vprolvq %zmm4,%zmm6,%zmm6", 0x62, 0xf2, 0xcd, 0x48, 0x15, 0xf4);
    FCML_I32("vprolvq zmm6,zmm6,zmm4", 0x62, 0xf2, 0xcd, 0x48, 0x15, 0xf4);
    /* disp8 */
    FCML_I32("vprolvq zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf2, 0xed, 0x48, 0x15, 0x4c, 0x24, 0x08);
    FCML_A32("vprolvq 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x48, 0x15, 0x4c, 0x24, 0x08);
    FCML_I64("vprolvq zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf2, 0xed, 0x48, 0x15, 0x4c, 0x24, 0x08);
    FCML_A64("vprolvq 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x48, 0x15, 0x4c, 0x24, 0x08);
    FCML_I32("vprolvq ymm1,ymm2,ymmword ptr [esp+00000100h]", 0x62, 0xf2, 0xed, 0x28, 0x15, 0x4c, 0x24, 0x08);
    FCML_A32("vprolvq 0x00000100(%esp),%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x28, 0x15, 0x4c, 0x24, 0x08);
    FCML_I64("vprolvq ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 0x62, 0xf2, 0xed, 0x28, 0x15, 0x4c, 0x24, 0x08);
    FCML_A64("vprolvq 0x0000000000000100(%rsp),%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x28, 0x15, 0x4c, 0x24, 0x08);
    FCML_I32("vprolvq xmm1,xmm2,xmmword ptr [esp+00000080h]", 0x62, 0xf2, 0xed, 0x08, 0x15, 0x4c, 0x24, 0x08);
    FCML_A32("vprolvq 0x00000080(%esp),%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x08, 0x15, 0x4c, 0x24, 0x08);
    FCML_I64("vprolvq xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 0x62, 0xf2, 0xed, 0x08, 0x15, 0x4c, 0x24, 0x08);
    FCML_A64("vprolvq 0x0000000000000080(%rsp),%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x08, 0x15, 0x4c, 0x24, 0x08);
    /* {k}{z} */
    FCML_A64("vprolvq (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x12, 0x8d, 0x8c, 0x15, 0x14, 0x01);
    FCML_I64("vprolvq xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x8c, 0x15, 0x14, 0x01);
    FCML_A32("vprolvq (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0x8d, 0x15, 0x14, 0x01);
    FCML_I32("vprolvq xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x8d, 0x15, 0x14, 0x01);
    FCML_A64("vprolvq (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x12, 0x8d, 0xac, 0x15, 0x14, 0x01);
    FCML_I64("vprolvq ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0xac, 0x15, 0x14, 0x01);
    FCML_A32("vprolvq (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0xad, 0x15, 0x14, 0x01);
    FCML_I32("vprolvq ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0xad, 0x15, 0x14, 0x01);
    FCML_A64("vprolvq (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x12, 0x8d, 0xcc, 0x15, 0x14, 0x01);
    FCML_I64("vprolvq zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0xcc, 0x15, 0x14, 0x01);
    FCML_A32("vprolvq (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0xcd, 0x15, 0x14, 0x01);
    FCML_I32("vprolvq zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0xcd, 0x15, 0x14, 0x01);
    /* {k} */
    FCML_A64("vprolvq (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x12, 0x8d, 0x0c, 0x15, 0x14, 0x01);
    FCML_I64("vprolvq xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x0c, 0x15, 0x14, 0x01);
    FCML_A32("vprolvq (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf2, 0xc5, 0x0d, 0x15, 0x14, 0x01);
    FCML_I32("vprolvq xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x0d, 0x15, 0x14, 0x01);
    FCML_A64("vprolvq (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x12, 0x8d, 0x2c, 0x15, 0x14, 0x01);
    FCML_I64("vprolvq ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x2c, 0x15, 0x14, 0x01);
    FCML_A32("vprolvq (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf2, 0xc5, 0x2d, 0x15, 0x14, 0x01);
    FCML_I32("vprolvq ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x2d, 0x15, 0x14, 0x01);
    FCML_A64("vprolvq (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x12, 0x8d, 0x4c, 0x15, 0x14, 0x01);
    FCML_I64("vprolvq zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x4c, 0x15, 0x14, 0x01);
    FCML_A32("vprolvq (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf2, 0xc5, 0x4d, 0x15, 0x14, 0x01);
    FCML_I32("vprolvq zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x4d, 0x15, 0x14, 0x01);
    /* bcast */
    FCML_I64("vprolvq zmm31,zmm21,mmword ptr [rsi]{1to8}", 0x62, 0x62, 0xd5, 0x50, 0x15, 0x3e);
    FCML_A64("vprolvq (%rsi){1to8},%zmm21,%zmm31", 0x62, 0x62, 0xd5, 0x50, 0x15, 0x3e);
    FCML_I64("vprolvq ymm31,ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x62, 0xd5, 0x30, 0x15, 0x3e);
    FCML_A64("vprolvq (%rsi){1to4},%ymm21,%ymm31", 0x62, 0x62, 0xd5, 0x30, 0x15, 0x3e);
    FCML_I64("vprolvq xmm31,xmm21,mmword ptr [rsi]{1to2}", 0x62, 0x62, 0xd5, 0x10, 0x15, 0x3e);
    FCML_A64("vprolvq (%rsi){1to2},%xmm21,%xmm31", 0x62, 0x62, 0xd5, 0x10, 0x15, 0x3e);
    FCML_A32("vprolvq (%esi){1to8},%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x58, 0x15, 0x0e);
    FCML_I32("vprolvq zmm1,zmm2,mmword ptr [esi]{1to8}", 0x62, 0xf2, 0xed, 0x58, 0x15, 0x0e);
    /* {k}{z}{bcast} */
    FCML_A64("vprolvq (%rsi){1to4},%ymm21,%ymm31{%k7}{z}", 0x62, 0x62, 0xd5, 0xb7, 0x15, 0x3e);
    FCML_I64("vprolvq ymm31{k7}{z},ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x62, 0xd5, 0xb7, 0x15, 0x3e);
    /* {bcast} disp8 */
    FCML_I32("vprolvq zmm1,zmm2,mmword ptr [esp+00000040h]{1to8}", 0x62, 0xf2, 0xed, 0x58, 0x15, 0x4c, 0x24, 0x08);
    FCML_A32("vprolvq 0x00000040(%esp){1to8},%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x58, 0x15, 0x4c, 0x24, 0x08);
    FCML_I64("vprolvq zmm1,zmm2,mmword ptr [rsp+0000000000000040h]{1to8}", 0x62, 0xf2, 0xed, 0x58, 0x15, 0x4c, 0x24, 0x08);
    FCML_A64("vprolvq 0x0000000000000040(%rsp){1to8},%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x58, 0x15, 0x4c, 0x24, 0x08);
    FCML_I32("vprolvq ymm1,ymm2,mmword ptr [esp+00000040h]{1to4}", 0x62, 0xf2, 0xed, 0x38, 0x15, 0x4c, 0x24, 0x08);
    FCML_A32("vprolvq 0x00000040(%esp){1to4},%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x38, 0x15, 0x4c, 0x24, 0x08);
    FCML_I64("vprolvq ymm1,ymm2,mmword ptr [rsp+0000000000000040h]{1to4}", 0x62, 0xf2, 0xed, 0x38, 0x15, 0x4c, 0x24, 0x08);
    FCML_A64("vprolvq 0x0000000000000040(%rsp){1to4},%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x38, 0x15, 0x4c, 0x24, 0x08);
    FCML_I32("vprolvq xmm1,xmm2,mmword ptr [esp+00000040h]{1to2}", 0x62, 0xf2, 0xed, 0x18, 0x15, 0x4c, 0x24, 0x08);
    FCML_A32("vprolvq 0x00000040(%esp){1to2},%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x18, 0x15, 0x4c, 0x24, 0x08);
    FCML_I64("vprolvq xmm1,xmm2,mmword ptr [rsp+0000000000000040h]{1to2}", 0x62, 0xf2, 0xed, 0x18, 0x15, 0x4c, 0x24, 0x08);
    FCML_A64("vprolvq 0x0000000000000040(%rsp){1to2},%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x18, 0x15, 0x4c, 0x24, 0x08);
}

void fcml_tf_instruction_VPROLD(void) {
    FCML_I64("vprold xmm2,xmmword ptr [rax],01h", 0x62, 0xf1, 0x6d, 0x08, 0x72, 0x08, 0x01);
    FCML_I64("vprold ymm3,ymmword ptr [rax],02h", 0x62, 0xf1, 0x65, 0x28, 0x72, 0x08, 0x02);
    FCML_I64("vprold zmm3,zmmword ptr [rax],03h", 0x62, 0xf1, 0x65, 0x48, 0x72, 0x08, 0x03);
    FCML_I64("vprold xmm1,dword ptr [rsp+0000000000000040h]{1to4},01h", 0x62, 0xf1, 0x75, 0x18, 0x72, 0x4c, 0x24, 0x10, 0x01);
    FCML_I64("vprold ymm2,dword ptr [rsp+0000000000000040h]{1to8},02h", 0x62, 0xf1, 0x6d, 0x38, 0x72, 0x4c, 0x24, 0x10, 0x02);
    FCML_I64("vprold zmm4,dword ptr [rsp+0000000000000040h]{1to16},03h", 0x62, 0xf1, 0x5d, 0x58, 0x72, 0x4c, 0x24, 0x10, 0x03);
    FCML_I64("vprold xmm1{k1},xmmword ptr [rax],01h", 0x62, 0xf1, 0x75, 0x09, 0x72, 0x08, 0x01);
    FCML_I64("vprold ymm4{k7},ymmword ptr [rax],02h", 0x62, 0xf1, 0x5d, 0x2f, 0x72, 0x08, 0x02);
    FCML_I64("vprold zmm6{k4},zmmword ptr [rax],03h", 0x62, 0xf1, 0x4d, 0x4c, 0x72, 0x08, 0x03);
    FCML_I64("vprold xmm1,xmm6,01h", 0x62, 0xf1, 0x75, 0x08, 0x72, 0xce, 0x01);
    FCML_I64("vprold ymm1,ymm21,02h", 0x62, 0xb1, 0x75, 0x28, 0x72, 0xcd, 0x02);
    FCML_I64("vprold zmm1,zmm7,03h", 0x62, 0xf1, 0x75, 0x48, 0x72, 0xcf, 0x03);
    FCML_I64("vprold xmm1{k3}{z},xmm6,01h", 0x62, 0xf1, 0x75, 0x8b, 0x72, 0xce, 0x01);
    FCML_I64("vprold ymm1{k1}{z},ymm21,02h", 0x62, 0xb1, 0x75, 0xa9, 0x72, 0xcd, 0x02);
    FCML_I64("vprold zmm1{k6}{z},zmm7,03h", 0x62, 0xf1, 0x75, 0xce, 0x72, 0xcf, 0x03);
    FCML_A32("vprold $0x03,(%eax),%zmm3", 0x62, 0xf1, 0x65, 0x48, 0x72, 0x08, 0x03);
    FCML_A32("vprold $0x02,0x00000040(%esp){1to8},%ymm2", 0x62, 0xf1, 0x6d, 0x38, 0x72, 0x4c, 0x24, 0x10, 0x02);
}

void fcml_tf_instruction_VPROLQ(void) {
    FCML_I64("vprolq xmm2,xmmword ptr [rax],01h", 0x62, 0xf1, 0xed, 0x08, 0x72, 0x08, 0x01);
    FCML_I64("vprolq ymm3,ymmword ptr [rax],02h", 0x62, 0xf1, 0xe5, 0x28, 0x72, 0x08, 0x02);
    FCML_I64("vprolq zmm3,zmmword ptr [rax],03h", 0x62, 0xf1, 0xe5, 0x48, 0x72, 0x08, 0x03);
    FCML_I64("vprolq xmm1,mmword ptr [rsp+0000000000000040h]{1to2},01h", 0x62, 0xf1, 0xf5, 0x18, 0x72, 0x4c, 0x24, 0x08, 0x01);
    FCML_I64("vprolq ymm2,mmword ptr [rsp+0000000000000040h]{1to4},02h", 0x62, 0xf1, 0xed, 0x38, 0x72, 0x4c, 0x24, 0x08, 0x02);
    FCML_I64("vprolq zmm4,mmword ptr [rsp+0000000000000040h]{1to8},03h", 0x62, 0xf1, 0xdd, 0x58, 0x72, 0x4c, 0x24, 0x08, 0x03);
    FCML_I64("vprolq xmm1{k1},xmmword ptr [rax],01h", 0x62, 0xf1, 0xf5, 0x09, 0x72, 0x08, 0x01);
    FCML_I64("vprolq ymm4{k7},ymmword ptr [rax],02h", 0x62, 0xf1, 0xdd, 0x2f, 0x72, 0x08, 0x02);
    FCML_I64("vprolq zmm6{k4},zmmword ptr [rax],03h", 0x62, 0xf1, 0xcd, 0x4c, 0x72, 0x08, 0x03);
    FCML_I64("vprolq xmm1,xmm6,01h", 0x62, 0xf1, 0xf5, 0x08, 0x72, 0xce, 0x01);
    FCML_I64("vprolq ymm1,ymm21,02h", 0x62, 0xb1, 0xf5, 0x28, 0x72, 0xcd, 0x02);
    FCML_I64("vprolq zmm1,zmm7,03h", 0x62, 0xf1, 0xf5, 0x48, 0x72, 0xcf, 0x03);
    FCML_I64("vprolq xmm1{k3}{z},xmm6,01h", 0x62, 0xf1, 0xf5, 0x8b, 0x72, 0xce, 0x01);
    FCML_I64("vprolq ymm1{k1}{z},ymm21,02h", 0x62, 0xb1, 0xf5, 0xa9, 0x72, 0xcd, 0x02);
    FCML_I64("vprolq zmm1{k6}{z},zmm7,03h", 0x62, 0xf1, 0xf5, 0xce, 0x72, 0xcf, 0x03);
    FCML_A32("vprolq $0x03,(%eax),%zmm3", 0x62, 0xf1, 0xe5, 0x48, 0x72, 0x08, 0x03);
    FCML_A32("vprolq $0x02,0x00000040(%esp){1to4},%ymm2", 0x62, 0xf1, 0xed, 0x38, 0x72, 0x4c, 0x24, 0x08, 0x02);
}

void fcml_tf_instruction_VPRORVD(void) {
    /* xmm1, xmm2, m128 */
    FCML_A64("vprorvd (%rax),%xmm7,%xmm15", 0x62, 0x72, 0x45, 0x08, 0x14, 0x38);
    FCML_I64("vprorvd xmm15,xmm7,xmmword ptr [rax]", 0x62, 0x72, 0x45, 0x08, 0x14, 0x38);
    FCML_A32("vprorvd (%eax),%xmm6,%xmm7", 0x62, 0xf2, 0x4d, 0x08, 0x14, 0x38);
    FCML_I32("vprorvd xmm7,xmm6,xmmword ptr [eax]", 0x62, 0xf2, 0x4d, 0x08, 0x14, 0x38);
    /* ymm1, ymm2, m256 */
    FCML_A64("vprorvd (%rax),%ymm7,%ymm15", 0x62, 0x72, 0x45, 0x28, 0x14, 0x38);
    FCML_I64("vprorvd ymm15,ymm7,ymmword ptr [rax]", 0x62, 0x72, 0x45, 0x28, 0x14, 0x38);
    FCML_A32("vprorvd (%eax),%ymm5,%ymm7", 0x62, 0xf2, 0x55, 0x28, 0x14, 0x38);
    FCML_I32("vprorvd ymm7,ymm5,ymmword ptr [eax]", 0x62, 0xf2, 0x55, 0x28, 0x14, 0x38);
    /* zmm1, zmm2, m512 */
    FCML_A64("vprorvd (%rax),%zmm7,%zmm15", 0x62, 0x72, 0x45, 0x48, 0x14, 0x38);
    FCML_I64("vprorvd zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x72, 0x45, 0x48, 0x14, 0x38);
    FCML_A32("vprorvd (%eax),%zmm3,%zmm7", 0x62, 0xf2, 0x65, 0x48, 0x14, 0x38);
    FCML_I32("vprorvd zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf2, 0x65, 0x48, 0x14, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64("vprorvd %xmm1,%xmm7,%xmm15", 0x62, 0x72, 0x45, 0x08, 0x14, 0xf9);
    FCML_I64("vprorvd xmm15,xmm7,xmm1", 0x62, 0x72, 0x45, 0x08, 0x14, 0xf9);
    FCML_A32("vprorvd %xmm1,%xmm2,%xmm7", 0x62, 0xf2, 0x6d, 0x08, 0x14, 0xf9);
    FCML_I32("vprorvd xmm7,xmm2,xmm1", 0x62, 0xf2, 0x6d, 0x08, 0x14, 0xf9);
    /* ymm1, ymm2, ymm3 */
    FCML_A64("vprorvd %ymm6,%ymm7,%ymm14", 0x62, 0x72, 0x45, 0x28, 0x14, 0xf6);
    FCML_I64("vprorvd ymm14,ymm7,ymm6", 0x62, 0x72, 0x45, 0x28, 0x14, 0xf6);
    FCML_A32("vprorvd %ymm5,%ymm3,%ymm6", 0x62, 0xf2, 0x65, 0x28, 0x14, 0xf5);
    FCML_I32("vprorvd ymm6,ymm3,ymm5", 0x62, 0xf2, 0x65, 0x28, 0x14, 0xf5);
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vprorvd %zmm4,%zmm15,%zmm6", 0x62, 0xf2, 0x05, 0x48, 0x14, 0xf4);
    FCML_I64("vprorvd zmm6,zmm15,zmm4", 0x62, 0xf2, 0x05, 0x48, 0x14, 0xf4);
    FCML_A32("vprorvd %zmm4,%zmm6,%zmm6", 0x62, 0xf2, 0x4d, 0x48, 0x14, 0xf4);
    FCML_I32("vprorvd zmm6,zmm6,zmm4", 0x62, 0xf2, 0x4d, 0x48, 0x14, 0xf4);
    /* disp8 */
    FCML_I32("vprorvd zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf2, 0x6d, 0x48, 0x14, 0x4c, 0x24, 0x08);
    FCML_A32("vprorvd 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x48, 0x14, 0x4c, 0x24, 0x08);
    FCML_I64("vprorvd zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf2, 0x6d, 0x48, 0x14, 0x4c, 0x24, 0x08);
    FCML_A64("vprorvd 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x48, 0x14, 0x4c, 0x24, 0x08);
    FCML_I32("vprorvd ymm1,ymm2,ymmword ptr [esp+00000100h]", 0x62, 0xf2, 0x6d, 0x28, 0x14, 0x4c, 0x24, 0x08);
    FCML_A32("vprorvd 0x00000100(%esp),%ymm2,%ymm1", 0x62, 0xf2, 0x6d, 0x28, 0x14, 0x4c, 0x24, 0x08);
    FCML_I64("vprorvd ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 0x62, 0xf2, 0x6d, 0x28, 0x14, 0x4c, 0x24, 0x08);
    FCML_A64("vprorvd 0x0000000000000100(%rsp),%ymm2,%ymm1", 0x62, 0xf2, 0x6d, 0x28, 0x14, 0x4c, 0x24, 0x08);
    FCML_I32("vprorvd xmm1,xmm2,xmmword ptr [esp+00000080h]", 0x62, 0xf2, 0x6d, 0x08, 0x14, 0x4c, 0x24, 0x08);
    FCML_A32("vprorvd 0x00000080(%esp),%xmm2,%xmm1", 0x62, 0xf2, 0x6d, 0x08, 0x14, 0x4c, 0x24, 0x08);
    FCML_I64("vprorvd xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 0x62, 0xf2, 0x6d, 0x08, 0x14, 0x4c, 0x24, 0x08);
    FCML_A64("vprorvd 0x0000000000000080(%rsp),%xmm2,%xmm1", 0x62, 0xf2, 0x6d, 0x08, 0x14, 0x4c, 0x24, 0x08);
    /* {k}{z} */
    FCML_A64("vprorvd (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x12, 0x0d, 0x8c, 0x14, 0x14, 0x01);
    FCML_I64("vprorvd xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x8c, 0x14, 0x14, 0x01);
    FCML_A32("vprorvd (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf2, 0x45, 0x8d, 0x14, 0x14, 0x01);
    FCML_I32("vprorvd xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x8d, 0x14, 0x14, 0x01);
    FCML_A64("vprorvd (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x12, 0x0d, 0xac, 0x14, 0x14, 0x01);
    FCML_I64("vprorvd ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0xac, 0x14, 0x14, 0x01);
    FCML_A32("vprorvd (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf2, 0x45, 0xad, 0x14, 0x14, 0x01);
    FCML_I32("vprorvd ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0xad, 0x14, 0x14, 0x01);
    FCML_A64("vprorvd (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x12, 0x0d, 0xcc, 0x14, 0x14, 0x01);
    FCML_I64("vprorvd zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0xcc, 0x14, 0x14, 0x01);
    FCML_A32("vprorvd (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf2, 0x45, 0xcd, 0x14, 0x14, 0x01);
    FCML_I32("vprorvd zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0xcd, 0x14, 0x14, 0x01);
    /* {k} */
    FCML_A64("vprorvd (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x12, 0x0d, 0x0c, 0x14, 0x14, 0x01);
    FCML_I64("vprorvd xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x0c, 0x14, 0x14, 0x01);
    FCML_A32("vprorvd (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf2, 0x45, 0x0d, 0x14, 0x14, 0x01);
    FCML_I32("vprorvd xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x0d, 0x14, 0x14, 0x01);
    FCML_A64("vprorvd (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x12, 0x0d, 0x2c, 0x14, 0x14, 0x01);
    FCML_I64("vprorvd ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x2c, 0x14, 0x14, 0x01);
    FCML_A32("vprorvd (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf2, 0x45, 0x2d, 0x14, 0x14, 0x01);
    FCML_I32("vprorvd ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x2d, 0x14, 0x14, 0x01);
    FCML_A64("vprorvd (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x12, 0x0d, 0x4c, 0x14, 0x14, 0x01);
    FCML_I64("vprorvd zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x4c, 0x14, 0x14, 0x01);
    FCML_A32("vprorvd (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf2, 0x45, 0x4d, 0x14, 0x14, 0x01);
    FCML_I32("vprorvd zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x4d, 0x14, 0x14, 0x01);
    /* bcast */
    FCML_I64("vprorvd zmm31,zmm21,dword ptr [rsi]{1to16}", 0x62, 0x62, 0x55, 0x50, 0x14, 0x3e);
    FCML_A64("vprorvd (%rsi){1to16},%zmm21,%zmm31", 0x62, 0x62, 0x55, 0x50, 0x14, 0x3e);
    FCML_I64("vprorvd ymm31,ymm21,dword ptr [rsi]{1to8}", 0x62, 0x62, 0x55, 0x30, 0x14, 0x3e);
    FCML_A64("vprorvd (%rsi){1to8},%ymm21,%ymm31", 0x62, 0x62, 0x55, 0x30, 0x14, 0x3e);
    FCML_I64("vprorvd xmm31,xmm21,dword ptr [rsi]{1to4}", 0x62, 0x62, 0x55, 0x10, 0x14, 0x3e);
    FCML_A64("vprorvd (%rsi){1to4},%xmm21,%xmm31", 0x62, 0x62, 0x55, 0x10, 0x14, 0x3e);
    FCML_A32("vprorvd (%esi){1to16},%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x58, 0x14, 0x0e);
    FCML_I32("vprorvd zmm1,zmm2,dword ptr [esi]{1to16}", 0x62, 0xf2, 0x6d, 0x58, 0x14, 0x0e);
    /* {k}{z}{bcast} */
    FCML_A64("vprorvd (%rsi){1to8},%ymm21,%ymm31{%k7}{z}", 0x62, 0x62, 0x55, 0xb7, 0x14, 0x3e);
    FCML_I64("vprorvd ymm31{k7}{z},ymm21,dword ptr [rsi]{1to8}", 0x62, 0x62, 0x55, 0xb7, 0x14, 0x3e);
    /* {bcast} disp8 */
    FCML_I32("vprorvd zmm1,zmm2,dword ptr [esp+00000020h]{1to16}", 0x62, 0xf2, 0x6d, 0x58, 0x14, 0x4c, 0x24, 0x08);
    FCML_A32("vprorvd 0x00000020(%esp){1to16},%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x58, 0x14, 0x4c, 0x24, 0x08);
    FCML_I64("vprorvd zmm1,zmm2,dword ptr [rsp+0000000000000020h]{1to16}", 0x62, 0xf2, 0x6d, 0x58, 0x14, 0x4c, 0x24, 0x08);
    FCML_A64("vprorvd 0x0000000000000020(%rsp){1to16},%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x58, 0x14, 0x4c, 0x24, 0x08);
    FCML_I32("vprorvd ymm1,ymm2,dword ptr [esp+00000020h]{1to8}", 0x62, 0xf2, 0x6d, 0x38, 0x14, 0x4c, 0x24, 0x08);
    FCML_A32("vprorvd 0x00000020(%esp){1to8},%ymm2,%ymm1", 0x62, 0xf2, 0x6d, 0x38, 0x14, 0x4c, 0x24, 0x08);
    FCML_I64("vprorvd ymm1,ymm2,dword ptr [rsp+0000000000000020h]{1to8}", 0x62, 0xf2, 0x6d, 0x38, 0x14, 0x4c, 0x24, 0x08);
    FCML_A64("vprorvd 0x0000000000000020(%rsp){1to8},%ymm2,%ymm1", 0x62, 0xf2, 0x6d, 0x38, 0x14, 0x4c, 0x24, 0x08);
    FCML_I32("vprorvd xmm1,xmm2,dword ptr [esp+00000020h]{1to4}", 0x62, 0xf2, 0x6d, 0x18, 0x14, 0x4c, 0x24, 0x08);
    FCML_A32("vprorvd 0x00000020(%esp){1to4},%xmm2,%xmm1", 0x62, 0xf2, 0x6d, 0x18, 0x14, 0x4c, 0x24, 0x08);
    FCML_I64("vprorvd xmm1,xmm2,dword ptr [rsp+0000000000000020h]{1to4}", 0x62, 0xf2, 0x6d, 0x18, 0x14, 0x4c, 0x24, 0x08);
    FCML_A64("vprorvd 0x0000000000000020(%rsp){1to4},%xmm2,%xmm1", 0x62, 0xf2, 0x6d, 0x18, 0x14, 0x4c, 0x24, 0x08);
}

void fcml_tf_instruction_VPRORVQ(void) {
    /* xmm1, xmm2, m128 */
    FCML_A64("vprorvq (%rax),%xmm7,%xmm15", 0x62, 0x72, 0xc5, 0x08, 0x14, 0x38);
    FCML_I64("vprorvq xmm15,xmm7,xmmword ptr [rax]", 0x62, 0x72, 0xc5, 0x08, 0x14, 0x38);
    FCML_A32("vprorvq (%eax),%xmm6,%xmm7", 0x62, 0xf2, 0xcd, 0x08, 0x14, 0x38);
    FCML_I32("vprorvq xmm7,xmm6,xmmword ptr [eax]", 0x62, 0xf2, 0xcd, 0x08, 0x14, 0x38);
    /* ymm1, ymm2, m256 */
    FCML_A64("vprorvq (%rax),%ymm7,%ymm15", 0x62, 0x72, 0xc5, 0x28, 0x14, 0x38);
    FCML_I64("vprorvq ymm15,ymm7,ymmword ptr [rax]", 0x62, 0x72, 0xc5, 0x28, 0x14, 0x38);
    FCML_A32("vprorvq (%eax),%ymm5,%ymm7", 0x62, 0xf2, 0xd5, 0x28, 0x14, 0x38);
    FCML_I32("vprorvq ymm7,ymm5,ymmword ptr [eax]", 0x62, 0xf2, 0xd5, 0x28, 0x14, 0x38);
    /* zmm1, zmm2, m512 */
    FCML_A64("vprorvq (%rax),%zmm7,%zmm15", 0x62, 0x72, 0xc5, 0x48, 0x14, 0x38);
    FCML_I64("vprorvq zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x72, 0xc5, 0x48, 0x14, 0x38);
    FCML_A32("vprorvq (%eax),%zmm3,%zmm7", 0x62, 0xf2, 0xe5, 0x48, 0x14, 0x38);
    FCML_I32("vprorvq zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf2, 0xe5, 0x48, 0x14, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64("vprorvq %xmm1,%xmm7,%xmm15", 0x62, 0x72, 0xc5, 0x08, 0x14, 0xf9);
    FCML_I64("vprorvq xmm15,xmm7,xmm1", 0x62, 0x72, 0xc5, 0x08, 0x14, 0xf9);
    FCML_A32("vprorvq %xmm1,%xmm2,%xmm7", 0x62, 0xf2, 0xed, 0x08, 0x14, 0xf9);
    FCML_I32("vprorvq xmm7,xmm2,xmm1", 0x62, 0xf2, 0xed, 0x08, 0x14, 0xf9);
    /* ymm1, ymm2, ymm3 */
    FCML_A64("vprorvq %ymm6,%ymm7,%ymm14", 0x62, 0x72, 0xc5, 0x28, 0x14, 0xf6);
    FCML_I64("vprorvq ymm14,ymm7,ymm6", 0x62, 0x72, 0xc5, 0x28, 0x14, 0xf6);
    FCML_A32("vprorvq %ymm5,%ymm3,%ymm6", 0x62, 0xf2, 0xe5, 0x28, 0x14, 0xf5);
    FCML_I32("vprorvq ymm6,ymm3,ymm5", 0x62, 0xf2, 0xe5, 0x28, 0x14, 0xf5);
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vprorvq %zmm4,%zmm15,%zmm6", 0x62, 0xf2, 0x85, 0x48, 0x14, 0xf4);
    FCML_I64("vprorvq zmm6,zmm15,zmm4", 0x62, 0xf2, 0x85, 0x48, 0x14, 0xf4);
    FCML_A32("vprorvq %zmm4,%zmm6,%zmm6", 0x62, 0xf2, 0xcd, 0x48, 0x14, 0xf4);
    FCML_I32("vprorvq zmm6,zmm6,zmm4", 0x62, 0xf2, 0xcd, 0x48, 0x14, 0xf4);
    /* disp8 */
    FCML_I32("vprorvq zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf2, 0xed, 0x48, 0x14, 0x4c, 0x24, 0x08);
    FCML_A32("vprorvq 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x48, 0x14, 0x4c, 0x24, 0x08);
    FCML_I64("vprorvq zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf2, 0xed, 0x48, 0x14, 0x4c, 0x24, 0x08);
    FCML_A64("vprorvq 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x48, 0x14, 0x4c, 0x24, 0x08);
    FCML_I32("vprorvq ymm1,ymm2,ymmword ptr [esp+00000100h]", 0x62, 0xf2, 0xed, 0x28, 0x14, 0x4c, 0x24, 0x08);
    FCML_A32("vprorvq 0x00000100(%esp),%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x28, 0x14, 0x4c, 0x24, 0x08);
    FCML_I64("vprorvq ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 0x62, 0xf2, 0xed, 0x28, 0x14, 0x4c, 0x24, 0x08);
    FCML_A64("vprorvq 0x0000000000000100(%rsp),%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x28, 0x14, 0x4c, 0x24, 0x08);
    FCML_I32("vprorvq xmm1,xmm2,xmmword ptr [esp+00000080h]", 0x62, 0xf2, 0xed, 0x08, 0x14, 0x4c, 0x24, 0x08);
    FCML_A32("vprorvq 0x00000080(%esp),%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x08, 0x14, 0x4c, 0x24, 0x08);
    FCML_I64("vprorvq xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 0x62, 0xf2, 0xed, 0x08, 0x14, 0x4c, 0x24, 0x08);
    FCML_A64("vprorvq 0x0000000000000080(%rsp),%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x08, 0x14, 0x4c, 0x24, 0x08);
    /* {k}{z} */
    FCML_A64("vprorvq (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x12, 0x8d, 0x8c, 0x14, 0x14, 0x01);
    FCML_I64("vprorvq xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x8c, 0x14, 0x14, 0x01);
    FCML_A32("vprorvq (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0x8d, 0x14, 0x14, 0x01);
    FCML_I32("vprorvq xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x8d, 0x14, 0x14, 0x01);
    FCML_A64("vprorvq (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x12, 0x8d, 0xac, 0x14, 0x14, 0x01);
    FCML_I64("vprorvq ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0xac, 0x14, 0x14, 0x01);
    FCML_A32("vprorvq (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0xad, 0x14, 0x14, 0x01);
    FCML_I32("vprorvq ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0xad, 0x14, 0x14, 0x01);
    FCML_A64("vprorvq (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x12, 0x8d, 0xcc, 0x14, 0x14, 0x01);
    FCML_I64("vprorvq zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0xcc, 0x14, 0x14, 0x01);
    FCML_A32("vprorvq (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0xcd, 0x14, 0x14, 0x01);
    FCML_I32("vprorvq zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0xcd, 0x14, 0x14, 0x01);
    /* {k} */
    FCML_A64("vprorvq (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x12, 0x8d, 0x0c, 0x14, 0x14, 0x01);
    FCML_I64("vprorvq xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x0c, 0x14, 0x14, 0x01);
    FCML_A32("vprorvq (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf2, 0xc5, 0x0d, 0x14, 0x14, 0x01);
    FCML_I32("vprorvq xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x0d, 0x14, 0x14, 0x01);
    FCML_A64("vprorvq (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x12, 0x8d, 0x2c, 0x14, 0x14, 0x01);
    FCML_I64("vprorvq ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x2c, 0x14, 0x14, 0x01);
    FCML_A32("vprorvq (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf2, 0xc5, 0x2d, 0x14, 0x14, 0x01);
    FCML_I32("vprorvq ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x2d, 0x14, 0x14, 0x01);
    FCML_A64("vprorvq (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x12, 0x8d, 0x4c, 0x14, 0x14, 0x01);
    FCML_I64("vprorvq zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x4c, 0x14, 0x14, 0x01);
    FCML_A32("vprorvq (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf2, 0xc5, 0x4d, 0x14, 0x14, 0x01);
    FCML_I32("vprorvq zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x4d, 0x14, 0x14, 0x01);
    /* bcast */
    FCML_I64("vprorvq zmm31,zmm21,mmword ptr [rsi]{1to8}", 0x62, 0x62, 0xd5, 0x50, 0x14, 0x3e);
    FCML_A64("vprorvq (%rsi){1to8},%zmm21,%zmm31", 0x62, 0x62, 0xd5, 0x50, 0x14, 0x3e);
    FCML_I64("vprorvq ymm31,ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x62, 0xd5, 0x30, 0x14, 0x3e);
    FCML_A64("vprorvq (%rsi){1to4},%ymm21,%ymm31", 0x62, 0x62, 0xd5, 0x30, 0x14, 0x3e);
    FCML_I64("vprorvq xmm31,xmm21,mmword ptr [rsi]{1to2}", 0x62, 0x62, 0xd5, 0x10, 0x14, 0x3e);
    FCML_A64("vprorvq (%rsi){1to2},%xmm21,%xmm31", 0x62, 0x62, 0xd5, 0x10, 0x14, 0x3e);
    FCML_A32("vprorvq (%esi){1to8},%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x58, 0x14, 0x0e);
    FCML_I32("vprorvq zmm1,zmm2,mmword ptr [esi]{1to8}", 0x62, 0xf2, 0xed, 0x58, 0x14, 0x0e);
    /* {k}{z}{bcast} */
    FCML_A64("vprorvq (%rsi){1to4},%ymm21,%ymm31{%k7}{z}", 0x62, 0x62, 0xd5, 0xb7, 0x14, 0x3e);
    FCML_I64("vprorvq ymm31{k7}{z},ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x62, 0xd5, 0xb7, 0x14, 0x3e);
    /* {bcast} disp8 */
    FCML_I32("vprorvq zmm1,zmm2,mmword ptr [esp+00000040h]{1to8}", 0x62, 0xf2, 0xed, 0x58, 0x14, 0x4c, 0x24, 0x08);
    FCML_A32("vprorvq 0x00000040(%esp){1to8},%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x58, 0x14, 0x4c, 0x24, 0x08);
    FCML_I64("vprorvq zmm1,zmm2,mmword ptr [rsp+0000000000000040h]{1to8}", 0x62, 0xf2, 0xed, 0x58, 0x14, 0x4c, 0x24, 0x08);
    FCML_A64("vprorvq 0x0000000000000040(%rsp){1to8},%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x58, 0x14, 0x4c, 0x24, 0x08);
    FCML_I32("vprorvq ymm1,ymm2,mmword ptr [esp+00000040h]{1to4}", 0x62, 0xf2, 0xed, 0x38, 0x14, 0x4c, 0x24, 0x08);
    FCML_A32("vprorvq 0x00000040(%esp){1to4},%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x38, 0x14, 0x4c, 0x24, 0x08);
    FCML_I64("vprorvq ymm1,ymm2,mmword ptr [rsp+0000000000000040h]{1to4}", 0x62, 0xf2, 0xed, 0x38, 0x14, 0x4c, 0x24, 0x08);
    FCML_A64("vprorvq 0x0000000000000040(%rsp){1to4},%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x38, 0x14, 0x4c, 0x24, 0x08);
    FCML_I32("vprorvq xmm1,xmm2,mmword ptr [esp+00000040h]{1to2}", 0x62, 0xf2, 0xed, 0x18, 0x14, 0x4c, 0x24, 0x08);
    FCML_A32("vprorvq 0x00000040(%esp){1to2},%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x18, 0x14, 0x4c, 0x24, 0x08);
    FCML_I64("vprorvq xmm1,xmm2,mmword ptr [rsp+0000000000000040h]{1to2}", 0x62, 0xf2, 0xed, 0x18, 0x14, 0x4c, 0x24, 0x08);
    FCML_A64("vprorvq 0x0000000000000040(%rsp){1to2},%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x18, 0x14, 0x4c, 0x24, 0x08);
}

void fcml_tf_instruction_VPRORD(void) {
    FCML_I64("vprord xmm2,xmmword ptr [rax],01h", 0x62, 0xf1, 0x6d, 0x08, 0x72, 0x00, 0x01);
    FCML_I64("vprord ymm3,ymmword ptr [rax],02h", 0x62, 0xf1, 0x65, 0x28, 0x72, 0x00, 0x02);
    FCML_I64("vprord zmm3,zmmword ptr [rax],03h", 0x62, 0xf1, 0x65, 0x48, 0x72, 0x00, 0x03);
    FCML_I64("vprord xmm1,dword ptr [rsp+0000000000000040h]{1to4},01h", 0x62, 0xf1, 0x75, 0x18, 0x72, 0x44, 0x24, 0x10, 0x01);
    FCML_I64("vprord ymm2,dword ptr [rsp+0000000000000040h]{1to8},02h", 0x62, 0xf1, 0x6d, 0x38, 0x72, 0x44, 0x24, 0x10, 0x02);
    FCML_I64("vprord zmm4,dword ptr [rsp+0000000000000040h]{1to16},03h", 0x62, 0xf1, 0x5d, 0x58, 0x72, 0x44, 0x24, 0x10, 0x03);
    FCML_I64("vprord xmm1{k1},xmmword ptr [rax],01h", 0x62, 0xf1, 0x75, 0x09, 0x72, 0x00, 0x01);
    FCML_I64("vprord ymm4{k7},ymmword ptr [rax],02h", 0x62, 0xf1, 0x5d, 0x2f, 0x72, 0x00, 0x02);
    FCML_I64("vprord zmm6{k4},zmmword ptr [rax],03h", 0x62, 0xf1, 0x4d, 0x4c, 0x72, 0x00, 0x03);
    FCML_I64("vprord xmm1,xmm6,01h", 0x62, 0xf1, 0x75, 0x08, 0x72, 0xc6, 0x01);
    FCML_I64("vprord ymm1,ymm21,02h", 0x62, 0xb1, 0x75, 0x28, 0x72, 0xc5, 0x02);
    FCML_I64("vprord zmm1,zmm7,03h", 0x62, 0xf1, 0x75, 0x48, 0x72, 0xc7, 0x03);
    FCML_I64("vprord xmm1{k3}{z},xmm6,01h", 0x62, 0xf1, 0x75, 0x8b, 0x72, 0xc6, 0x01);
    FCML_I64("vprord ymm1{k1}{z},ymm21,02h", 0x62, 0xb1, 0x75, 0xa9, 0x72, 0xc5, 0x02);
    FCML_I64("vprord zmm1{k6}{z},zmm7,03h", 0x62, 0xf1, 0x75, 0xce, 0x72, 0xc7, 0x03);
    FCML_A32("vprord $0x03,(%eax),%zmm3", 0x62, 0xf1, 0x65, 0x48, 0x72, 0x00, 0x03);
    FCML_A32("vprord $0x02,0x00000040(%esp){1to8},%ymm2", 0x62, 0xf1, 0x6d, 0x38, 0x72, 0x44, 0x24, 0x10, 0x02);
}

void fcml_tf_instruction_VPRORQ(void) {
    FCML_I64("vprorq xmm2,xmmword ptr [rax],01h", 0x62, 0xf1, 0xed, 0x08, 0x72, 0x00, 0x01);
    FCML_I64("vprorq ymm3,ymmword ptr [rax],02h", 0x62, 0xf1, 0xe5, 0x28, 0x72, 0x00, 0x02);
    FCML_I64("vprorq zmm3,zmmword ptr [rax],03h", 0x62, 0xf1, 0xe5, 0x48, 0x72, 0x00, 0x03);
    FCML_I64("vprorq xmm1,mmword ptr [rsp+0000000000000040h]{1to2},01h", 0x62, 0xf1, 0xf5, 0x18, 0x72, 0x44, 0x24, 0x08, 0x01);
    FCML_I64("vprorq ymm2,mmword ptr [rsp+0000000000000040h]{1to4},02h", 0x62, 0xf1, 0xed, 0x38, 0x72, 0x44, 0x24, 0x08, 0x02);
    FCML_I64("vprorq zmm4,mmword ptr [rsp+0000000000000040h]{1to8},03h", 0x62, 0xf1, 0xdd, 0x58, 0x72, 0x44, 0x24, 0x08, 0x03);
    FCML_I64("vprorq xmm1{k1},xmmword ptr [rax],01h", 0x62, 0xf1, 0xf5, 0x09, 0x72, 0x00, 0x01);
    FCML_I64("vprorq ymm4{k7},ymmword ptr [rax],02h", 0x62, 0xf1, 0xdd, 0x2f, 0x72, 0x00, 0x02);
    FCML_I64("vprorq zmm6{k4},zmmword ptr [rax],03h", 0x62, 0xf1, 0xcd, 0x4c, 0x72, 0x00, 0x03);
    FCML_I64("vprorq xmm1,xmm6,01h", 0x62, 0xf1, 0xf5, 0x08, 0x72, 0xc6, 0x01);
    FCML_I64("vprorq ymm1,ymm21,02h", 0x62, 0xb1, 0xf5, 0x28, 0x72, 0xc5, 0x02);
    FCML_I64("vprorq zmm1,zmm7,03h", 0x62, 0xf1, 0xf5, 0x48, 0x72, 0xc7, 0x03);
    FCML_I64("vprorq xmm1{k3}{z},xmm6,01h", 0x62, 0xf1, 0xf5, 0x8b, 0x72, 0xc6, 0x01);
    FCML_I64("vprorq ymm1{k1}{z},ymm21,02h", 0x62, 0xb1, 0xf5, 0xa9, 0x72, 0xc5, 0x02);
    FCML_I64("vprorq zmm1{k6}{z},zmm7,03h", 0x62, 0xf1, 0xf5, 0xce, 0x72, 0xc7, 0x03);
    FCML_A32("vprorq $0x03,(%eax),%zmm3", 0x62, 0xf1, 0xe5, 0x48, 0x72, 0x00, 0x03);
    FCML_A32("vprorq $0x02,0x00000040(%esp){1to4},%ymm2", 0x62, 0xf1, 0xed, 0x38, 0x72, 0x44, 0x24, 0x08, 0x02);
}

void fcml_tf_instruction_VPSCATTERDD(void) {
    FCML_I32("vpscatterdd dword ptr [eax+xmm5]{k1},xmm0", 0x62, 0xf2, 0x7d, 0x09, 0xa0, 0x04, 0x28);
    FCML_I32("vpscatterdd dword ptr [eax+ymm5]{k2},ymm0", 0x62, 0xf2, 0x7d, 0x2a, 0xa0, 0x04, 0x28);
    FCML_I32("vpscatterdd dword ptr [eax+zmm5]{k3},zmm0", 0x62, 0xf2, 0x7d, 0x4b, 0xa0, 0x04, 0x28);
    FCML_I32("vpscatterdd dword ptr [eax+zmm5+00000020h]{k3},zmm0", 0x62, 0xf2, 0x7d, 0x4b, 0xa0, 0x44, 0x28, 0x08);
}

void fcml_tf_instruction_VPSCATTERDQ(void) {
    FCML_I32("vpscatterdq mmword ptr [eax+xmm5]{k1},xmm0", 0x62, 0xf2, 0xfd, 0x09, 0xa0, 0x04, 0x28);
    FCML_I32("vpscatterdq mmword ptr [eax+xmm5]{k2},ymm0", 0x62, 0xf2, 0xfd, 0x2a, 0xa0, 0x04, 0x28);
    FCML_I32("vpscatterdq mmword ptr [eax+ymm5]{k3},zmm0", 0x62, 0xf2, 0xfd, 0x4b, 0xa0, 0x04, 0x28);
    FCML_I32("vpscatterdq mmword ptr [eax+ymm5+00000020h]{k3},zmm0", 0x62, 0xf2, 0xfd, 0x4b, 0xa0, 0x44, 0x28, 0x04);
}

void fcml_tf_instruction_VPSCATTERQD(void) {
    FCML_I32("vpscatterqd dword ptr [eax+xmm5]{k1},xmm0", 0x62, 0xf2, 0x7d, 0x09, 0xa1, 0x04, 0x28);
    FCML_I32("vpscatterqd dword ptr [eax+ymm5]{k2},xmm0", 0x62, 0xf2, 0x7d, 0x2a, 0xa1, 0x04, 0x28);
    FCML_I32("vpscatterqd dword ptr [eax+zmm5]{k3},ymm0", 0x62, 0xf2, 0x7d, 0x4b, 0xa1, 0x04, 0x28);
    FCML_I32("vpscatterqd dword ptr [eax+zmm5+00000020h]{k3},ymm0", 0x62, 0xf2, 0x7d, 0x4b, 0xa1, 0x44, 0x28, 0x08);
}

void fcml_tf_instruction_VPSCATTERQQ(void) {
    FCML_I32("vpscatterqq mmword ptr [eax+xmm5]{k1},xmm0", 0x62, 0xf2, 0xfd, 0x09, 0xa1, 0x04, 0x28);
    FCML_I32("vpscatterqq mmword ptr [eax+ymm5]{k2},ymm0", 0x62, 0xf2, 0xfd, 0x2a, 0xa1, 0x04, 0x28);
    FCML_I32("vpscatterqq mmword ptr [eax+zmm5]{k3},zmm0", 0x62, 0xf2, 0xfd, 0x4b, 0xa1, 0x04, 0x28);
    FCML_I32("vpscatterqq mmword ptr [eax+zmm5+00000020h]{k3},zmm0", 0x62, 0xf2, 0xfd, 0x4b, 0xa1, 0x44, 0x28, 0x04);
}

void fcml_tf_instruction_VPSLLVW(void) {
    /* xmm1, xmm2, m128 */
    FCML_A64("vpsllvw (%rax),%xmm7,%xmm15", 0x62, 0x72, 0xc5, 0x08, 0x12, 0x38);
    FCML_I64("vpsllvw xmm15,xmm7,xmmword ptr [rax]", 0x62, 0x72, 0xc5, 0x08, 0x12, 0x38);
    FCML_A32("vpsllvw (%eax),%xmm6,%xmm7", 0x62, 0xf2, 0xcd, 0x08, 0x12, 0x38);
    FCML_I32("vpsllvw xmm7,xmm6,xmmword ptr [eax]", 0x62, 0xf2, 0xcd, 0x08, 0x12, 0x38);
    /* ymm1, ymm2, m256 */
    FCML_A64("vpsllvw (%rax),%ymm7,%ymm15", 0x62, 0x72, 0xc5, 0x28, 0x12, 0x38);
    FCML_I64("vpsllvw ymm15,ymm7,ymmword ptr [rax]", 0x62, 0x72, 0xc5, 0x28, 0x12, 0x38);
    FCML_A32("vpsllvw (%eax),%ymm5,%ymm7", 0x62, 0xf2, 0xd5, 0x28, 0x12, 0x38);
    FCML_I32("vpsllvw ymm7,ymm5,ymmword ptr [eax]", 0x62, 0xf2, 0xd5, 0x28, 0x12, 0x38);
    /* zmm1, zmm2, m512 */
    FCML_A64("vpsllvw (%rax),%zmm7,%zmm15", 0x62, 0x72, 0xc5, 0x48, 0x12, 0x38);
    FCML_I64("vpsllvw zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x72, 0xc5, 0x48, 0x12, 0x38);
    FCML_A32("vpsllvw (%eax),%zmm3,%zmm7", 0x62, 0xf2, 0xe5, 0x48, 0x12, 0x38);
    FCML_I32("vpsllvw zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf2, 0xe5, 0x48, 0x12, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64("vpsllvw %xmm1,%xmm7,%xmm15", 0x62, 0x72, 0xc5, 0x08, 0x12, 0xf9);
    FCML_I64("vpsllvw xmm15,xmm7,xmm1", 0x62, 0x72, 0xc5, 0x08, 0x12, 0xf9);
    FCML_A32("vpsllvw %xmm1,%xmm2,%xmm7", 0x62, 0xf2, 0xed, 0x08, 0x12, 0xf9);
    FCML_I32("vpsllvw xmm7,xmm2,xmm1", 0x62, 0xf2, 0xed, 0x08, 0x12, 0xf9);
    /* ymm1, ymm2, ymm3 */
    FCML_A64("vpsllvw %ymm6,%ymm7,%ymm14", 0x62, 0x72, 0xc5, 0x28, 0x12, 0xf6);
    FCML_I64("vpsllvw ymm14,ymm7,ymm6", 0x62, 0x72, 0xc5, 0x28, 0x12, 0xf6);
    FCML_A32("vpsllvw %ymm5,%ymm3,%ymm6", 0x62, 0xf2, 0xe5, 0x28, 0x12, 0xf5);
    FCML_I32("vpsllvw ymm6,ymm3,ymm5", 0x62, 0xf2, 0xe5, 0x28, 0x12, 0xf5);
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vpsllvw %zmm4,%zmm15,%zmm6", 0x62, 0xf2, 0x85, 0x48, 0x12, 0xf4);
    FCML_I64("vpsllvw zmm6,zmm15,zmm4", 0x62, 0xf2, 0x85, 0x48, 0x12, 0xf4);
    FCML_A32("vpsllvw %zmm4,%zmm6,%zmm6", 0x62, 0xf2, 0xcd, 0x48, 0x12, 0xf4);
    FCML_I32("vpsllvw zmm6,zmm6,zmm4", 0x62, 0xf2, 0xcd, 0x48, 0x12, 0xf4);
    /* disp8 */
    FCML_I32("vpsllvw zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf2, 0xed, 0x48, 0x12, 0x4c, 0x24, 0x08);
    FCML_A32("vpsllvw 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x48, 0x12, 0x4c, 0x24, 0x08);
    FCML_I64("vpsllvw zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf2, 0xed, 0x48, 0x12, 0x4c, 0x24, 0x08);
    FCML_A64("vpsllvw 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x48, 0x12, 0x4c, 0x24, 0x08);
    FCML_I32("vpsllvw ymm1,ymm2,ymmword ptr [esp+00000100h]", 0x62, 0xf2, 0xed, 0x28, 0x12, 0x4c, 0x24, 0x08);
    FCML_A32("vpsllvw 0x00000100(%esp),%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x28, 0x12, 0x4c, 0x24, 0x08);
    FCML_I64("vpsllvw ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 0x62, 0xf2, 0xed, 0x28, 0x12, 0x4c, 0x24, 0x08);
    FCML_A64("vpsllvw 0x0000000000000100(%rsp),%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x28, 0x12, 0x4c, 0x24, 0x08);
    FCML_I32("vpsllvw xmm1,xmm2,xmmword ptr [esp+00000080h]", 0x62, 0xf2, 0xed, 0x08, 0x12, 0x4c, 0x24, 0x08);
    FCML_A32("vpsllvw 0x00000080(%esp),%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x08, 0x12, 0x4c, 0x24, 0x08);
    FCML_I64("vpsllvw xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 0x62, 0xf2, 0xed, 0x08, 0x12, 0x4c, 0x24, 0x08);
    FCML_A64("vpsllvw 0x0000000000000080(%rsp),%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x08, 0x12, 0x4c, 0x24, 0x08);
    /* {k}{z} */
    FCML_A64("vpsllvw (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x12, 0x8d, 0x8c, 0x12, 0x14, 0x01);
    FCML_I64("vpsllvw xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x8c, 0x12, 0x14, 0x01);
    FCML_A32("vpsllvw (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0x8d, 0x12, 0x14, 0x01);
    FCML_I32("vpsllvw xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x8d, 0x12, 0x14, 0x01);
    FCML_A64("vpsllvw (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x12, 0x8d, 0xac, 0x12, 0x14, 0x01);
    FCML_I64("vpsllvw ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0xac, 0x12, 0x14, 0x01);
    FCML_A32("vpsllvw (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0xad, 0x12, 0x14, 0x01);
    FCML_I32("vpsllvw ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0xad, 0x12, 0x14, 0x01);
    FCML_A64("vpsllvw (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x12, 0x8d, 0xcc, 0x12, 0x14, 0x01);
    FCML_I64("vpsllvw zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0xcc, 0x12, 0x14, 0x01);
    FCML_A32("vpsllvw (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0xcd, 0x12, 0x14, 0x01);
    FCML_I32("vpsllvw zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0xcd, 0x12, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpsllvw (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x12, 0x8d, 0x0c, 0x12, 0x14, 0x01);
    FCML_I64("vpsllvw xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x0c, 0x12, 0x14, 0x01);
    FCML_A32("vpsllvw (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf2, 0xc5, 0x0d, 0x12, 0x14, 0x01);
    FCML_I32("vpsllvw xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x0d, 0x12, 0x14, 0x01);
    FCML_A64("vpsllvw (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x12, 0x8d, 0x2c, 0x12, 0x14, 0x01);
    FCML_I64("vpsllvw ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x2c, 0x12, 0x14, 0x01);
    FCML_A32("vpsllvw (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf2, 0xc5, 0x2d, 0x12, 0x14, 0x01);
    FCML_I32("vpsllvw ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x2d, 0x12, 0x14, 0x01);
    FCML_A64("vpsllvw (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x12, 0x8d, 0x4c, 0x12, 0x14, 0x01);
    FCML_I64("vpsllvw zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x4c, 0x12, 0x14, 0x01);
    FCML_A32("vpsllvw (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf2, 0xc5, 0x4d, 0x12, 0x14, 0x01);
    FCML_I32("vpsllvw zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x4d, 0x12, 0x14, 0x01);
}

void fcml_tf_instruction_VPSLLVQ(void) {

    FCML_I64_M("vpsllvq xmm0,xmm6,xmmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0xcd, 0x08, 0x47, 0x00), FCML_MI(0xc4, 0xe2, 0xc9, 0x47, 0x00));
    FCML_I64_M("vpsllvq ymm0,ymm6,ymmword ptr [rax]", 2, FCML_MI(0x62, 0xf2, 0xcd, 0x28, 0x47, 0x00), FCML_MI(0xc4, 0xe2, 0xcd, 0x47, 0x00));
    FCML_I64_M("vpsllvq ymm0,ymm6,ymm0", 2, FCML_MI(0x62, 0xf2, 0xcd, 0x28, 0x47, 0xc0), FCML_MI(0xc4, 0xe2, 0xcd, 0x47, 0xc0));
    FCML_A64_M("vpsllvq (%rax),%xmm6,%xmm0", 2, FCML_MI(0x62, 0xf2, 0xcd, 0x08, 0x47, 0x00), FCML_MI(0xc4, 0xe2, 0xc9, 0x47, 0x00));
    FCML_A64_M("vpsllvq (%rax),%ymm6,%ymm0", 2, FCML_MI(0x62, 0xf2, 0xcd, 0x28, 0x47, 0x00), FCML_MI(0xc4, 0xe2, 0xcd, 0x47, 0x00));
    FCML_A64_M("vpsllvq %ymm0,%ymm6,%ymm0", 2, FCML_MI(0x62, 0xf2, 0xcd, 0x28, 0x47, 0xc0), FCML_MI(0xc4, 0xe2, 0xcd, 0x47, 0xc0));

    /* xmm1, xmm2, m128 */
    FCML_A64_M("vpsllvq (%rax),%xmm7,%xmm15", 2, FCML_MI(0x62, 0x72, 0xc5, 0x08, 0x47, 0x38), FCML_MI(0xc4, 0x62, 0xc1, 0x47, 0x38));
    FCML_I64_M("vpsllvq xmm15,xmm7,xmmword ptr [rax]", 2, FCML_MI(0x62, 0x72, 0xc5, 0x08, 0x47, 0x38), FCML_MI(0xc4, 0x62, 0xc1, 0x47, 0x38));
    FCML_A32_M("vpsllvq (%eax),%xmm6,%xmm7", 2, FCML_MI(0x62, 0xf2, 0xcd, 0x08, 0x47, 0x38), FCML_MI(0xc4, 0xe2, 0xc9, 0x47, 0x38));
    FCML_I32_M("vpsllvq xmm7,xmm6,xmmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0xcd, 0x08, 0x47, 0x38), FCML_MI(0xc4, 0xe2, 0xc9, 0x47, 0x38));
    /* ymm1, ymm2, m256 */
    FCML_A64_M("vpsllvq (%rax),%ymm7,%ymm15", 2, FCML_MI(0x62, 0x72, 0xc5, 0x28, 0x47, 0x38), FCML_MI(0xc4, 0x62, 0xc5, 0x47, 0x38));
    FCML_I64_M("vpsllvq ymm15,ymm7,ymmword ptr [rax]", 2, FCML_MI(0x62, 0x72, 0xc5, 0x28, 0x47, 0x38), FCML_MI(0xc4, 0x62, 0xc5, 0x47, 0x38));
    FCML_A32_M("vpsllvq (%eax),%ymm5,%ymm7", 2, FCML_MI(0x62, 0xf2, 0xd5, 0x28, 0x47, 0x38), FCML_MI(0xc4, 0xe2, 0xd5, 0x47, 0x38));
    FCML_I32_M("vpsllvq ymm7,ymm5,ymmword ptr [eax]", 2, FCML_MI(0x62, 0xf2, 0xd5, 0x28, 0x47, 0x38), FCML_MI(0xc4, 0xe2, 0xd5, 0x47, 0x38));
    /* zmm1, zmm2, m512 */
    FCML_A64("vpsllvq (%rax),%zmm7,%zmm15", 0x62, 0x72, 0xc5, 0x48, 0x47, 0x38);
    FCML_I64("vpsllvq zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x72, 0xc5, 0x48, 0x47, 0x38);
    FCML_A32("vpsllvq (%eax),%zmm3,%zmm7", 0x62, 0xf2, 0xe5, 0x48, 0x47, 0x38);
    FCML_I32("vpsllvq zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf2, 0xe5, 0x48, 0x47, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64_M("vpsllvq %xmm1,%xmm7,%xmm15", 2, FCML_MI(0x62, 0x72, 0xc5, 0x08, 0x47, 0xf9), FCML_MI(0xc4, 0x62, 0xc1, 0x47, 0xf9));
    FCML_I64_M("vpsllvq xmm15,xmm7,xmm1", 2, FCML_MI(0x62, 0x72, 0xc5, 0x08, 0x47, 0xf9), FCML_MI(0xc4, 0x62, 0xc1, 0x47, 0xf9));
    FCML_A32_M("vpsllvq %xmm1,%xmm2,%xmm7", 2, FCML_MI(0x62, 0xf2, 0xed, 0x08, 0x47, 0xf9), FCML_MI(0xc4, 0xe2, 0xe9, 0x47, 0xf9));
    FCML_I32_M("vpsllvq xmm7,xmm2,xmm1", 2, FCML_MI(0x62, 0xf2, 0xed, 0x08, 0x47, 0xf9), FCML_MI(0xc4, 0xe2, 0xe9, 0x47, 0xf9));
     /* ymm1, ymm2, ymm3 */
    FCML_A64_M("vpsllvq %ymm6,%ymm7,%ymm14", 2, FCML_MI(0x62, 0x72, 0xc5, 0x28, 0x47, 0xf6), FCML_MI(0xc4, 0x62, 0xc5, 0x47, 0xf6));
    FCML_I64_M("vpsllvq ymm14,ymm7,ymm6", 2, FCML_MI(0x62, 0x72, 0xc5, 0x28, 0x47, 0xf6), FCML_MI(0xc4, 0x62, 0xc5, 0x47, 0xf6));
    FCML_A32_M("vpsllvq %ymm5,%ymm3,%ymm6", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0x47, 0xf5), FCML_MI(0xc4, 0xe2, 0xe5, 0x47, 0xf5));
    FCML_I32_M("vpsllvq ymm6,ymm3,ymm5", 2, FCML_MI(0x62, 0xf2, 0xe5, 0x28, 0x47, 0xf5), FCML_MI(0xc4, 0xe2, 0xe5, 0x47, 0xf5));
   /* zmm1, zmm2, zmm3 */
    FCML_A64("vpsllvq %zmm4,%zmm15,%zmm6", 0x62, 0xf2, 0x85, 0x48, 0x47, 0xf4);
    FCML_I64("vpsllvq zmm6,zmm15,zmm4", 0x62, 0xf2, 0x85, 0x48, 0x47, 0xf4);
    FCML_A32("vpsllvq %zmm4,%zmm6,%zmm6", 0x62, 0xf2, 0xcd, 0x48, 0x47, 0xf4);
    FCML_I32("vpsllvq zmm6,zmm6,zmm4", 0x62, 0xf2, 0xcd, 0x48, 0x47, 0xf4);
    /* disp8 */
    FCML_I32("vpsllvq zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf2, 0xed, 0x48, 0x47, 0x4c, 0x24, 0x08);
    FCML_A32("vpsllvq 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x48, 0x47, 0x4c, 0x24, 0x08);
    FCML_I64("vpsllvq zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf2, 0xed, 0x48, 0x47, 0x4c, 0x24, 0x08);
    FCML_A64("vpsllvq 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x48, 0x47, 0x4c, 0x24, 0x08);
    FCML_I32_M("vpsllvq ymm1,ymm2,ymmword ptr [esp+00000100h]", 2, FCML_MI(0x62, 0xf2, 0xed, 0x28, 0x47, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0xed, 0x47, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A32_M("vpsllvq 0x00000100(%esp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf2, 0xed, 0x28, 0x47, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0xed, 0x47, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I64_M("vpsllvq ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 2, FCML_MI(0x62, 0xf2, 0xed, 0x28, 0x47, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0xed, 0x47, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_A64_M("vpsllvq 0x0000000000000100(%rsp),%ymm2,%ymm1", 2, FCML_MI(0x62, 0xf2, 0xed, 0x28, 0x47, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0xed, 0x47, 0x8c, 0x24, 0x00, 0x01, 0x00, 0x00));
    FCML_I32_M("vpsllvq xmm1,xmm2,xmmword ptr [esp+00000080h]", 2, FCML_MI(0x62, 0xf2, 0xed, 0x08, 0x47, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0xe9, 0x47, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A32_M("vpsllvq 0x00000080(%esp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf2, 0xed, 0x08, 0x47, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0xe9, 0x47, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_I64_M("vpsllvq xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 2, FCML_MI(0x62, 0xf2, 0xed, 0x08, 0x47, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0xe9, 0x47, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    FCML_A64_M("vpsllvq 0x0000000000000080(%rsp),%xmm2,%xmm1", 2, FCML_MI(0x62, 0xf2, 0xed, 0x08, 0x47, 0x4c, 0x24, 0x08), FCML_MI(0xc4, 0xe2, 0xe9, 0x47, 0x8c, 0x24, 0x80, 0x00, 0x00, 0x00));
    /* {k}{z} */
    FCML_A64("vpsllvq (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x12, 0x8d, 0x8c, 0x47, 0x14, 0x01);
    FCML_I64("vpsllvq xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x8c, 0x47, 0x14, 0x01);
    FCML_A32("vpsllvq (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0x8d, 0x47, 0x14, 0x01);
    FCML_I32("vpsllvq xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x8d, 0x47, 0x14, 0x01);
    FCML_A64("vpsllvq (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x12, 0x8d, 0xac, 0x47, 0x14, 0x01);
    FCML_I64("vpsllvq ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0xac, 0x47, 0x14, 0x01);
    FCML_A32("vpsllvq (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0xad, 0x47, 0x14, 0x01);
    FCML_I32("vpsllvq ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0xad, 0x47, 0x14, 0x01);
    FCML_A64("vpsllvq (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x12, 0x8d, 0xcc, 0x47, 0x14, 0x01);
    FCML_I64("vpsllvq zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0xcc, 0x47, 0x14, 0x01);
    FCML_A32("vpsllvq (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0xcd, 0x47, 0x14, 0x01);
    FCML_I32("vpsllvq zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0xcd, 0x47, 0x14, 0x01);
    /* {k} */
    FCML_A64("vpsllvq (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x12, 0x8d, 0x0c, 0x47, 0x14, 0x01);
    FCML_I64("vpsllvq xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x0c, 0x47, 0x14, 0x01);
    FCML_A32("vpsllvq (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf2, 0xc5, 0x0d, 0x47, 0x14, 0x01);
    FCML_I32("vpsllvq xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x0d, 0x47, 0x14, 0x01);
    FCML_A64("vpsllvq (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x12, 0x8d, 0x2c, 0x47, 0x14, 0x01);
    FCML_I64("vpsllvq ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x2c, 0x47, 0x14, 0x01);
    FCML_A32("vpsllvq (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf2, 0xc5, 0x2d, 0x47, 0x14, 0x01);
    FCML_I32("vpsllvq ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x2d, 0x47, 0x14, 0x01);
    FCML_A64("vpsllvq (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x12, 0x8d, 0x4c, 0x47, 0x14, 0x01);
    FCML_I64("vpsllvq zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x4c, 0x47, 0x14, 0x01);
    FCML_A32("vpsllvq (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf2, 0xc5, 0x4d, 0x47, 0x14, 0x01);
    FCML_I32("vpsllvq zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x4d, 0x47, 0x14, 0x01);
    /* bcast */
    FCML_I64("vpsllvq zmm31,zmm21,mmword ptr [rsi]{1to8}", 0x62, 0x62, 0xd5, 0x50, 0x47, 0x3e);
    FCML_A64("vpsllvq (%rsi){1to8},%zmm21,%zmm31", 0x62, 0x62, 0xd5, 0x50, 0x47, 0x3e);
    FCML_I64("vpsllvq ymm31,ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x62, 0xd5, 0x30, 0x47, 0x3e);
    FCML_A64("vpsllvq (%rsi){1to4},%ymm21,%ymm31", 0x62, 0x62, 0xd5, 0x30, 0x47, 0x3e);
    FCML_I64("vpsllvq xmm31,xmm21,mmword ptr [rsi]{1to2}", 0x62, 0x62, 0xd5, 0x10, 0x47, 0x3e);
    FCML_A64("vpsllvq (%rsi){1to2},%xmm21,%xmm31", 0x62, 0x62, 0xd5, 0x10, 0x47, 0x3e);
    FCML_A32("vpsllvq (%esi){1to8},%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x58, 0x47, 0x0e);
    FCML_I32("vpsllvq zmm1,zmm2,mmword ptr [esi]{1to8}", 0x62, 0xf2, 0xed, 0x58, 0x47, 0x0e);
    /* {k}{z}{bcast} */
    FCML_A64("vpsllvq (%rsi){1to4},%ymm21,%ymm31{%k7}{z}", 0x62, 0x62, 0xd5, 0xb7, 0x47, 0x3e);
    FCML_I64("vpsllvq ymm31{k7}{z},ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x62, 0xd5, 0xb7, 0x47, 0x3e);
    /* {bcast} disp8 */
    FCML_I32("vpsllvq zmm1,zmm2,mmword ptr [esp+00000040h]{1to8}", 0x62, 0xf2, 0xed, 0x58, 0x47, 0x4c, 0x24, 0x08);
    FCML_A32("vpsllvq 0x00000040(%esp){1to8},%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x58, 0x47, 0x4c, 0x24, 0x08);
    FCML_I64("vpsllvq zmm1,zmm2,mmword ptr [rsp+0000000000000040h]{1to8}", 0x62, 0xf2, 0xed, 0x58, 0x47, 0x4c, 0x24, 0x08);
    FCML_A64("vpsllvq 0x0000000000000040(%rsp){1to8},%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x58, 0x47, 0x4c, 0x24, 0x08);
    FCML_I32("vpsllvq ymm1,ymm2,mmword ptr [esp+00000040h]{1to4}", 0x62, 0xf2, 0xed, 0x38, 0x47, 0x4c, 0x24, 0x08);
    FCML_A32("vpsllvq 0x00000040(%esp){1to4},%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x38, 0x47, 0x4c, 0x24, 0x08);
    FCML_I64("vpsllvq ymm1,ymm2,mmword ptr [rsp+0000000000000040h]{1to4}", 0x62, 0xf2, 0xed, 0x38, 0x47, 0x4c, 0x24, 0x08);
    FCML_A64("vpsllvq 0x0000000000000040(%rsp){1to4},%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x38, 0x47, 0x4c, 0x24, 0x08);
    FCML_I32("vpsllvq xmm1,xmm2,mmword ptr [esp+00000040h]{1to2}", 0x62, 0xf2, 0xed, 0x18, 0x47, 0x4c, 0x24, 0x08);
    FCML_A32("vpsllvq 0x00000040(%esp){1to2},%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x18, 0x47, 0x4c, 0x24, 0x08);
    FCML_I64("vpsllvq xmm1,xmm2,mmword ptr [rsp+0000000000000040h]{1to2}", 0x62, 0xf2, 0xed, 0x18, 0x47, 0x4c, 0x24, 0x08);
    FCML_A64("vpsllvq 0x0000000000000040(%rsp){1to2},%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x18, 0x47, 0x4c, 0x24, 0x08);
}

void fcml_tf_instruction_VPTERNLOGD(void) {
    FCML_A64("vpternlogd $0x14,(%rax),%xmm7,%xmm15", 0x62, 0x73, 0x45, 0x08, 0x25, 0x38, 0x14);
    FCML_I64("vpternlogd xmm15,xmm7,xmmword ptr [rax],14h", 0x62, 0x73, 0x45, 0x08, 0x25, 0x38, 0x14);
    FCML_A32("vpternlogd $0x14,(%eax),%xmm6,%xmm7", 0x62, 0xf3, 0x4d, 0x08, 0x25, 0x38, 0x14);
    FCML_I32("vpternlogd xmm7,xmm6,xmmword ptr [eax],14h", 0x62, 0xf3, 0x4d, 0x08, 0x25, 0x38, 0x14);
    FCML_A64("vpternlogd $0x14,(%rax),%ymm7,%ymm15", 0x62, 0x73, 0x45, 0x28, 0x25, 0x38, 0x14);
    FCML_I64("vpternlogd ymm15,ymm7,ymmword ptr [rax],14h", 0x62, 0x73, 0x45, 0x28, 0x25, 0x38, 0x14);
    FCML_A32("vpternlogd $0x14,(%eax),%ymm5,%ymm7", 0x62, 0xf3, 0x55, 0x28, 0x25, 0x38, 0x14);
    FCML_I32("vpternlogd ymm7,ymm5,ymmword ptr [eax],14h", 0x62, 0xf3, 0x55, 0x28, 0x25, 0x38, 0x14);
    FCML_A64("vpternlogd $0x14,(%rax),%zmm7,%zmm15", 0x62, 0x73, 0x45, 0x48, 0x25, 0x38, 0x14);
    FCML_I64("vpternlogd zmm15,zmm7,zmmword ptr [rax],14h", 0x62, 0x73, 0x45, 0x48, 0x25, 0x38, 0x14);
    FCML_A32("vpternlogd $0x14,(%eax),%zmm3,%zmm7", 0x62, 0xf3, 0x65, 0x48, 0x25, 0x38, 0x14);
    FCML_I32("vpternlogd zmm7,zmm3,zmmword ptr [eax],14h", 0x62, 0xf3, 0x65, 0x48, 0x25, 0x38, 0x14);
    FCML_A64("vpternlogd $0x14,%xmm1,%xmm7,%xmm15", 0x62, 0x73, 0x45, 0x08, 0x25, 0xf9, 0x14);
    FCML_I64("vpternlogd xmm15,xmm7,xmm1,14h", 0x62, 0x73, 0x45, 0x08, 0x25, 0xf9, 0x14);
    FCML_A32("vpternlogd $0x14,%xmm1,%xmm2,%xmm7", 0x62, 0xf3, 0x6d, 0x08, 0x25, 0xf9, 0x14);
    FCML_I32("vpternlogd xmm7,xmm2,xmm1,14h", 0x62, 0xf3, 0x6d, 0x08, 0x25, 0xf9, 0x14);
    FCML_A64("vpternlogd $0x14,%ymm6,%ymm7,%ymm14", 0x62, 0x73, 0x45, 0x28, 0x25, 0xf6, 0x14);
    FCML_I64("vpternlogd ymm14,ymm7,ymm6,14h", 0x62, 0x73, 0x45, 0x28, 0x25, 0xf6, 0x14);
    FCML_A32("vpternlogd $0x14,%ymm5,%ymm3,%ymm6", 0x62, 0xf3, 0x65, 0x28, 0x25, 0xf5, 0x14);
    FCML_I32("vpternlogd ymm6,ymm3,ymm5,14h", 0x62, 0xf3, 0x65, 0x28, 0x25, 0xf5, 0x14);
    FCML_A64("vpternlogd $0x14,%zmm4,%zmm15,%zmm6", 0x62, 0xf3, 0x05, 0x48, 0x25, 0xf4, 0x14);
    FCML_I64("vpternlogd zmm6,zmm15,zmm4,14h", 0x62, 0xf3, 0x05, 0x48, 0x25, 0xf4, 0x14);
    FCML_A32("vpternlogd $0x14,%zmm4,%zmm6,%zmm6", 0x62, 0xf3, 0x4d, 0x48, 0x25, 0xf4, 0x14);
    FCML_I32("vpternlogd zmm6,zmm6,zmm4,14h", 0x62, 0xf3, 0x4d, 0x48, 0x25, 0xf4, 0x14);
    FCML_I32("vpternlogd zmm1,zmm2,zmmword ptr [esp+00000200h],14h", 0x62, 0xf3, 0x6d, 0x48, 0x25, 0x4c, 0x24, 0x08, 0x14);
    FCML_A32("vpternlogd $0x14,0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf3, 0x6d, 0x48, 0x25, 0x4c, 0x24, 0x08, 0x14);
    FCML_I64("vpternlogd zmm1,zmm2,zmmword ptr [rsp+0000000000000200h],14h", 0x62, 0xf3, 0x6d, 0x48, 0x25, 0x4c, 0x24, 0x08, 0x14);
    FCML_A64("vpternlogd $0x14,0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf3, 0x6d, 0x48, 0x25, 0x4c, 0x24, 0x08, 0x14);
    FCML_I32("vpternlogd ymm1,ymm2,ymmword ptr [esp+00000100h],14h", 0x62, 0xf3, 0x6d, 0x28, 0x25, 0x4c, 0x24, 0x08, 0x14);
    FCML_A32("vpternlogd $0x14,0x00000100(%esp),%ymm2,%ymm1", 0x62, 0xf3, 0x6d, 0x28, 0x25, 0x4c, 0x24, 0x08, 0x14);
    FCML_I64("vpternlogd ymm1,ymm2,ymmword ptr [rsp+0000000000000100h],14h", 0x62, 0xf3, 0x6d, 0x28, 0x25, 0x4c, 0x24, 0x08, 0x14);
    FCML_A64("vpternlogd $0x14,0x0000000000000100(%rsp),%ymm2,%ymm1", 0x62, 0xf3, 0x6d, 0x28, 0x25, 0x4c, 0x24, 0x08, 0x14);
    FCML_I32("vpternlogd xmm1,xmm2,xmmword ptr [esp+00000080h],14h", 0x62, 0xf3, 0x6d, 0x08, 0x25, 0x4c, 0x24, 0x08, 0x14);
    FCML_A32("vpternlogd $0x14,0x00000080(%esp),%xmm2,%xmm1", 0x62, 0xf3, 0x6d, 0x08, 0x25, 0x4c, 0x24, 0x08, 0x14);
    FCML_I64("vpternlogd xmm1,xmm2,xmmword ptr [rsp+0000000000000080h],14h", 0x62, 0xf3, 0x6d, 0x08, 0x25, 0x4c, 0x24, 0x08, 0x14);
    FCML_A64("vpternlogd $0x14,0x0000000000000080(%rsp),%xmm2,%xmm1", 0x62, 0xf3, 0x6d, 0x08, 0x25, 0x4c, 0x24, 0x08, 0x14);
    FCML_A64("vpternlogd $0x14,(%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x13, 0x0d, 0x8c, 0x25, 0x14, 0x01, 0x14);
    FCML_I64("vpternlogd xmm10{k4}{z},xmm14,xmmword ptr [r9+r8],14h", 0x62, 0x13, 0x0d, 0x8c, 0x25, 0x14, 0x01, 0x14);
    FCML_A32("vpternlogd $0x14,(%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf3, 0x45, 0x8d, 0x25, 0x14, 0x01, 0x14);
    FCML_I32("vpternlogd xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax],14h", 0x62, 0xf3, 0x45, 0x8d, 0x25, 0x14, 0x01, 0x14);
    FCML_A64("vpternlogd $0x14,(%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x13, 0x0d, 0xac, 0x25, 0x14, 0x01, 0x14);
    FCML_I64("vpternlogd ymm10{k4}{z},ymm14,ymmword ptr [r9+r8],14h", 0x62, 0x13, 0x0d, 0xac, 0x25, 0x14, 0x01, 0x14);
    FCML_A32("vpternlogd $0x14,(%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf3, 0x45, 0xad, 0x25, 0x14, 0x01, 0x14);
    FCML_I32("vpternlogd ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax],14h", 0x62, 0xf3, 0x45, 0xad, 0x25, 0x14, 0x01, 0x14);
    FCML_A64("vpternlogd $0x14,(%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x13, 0x0d, 0xcc, 0x25, 0x14, 0x01, 0x14);
    FCML_I64("vpternlogd zmm10{k4}{z},zmm14,zmmword ptr [r9+r8],14h", 0x62, 0x13, 0x0d, 0xcc, 0x25, 0x14, 0x01, 0x14);
    FCML_A32("vpternlogd $0x14,(%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf3, 0x45, 0xcd, 0x25, 0x14, 0x01, 0x14);
    FCML_I32("vpternlogd zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax],14h", 0x62, 0xf3, 0x45, 0xcd, 0x25, 0x14, 0x01, 0x14);
    FCML_A64("vpternlogd $0x14,(%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x13, 0x0d, 0x0c, 0x25, 0x14, 0x01, 0x14);
    FCML_I64("vpternlogd xmm10{k4},xmm14,xmmword ptr [r9+r8],14h", 0x62, 0x13, 0x0d, 0x0c, 0x25, 0x14, 0x01, 0x14);
    FCML_A32("vpternlogd $0x14,(%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf3, 0x45, 0x0d, 0x25, 0x14, 0x01, 0x14);
    FCML_I32("vpternlogd xmm2{k5},xmm7,xmmword ptr [ecx+eax],14h", 0x62, 0xf3, 0x45, 0x0d, 0x25, 0x14, 0x01, 0x14);
    FCML_A64("vpternlogd $0x14,(%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x13, 0x0d, 0x2c, 0x25, 0x14, 0x01, 0x14);
    FCML_I64("vpternlogd ymm10{k4},ymm14,ymmword ptr [r9+r8],14h", 0x62, 0x13, 0x0d, 0x2c, 0x25, 0x14, 0x01, 0x14);
    FCML_A32("vpternlogd $0x14,(%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf3, 0x45, 0x2d, 0x25, 0x14, 0x01, 0x14);
    FCML_I32("vpternlogd ymm2{k5},ymm7,ymmword ptr [ecx+eax],14h", 0x62, 0xf3, 0x45, 0x2d, 0x25, 0x14, 0x01, 0x14);
    FCML_A64("vpternlogd $0x14,(%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x13, 0x0d, 0x4c, 0x25, 0x14, 0x01, 0x14);
    FCML_I64("vpternlogd zmm10{k4},zmm14,zmmword ptr [r9+r8],14h", 0x62, 0x13, 0x0d, 0x4c, 0x25, 0x14, 0x01, 0x14);
    FCML_A32("vpternlogd $0x14,(%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf3, 0x45, 0x4d, 0x25, 0x14, 0x01, 0x14);
    FCML_I32("vpternlogd zmm2{k5},zmm7,zmmword ptr [ecx+eax],14h", 0x62, 0xf3, 0x45, 0x4d, 0x25, 0x14, 0x01, 0x14);
    FCML_I64("vpternlogd ymm31{k7}{z},ymm21,dword ptr [rsi]{1to8},14h", 0x62, 0x63, 0x55, 0xb7, 0x25, 0x3e, 0x14);
}

void fcml_tf_instruction_VPTERNLOGQ(void) {
    FCML_A64("vpternlogq $0x14,(%rax),%xmm7,%xmm15", 0x62, 0x73, 0xc5, 0x08, 0x25, 0x38, 0x14);
    FCML_I64("vpternlogq xmm15,xmm7,xmmword ptr [rax],14h", 0x62, 0x73, 0xc5, 0x08, 0x25, 0x38, 0x14);
    FCML_A32("vpternlogq $0x14,(%eax),%xmm6,%xmm7", 0x62, 0xf3, 0xcd, 0x08, 0x25, 0x38, 0x14);
    FCML_I32("vpternlogq xmm7,xmm6,xmmword ptr [eax],14h", 0x62, 0xf3, 0xcd, 0x08, 0x25, 0x38, 0x14);
    FCML_A64("vpternlogq $0x14,(%rax),%ymm7,%ymm15", 0x62, 0x73, 0xc5, 0x28, 0x25, 0x38, 0x14);
    FCML_I64("vpternlogq ymm15,ymm7,ymmword ptr [rax],14h", 0x62, 0x73, 0xc5, 0x28, 0x25, 0x38, 0x14);
    FCML_A32("vpternlogq $0x14,(%eax),%ymm5,%ymm7", 0x62, 0xf3, 0xd5, 0x28, 0x25, 0x38, 0x14);
    FCML_I32("vpternlogq ymm7,ymm5,ymmword ptr [eax],14h", 0x62, 0xf3, 0xd5, 0x28, 0x25, 0x38, 0x14);
    FCML_A64("vpternlogq $0x14,(%rax),%zmm7,%zmm15", 0x62, 0x73, 0xc5, 0x48, 0x25, 0x38, 0x14);
    FCML_I64("vpternlogq zmm15,zmm7,zmmword ptr [rax],14h", 0x62, 0x73, 0xc5, 0x48, 0x25, 0x38, 0x14);
    FCML_A32("vpternlogq $0x14,(%eax),%zmm3,%zmm7", 0x62, 0xf3, 0xe5, 0x48, 0x25, 0x38, 0x14);
    FCML_I32("vpternlogq zmm7,zmm3,zmmword ptr [eax],14h", 0x62, 0xf3, 0xe5, 0x48, 0x25, 0x38, 0x14);
    FCML_A64("vpternlogq $0x14,%xmm1,%xmm7,%xmm15", 0x62, 0x73, 0xc5, 0x08, 0x25, 0xf9, 0x14);
    FCML_I64("vpternlogq xmm15,xmm7,xmm1,14h", 0x62, 0x73, 0xc5, 0x08, 0x25, 0xf9, 0x14);
    FCML_A32("vpternlogq $0x14,%xmm1,%xmm2,%xmm7", 0x62, 0xf3, 0xed, 0x08, 0x25, 0xf9, 0x14);
    FCML_I32("vpternlogq xmm7,xmm2,xmm1,14h", 0x62, 0xf3, 0xed, 0x08, 0x25, 0xf9, 0x14);
    FCML_A64("vpternlogq $0x14,%ymm6,%ymm7,%ymm14", 0x62, 0x73, 0xc5, 0x28, 0x25, 0xf6, 0x14);
    FCML_I64("vpternlogq ymm14,ymm7,ymm6,14h", 0x62, 0x73, 0xc5, 0x28, 0x25, 0xf6, 0x14);
    FCML_A32("vpternlogq $0x14,%ymm5,%ymm3,%ymm6", 0x62, 0xf3, 0xe5, 0x28, 0x25, 0xf5, 0x14);
    FCML_I32("vpternlogq ymm6,ymm3,ymm5,14h", 0x62, 0xf3, 0xe5, 0x28, 0x25, 0xf5, 0x14);
    FCML_A64("vpternlogq $0x14,%zmm4,%zmm15,%zmm6", 0x62, 0xf3, 0x85, 0x48, 0x25, 0xf4, 0x14);
    FCML_I64("vpternlogq zmm6,zmm15,zmm4,14h", 0x62, 0xf3, 0x85, 0x48, 0x25, 0xf4, 0x14);
    FCML_A32("vpternlogq $0x14,%zmm4,%zmm6,%zmm6", 0x62, 0xf3, 0xcd, 0x48, 0x25, 0xf4, 0x14);
    FCML_I32("vpternlogq zmm6,zmm6,zmm4,14h", 0x62, 0xf3, 0xcd, 0x48, 0x25, 0xf4, 0x14);
    FCML_I32("vpternlogq zmm1,zmm2,zmmword ptr [esp+00000200h],14h", 0x62, 0xf3, 0xed, 0x48, 0x25, 0x4c, 0x24, 0x08, 0x14);
    FCML_A32("vpternlogq $0x14,0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf3, 0xed, 0x48, 0x25, 0x4c, 0x24, 0x08, 0x14);
    FCML_I64("vpternlogq zmm1,zmm2,zmmword ptr [rsp+0000000000000200h],14h", 0x62, 0xf3, 0xed, 0x48, 0x25, 0x4c, 0x24, 0x08, 0x14);
    FCML_A64("vpternlogq $0x14,0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf3, 0xed, 0x48, 0x25, 0x4c, 0x24, 0x08, 0x14);
    FCML_I32("vpternlogq ymm1,ymm2,ymmword ptr [esp+00000100h],14h", 0x62, 0xf3, 0xed, 0x28, 0x25, 0x4c, 0x24, 0x08, 0x14);
    FCML_A32("vpternlogq $0x14,0x00000100(%esp),%ymm2,%ymm1", 0x62, 0xf3, 0xed, 0x28, 0x25, 0x4c, 0x24, 0x08, 0x14);
    FCML_I64("vpternlogq ymm1,ymm2,ymmword ptr [rsp+0000000000000100h],14h", 0x62, 0xf3, 0xed, 0x28, 0x25, 0x4c, 0x24, 0x08, 0x14);
    FCML_A64("vpternlogq $0x14,0x0000000000000100(%rsp),%ymm2,%ymm1", 0x62, 0xf3, 0xed, 0x28, 0x25, 0x4c, 0x24, 0x08, 0x14);
    FCML_I32("vpternlogq xmm1,xmm2,xmmword ptr [esp+00000080h],14h", 0x62, 0xf3, 0xed, 0x08, 0x25, 0x4c, 0x24, 0x08, 0x14);
    FCML_A32("vpternlogq $0x14,0x00000080(%esp),%xmm2,%xmm1", 0x62, 0xf3, 0xed, 0x08, 0x25, 0x4c, 0x24, 0x08, 0x14);
    FCML_I64("vpternlogq xmm1,xmm2,xmmword ptr [rsp+0000000000000080h],14h", 0x62, 0xf3, 0xed, 0x08, 0x25, 0x4c, 0x24, 0x08, 0x14);
    FCML_A64("vpternlogq $0x14,0x0000000000000080(%rsp),%xmm2,%xmm1", 0x62, 0xf3, 0xed, 0x08, 0x25, 0x4c, 0x24, 0x08, 0x14);
    FCML_A64("vpternlogq $0x14,(%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x13, 0x8d, 0x8c, 0x25, 0x14, 0x01, 0x14);
    FCML_I64("vpternlogq xmm10{k4}{z},xmm14,xmmword ptr [r9+r8],14h", 0x62, 0x13, 0x8d, 0x8c, 0x25, 0x14, 0x01, 0x14);
    FCML_A32("vpternlogq $0x14,(%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf3, 0xc5, 0x8d, 0x25, 0x14, 0x01, 0x14);
    FCML_I32("vpternlogq xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax],14h", 0x62, 0xf3, 0xc5, 0x8d, 0x25, 0x14, 0x01, 0x14);
    FCML_A64("vpternlogq $0x14,(%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x13, 0x8d, 0xac, 0x25, 0x14, 0x01, 0x14);
    FCML_I64("vpternlogq ymm10{k4}{z},ymm14,ymmword ptr [r9+r8],14h", 0x62, 0x13, 0x8d, 0xac, 0x25, 0x14, 0x01, 0x14);
    FCML_A32("vpternlogq $0x14,(%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf3, 0xc5, 0xad, 0x25, 0x14, 0x01, 0x14);
    FCML_I32("vpternlogq ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax],14h", 0x62, 0xf3, 0xc5, 0xad, 0x25, 0x14, 0x01, 0x14);
    FCML_A64("vpternlogq $0x14,(%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x13, 0x8d, 0xcc, 0x25, 0x14, 0x01, 0x14);
    FCML_I64("vpternlogq zmm10{k4}{z},zmm14,zmmword ptr [r9+r8],14h", 0x62, 0x13, 0x8d, 0xcc, 0x25, 0x14, 0x01, 0x14);
    FCML_A32("vpternlogq $0x14,(%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf3, 0xc5, 0xcd, 0x25, 0x14, 0x01, 0x14);
    FCML_I32("vpternlogq zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax],14h", 0x62, 0xf3, 0xc5, 0xcd, 0x25, 0x14, 0x01, 0x14);
    FCML_A64("vpternlogq $0x14,(%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x13, 0x8d, 0x0c, 0x25, 0x14, 0x01, 0x14);
    FCML_I64("vpternlogq xmm10{k4},xmm14,xmmword ptr [r9+r8],14h", 0x62, 0x13, 0x8d, 0x0c, 0x25, 0x14, 0x01, 0x14);
    FCML_A32("vpternlogq $0x14,(%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf3, 0xc5, 0x0d, 0x25, 0x14, 0x01, 0x14);
    FCML_I32("vpternlogq xmm2{k5},xmm7,xmmword ptr [ecx+eax],14h", 0x62, 0xf3, 0xc5, 0x0d, 0x25, 0x14, 0x01, 0x14);
    FCML_A64("vpternlogq $0x14,(%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x13, 0x8d, 0x2c, 0x25, 0x14, 0x01, 0x14);
    FCML_I64("vpternlogq ymm10{k4},ymm14,ymmword ptr [r9+r8],14h", 0x62, 0x13, 0x8d, 0x2c, 0x25, 0x14, 0x01, 0x14);
    FCML_A32("vpternlogq $0x14,(%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf3, 0xc5, 0x2d, 0x25, 0x14, 0x01, 0x14);
    FCML_I32("vpternlogq ymm2{k5},ymm7,ymmword ptr [ecx+eax],14h", 0x62, 0xf3, 0xc5, 0x2d, 0x25, 0x14, 0x01, 0x14);
    FCML_A64("vpternlogq $0x14,(%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x13, 0x8d, 0x4c, 0x25, 0x14, 0x01, 0x14);
    FCML_I64("vpternlogq zmm10{k4},zmm14,zmmword ptr [r9+r8],14h", 0x62, 0x13, 0x8d, 0x4c, 0x25, 0x14, 0x01, 0x14);
    FCML_A32("vpternlogq $0x14,(%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf3, 0xc5, 0x4d, 0x25, 0x14, 0x01, 0x14);
    FCML_I32("vpternlogq zmm2{k5},zmm7,zmmword ptr [ecx+eax],14h", 0x62, 0xf3, 0xc5, 0x4d, 0x25, 0x14, 0x01, 0x14);
    FCML_A64("vpternlogq $0x14,(%rsi){1to4},%ymm21,%ymm31{%k7}{z}", 0x62, 0x63, 0xd5, 0xb7, 0x25, 0x3e, 0x14);
    FCML_I64("vpternlogq ymm31{k7}{z},ymm21,mmword ptr [rsi]{1to4},14h", 0x62, 0x63, 0xd5, 0xb7, 0x25, 0x3e, 0x14);
}

void fcml_tf_instruction_VPTESTMB(void) {
    /* xmm1, xmm2, m128 */
    FCML_A64("vptestmb (%rax),%xmm7,%k0", 0x62, 0xf2, 0x45, 0x08, 0x26, 0x00);
    FCML_I64("vptestmb k7,xmm7,xmmword ptr [rax]", 0x62, 0xf2, 0x45, 0x08, 0x26, 0x38);
    /* ymm1, ymm2, m256 */
    FCML_A64("vptestmb (%rax),%ymm7,%k0", 0x62, 0xf2, 0x45, 0x28, 0x26, 0x00);
    FCML_I64("vptestmb k0,ymm7,ymmword ptr [rax]", 0x62, 0xf2, 0x45, 0x28, 0x26, 0x00);
    /* zmm1, zmm2, m512 */
    FCML_A64("vptestmb (%rax),%zmm7,%k7", 0x62, 0xf2, 0x45, 0x48, 0x26, 0x38);
    FCML_I64("vptestmb k7,zmm7,zmmword ptr [rax]", 0x62, 0xf2, 0x45, 0x48, 0x26, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64("vptestmb %xmm1,%xmm7,%k3", 0x62, 0xf2, 0x45, 0x08, 0x26, 0xd9);
    FCML_I64("vptestmb k3,xmm7,xmm1", 0x62, 0xf2, 0x45, 0x08, 0x26, 0xd9);
    /* ymm1, ymm2, ymm3 */
    FCML_A64("vptestmb %ymm6,%ymm7,%k1", 0x62, 0xf2, 0x45, 0x28, 0x26, 0xce);
    FCML_I64("vptestmb k1,ymm7,ymm6", 0x62, 0xf2, 0x45, 0x28, 0x26, 0xce);
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vptestmb %zmm4,%zmm15,%k2", 0x62, 0xf2, 0x05, 0x48, 0x26, 0xd4);
    FCML_I64("vptestmb k2,zmm15,zmm4", 0x62, 0xf2, 0x05, 0x48, 0x26, 0xd4);
    /* disp8 */
    FCML_I32("vptestmb k0,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf2, 0x6d, 0x48, 0x26, 0x44, 0x24, 0x08);
    FCML_A32("vptestmb 0x00000200(%esp),%zmm2,%k2", 0x62, 0xf2, 0x6d, 0x48, 0x26, 0x54, 0x24, 0x08);
    FCML_I32("vptestmb k1,ymm2,ymmword ptr [esp+00000100h]", 0x62, 0xf2, 0x6d, 0x28, 0x26, 0x4c, 0x24, 0x08);
    FCML_A32("vptestmb 0x00000100(%esp),%ymm2,%k4", 0x62, 0xf2, 0x6d, 0x28, 0x26, 0x64, 0x24, 0x08);
    FCML_I32("vptestmb k0,xmm2,xmmword ptr [esp+00000080h]", 0x62, 0xf2, 0x6d, 0x08, 0x26, 0x44, 0x24, 0x08);
    FCML_A32("vptestmb 0x00000080(%esp),%xmm2,%k3", 0x62, 0xf2, 0x6d, 0x08, 0x26, 0x5c, 0x24, 0x08);
    /* {k} */
    FCML_A64("vptestmb (%r9,%r8),%xmm14,%k1{%k4}", 0x62, 0x92, 0x0d, 0x0c, 0x26, 0x0c, 0x01);
    FCML_I64("vptestmb k0{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x92, 0x0d, 0x0c, 0x26, 0x04, 0x01);
    FCML_A64("vptestmb (%r9,%r8),%ymm14,%k0{%k4}", 0x62, 0x92, 0x0d, 0x2c, 0x26, 0x04, 0x01);
    FCML_I64("vptestmb k1{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x92, 0x0d, 0x2c, 0x26, 0x0c, 0x01);
    FCML_A64("vptestmb (%r9,%r8),%zmm14,%k2{%k4}", 0x62, 0x92, 0x0d, 0x4c, 0x26, 0x14, 0x01);
    FCML_I64("vptestmb k7{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x92, 0x0d, 0x4c, 0x26, 0x3c, 0x01);
}

void fcml_tf_instruction_VPTESTMW(void) {
    /* xmm1, xmm2, m128 */
    FCML_A64("vptestmw (%rax),%xmm7,%k0", 0x62, 0xf2, 0xC5, 0x08, 0x26, 0x00);
    FCML_I64("vptestmw k7,xmm7,xmmword ptr [rax]", 0x62, 0xf2, 0xC5, 0x08, 0x26, 0x38);
    /* ymm1, ymm2, m256 */
    FCML_A64("vptestmw (%rax),%ymm7,%k0", 0x62, 0xf2, 0xC5, 0x28, 0x26, 0x00);
    FCML_I64("vptestmw k0,ymm7,ymmword ptr [rax]", 0x62, 0xf2, 0xC5, 0x28, 0x26, 0x00);
    /* zmm1, zmm2, m512 */
    FCML_A64("vptestmw (%rax),%zmm7,%k7", 0x62, 0xf2, 0xC5, 0x48, 0x26, 0x38);
    FCML_I64("vptestmw k7,zmm7,zmmword ptr [rax]", 0x62, 0xf2, 0xC5, 0x48, 0x26, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64("vptestmw %xmm1,%xmm7,%k3", 0x62, 0xf2, 0xC5, 0x08, 0x26, 0xd9);
    FCML_I64("vptestmw k3,xmm7,xmm1", 0x62, 0xf2, 0xC5, 0x08, 0x26, 0xd9);
    /* ymm1, ymm2, ymm3 */
    FCML_A64("vptestmw %ymm6,%ymm7,%k1", 0x62, 0xf2, 0xC5, 0x28, 0x26, 0xce);
    FCML_I64("vptestmw k1,ymm7,ymm6", 0x62, 0xf2, 0xC5, 0x28, 0x26, 0xce);
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vptestmw %zmm4,%zmm15,%k2", 0x62, 0xf2, 0x85, 0x48, 0x26, 0xd4);
    FCML_I64("vptestmw k2,zmm15,zmm4", 0x62, 0xf2, 0x85, 0x48, 0x26, 0xd4);
    /* disp8 */
    FCML_I32("vptestmw k0,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf2, 0xED, 0x48, 0x26, 0x44, 0x24, 0x08);
    FCML_A32("vptestmw 0x00000200(%esp),%zmm2,%k2", 0x62, 0xf2, 0xED, 0x48, 0x26, 0x54, 0x24, 0x08);
    FCML_I32("vptestmw k1,ymm2,ymmword ptr [esp+00000100h]", 0x62, 0xf2, 0xED, 0x28, 0x26, 0x4c, 0x24, 0x08);
    FCML_A32("vptestmw 0x00000100(%esp),%ymm2,%k4", 0x62, 0xf2, 0xED, 0x28, 0x26, 0x64, 0x24, 0x08);
    FCML_I32("vptestmw k0,xmm2,xmmword ptr [esp+00000080h]", 0x62, 0xf2, 0xED, 0x08, 0x26, 0x44, 0x24, 0x08);
    FCML_A32("vptestmw 0x00000080(%esp),%xmm2,%k3", 0x62, 0xf2, 0xED, 0x08, 0x26, 0x5c, 0x24, 0x08);
    /* {k} */
    FCML_A64("vptestmw (%r9,%r8),%xmm14,%k1{%k4}", 0x62, 0x92, 0x8D, 0x0c, 0x26, 0x0c, 0x01);
    FCML_I64("vptestmw k0{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x92, 0x8D, 0x0c, 0x26, 0x04, 0x01);
    FCML_A64("vptestmw (%r9,%r8),%ymm14,%k0{%k4}", 0x62, 0x92, 0x8D, 0x2c, 0x26, 0x04, 0x01);
    FCML_I64("vptestmw k1{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x92, 0x8D, 0x2c, 0x26, 0x0c, 0x01);
    FCML_A64("vptestmw (%r9,%r8),%zmm14,%k2{%k4}", 0x62, 0x92, 0x8D, 0x4c, 0x26, 0x14, 0x01);
    FCML_I64("vptestmw k7{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x92, 0x8D, 0x4c, 0x26, 0x3c, 0x01);
}

void fcml_tf_instruction_VPTESTMD(void) {
    /* xmm1, xmm2, m128 */
    FCML_A64("vptestmd (%rax),%xmm7,%k0", 0x62, 0xf2, 0x45, 0x08, 0x27, 0x00);
    FCML_I64("vptestmd k7,xmm7,xmmword ptr [rax]", 0x62, 0xf2, 0x45, 0x08, 0x27, 0x38);
    /* ymm1, ymm2, m256 */
    FCML_A64("vptestmd (%rax),%ymm7,%k0", 0x62, 0xf2, 0x45, 0x28, 0x27, 0x00);
    FCML_I64("vptestmd k0,ymm7,ymmword ptr [rax]", 0x62, 0xf2, 0x45, 0x28, 0x27, 0x00);
    /* zmm1, zmm2, m512 */
    FCML_A64("vptestmd (%rax),%zmm7,%k7", 0x62, 0xf2, 0x45, 0x48, 0x27, 0x38);
    FCML_I64("vptestmd k7,zmm7,zmmword ptr [rax]", 0x62, 0xf2, 0x45, 0x48, 0x27, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64("vptestmd %xmm1,%xmm7,%k3", 0x62, 0xf2, 0x45, 0x08, 0x27, 0xd9);
    FCML_I64("vptestmd k3,xmm7,xmm1", 0x62, 0xf2, 0x45, 0x08, 0x27, 0xd9);
    /* ymm1, ymm2, ymm3 */
    FCML_A64("vptestmd %ymm6,%ymm7,%k1", 0x62, 0xf2, 0x45, 0x28, 0x27, 0xce);
    FCML_I64("vptestmd k1,ymm7,ymm6", 0x62, 0xf2, 0x45, 0x28, 0x27, 0xce);
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vptestmd %zmm4,%zmm15,%k2", 0x62, 0xf2, 0x05, 0x48, 0x27, 0xd4);
    FCML_I64("vptestmd k2,zmm15,zmm4", 0x62, 0xf2, 0x05, 0x48, 0x27, 0xd4);
    /* disp8 */
    FCML_I32("vptestmd k0,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf2, 0x6d, 0x48, 0x27, 0x44, 0x24, 0x08);
    FCML_A32("vptestmd 0x00000200(%esp),%zmm2,%k2", 0x62, 0xf2, 0x6d, 0x48, 0x27, 0x54, 0x24, 0x08);
    FCML_I32("vptestmd k1,ymm2,ymmword ptr [esp+00000100h]", 0x62, 0xf2, 0x6d, 0x28, 0x27, 0x4c, 0x24, 0x08);
    FCML_A32("vptestmd 0x00000100(%esp),%ymm2,%k4", 0x62, 0xf2, 0x6d, 0x28, 0x27, 0x64, 0x24, 0x08);
    FCML_I32("vptestmd k0,xmm2,xmmword ptr [esp+00000080h]", 0x62, 0xf2, 0x6d, 0x08, 0x27, 0x44, 0x24, 0x08);
    FCML_A32("vptestmd 0x00000080(%esp),%xmm2,%k3", 0x62, 0xf2, 0x6d, 0x08, 0x27, 0x5c, 0x24, 0x08);
    /* {k} */
    FCML_A64("vptestmd (%r9,%r8),%xmm14,%k1{%k4}", 0x62, 0x92, 0x0d, 0x0c, 0x27, 0x0c, 0x01);
    FCML_I64("vptestmd k0{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x92, 0x0d, 0x0c, 0x27, 0x04, 0x01);
    FCML_A64("vptestmd (%r9,%r8),%ymm14,%k0{%k4}", 0x62, 0x92, 0x0d, 0x2c, 0x27, 0x04, 0x01);
    FCML_I64("vptestmd k1{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x92, 0x0d, 0x2c, 0x27, 0x0c, 0x01);
    FCML_A64("vptestmd (%r9,%r8),%zmm14,%k2{%k4}", 0x62, 0x92, 0x0d, 0x4c, 0x27, 0x14, 0x01);
    FCML_I64("vptestmd k7{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x92, 0x0d, 0x4c, 0x27, 0x3c, 0x01);
    /* bcast */
    FCML_I32("vptestmd k0,xmm2,dword ptr [esp+00000080h]{1to4}", 0x62, 0xf2, 0x6d, 0x18, 0x27, 0x44, 0x24, 0x20);
}

void fcml_tf_instruction_VPTESTMQ(void) {
    /* xmm1, xmm2, m128 */
    FCML_A64("vptestmq (%rax),%xmm7,%k0", 0x62, 0xf2, 0xC5, 0x08, 0x27, 0x00);
    FCML_I64("vptestmq k7,xmm7,xmmword ptr [rax]", 0x62, 0xf2, 0xC5, 0x08, 0x27, 0x38);
    /* ymm1, ymm2, m256 */
    FCML_A64("vptestmq (%rax),%ymm7,%k0", 0x62, 0xf2, 0xC5, 0x28, 0x27, 0x00);
    FCML_I64("vptestmq k0,ymm7,ymmword ptr [rax]", 0x62, 0xf2, 0xC5, 0x28, 0x27, 0x00);
    /* zmm1, zmm2, m512 */
    FCML_A64("vptestmq (%rax),%zmm7,%k7", 0x62, 0xf2, 0xC5, 0x48, 0x27, 0x38);
    FCML_I64("vptestmq k7,zmm7,zmmword ptr [rax]", 0x62, 0xf2, 0xC5, 0x48, 0x27, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64("vptestmq %xmm1,%xmm7,%k3", 0x62, 0xf2, 0xC5, 0x08, 0x27, 0xd9);
    FCML_I64("vptestmq k3,xmm7,xmm1", 0x62, 0xf2, 0xC5, 0x08, 0x27, 0xd9);
    /* ymm1, ymm2, ymm3 */
    FCML_A64("vptestmq %ymm6,%ymm7,%k1", 0x62, 0xf2, 0xC5, 0x28, 0x27, 0xce);
    FCML_I64("vptestmq k1,ymm7,ymm6", 0x62, 0xf2, 0xC5, 0x28, 0x27, 0xce);
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vptestmq %zmm4,%zmm15,%k2", 0x62, 0xf2, 0x85, 0x48, 0x27, 0xd4);
    FCML_I64("vptestmq k2,zmm15,zmm4", 0x62, 0xf2, 0x85, 0x48, 0x27, 0xd4);
    /* disp8 */
    FCML_I32("vptestmq k0,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf2, 0xED, 0x48, 0x27, 0x44, 0x24, 0x08);
    FCML_A32("vptestmq 0x00000200(%esp),%zmm2,%k2", 0x62, 0xf2, 0xED, 0x48, 0x27, 0x54, 0x24, 0x08);
    FCML_I32("vptestmq k1,ymm2,ymmword ptr [esp+00000100h]", 0x62, 0xf2, 0xED, 0x28, 0x27, 0x4c, 0x24, 0x08);
    FCML_A32("vptestmq 0x00000100(%esp),%ymm2,%k4", 0x62, 0xf2, 0xED, 0x28, 0x27, 0x64, 0x24, 0x08);
    FCML_I32("vptestmq k0,xmm2,xmmword ptr [esp+00000080h]", 0x62, 0xf2, 0xED, 0x08, 0x27, 0x44, 0x24, 0x08);
    FCML_A32("vptestmq 0x00000080(%esp),%xmm2,%k3", 0x62, 0xf2, 0xED, 0x08, 0x27, 0x5c, 0x24, 0x08);
    /* {k} */
    FCML_A64("vptestmq (%r9,%r8),%xmm14,%k1{%k4}", 0x62, 0x92, 0x8D, 0x0c, 0x27, 0x0c, 0x01);
    FCML_I64("vptestmq k0{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x92, 0x8D, 0x0c, 0x27, 0x04, 0x01);
    FCML_A64("vptestmq (%r9,%r8),%ymm14,%k0{%k4}", 0x62, 0x92, 0x8D, 0x2c, 0x27, 0x04, 0x01);
    FCML_I64("vptestmq k1{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x92, 0x8D, 0x2c, 0x27, 0x0c, 0x01);
    FCML_A64("vptestmq (%r9,%r8),%zmm14,%k2{%k4}", 0x62, 0x92, 0x8D, 0x4c, 0x27, 0x14, 0x01);
    FCML_I64("vptestmq k7{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x92, 0x8D, 0x4c, 0x27, 0x3c, 0x01);
    /* bcast */
    FCML_I32("vptestmq k0,xmm2,mmword ptr [esp+00000080h]{1to2}", 0x62, 0xf2, 0xed, 0x18, 0x27, 0x44, 0x24, 0x10);
}

void fcml_tf_instruction_VPTESTNMB(void) {
    /* xmm1, xmm2, m128 */
    FCML_A64("vptestnmb (%rax),%xmm7,%k0", 0x62, 0xf2, 0x46, 0x08, 0x26, 0x00);
    FCML_I64("vptestnmb k7,xmm7,xmmword ptr [rax]", 0x62, 0xf2, 0x46, 0x08, 0x26, 0x38);
    /* ymm1, ymm2, m256 */
    FCML_A64("vptestnmb (%rax),%ymm7,%k0", 0x62, 0xf2, 0x46, 0x28, 0x26, 0x00);
    FCML_I64("vptestnmb k0,ymm7,ymmword ptr [rax]", 0x62, 0xf2, 0x46, 0x28, 0x26, 0x00);
    /* zmm1, zmm2, m512 */
    FCML_A64("vptestnmb (%rax),%zmm7,%k7", 0x62, 0xf2, 0x46, 0x48, 0x26, 0x38);
    FCML_I64("vptestnmb k7,zmm7,zmmword ptr [rax]", 0x62, 0xf2, 0x46, 0x48, 0x26, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64("vptestnmb %xmm1,%xmm7,%k3", 0x62, 0xf2, 0x46, 0x08, 0x26, 0xd9);
    FCML_I64("vptestnmb k3,xmm7,xmm1", 0x62, 0xf2, 0x46, 0x08, 0x26, 0xd9);
    /* ymm1, ymm2, ymm3 */
    FCML_A64("vptestnmb %ymm6,%ymm7,%k1", 0x62, 0xf2, 0x46, 0x28, 0x26, 0xce);
    FCML_I64("vptestnmb k1,ymm7,ymm6", 0x62, 0xf2, 0x46, 0x28, 0x26, 0xce);
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vptestnmb %zmm4,%zmm15,%k2", 0x62, 0xf2, 0x06, 0x48, 0x26, 0xd4);
    FCML_I64("vptestnmb k2,zmm15,zmm4", 0x62, 0xf2, 0x06, 0x48, 0x26, 0xd4);
    /* disp8 */
    FCML_I32("vptestnmb k0,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf2, 0x6E, 0x48, 0x26, 0x44, 0x24, 0x08);
    FCML_A32("vptestnmb 0x00000200(%esp),%zmm2,%k2", 0x62, 0xf2, 0x6E, 0x48, 0x26, 0x54, 0x24, 0x08);
    FCML_I32("vptestnmb k1,ymm2,ymmword ptr [esp+00000100h]", 0x62, 0xf2, 0x6E, 0x28, 0x26, 0x4c, 0x24, 0x08);
    FCML_A32("vptestnmb 0x00000100(%esp),%ymm2,%k4", 0x62, 0xf2, 0x6E, 0x28, 0x26, 0x64, 0x24, 0x08);
    FCML_I32("vptestnmb k0,xmm2,xmmword ptr [esp+00000080h]", 0x62, 0xf2, 0x6E, 0x08, 0x26, 0x44, 0x24, 0x08);
    FCML_A32("vptestnmb 0x00000080(%esp),%xmm2,%k3", 0x62, 0xf2, 0x6E, 0x08, 0x26, 0x5c, 0x24, 0x08);
    /* {k} */
    FCML_A64("vptestnmb (%r9,%r8),%xmm14,%k1{%k4}", 0x62, 0x92, 0x0E, 0x0c, 0x26, 0x0c, 0x01);
    FCML_I64("vptestnmb k0{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x92, 0x0E, 0x0c, 0x26, 0x04, 0x01);
    FCML_A64("vptestnmb (%r9,%r8),%ymm14,%k0{%k4}", 0x62, 0x92, 0x0E, 0x2c, 0x26, 0x04, 0x01);
    FCML_I64("vptestnmb k1{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x92, 0x0E, 0x2c, 0x26, 0x0c, 0x01);
    FCML_A64("vptestnmb (%r9,%r8),%zmm14,%k2{%k4}", 0x62, 0x92, 0x0E, 0x4c, 0x26, 0x14, 0x01);
    FCML_I64("vptestnmb k7{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x92, 0x0E, 0x4c, 0x26, 0x3c, 0x01);
}

void fcml_tf_instruction_VPTESTNMW(void) {
    /* xmm1, xmm2, m128 */
    FCML_A64("vptestnmw (%rax),%xmm7,%k0", 0x62, 0xf2, 0xC6, 0x08, 0x26, 0x00);
    FCML_I64("vptestnmw k7,xmm7,xmmword ptr [rax]", 0x62, 0xf2, 0xC6, 0x08, 0x26, 0x38);
    /* ymm1, ymm2, m256 */
    FCML_A64("vptestnmw (%rax),%ymm7,%k0", 0x62, 0xf2, 0xC6, 0x28, 0x26, 0x00);
    FCML_I64("vptestnmw k0,ymm7,ymmword ptr [rax]", 0x62, 0xf2, 0xC6, 0x28, 0x26, 0x00);
    /* zmm1, zmm2, m512 */
    FCML_A64("vptestnmw (%rax),%zmm7,%k7", 0x62, 0xf2, 0xC6, 0x48, 0x26, 0x38);
    FCML_I64("vptestnmw k7,zmm7,zmmword ptr [rax]", 0x62, 0xf2, 0xC6, 0x48, 0x26, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64("vptestnmw %xmm1,%xmm7,%k3", 0x62, 0xf2, 0xC6, 0x08, 0x26, 0xd9);
    FCML_I64("vptestnmw k3,xmm7,xmm1", 0x62, 0xf2, 0xC6, 0x08, 0x26, 0xd9);
    /* ymm1, ymm2, ymm3 */
    FCML_A64("vptestnmw %ymm6,%ymm7,%k1", 0x62, 0xf2, 0xC6, 0x28, 0x26, 0xce);
    FCML_I64("vptestnmw k1,ymm7,ymm6", 0x62, 0xf2, 0xC6, 0x28, 0x26, 0xce);
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vptestnmw %zmm4,%zmm15,%k2", 0x62, 0xf2, 0x86, 0x48, 0x26, 0xd4);
    FCML_I64("vptestnmw k2,zmm15,zmm4", 0x62, 0xf2, 0x86, 0x48, 0x26, 0xd4);
    /* disp8 */
    FCML_I32("vptestnmw k0,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf2, 0xEE, 0x48, 0x26, 0x44, 0x24, 0x08);
    FCML_A32("vptestnmw 0x00000200(%esp),%zmm2,%k2", 0x62, 0xf2, 0xEE, 0x48, 0x26, 0x54, 0x24, 0x08);
    FCML_I32("vptestnmw k1,ymm2,ymmword ptr [esp+00000100h]", 0x62, 0xf2, 0xEE, 0x28, 0x26, 0x4c, 0x24, 0x08);
    FCML_A32("vptestnmw 0x00000100(%esp),%ymm2,%k4", 0x62, 0xf2, 0xEE, 0x28, 0x26, 0x64, 0x24, 0x08);
    FCML_I32("vptestnmw k0,xmm2,xmmword ptr [esp+00000080h]", 0x62, 0xf2, 0xEE, 0x08, 0x26, 0x44, 0x24, 0x08);
    FCML_A32("vptestnmw 0x00000080(%esp),%xmm2,%k3", 0x62, 0xf2, 0xEE, 0x08, 0x26, 0x5c, 0x24, 0x08);
    /* {k} */
    FCML_A64("vptestnmw (%r9,%r8),%xmm14,%k1{%k4}", 0x62, 0x92, 0x8E, 0x0c, 0x26, 0x0c, 0x01);
    FCML_I64("vptestnmw k0{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x92, 0x8E, 0x0c, 0x26, 0x04, 0x01);
    FCML_A64("vptestnmw (%r9,%r8),%ymm14,%k0{%k4}", 0x62, 0x92, 0x8E, 0x2c, 0x26, 0x04, 0x01);
    FCML_I64("vptestnmw k1{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x92, 0x8E, 0x2c, 0x26, 0x0c, 0x01);
    FCML_A64("vptestnmw (%r9,%r8),%zmm14,%k2{%k4}", 0x62, 0x92, 0x8E, 0x4c, 0x26, 0x14, 0x01);
    FCML_I64("vptestnmw k7{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x92, 0x8E, 0x4c, 0x26, 0x3c, 0x01);
}

void fcml_tf_instruction_VPTESTNMD(void) {
    /* xmm1, xmm2, m128 */
    FCML_A64("vptestnmd (%rax),%xmm7,%k0", 0x62, 0xf2, 0x46, 0x08, 0x27, 0x00);
    FCML_I64("vptestnmd k7,xmm7,xmmword ptr [rax]", 0x62, 0xf2, 0x46, 0x08, 0x27, 0x38);
    /* ymm1, ymm2, m256 */
    FCML_A64("vptestnmd (%rax),%ymm7,%k0", 0x62, 0xf2, 0x46, 0x28, 0x27, 0x00);
    FCML_I64("vptestnmd k0,ymm7,ymmword ptr [rax]", 0x62, 0xf2, 0x46, 0x28, 0x27, 0x00);
    /* zmm1, zmm2, m512 */
    FCML_A64("vptestnmd (%rax),%zmm7,%k7", 0x62, 0xf2, 0x46, 0x48, 0x27, 0x38);
    FCML_I64("vptestnmd k7,zmm7,zmmword ptr [rax]", 0x62, 0xf2, 0x46, 0x48, 0x27, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64("vptestnmd %xmm1,%xmm7,%k3", 0x62, 0xf2, 0x46, 0x08, 0x27, 0xd9);
    FCML_I64("vptestnmd k3,xmm7,xmm1", 0x62, 0xf2, 0x46, 0x08, 0x27, 0xd9);
    /* ymm1, ymm2, ymm3 */
    FCML_A64("vptestnmd %ymm6,%ymm7,%k1", 0x62, 0xf2, 0x46, 0x28, 0x27, 0xce);
    FCML_I64("vptestnmd k1,ymm7,ymm6", 0x62, 0xf2, 0x46, 0x28, 0x27, 0xce);
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vptestnmd %zmm4,%zmm15,%k2", 0x62, 0xf2, 0x06, 0x48, 0x27, 0xd4);
    FCML_I64("vptestnmd k2,zmm15,zmm4", 0x62, 0xf2, 0x06, 0x48, 0x27, 0xd4);
    /* disp8 */
    FCML_I32("vptestnmd k0,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf2, 0x6E, 0x48, 0x27, 0x44, 0x24, 0x08);
    FCML_A32("vptestnmd 0x00000200(%esp),%zmm2,%k2", 0x62, 0xf2, 0x6E, 0x48, 0x27, 0x54, 0x24, 0x08);
    FCML_I32("vptestnmd k1,ymm2,ymmword ptr [esp+00000100h]", 0x62, 0xf2, 0x6E, 0x28, 0x27, 0x4c, 0x24, 0x08);
    FCML_A32("vptestnmd 0x00000100(%esp),%ymm2,%k4", 0x62, 0xf2, 0x6E, 0x28, 0x27, 0x64, 0x24, 0x08);
    FCML_I32("vptestnmd k0,xmm2,xmmword ptr [esp+00000080h]", 0x62, 0xf2, 0x6E, 0x08, 0x27, 0x44, 0x24, 0x08);
    FCML_A32("vptestnmd 0x00000080(%esp),%xmm2,%k3", 0x62, 0xf2, 0x6E, 0x08, 0x27, 0x5c, 0x24, 0x08);
    /* {k} */
    FCML_A64("vptestnmd (%r9,%r8),%xmm14,%k1{%k4}", 0x62, 0x92, 0x0E, 0x0c, 0x27, 0x0c, 0x01);
    FCML_I64("vptestnmd k0{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x92, 0x0E, 0x0c, 0x27, 0x04, 0x01);
    FCML_A64("vptestnmd (%r9,%r8),%ymm14,%k0{%k4}", 0x62, 0x92, 0x0E, 0x2c, 0x27, 0x04, 0x01);
    FCML_I64("vptestnmd k1{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x92, 0x0E, 0x2c, 0x27, 0x0c, 0x01);
    FCML_A64("vptestnmd (%r9,%r8),%zmm14,%k2{%k4}", 0x62, 0x92, 0x0E, 0x4c, 0x27, 0x14, 0x01);
    FCML_I64("vptestnmd k7{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x92, 0x0E, 0x4c, 0x27, 0x3c, 0x01);
    /* bcast */
    FCML_I32("vptestnmd k0,xmm2,dword ptr [esp+00000080h]{1to4}", 0x62, 0xf2, 0x6E, 0x18, 0x27, 0x44, 0x24, 0x20);
}

void fcml_tf_instruction_VPTESTNMQ(void) {
    /* xmm1, xmm2, m128 */
    FCML_A64("vptestnmq (%rax),%xmm7,%k0", 0x62, 0xf2, 0xC6, 0x08, 0x27, 0x00);
    FCML_I64("vptestnmq k7,xmm7,xmmword ptr [rax]", 0x62, 0xf2, 0xC6, 0x08, 0x27, 0x38);
    /* ymm1, ymm2, m256 */
    FCML_A64("vptestnmq (%rax),%ymm7,%k0", 0x62, 0xf2, 0xC6, 0x28, 0x27, 0x00);
    FCML_I64("vptestnmq k0,ymm7,ymmword ptr [rax]", 0x62, 0xf2, 0xC6, 0x28, 0x27, 0x00);
    /* zmm1, zmm2, m512 */
    FCML_A64("vptestnmq (%rax),%zmm7,%k7", 0x62, 0xf2, 0xC6, 0x48, 0x27, 0x38);
    FCML_I64("vptestnmq k7,zmm7,zmmword ptr [rax]", 0x62, 0xf2, 0xC6, 0x48, 0x27, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64("vptestnmq %xmm1,%xmm7,%k3", 0x62, 0xf2, 0xC6, 0x08, 0x27, 0xd9);
    FCML_I64("vptestnmq k3,xmm7,xmm1", 0x62, 0xf2, 0xC6, 0x08, 0x27, 0xd9);
    /* ymm1, ymm2, ymm3 */
    FCML_A64("vptestnmq %ymm6,%ymm7,%k1", 0x62, 0xf2, 0xC6, 0x28, 0x27, 0xce);
    FCML_I64("vptestnmq k1,ymm7,ymm6", 0x62, 0xf2, 0xC6, 0x28, 0x27, 0xce);
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vptestnmq %zmm4,%zmm15,%k2", 0x62, 0xf2, 0x86, 0x48, 0x27, 0xd4);
    FCML_I64("vptestnmq k2,zmm15,zmm4", 0x62, 0xf2, 0x86, 0x48, 0x27, 0xd4);
    /* disp8 */
    FCML_I32("vptestnmq k0,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf2, 0xEE, 0x48, 0x27, 0x44, 0x24, 0x08);
    FCML_A32("vptestnmq 0x00000200(%esp),%zmm2,%k2", 0x62, 0xf2, 0xEE, 0x48, 0x27, 0x54, 0x24, 0x08);
    FCML_I32("vptestnmq k1,ymm2,ymmword ptr [esp+00000100h]", 0x62, 0xf2, 0xEE, 0x28, 0x27, 0x4c, 0x24, 0x08);
    FCML_A32("vptestnmq 0x00000100(%esp),%ymm2,%k4", 0x62, 0xf2, 0xEE, 0x28, 0x27, 0x64, 0x24, 0x08);
    FCML_I32("vptestnmq k0,xmm2,xmmword ptr [esp+00000080h]", 0x62, 0xf2, 0xEE, 0x08, 0x27, 0x44, 0x24, 0x08);
    FCML_A32("vptestnmq 0x00000080(%esp),%xmm2,%k3", 0x62, 0xf2, 0xEE, 0x08, 0x27, 0x5c, 0x24, 0x08);
    /* {k} */
    FCML_A64("vptestnmq (%r9,%r8),%xmm14,%k1{%k4}", 0x62, 0x92, 0x8E, 0x0c, 0x27, 0x0c, 0x01);
    FCML_I64("vptestnmq k0{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x92, 0x8E, 0x0c, 0x27, 0x04, 0x01);
    FCML_A64("vptestnmq (%r9,%r8),%ymm14,%k0{%k4}", 0x62, 0x92, 0x8E, 0x2c, 0x27, 0x04, 0x01);
    FCML_I64("vptestnmq k1{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x92, 0x8E, 0x2c, 0x27, 0x0c, 0x01);
    FCML_A64("vptestnmq (%r9,%r8),%zmm14,%k2{%k4}", 0x62, 0x92, 0x8E, 0x4c, 0x27, 0x14, 0x01);
    FCML_I64("vptestnmq k7{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x92, 0x8E, 0x4c, 0x27, 0x3c, 0x01);
    /* bcast */
    FCML_I32("vptestnmq k0,xmm2,mmword ptr [esp+00000080h]{1to2}", 0x62, 0xf2, 0xEE, 0x18, 0x27, 0x44, 0x24, 0x10);
}

void fcml_tf_instruction_VRANGEPD(void) {
    /* xmm1, xmm2, m128 */
    FCML_A64("vrangepd $0x14,(%rax),%xmm7,%xmm15", 0x62, 0x73, 0xc5, 0x08, 0x50, 0x38, 0x14);
    FCML_I64("vrangepd xmm15,xmm7,xmmword ptr [rax],14h", 0x62, 0x73, 0xc5, 0x08, 0x50, 0x38, 0x14);
    FCML_A32("vrangepd $0x14,(%eax),%xmm6,%xmm7", 0x62, 0xf3, 0xcd, 0x08, 0x50, 0x38, 0x14);
    FCML_I32("vrangepd xmm7,xmm6,xmmword ptr [eax],14h", 0x62, 0xf3, 0xcd, 0x08, 0x50, 0x38, 0x14);
    /* ymm1, ymm2, m256 */
    FCML_A64("vrangepd $0x14,(%rax),%ymm7,%ymm15", 0x62, 0x73, 0xc5, 0x28, 0x50, 0x38, 0x14);
    FCML_I64("vrangepd ymm15,ymm7,ymmword ptr [rax],14h", 0x62, 0x73, 0xc5, 0x28, 0x50, 0x38, 0x14);
    FCML_A32("vrangepd $0x14,(%eax),%ymm5,%ymm7", 0x62, 0xf3, 0xd5, 0x28, 0x50, 0x38, 0x14);
    FCML_I32("vrangepd ymm7,ymm5,ymmword ptr [eax],14h", 0x62, 0xf3, 0xd5, 0x28, 0x50, 0x38, 0x14);
    /* zmm1, zmm2, m512 */
    FCML_A64("vrangepd $0x14,(%rax),%zmm7,%zmm15", 0x62, 0x73, 0xc5, 0x48, 0x50, 0x38, 0x14);
    FCML_I64("vrangepd zmm15,zmm7,zmmword ptr [rax],14h", 0x62, 0x73, 0xc5, 0x48, 0x50, 0x38, 0x14);
    FCML_A32("vrangepd $0x14,(%eax),%zmm3,%zmm7", 0x62, 0xf3, 0xe5, 0x48, 0x50, 0x38, 0x14);
    FCML_I32("vrangepd zmm7,zmm3,zmmword ptr [eax],14h", 0x62, 0xf3, 0xe5, 0x48, 0x50, 0x38, 0x14);
    /* xmm1, xmm2, xmm3 */
    FCML_A64("vrangepd $0x14,%xmm1,%xmm7,%xmm15", 0x62, 0x73, 0xc5, 0x08, 0x50, 0xf9, 0x14);
    FCML_I64("vrangepd xmm15,xmm7,xmm1,14h", 0x62, 0x73, 0xc5, 0x08, 0x50, 0xf9, 0x14);
    FCML_A32("vrangepd $0x14,%xmm1,%xmm2,%xmm7", 0x62, 0xf3, 0xed, 0x08, 0x50, 0xf9, 0x14);
    FCML_I32("vrangepd xmm7,xmm2,xmm1,14h", 0x62, 0xf3, 0xed, 0x08, 0x50, 0xf9, 0x14);
    /* ymm1, ymm2, ymm3 */
    FCML_A64("vrangepd $0x14,%ymm6,%ymm7,%ymm14", 0x62, 0x73, 0xc5, 0x28, 0x50, 0xf6, 0x14);
    FCML_I64("vrangepd ymm14,ymm7,ymm6,14h", 0x62, 0x73, 0xc5, 0x28, 0x50, 0xf6, 0x14);
    FCML_A32("vrangepd $0x14,%ymm5,%ymm3,%ymm6", 0x62, 0xf3, 0xe5, 0x28, 0x50, 0xf5, 0x14);
    FCML_I32("vrangepd ymm6,ymm3,ymm5,14h", 0x62, 0xf3, 0xe5, 0x28, 0x50, 0xf5, 0x14);
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vrangepd $0x14,%zmm4,%zmm15,%zmm6", 0x62, 0xf3, 0x85, 0x48, 0x50, 0xf4, 0x14);
    FCML_I64("vrangepd zmm6,zmm15,zmm4,14h", 0x62, 0xf3, 0x85, 0x48, 0x50, 0xf4, 0x14);
    FCML_A32("vrangepd $0x14,%zmm4,%zmm6,%zmm6", 0x62, 0xf3, 0xcd, 0x48, 0x50, 0xf4, 0x14);
    FCML_I32("vrangepd zmm6,zmm6,zmm4,14h", 0x62, 0xf3, 0xcd, 0x48, 0x50, 0xf4, 0x14);
    /* disp8 */
    FCML_I32("vrangepd zmm1,zmm2,zmmword ptr [esp+00000200h],14h", 0x62, 0xf3, 0xed, 0x48, 0x50, 0x4c, 0x24, 0x08, 0x14);
    FCML_A32("vrangepd $0x14,0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf3, 0xed, 0x48, 0x50, 0x4c, 0x24, 0x08, 0x14);
    FCML_I64("vrangepd zmm1,zmm2,zmmword ptr [rsp+0000000000000200h],14h", 0x62, 0xf3, 0xed, 0x48, 0x50, 0x4c, 0x24, 0x08, 0x14);
    FCML_A64("vrangepd $0x14,0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf3, 0xed, 0x48, 0x50, 0x4c, 0x24, 0x08, 0x14);
    FCML_I32("vrangepd ymm1,ymm2,ymmword ptr [esp+00000100h],14h", 0x62, 0xf3, 0xed, 0x28, 0x50, 0x4c, 0x24, 0x08, 0x14);
    FCML_A32("vrangepd $0x14,0x00000100(%esp),%ymm2,%ymm1", 0x62, 0xf3, 0xed, 0x28, 0x50, 0x4c, 0x24, 0x08, 0x14);
    FCML_I64("vrangepd ymm1,ymm2,ymmword ptr [rsp+0000000000000100h],14h", 0x62, 0xf3, 0xed, 0x28, 0x50, 0x4c, 0x24, 0x08, 0x14);
    FCML_A64("vrangepd $0x14,0x0000000000000100(%rsp),%ymm2,%ymm1", 0x62, 0xf3, 0xed, 0x28, 0x50, 0x4c, 0x24, 0x08, 0x14);
    FCML_I32("vrangepd xmm1,xmm2,xmmword ptr [esp+00000080h],14h", 0x62, 0xf3, 0xed, 0x08, 0x50, 0x4c, 0x24, 0x08, 0x14);
    FCML_A32("vrangepd $0x14,0x00000080(%esp),%xmm2,%xmm1", 0x62, 0xf3, 0xed, 0x08, 0x50, 0x4c, 0x24, 0x08, 0x14);
    FCML_I64("vrangepd xmm1,xmm2,xmmword ptr [rsp+0000000000000080h],14h", 0x62, 0xf3, 0xed, 0x08, 0x50, 0x4c, 0x24, 0x08, 0x14);
    FCML_A64("vrangepd $0x14,0x0000000000000080(%rsp),%xmm2,%xmm1", 0x62, 0xf3, 0xed, 0x08, 0x50, 0x4c, 0x24, 0x08, 0x14);
    /* {k}{z} */
    FCML_A64("vrangepd $0x14,(%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x13, 0x8d, 0x8c, 0x50, 0x14, 0x01, 0x14);
    FCML_I64("vrangepd xmm10{k4}{z},xmm14,xmmword ptr [r9+r8],14h", 0x62, 0x13, 0x8d, 0x8c, 0x50, 0x14, 0x01, 0x14);
    FCML_A32("vrangepd $0x14,(%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf3, 0xc5, 0x8d, 0x50, 0x14, 0x01, 0x14);
    FCML_I32("vrangepd xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax],14h", 0x62, 0xf3, 0xc5, 0x8d, 0x50, 0x14, 0x01, 0x14);
    FCML_A64("vrangepd $0x14,(%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x13, 0x8d, 0xac, 0x50, 0x14, 0x01, 0x14);
    FCML_I64("vrangepd ymm10{k4}{z},ymm14,ymmword ptr [r9+r8],14h", 0x62, 0x13, 0x8d, 0xac, 0x50, 0x14, 0x01, 0x14);
    FCML_A32("vrangepd $0x14,(%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf3, 0xc5, 0xad, 0x50, 0x14, 0x01, 0x14);
    FCML_I32("vrangepd ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax],14h", 0x62, 0xf3, 0xc5, 0xad, 0x50, 0x14, 0x01, 0x14);
    FCML_A64("vrangepd $0x14,(%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x13, 0x8d, 0xcc, 0x50, 0x14, 0x01, 0x14);
    FCML_I64("vrangepd zmm10{k4}{z},zmm14,zmmword ptr [r9+r8],14h", 0x62, 0x13, 0x8d, 0xcc, 0x50, 0x14, 0x01, 0x14);
    FCML_A32("vrangepd $0x14,(%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf3, 0xc5, 0xcd, 0x50, 0x14, 0x01, 0x14);
    FCML_I32("vrangepd zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax],14h", 0x62, 0xf3, 0xc5, 0xcd, 0x50, 0x14, 0x01, 0x14);
    /* {sae} */
    FCML_I64("vrangepd zmm10{k4}{z},zmm14,zmm13,{sae},14h", 0x62, 0x53, 0x8d, 0x9c, 0x50, 0xd5, 0x14);
    /* {k} */
    FCML_A64("vrangepd $0x14,(%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x13, 0x8d, 0x0c, 0x50, 0x14, 0x01, 0x14);
    FCML_I64("vrangepd xmm10{k4},xmm14,xmmword ptr [r9+r8],14h", 0x62, 0x13, 0x8d, 0x0c, 0x50, 0x14, 0x01, 0x14);
    FCML_A32("vrangepd $0x14,(%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf3, 0xc5, 0x0d, 0x50, 0x14, 0x01, 0x14);
    FCML_I32("vrangepd xmm2{k5},xmm7,xmmword ptr [ecx+eax],14h", 0x62, 0xf3, 0xc5, 0x0d, 0x50, 0x14, 0x01, 0x14);
    FCML_A64("vrangepd $0x14,(%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x13, 0x8d, 0x2c, 0x50, 0x14, 0x01, 0x14);
    FCML_I64("vrangepd ymm10{k4},ymm14,ymmword ptr [r9+r8],14h", 0x62, 0x13, 0x8d, 0x2c, 0x50, 0x14, 0x01, 0x14);
    FCML_A32("vrangepd $0x14,(%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf3, 0xc5, 0x2d, 0x50, 0x14, 0x01, 0x14);
    FCML_I32("vrangepd ymm2{k5},ymm7,ymmword ptr [ecx+eax],14h", 0x62, 0xf3, 0xc5, 0x2d, 0x50, 0x14, 0x01, 0x14);
    FCML_A64("vrangepd $0x14,(%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x13, 0x8d, 0x4c, 0x50, 0x14, 0x01, 0x14);
    FCML_I64("vrangepd zmm10{k4},zmm14,zmmword ptr [r9+r8],14h", 0x62, 0x13, 0x8d, 0x4c, 0x50, 0x14, 0x01, 0x14);
    FCML_A32("vrangepd $0x14,(%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf3, 0xc5, 0x4d, 0x50, 0x14, 0x01, 0x14);
    FCML_I32("vrangepd zmm2{k5},zmm7,zmmword ptr [ecx+eax],14h", 0x62, 0xf3, 0xc5, 0x4d, 0x50, 0x14, 0x01, 0x14);
    /* bcast */
    FCML_I64("vrangepd zmm31,zmm21,mmword ptr [rsi]{1to8},14h", 0x62, 0x63, 0xd5, 0x50, 0x50, 0x3e, 0x14);
    FCML_A64("vrangepd $0x14,(%rsi){1to8},%zmm21,%zmm31", 0x62, 0x63, 0xd5, 0x50, 0x50, 0x3e, 0x14);
    FCML_I64("vrangepd ymm31,ymm21,mmword ptr [rsi]{1to4},14h", 0x62, 0x63, 0xd5, 0x30, 0x50, 0x3e, 0x14);
    FCML_A64("vrangepd $0x14,(%rsi){1to4},%ymm21,%ymm31", 0x62, 0x63, 0xd5, 0x30, 0x50, 0x3e, 0x14);
    FCML_I64("vrangepd xmm31,xmm21,mmword ptr [rsi]{1to2},14h", 0x62, 0x63, 0xd5, 0x10, 0x50, 0x3e, 0x14);
    FCML_A64("vrangepd $0x14,(%rsi){1to2},%xmm21,%xmm31", 0x62, 0x63, 0xd5, 0x10, 0x50, 0x3e, 0x14);
    FCML_A32("vrangepd $0x14,(%esi){1to8},%zmm2,%zmm1", 0x62, 0xf3, 0xed, 0x58, 0x50, 0x0e, 0x14);
    FCML_I32("vrangepd zmm1,zmm2,mmword ptr [esi]{1to8},14h", 0x62, 0xf3, 0xed, 0x58, 0x50, 0x0e, 0x14);
    /* {k}{z}{bcast} */
    FCML_A64("vrangepd $0x14,(%rsi){1to4},%ymm21,%ymm31{%k7}{z}", 0x62, 0x63, 0xd5, 0xb7, 0x50, 0x3e, 0x14);
    FCML_I64("vrangepd ymm31{k7}{z},ymm21,mmword ptr [rsi]{1to4},14h", 0x62, 0x63, 0xd5, 0xb7, 0x50, 0x3e, 0x14);
    /* {bcast} disp8 */
    FCML_I32("vrangepd zmm1,zmm2,mmword ptr [esp+00000040h]{1to8},14h", 0x62, 0xf3, 0xed, 0x58, 0x50, 0x4c, 0x24, 0x08, 0x14);
    FCML_A32("vrangepd $0x14,0x00000040(%esp){1to8},%zmm2,%zmm1", 0x62, 0xf3, 0xed, 0x58, 0x50, 0x4c, 0x24, 0x08, 0x14);
    FCML_I64("vrangepd zmm1,zmm2,mmword ptr [rsp+0000000000000040h]{1to8},14h", 0x62, 0xf3, 0xed, 0x58, 0x50, 0x4c, 0x24, 0x08, 0x14);
    FCML_A64("vrangepd $0x14,0x0000000000000040(%rsp){1to8},%zmm2,%zmm1", 0x62, 0xf3, 0xed, 0x58, 0x50, 0x4c, 0x24, 0x08, 0x14);
    FCML_I32("vrangepd ymm1,ymm2,mmword ptr [esp+00000040h]{1to4},14h", 0x62, 0xf3, 0xed, 0x38, 0x50, 0x4c, 0x24, 0x08, 0x14);
    FCML_A32("vrangepd $0x14,0x00000040(%esp){1to4},%ymm2,%ymm1", 0x62, 0xf3, 0xed, 0x38, 0x50, 0x4c, 0x24, 0x08, 0x14);
    FCML_I64("vrangepd ymm1,ymm2,mmword ptr [rsp+0000000000000040h]{1to4},14h", 0x62, 0xf3, 0xed, 0x38, 0x50, 0x4c, 0x24, 0x08, 0x14);
    FCML_A64("vrangepd $0x14,0x0000000000000040(%rsp){1to4},%ymm2,%ymm1", 0x62, 0xf3, 0xed, 0x38, 0x50, 0x4c, 0x24, 0x08, 0x14);
    FCML_I32("vrangepd xmm1,xmm2,mmword ptr [esp+00000040h]{1to2},14h", 0x62, 0xf3, 0xed, 0x18, 0x50, 0x4c, 0x24, 0x08, 0x14);
    FCML_A32("vrangepd $0x14,0x00000040(%esp){1to2},%xmm2,%xmm1", 0x62, 0xf3, 0xed, 0x18, 0x50, 0x4c, 0x24, 0x08, 0x14);
    FCML_I64("vrangepd xmm1,xmm2,mmword ptr [rsp+0000000000000040h]{1to2},14h", 0x62, 0xf3, 0xed, 0x18, 0x50, 0x4c, 0x24, 0x08, 0x14);
    FCML_A64("vrangepd $0x14,0x0000000000000040(%rsp){1to2},%xmm2,%xmm1", 0x62, 0xf3, 0xed, 0x18, 0x50, 0x4c, 0x24, 0x08, 0x14);
}

void fcml_tf_instruction_VRANGEPS(void) {
    /* xmm1, xmm2, m128 */
    FCML_A64("vrangeps $0x14,(%rax),%xmm7,%xmm15", 0x62, 0x73, 0x45, 0x08, 0x50, 0x38, 0x14);
    FCML_I64("vrangeps xmm15,xmm7,xmmword ptr [rax],14h", 0x62, 0x73, 0x45, 0x08, 0x50, 0x38, 0x14);
    FCML_A32("vrangeps $0x14,(%eax),%xmm6,%xmm7", 0x62, 0xf3, 0x4d, 0x08, 0x50, 0x38, 0x14);
    FCML_I32("vrangeps xmm7,xmm6,xmmword ptr [eax],14h", 0x62, 0xf3, 0x4d, 0x08, 0x50, 0x38, 0x14);
    /* ymm1, ymm2, m256 */
    FCML_A64("vrangeps $0x14,(%rax),%ymm7,%ymm15", 0x62, 0x73, 0x45, 0x28, 0x50, 0x38, 0x14);
    FCML_I64("vrangeps ymm15,ymm7,ymmword ptr [rax],14h", 0x62, 0x73, 0x45, 0x28, 0x50, 0x38, 0x14);
    FCML_A32("vrangeps $0x14,(%eax),%ymm5,%ymm7", 0x62, 0xf3, 0x55, 0x28, 0x50, 0x38, 0x14);
    FCML_I32("vrangeps ymm7,ymm7,ymmword ptr [eax],14h", 0x62, 0xf3, 0x45, 0x28, 0x50, 0x38, 0x14);
    /* zmm1, zmm2, m512 */
    FCML_A64("vrangeps $0x14,(%rax),%zmm7,%zmm15", 0x62, 0x73, 0x45, 0x48, 0x50, 0x38, 0x14);
    FCML_I64("vrangeps zmm15,zmm7,zmmword ptr [rax],14h", 0x62, 0x73, 0x45, 0x48, 0x50, 0x38, 0x14);
    FCML_A32("vrangeps $0x14,(%eax),%zmm3,%zmm7", 0x62, 0xf3, 0x65, 0x48, 0x50, 0x38, 0x14);
    FCML_I32("vrangeps zmm7,zmm3,zmmword ptr [eax],14h", 0x62, 0xf3, 0x65, 0x48, 0x50, 0x38, 0x14);
    /* xmm1, xmm2, xmm3 */
    FCML_A64("vrangeps $0x14,%xmm1,%xmm7,%xmm15", 0x62, 0x73, 0x45, 0x08, 0x50, 0xf9, 0x14);
    FCML_I64("vrangeps xmm15,xmm7,xmm1,14h", 0x62, 0x73, 0x45, 0x08, 0x50, 0xf9, 0x14);
    FCML_A32("vrangeps $0x14,%xmm1,%xmm2,%xmm7", 0x62, 0xf3, 0x6D, 0x08, 0x50, 0xf9, 0x14);
    FCML_I32("vrangeps xmm7,xmm2,xmm1,14h", 0x62, 0xf3, 0x6D, 0x08, 0x50, 0xf9, 0x14);
    /* ymm1, ymm2, ymm3 */
    FCML_A64("vrangeps $0x14,%ymm6,%ymm7,%ymm14", 0x62, 0x73, 0x45, 0x28, 0x50, 0xf6, 0x14);
    FCML_I64("vrangeps ymm14,ymm7,ymm6,14h", 0x62, 0x73, 0x45, 0x28, 0x50, 0xf6, 0x14);
    FCML_A32("vrangeps $0x14,%ymm5,%ymm3,%ymm6", 0x62, 0xf3, 0x65, 0x28, 0x50, 0xf5, 0x14);
    FCML_I32("vrangeps ymm6,ymm3,ymm5,14h", 0x62, 0xf3, 0x65, 0x28, 0x50, 0xf5, 0x14);
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vrangeps $0x14,%zmm4,%zmm15,%zmm6", 0x62, 0xf3, 0x05, 0x48, 0x50, 0xf4, 0x14);
    FCML_I64("vrangeps zmm6,zmm15,zmm4,14h", 0x62, 0xf3, 0x05, 0x48, 0x50, 0xf4, 0x14);
    FCML_A32("vrangeps $0x14,%zmm4,%zmm6,%zmm6", 0x62, 0xf3, 0x4D, 0x48, 0x50, 0xf4, 0x14);
    FCML_I32("vrangeps zmm6,zmm6,zmm4,14h", 0x62, 0xf3, 0x4D, 0x48, 0x50, 0xf4, 0x14);
    /* disp8 */
    FCML_I32("vrangeps zmm1,zmm2,zmmword ptr [esp+00000200h],14h", 0x62, 0xf3, 0x6D, 0x48, 0x50, 0x4c, 0x24, 0x08, 0x14);
    FCML_A32("vrangeps $0x14,0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf3, 0x6D, 0x48, 0x50, 0x4c, 0x24, 0x08, 0x14);
    FCML_I64("vrangeps zmm1,zmm2,zmmword ptr [rsp+0000000000000200h],14h", 0x62, 0xf3, 0x6D, 0x48, 0x50, 0x4c, 0x24, 0x08, 0x14);
    FCML_A64("vrangeps $0x14,0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf3, 0x6D, 0x48, 0x50, 0x4c, 0x24, 0x08, 0x14);
    FCML_I32("vrangeps ymm1,ymm2,ymmword ptr [esp+00000100h],14h", 0x62, 0xf3, 0x6D, 0x28, 0x50, 0x4c, 0x24, 0x08, 0x14);
    FCML_A32("vrangeps $0x14,0x00000100(%esp),%ymm2,%ymm1", 0x62, 0xf3, 0x6D, 0x28, 0x50, 0x4c, 0x24, 0x08, 0x14);
    FCML_I64("vrangeps ymm1,ymm2,ymmword ptr [rsp+0000000000000100h],14h", 0x62, 0xf3, 0x6D, 0x28, 0x50, 0x4c, 0x24, 0x08, 0x14);
    FCML_A64("vrangeps $0x14,0x0000000000000100(%rsp),%ymm2,%ymm1", 0x62, 0xf3, 0x6D, 0x28, 0x50, 0x4c, 0x24, 0x08, 0x14);
    FCML_I32("vrangeps xmm1,xmm2,xmmword ptr [esp+00000080h],14h", 0x62, 0xf3, 0x6D, 0x08, 0x50, 0x4c, 0x24, 0x08, 0x14);
    FCML_A32("vrangeps $0x14,0x00000080(%esp),%xmm2,%xmm1", 0x62, 0xf3, 0x6D, 0x08, 0x50, 0x4c, 0x24, 0x08, 0x14);
    FCML_I64("vrangeps xmm1,xmm2,xmmword ptr [rsp+0000000000000080h],14h", 0x62, 0xf3, 0x6D, 0x08, 0x50, 0x4c, 0x24, 0x08, 0x14);
    FCML_A64("vrangeps $0x14,0x0000000000000080(%rsp),%xmm2,%xmm1", 0x62, 0xf3, 0x6D, 0x08, 0x50, 0x4c, 0x24, 0x08, 0x14);
    /* {k}{z} */
    FCML_A64("vrangeps $0x14,(%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x13, 0x0D, 0x8c, 0x50, 0x14, 0x01, 0x14);
    FCML_I64("vrangeps xmm10{k4}{z},xmm14,xmmword ptr [r9+r8],14h", 0x62, 0x13, 0x0D, 0x8c, 0x50, 0x14, 0x01, 0x14);
    FCML_A32("vrangeps $0x14,(%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf3, 0x45, 0x8d, 0x50, 0x14, 0x01, 0x14);
    FCML_I32("vrangeps xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax],14h", 0x62, 0xf3, 0x45, 0x8d, 0x50, 0x14, 0x01, 0x14);
    FCML_A64("vrangeps $0x14,(%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x13, 0x0D, 0xac, 0x50, 0x14, 0x01, 0x14);
    FCML_I64("vrangeps ymm10{k4}{z},ymm14,ymmword ptr [r9+r8],14h", 0x62, 0x13, 0x0D, 0xac, 0x50, 0x14, 0x01, 0x14);
    FCML_A32("vrangeps $0x14,(%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf3, 0x45, 0xad, 0x50, 0x14, 0x01, 0x14);
    FCML_I32("vrangeps ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax],14h", 0x62, 0xf3, 0x45, 0xad, 0x50, 0x14, 0x01, 0x14);
    FCML_A64("vrangeps $0x14,(%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x13, 0x0D, 0xcc, 0x50, 0x14, 0x01, 0x14);
    FCML_I64("vrangeps zmm10{k4}{z},zmm14,zmmword ptr [r9+r8],14h", 0x62, 0x13, 0x0D, 0xcc, 0x50, 0x14, 0x01, 0x14);
    FCML_A32("vrangeps $0x14,(%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf3, 0x45, 0xcd, 0x50, 0x14, 0x01, 0x14);
    FCML_I32("vrangeps zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax],14h", 0x62, 0xf3, 0x45, 0xcd, 0x50, 0x14, 0x01, 0x14);
    /* {k} */
    FCML_A64("vrangeps $0x14,(%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x13, 0x0D, 0x0c, 0x50, 0x14, 0x01, 0x14);
    FCML_I64("vrangeps xmm10{k4},xmm14,xmmword ptr [r9+r8],14h", 0x62, 0x13, 0x0D, 0x0c, 0x50, 0x14, 0x01, 0x14);
    FCML_A32("vrangeps $0x14,(%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf3, 0x45, 0x0d, 0x50, 0x14, 0x01, 0x14);
    FCML_I32("vrangeps xmm2{k5},xmm7,xmmword ptr [ecx+eax],14h", 0x62, 0xf3, 0x45, 0x0d, 0x50, 0x14, 0x01, 0x14);
    FCML_A64("vrangeps $0x14,(%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x13, 0x0D, 0x2c, 0x50, 0x14, 0x01, 0x14);
    FCML_I64("vrangeps ymm10{k4},ymm14,ymmword ptr [r9+r8],14h", 0x62, 0x13, 0x0D, 0x2c, 0x50, 0x14, 0x01, 0x14);
    FCML_A32("vrangeps $0x14,(%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf3, 0x45, 0x2d, 0x50, 0x14, 0x01, 0x14);
    FCML_I32("vrangeps ymm2{k5},ymm7,ymmword ptr [ecx+eax],14h", 0x62, 0xf3, 0x45, 0x2d, 0x50, 0x14, 0x01, 0x14);
    FCML_A64("vrangeps $0x14,(%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x13, 0x0D, 0x4c, 0x50, 0x14, 0x01, 0x14);
    FCML_I64("vrangeps zmm10{k4},zmm14,zmmword ptr [r9+r8],14h", 0x62, 0x13, 0x0D, 0x4c, 0x50, 0x14, 0x01, 0x14);
    FCML_A32("vrangeps $0x14,(%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf3, 0x45, 0x4d, 0x50, 0x14, 0x01, 0x14);
    FCML_I32("vrangeps zmm2{k5},zmm7,zmmword ptr [ecx+eax],14h", 0x62, 0xf3, 0x45, 0x4d, 0x50, 0x14, 0x01, 0x14);
    /* {sae} */
    FCML_I64("vrangeps zmm10{k4}{z},zmm14,zmm13,{sae},14h", 0x62, 0x53, 0x0d, 0x9c, 0x50, 0xd5, 0x14);
    /* bcast */
    FCML_I64("vrangeps zmm31,zmm21,dword ptr [rsi]{1to16},14h", 0x62, 0x63, 0x55, 0x50, 0x50, 0x3e, 0x14);
    FCML_A64("vrangeps $0x14,(%rsi){1to16},%zmm21,%zmm31", 0x62, 0x63, 0x55, 0x50, 0x50, 0x3e, 0x14);
    FCML_I64("vrangeps ymm31,ymm21,dword ptr [rsi]{1to8},14h", 0x62, 0x63, 0x55, 0x30, 0x50, 0x3e, 0x14);
    FCML_A64("vrangeps $0x14,(%rsi){1to8},%ymm21,%ymm31", 0x62, 0x63, 0x55, 0x30, 0x50, 0x3e, 0x14);
    FCML_I64("vrangeps xmm31,xmm21,dword ptr [rsi]{1to4},14h", 0x62, 0x63, 0x55, 0x10, 0x50, 0x3e, 0x14);
    FCML_A64("vrangeps $0x14,(%rsi){1to4},%xmm21,%xmm31", 0x62, 0x63, 0x55, 0x10, 0x50, 0x3e, 0x14);
    FCML_A32("vrangeps $0x14,(%esi){1to16},%zmm2,%zmm1", 0x62, 0xf3, 0x6D, 0x58, 0x50, 0x0e, 0x14);
    FCML_I32("vrangeps zmm1,zmm2,dword ptr [esi]{1to16},14h", 0x62, 0xf3, 0x6D, 0x58, 0x50, 0x0e, 0x14);
    /* {k}{z}{bcast} */
    FCML_A64("vrangeps $0x14,(%rsi){1to8},%ymm21,%ymm31{%k7}{z}", 0x62, 0x63, 0x55, 0xb7, 0x50, 0x3e, 0x14);
    FCML_I64("vrangeps ymm31{k7}{z},ymm21,dword ptr [rsi]{1to8},14h", 0x62, 0x63, 0x55, 0xb7, 0x50, 0x3e, 0x14);
    /* {bcast} disp8 */
    FCML_I32("vrangeps zmm1,zmm2,dword ptr [esp+00000020h]{1to16},14h", 0x62, 0xf3, 0x6D, 0x58, 0x50, 0x4c, 0x24, 0x08, 0x14);
    FCML_A32("vrangeps $0x14,0x00000020(%esp){1to16},%zmm2,%zmm1", 0x62, 0xf3, 0x6D, 0x58, 0x50, 0x4c, 0x24, 0x08, 0x14);
    FCML_I64("vrangeps zmm1,zmm2,dword ptr [rsp+0000000000000020h]{1to16},14h", 0x62, 0xf3, 0x6D, 0x58, 0x50, 0x4c, 0x24, 0x08, 0x14);
    FCML_A64("vrangeps $0x14,0x0000000000000020(%rsp){1to16},%zmm2,%zmm1", 0x62, 0xf3, 0x6D, 0x58, 0x50, 0x4c, 0x24, 0x08, 0x14);
    FCML_I32("vrangeps ymm1,ymm2,dword ptr [esp+00000020h]{1to8},14h", 0x62, 0xf3, 0x6D, 0x38, 0x50, 0x4c, 0x24, 0x08, 0x14);
    FCML_A32("vrangeps $0x14,0x00000020(%esp){1to8},%ymm2,%ymm1", 0x62, 0xf3, 0x6D, 0x38, 0x50, 0x4c, 0x24, 0x08, 0x14);
    FCML_I64("vrangeps ymm1,ymm2,dword ptr [rsp+0000000000000020h]{1to8},14h", 0x62, 0xf3, 0x6D, 0x38, 0x50, 0x4c, 0x24, 0x08, 0x14);
    FCML_A64("vrangeps $0x14,0x0000000000000020(%rsp){1to8},%ymm2,%ymm1", 0x62, 0xf3, 0x6D, 0x38, 0x50, 0x4c, 0x24, 0x08, 0x14);
    FCML_I32("vrangeps xmm1,xmm2,dword ptr [esp+00000020h]{1to4},14h", 0x62, 0xf3, 0x6D, 0x18, 0x50, 0x4c, 0x24, 0x08, 0x14);
    FCML_A32("vrangeps $0x14,0x00000020(%esp){1to4},%xmm2,%xmm1", 0x62, 0xf3, 0x6D, 0x18, 0x50, 0x4c, 0x24, 0x08, 0x14);
    FCML_I64("vrangeps xmm1,xmm2,dword ptr [rsp+0000000000000020h]{1to4},14h", 0x62, 0xf3, 0x6D, 0x18, 0x50, 0x4c, 0x24, 0x08, 0x14);
    FCML_A64("vrangeps $0x14,0x0000000000000020(%rsp){1to4},%xmm2,%xmm1", 0x62, 0xf3, 0x6D, 0x18, 0x50, 0x4c, 0x24, 0x08, 0x14);
}

void fcml_tf_instruction_VRANGESD(void) {
    FCML_I64("vrangesd xmm3,xmm12,xmm0,14h", 0x62, 0xf3, 0x9d, 0x08, 0x51, 0xd8, 0x14);
    FCML_I32("vrangesd xmm3,xmm4,xmm0,14h", 0x62, 0xf3, 0xdd, 0x08, 0x51, 0xd8, 0x14);
    FCML_A64("vrangesd $0x14,%xmm0,%xmm12,%xmm3", 0x62, 0xf3, 0x9d, 0x08, 0x51, 0xd8, 0x14);
    FCML_A64("vrangesd $0x14,%xmm0,%xmm3,%xmm3", 0x62, 0xf3, 0xe5, 0x08, 0x51, 0xd8, 0x14);
    FCML_I64("vrangesd xmm10{k1},xmm5,mmword ptr [r9+r8],14h", 0x62, 0x13, 0xd5, 0x09, 0x51, 0x14, 0x01, 0x14);
    FCML_A64("vrangesd $0x14,(%r9,%r8),%xmm5,%xmm10{%k1}", 0x62, 0x13, 0xd5, 0x09, 0x51, 0x14, 0x01, 0x14);
    FCML_I64("vrangesd xmm31{k7}{z},xmm4,xmm6,{sae},14h", 0x62, 0x63, 0xdd, 0x9f, 0x51, 0xfe, 0x14);
}

void fcml_tf_instruction_VRANGESS(void) {
    FCML_I64("vrangess xmm3,xmm12,xmm0,14h", 0x62, 0xf3, 0x1d, 0x08, 0x51, 0xd8, 0x14);
    FCML_I32("vrangess xmm3,xmm4,xmm0,14h", 0x62, 0xf3, 0x5d, 0x08, 0x51, 0xd8, 0x14);
    FCML_A64("vrangess $0x14,%xmm0,%xmm12,%xmm3", 0x62, 0xf3, 0x1d, 0x08, 0x51, 0xd8, 0x14);
    FCML_A64("vrangess $0x14,%xmm0,%xmm3,%xmm3", 0x62, 0xf3, 0x65, 0x08, 0x51, 0xd8, 0x14);
    FCML_I64("vrangess xmm10{k1},xmm5,dword ptr [r9+r8],14h", 0x62, 0x13, 0x55, 0x09, 0x51, 0x14, 0x01, 0x14);
    FCML_A64("vrangess $0x14,(%r9,%r8),%xmm5,%xmm10{%k1}", 0x62, 0x13, 0x55, 0x09, 0x51, 0x14, 0x01, 0x14);
    FCML_I64("vrangess xmm31{k7}{z},xmm4,xmm6,{sae},14h", 0x62, 0x63, 0x5d, 0x9f, 0x51, 0xfe, 0x14);
}

void fcml_tf_instruction_VRCP14PD(void) {
    FCML_I64("vrcp14pd xmm3,xmm0", 0x62, 0xf2, 0xfd, 0x08, 0x4c, 0xd8);
    FCML_I32("vrcp14pd xmm3,xmm0", 0x62, 0xf2, 0xfd, 0x08, 0x4c, 0xd8);
    FCML_I32("vrcp14pd ymm0,ymmword ptr [eax]", 0x62, 0xf2, 0xfd, 0x28, 0x4c, 0x00);
    FCML_A64("vrcp14pd %xmm0,%xmm3", 0x62, 0xf2, 0xfd, 0x08, 0x4c, 0xd8);
    FCML_A64("vrcp14pd %xmm0,%xmm3", 0x62, 0xf2, 0xfd, 0x08, 0x4c, 0xd8);
    FCML_I64("vrcp14pd ymm10{k1},ymmword ptr [r9+r8]", 0x62, 0x12, 0xfd, 0x29, 0x4c, 0x14, 0x01);
    FCML_A64("vrcp14pd (%r9,%r8),%ymm10{%k1}", 0x62, 0x12, 0xfd, 0x29, 0x4c, 0x14, 0x01);
    FCML_I64("vrcp14pd xmm10{k1},xmmword ptr [r9+r8]", 0x62, 0x12, 0xfd, 0x09, 0x4c, 0x14, 0x01);
    FCML_A64("vrcp14pd (%r9,%r8),%xmm10{%k1}", 0x62, 0x12, 0xfd, 0x09, 0x4c, 0x14, 0x01);
    FCML_I64("vrcp14pd zmm1{k1},zmmword ptr [r9+r8]", 0x62, 0x92, 0xfd, 0x49, 0x4c, 0x0c, 0x01);
    FCML_A64("vrcp14pd (%r9,%r8),%zmm1{%k1}", 0x62, 0x92, 0xfd, 0x49, 0x4c, 0x0c, 0x01);
    FCML_I64("vrcp14pd ymm10{k1}{z},ymmword ptr [r9+r8]", 0x62, 0x12, 0xfd, 0xa9, 0x4c, 0x14, 0x01);
    FCML_I64("vrcp14pd zmm31,mmword ptr [rsi]{1to8}", 0x62, 0x62, 0xfd, 0x58, 0x4c, 0x3e);
    FCML_I64("vrcp14pd ymm31{k7}{z},mmword ptr [rsi]{1to4}", 0x62, 0x62, 0xfd, 0xbf, 0x4c, 0x3e);
    FCML_A64("vrcp14pd (%rsi){1to4},%ymm31{%k7}{z}", 0x62, 0x62, 0xfd, 0xbf, 0x4c, 0x3e);
    FCML_I64_FAILED("vrcp14pd zmm31{k7}{z},zmm4,{sae}", 0x62, 0x62, 0xfd, 0x9f, 0x4c, 0xfc);
    FCML_I64("vrcp14pd xmm1{k4}{z},mmword ptr [rsp+0000000000000020h]{1to2}", 0x62, 0xf2, 0xfd, 0x9c, 0x4c, 0x4c, 0x24, 0x04);
    FCML_I64("vrcp14pd xmm1{k4}{z},mmword ptr [rsp+00000000000001d0h]{1to2}", 0x62, 0xf2, 0xfd, 0x9c, 0x4c, 0x4c, 0x24, 0x3a);
    FCML_I32("vrcp14pd xmm1{k4}{z},mmword ptr [esp+00000020h]{1to2}", 0x62, 0xf2, 0xfd, 0x9c, 0x4c, 0x4c, 0x24, 0x04);
}

void fcml_tf_instruction_VRCP14PS(void) {
    FCML_I64("vrcp14ps xmm3,xmm0", 0x62, 0xf2, 0x7d, 0x08, 0x4c, 0xd8);
    FCML_I32("vrcp14ps xmm3,xmm0", 0x62, 0xf2, 0x7d, 0x08, 0x4c, 0xd8);
    FCML_I32("vrcp14ps ymm0,ymmword ptr [eax]", 0x62, 0xf2, 0x7d, 0x28, 0x4c, 0x00);
    FCML_A64("vrcp14ps %xmm0,%xmm3", 0x62, 0xf2, 0x7d, 0x08, 0x4c, 0xd8);
    FCML_A64("vrcp14ps %xmm0,%xmm3", 0x62, 0xf2, 0x7d, 0x08, 0x4c, 0xd8);
    FCML_I64("vrcp14ps ymm10{k1},ymmword ptr [r9+r8]", 0x62, 0x12, 0x7d, 0x29, 0x4c, 0x14, 0x01);
    FCML_A64("vrcp14ps (%r9,%r8),%ymm10{%k1}", 0x62, 0x12, 0x7d, 0x29, 0x4c, 0x14, 0x01);
    FCML_I64("vrcp14ps xmm10{k1},xmmword ptr [r9+r8]", 0x62, 0x12, 0x7d, 0x09, 0x4c, 0x14, 0x01);
    FCML_A64("vrcp14ps (%r9,%r8),%xmm10{%k1}", 0x62, 0x12, 0x7d, 0x09, 0x4c, 0x14, 0x01);
    FCML_I64("vrcp14ps zmm1{k1},zmmword ptr [r9+r8]", 0x62, 0x92, 0x7d, 0x49, 0x4c, 0x0c, 0x01);
    FCML_A64("vrcp14ps (%r9,%r8),%zmm1{%k1}", 0x62, 0x92, 0x7d, 0x49, 0x4c, 0x0c, 0x01);
    FCML_I64("vrcp14ps ymm10{k1}{z},ymmword ptr [r9+r8]", 0x62, 0x12, 0x7d, 0xa9, 0x4c, 0x14, 0x01);
    FCML_I64("vrcp14ps zmm31,dword ptr [rsi]{1to16}", 0x62, 0x62, 0x7d, 0x58, 0x4c, 0x3e);
    FCML_I64("vrcp14ps ymm31{k7}{z},dword ptr [rsi]{1to8}", 0x62, 0x62, 0x7d, 0xbf, 0x4c, 0x3e);
    FCML_I64_FAILED("vrcp14ps zmm31{k7}{z},zmm4,{sae}", 0x62, 0x62, 0x7d, 0x9f, 0x4c, 0xfc);
    FCML_I64("vrcp14ps xmm1{k4}{z},dword ptr [rsp+0000000000000020h]{1to4}", 0x62, 0xf2, 0x7d, 0x9c, 0x4c, 0x4c, 0x24, 0x08);
    FCML_I64("vrcp14ps xmm1{k4}{z},dword ptr [rsp+00000000000001d0h]{1to4}", 0x62, 0xf2, 0x7d, 0x9c, 0x4c, 0x4c, 0x24, 0x74);
    FCML_I32("vrcp14ps xmm1{k4}{z},dword ptr [esp+00000020h]{1to4}", 0x62, 0xf2, 0x7d, 0x9c, 0x4c, 0x4c, 0x24, 0x08);
}

void fcml_tf_instruction_VRCP14SD(void) {
    FCML_I64("vrcp14sd xmm3,xmm12,xmm0", 0x62, 0xf2, 0x9d, 0x08, 0x4d, 0xd8);
    FCML_I32("vrcp14sd xmm3,xmm4,xmm0", 0x62, 0xf2, 0xdd, 0x08, 0x4d, 0xd8);
    FCML_A64("vrcp14sd %xmm0,%xmm12,%xmm3", 0x62, 0xf2, 0x9d, 0x08, 0x4d, 0xd8);
    FCML_A64("vrcp14sd %xmm0,%xmm3,%xmm3", 0x62, 0xf2, 0xe5, 0x08, 0x4d, 0xd8);
    FCML_I64("vrcp14sd xmm10{k1},xmm5,mmword ptr [r9+r8]", 0x62, 0x12, 0xd5, 0x09, 0x4d, 0x14, 0x01);
    FCML_A64("vrcp14sd (%r9,%r8),%xmm5,%xmm10{%k1}", 0x62, 0x12, 0xd5, 0x09, 0x4d, 0x14, 0x01);
    FCML_I64_FAILED("vrcp14sd xmm31{k7}{z},xmm4,xmm6,{sae}", 0x62, 0x62, 0xdd, 0x9f, 0x4d, 0xfe);
}

void fcml_tf_instruction_VRCP14SS(void) {
    FCML_I64("vrcp14ss xmm3,xmm12,xmm0", 0x62, 0xf2, 0x1d, 0x08, 0x4d, 0xd8);
    FCML_I32("vrcp14ss xmm3,xmm4,xmm0", 0x62, 0xf2, 0x5d, 0x08, 0x4d, 0xd8);
    FCML_A64("vrcp14ss %xmm0,%xmm12,%xmm3", 0x62, 0xf2, 0x1d, 0x08, 0x4d, 0xd8);
    FCML_A64("vrcp14ss %xmm0,%xmm3,%xmm3", 0x62, 0xf2, 0x65, 0x08, 0x4d, 0xd8);
    FCML_I64("vrcp14ss xmm10{k1},xmm5,dword ptr [r9+r8]", 0x62, 0x12, 0x55, 0x09, 0x4d, 0x14, 0x01);
    FCML_A64("vrcp14ss (%r9,%r8),%xmm5,%xmm10{%k1}", 0x62, 0x12, 0x55, 0x09, 0x4d, 0x14, 0x01);
    FCML_I64_FAILED("vrcp14ss xmm31{k7}{z},xmm4,xmm6,{sae}", 0x62, 0x62, 0x5d, 0x9f, 0x4d, 0xfe);
}

void fcml_tf_instruction_VREDUCEPD(void) {
    FCML_I64("vreducepd xmm3,xmm0,14h", 0x62, 0xf3, 0xfd, 0x08, 0x56, 0xd8, 0x14);
    FCML_I32("vreducepd xmm3,xmm0,14h", 0x62, 0xf3, 0xfd, 0x08, 0x56, 0xd8, 0x14);
    FCML_I32("vreducepd ymm0,ymmword ptr [eax],14h", 0x62, 0xf3, 0xfd, 0x28, 0x56, 0x00, 0x14);
    FCML_A64("vreducepd $0x14,%xmm0,%xmm3", 0x62, 0xf3, 0xfd, 0x08, 0x56, 0xd8, 0x14);
    FCML_A64("vreducepd $0x14,%xmm0,%xmm3", 0x62, 0xf3, 0xfd, 0x08, 0x56, 0xd8, 0x14);
    FCML_I64("vreducepd ymm10{k1},ymmword ptr [r9+r8],14h", 0x62, 0x13, 0xfd, 0x29, 0x56, 0x14, 0x01, 0x14);
    FCML_A64("vreducepd $0x14,(%r9,%r8),%ymm10{%k1}", 0x62, 0x13, 0xfd, 0x29, 0x56, 0x14, 0x01, 0x14);
    FCML_I64("vreducepd xmm10{k1},xmmword ptr [r9+r8],14h", 0x62, 0x13, 0xfd, 0x09, 0x56, 0x14, 0x01, 0x14);
    FCML_A64("vreducepd $0x14,(%r9,%r8),%xmm10{%k1}", 0x62, 0x13, 0xfd, 0x09, 0x56, 0x14, 0x01, 0x14);
    FCML_I64("vreducepd zmm1{k1},zmmword ptr [r9+r8],14h", 0x62, 0x93, 0xfd, 0x49, 0x56, 0x0c, 0x01, 0x14);
    FCML_A64("vreducepd $0x14,(%r9,%r8),%zmm1{%k1}", 0x62, 0x93, 0xfd, 0x49, 0x56, 0x0c, 0x01, 0x14);
    FCML_I64("vreducepd ymm10{k1}{z},ymmword ptr [r9+r8],14h", 0x62, 0x13, 0xfd, 0xa9, 0x56, 0x14, 0x01, 0x14);
    FCML_I64("vreducepd zmm31,mmword ptr [rsi]{1to8},14h", 0x62, 0x63, 0xfd, 0x58, 0x56, 0x3e, 0x14);
    FCML_I64("vreducepd ymm31{k7}{z},mmword ptr [rsi]{1to4},14h", 0x62, 0x63, 0xfd, 0xbf, 0x56, 0x3e, 0x14);
    FCML_A64("vreducepd $0x14,(%rsi){1to4},%ymm31{%k7}{z}", 0x62, 0x63, 0xfd, 0xbf, 0x56, 0x3e, 0x14);
    FCML_I64("vreducepd zmm31{k7}{z},zmm4,{sae},14h", 0x62, 0x63, 0xfd, 0x9f, 0x56, 0xfc, 0x14);
    FCML_I64("vreducepd xmm1{k4}{z},mmword ptr [rsp+0000000000000020h]{1to2},14h", 0x62, 0xf3, 0xfd, 0x9c, 0x56, 0x4c, 0x24, 0x04, 0x14);
    FCML_I64("vreducepd xmm1{k4}{z},mmword ptr [rsp+00000000000001d0h]{1to2},14h", 0x62, 0xf3, 0xfd, 0x9c, 0x56, 0x4c, 0x24, 0x3a, 0x14);
    FCML_I32("vreducepd xmm1{k4}{z},mmword ptr [esp+00000020h]{1to2},14h", 0x62, 0xf3, 0xfd, 0x9c, 0x56, 0x4c, 0x24, 0x04, 0x14);
}

void fcml_tf_instruction_VREDUCEPS(void) {
    FCML_I64("vreduceps xmm3,xmm0,14h", 0x62, 0xf3, 0x7d, 0x08, 0x56, 0xd8, 0x14);
    FCML_I32("vreduceps xmm3,xmm0,14h", 0x62, 0xf3, 0x7d, 0x08, 0x56, 0xd8, 0x14);
    FCML_I32("vreduceps ymm0,ymmword ptr [eax],14h", 0x62, 0xf3, 0x7d, 0x28, 0x56, 0x00, 0x14);
    FCML_A64("vreduceps $0x14,%xmm0,%xmm3", 0x62, 0xf3, 0x7d, 0x08, 0x56, 0xd8, 0x14);
    FCML_A64("vreduceps $0x14,%xmm0,%xmm3", 0x62, 0xf3, 0x7d, 0x08, 0x56, 0xd8, 0x14);
    FCML_I64("vreduceps ymm10{k1},ymmword ptr [r9+r8],14h", 0x62, 0x13, 0x7d, 0x29, 0x56, 0x14, 0x01, 0x14);
    FCML_A64("vreduceps $0x14,(%r9,%r8),%ymm10{%k1}", 0x62, 0x13, 0x7d, 0x29, 0x56, 0x14, 0x01, 0x14);
    FCML_I64("vreduceps xmm10{k1},xmmword ptr [r9+r8],14h", 0x62, 0x13, 0x7d, 0x09, 0x56, 0x14, 0x01, 0x14);
    FCML_A64("vreduceps $0x14,(%r9,%r8),%xmm10{%k1}", 0x62, 0x13, 0x7d, 0x09, 0x56, 0x14, 0x01, 0x14);
    FCML_I64("vreduceps zmm1{k1},zmmword ptr [r9+r8],14h", 0x62, 0x93, 0x7d, 0x49, 0x56, 0x0c, 0x01, 0x14);
    FCML_A64("vreduceps $0x14,(%r9,%r8),%zmm1{%k1}", 0x62, 0x93, 0x7d, 0x49, 0x56, 0x0c, 0x01, 0x14);
    FCML_I64("vreduceps ymm10{k1}{z},ymmword ptr [r9+r8],14h", 0x62, 0x13, 0x7d, 0xa9, 0x56, 0x14, 0x01, 0x14);
    FCML_I64("vreduceps zmm31,dword ptr [rsi]{1to16},14h", 0x62, 0x63, 0x7d, 0x58, 0x56, 0x3e, 0x14);
    FCML_I64("vreduceps ymm31{k7}{z},dword ptr [rsi]{1to8},14h", 0x62, 0x63, 0x7d, 0xbf, 0x56, 0x3e, 0x14);
    FCML_I64("vreduceps zmm31{k7}{z},zmm4,{sae},14h", 0x62, 0x63, 0x7d, 0x9f, 0x56, 0xfc, 0x14);
    FCML_I64("vreduceps xmm1{k4}{z},dword ptr [rsp+0000000000000020h]{1to4},14h", 0x62, 0xf3, 0x7d, 0x9c, 0x56, 0x4c, 0x24, 0x08, 0x14);
    FCML_I64("vreduceps xmm1{k4}{z},dword ptr [rsp+00000000000001d0h]{1to4},14h", 0x62, 0xf3, 0x7d, 0x9c, 0x56, 0x4c, 0x24, 0x74, 0x14);
    FCML_I32("vreduceps xmm1{k4}{z},dword ptr [esp+00000020h]{1to4},14h", 0x62, 0xf3, 0x7d, 0x9c, 0x56, 0x4c, 0x24, 0x08, 0x14);
}

void fcml_tf_instruction_VREDUCESD(void) {
    FCML_I64("vreducesd xmm3,xmm12,xmm0,14h", 0x62, 0xf3, 0x9d, 0x08, 0x57, 0xd8, 0x14);
    FCML_I32("vreducesd xmm3,xmm4,xmm0,14h", 0x62, 0xf3, 0xdd, 0x08, 0x57, 0xd8, 0x14);
    FCML_A64("vreducesd $0x14,%xmm0,%xmm12,%xmm3", 0x62, 0xf3, 0x9d, 0x08, 0x57, 0xd8, 0x14);
    FCML_A64("vreducesd $0x14,%xmm0,%xmm3,%xmm3", 0x62, 0xf3, 0xe5, 0x08, 0x57, 0xd8, 0x14);
    FCML_I64("vreducesd xmm10{k1},xmm5,mmword ptr [r9+r8],14h", 0x62, 0x13, 0xd5, 0x09, 0x57, 0x14, 0x01, 0x14);
    FCML_A64("vreducesd $0x14,(%r9,%r8),%xmm5,%xmm10{%k1}", 0x62, 0x13, 0xd5, 0x09, 0x57, 0x14, 0x01, 0x14);
    FCML_I64("vreducesd xmm31{k7}{z},xmm4,xmm6,{sae},14h", 0x62, 0x63, 0xdd, 0x9f, 0x57, 0xfe, 0x14);
}

void fcml_tf_instruction_VREDUCESS(void) {
    FCML_I64("vreducess xmm3,xmm12,xmm0,14h", 0x62, 0xf3, 0x1d, 0x08, 0x57, 0xd8, 0x14);
    FCML_I32("vreducess xmm3,xmm4,xmm0,14h", 0x62, 0xf3, 0x5d, 0x08, 0x57, 0xd8, 0x14);
    FCML_A64("vreducess $0x14,%xmm0,%xmm12,%xmm3", 0x62, 0xf3, 0x1d, 0x08, 0x57, 0xd8, 0x14);
    FCML_A64("vreducess $0x14,%xmm0,%xmm3,%xmm3", 0x62, 0xf3, 0x65, 0x08, 0x57, 0xd8, 0x14);
    FCML_I64("vreducess xmm10{k1},xmm5,dword ptr [r9+r8],14h", 0x62, 0x13, 0x55, 0x09, 0x57, 0x14, 0x01, 0x14);
    FCML_A64("vreducess $0x14,(%r9,%r8),%xmm5,%xmm10{%k1}", 0x62, 0x13, 0x55, 0x09, 0x57, 0x14, 0x01, 0x14);
    FCML_I64("vreducess xmm31{k7}{z},xmm4,xmm6,{sae},14h", 0x62, 0x63, 0x5d, 0x9f, 0x57, 0xfe, 0x14);
}

void fcml_tf_instruction_VRNDSCALEPD(void) {
    FCML_I64("vrndscalepd xmm3,xmm0,14h", 0x62, 0xf3, 0xfd, 0x08, 0x09, 0xd8, 0x14);
    FCML_I32("vrndscalepd xmm3,xmm0,14h", 0x62, 0xf3, 0xfd, 0x08, 0x09, 0xd8, 0x14);
    FCML_I32("vrndscalepd ymm0,ymmword ptr [eax],14h", 0x62, 0xf3, 0xfd, 0x28, 0x09, 0x00, 0x14);
    FCML_A64("vrndscalepd $0x14,%xmm0,%xmm3", 0x62, 0xf3, 0xfd, 0x08, 0x09, 0xd8, 0x14);
    FCML_A64("vrndscalepd $0x14,%xmm0,%xmm3", 0x62, 0xf3, 0xfd, 0x08, 0x09, 0xd8, 0x14);
    FCML_I64("vrndscalepd ymm10{k1},ymmword ptr [r9+r8],14h", 0x62, 0x13, 0xfd, 0x29, 0x09, 0x14, 0x01, 0x14);
    FCML_A64("vrndscalepd $0x14,(%r9,%r8),%ymm10{%k1}", 0x62, 0x13, 0xfd, 0x29, 0x09, 0x14, 0x01, 0x14);
    FCML_I64("vrndscalepd xmm10{k1},xmmword ptr [r9+r8],14h", 0x62, 0x13, 0xfd, 0x09, 0x09, 0x14, 0x01, 0x14);
    FCML_A64("vrndscalepd $0x14,(%r9,%r8),%xmm10{%k1}", 0x62, 0x13, 0xfd, 0x09, 0x09, 0x14, 0x01, 0x14);
    FCML_I64("vrndscalepd zmm1{k1},zmmword ptr [r9+r8],14h", 0x62, 0x93, 0xfd, 0x49, 0x09, 0x0c, 0x01, 0x14);
    FCML_A64("vrndscalepd $0x14,(%r9,%r8),%zmm1{%k1}", 0x62, 0x93, 0xfd, 0x49, 0x09, 0x0c, 0x01, 0x14);
    FCML_I64("vrndscalepd ymm10{k1}{z},ymmword ptr [r9+r8],14h", 0x62, 0x13, 0xfd, 0xa9, 0x09, 0x14, 0x01, 0x14);
    FCML_I64("vrndscalepd zmm31,mmword ptr [rsi]{1to8},14h", 0x62, 0x63, 0xfd, 0x58, 0x09, 0x3e, 0x14);
    FCML_I64("vrndscalepd ymm31{k7}{z},mmword ptr [rsi]{1to4},14h", 0x62, 0x63, 0xfd, 0xbf, 0x09, 0x3e, 0x14);
    FCML_A64("vrndscalepd $0x14,(%rsi){1to4},%ymm31{%k7}{z}", 0x62, 0x63, 0xfd, 0xbf, 0x09, 0x3e, 0x14);
    FCML_I64("vrndscalepd zmm31{k7}{z},zmm4,{sae},14h", 0x62, 0x63, 0xfd, 0x9f, 0x09, 0xfc, 0x14);
    FCML_I64("vrndscalepd xmm1{k4}{z},mmword ptr [rsp+0000000000000020h]{1to2},14h", 0x62, 0xf3, 0xfd, 0x9c, 0x09, 0x4c, 0x24, 0x04, 0x14);
    FCML_I64("vrndscalepd xmm1{k4}{z},mmword ptr [rsp+00000000000001d0h]{1to2},14h", 0x62, 0xf3, 0xfd, 0x9c, 0x09, 0x4c, 0x24, 0x3a, 0x14);
    FCML_I32("vrndscalepd xmm1{k4}{z},mmword ptr [esp+00000020h]{1to2},14h", 0x62, 0xf3, 0xfd, 0x9c, 0x09, 0x4c, 0x24, 0x04, 0x14);
}

void fcml_tf_instruction_VRNDSCALEPS(void) {
    FCML_I64("vrndscaleps xmm3,xmm0,14h", 0x62, 0xf3, 0x7d, 0x08, 0x08, 0xd8, 0x14);
    FCML_I32("vrndscaleps xmm3,xmm0,14h", 0x62, 0xf3, 0x7d, 0x08, 0x08, 0xd8, 0x14);
    FCML_I32("vrndscaleps ymm0,ymmword ptr [eax],14h", 0x62, 0xf3, 0x7d, 0x28, 0x08, 0x00, 0x14);
    FCML_A64("vrndscaleps $0x14,%xmm0,%xmm3", 0x62, 0xf3, 0x7d, 0x08, 0x08, 0xd8, 0x14);
    FCML_A64("vrndscaleps $0x14,%xmm0,%xmm3", 0x62, 0xf3, 0x7d, 0x08, 0x08, 0xd8, 0x14);
    FCML_I64("vrndscaleps ymm10{k1},ymmword ptr [r9+r8],14h", 0x62, 0x13, 0x7d, 0x29, 0x08, 0x14, 0x01, 0x14);
    FCML_A64("vrndscaleps $0x14,(%r9,%r8),%ymm10{%k1}", 0x62, 0x13, 0x7d, 0x29, 0x08, 0x14, 0x01, 0x14);
    FCML_I64("vrndscaleps xmm10{k1},xmmword ptr [r9+r8],14h", 0x62, 0x13, 0x7d, 0x09, 0x08, 0x14, 0x01, 0x14);
    FCML_A64("vrndscaleps $0x14,(%r9,%r8),%xmm10{%k1}", 0x62, 0x13, 0x7d, 0x09, 0x08, 0x14, 0x01, 0x14);
    FCML_I64("vrndscaleps zmm1{k1},zmmword ptr [r9+r8],14h", 0x62, 0x93, 0x7d, 0x49, 0x08, 0x0c, 0x01, 0x14);
    FCML_A64("vrndscaleps $0x14,(%r9,%r8),%zmm1{%k1}", 0x62, 0x93, 0x7d, 0x49, 0x08, 0x0c, 0x01, 0x14);
    FCML_I64("vrndscaleps ymm10{k1}{z},ymmword ptr [r9+r8],14h", 0x62, 0x13, 0x7d, 0xa9, 0x08, 0x14, 0x01, 0x14);
    FCML_I64("vrndscaleps zmm31,dword ptr [rsi]{1to16},14h", 0x62, 0x63, 0x7d, 0x58, 0x08, 0x3e, 0x14);
    FCML_I64("vrndscaleps ymm31{k7}{z},dword ptr [rsi]{1to8},14h", 0x62, 0x63, 0x7d, 0xbf, 0x08, 0x3e, 0x14);
    FCML_I64("vrndscaleps zmm31{k7}{z},zmm4,{sae},14h", 0x62, 0x63, 0x7d, 0x9f, 0x08, 0xfc, 0x14);
    FCML_I64("vrndscaleps xmm1{k4}{z},dword ptr [rsp+0000000000000020h]{1to4},14h", 0x62, 0xf3, 0x7d, 0x9c, 0x08, 0x4c, 0x24, 0x08, 0x14);
    FCML_I64("vrndscaleps xmm1{k4}{z},dword ptr [rsp+00000000000001d0h]{1to4},14h", 0x62, 0xf3, 0x7d, 0x9c, 0x08, 0x4c, 0x24, 0x74, 0x14);
    FCML_I32("vrndscaleps xmm1{k4}{z},dword ptr [esp+00000020h]{1to4},14h", 0x62, 0xf3, 0x7d, 0x9c, 0x08, 0x4c, 0x24, 0x08, 0x14);
}

void fcml_tf_instruction_VRNDSCALESD(void) {
    FCML_I64("vrndscalesd xmm3,xmm12,xmm0,14h", 0x62, 0xf3, 0x9d, 0x08, 0x0B, 0xd8, 0x14);
    FCML_I32("vrndscalesd xmm3,xmm4,xmm0,14h", 0x62, 0xf3, 0xdd, 0x08, 0x0B, 0xd8, 0x14);
    FCML_A64("vrndscalesd $0x14,%xmm0,%xmm12,%xmm3", 0x62, 0xf3, 0x9d, 0x08, 0x0B, 0xd8, 0x14);
    FCML_A64("vrndscalesd $0x14,%xmm0,%xmm3,%xmm3", 0x62, 0xf3, 0xe5, 0x08, 0x0B, 0xd8, 0x14);
    FCML_I64("vrndscalesd xmm10{k1},xmm5,mmword ptr [r9+r8],14h", 0x62, 0x13, 0xd5, 0x09, 0x0B, 0x14, 0x01, 0x14);
    FCML_A64("vrndscalesd $0x14,(%r9,%r8),%xmm5,%xmm10{%k1}", 0x62, 0x13, 0xd5, 0x09, 0x0B, 0x14, 0x01, 0x14);
    FCML_I64("vrndscalesd xmm31{k7}{z},xmm4,xmm6,{sae},14h", 0x62, 0x63, 0xdd, 0x9f, 0x0B, 0xfe, 0x14);
}

void fcml_tf_instruction_VRNDSCALESS(void) {
    FCML_I64("vrndscaless xmm3,xmm12,xmm0,14h", 0x62, 0xf3, 0x1d, 0x08, 0x0A, 0xd8, 0x14);
    FCML_I32("vrndscaless xmm3,xmm4,xmm0,14h", 0x62, 0xf3, 0x5d, 0x08, 0x0A, 0xd8, 0x14);
    FCML_A64("vrndscaless $0x14,%xmm0,%xmm12,%xmm3", 0x62, 0xf3, 0x1d, 0x08, 0x0A, 0xd8, 0x14);
    FCML_A64("vrndscaless $0x14,%xmm0,%xmm3,%xmm3", 0x62, 0xf3, 0x65, 0x08, 0x0A, 0xd8, 0x14);
    FCML_I64("vrndscaless xmm10{k1},xmm5,dword ptr [r9+r8],14h", 0x62, 0x13, 0x55, 0x09, 0x0A, 0x14, 0x01, 0x14);
    FCML_A64("vrndscaless $0x14,(%r9,%r8),%xmm5,%xmm10{%k1}", 0x62, 0x13, 0x55, 0x09, 0x0A, 0x14, 0x01, 0x14);
    FCML_I64("vrndscaless xmm31{k7}{z},xmm4,xmm6,{sae},14h", 0x62, 0x63, 0x5d, 0x9f, 0x0A, 0xfe, 0x14);
}

void fcml_tf_instruction_VRSQRT14PD(void) {
    FCML_I64("vrsqrt14pd xmm3,xmm0", 0x62, 0xf3, 0xfd, 0x08, 0x4e, 0xd8);
    FCML_I32("vrsqrt14pd xmm3,xmm0", 0x62, 0xf3, 0xfd, 0x08, 0x4e, 0xd8);
    FCML_I32("vrsqrt14pd ymm0,ymmword ptr [eax]", 0x62, 0xf3, 0xfd, 0x28, 0x4e, 0x00);
    FCML_A64("vrsqrt14pd %xmm0,%xmm3", 0x62, 0xf3, 0xfd, 0x08, 0x4e, 0xd8);
    FCML_A64("vrsqrt14pd %xmm0,%xmm3", 0x62, 0xf3, 0xfd, 0x08, 0x4e, 0xd8);
    FCML_A64("vrsqrt14pd (%rax),%ymm0", 0x62, 0xf3, 0xfd, 0x28, 0x4e, 0x00);
    FCML_I64("vrsqrt14pd ymm10{k1},ymmword ptr [r9+r8]", 0x62, 0x13, 0xfd, 0x29, 0x4e, 0x14, 0x01);
    FCML_A64("vrsqrt14pd (%r9,%r8),%ymm10{%k1}", 0x62, 0x13, 0xfd, 0x29, 0x4e, 0x14, 0x01);
    FCML_I64("vrsqrt14pd xmm10{k1},xmmword ptr [r9+r8]", 0x62, 0x13, 0xfd, 0x09, 0x4e, 0x14, 0x01);
    FCML_A64("vrsqrt14pd (%r9,%r8),%xmm10{%k1}", 0x62, 0x13, 0xfd, 0x09, 0x4e, 0x14, 0x01);
    FCML_I64("vrsqrt14pd zmm1{k1},zmmword ptr [r9+r8]", 0x62, 0x93, 0xfd, 0x49, 0x4e, 0x0c, 0x01);
    FCML_A64("vrsqrt14pd (%r9,%r8),%zmm1{%k1}", 0x62, 0x93, 0xfd, 0x49, 0x4e, 0x0c, 0x01);
    FCML_I64("vrsqrt14pd ymm10{k1}{z},ymmword ptr [r9+r8]", 0x62, 0x13, 0xfd, 0xa9, 0x4e, 0x14, 0x01);
    FCML_I64("vrsqrt14pd zmm31,mmword ptr [rsi]{1to8}", 0x62, 0x63, 0xfd, 0x58, 0x4e, 0x3e);
    FCML_I64("vrsqrt14pd ymm31{k7}{z},mmword ptr [rsi]{1to4}", 0x62, 0x63, 0xfd, 0xbf, 0x4e, 0x3e);
    FCML_A64("vrsqrt14pd (%rsi){1to4},%ymm31{%k7}{z}", 0x62, 0x63, 0xfd, 0xbf, 0x4e, 0x3e);
    FCML_I64("vrsqrt14pd xmm1{k4}{z},mmword ptr [rsp+0000000000000020h]{1to2}", 0x62, 0xf3, 0xfd, 0x9c, 0x4e, 0x4c, 0x24, 0x04);
    FCML_I64("vrsqrt14pd xmm1{k4}{z},mmword ptr [rsp+00000000000001d0h]{1to2}", 0x62, 0xf3, 0xfd, 0x9c, 0x4e, 0x4c, 0x24, 0x3a);
    FCML_I32("vrsqrt14pd xmm1{k4}{z},mmword ptr [esp+00000020h]{1to2}", 0x62, 0xf3, 0xfd, 0x9c, 0x4e, 0x4c, 0x24, 0x04);
}

void fcml_tf_instruction_VRSQRT14PS(void) {
    FCML_I64("vrsqrt14ps xmm3,xmm0", 0x62, 0xf3, 0x7d, 0x08, 0x4e, 0xd8);
    FCML_I32("vrsqrt14ps xmm3,xmm0", 0x62, 0xf3, 0x7d, 0x08, 0x4e, 0xd8);
    FCML_I32("vrsqrt14ps ymm0,ymmword ptr [eax]", 0x62, 0xf3, 0x7d, 0x28, 0x4e, 0x00);
    FCML_A64("vrsqrt14ps %xmm0,%xmm3", 0x62, 0xf3, 0x7d, 0x08, 0x4e, 0xd8);
    FCML_A64("vrsqrt14ps %xmm0,%xmm3", 0x62, 0xf3, 0x7d, 0x08, 0x4e, 0xd8);
    FCML_A64("vrsqrt14ps (%rax),%ymm0", 0x62, 0xf3, 0x7d, 0x28, 0x4e, 0x00);
    FCML_I64("vrsqrt14ps ymm10{k1},ymmword ptr [r9+r8]", 0x62, 0x13, 0x7d, 0x29, 0x4e, 0x14, 0x01);
    FCML_A64("vrsqrt14ps (%r9,%r8),%ymm10{%k1}", 0x62, 0x13, 0x7d, 0x29, 0x4e, 0x14, 0x01);
    FCML_I64("vrsqrt14ps xmm10{k1},xmmword ptr [r9+r8]", 0x62, 0x13, 0x7d, 0x09, 0x4e, 0x14, 0x01);
    FCML_A64("vrsqrt14ps (%r9,%r8),%xmm10{%k1}", 0x62, 0x13, 0x7d, 0x09, 0x4e, 0x14, 0x01);
    FCML_I64("vrsqrt14ps zmm1{k1},zmmword ptr [r9+r8]", 0x62, 0x93, 0x7d, 0x49, 0x4e, 0x0c, 0x01);
    FCML_A64("vrsqrt14ps (%r9,%r8),%zmm1{%k1}", 0x62, 0x93, 0x7d, 0x49, 0x4e, 0x0c, 0x01);
    FCML_I64("vrsqrt14ps ymm10{k1}{z},ymmword ptr [r9+r8]", 0x62, 0x13, 0x7d, 0xa9, 0x4e, 0x14, 0x01);
    FCML_I64("vrsqrt14ps zmm31,dword ptr [rsi]{1to16}", 0x62, 0x63, 0x7d, 0x58, 0x4e, 0x3e);
    FCML_I64("vrsqrt14ps ymm31{k7}{z},dword ptr [rsi]{1to8}", 0x62, 0x63, 0x7d, 0xbf, 0x4e, 0x3e);
    FCML_A64("vrsqrt14ps (%rsi){1to8},%ymm31{%k7}{z}", 0x62, 0x63, 0x7d, 0xbf, 0x4e, 0x3e);
    FCML_I64("vrsqrt14ps xmm1{k4}{z},dword ptr [rsp+0000000000000020h]{1to4}", 0x62, 0xf3, 0x7d, 0x9c, 0x4e, 0x4c, 0x24, 0x08);
    FCML_I64("vrsqrt14ps xmm1{k4}{z},dword ptr [rsp+00000000000001d0h]{1to4}", 0x62, 0xf3, 0x7d, 0x9c, 0x4e, 0x4c, 0x24, 0x74);
    FCML_I32("vrsqrt14ps xmm1{k4}{z},dword ptr [esp+00000020h]{1to4}", 0x62, 0xf3, 0x7d, 0x9c, 0x4e, 0x4c, 0x24, 0x08);
}

void fcml_tf_instruction_VRSQRT14SD(void) {
    FCML_I64("vrsqrt14sd xmm3,xmm12,xmm0", 0x62, 0xf2, 0x9d, 0x08, 0x4f, 0xd8);
    FCML_I32("vrsqrt14sd xmm3,xmm4,xmm0", 0x62, 0xf2, 0xdd, 0x08, 0x4f, 0xd8);
    FCML_A64("vrsqrt14sd %xmm0,%xmm12,%xmm3", 0x62, 0xf2, 0x9d, 0x08, 0x4f, 0xd8);
    FCML_A64("vrsqrt14sd %xmm0,%xmm3,%xmm3", 0x62, 0xf2, 0xe5, 0x08, 0x4f, 0xd8);
    FCML_I64("vrsqrt14sd xmm10{k1},xmm5,mmword ptr [r9+r8]", 0x62, 0x12, 0xd5, 0x09, 0x4f, 0x14, 0x01);
    FCML_A64("vrsqrt14sd (%r9,%r8),%xmm5,%xmm10{%k1}", 0x62, 0x12, 0xd5, 0x09, 0x4f, 0x14, 0x01);
}

void fcml_tf_instruction_VRSQRT14SS(void) {
    FCML_I64("vrsqrt14ss xmm3,xmm12,xmm0", 0x62, 0xf2, 0x1d, 0x08, 0x4f, 0xd8);
    FCML_I32("vrsqrt14ss xmm3,xmm4,xmm0", 0x62, 0xf2, 0x5d, 0x08, 0x4f, 0xd8);
    FCML_A64("vrsqrt14ss %xmm0,%xmm12,%xmm3", 0x62, 0xf2, 0x1d, 0x08, 0x4f, 0xd8);
    FCML_A64("vrsqrt14ss %xmm0,%xmm3,%xmm3", 0x62, 0xf2, 0x65, 0x08, 0x4f, 0xd8);
    FCML_I64("vrsqrt14ss xmm10{k1},xmm5,dword ptr [r9+r8]", 0x62, 0x12, 0x55, 0x09, 0x4f, 0x14, 0x01);
    FCML_A64("vrsqrt14ss (%r9,%r8),%xmm5,%xmm10{%k1}", 0x62, 0x12, 0x55, 0x09, 0x4f, 0x14, 0x01);
}

void fcml_tf_instruction_VSCALEFPD(void) {
    /* xmm1, xmm2, m128 */
    FCML_A64("vscalefpd (%rax),%xmm7,%xmm15", 0x62, 0x72, 0xc5, 0x08, 0x2c, 0x38);
    FCML_I64("vscalefpd xmm15,xmm7,xmmword ptr [rax]", 0x62, 0x72, 0xc5, 0x08, 0x2c, 0x38);
    FCML_A32("vscalefpd (%eax),%xmm6,%xmm7", 0x62, 0xf2, 0xcd, 0x08, 0x2c, 0x38);
    FCML_I32("vscalefpd xmm7,xmm6,xmmword ptr [eax]", 0x62, 0xf2, 0xcd, 0x08, 0x2c, 0x38);
    /* ymm1, ymm2, m256 */
    FCML_A64("vscalefpd (%rax),%ymm7,%ymm15", 0x62, 0x72, 0xc5, 0x28, 0x2c, 0x38);
    FCML_I64("vscalefpd ymm15,ymm7,ymmword ptr [rax]", 0x62, 0x72, 0xc5, 0x28, 0x2c, 0x38);
    FCML_A32("vscalefpd (%eax),%ymm5,%ymm7", 0x62, 0xf2, 0xd5, 0x28, 0x2c, 0x38);
    FCML_I32("vscalefpd ymm7,ymm5,ymmword ptr [eax]", 0x62, 0xf2, 0xd5, 0x28, 0x2c, 0x38);
    /* zmm1, zmm2, m512 */
    FCML_A64("vscalefpd (%rax),%zmm7,%zmm15", 0x62, 0x72, 0xc5, 0x48, 0x2c, 0x38);
    FCML_I64("vscalefpd zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x72, 0xc5, 0x48, 0x2c, 0x38);
    FCML_A32("vscalefpd (%eax),%zmm3,%zmm7", 0x62, 0xf2, 0xe5, 0x48, 0x2c, 0x38);
    FCML_I32("vscalefpd zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf2, 0xe5, 0x48, 0x2c, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64("vscalefpd %xmm1,%xmm7,%xmm15", 0x62, 0x72, 0xc5, 0x08, 0x2c, 0xf9);
    FCML_I64("vscalefpd xmm15,xmm7,xmm1", 0x62, 0x72, 0xc5, 0x08, 0x2c, 0xf9);
    FCML_A32("vscalefpd %xmm1,%xmm2,%xmm7", 0x62, 0xf2, 0xed, 0x08, 0x2c, 0xf9);
    FCML_I32("vscalefpd xmm7,xmm2,xmm1", 0x62, 0xf2, 0xed, 0x08, 0x2c, 0xf9);
    /* ymm1, ymm2, ymm3 */
    FCML_A64("vscalefpd %ymm6,%ymm7,%ymm14", 0x62, 0x72, 0xc5, 0x28, 0x2c, 0xf6);
    FCML_I64("vscalefpd ymm14,ymm7,ymm6", 0x62, 0x72, 0xc5, 0x28, 0x2c, 0xf6);
    FCML_A32("vscalefpd %ymm5,%ymm3,%ymm6", 0x62, 0xf2, 0xe5, 0x28, 0x2c, 0xf5);
    FCML_I32("vscalefpd ymm6,ymm3,ymm5", 0x62, 0xf2, 0xe5, 0x28, 0x2c, 0xf5);
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vscalefpd %zmm4,%zmm15,%zmm6", 0x62, 0xf2, 0x85, 0x48, 0x2c, 0xf4);
    FCML_I64("vscalefpd zmm6,zmm15,zmm4", 0x62, 0xf2, 0x85, 0x48, 0x2c, 0xf4);
    FCML_A32("vscalefpd %zmm4,%zmm6,%zmm6", 0x62, 0xf2, 0xcd, 0x48, 0x2c, 0xf4);
    FCML_I32("vscalefpd zmm6,zmm6,zmm4", 0x62, 0xf2, 0xcd, 0x48, 0x2c, 0xf4);
    /* disp8 */
    FCML_I32("vscalefpd zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf2, 0xed, 0x48, 0x2c, 0x4c, 0x24, 0x08);
    FCML_A32("vscalefpd 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x48, 0x2c, 0x4c, 0x24, 0x08);
    FCML_I64("vscalefpd zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf2, 0xed, 0x48, 0x2c, 0x4c, 0x24, 0x08);
    FCML_A64("vscalefpd 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x48, 0x2c, 0x4c, 0x24, 0x08);
    FCML_I32("vscalefpd ymm1,ymm2,ymmword ptr [esp+00000100h]", 0x62, 0xf2, 0xed, 0x28, 0x2c, 0x4c, 0x24, 0x08);
    FCML_A32("vscalefpd 0x00000100(%esp),%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x28, 0x2c, 0x4c, 0x24, 0x08);
    FCML_I64("vscalefpd ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 0x62, 0xf2, 0xed, 0x28, 0x2c, 0x4c, 0x24, 0x08);
    FCML_A64("vscalefpd 0x0000000000000100(%rsp),%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x28, 0x2c, 0x4c, 0x24, 0x08);
    FCML_I32("vscalefpd xmm1,xmm2,xmmword ptr [esp+00000080h]", 0x62, 0xf2, 0xed, 0x08, 0x2c, 0x4c, 0x24, 0x08);
    FCML_A32("vscalefpd 0x00000080(%esp),%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x08, 0x2c, 0x4c, 0x24, 0x08);
    FCML_I64("vscalefpd xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 0x62, 0xf2, 0xed, 0x08, 0x2c, 0x4c, 0x24, 0x08);
    FCML_A64("vscalefpd 0x0000000000000080(%rsp),%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x08, 0x2c, 0x4c, 0x24, 0x08);
    /* {k}{z} */
    FCML_A64("vscalefpd (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x12, 0x8d, 0x8c, 0x2c, 0x14, 0x01);
    FCML_I64("vscalefpd xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x8c, 0x2c, 0x14, 0x01);
    FCML_A32("vscalefpd (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0x8d, 0x2c, 0x14, 0x01);
    FCML_I32("vscalefpd xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x8d, 0x2c, 0x14, 0x01);
    FCML_A64("vscalefpd (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x12, 0x8d, 0xac, 0x2c, 0x14, 0x01);
    FCML_I64("vscalefpd ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0xac, 0x2c, 0x14, 0x01);
    FCML_A32("vscalefpd (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0xad, 0x2c, 0x14, 0x01);
    FCML_I32("vscalefpd ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0xad, 0x2c, 0x14, 0x01);
    FCML_A64("vscalefpd (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x12, 0x8d, 0xcc, 0x2c, 0x14, 0x01);
    FCML_I64("vscalefpd zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0xcc, 0x2c, 0x14, 0x01);
    FCML_A32("vscalefpd (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf2, 0xc5, 0xcd, 0x2c, 0x14, 0x01);
    FCML_I32("vscalefpd zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0xcd, 0x2c, 0x14, 0x01);
    /* {k} */
    FCML_A64("vscalefpd (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x12, 0x8d, 0x0c, 0x2c, 0x14, 0x01);
    FCML_I64("vscalefpd xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x0c, 0x2c, 0x14, 0x01);
    FCML_A32("vscalefpd (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf2, 0xc5, 0x0d, 0x2c, 0x14, 0x01);
    FCML_I32("vscalefpd xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x0d, 0x2c, 0x14, 0x01);
    FCML_A64("vscalefpd (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x12, 0x8d, 0x2c, 0x2c, 0x14, 0x01);
    FCML_I64("vscalefpd ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x2c, 0x2c, 0x14, 0x01);
    FCML_A32("vscalefpd (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf2, 0xc5, 0x2d, 0x2c, 0x14, 0x01);
    FCML_I32("vscalefpd ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x2d, 0x2c, 0x14, 0x01);
    FCML_A64("vscalefpd (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x12, 0x8d, 0x4c, 0x2c, 0x14, 0x01);
    FCML_I64("vscalefpd zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x8d, 0x4c, 0x2c, 0x14, 0x01);
    FCML_A32("vscalefpd (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf2, 0xc5, 0x4d, 0x2c, 0x14, 0x01);
    FCML_I32("vscalefpd zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0xc5, 0x4d, 0x2c, 0x14, 0x01);
    /* bcast */
    FCML_I64("vscalefpd zmm31,zmm21,mmword ptr [rsi]{1to8}", 0x62, 0x62, 0xd5, 0x50, 0x2c, 0x3e);
    FCML_A64("vscalefpd (%rsi){1to8},%zmm21,%zmm31", 0x62, 0x62, 0xd5, 0x50, 0x2c, 0x3e);
    FCML_I64("vscalefpd ymm31,ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x62, 0xd5, 0x30, 0x2c, 0x3e);
    FCML_A64("vscalefpd (%rsi){1to4},%ymm21,%ymm31", 0x62, 0x62, 0xd5, 0x30, 0x2c, 0x3e);
    FCML_I64("vscalefpd xmm31,xmm21,mmword ptr [rsi]{1to2}", 0x62, 0x62, 0xd5, 0x10, 0x2c, 0x3e);
    FCML_A64("vscalefpd (%rsi){1to2},%xmm21,%xmm31", 0x62, 0x62, 0xd5, 0x10, 0x2c, 0x3e);
    FCML_A32("vscalefpd (%esi){1to8},%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x58, 0x2c, 0x0e);
    FCML_I32("vscalefpd zmm1,zmm2,mmword ptr [esi]{1to8}", 0x62, 0xf2, 0xed, 0x58, 0x2c, 0x0e);
    /* {k}{z}{bcast} */
    FCML_A64("vscalefpd (%rsi){1to4},%ymm21,%ymm31{%k7}{z}", 0x62, 0x62, 0xd5, 0xb7, 0x2c, 0x3e);
    FCML_I64("vscalefpd ymm31{k7}{z},ymm21,mmword ptr [rsi]{1to4}", 0x62, 0x62, 0xd5, 0xb7, 0x2c, 0x3e);
    /* {bcast} disp8 */
    FCML_I32("vscalefpd zmm1,zmm2,mmword ptr [esp+00000040h]{1to8}", 0x62, 0xf2, 0xed, 0x58, 0x2c, 0x4c, 0x24, 0x08);
    FCML_A32("vscalefpd 0x00000040(%esp){1to8},%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x58, 0x2c, 0x4c, 0x24, 0x08);
    FCML_I64("vscalefpd zmm1,zmm2,mmword ptr [rsp+0000000000000040h]{1to8}", 0x62, 0xf2, 0xed, 0x58, 0x2c, 0x4c, 0x24, 0x08);
    FCML_A64("vscalefpd 0x0000000000000040(%rsp){1to8},%zmm2,%zmm1", 0x62, 0xf2, 0xed, 0x58, 0x2c, 0x4c, 0x24, 0x08);
    FCML_I32("vscalefpd ymm1,ymm2,mmword ptr [esp+00000040h]{1to4}", 0x62, 0xf2, 0xed, 0x38, 0x2c, 0x4c, 0x24, 0x08);
    FCML_A32("vscalefpd 0x00000040(%esp){1to4},%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x38, 0x2c, 0x4c, 0x24, 0x08);
    FCML_I64("vscalefpd ymm1,ymm2,mmword ptr [rsp+0000000000000040h]{1to4}", 0x62, 0xf2, 0xed, 0x38, 0x2c, 0x4c, 0x24, 0x08);
    FCML_A64("vscalefpd 0x0000000000000040(%rsp){1to4},%ymm2,%ymm1", 0x62, 0xf2, 0xed, 0x38, 0x2c, 0x4c, 0x24, 0x08);
    FCML_I32("vscalefpd xmm1,xmm2,mmword ptr [esp+00000040h]{1to2}", 0x62, 0xf2, 0xed, 0x18, 0x2c, 0x4c, 0x24, 0x08);
    FCML_A32("vscalefpd 0x00000040(%esp){1to2},%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x18, 0x2c, 0x4c, 0x24, 0x08);
    FCML_I64("vscalefpd xmm1,xmm2,mmword ptr [rsp+0000000000000040h]{1to2}", 0x62, 0xf2, 0xed, 0x18, 0x2c, 0x4c, 0x24, 0x08);
    FCML_A64("vscalefpd 0x0000000000000040(%rsp){1to2},%xmm2,%xmm1", 0x62, 0xf2, 0xed, 0x18, 0x2c, 0x4c, 0x24, 0x08);
}

void fcml_tf_instruction_VSCALEFPS(void) {
    /* xmm1, xmm2, m128 */
    FCML_A64("vscalefps (%rax),%xmm7,%xmm15", 0x62, 0x72, 0x45, 0x08, 0x2c, 0x38);
    FCML_I64("vscalefps xmm15,xmm7,xmmword ptr [rax]", 0x62, 0x72, 0x45, 0x08, 0x2c, 0x38);
    FCML_A32("vscalefps (%eax),%xmm6,%xmm7", 0x62, 0xf2, 0x4d, 0x08, 0x2c, 0x38);
    FCML_I32("vscalefps xmm7,xmm6,xmmword ptr [eax]", 0x62, 0xf2, 0x4d, 0x08, 0x2c, 0x38);
    /* ymm1, ymm2, m256 */
    FCML_A64("vscalefps (%rax),%ymm7,%ymm15", 0x62, 0x72, 0x45, 0x28, 0x2c, 0x38);
    FCML_I64("vscalefps ymm15,ymm7,ymmword ptr [rax]", 0x62, 0x72, 0x45, 0x28, 0x2c, 0x38);
    FCML_A32("vscalefps (%eax),%ymm5,%ymm7", 0x62, 0xf2, 0x55, 0x28, 0x2c, 0x38);
    FCML_I32("vscalefps ymm7,ymm5,ymmword ptr [eax]", 0x62, 0xf2, 0x55, 0x28, 0x2c, 0x38);
    /* zmm1, zmm2, m512 */
    FCML_A64("vscalefps (%rax),%zmm7,%zmm15", 0x62, 0x72, 0x45, 0x48, 0x2c, 0x38);
    FCML_I64("vscalefps zmm15,zmm7,zmmword ptr [rax]", 0x62, 0x72, 0x45, 0x48, 0x2c, 0x38);
    FCML_A32("vscalefps (%eax),%zmm3,%zmm7", 0x62, 0xf2, 0x65, 0x48, 0x2c, 0x38);
    FCML_I32("vscalefps zmm7,zmm3,zmmword ptr [eax]", 0x62, 0xf2, 0x65, 0x48, 0x2c, 0x38);
    /* xmm1, xmm2, xmm3 */
    FCML_A64("vscalefps %xmm1,%xmm7,%xmm15", 0x62, 0x72, 0x45, 0x08, 0x2c, 0xf9);
    FCML_I64("vscalefps xmm15,xmm7,xmm1", 0x62, 0x72, 0x45, 0x08, 0x2c, 0xf9);
    FCML_A32("vscalefps %xmm1,%xmm2,%xmm7", 0x62, 0xf2, 0x6d, 0x08, 0x2c, 0xf9);
    FCML_I32("vscalefps xmm7,xmm2,xmm1", 0x62, 0xf2, 0x6d, 0x08, 0x2c, 0xf9);
    /* ymm1, ymm2, ymm3 */
    FCML_A64("vscalefps %ymm6,%ymm7,%ymm14", 0x62, 0x72, 0x45, 0x28, 0x2c, 0xf6);
    FCML_I64("vscalefps ymm14,ymm7,ymm6", 0x62, 0x72, 0x45, 0x28, 0x2c, 0xf6);
    FCML_A32("vscalefps %ymm5,%ymm3,%ymm6", 0x62, 0xf2, 0x65, 0x28, 0x2c, 0xf5);
    FCML_I32("vscalefps ymm6,ymm3,ymm5", 0x62, 0xf2, 0x65, 0x28, 0x2c, 0xf5);
    /* zmm1, zmm2, zmm3 */
    FCML_A64("vscalefps %zmm4,%zmm15,%zmm6", 0x62, 0xf2, 0x05, 0x48, 0x2c, 0xf4);
    FCML_I64("vscalefps zmm6,zmm15,zmm4", 0x62, 0xf2, 0x05, 0x48, 0x2c, 0xf4);
    FCML_A32("vscalefps %zmm4,%zmm6,%zmm6", 0x62, 0xf2, 0x4d, 0x48, 0x2c, 0xf4);
    FCML_I32("vscalefps zmm6,zmm6,zmm4", 0x62, 0xf2, 0x4d, 0x48, 0x2c, 0xf4);
    /* disp8 */
    FCML_I32("vscalefps zmm1,zmm2,zmmword ptr [esp+00000200h]", 0x62, 0xf2, 0x6d, 0x48, 0x2c, 0x4c, 0x24, 0x08);
    FCML_A32("vscalefps 0x00000200(%esp),%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x48, 0x2c, 0x4c, 0x24, 0x08);
    FCML_I64("vscalefps zmm1,zmm2,zmmword ptr [rsp+0000000000000200h]", 0x62, 0xf2, 0x6d, 0x48, 0x2c, 0x4c, 0x24, 0x08);
    FCML_A64("vscalefps 0x0000000000000200(%rsp),%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x48, 0x2c, 0x4c, 0x24, 0x08);
    FCML_I32("vscalefps ymm1,ymm2,ymmword ptr [esp+00000100h]", 0x62, 0xf2, 0x6d, 0x28, 0x2c, 0x4c, 0x24, 0x08);
    FCML_A32("vscalefps 0x00000100(%esp),%ymm2,%ymm1", 0x62, 0xf2, 0x6d, 0x28, 0x2c, 0x4c, 0x24, 0x08);
    FCML_I64("vscalefps ymm1,ymm2,ymmword ptr [rsp+0000000000000100h]", 0x62, 0xf2, 0x6d, 0x28, 0x2c, 0x4c, 0x24, 0x08);
    FCML_A64("vscalefps 0x0000000000000100(%rsp),%ymm2,%ymm1", 0x62, 0xf2, 0x6d, 0x28, 0x2c, 0x4c, 0x24, 0x08);
    FCML_I32("vscalefps xmm1,xmm2,xmmword ptr [esp+00000080h]", 0x62, 0xf2, 0x6d, 0x08, 0x2c, 0x4c, 0x24, 0x08);
    FCML_A32("vscalefps 0x00000080(%esp),%xmm2,%xmm1", 0x62, 0xf2, 0x6d, 0x08, 0x2c, 0x4c, 0x24, 0x08);
    FCML_I64("vscalefps xmm1,xmm2,xmmword ptr [rsp+0000000000000080h]", 0x62, 0xf2, 0x6d, 0x08, 0x2c, 0x4c, 0x24, 0x08);
    FCML_A64("vscalefps 0x0000000000000080(%rsp),%xmm2,%xmm1", 0x62, 0xf2, 0x6d, 0x08, 0x2c, 0x4c, 0x24, 0x08);
    /* {k}{z} */
    FCML_A64("vscalefps (%r9,%r8),%xmm14,%xmm10{%k4}{z}", 0x62, 0x12, 0x0d, 0x8c, 0x2c, 0x14, 0x01);
    FCML_I64("vscalefps xmm10{k4}{z},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x8c, 0x2c, 0x14, 0x01);
    FCML_A32("vscalefps (%ecx,%eax),%xmm7,%xmm2{%k5}{z}", 0x62, 0xf2, 0x45, 0x8d, 0x2c, 0x14, 0x01);
    FCML_I32("vscalefps xmm2{k5}{z},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x8d, 0x2c, 0x14, 0x01);
    FCML_A64("vscalefps (%r9,%r8),%ymm14,%ymm10{%k4}{z}", 0x62, 0x12, 0x0d, 0xac, 0x2c, 0x14, 0x01);
    FCML_I64("vscalefps ymm10{k4}{z},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0xac, 0x2c, 0x14, 0x01);
    FCML_A32("vscalefps (%ecx,%eax),%ymm7,%ymm2{%k5}{z}", 0x62, 0xf2, 0x45, 0xad, 0x2c, 0x14, 0x01);
    FCML_I32("vscalefps ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0xad, 0x2c, 0x14, 0x01);
    FCML_A64("vscalefps (%r9,%r8),%zmm14,%zmm10{%k4}{z}", 0x62, 0x12, 0x0d, 0xcc, 0x2c, 0x14, 0x01);
    FCML_I64("vscalefps zmm10{k4}{z},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0xcc, 0x2c, 0x14, 0x01);
    FCML_A32("vscalefps (%ecx,%eax),%zmm7,%zmm2{%k5}{z}", 0x62, 0xf2, 0x45, 0xcd, 0x2c, 0x14, 0x01);
    FCML_I32("vscalefps zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0xcd, 0x2c, 0x14, 0x01);
    /* {k} */
    FCML_A64("vscalefps (%r9,%r8),%xmm14,%xmm10{%k4}", 0x62, 0x12, 0x0d, 0x0c, 0x2c, 0x14, 0x01);
    FCML_I64("vscalefps xmm10{k4},xmm14,xmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x0c, 0x2c, 0x14, 0x01);
    FCML_A32("vscalefps (%ecx,%eax),%xmm7,%xmm2{%k5}", 0x62, 0xf2, 0x45, 0x0d, 0x2c, 0x14, 0x01);
    FCML_I32("vscalefps xmm2{k5},xmm7,xmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x0d, 0x2c, 0x14, 0x01);
    FCML_A64("vscalefps (%r9,%r8),%ymm14,%ymm10{%k4}", 0x62, 0x12, 0x0d, 0x2c, 0x2c, 0x14, 0x01);
    FCML_I64("vscalefps ymm10{k4},ymm14,ymmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x2c, 0x2c, 0x14, 0x01);
    FCML_A32("vscalefps (%ecx,%eax),%ymm7,%ymm2{%k5}", 0x62, 0xf2, 0x45, 0x2d, 0x2c, 0x14, 0x01);
    FCML_I32("vscalefps ymm2{k5},ymm7,ymmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x2d, 0x2c, 0x14, 0x01);
    FCML_A64("vscalefps (%r9,%r8),%zmm14,%zmm10{%k4}", 0x62, 0x12, 0x0d, 0x4c, 0x2c, 0x14, 0x01);
    FCML_I64("vscalefps zmm10{k4},zmm14,zmmword ptr [r9+r8]", 0x62, 0x12, 0x0d, 0x4c, 0x2c, 0x14, 0x01);
    FCML_A32("vscalefps (%ecx,%eax),%zmm7,%zmm2{%k5}", 0x62, 0xf2, 0x45, 0x4d, 0x2c, 0x14, 0x01);
    FCML_I32("vscalefps zmm2{k5},zmm7,zmmword ptr [ecx+eax]", 0x62, 0xf2, 0x45, 0x4d, 0x2c, 0x14, 0x01);
    /* bcast */
    FCML_I64("vscalefps zmm31,zmm21,dword ptr [rsi]{1to16}", 0x62, 0x62, 0x55, 0x50, 0x2c, 0x3e);
    FCML_A64("vscalefps (%rsi){1to16},%zmm21,%zmm31", 0x62, 0x62, 0x55, 0x50, 0x2c, 0x3e);
    FCML_I64("vscalefps ymm31,ymm21,dword ptr [rsi]{1to8}", 0x62, 0x62, 0x55, 0x30, 0x2c, 0x3e);
    FCML_A64("vscalefps (%rsi){1to8},%ymm21,%ymm31", 0x62, 0x62, 0x55, 0x30, 0x2c, 0x3e);
    FCML_I64("vscalefps xmm31,xmm21,dword ptr [rsi]{1to4}", 0x62, 0x62, 0x55, 0x10, 0x2c, 0x3e);
    FCML_A64("vscalefps (%rsi){1to4},%xmm21,%xmm31", 0x62, 0x62, 0x55, 0x10, 0x2c, 0x3e);
    FCML_A32("vscalefps (%esi){1to16},%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x58, 0x2c, 0x0e);
    FCML_I32("vscalefps zmm1,zmm2,dword ptr [esi]{1to16}", 0x62, 0xf2, 0x6d, 0x58, 0x2c, 0x0e);
    /* {k}{z}{bcast} */
    FCML_A64("vscalefps (%rsi){1to8},%ymm21,%ymm31{%k7}{z}", 0x62, 0x62, 0x55, 0xb7, 0x2c, 0x3e);
    FCML_I64("vscalefps ymm31{k7}{z},ymm21,dword ptr [rsi]{1to8}", 0x62, 0x62, 0x55, 0xb7, 0x2c, 0x3e);
    /* {bcast} disp8 */
    FCML_I32("vscalefps zmm1,zmm2,dword ptr [esp+00000020h]{1to16}", 0x62, 0xf2, 0x6d, 0x58, 0x2c, 0x4c, 0x24, 0x08);
    FCML_A32("vscalefps 0x00000020(%esp){1to16},%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x58, 0x2c, 0x4c, 0x24, 0x08);
    FCML_I64("vscalefps zmm1,zmm2,dword ptr [rsp+0000000000000020h]{1to16}", 0x62, 0xf2, 0x6d, 0x58, 0x2c, 0x4c, 0x24, 0x08);
    FCML_A64("vscalefps 0x0000000000000020(%rsp){1to16},%zmm2,%zmm1", 0x62, 0xf2, 0x6d, 0x58, 0x2c, 0x4c, 0x24, 0x08);
    FCML_I32("vscalefps ymm1,ymm2,dword ptr [esp+00000020h]{1to8}", 0x62, 0xf2, 0x6d, 0x38, 0x2c, 0x4c, 0x24, 0x08);
    FCML_A32("vscalefps 0x00000020(%esp){1to8},%ymm2,%ymm1", 0x62, 0xf2, 0x6d, 0x38, 0x2c, 0x4c, 0x24, 0x08);
    FCML_I64("vscalefps ymm1,ymm2,dword ptr [rsp+0000000000000020h]{1to8}", 0x62, 0xf2, 0x6d, 0x38, 0x2c, 0x4c, 0x24, 0x08);
    FCML_A64("vscalefps 0x0000000000000020(%rsp){1to8},%ymm2,%ymm1", 0x62, 0xf2, 0x6d, 0x38, 0x2c, 0x4c, 0x24, 0x08);
    FCML_I32("vscalefps xmm1,xmm2,dword ptr [esp+00000020h]{1to4}", 0x62, 0xf2, 0x6d, 0x18, 0x2c, 0x4c, 0x24, 0x08);
    FCML_A32("vscalefps 0x00000020(%esp){1to4},%xmm2,%xmm1", 0x62, 0xf2, 0x6d, 0x18, 0x2c, 0x4c, 0x24, 0x08);
    FCML_I64("vscalefps xmm1,xmm2,dword ptr [rsp+0000000000000020h]{1to4}", 0x62, 0xf2, 0x6d, 0x18, 0x2c, 0x4c, 0x24, 0x08);
    FCML_A64("vscalefps 0x0000000000000020(%rsp){1to4},%xmm2,%xmm1", 0x62, 0xf2, 0x6d, 0x18, 0x2c, 0x4c, 0x24, 0x08);
}

void fcml_tf_instruction_VSCALEFSD(void) {
    FCML_I64("vscalefsd xmm3,xmm12,xmm0", 0x62, 0xf2, 0x9d, 0x08, 0x2d, 0xd8);
    FCML_I32("vscalefsd xmm3,xmm4,xmm0", 0x62, 0xf2, 0xdd, 0x08, 0x2d, 0xd8);
    FCML_A64("vscalefsd %xmm0,%xmm12,%xmm3", 0x62, 0xf2, 0x9d, 0x08, 0x2d, 0xd8);
    FCML_A64("vscalefsd %xmm0,%xmm3,%xmm3", 0x62, 0xf2, 0xe5, 0x08, 0x2d, 0xd8);
    FCML_I64("vscalefsd xmm10{k1},xmm5,mmword ptr [r9+r8]", 0x62, 0x12, 0xd5, 0x09, 0x2d, 0x14, 0x01);
    FCML_A64("vscalefsd (%r9,%r8),%xmm5,%xmm10{%k1}", 0x62, 0x12, 0xd5, 0x09, 0x2d, 0x14, 0x01);
    FCML_I64("vscalefsd xmm10{k1},xmm5,xmm7,{rn-sae}", 0x62, 0x72, 0xd5, 0x19, 0x2d, 0xd7);
}

void fcml_tf_instruction_VSCALEFSS(void) {
    FCML_I64("vscalefss xmm3,xmm12,xmm0", 0x62, 0xf2, 0x1d, 0x08, 0x2d, 0xd8);
    FCML_I32("vscalefss xmm3,xmm4,xmm0", 0x62, 0xf2, 0x5d, 0x08, 0x2d, 0xd8);
    FCML_A64("vscalefss %xmm0,%xmm12,%xmm3", 0x62, 0xf2, 0x1d, 0x08, 0x2d, 0xd8);
    FCML_A64("vscalefss %xmm0,%xmm3,%xmm3", 0x62, 0xf2, 0x65, 0x08, 0x2d, 0xd8);
    FCML_I64("vscalefss xmm10{k1},xmm5,dword ptr [r9+r8]", 0x62, 0x12, 0x55, 0x09, 0x2d, 0x14, 0x01);
    FCML_A64("vscalefss (%r9,%r8),%xmm5,%xmm10{%k1}", 0x62, 0x12, 0x55, 0x09, 0x2d, 0x14, 0x01);
    FCML_I64("vscalefss xmm10{k1},xmm5,xmm6,{rn-sae}", 0x62, 0x72, 0x55, 0x19, 0x2d, 0xd6);
}

void fcml_tf_instruction_VSCATTERDPS(void) {
    FCML_I32("vscatterdps dword ptr [eax+xmm5]{k1},xmm0", 0x62, 0xf2, 0x7d, 0x09, 0xa2, 0x04, 0x28);
    FCML_I32("vscatterdps dword ptr [eax+ymm5]{k2},ymm0", 0x62, 0xf2, 0x7d, 0x2a, 0xa2, 0x04, 0x28);
    FCML_I32("vscatterdps dword ptr [eax+zmm5]{k3},zmm0", 0x62, 0xf2, 0x7d, 0x4b, 0xa2, 0x04, 0x28);
    FCML_I32("vscatterdps dword ptr [eax+zmm5+00000020h]{k3},zmm0", 0x62, 0xf2, 0x7d, 0x4b, 0xa2, 0x44, 0x28, 0x08);
}

void fcml_tf_instruction_VSCATTERDPD(void) {
    FCML_I32("vscatterdpd mmword ptr [eax+xmm5]{k1},xmm0", 0x62, 0xf2, 0xfd, 0x09, 0xa2, 0x04, 0x28);
    FCML_I32("vscatterdpd mmword ptr [eax+xmm5]{k2},ymm0", 0x62, 0xf2, 0xfd, 0x2a, 0xa2, 0x04, 0x28);
    FCML_I32("vscatterdpd mmword ptr [eax+ymm5]{k3},zmm0", 0x62, 0xf2, 0xfd, 0x4b, 0xa2, 0x04, 0x28);
    FCML_I32("vscatterdpd mmword ptr [eax+ymm5+00000020h]{k3},zmm0", 0x62, 0xf2, 0xfd, 0x4b, 0xa2, 0x44, 0x28, 0x04);
}

void fcml_tf_instruction_VSCATTERQPS(void) {
    FCML_I32("vscatterqps dword ptr [eax+xmm5]{k1},xmm0", 0x62, 0xf2, 0x7d, 0x09, 0xa3, 0x04, 0x28);
    FCML_I32("vscatterqps dword ptr [eax+ymm5]{k2},xmm0", 0x62, 0xf2, 0x7d, 0x2a, 0xa3, 0x04, 0x28);
    FCML_I32("vscatterqps dword ptr [eax+zmm5]{k3},ymm0", 0x62, 0xf2, 0x7d, 0x4b, 0xa3, 0x04, 0x28);
    FCML_I32("vscatterqps dword ptr [eax+zmm5+00000020h]{k3},ymm0", 0x62, 0xf2, 0x7d, 0x4b, 0xa3, 0x44, 0x28, 0x08);
}

void fcml_tf_instruction_VSCATTERQPD(void) {
    FCML_I32("vscatterqpd mmword ptr [eax+xmm5]{k1},xmm0", 0x62, 0xf2, 0xfd, 0x09, 0xa3, 0x04, 0x28);
    FCML_I32("vscatterqpd mmword ptr [eax+ymm5]{k2},ymm0", 0x62, 0xf2, 0xfd, 0x2a, 0xa3, 0x04, 0x28);
    FCML_I32("vscatterqpd mmword ptr [eax+zmm5]{k3},zmm0", 0x62, 0xf2, 0xfd, 0x4b, 0xa3, 0x04, 0x28);
    FCML_I32("vscatterqpd mmword ptr [eax+zmm5+00000020h]{k3},zmm0", 0x62, 0xf2, 0xfd, 0x4b, 0xa3, 0x44, 0x28, 0x04);
}

void fcml_tf_instruction_VSHUFF32X4(void) {
    FCML_I64("vshuff32x4 ymm15,ymm7,ymmword ptr [rax],14h", 0x62, 0x73, 0x45, 0x28, 0x23, 0x38, 0x14);
    FCML_I32("vshuff32x4 ymm7,ymm5,ymmword ptr [eax],14h", 0x62, 0xf3, 0x55, 0x28, 0x23, 0x38, 0x14);
    FCML_I64("vshuff32x4 zmm15,zmm7,zmmword ptr [rax],14h", 0x62, 0x73, 0x45, 0x48, 0x23, 0x38, 0x14);
    FCML_I32("vshuff32x4 zmm7,zmm3,zmmword ptr [eax],14h", 0x62, 0xf3, 0x65, 0x48, 0x23, 0x38, 0x14);
    FCML_I64("vshuff32x4 ymm14,ymm7,ymm6,14h", 0x62, 0x73, 0x45, 0x28, 0x23, 0xf6, 0x14);
    FCML_I32("vshuff32x4 ymm6,ymm3,ymm5,14h", 0x62, 0xf3, 0x65, 0x28, 0x23, 0xf5, 0x14);
    FCML_I64("vshuff32x4 zmm6,zmm15,zmm4,14h", 0x62, 0xf3, 0x05, 0x48, 0x23, 0xf4, 0x14);
    FCML_I32("vshuff32x4 zmm6,zmm6,zmm4,14h", 0x62, 0xf3, 0x4d, 0x48, 0x23, 0xf4, 0x14);
    FCML_I32("vshuff32x4 zmm1,zmm2,zmmword ptr [esp+00000200h],14h", 0x62, 0xf3, 0x6d, 0x48, 0x23, 0x4c, 0x24, 0x08, 0x14);
    FCML_I64("vshuff32x4 zmm1,zmm2,zmmword ptr [rsp+0000000000000200h],14h", 0x62, 0xf3, 0x6d, 0x48, 0x23, 0x4c, 0x24, 0x08, 0x14);
    FCML_I32("vshuff32x4 ymm1,ymm2,ymmword ptr [esp+00000100h],14h", 0x62, 0xf3, 0x6d, 0x28, 0x23, 0x4c, 0x24, 0x08, 0x14);
    FCML_I64("vshuff32x4 ymm1,ymm2,ymmword ptr [rsp+0000000000000100h],14h", 0x62, 0xf3, 0x6d, 0x28, 0x23, 0x4c, 0x24, 0x08, 0x14);
    FCML_I64("vshuff32x4 ymm10{k4}{z},ymm14,ymmword ptr [r9+r8],14h", 0x62, 0x13, 0x0d, 0xac, 0x23, 0x14, 0x01, 0x14);
    FCML_I32("vshuff32x4 ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax],14h", 0x62, 0xf3, 0x45, 0xad, 0x23, 0x14, 0x01, 0x14);
    FCML_I64("vshuff32x4 zmm10{k4}{z},zmm14,zmmword ptr [r9+r8],14h", 0x62, 0x13, 0x0d, 0xcc, 0x23, 0x14, 0x01, 0x14);
    FCML_I32("vshuff32x4 zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax],14h", 0x62, 0xf3, 0x45, 0xcd, 0x23, 0x14, 0x01, 0x14);
    FCML_I64("vshuff32x4 ymm10{k4},ymm14,ymmword ptr [r9+r8],14h", 0x62, 0x13, 0x0d, 0x2c, 0x23, 0x14, 0x01, 0x14);
    FCML_I32("vshuff32x4 ymm2{k5},ymm7,ymmword ptr [ecx+eax],14h", 0x62, 0xf3, 0x45, 0x2d, 0x23, 0x14, 0x01, 0x14);
    FCML_I64("vshuff32x4 zmm10{k4},zmm14,zmmword ptr [r9+r8],14h", 0x62, 0x13, 0x0d, 0x4c, 0x23, 0x14, 0x01, 0x14);
    FCML_I32("vshuff32x4 zmm2{k5},zmm7,zmmword ptr [ecx+eax],14h", 0x62, 0xf3, 0x45, 0x4d, 0x23, 0x14, 0x01, 0x14);
    FCML_I64("vshuff32x4 ymm31{k7}{z},ymm21,dword ptr [rsi]{1to8},14h", 0x62, 0x63, 0x55, 0xb7, 0x23, 0x3e, 0x14);
    FCML_I32("vshuff32x4 zmm1,zmm2,dword ptr [esp+00000040h]{1to16},14h", 0x62, 0xf3, 0x6d, 0x58, 0x23, 0x4c, 0x24, 0x10, 0x14);
    FCML_I64("vshuff32x4 zmm1,zmm2,dword ptr [rsp+0000000000000040h]{1to16},14h", 0x62, 0xf3, 0x6d, 0x58, 0x23, 0x4c, 0x24, 0x10, 0x14);
    FCML_I32("vshuff32x4 ymm1,ymm2,dword ptr [esp+00000040h]{1to8},14h", 0x62, 0xf3, 0x6d, 0x38, 0x23, 0x4c, 0x24, 0x10, 0x14);
    FCML_I64("vshuff32x4 ymm1,ymm2,dword ptr [rsp+0000000000000040h]{1to8},14h", 0x62, 0xf3, 0x6d, 0x38, 0x23, 0x4c, 0x24, 0x10, 0x14);
}

void fcml_tf_instruction_VSHUFI32X4(void) {
    FCML_I64("vshufi32x4 ymm15,ymm7,ymmword ptr [rax],14h", 0x62, 0x73, 0x45, 0x28, 0x43, 0x38, 0x14);
    FCML_I32("vshufi32x4 ymm7,ymm5,ymmword ptr [eax],14h", 0x62, 0xf3, 0x55, 0x28, 0x43, 0x38, 0x14);
    FCML_I64("vshufi32x4 zmm15,zmm7,zmmword ptr [rax],14h", 0x62, 0x73, 0x45, 0x48, 0x43, 0x38, 0x14);
    FCML_I32("vshufi32x4 zmm7,zmm3,zmmword ptr [eax],14h", 0x62, 0xf3, 0x65, 0x48, 0x43, 0x38, 0x14);
    FCML_I64("vshufi32x4 ymm14,ymm7,ymm6,14h", 0x62, 0x73, 0x45, 0x28, 0x43, 0xf6, 0x14);
    FCML_I32("vshufi32x4 ymm6,ymm3,ymm5,14h", 0x62, 0xf3, 0x65, 0x28, 0x43, 0xf5, 0x14);
    FCML_I64("vshufi32x4 zmm6,zmm15,zmm4,14h", 0x62, 0xf3, 0x05, 0x48, 0x43, 0xf4, 0x14);
    FCML_I32("vshufi32x4 zmm6,zmm6,zmm4,14h", 0x62, 0xf3, 0x4d, 0x48, 0x43, 0xf4, 0x14);
    FCML_I32("vshufi32x4 zmm1,zmm2,zmmword ptr [esp+00000200h],14h", 0x62, 0xf3, 0x6d, 0x48, 0x43, 0x4c, 0x24, 0x08, 0x14);
    FCML_I64("vshufi32x4 zmm1,zmm2,zmmword ptr [rsp+0000000000000200h],14h", 0x62, 0xf3, 0x6d, 0x48, 0x43, 0x4c, 0x24, 0x08, 0x14);
    FCML_I32("vshufi32x4 ymm1,ymm2,ymmword ptr [esp+00000100h],14h", 0x62, 0xf3, 0x6d, 0x28, 0x43, 0x4c, 0x24, 0x08, 0x14);
    FCML_I64("vshufi32x4 ymm1,ymm2,ymmword ptr [rsp+0000000000000100h],14h", 0x62, 0xf3, 0x6d, 0x28, 0x43, 0x4c, 0x24, 0x08, 0x14);
    FCML_I64("vshufi32x4 ymm10{k4}{z},ymm14,ymmword ptr [r9+r8],14h", 0x62, 0x13, 0x0d, 0xac, 0x43, 0x14, 0x01, 0x14);
    FCML_I32("vshufi32x4 ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax],14h", 0x62, 0xf3, 0x45, 0xad, 0x43, 0x14, 0x01, 0x14);
    FCML_I64("vshufi32x4 zmm10{k4}{z},zmm14,zmmword ptr [r9+r8],14h", 0x62, 0x13, 0x0d, 0xcc, 0x43, 0x14, 0x01, 0x14);
    FCML_I32("vshufi32x4 zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax],14h", 0x62, 0xf3, 0x45, 0xcd, 0x43, 0x14, 0x01, 0x14);
    FCML_I64("vshufi32x4 ymm10{k4},ymm14,ymmword ptr [r9+r8],14h", 0x62, 0x13, 0x0d, 0x2c, 0x43, 0x14, 0x01, 0x14);
    FCML_I32("vshufi32x4 ymm2{k5},ymm7,ymmword ptr [ecx+eax],14h", 0x62, 0xf3, 0x45, 0x2d, 0x43, 0x14, 0x01, 0x14);
    FCML_I64("vshufi32x4 zmm10{k4},zmm14,zmmword ptr [r9+r8],14h", 0x62, 0x13, 0x0d, 0x4c, 0x43, 0x14, 0x01, 0x14);
    FCML_I32("vshufi32x4 zmm2{k5},zmm7,zmmword ptr [ecx+eax],14h", 0x62, 0xf3, 0x45, 0x4d, 0x43, 0x14, 0x01, 0x14);
    FCML_I64("vshufi32x4 ymm31{k7}{z},ymm21,dword ptr [rsi]{1to8},14h", 0x62, 0x63, 0x55, 0xb7, 0x43, 0x3e, 0x14);
    FCML_I32("vshufi32x4 zmm1,zmm2,dword ptr [esp+00000040h]{1to16},14h", 0x62, 0xf3, 0x6d, 0x58, 0x43, 0x4c, 0x24, 0x10, 0x14);
    FCML_I64("vshufi32x4 zmm1,zmm2,dword ptr [rsp+0000000000000040h]{1to16},14h", 0x62, 0xf3, 0x6d, 0x58, 0x43, 0x4c, 0x24, 0x10, 0x14);
    FCML_I32("vshufi32x4 ymm1,ymm2,dword ptr [esp+00000040h]{1to8},14h", 0x62, 0xf3, 0x6d, 0x38, 0x43, 0x4c, 0x24, 0x10, 0x14);
    FCML_I64("vshufi32x4 ymm1,ymm2,dword ptr [rsp+0000000000000040h]{1to8},14h", 0x62, 0xf3, 0x6d, 0x38, 0x43, 0x4c, 0x24, 0x10, 0x14);
}

void fcml_tf_instruction_VSHUFF64X2(void) {
    FCML_I64("vshuff64x2 ymm15,ymm7,ymmword ptr [rax],14h", 0x62, 0x73, 0xc5, 0x28, 0x23, 0x38, 0x14);
    FCML_I32("vshuff64x2 ymm7,ymm5,ymmword ptr [eax],14h", 0x62, 0xf3, 0xd5, 0x28, 0x23, 0x38, 0x14);
    FCML_I64("vshuff64x2 zmm15,zmm7,zmmword ptr [rax],14h", 0x62, 0x73, 0xc5, 0x48, 0x23, 0x38, 0x14);
    FCML_I32("vshuff64x2 zmm7,zmm3,zmmword ptr [eax],14h", 0x62, 0xf3, 0xe5, 0x48, 0x23, 0x38, 0x14);
    FCML_I64("vshuff64x2 ymm14,ymm7,ymm6,14h", 0x62, 0x73, 0xc5, 0x28, 0x23, 0xf6, 0x14);
    FCML_I32("vshuff64x2 ymm6,ymm3,ymm5,14h", 0x62, 0xf3, 0xe5, 0x28, 0x23, 0xf5, 0x14);
    FCML_I64("vshuff64x2 zmm6,zmm15,zmm4,14h", 0x62, 0xf3, 0x85, 0x48, 0x23, 0xf4, 0x14);
    FCML_I32("vshuff64x2 zmm6,zmm6,zmm4,14h", 0x62, 0xf3, 0xcd, 0x48, 0x23, 0xf4, 0x14);
    FCML_I32("vshuff64x2 zmm1,zmm2,zmmword ptr [esp+00000200h],14h", 0x62, 0xf3, 0xed, 0x48, 0x23, 0x4c, 0x24, 0x08, 0x14);
    FCML_I64("vshuff64x2 zmm1,zmm2,zmmword ptr [rsp+0000000000000200h],14h", 0x62, 0xf3, 0xed, 0x48, 0x23, 0x4c, 0x24, 0x08, 0x14);
    FCML_I32("vshuff64x2 ymm1,ymm2,ymmword ptr [esp+00000100h],14h", 0x62, 0xf3, 0xed, 0x28, 0x23, 0x4c, 0x24, 0x08, 0x14);
    FCML_I64("vshuff64x2 ymm1,ymm2,ymmword ptr [rsp+0000000000000100h],14h", 0x62, 0xf3, 0xed, 0x28, 0x23, 0x4c, 0x24, 0x08, 0x14);
    FCML_I64("vshuff64x2 ymm10{k4}{z},ymm14,ymmword ptr [r9+r8],14h", 0x62, 0x13, 0x8d, 0xac, 0x23, 0x14, 0x01, 0x14);
    FCML_I32("vshuff64x2 ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax],14h", 0x62, 0xf3, 0xc5, 0xad, 0x23, 0x14, 0x01, 0x14);
    FCML_I64("vshuff64x2 zmm10{k4}{z},zmm14,zmmword ptr [r9+r8],14h", 0x62, 0x13, 0x8d, 0xcc, 0x23, 0x14, 0x01, 0x14);
    FCML_I32("vshuff64x2 zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax],14h", 0x62, 0xf3, 0xc5, 0xcd, 0x23, 0x14, 0x01, 0x14);
    FCML_I64("vshuff64x2 ymm10{k4},ymm14,ymmword ptr [r9+r8],14h", 0x62, 0x13, 0x8d, 0x2c, 0x23, 0x14, 0x01, 0x14);
    FCML_I32("vshuff64x2 ymm2{k5},ymm7,ymmword ptr [ecx+eax],14h", 0x62, 0xf3, 0xc5, 0x2d, 0x23, 0x14, 0x01, 0x14);
    FCML_I64("vshuff64x2 zmm10{k4},zmm14,zmmword ptr [r9+r8],14h", 0x62, 0x13, 0x8d, 0x4c, 0x23, 0x14, 0x01, 0x14);
    FCML_I32("vshuff64x2 zmm2{k5},zmm7,zmmword ptr [ecx+eax],14h", 0x62, 0xf3, 0xc5, 0x4d, 0x23, 0x14, 0x01, 0x14);
    FCML_I64("vshuff64x2 zmm31,zmm21,mmword ptr [rsi]{1to8},14h", 0x62, 0x63, 0xd5, 0x50, 0x23, 0x3e, 0x14);
    FCML_I64("vshuff64x2 ymm31,ymm21,mmword ptr [rsi]{1to4},14h", 0x62, 0x63, 0xd5, 0x30, 0x23, 0x3e, 0x14);
    FCML_I32("vshuff64x2 zmm1,zmm2,mmword ptr [esi]{1to8},14h", 0x62, 0xf3, 0xed, 0x58, 0x23, 0x0e, 0x14);
    FCML_I64("vshuff64x2 ymm31{k7}{z},ymm21,mmword ptr [rsi]{1to4},14h", 0x62, 0x63, 0xd5, 0xb7, 0x23, 0x3e, 0x14);
    FCML_I32("vshuff64x2 zmm1,zmm2,mmword ptr [esp+00000040h]{1to8},14h", 0x62, 0xf3, 0xed, 0x58, 0x23, 0x4c, 0x24, 0x08, 0x14);
    FCML_I64("vshuff64x2 zmm1,zmm2,mmword ptr [rsp+0000000000000040h]{1to8},14h", 0x62, 0xf3, 0xed, 0x58, 0x23, 0x4c, 0x24, 0x08, 0x14);
    FCML_I32("vshuff64x2 ymm1,ymm2,mmword ptr [esp+00000040h]{1to4},14h", 0x62, 0xf3, 0xed, 0x38, 0x23, 0x4c, 0x24, 0x08, 0x14);
    FCML_I64("vshuff64x2 ymm1,ymm2,mmword ptr [rsp+0000000000000040h]{1to4},14h", 0x62, 0xf3, 0xed, 0x38, 0x23, 0x4c, 0x24, 0x08, 0x14);
}

void fcml_tf_instruction_VSHUFI64X2(void) {
    FCML_I64("vshufi64x2 ymm15,ymm7,ymmword ptr [rax],14h", 0x62, 0x73, 0xc5, 0x28, 0x43, 0x38, 0x14);
    FCML_I32("vshufi64x2 ymm7,ymm5,ymmword ptr [eax],14h", 0x62, 0xf3, 0xd5, 0x28, 0x43, 0x38, 0x14);
    FCML_I64("vshufi64x2 zmm15,zmm7,zmmword ptr [rax],14h", 0x62, 0x73, 0xc5, 0x48, 0x43, 0x38, 0x14);
    FCML_I32("vshufi64x2 zmm7,zmm3,zmmword ptr [eax],14h", 0x62, 0xf3, 0xe5, 0x48, 0x43, 0x38, 0x14);
    FCML_I64("vshufi64x2 ymm14,ymm7,ymm6,14h", 0x62, 0x73, 0xc5, 0x28, 0x43, 0xf6, 0x14);
    FCML_I32("vshufi64x2 ymm6,ymm3,ymm5,14h", 0x62, 0xf3, 0xe5, 0x28, 0x43, 0xf5, 0x14);
    FCML_I64("vshufi64x2 zmm6,zmm15,zmm4,14h", 0x62, 0xf3, 0x85, 0x48, 0x43, 0xf4, 0x14);
    FCML_I32("vshufi64x2 zmm6,zmm6,zmm4,14h", 0x62, 0xf3, 0xcd, 0x48, 0x43, 0xf4, 0x14);
    FCML_I32("vshufi64x2 zmm1,zmm2,zmmword ptr [esp+00000200h],14h", 0x62, 0xf3, 0xed, 0x48, 0x43, 0x4c, 0x24, 0x08, 0x14);
    FCML_I64("vshufi64x2 zmm1,zmm2,zmmword ptr [rsp+0000000000000200h],14h", 0x62, 0xf3, 0xed, 0x48, 0x43, 0x4c, 0x24, 0x08, 0x14);
    FCML_I32("vshufi64x2 ymm1,ymm2,ymmword ptr [esp+00000100h],14h", 0x62, 0xf3, 0xed, 0x28, 0x43, 0x4c, 0x24, 0x08, 0x14);
    FCML_I64("vshufi64x2 ymm1,ymm2,ymmword ptr [rsp+0000000000000100h],14h", 0x62, 0xf3, 0xed, 0x28, 0x43, 0x4c, 0x24, 0x08, 0x14);
    FCML_I64("vshufi64x2 ymm10{k4}{z},ymm14,ymmword ptr [r9+r8],14h", 0x62, 0x13, 0x8d, 0xac, 0x43, 0x14, 0x01, 0x14);
    FCML_I32("vshufi64x2 ymm2{k5}{z},ymm7,ymmword ptr [ecx+eax],14h", 0x62, 0xf3, 0xc5, 0xad, 0x43, 0x14, 0x01, 0x14);
    FCML_I64("vshufi64x2 zmm10{k4}{z},zmm14,zmmword ptr [r9+r8],14h", 0x62, 0x13, 0x8d, 0xcc, 0x43, 0x14, 0x01, 0x14);
    FCML_I32("vshufi64x2 zmm2{k5}{z},zmm7,zmmword ptr [ecx+eax],14h", 0x62, 0xf3, 0xc5, 0xcd, 0x43, 0x14, 0x01, 0x14);
    FCML_I64("vshufi64x2 ymm10{k4},ymm14,ymmword ptr [r9+r8],14h", 0x62, 0x13, 0x8d, 0x2c, 0x43, 0x14, 0x01, 0x14);
    FCML_I32("vshufi64x2 ymm2{k5},ymm7,ymmword ptr [ecx+eax],14h", 0x62, 0xf3, 0xc5, 0x2d, 0x43, 0x14, 0x01, 0x14);
    FCML_I64("vshufi64x2 zmm10{k4},zmm14,zmmword ptr [r9+r8],14h", 0x62, 0x13, 0x8d, 0x4c, 0x43, 0x14, 0x01, 0x14);
    FCML_I32("vshufi64x2 zmm2{k5},zmm7,zmmword ptr [ecx+eax],14h", 0x62, 0xf3, 0xc5, 0x4d, 0x43, 0x14, 0x01, 0x14);
    FCML_I64("vshufi64x2 zmm31,zmm21,mmword ptr [rsi]{1to8},14h", 0x62, 0x63, 0xd5, 0x50, 0x43, 0x3e, 0x14);
    FCML_I64("vshufi64x2 ymm31,ymm21,mmword ptr [rsi]{1to4},14h", 0x62, 0x63, 0xd5, 0x30, 0x43, 0x3e, 0x14);
    FCML_I32("vshufi64x2 zmm1,zmm2,mmword ptr [esi]{1to8},14h", 0x62, 0xf3, 0xed, 0x58, 0x43, 0x0e, 0x14);
    FCML_I64("vshufi64x2 ymm31{k7}{z},ymm21,mmword ptr [rsi]{1to4},14h", 0x62, 0x63, 0xd5, 0xb7, 0x43, 0x3e, 0x14);
    FCML_I32("vshufi64x2 zmm1,zmm2,mmword ptr [esp+00000040h]{1to8},14h", 0x62, 0xf3, 0xed, 0x58, 0x43, 0x4c, 0x24, 0x08, 0x14);
    FCML_I64("vshufi64x2 zmm1,zmm2,mmword ptr [rsp+0000000000000040h]{1to8},14h", 0x62, 0xf3, 0xed, 0x58, 0x43, 0x4c, 0x24, 0x08, 0x14);
    FCML_I32("vshufi64x2 ymm1,ymm2,mmword ptr [esp+00000040h]{1to4},14h", 0x62, 0xf3, 0xed, 0x38, 0x43, 0x4c, 0x24, 0x08, 0x14);
    FCML_I64("vshufi64x2 ymm1,ymm2,mmword ptr [rsp+0000000000000040h]{1to4},14h", 0x62, 0xf3, 0xed, 0x38, 0x43, 0x4c, 0x24, 0x08, 0x14);
}

void fcml_tf_instruction_V4FMADDPS(void) {
    FCML_I64("v4fmaddps zmm2,zmm4,oword ptr [rax]", 0x62, 0xf2, 0x5f, 0x48, 0x9a, 0x10);
    FCML_I64("v4fmaddps zmm2,zmm4,oword ptr [rax+0000000000000040h]", 0x62, 0xf2, 0x5f, 0x48, 0x9a, 0x50, 0x04);
    FCML_A64("v4fmaddps (%rax),%zmm4,%zmm2", 0x62, 0xf2, 0x5f, 0x48, 0x9a, 0x10);
    FCML_A64("v4fmaddps (%rax),%zmm4,%zmm2{%k2}", 0x62, 0xf2, 0x5f, 0x4a, 0x9a, 0x10);
    FCML_A64("v4fmaddps (%rax),%zmm4,%zmm2{%k1}{z}", 0x62, 0xf2, 0x5f, 0xc9, 0x9a, 0x10);
    FCML_A64("v4fmaddps 0x0000000000000040(%rax),%zmm4,%zmm2", 0x62, 0xf2, 0x5f, 0x48, 0x9a, 0x50, 0x04);
    FCML_A32("v4fmaddps (%eax),%zmm4,%zmm2", 0x62, 0xf2, 0x5f, 0x48, 0x9a, 0x10);
    FCML_A32("v4fmaddps (%eax),%zmm4,%zmm2{%k2}", 0x62, 0xf2, 0x5f, 0x4a, 0x9a, 0x10);
    FCML_A32("v4fmaddps (%eax),%zmm4,%zmm2{%k1}{z}", 0x62, 0xf2, 0x5f, 0xc9, 0x9a, 0x10);
    FCML_A32("v4fmaddps 0x00000040(%eax),%zmm4,%zmm2", 0x62, 0xf2, 0x5f, 0x48, 0x9a, 0x50, 0x04);
}

void fcml_tf_instruction_V4FNMADDPS(void) {
    FCML_I64("v4fnmaddps zmm2,zmm4,oword ptr [rax]", 0x62, 0xf2, 0x5f, 0x48, 0xaa, 0x10);
    FCML_I64("v4fnmaddps zmm2,zmm4,oword ptr [rax+0000000000000040h]", 0x62, 0xf2, 0x5f, 0x48, 0xaa, 0x50, 0x04);
    FCML_A64("v4fnmaddps (%rax),%zmm4,%zmm2", 0x62, 0xf2, 0x5f, 0x48, 0xaa, 0x10);
    FCML_A64("v4fnmaddps (%rax),%zmm4,%zmm2{%k2}", 0x62, 0xf2, 0x5f, 0x4a, 0xaa, 0x10);
    FCML_A64("v4fnmaddps (%rax),%zmm4,%zmm2{%k1}{z}", 0x62, 0xf2, 0x5f, 0xc9, 0xaa, 0x10);
    FCML_A64("v4fnmaddps 0x0000000000000040(%rax),%zmm4,%zmm2", 0x62, 0xf2, 0x5f, 0x48, 0xaa, 0x50, 0x04);
    FCML_A32("v4fnmaddps (%eax),%zmm4,%zmm2", 0x62, 0xf2, 0x5f, 0x48, 0xaa, 0x10);
    FCML_A32("v4fnmaddps (%eax),%zmm4,%zmm2{%k2}", 0x62, 0xf2, 0x5f, 0x4a, 0xaa, 0x10);
    FCML_A32("v4fnmaddps (%eax),%zmm4,%zmm2{%k1}{z}", 0x62, 0xf2, 0x5f, 0xc9, 0xaa, 0x10);
    FCML_A32("v4fnmaddps 0x00000040(%eax),%zmm4,%zmm2", 0x62, 0xf2, 0x5f, 0x48, 0xaa, 0x50, 0x04);
}

void fcml_tf_instruction_V4FMADDSS(void) {
    FCML_I64("v4fmaddss xmm2,xmm4,oword ptr [rax]", 0x62, 0xf2, 0x5f, 0x08, 0x9b, 0x10);
    FCML_I64("v4fmaddss xmm2,xmm4,oword ptr [rax+0000000000000040h]", 0x62, 0xf2, 0x5f, 0x08, 0x9b, 0x50, 0x04);
    FCML_A64("v4fmaddss (%rax),%xmm4,%xmm2", 0x62, 0xf2, 0x5f, 0x08, 0x9b, 0x10);
    FCML_A64("v4fmaddss (%rax),%xmm4,%xmm2{%k2}", 0x62, 0xf2, 0x5f, 0x0a, 0x9b, 0x10);
    FCML_A64("v4fmaddss (%rax),%xmm4,%xmm2{%k1}{z}", 0x62, 0xf2, 0x5f, 0x89, 0x9b, 0x10);
    FCML_A64("v4fmaddss 0x0000000000000040(%rax),%xmm4,%xmm2", 0x62, 0xf2, 0x5f, 0x08, 0x9b, 0x50, 0x04);
    FCML_A32("v4fmaddss (%eax),%xmm4,%xmm2", 0x62, 0xf2, 0x5f, 0x08, 0x9b, 0x10);
    FCML_A32("v4fmaddss (%eax),%xmm4,%xmm2{%k2}", 0x62, 0xf2, 0x5f, 0x0a, 0x9b, 0x10);
    FCML_A32("v4fmaddss (%eax),%xmm4,%xmm2{%k1}{z}", 0x62, 0xf2, 0x5f, 0x89, 0x9b, 0x10);
    FCML_A32("v4fmaddss 0x00000040(%eax),%xmm4,%xmm2", 0x62, 0xf2, 0x5f, 0x08, 0x9b, 0x50, 0x04);
}

void fcml_tf_instruction_V4FNMADDSS(void) {
    FCML_I64("v4fnmaddss xmm2,xmm4,oword ptr [rax]", 0x62, 0xf2, 0x5f, 0x08, 0xab, 0x10);
    FCML_I64("v4fnmaddss xmm2,xmm4,oword ptr [rax+0000000000000040h]", 0x62, 0xf2, 0x5f, 0x08, 0xab, 0x50, 0x04);
    FCML_A64("v4fnmaddss (%rax),%xmm4,%xmm2", 0x62, 0xf2, 0x5f, 0x08, 0xab, 0x10);
    FCML_A64("v4fnmaddss (%rax),%xmm4,%xmm2{%k2}", 0x62, 0xf2, 0x5f, 0x0a, 0xab, 0x10);
    FCML_A64("v4fnmaddss (%rax),%xmm4,%xmm2{%k1}{z}", 0x62, 0xf2, 0x5f, 0x89, 0xab, 0x10);
    FCML_A64("v4fnmaddss 0x0000000000000040(%rax),%xmm4,%xmm2", 0x62, 0xf2, 0x5f, 0x08, 0xab, 0x50, 0x04);
    FCML_A32("v4fnmaddss (%eax),%xmm4,%xmm2", 0x62, 0xf2, 0x5f, 0x08, 0xab, 0x10);
    FCML_A32("v4fnmaddss (%eax),%xmm4,%xmm2{%k2}", 0x62, 0xf2, 0x5f, 0x0a, 0xab, 0x10);
    FCML_A32("v4fnmaddss (%eax),%xmm4,%xmm2{%k1}{z}", 0x62, 0xf2, 0x5f, 0x89, 0xab, 0x10);
    FCML_A32("v4fnmaddss 0x00000040(%eax),%xmm4,%xmm2", 0x62, 0xf2, 0x5f, 0x08, 0xab, 0x50, 0x04);
}

void fcml_tf_instruction_VEXP2PD(void) {
    FCML_I64("vexp2pd zmm2,zmmword ptr [rax]", 0x62, 0xf2, 0xfd, 0x48, 0xc8, 0x10);
    FCML_I64("vexp2pd zmm2{k3},zmmword ptr [rax]", 0x62, 0xf2, 0xfd, 0x4b, 0xc8, 0x10);
    FCML_I64("vexp2pd zmm2{k4}{z},zmmword ptr [rax]", 0x62, 0xf2, 0xfd, 0xcc, 0xc8, 0x10);
    FCML_I64("vexp2pd zmm2,zmm24", 0x62, 0x92, 0xfd, 0x48, 0xc8, 0xd0);
    FCML_I64("vexp2pd zmm2{k3},zmm13", 0x62, 0xd2, 0xfd, 0x4b, 0xc8, 0xd5);
    FCML_I64("vexp2pd zmm2{k4}{z},zmm3", 0x62, 0xf2, 0xfd, 0xcc, 0xc8, 0xd3);
    FCML_I64("vexp2pd zmm2,mmword ptr [rax]{1to8}", 0x62, 0xf2, 0xfd, 0x58, 0xc8, 0x10);
    FCML_A64("vexp2pd 0x0000000000000040(%rax),%zmm2", 0x62, 0xf2, 0xfd, 0x48, 0xc8, 0x50, 0x01);
    FCML_I64("vexp2pd zmm2,zmm5,{sae}", 0x62, 0xf2, 0xfd, 0x18, 0xc8, 0xd5);
}

void fcml_tf_instruction_VEXP2PS(void) {
    FCML_I64("vexp2ps zmm2,zmmword ptr [rax]", 0x62, 0xf2, 0x7d, 0x48, 0xc8, 0x10);
    FCML_I64("vexp2ps zmm2{k3},zmmword ptr [rax]", 0x62, 0xf2, 0x7d, 0x4b, 0xc8, 0x10);
    FCML_I64("vexp2ps zmm2{k4}{z},zmmword ptr [rax]", 0x62, 0xf2, 0x7d, 0xcc, 0xc8, 0x10);
    FCML_I64("vexp2ps zmm2,zmm24", 0x62, 0x92, 0x7d, 0x48, 0xc8, 0xd0);
    FCML_I64("vexp2ps zmm2{k3},zmm13", 0x62, 0xd2, 0x7d, 0x4b, 0xc8, 0xd5);
    FCML_I64("vexp2ps zmm2{k4}{z},zmm3", 0x62, 0xf2, 0x7d, 0xcc, 0xc8, 0xd3);
    FCML_I64("vexp2ps zmm2,zmm5,{sae}", 0x62, 0xf2, 0x7d, 0x18, 0xc8, 0xd5);
    FCML_I64("vexp2ps zmm2,dword ptr [rax]{1to16}", 0x62, 0xf2, 0x7d, 0x58, 0xc8, 0x10);
    FCML_A64("vexp2ps 0x0000000000000040(%rax),%zmm2", 0x62, 0xf2, 0x7d, 0x48, 0xc8, 0x50, 0x01);
}

void fcml_tf_instruction_VGATHERPF0DPS(void) {
    FCML_I32("vgatherpf0dps dword ptr [eax+zmm5]{k1}", 0x62, 0xf2, 0x7d, 0x49, 0xc6, 0x0c, 0x28);
    FCML_I32("vgatherpf0dps dword ptr [eax+zmm5+00000020h]{k3}", 0x62, 0xf2, 0x7d, 0x4b, 0xc6, 0x4c, 0x28, 0x08);
    FCML_A64("vgatherpf0dps (%rax,%zmm5){%k1}", 0x62, 0xf2, 0x7d, 0x49, 0xc6, 0x0c, 0x28);
    FCML_A64("vgatherpf0dps 0x0000000000000020(%rax,%zmm5){%k3}", 0x62, 0xf2, 0x7d, 0x4b, 0xc6, 0x4c, 0x28, 0x08);
}

void fcml_tf_instruction_VGATHERPF0QPS(void) {
    FCML_I32("vgatherpf0qps mmword ptr [eax+zmm5]{k1}", 0x62, 0xf2, 0x7d, 0x49, 0xc7, 0x0c, 0x28);
    FCML_I32("vgatherpf0qps mmword ptr [eax+zmm5+00000020h]{k3}", 0x62, 0xf2, 0x7d, 0x4b, 0xc7, 0x4c, 0x28, 0x08);
    FCML_A64("vgatherpf0qps (%rax,%zmm5){%k1}", 0x62, 0xf2, 0x7d, 0x49, 0xc7, 0x0c, 0x28);
    FCML_A64("vgatherpf0qps 0x0000000000000020(%rax,%zmm5){%k3}", 0x62, 0xf2, 0x7d, 0x4b, 0xc7, 0x4c, 0x28, 0x08);
}

void fcml_tf_instruction_VGATHERPF0DPD(void) {
    FCML_I32("vgatherpf0dpd dword ptr [eax+ymm5]{k1}", 0x62, 0xf2, 0xfd, 0x49, 0xc6, 0x0c, 0x28);
    FCML_I32("vgatherpf0dpd dword ptr [eax+ymm5+00000020h]{k3}", 0x62, 0xf2, 0xfd, 0x4b, 0xc6, 0x4c, 0x28, 0x04);
    FCML_A64("vgatherpf0dpd (%rax,%ymm5){%k1}", 0x62, 0xf2, 0xfd, 0x49, 0xc6, 0x0c, 0x28);
    FCML_A64("vgatherpf0dpd 0x0000000000000020(%rax,%ymm5){%k3}", 0x62, 0xf2, 0xfd, 0x4b, 0xc6, 0x4c, 0x28, 0x04);
}

void fcml_tf_instruction_VGATHERPF0QPD(void) {
    FCML_I32("vgatherpf0qpd mmword ptr [eax+zmm5]{k1}", 0x62, 0xf2, 0xfd, 0x49, 0xc7, 0x0c, 0x28);
    FCML_I32("vgatherpf0qpd mmword ptr [eax+zmm5+00000020h]{k3}", 0x62, 0xf2, 0xfd, 0x4b, 0xc7, 0x4c, 0x28, 0x04);
    FCML_A64("vgatherpf0qpd (%rax,%zmm5){%k1}", 0x62, 0xf2, 0xfd, 0x49, 0xc7, 0x0c, 0x28);
    FCML_A64("vgatherpf0qpd 0x0000000000000020(%rax,%zmm5){%k3}", 0x62, 0xf2, 0xfd, 0x4b, 0xc7, 0x4c, 0x28, 0x04);
}

void fcml_tf_instruction_VGATHERPF1DPS(void) {
    FCML_I32("vgatherpf1dps dword ptr [eax+zmm5]{k1}", 0x62, 0xf2, 0x7d, 0x49, 0xc6, 0x14, 0x28);
    FCML_I32("vgatherpf1dps dword ptr [eax+zmm5+00000020h]{k3}", 0x62, 0xf2, 0x7d, 0x4b, 0xc6, 0x54, 0x28, 0x08);
    FCML_A64("vgatherpf1dps (%rax,%zmm5){%k1}", 0x62, 0xf2, 0x7d, 0x49, 0xc6, 0x14, 0x28);
    FCML_A64("vgatherpf1dps 0x0000000000000020(%rax,%zmm5){%k3}", 0x62, 0xf2, 0x7d, 0x4b, 0xc6, 0x54, 0x28, 0x08);
}

void fcml_tf_instruction_VGATHERPF1QPS(void) {
    FCML_I32("vgatherpf1qps mmword ptr [eax+zmm5]{k1}", 0x62, 0xf2, 0x7d, 0x49, 0xc7, 0x14, 0x28);
    FCML_I32("vgatherpf1qps mmword ptr [eax+zmm5+00000020h]{k3}", 0x62, 0xf2, 0x7d, 0x4b, 0xc7, 0x54, 0x28, 0x08);
    FCML_A64("vgatherpf1qps (%rax,%zmm5){%k1}", 0x62, 0xf2, 0x7d, 0x49, 0xc7, 0x14, 0x28);
    FCML_A64("vgatherpf1qps 0x0000000000000020(%rax,%zmm5){%k3}", 0x62, 0xf2, 0x7d, 0x4b, 0xc7, 0x54, 0x28, 0x08);
}

void fcml_tf_instruction_VGATHERPF1DPD(void) {
    FCML_I32("vgatherpf1dpd dword ptr [eax+ymm5]{k1}", 0x62, 0xf2, 0xfd, 0x49, 0xc6, 0x14, 0x28);
    FCML_I32("vgatherpf1dpd dword ptr [eax+ymm5+00000020h]{k3}", 0x62, 0xf2, 0xfd, 0x4b, 0xc6, 0x54, 0x28, 0x04);
    FCML_A64("vgatherpf1dpd (%rax,%ymm5){%k1}", 0x62, 0xf2, 0xfd, 0x49, 0xc6, 0x14, 0x28);
    FCML_A64("vgatherpf1dpd 0x0000000000000020(%rax,%ymm5){%k3}", 0x62, 0xf2, 0xfd, 0x4b, 0xc6, 0x54, 0x28, 0x04);
}

void fcml_tf_instruction_VGATHERPF1QPD(void) {
    FCML_I32("vgatherpf1qpd mmword ptr [eax+zmm5]{k1}", 0x62, 0xf2, 0xfd, 0x49, 0xc7, 0x14, 0x28);
    FCML_I32("vgatherpf1qpd mmword ptr [eax+zmm5+00000020h]{k3}", 0x62, 0xf2, 0xfd, 0x4b, 0xc7, 0x54, 0x28, 0x04);
    FCML_A64("vgatherpf1qpd (%rax,%zmm5){%k1}", 0x62, 0xf2, 0xfd, 0x49, 0xc7, 0x14, 0x28);
    FCML_A64("vgatherpf1qpd 0x0000000000000020(%rax,%zmm5){%k3}", 0x62, 0xf2, 0xfd, 0x4b, 0xc7, 0x54, 0x28, 0x04);
}

void fcml_tf_instruction_VP4DPWSSDS(void) {
    FCML_I64("vp4dpwssds zmm2,zmm4,oword ptr [rax]", 0x62, 0xf2, 0x5f, 0x48, 0x53, 0x10);
    FCML_I64("vp4dpwssds zmm2,zmm4,oword ptr [rax+0000000000000040h]", 0x62, 0xf2, 0x5f, 0x48, 0x53, 0x50, 0x04);
    FCML_A64("vp4dpwssds (%rax),%zmm4,%zmm2", 0x62, 0xf2, 0x5f, 0x48, 0x53, 0x10);
    FCML_A64("vp4dpwssds (%rax),%zmm4,%zmm2{%k2}", 0x62, 0xf2, 0x5f, 0x4a, 0x53, 0x10);
    FCML_A64("vp4dpwssds (%rax),%zmm4,%zmm2{%k1}{z}", 0x62, 0xf2, 0x5f, 0xc9, 0x53, 0x10);
    FCML_A64("vp4dpwssds 0x0000000000000040(%rax),%zmm4,%zmm2", 0x62, 0xf2, 0x5f, 0x48, 0x53, 0x50, 0x04);
    FCML_A32("vp4dpwssds (%eax),%zmm4,%zmm2", 0x62, 0xf2, 0x5f, 0x48, 0x53, 0x10);
    FCML_A32("vp4dpwssds (%eax),%zmm4,%zmm2{%k2}", 0x62, 0xf2, 0x5f, 0x4a, 0x53, 0x10);
    FCML_A32("vp4dpwssds (%eax),%zmm4,%zmm2{%k1}{z}", 0x62, 0xf2, 0x5f, 0xc9, 0x53, 0x10);
    FCML_A32("vp4dpwssds 0x00000040(%eax),%zmm4,%zmm2", 0x62, 0xf2, 0x5f, 0x48, 0x53, 0x50, 0x04);
}

void fcml_tf_instruction_VP4DPWSSD(void) {
    FCML_I64("vp4dpwssd zmm2,zmm4,oword ptr [rax]", 0x62, 0xf2, 0x5f, 0x48, 0x52, 0x10);
    FCML_I64("vp4dpwssd zmm2,zmm4,oword ptr [rax+0000000000000040h]", 0x62, 0xf2, 0x5f, 0x48, 0x52, 0x50, 0x04);
    FCML_A64("vp4dpwssd (%rax),%zmm4,%zmm2", 0x62, 0xf2, 0x5f, 0x48, 0x52, 0x10);
    FCML_A64("vp4dpwssd (%rax),%zmm4,%zmm2{%k2}", 0x62, 0xf2, 0x5f, 0x4a, 0x52, 0x10);
    FCML_A64("vp4dpwssd (%rax),%zmm4,%zmm2{%k1}{z}", 0x62, 0xf2, 0x5f, 0xc9, 0x52, 0x10);
    FCML_A64("vp4dpwssd 0x0000000000000040(%rax),%zmm4,%zmm2", 0x62, 0xf2, 0x5f, 0x48, 0x52, 0x50, 0x04);
    FCML_A32("vp4dpwssd (%eax),%zmm4,%zmm2", 0x62, 0xf2, 0x5f, 0x48, 0x52, 0x10);
    FCML_A32("vp4dpwssd (%eax),%zmm4,%zmm2{%k2}", 0x62, 0xf2, 0x5f, 0x4a, 0x52, 0x10);
    FCML_A32("vp4dpwssd (%eax),%zmm4,%zmm2{%k1}{z}", 0x62, 0xf2, 0x5f, 0xc9, 0x52, 0x10);
    FCML_A32("vp4dpwssd 0x00000040(%eax),%zmm4,%zmm2", 0x62, 0xf2, 0x5f, 0x48, 0x52, 0x50, 0x04);
}

void fcml_tf_instruction_VRCP28PD(void) {
    FCML_I64("vrcp28pd zmm2,zmmword ptr [rax]", 0x62, 0xf2, 0xfd, 0x48, 0xca, 0x10);
    FCML_I64("vrcp28pd zmm2{k3},zmmword ptr [rax]", 0x62, 0xf2, 0xfd, 0x4b, 0xca, 0x10);
    FCML_I64("vrcp28pd zmm2{k4}{z},zmmword ptr [rax]", 0x62, 0xf2, 0xfd, 0xcc, 0xca, 0x10);
    FCML_I64("vrcp28pd zmm2,zmm24", 0x62, 0x92, 0xfd, 0x48, 0xca, 0xd0);
    FCML_I64("vrcp28pd zmm2{k3},zmm13", 0x62, 0xd2, 0xfd, 0x4b, 0xca, 0xd5);
    FCML_I64("vrcp28pd zmm2{k4}{z},zmm3", 0x62, 0xf2, 0xfd, 0xcc, 0xca, 0xd3);
    FCML_I64("vrcp28pd zmm2,mmword ptr [rax]{1to8}", 0x62, 0xf2, 0xfd, 0x58, 0xca, 0x10);
    FCML_A64("vrcp28pd 0x0000000000000040(%rax),%zmm2", 0x62, 0xf2, 0xfd, 0x48, 0xca, 0x50, 0x01);
    FCML_I64("vrcp28pd zmm2,zmm5,{sae}", 0x62, 0xf2, 0xfd, 0x18, 0xca, 0xd5);
}

void fcml_tf_instruction_VRCP28SD(void) {
    FCML_I64("vrcp28sd xmm2,xmm12,mmword ptr [rax]", 0x62, 0xf2, 0x9d, 0x08, 0xcb, 0x10);
    FCML_I64("vrcp28sd xmm2{k3},xmm12,mmword ptr [rax]", 0x62, 0xf2, 0x9d, 0x0b, 0xcb, 0x10);
    FCML_I64("vrcp28sd xmm2{k4}{z},xmm12,mmword ptr [rax]", 0x62, 0xf2, 0x9d, 0x8c, 0xcb, 0x10);
    FCML_I64("vrcp28sd xmm2,xmm12,xmm24", 0x62, 0x92, 0x9d, 0x08, 0xcb, 0xd0);
    FCML_I64("vrcp28sd xmm2{k3},xmm12,xmm13", 0x62, 0xd2, 0x9d, 0x0b, 0xcb, 0xd5);
    FCML_I64("vrcp28sd xmm2{k4}{z},xmm12,xmm3", 0x62, 0xf2, 0x9d, 0x8c, 0xcb, 0xd3);
    FCML_A64("vrcp28sd 0x0000000000000040(%rax),%xmm12,%xmm2", 0x62, 0xf2, 0x9d, 0x08, 0xcb, 0x50, 0x04);
    FCML_I64("vrcp28sd xmm2,xmm12,xmm5,{sae}", 0x62, 0xf2, 0x9d, 0x18, 0xcb, 0xd5);
}

void fcml_tf_instruction_VRCP28PS(void) {
    FCML_I64("vrcp28ps zmm2,zmmword ptr [rax]", 0x62, 0xf2, 0x7d, 0x48, 0xca, 0x10);
    FCML_I64("vrcp28ps zmm2{k3},zmmword ptr [rax]", 0x62, 0xf2, 0x7d, 0x4b, 0xca, 0x10);
    FCML_I64("vrcp28ps zmm2{k4}{z},zmmword ptr [rax]", 0x62, 0xf2, 0x7d, 0xcc, 0xca, 0x10);
    FCML_I64("vrcp28ps zmm2,zmm24", 0x62, 0x92, 0x7d, 0x48, 0xca, 0xd0);
    FCML_I64("vrcp28ps zmm2{k3},zmm13", 0x62, 0xd2, 0x7d, 0x4b, 0xca, 0xd5);
    FCML_I64("vrcp28ps zmm2{k4}{z},zmm3", 0x62, 0xf2, 0x7d, 0xcc, 0xca, 0xd3);
    FCML_I64("vrcp28ps zmm2,dword ptr [rax]{1to16}", 0x62, 0xf2, 0x7d, 0x58, 0xca, 0x10);
    FCML_A64("vrcp28ps 0x0000000000000040(%rax),%zmm2", 0x62, 0xf2, 0x7d, 0x48, 0xca, 0x50, 0x01);
    FCML_I64("vrcp28ps zmm2,zmm5,{sae}", 0x62, 0xf2, 0x7d, 0x18, 0xca, 0xd5);
}

void fcml_tf_instruction_VRCP28SS(void) {
    FCML_I64("vrcp28ss xmm2,xmm12,dword ptr [rax]", 0x62, 0xf2, 0x1d, 0x08, 0xcb, 0x10);
    FCML_I64("vrcp28ss xmm2{k3},xmm12,dword ptr [rax]", 0x62, 0xf2, 0x1d, 0x0b, 0xcb, 0x10);
    FCML_I64("vrcp28ss xmm2{k4}{z},xmm12,dword ptr [rax]", 0x62, 0xf2, 0x1d, 0x8c, 0xcb, 0x10);
    FCML_I64("vrcp28ss xmm2,xmm12,xmm24", 0x62, 0x92, 0x1d, 0x08, 0xcb, 0xd0);
    FCML_I64("vrcp28ss xmm2{k3},xmm12,xmm13", 0x62, 0xd2, 0x1d, 0x0b, 0xcb, 0xd5);
    FCML_I64("vrcp28ss xmm2{k4}{z},xmm12,xmm3", 0x62, 0xf2, 0x1d, 0x8c, 0xcb, 0xd3);
    FCML_A64("vrcp28ss 0x0000000000000040(%rax),%xmm12,%xmm2", 0x62, 0xf2, 0x1d, 0x08, 0xcb, 0x50, 0x04);
    FCML_I64("vrcp28ss xmm2,xmm12,xmm5,{sae}", 0x62, 0xf2, 0x1d, 0x18, 0xcb, 0xd5);
}

void fcml_tf_instruction_VRSQRT28PD(void) {
    FCML_I64("vrsqrt28pd zmm2,zmmword ptr [rax]", 0x62, 0xf2, 0xfd, 0x48, 0xcc, 0x10);
    FCML_I64("vrsqrt28pd zmm2{k3},zmmword ptr [rax]", 0x62, 0xf2, 0xfd, 0x4b, 0xcc, 0x10);
    FCML_I64("vrsqrt28pd zmm2{k4}{z},zmmword ptr [rax]", 0x62, 0xf2, 0xfd, 0xcc, 0xcc, 0x10);
    FCML_I64("vrsqrt28pd zmm2,zmm24", 0x62, 0x92, 0xfd, 0x48, 0xcc, 0xd0);
    FCML_I64("vrsqrt28pd zmm2{k3},zmm13", 0x62, 0xd2, 0xfd, 0x4b, 0xcc, 0xd5);
    FCML_I64("vrsqrt28pd zmm2{k4}{z},zmm3", 0x62, 0xf2, 0xfd, 0xcc, 0xcc, 0xd3);
    FCML_I64("vrsqrt28pd zmm2,mmword ptr [rax]{1to8}", 0x62, 0xf2, 0xfd, 0x58, 0xcc, 0x10);
    FCML_A64("vrsqrt28pd 0x0000000000000040(%rax),%zmm2", 0x62, 0xf2, 0xfd, 0x48, 0xcc, 0x50, 0x01);
    FCML_I64("vrsqrt28pd zmm2,zmm5,{sae}", 0x62, 0xf2, 0xfd, 0x18, 0xcc, 0xd5);
}

void fcml_tf_instruction_VRSQRT28SD(void) {
    FCML_I64("vrsqrt28sd xmm2,xmm12,mmword ptr [rax]", 0x62, 0xf2, 0x9d, 0x08, 0xcd, 0x10);
    FCML_I64("vrsqrt28sd xmm2{k3},xmm12,mmword ptr [rax]", 0x62, 0xf2, 0x9d, 0x0b, 0xcd, 0x10);
    FCML_I64("vrsqrt28sd xmm2{k4}{z},xmm12,mmword ptr [rax]", 0x62, 0xf2, 0x9d, 0x8c, 0xcd, 0x10);
    FCML_I64("vrsqrt28sd xmm2,xmm12,xmm24", 0x62, 0x92, 0x9d, 0x08, 0xcd, 0xd0);
    FCML_I64("vrsqrt28sd xmm2{k3},xmm12,xmm13", 0x62, 0xd2, 0x9d, 0x0b, 0xcd, 0xd5);
    FCML_I64("vrsqrt28sd xmm2{k4}{z},xmm12,xmm3", 0x62, 0xf2, 0x9d, 0x8c, 0xcd, 0xd3);
    FCML_A64("vrsqrt28sd 0x0000000000000040(%rax),%xmm12,%xmm2", 0x62, 0xf2, 0x9d, 0x08, 0xcd, 0x50, 0x04);
    FCML_I64("vrsqrt28sd xmm2,xmm12,xmm5,{sae}", 0x62, 0xf2, 0x9d, 0x18, 0xcd, 0xd5);
}

void fcml_tf_instruction_VRSQRT28PS(void) {
    FCML_I64("vrsqrt28ps zmm2,zmmword ptr [rax]", 0x62, 0xf2, 0x7d, 0x48, 0xcc, 0x10);
    FCML_I64("vrsqrt28ps zmm2{k3},zmmword ptr [rax]", 0x62, 0xf2, 0x7d, 0x4b, 0xcc, 0x10);
    FCML_I64("vrsqrt28ps zmm2{k4}{z},zmmword ptr [rax]", 0x62, 0xf2, 0x7d, 0xcc, 0xcc, 0x10);
    FCML_I64("vrsqrt28ps zmm2,zmm24", 0x62, 0x92, 0x7d, 0x48, 0xcc, 0xd0);
    FCML_I64("vrsqrt28ps zmm2{k3},zmm13", 0x62, 0xd2, 0x7d, 0x4b, 0xcc, 0xd5);
    FCML_I64("vrsqrt28ps zmm2{k4}{z},zmm3", 0x62, 0xf2, 0x7d, 0xcc, 0xcc, 0xd3);
    FCML_I64("vrsqrt28ps zmm2,dword ptr [rax]{1to16}", 0x62, 0xf2, 0x7d, 0x58, 0xcc, 0x10);
    FCML_A64("vrsqrt28ps 0x0000000000000040(%rax),%zmm2", 0x62, 0xf2, 0x7d, 0x48, 0xcc, 0x50, 0x01);
    FCML_I64("vrsqrt28ps zmm2,zmm5,{sae}", 0x62, 0xf2, 0x7d, 0x18, 0xcc, 0xd5);
}

void fcml_tf_instruction_VRSQRT28SS(void) {
    FCML_I64("vrsqrt28ss xmm2,xmm12,dword ptr [rax]", 0x62, 0xf2, 0x1d, 0x08, 0xcd, 0x10);
    FCML_I64("vrsqrt28ss xmm2{k3},xmm12,dword ptr [rax]", 0x62, 0xf2, 0x1d, 0x0b, 0xcd, 0x10);
    FCML_I64("vrsqrt28ss xmm2{k4}{z},xmm12,dword ptr [rax]", 0x62, 0xf2, 0x1d, 0x8c, 0xcd, 0x10);
    FCML_I64("vrsqrt28ss xmm2,xmm12,xmm24", 0x62, 0x92, 0x1d, 0x08, 0xcd, 0xd0);
    FCML_I64("vrsqrt28ss xmm2{k3},xmm12,xmm13", 0x62, 0xd2, 0x1d, 0x0b, 0xcd, 0xd5);
    FCML_I64("vrsqrt28ss xmm2{k4}{z},xmm12,xmm3", 0x62, 0xf2, 0x1d, 0x8c, 0xcd, 0xd3);
    FCML_A64("vrsqrt28ss 0x0000000000000040(%rax),%xmm12,%xmm2", 0x62, 0xf2, 0x1d, 0x08, 0xcd, 0x50, 0x04);
    FCML_I64("vrsqrt28ss xmm2,xmm12,xmm5,{sae}", 0x62, 0xf2, 0x1d, 0x18, 0xcd, 0xd5);
}

void fcml_tf_instruction_VSCATTERPF0DPS(void) {
    FCML_I32("vscatterpf1dps dword ptr [eax+zmm5]{k1}", 0x62, 0xf2, 0x7d, 0x49, 0xc6, 0x34, 0x28);
    FCML_I32("vscatterpf1dps dword ptr [eax+zmm5+00000020h]{k3}", 0x62, 0xf2, 0x7d, 0x4b, 0xc6, 0x74, 0x28, 0x08);
    FCML_A64("vscatterpf1dps (%rax,%zmm5){%k1}", 0x62, 0xf2, 0x7d, 0x49, 0xc6, 0x34, 0x28);
    FCML_A64("vscatterpf1dps 0x0000000000000020(%rax,%zmm5){%k3}", 0x62, 0xf2, 0x7d, 0x4b, 0xc6, 0x74, 0x28, 0x08);
}

void fcml_tf_instruction_VSCATTERPF0QPS(void) {
    FCML_I32("vscatterpf1qps mmword ptr [eax+zmm5]{k1}", 0x62, 0xf2, 0x7d, 0x49, 0xc7, 0x34, 0x28);
    FCML_I32("vscatterpf1qps mmword ptr [eax+zmm5+00000020h]{k3}", 0x62, 0xf2, 0x7d, 0x4b, 0xc7, 0x74, 0x28, 0x08);
    FCML_A64("vscatterpf1qps (%rax,%zmm5){%k1}", 0x62, 0xf2, 0x7d, 0x49, 0xc7, 0x34, 0x28);
    FCML_A64("vscatterpf1qps 0x0000000000000020(%rax,%zmm5){%k3}", 0x62, 0xf2, 0x7d, 0x4b, 0xc7, 0x74, 0x28, 0x08);
}

void fcml_tf_instruction_VSCATTERPF0DPD(void) {
    FCML_I32("vscatterpf1dpd dword ptr [eax+ymm5]{k1}", 0x62, 0xf2, 0xfd, 0x49, 0xc6, 0x34, 0x28);
    FCML_I32("vscatterpf1dpd dword ptr [eax+ymm5+00000020h]{k3}", 0x62, 0xf2, 0xfd, 0x4b, 0xc6, 0x74, 0x28, 0x04);
    FCML_A64("vscatterpf1dpd (%rax,%ymm5){%k1}", 0x62, 0xf2, 0xfd, 0x49, 0xc6, 0x34, 0x28);
    FCML_A64("vscatterpf1dpd 0x0000000000000020(%rax,%ymm5){%k3}", 0x62, 0xf2, 0xfd, 0x4b, 0xc6, 0x74, 0x28, 0x04);
}

void fcml_tf_instruction_VSCATTERPF0QPD(void) {
    FCML_I32("vscatterpf0qpd mmword ptr [eax+zmm5]{k1}", 0x62, 0xf2, 0xfd, 0x49, 0xc7, 0x2c, 0x28);
    FCML_I32("vscatterpf0qpd mmword ptr [eax+zmm5+00000020h]{k3}", 0x62, 0xf2, 0xfd, 0x4b, 0xc7, 0x6c, 0x28, 0x04);
    FCML_A64("vscatterpf0qpd (%rax,%zmm5){%k1}", 0x62, 0xf2, 0xfd, 0x49, 0xc7, 0x2c, 0x28);
    FCML_A64("vscatterpf0qpd 0x0000000000000020(%rax,%zmm5){%k3}", 0x62, 0xf2, 0xfd, 0x4b, 0xc7, 0x6c, 0x28, 0x04);
}

void fcml_tf_instruction_VSCATTERPF1DPS(void) {
    FCML_I32("vscatterpf1dps dword ptr [eax+zmm5]{k1}", 0x62, 0xf2, 0x7d, 0x49, 0xc6, 0x34, 0x28);
    FCML_I32("vscatterpf1dps dword ptr [eax+zmm5+00000020h]{k3}", 0x62, 0xf2, 0x7d, 0x4b, 0xc6, 0x74, 0x28, 0x08);
    FCML_A64("vscatterpf1dps (%rax,%zmm5){%k1}", 0x62, 0xf2, 0x7d, 0x49, 0xc6, 0x34, 0x28);
    FCML_A64("vscatterpf1dps 0x0000000000000020(%rax,%zmm5){%k3}", 0x62, 0xf2, 0x7d, 0x4b, 0xc6, 0x74, 0x28, 0x08);
}

void fcml_tf_instruction_VSCATTERPF1QPS(void) {
    FCML_I32("vscatterpf1qps mmword ptr [eax+zmm5]{k1}", 0x62, 0xf2, 0x7d, 0x49, 0xc7, 0x34, 0x28);
    FCML_I32("vscatterpf1qps mmword ptr [eax+zmm5+00000020h]{k3}", 0x62, 0xf2, 0x7d, 0x4b, 0xc7, 0x74, 0x28, 0x08);
    FCML_A64("vscatterpf1qps (%rax,%zmm5){%k1}", 0x62, 0xf2, 0x7d, 0x49, 0xc7, 0x34, 0x28);
    FCML_A64("vscatterpf1qps 0x0000000000000020(%rax,%zmm5){%k3}", 0x62, 0xf2, 0x7d, 0x4b, 0xc7, 0x74, 0x28, 0x08);
}

void fcml_tf_instruction_VSCATTERPF1DPD(void) {
    FCML_I32("vscatterpf1dpd dword ptr [eax+ymm5]{k1}", 0x62, 0xf2, 0xfd, 0x49, 0xc6, 0x34, 0x28);
    FCML_I32("vscatterpf1dpd dword ptr [eax+ymm5+00000020h]{k3}", 0x62, 0xf2, 0xfd, 0x4b, 0xc6, 0x74, 0x28, 0x04);
    FCML_A64("vscatterpf1dpd (%rax,%ymm5){%k1}", 0x62, 0xf2, 0xfd, 0x49, 0xc6, 0x34, 0x28);
    FCML_A64("vscatterpf1dpd 0x0000000000000020(%rax,%ymm5){%k3}", 0x62, 0xf2, 0xfd, 0x4b, 0xc6, 0x74, 0x28, 0x04);
}

void fcml_tf_instruction_VSCATTERPF1QPD(void) {
    FCML_I32("vscatterpf1qpd mmword ptr [eax+zmm5]{k1}", 0x62, 0xf2, 0xfd, 0x49, 0xc7, 0x34, 0x28);
    FCML_I32("vscatterpf1qpd mmword ptr [eax+zmm5+00000020h]{k3}", 0x62, 0xf2, 0xfd, 0x4b, 0xc7, 0x74, 0x28, 0x04);
    FCML_A64("vscatterpf1qpd (%rax,%zmm5){%k1}", 0x62, 0xf2, 0xfd, 0x49, 0xc7, 0x34, 0x28);
    FCML_A64("vscatterpf1qpd 0x0000000000000020(%rax,%zmm5){%k3}", 0x62, 0xf2, 0xfd, 0x4b, 0xc7, 0x74, 0x28, 0x04);
}

fcml_stf_test_case fctl_ti_instructions_v[] = {
    { "fcml_tf_instruction_VSCATTERPF1DPS", fcml_tf_instruction_VSCATTERPF1DPS },
    { "fcml_tf_instruction_VSCATTERPF1QPS", fcml_tf_instruction_VSCATTERPF1QPS },
    { "fcml_tf_instruction_VSCATTERPF1DPD", fcml_tf_instruction_VSCATTERPF1DPD },
    { "fcml_tf_instruction_VSCATTERPF1QPD", fcml_tf_instruction_VSCATTERPF1QPD },
    { "fcml_tf_instruction_VSCATTERPF0DPS", fcml_tf_instruction_VSCATTERPF0DPS },
    { "fcml_tf_instruction_VSCATTERPF0QPS", fcml_tf_instruction_VSCATTERPF0QPS },
    { "fcml_tf_instruction_VSCATTERPF0DPD", fcml_tf_instruction_VSCATTERPF0DPD },
    { "fcml_tf_instruction_VSCATTERPF0QPD", fcml_tf_instruction_VSCATTERPF0QPD },
    { "fcml_tf_instruction_VRSQRT28PD", fcml_tf_instruction_VRSQRT28PD },
    { "fcml_tf_instruction_VRSQRT28SD", fcml_tf_instruction_VRSQRT28SD },
    { "fcml_tf_instruction_VRSQRT28PS", fcml_tf_instruction_VRSQRT28PS },
    { "fcml_tf_instruction_VRSQRT28SS", fcml_tf_instruction_VRSQRT28SS },
    { "fcml_tf_instruction_VRCP28PD", fcml_tf_instruction_VRCP28PD },
    { "fcml_tf_instruction_VRCP28SD", fcml_tf_instruction_VRCP28SD },
    { "fcml_tf_instruction_VRCP28PS", fcml_tf_instruction_VRCP28PS },
    { "fcml_tf_instruction_VRCP28SS", fcml_tf_instruction_VRCP28SS },
    { "fcml_tf_instruction_VP4DPWSSDS", fcml_tf_instruction_VP4DPWSSDS },
    { "fcml_tf_instruction_VP4DPWSSD", fcml_tf_instruction_VP4DPWSSD },
    { "fcml_tf_instruction_VGATHERPF1DPS", fcml_tf_instruction_VGATHERPF1DPS },
    { "fcml_tf_instruction_VGATHERPF1QPS", fcml_tf_instruction_VGATHERPF1QPS },
    { "fcml_tf_instruction_VGATHERPF1DPD", fcml_tf_instruction_VGATHERPF1DPD },
    { "fcml_tf_instruction_VGATHERPF1QPD", fcml_tf_instruction_VGATHERPF1QPD },
    { "fcml_tf_instruction_VGATHERPF0DPS", fcml_tf_instruction_VGATHERPF0DPS },
    { "fcml_tf_instruction_VGATHERPF0QPS", fcml_tf_instruction_VGATHERPF0QPS },
    { "fcml_tf_instruction_VGATHERPF0DPD", fcml_tf_instruction_VGATHERPF0DPD },
    { "fcml_tf_instruction_VGATHERPF0QPD", fcml_tf_instruction_VGATHERPF0QPD },
    { "fcml_tf_instruction_VEXP2PD", fcml_tf_instruction_VEXP2PD },
    { "fcml_tf_instruction_VEXP2PS", fcml_tf_instruction_VEXP2PS },
    { "fcml_tf_instruction_V4FMADDSS", fcml_tf_instruction_V4FMADDSS },
    { "fcml_tf_instruction_V4FNMADDSS", fcml_tf_instruction_V4FNMADDSS },
    { "fcml_tf_instruction_V4FMADDPS", fcml_tf_instruction_V4FMADDPS },
    { "fcml_tf_instruction_V4FNMADDPS", fcml_tf_instruction_V4FNMADDPS },
    { "fcml_tf_instruction_VSHUFF32X4", fcml_tf_instruction_VSHUFF32X4 },
    { "fcml_tf_instruction_VSHUFI32X4", fcml_tf_instruction_VSHUFI32X4 },
    { "fcml_tf_instruction_VSHUFF64X2", fcml_tf_instruction_VSHUFF64X2 },
    { "fcml_tf_instruction_VSHUFI64X2", fcml_tf_instruction_VSHUFI64X2 },
    { "fcml_tf_instruction_VSCATTERDPS", fcml_tf_instruction_VSCATTERDPS },
    { "fcml_tf_instruction_VSCATTERDPD", fcml_tf_instruction_VSCATTERDPD },
    { "fcml_tf_instruction_VSCATTERQPS", fcml_tf_instruction_VSCATTERQPS },
    { "fcml_tf_instruction_VSCATTERQPD", fcml_tf_instruction_VSCATTERQPD },
    { "fcml_tf_instruction_VSCALEFPD", fcml_tf_instruction_VSCALEFPD },
    { "fcml_tf_instruction_VSCALEFPS", fcml_tf_instruction_VSCALEFPS },
    { "fcml_tf_instruction_VSCALEFSD", fcml_tf_instruction_VSCALEFSD },
    { "fcml_tf_instruction_VSCALEFSS", fcml_tf_instruction_VSCALEFSS },
    { "fcml_tf_instruction_VRSQRT14PD", fcml_tf_instruction_VRSQRT14PD },
    { "fcml_tf_instruction_VRSQRT14PS", fcml_tf_instruction_VRSQRT14PS },
    { "fcml_tf_instruction_VRSQRT14SD", fcml_tf_instruction_VRSQRT14SD },
    { "fcml_tf_instruction_VRSQRT14SS", fcml_tf_instruction_VRSQRT14SS },
    { "fcml_tf_instruction_VRNDSCALEPD", fcml_tf_instruction_VRNDSCALEPD },
    { "fcml_tf_instruction_VRNDSCALEPS", fcml_tf_instruction_VRNDSCALEPS },
    { "fcml_tf_instruction_VRNDSCALESD", fcml_tf_instruction_VRNDSCALESD },
    { "fcml_tf_instruction_VRNDSCALESS", fcml_tf_instruction_VRNDSCALESS },
    { "fcml_tf_instruction_VREDUCEPD", fcml_tf_instruction_VREDUCEPD },
    { "fcml_tf_instruction_VREDUCEPS", fcml_tf_instruction_VREDUCEPS },
    { "fcml_tf_instruction_VREDUCESD", fcml_tf_instruction_VREDUCESD },
    { "fcml_tf_instruction_VREDUCESS", fcml_tf_instruction_VREDUCESS },
    { "fcml_tf_instruction_VRCP14PD", fcml_tf_instruction_VRCP14PD },
    { "fcml_tf_instruction_VRCP14PS", fcml_tf_instruction_VRCP14PS },
    { "fcml_tf_instruction_VRCP14SD", fcml_tf_instruction_VRCP14SD },
    { "fcml_tf_instruction_VRCP14SS", fcml_tf_instruction_VRCP14SS },
    { "fcml_tf_instruction_VRANGEPD", fcml_tf_instruction_VRANGEPD },
    { "fcml_tf_instruction_VRANGEPS", fcml_tf_instruction_VRANGEPS },
    { "fcml_tf_instruction_VRANGESD", fcml_tf_instruction_VRANGESD },
    { "fcml_tf_instruction_VRANGESS", fcml_tf_instruction_VRANGESS },
    { "fcml_tf_instruction_VPTESTMB", fcml_tf_instruction_VPTESTMB },
    { "fcml_tf_instruction_VPTESTMW", fcml_tf_instruction_VPTESTMW },
    { "fcml_tf_instruction_VPTESTMD", fcml_tf_instruction_VPTESTMD },
    { "fcml_tf_instruction_VPTESTMQ", fcml_tf_instruction_VPTESTMQ },
    { "fcml_tf_instruction_VPTESTNMB", fcml_tf_instruction_VPTESTNMB },
    { "fcml_tf_instruction_VPTESTNMW", fcml_tf_instruction_VPTESTNMW },
    { "fcml_tf_instruction_VPTESTNMD", fcml_tf_instruction_VPTESTNMD },
    { "fcml_tf_instruction_VPTESTNMQ", fcml_tf_instruction_VPTESTNMQ },
    { "fcml_tf_instruction_VPTERNLOGD", fcml_tf_instruction_VPTERNLOGD },
    { "fcml_tf_instruction_VPTERNLOGQ", fcml_tf_instruction_VPTERNLOGQ },
    { "fcml_tf_instruction_VPSLLVW", fcml_tf_instruction_VPSLLVW },
    { "fcml_tf_instruction_VPSLLVD", fcml_tf_instruction_VPSLLVD },
    { "fcml_tf_instruction_VPSLLVQ", fcml_tf_instruction_VPSLLVQ },
    { "fcml_tf_instruction_VPSCATTERDD", fcml_tf_instruction_VPSCATTERDD },
    { "fcml_tf_instruction_VPSCATTERDQ", fcml_tf_instruction_VPSCATTERDQ },
    { "fcml_tf_instruction_VPSCATTERQD", fcml_tf_instruction_VPSCATTERQD },
    { "fcml_tf_instruction_VPSCATTERQQ", fcml_tf_instruction_VPSCATTERQQ },
    { "fcml_tf_instruction_VPRORVD", fcml_tf_instruction_VPRORVD },
    { "fcml_tf_instruction_VPRORVQ", fcml_tf_instruction_VPRORVQ },
    { "fcml_tf_instruction_VPRORD", fcml_tf_instruction_VPRORD },
    { "fcml_tf_instruction_VPRORQ", fcml_tf_instruction_VPRORQ },
    { "fcml_tf_instruction_VPROLD", fcml_tf_instruction_VPROLD },
    { "fcml_tf_instruction_VPROLQ", fcml_tf_instruction_VPROLQ },
    { "fcml_tf_instruction_VPROLVD", fcml_tf_instruction_VPROLVD },
    { "fcml_tf_instruction_VPROLVQ", fcml_tf_instruction_VPROLVQ },
    { "fcml_tf_instruction_VPMULTISHIFTQB", fcml_tf_instruction_VPMULTISHIFTQB },
    { "fcml_tf_instruction_VPMOVWB", fcml_tf_instruction_VPMOVWB },
    { "fcml_tf_instruction_VPMOVSWB", fcml_tf_instruction_VPMOVSWB },
    { "fcml_tf_instruction_VPMOVUSWB", fcml_tf_instruction_VPMOVUSWB },
    { "fcml_tf_instruction_VPMOVQW", fcml_tf_instruction_VPMOVQW },
    { "fcml_tf_instruction_VPMOVSQW", fcml_tf_instruction_VPMOVSQW },
    { "fcml_tf_instruction_VPMOVUSQW", fcml_tf_instruction_VPMOVUSQW },
    { "fcml_tf_instruction_VPMOVQD", fcml_tf_instruction_VPMOVQD },
    { "fcml_tf_instruction_VPMOVSQD", fcml_tf_instruction_VPMOVSQD },
    { "fcml_tf_instruction_VPMOVUSQD", fcml_tf_instruction_VPMOVUSQD },
    { "fcml_tf_instruction_VPMOVQB", fcml_tf_instruction_VPMOVQB },
    { "fcml_tf_instruction_VPMOVSQB", fcml_tf_instruction_VPMOVSQB },
    { "fcml_tf_instruction_VPMOVUSQB", fcml_tf_instruction_VPMOVUSQB },
    { "fcml_tf_instruction_VPMOVDW", fcml_tf_instruction_VPMOVDW },
    { "fcml_tf_instruction_VPMOVSDW", fcml_tf_instruction_VPMOVSDW },
    { "fcml_tf_instruction_VPMOVUSDW", fcml_tf_instruction_VPMOVUSDW },
    { "fcml_tf_instruction_VPMOVDB", fcml_tf_instruction_VPMOVDB },
    { "fcml_tf_instruction_VPMOVSDB", fcml_tf_instruction_VPMOVSDB },
    { "fcml_tf_instruction_VPMOVUSDB", fcml_tf_instruction_VPMOVUSDB },
    { "fcml_tf_instruction_VPMOVB2M", fcml_tf_instruction_VPMOVB2M },
    { "fcml_tf_instruction_VPMOVW2M", fcml_tf_instruction_VPMOVW2M },
    { "fcml_tf_instruction_VPMOVD2M", fcml_tf_instruction_VPMOVD2M },
    { "fcml_tf_instruction_VPMOVQ2M", fcml_tf_instruction_VPMOVQ2M },
    { "fcml_tf_instruction_VPMOVM2B", fcml_tf_instruction_VPMOVM2B },
    { "fcml_tf_instruction_VPMOVM2W", fcml_tf_instruction_VPMOVM2W },
    { "fcml_tf_instruction_VPMOVM2D", fcml_tf_instruction_VPMOVM2D },
    { "fcml_tf_instruction_VPMOVM2Q", fcml_tf_instruction_VPMOVM2Q },
    { "fcml_tf_instruction_VPMADD52HUQ", fcml_tf_instruction_VPMADD52HUQ },
    { "fcml_tf_instruction_VPMADD52LUQ", fcml_tf_instruction_VPMADD52LUQ },
    { "fcml_tf_instruction_VPLZCNTD", fcml_tf_instruction_VPLZCNTD },
    { "fcml_tf_instruction_VPLZCNTQ", fcml_tf_instruction_VPLZCNTQ },
    { "fcml_tf_instruction_VPGATHERQD", fcml_tf_instruction_VPGATHERQD },
    { "fcml_tf_instruction_VPGATHERQQ", fcml_tf_instruction_VPGATHERQQ },
    { "fcml_tf_instruction_VPEXPANDD", fcml_tf_instruction_VPEXPANDD },
    { "fcml_tf_instruction_VPEXPANDQ", fcml_tf_instruction_VPEXPANDQ },
    { "fcml_tf_instruction_VPERMT2PD", fcml_tf_instruction_VPERMT2PD },
    { "fcml_tf_instruction_VPERMT2PS", fcml_tf_instruction_VPERMT2PS },
    { "fcml_tf_instruction_VPERMT2Q", fcml_tf_instruction_VPERMT2Q },
    { "fcml_tf_instruction_VPERMT2D", fcml_tf_instruction_VPERMT2D },
    { "fcml_tf_instruction_VPERMT2W", fcml_tf_instruction_VPERMT2W },
    { "fcml_tf_instruction_VPERMT2B", fcml_tf_instruction_VPERMT2B },
    { "fcml_tf_instruction_VPERMI2PD", fcml_tf_instruction_VPERMI2PD },
    { "fcml_tf_instruction_VPERMI2PS", fcml_tf_instruction_VPERMI2PS },
    { "fcml_tf_instruction_VPERMI2Q", fcml_tf_instruction_VPERMI2Q },
    { "fcml_tf_instruction_VPERMI2D", fcml_tf_instruction_VPERMI2D },
    { "fcml_tf_instruction_VPERMI2W", fcml_tf_instruction_VPERMI2W },
    { "fcml_tf_instruction_VPERMI2B", fcml_tf_instruction_VPERMI2B },
    { "fcml_tf_instruction_VPERMB", fcml_tf_instruction_VPERMB },
    { "fcml_tf_instruction_VPCOMPRESSD", fcml_tf_instruction_VPCOMPRESSD },
    { "fcml_tf_instruction_VPCOMPRESSQ", fcml_tf_instruction_VPCOMPRESSQ },
    { "fcml_tf_instruction_VPCMPW", fcml_tf_instruction_VPCMPW },
    { "fcml_tf_instruction_VPCMPUW", fcml_tf_instruction_VPCMPUW },
    { "fcml_tf_instruction_VPCMPQ", fcml_tf_instruction_VPCMPQ },
    { "fcml_tf_instruction_VPCMPUQ", fcml_tf_instruction_VPCMPUQ },
    { "fcml_tf_instruction_VPCMPD", fcml_tf_instruction_VPCMPD },
    { "fcml_tf_instruction_VPCMPUD", fcml_tf_instruction_VPCMPUD },
    { "fcml_tf_instruction_VPCMPB", fcml_tf_instruction_VPCMPB },
    { "fcml_tf_instruction_VPCMPUB", fcml_tf_instruction_VPCMPUB },
    { "fcml_tf_instruction_VPBROADCASTMB2Q", fcml_tf_instruction_VPBROADCASTMB2Q },
    { "fcml_tf_instruction_VPBROADCASTMW2D", fcml_tf_instruction_VPBROADCASTMW2D },
    { "fcml_tf_instruction_VBROADCASTI32X2", fcml_tf_instruction_VBROADCASTI32X2 },
    { "fcml_tf_instruction_VBROADCASTI32X4", fcml_tf_instruction_VBROADCASTI32X4 },
    { "fcml_tf_instruction_VBROADCASTI64X2", fcml_tf_instruction_VBROADCASTI64X2 },
    { "fcml_tf_instruction_VBROADCASTI32X8", fcml_tf_instruction_VBROADCASTI32X8 },
    { "fcml_tf_instruction_VBROADCASTI64X4", fcml_tf_instruction_VBROADCASTI64X4 },
    { "fcml_tf_instruction_VPBLENDMQ", fcml_tf_instruction_VPBLENDMQ },
    { "fcml_tf_instruction_VPBLENDMD", fcml_tf_instruction_VPBLENDMD },
    { "fcml_tf_instruction_VPBLENDMW", fcml_tf_instruction_VPBLENDMW },
    { "fcml_tf_instruction_VPBLENDMB", fcml_tf_instruction_VPBLENDMB },
    { "fcml_tf_instruction_VINSERTI32X8", fcml_tf_instruction_VINSERTI32X8 },
    { "fcml_tf_instruction_VINSERTI64X4", fcml_tf_instruction_VINSERTI64X4 },
    { "fcml_tf_instruction_VINSERTI64X2", fcml_tf_instruction_VINSERTI64X2 },
    { "fcml_tf_instruction_VINSERTI32X4", fcml_tf_instruction_VINSERTI32X4 },
    { "fcml_tf_instruction_VINSERTF32X8", fcml_tf_instruction_VINSERTF32X8 },
    { "fcml_tf_instruction_VINSERTF64X4", fcml_tf_instruction_VINSERTF64X4 },
    { "fcml_tf_instruction_VINSERTF64X2", fcml_tf_instruction_VINSERTF64X2 },
    { "fcml_tf_instruction_VINSERTF32X4", fcml_tf_instruction_VINSERTF32X4 },
    { "fcml_tf_instruction_VGETMANTPD", fcml_tf_instruction_VGETMANTPD },
    { "fcml_tf_instruction_VGETMANTPS", fcml_tf_instruction_VGETMANTPS },
    { "fcml_tf_instruction_VGETMANTSD", fcml_tf_instruction_VGETMANTSD },
    { "fcml_tf_instruction_VGETMANTSS", fcml_tf_instruction_VGETMANTSS },
    { "fcml_tf_instruction_VGETEXPPD", fcml_tf_instruction_VGETEXPPD },
    { "fcml_tf_instruction_VGETEXPPS", fcml_tf_instruction_VGETEXPPS },
    { "fcml_tf_instruction_VGETEXPSD", fcml_tf_instruction_VGETEXPSD },
    { "fcml_tf_instruction_VGETEXPSS", fcml_tf_instruction_VGETEXPSS },
    { "fcml_tf_instruction_VFPCLASSPD", fcml_tf_instruction_VFPCLASSPD },
    { "fcml_tf_instruction_VFPCLASSPS", fcml_tf_instruction_VFPCLASSPS },
    { "fcml_tf_instruction_VFPCLASSSD", fcml_tf_instruction_VFPCLASSSD },
    { "fcml_tf_instruction_VFPCLASSSS", fcml_tf_instruction_VFPCLASSSS },
    { "fcml_tf_instruction_VFIXUPIMMSS", fcml_tf_instruction_VFIXUPIMMSS },
    { "fcml_tf_instruction_VFIXUPIMMSD", fcml_tf_instruction_VFIXUPIMMSD },
    { "fcml_tf_instruction_VFIXUPIMMPD", fcml_tf_instruction_VFIXUPIMMPD },
    { "fcml_tf_instruction_VFIXUPIMMPS", fcml_tf_instruction_VFIXUPIMMPS },
    { "fcml_tf_instruction_VEXTRACTI32X4", fcml_tf_instruction_VEXTRACTI32X4 },
    { "fcml_tf_instruction_VEXTRACTI64X2", fcml_tf_instruction_VEXTRACTI64X2 },
    { "fcml_tf_instruction_VEXTRACTI32X8", fcml_tf_instruction_VEXTRACTI32X8 },
    { "fcml_tf_instruction_VEXTRACTI64X4", fcml_tf_instruction_VEXTRACTI64X4 },
    { "fcml_tf_instruction_VEXTRACTF32X4", fcml_tf_instruction_VEXTRACTF32X4 },
    { "fcml_tf_instruction_VEXTRACTF64X2", fcml_tf_instruction_VEXTRACTF64X2 },
    { "fcml_tf_instruction_VEXTRACTF32X8", fcml_tf_instruction_VEXTRACTF32X8 },
    { "fcml_tf_instruction_VEXTRACTF64X4", fcml_tf_instruction_VEXTRACTF64X4 },
    { "fcml_tf_instruction_VEXPANDPS", fcml_tf_instruction_VEXPANDPS },
    { "fcml_tf_instruction_VEXPANDPD", fcml_tf_instruction_VEXPANDPD },
    { "fcml_tf_instruction_VDBPSADBW", fcml_tf_instruction_VDBPSADBW },
    { "fcml_tf_instruction_VCVTUSI2SS", fcml_tf_instruction_VCVTUSI2SS },
    { "fcml_tf_instruction_VCVTUSI2SD", fcml_tf_instruction_VCVTUSI2SD },
    { "fcml_tf_instruction_VCVTUQQ2PS", fcml_tf_instruction_VCVTUQQ2PS },
    { "fcml_tf_instruction_VCVTUQQ2PD", fcml_tf_instruction_VCVTUQQ2PD },
    { "fcml_tf_instruction_VCVTUDQ2PS", fcml_tf_instruction_VCVTUDQ2PS },
    { "fcml_tf_instruction_VCVTUDQ2PD", fcml_tf_instruction_VCVTUDQ2PD },
    { "fcml_tf_instruction_VCVTTSD2USI", fcml_tf_instruction_VCVTTSD2USI },
    { "fcml_tf_instruction_VCVTTSS2USI", fcml_tf_instruction_VCVTTSS2USI },
    { "fcml_tf_instruction_VCVTTPS2UQQ", fcml_tf_instruction_VCVTTPS2UQQ },
    { "fcml_tf_instruction_VCVTTPS2QQ", fcml_tf_instruction_VCVTTPS2QQ },
    { "fcml_tf_instruction_VCVTTPS2UDQ", fcml_tf_instruction_VCVTTPS2UDQ },
    { "fcml_tf_instruction_VCVTTPD2UQQ", fcml_tf_instruction_VCVTTPD2UQQ },
    { "fcml_tf_instruction_VCVTTPD2UDQ", fcml_tf_instruction_VCVTTPD2UDQ },
    { "fcml_tf_instruction_VCVTTPD2QQ", fcml_tf_instruction_VCVTTPD2QQ },
    { "fcml_tf_instruction_VCVTQQ2PS", fcml_tf_instruction_VCVTQQ2PS },
    { "fcml_tf_instruction_VCVTSD2USI", fcml_tf_instruction_VCVTSD2USI },
    { "fcml_tf_instruction_VCVTSS2USI", fcml_tf_instruction_VCVTSS2USI },
    { "fcml_tf_instruction_VCVTQQ2PD",fcml_tf_instruction_VCVTQQ2PD },
    { "fcml_tf_instruction_VCVTPS2UQQ", fcml_tf_instruction_VCVTPS2UQQ },
    { "fcml_tf_instruction_VCVTPS2QQ", fcml_tf_instruction_VCVTPS2QQ },
    { "fcml_tf_instruction_VBROADCASTSS", fcml_tf_instruction_VBROADCASTSS },
    { "fcml_tf_instruction_VCOMPRESSPD", fcml_tf_instruction_VCOMPRESSPD },
    { "fcml_tf_instruction_VCOMPRESSPS", fcml_tf_instruction_VCOMPRESSPS },
    { "fcml_tf_instruction_VCVTPD2QQ", fcml_tf_instruction_VCVTPD2QQ },
    { "fcml_tf_instruction_VCVTPD2UDQ", fcml_tf_instruction_VCVTPD2UDQ },
    { "fcml_tf_instruction_VCVTPD2UQQ", fcml_tf_instruction_VCVTPD2UQQ },
    { "fcml_tf_instruction_VCVTPS2UDQ", fcml_tf_instruction_VCVTPS2UDQ },
    { "fcml_tf_instruction_VPBROADCASTB", fcml_tf_instruction_VPBROADCASTB },
    { "fcml_tf_instruction_VEXTRACTF128", fcml_tf_instruction_VEXTRACTF128 },
    { "fcml_tf_instruction_VINSERTF128", fcml_tf_instruction_VINSERTF128 },
    { "fcml_tf_instruction_VMASKMOVPS_VMASKMOVPD", fcml_tf_instruction_VMASKMOVPS_VMASKMOVPD },
    { "fcml_tf_instruction_VPMASKMOVD_VPMASKMOVQ", fcml_tf_instruction_VPMASKMOVD_VPMASKMOVQ },
    { "fcml_tf_instruction_VPBLENDD", fcml_tf_instruction_VPBLENDD },
    { "fcml_tf_instruction_VCVTPH2PS", fcml_tf_instruction_VCVTPH2PS },
    { "fcml_tf_instruction_VCVTPS2PH", fcml_tf_instruction_VCVTPS2PH },
    { "fcml_tf_instruction_VERR", fcml_tf_instruction_VERR },
    { "fcml_tf_instruction_VMLOAD", fcml_tf_instruction_VMLOAD },
    { "fcml_tf_instruction_VMMCALL", fcml_tf_instruction_VMMCALL },
    { "fcml_tf_instruction_VMRUN", fcml_tf_instruction_VMRUN },
    { "fcml_tf_instruction_VMSAVE", fcml_tf_instruction_VMSAVE },
    { "fcml_tf_instruction_VPERMILPD", fcml_tf_instruction_VPERMILPD },
    { "fcml_tf_instruction_VPERMILPS", fcml_tf_instruction_VPERMILPS },
    { "fcml_tf_instruction_VPSRLVW", fcml_tf_instruction_VPSRLVW },
    { "fcml_tf_instruction_VPSRLVD", fcml_tf_instruction_VPSRLVD },
    { "fcml_tf_instruction_VPSRLVQ", fcml_tf_instruction_VPSRLVQ },
    { "fcml_tf_instruction_VPSRAVW", fcml_tf_instruction_VPSRAVW },
    { "fcml_tf_instruction_VPSRAVD", fcml_tf_instruction_VPSRAVD },
    { "fcml_tf_instruction_VPSRAVQ", fcml_tf_instruction_VPSRAVQ },
    { "fcml_tf_instruction_VPERMD", fcml_tf_instruction_VPERMD },
    { "fcml_tf_instruction_VPERMW", fcml_tf_instruction_VPERMW },
    { "fcml_tf_instruction_VPERMPD", fcml_tf_instruction_VPERMPD },
    { "fcml_tf_instruction_VPERMQ", fcml_tf_instruction_VPERMQ },
    { "fcml_tf_instruction_VPERMPS", fcml_tf_instruction_VPERMPS },
    { "fcml_tf_instruction_VPERM2F128", fcml_tf_instruction_VPERM2F128 },
    { "fcml_tf_instruction_VPERM2I128", fcml_tf_instruction_VPERM2I128 },
    { "fcml_tf_instruction_VEXTRACTI128", fcml_tf_instruction_VEXTRACTI128 },
    { "fcml_tf_instruction_VINSERTI128", fcml_tf_instruction_VINSERTI128 },
    { "fcml_tf_instruction_VTESTPS", fcml_tf_instruction_VTESTPS },
    { "fcml_tf_instruction_VGATHERDPD", fcml_tf_instruction_VGATHERDPD },
    { "fcml_tf_instruction_VGATHERQPD", fcml_tf_instruction_VGATHERQPD },
    { "fcml_tf_instruction_VGATHERDPS", fcml_tf_instruction_VGATHERDPS },
    { "fcml_tf_instruction_VGATHERQPS", fcml_tf_instruction_VGATHERQPS },
    { "fcml_tf_instruction_VPGATHERDD", fcml_tf_instruction_VPGATHERDD },
    { "fcml_tf_instruction_VPGATHERDQ", fcml_tf_instruction_VPGATHERDQ },
    { "fcml_tf_instruction_VZEROALL", fcml_tf_instruction_VZEROALL },
    { "fcml_tf_instruction_VZEROUPPER", fcml_tf_instruction_VZEROUPPER },
    { "fcml_tf_instruction_VFMADDPD", fcml_tf_instruction_VFMADDPD },
    { "fcml_tf_instruction_VFMADDPS", fcml_tf_instruction_VFMADDPS },
    { "fcml_tf_instruction_VFMADDSD", fcml_tf_instruction_VFMADDSD },
    { "fcml_tf_instruction_VFMADDSS", fcml_tf_instruction_VFMADDSS },
    { "fcml_tf_instruction_VFMADDSUBPD", fcml_tf_instruction_VFMADDSUBPD },
    { "fcml_tf_instruction_VFMADDSUBPS", fcml_tf_instruction_VFMADDSUBPS },
    { "fcml_tf_instruction_VFMSUBADDPD", fcml_tf_instruction_VFMSUBADDPD },
    { "fcml_tf_instruction_VFMSUBADDPS", fcml_tf_instruction_VFMSUBADDPS },
    { "fcml_tf_instruction_VFMSUBPD", fcml_tf_instruction_VFMSUBPD },
    { "fcml_tf_instruction_VFMSUBPS", fcml_tf_instruction_VFMSUBPS },
    { "fcml_tf_instruction_VFMSUBSD", fcml_tf_instruction_VFMSUBSD },
    { "fcml_tf_instruction_VFMSUBSS", fcml_tf_instruction_VFMSUBSS },
    { "fcml_tf_instruction_VFNMADDPD", fcml_tf_instruction_VFNMADDPD },
    { "fcml_tf_instruction_VFNMADDPS", fcml_tf_instruction_VFNMADDPS },
    { "fcml_tf_instruction_VFNMADDSD", fcml_tf_instruction_VFNMADDSD },
    { "fcml_tf_instruction_VFNMADDSS", fcml_tf_instruction_VFNMADDSS },
    { "fcml_tf_instruction_VFNMSUBPD", fcml_tf_instruction_VFNMSUBPD },
    { "fcml_tf_instruction_VFNMSUBPS", fcml_tf_instruction_VFNMSUBPS },
    { "fcml_tf_instruction_VFNMSUBSD", fcml_tf_instruction_VFNMSUBSD },
    { "fcml_tf_instruction_VFNMSUBSS", fcml_tf_instruction_VFNMSUBSS },
    { "fcml_tf_instruction_VFRCZPD", fcml_tf_instruction_VFRCZPD },
    { "fcml_tf_instruction_VFRCZPS", fcml_tf_instruction_VFRCZPS },
    { "fcml_tf_instruction_VFRCZSD", fcml_tf_instruction_VFRCZSD },
    { "fcml_tf_instruction_VFRCZSS", fcml_tf_instruction_VFRCZSS },
    { "fcml_tf_instruction_VPCMOV", fcml_tf_instruction_VPCMOV },
    { "fcml_tf_instruction_VPCOMU", fcml_tf_instruction_VPCOMU },
    { "fcml_tf_instruction_VPCOM", fcml_tf_instruction_VPCOM },
    { "fcml_tf_instruction_VPHADDBD", fcml_tf_instruction_VPHADDBD },
    { "fcml_tf_instruction_VPHADDBW", fcml_tf_instruction_VPHADDBW },
    { "fcml_tf_instruction_VPHADDBQ", fcml_tf_instruction_VPHADDBQ },
    { "fcml_tf_instruction_VPHADDDQ", fcml_tf_instruction_VPHADDDQ },
    { "fcml_tf_instruction_VPHADDUBD", fcml_tf_instruction_VPHADDUBD },
    { "fcml_tf_instruction_VPHADDUBQ", fcml_tf_instruction_VPHADDUBQ },
    { "fcml_tf_instruction_VPHADDUBW", fcml_tf_instruction_VPHADDUBW },
    { "fcml_tf_instruction_VPHADDUDQ", fcml_tf_instruction_VPHADDUDQ },
    { "fcml_tf_instruction_VPHADDUWD", fcml_tf_instruction_VPHADDUWD },
    { "fcml_tf_instruction_VPHADDUWQ", fcml_tf_instruction_VPHADDUWQ },
    { "fcml_tf_instruction_VPHADDWD", fcml_tf_instruction_VPHADDWD },
    { "fcml_tf_instruction_VPHADDWQ", fcml_tf_instruction_VPHADDWQ },
    { "fcml_tf_instruction_VPHSUBBW", fcml_tf_instruction_VPHSUBBW },
    { "fcml_tf_instruction_VPHSUBDQ", fcml_tf_instruction_VPHSUBDQ },
    { "fcml_tf_instruction_VPHSUBWD", fcml_tf_instruction_VPHSUBWD },
    { "fcml_tf_instruction_VPMACSDD", fcml_tf_instruction_VPMACSDD },
    { "fcml_tf_instruction_VPMACSDQH", fcml_tf_instruction_VPMACSDQH },
    { "fcml_tf_instruction_VPMACSDQL", fcml_tf_instruction_VPMACSDQL },
    { "fcml_tf_instruction_VPMACSSDD", fcml_tf_instruction_VPMACSSDD },
    { "fcml_tf_instruction_VPMACSSDQH", fcml_tf_instruction_VPMACSSDQH },
    { "fcml_tf_instruction_VPMACSSDQL", fcml_tf_instruction_VPMACSSDQL },
    { "fcml_tf_instruction_VPMACSSWD", fcml_tf_instruction_VPMACSSWD },
    { "fcml_tf_instruction_VPMACSSWW", fcml_tf_instruction_VPMACSSWW },
    { "fcml_tf_instruction_VPMACSWD", fcml_tf_instruction_VPMACSWD },
    { "fcml_tf_instruction_VPMACSWW", fcml_tf_instruction_VPMACSWW },
    { "fcml_tf_instruction_VPMADCSSWD", fcml_tf_instruction_VPMADCSSWD },
    { "fcml_tf_instruction_VPMADCSWD", fcml_tf_instruction_VPMADCSWD },
    { "fcml_tf_instruction_VPPERM", fcml_tf_instruction_VPPERM },
    { "fcml_tf_instruction_VPROTD", fcml_tf_instruction_VPROTD },
    { "fcml_tf_instruction_VPROTB", fcml_tf_instruction_VPROTB },
    { "fcml_tf_instruction_VPROTQ", fcml_tf_instruction_VPROTQ },
    { "fcml_tf_instruction_VPROTW", fcml_tf_instruction_VPROTW },
    { "fcml_tf_instruction_VPSHAB", fcml_tf_instruction_VPSHAB },
    { "fcml_tf_instruction_VPSHAD", fcml_tf_instruction_VPSHAD },
    { "fcml_tf_instruction_VPSHAQ", fcml_tf_instruction_VPSHAQ },
    { "fcml_tf_instruction_VPSHAW", fcml_tf_instruction_VPSHAW },
    { "fcml_tf_instruction_VPSHLB", fcml_tf_instruction_VPSHLB },
    { "fcml_tf_instruction_VPSHLD", fcml_tf_instruction_VPSHLD },
    { "fcml_tf_instruction_VPSHLQ", fcml_tf_instruction_VPSHLQ },
    { "fcml_tf_instruction_VPSHLW", fcml_tf_instruction_VPSHLW },
    { "fcml_tf_instruction_VMPTRLD", fcml_tf_instruction_VMPTRLD },
    { "fcml_tf_instruction_VMPTRST", fcml_tf_instruction_VMPTRST },
    { "fcml_tf_instruction_VMCLEAR", fcml_tf_instruction_VMCLEAR },
    { "fcml_tf_instruction_VMREAD", fcml_tf_instruction_VMREAD },
    { "fcml_tf_instruction_VMWRITE", fcml_tf_instruction_VMWRITE },
    { "fcml_tf_instruction_VMLAUNCH", fcml_tf_instruction_VMLAUNCH },
    { "fcml_tf_instruction_VMRESUME", fcml_tf_instruction_VMRESUME },
    { "fcml_tf_instruction_VMXON", fcml_tf_instruction_VMXON },
    { "fcml_tf_instruction_VMXOFF", fcml_tf_instruction_VMXOFF },
    { "fcml_tf_instruction_VMCALL", fcml_tf_instruction_VMCALL },
    { "fcml_tf_instruction_VMFUNC", fcml_tf_instruction_VMFUNC },
    { "fcml_tf_instruction_VPERMIL2PS", fcml_tf_instruction_VPERMIL2PS },
    { "fcml_tf_instruction_VPERMIL2PD", fcml_tf_instruction_VPERMIL2PD },
    { "fcml_tf_instruction_VALIGND", fcml_tf_instruction_VALIGND },
    { "fcml_tf_instruction_VALIGNQ", fcml_tf_instruction_VALIGNQ },
    { "fcml_tf_instruction_VBLENDMPD", fcml_tf_instruction_VBLENDMPD },
    { "fcml_tf_instruction_VBLENDMPS", fcml_tf_instruction_VBLENDMPS },
    FCML_STF_NULL_TEST
};

fcml_stf_test_suite fctl_si_instructions_v = {
    "suite-fctl_ti_instructions_v", fcml_tf_instructions_v_suite_init, fcml_tf_instructions_v_suite_cleanup, fctl_ti_instructions_v
};


