
/*
 * Copyright (c) 2018-2019, NVIDIA CORPORATION.  All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

#ifndef COMMON_H
#define COMMON_H

static float int_as_float(int a) { return *(float*)&a; }
static int float_as_int(float a) { return *(int*)&a; }

float const TWO_TO_24_F = 16777216.0f;
float const PINF = int_as_float(0x7f800000);
float const NINF = int_as_float(0xff800000);
float const CANONICAL_NAN = int_as_float(0xffc00000);

const float ONE_F[]  __attribute__ ((aligned (64))) = {
    1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f,
    1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f
};

const float MAGIC_F[]  __attribute__ ((aligned (64))) = {
    0.75f, 0.75f, 0.75f, 0.75f, 0.75f, 0.75f, 0.75f, 0.75f,
    0.75f, 0.75f, 0.75f, 0.75f, 0.75f, 0.75f, 0.75f, 0.75f
};

const float MAGIC_F_LEGACY[]  __attribute__ ((aligned (64))) = {
    0.7071067812f, 0.7071067812f, 0.7071067812f, 0.7071067812f,
    0.7071067812f, 0.7071067812f, 0.7071067812f, 0.7071067812f,
    0.7071067812f, 0.7071067812f, 0.7071067812f, 0.7071067812f,
    0.7071067812f, 0.7071067812f, 0.7071067812f, 0.7071067812f
};


const unsigned MANTISSA_MASK[]  __attribute__ ((aligned (64))) = {
    0x7fffff, 0x7fffff, 0x7fffff, 0x7fffff, 0x7fffff, 0x7fffff, 0x7fffff, 0x7fffff,
    0x7fffff, 0x7fffff, 0x7fffff, 0x7fffff, 0x7fffff, 0x7fffff, 0x7fffff, 0x7fffff
};

float const LOG10_2_F[] __attribute__ ((aligned (64))) = {
    3.01029996e-01f, 3.01029996e-01f, 3.01029996e-01f, 3.01029996e-01f,
    3.01029996e-01f, 3.01029996e-01f, 3.01029996e-01f, 3.01029996e-01f,
    3.01029996e-01f, 3.01029996e-01f, 3.01029996e-01f, 3.01029996e-01f,
    3.01029996e-01f, 3.01029996e-01f, 3.01029996e-01f, 3.01029996e-01f
};

const float coeffs[]  __attribute__ ((aligned (16))) = {
    -9.80694070e-02f, 1.44336283e-01f, -2.17141137e-01f, 4.34294462e-01f,
    -8.15163627e-02f, 1.41261861e-01f, -2.16943070e-01f, 4.34290051e-01f,
    -6.81932494e-02f, 1.36310310e-01f, -2.16323197e-01f, 4.34263915e-01f,
    -5.75571842e-02f, 1.30361691e-01f, -2.15209022e-01f, 4.34194028e-01f,
    -4.89818156e-02f, 1.23956010e-01f, -2.13609859e-01f, 4.34060603e-01f,
    -4.19953652e-02f, 1.17426045e-01f, -2.11572021e-01f, 4.33848262e-01f,
    -3.62535790e-02f, 1.10982470e-01f, -2.09158853e-01f, 4.33546662e-01f,
    -3.04579288e-02f, 1.03325322e-01f, -2.05785006e-01f, 4.33050960e-01f,
    -2.54308611e-01f, 8.42267722e-02f, -2.27419138e-01f, 4.33662415e-01f,
    -2.23996714e-01f, 1.04154654e-01f, -2.23048404e-01f, 4.33982223e-01f,
    -1.98214740e-01f, 1.18687198e-01f, -2.20314741e-01f, 4.34153825e-01f,
    -1.76170990e-01f, 1.29044935e-01f, -2.18689784e-01f, 4.34238940e-01f,
    -1.57210961e-01f, 1.36175334e-01f, -2.17793614e-01f, 4.34276581e-01f,
    -1.40831023e-01f, 1.40798539e-01f, -2.17356652e-01f, 4.34290409e-01f,
    -1.26597300e-01f, 1.43480599e-01f, -2.17186451e-01f, 4.34294045e-01f,
    -1.10963471e-01f, 1.44830704e-01f, -2.17145175e-01f, 4.34294492e-01f
};

const float coeffs0[] __attribute__ ((aligned (64))) = {
    -9.80694070e-02f, -8.15163627e-02f, -6.81932494e-02f, -5.75571842e-02f,
    -4.89818156e-02f, -4.19953652e-02f, -3.62535790e-02f, -3.04579288e-02f,
    -2.54308611e-01f, -2.23996714e-01f, -1.98214740e-01f, -1.76170990e-01f,
    -1.57210961e-01f, -1.40831023e-01f, -1.26597300e-01f, -1.10963471e-01f
};

const float coeffs1[] __attribute__ ((aligned (64))) = {
    1.44336283e-01f, 1.41261861e-01f, 1.36310309e-01f, 1.30361691e-01f,
    1.23956010e-01f, 1.17426045e-01f, 1.10982470e-01f, 1.03325322e-01f,
    8.42267722e-02f, 1.04154654e-01f, 1.18687198e-01f, 1.29044935e-01f,
    1.36175334e-01f, 1.40798539e-01f, 1.43480599e-01f, 1.44830704e-01f
};

const float coeffs2[] __attribute__ ((aligned (64))) = {
    -2.17141137e-01f, -2.16943070e-01f, -2.16323197e-01f, -2.15209022e-01f,
    -2.13609859e-01f, -2.11572021e-01f, -2.09158853e-01f, -2.05785006e-01f,
    -2.27419138e-01f, -2.23048404e-01f, -2.20314741e-01f, -2.18689784e-01f,
    -2.17793614e-01f, -2.17356652e-01f, -2.17186451e-01f, -2.17145175e-01f
};

const float coeffs3[]  __attribute__ ((aligned (64))) = {
    4.34294462e-01f, 4.34290051e-01f, 4.34263915e-01f, 4.34194028e-01f,
    4.34060603e-01f, 4.33848262e-01f, 4.33546662e-01f, 4.33050960e-01f,
    4.33662415e-01f, 4.33982223e-01f, 4.34153825e-01f, 4.34238940e-01f,
    4.34276581e-01f, 4.34290409e-01f, 4.34294045e-01f, 4.34294492e-01f
};


const float c0[] __attribute__ ((aligned (64))) = {
    3.773205727e-02f, 3.773205727e-02f, 3.773205727e-02f, 3.773205727e-02f,
    3.773205727e-02f, 3.773205727e-02f, 3.773205727e-02f, 3.773205727e-02f,
    3.773205727e-02f, 3.773205727e-02f, 3.773205727e-02f, 3.773205727e-02f,
    3.773205727e-02f, 3.773205727e-02f, 3.773205727e-02f, 3.773205727e-02f
};

const float c1[] __attribute__ ((aligned (64))) = {
    -6.326953322e-02f, -6.326953322e-02f, -6.326953322e-02f, -6.326953322e-02f,
    -6.326953322e-02f, -6.326953322e-02f, -6.326953322e-02f, -6.326953322e-02f,
    -6.326953322e-02f, -6.326953322e-02f, -6.326953322e-02f, -6.326953322e-02f,
    -6.326953322e-02f, -6.326953322e-02f, -6.326953322e-02f, -6.326953322e-02f
};

const float c2[] __attribute__ ((aligned (64))) = {
    6.542643160e-02f, 6.542643160e-02f, 6.542643160e-02f, 6.542643160e-02f,
    6.542643160e-02f, 6.542643160e-02f, 6.542643160e-02f, 6.542643160e-02f,
    6.542643160e-02f, 6.542643160e-02f, 6.542643160e-02f, 6.542643160e-02f,
    6.542643160e-02f, 6.542643160e-02f, 6.542643160e-02f, 6.542643160e-02f
};

const float c3[] __attribute__ ((aligned (64))) = {
    -7.180753350e-02f, -7.180753350e-02f, -7.180753350e-02f, -7.180753350e-02f,
    -7.180753350e-02f, -7.180753350e-02f, -7.180753350e-02f, -7.180753350e-02f,
    -7.180753350e-02f, -7.180753350e-02f, -7.180753350e-02f, -7.180753350e-02f,
    -7.180753350e-02f, -7.180753350e-02f, -7.180753350e-02f, -7.180753350e-02f
};

const float c4[] __attribute__ ((aligned (64))) = {
    8.659575135e-02f, 8.659575135e-02f, 8.659575135e-02f, 8.659575135e-02f,
    8.659575135e-02f, 8.659575135e-02f, 8.659575135e-02f, 8.659575135e-02f,
    8.659575135e-02f, 8.659575135e-02f, 8.659575135e-02f, 8.659575135e-02f,
    8.659575135e-02f, 8.659575135e-02f, 8.659575135e-02f, 8.659575135e-02f
};

const float c5[] __attribute__ ((aligned (64))) = {
    -1.085876152e-01f, -1.085876152e-01f, -1.085876152e-01f, -1.085876152e-01f,
    -1.085876152e-01f, -1.085876152e-01f, -1.085876152e-01f, -1.085876152e-01f,
    -1.085876152e-01f, -1.085876152e-01f, -1.085876152e-01f, -1.085876152e-01f,
    -1.085876152e-01f, -1.085876152e-01f, -1.085876152e-01f, -1.085876152e-01f
};

const float c6[] __attribute__ ((aligned (64))) = {
    1.447719634e-01f, 1.447719634e-01f, 1.447719634e-01f, 1.447719634e-01f,
    1.447719634e-01f, 1.447719634e-01f, 1.447719634e-01f, 1.447719634e-01f,
    1.447719634e-01f, 1.447719634e-01f, 1.447719634e-01f, 1.447719634e-01f,
    1.447719634e-01f, 1.447719634e-01f, 1.447719634e-01f, 1.447719634e-01f
};

const float c7[] __attribute__ ((aligned (64))) = {
    -2.171471268e-01f, -2.171471268e-01f, -2.171471268e-01f, -2.171471268e-01f,
    -2.171471268e-01f, -2.171471268e-01f, -2.171471268e-01f, -2.171471268e-01f,
    -2.171471268e-01f, -2.171471268e-01f, -2.171471268e-01f, -2.171471268e-01f,
    -2.171471268e-01f, -2.171471268e-01f, -2.171471268e-01f, -2.171471268e-01f
};

const float c8[] __attribute__ ((aligned (64))) = {
    4.342944324e-01f, 4.342944324e-01f, 4.342944324e-01f, 4.342944324e-01f,
    4.342944324e-01f, 4.342944324e-01f, 4.342944324e-01f, 4.342944324e-01f,
    4.342944324e-01f, 4.342944324e-01f, 4.342944324e-01f, 4.342944324e-01f,
    4.342944324e-01f, 4.342944324e-01f, 4.342944324e-01f, 4.342944324e-01f
};


#endif
