#
# Flask-Security documentation build configuration file, created by
# sphinx-quickstart on Mon Mar 12 15:35:21 2012.
#
# This file is execfile()d with the current directory set to its containing
# dir.
#
# Note that not all possible configuration values are present in this
# autogenerated file.
#
# All configuration values have a default; values that are commented out
# serve to show the default.

import os
import sys

from pallets_sphinx_themes import ProjectLink
from pallets_sphinx_themes import get_version

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
sys.path.insert(0, os.path.abspath(".."))

# -- General configuration -----------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.
# needs_sphinx = '1.0'

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom ones.
extensions = [
    "pallets_sphinx_themes",
    "sphinx.ext.autodoc",
    "sphinx.ext.intersphinx",
    "sphinx.ext.autosectionlabel",
    "sphinx_issues",
]

# Add any paths that contain templates here, relative to this directory.
templates_path = ["_templates"]

# The suffix of source filenames.
source_suffix = ".rst"

# The encoding of source files.
# source_encoding = 'utf-8-sig'

# The master toctree document.
master_doc = "index"

# General information about the project.
project = "Flask-Security"
copyright = "2012-2024"
author = "Matt Wright & Chris Wagner"

# The version info for the project you're documenting, acts as replacement for
# |version| and |release|, also used in various other places throughout the
# built documents.
#
release, version = get_version("Flask-Security-Too")

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
# language = None

# There are two options for replacing |today|: either, you set today to some
# non-false value, then it is used:
# today = ''
# Else, today_fmt is used as the format for a strftime call.
# today_fmt = '%B %d, %Y'

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
exclude_patterns = ["_build"]

# The reST default role (used for this markup: `text`) to use for all
# documents.
# default_role = None

# If true, '()' will be appended to :func: etc. cross-reference text.
# add_function_parentheses = True

# If true, the current module name will be prepended to all description
# unit titles (such as .. function::).
# add_module_names = True

# If true, sectionauthor and moduleauthor directives will be shown in the
# output. They are ignored by default.
# show_authors = False

# The name of the Pygments (syntax highlighting) style to use.
# pygments_style = "pocoo"

# A list of ignored prefixes for module index sorting.
# modindex_common_prefix = []

nitpicky = True
nitpick_ignore = [
    ("py:class", "mongoengine.connection"),
    ("py:class", "ResponseValue"),
    ("py:class", "AuthenticatorSelectionCriteria"),
    ("py:class", "UserVerificationRequirement"),
    ("py:class", "OAuth"),
    ("py:class", "OAuthError"),
    ("py:class", "authlib.integrations.flask_client.OAuth"),
    ("py:class", "TotpMatch"),
    ("py:class", "t.Type"),
    ("py:class", "t.Callable"),
    ("py:class", "t.Any"),
    ("py:class", "timedelta"),
]
autodoc_typehints = "description"
# autodoc_mock_imports = ["flask_sqlalchemy"]
autodoc_type_aliases = {
    "CbType": "oauth_provider.CbType",
}
autosectionlabel_prefix_document = True
autosectionlabel_maxdepth = 2

intersphinx_mapping = {
    "python": ("https://docs.python.org/3/", None),
    "werkzeug": ("https://werkzeug.palletsprojects.com/", None),
    "flask": ("https://flask.palletsprojects.com/", None),
    "itsdangerous": ("https://itsdangerous.palletsprojects.com/", None),
    "sqlalchemy": ("https://docs.sqlalchemy.org/", None),
    "wtforms": ("https://wtforms.readthedocs.io/", None),
    "flask_wtforms": ("https://flask-wtf.readthedocs.io", None),
    "flask_sqlalchemy": ("https://flask-sqlalchemy.palletsprojects.com/", None),
    "flask_sqlalchemy_lite": (
        "https://flask-sqlalchemy-lite.readthedocs.io/en/latest/",
        None,
    ),
    "flask_login": ("https://flask-login.readthedocs.io/en/latest/", None),
    "passlib": ("https://passlib.readthedocs.io/en/stable", None),
    "authlib": ("https://docs.authlib.org/en/latest/", None),
}

# -- Options for HTML output ---------------------------------------------

# The theme to use for HTML and HTML Help pages.  Major themes that come with
# Sphinx are currently 'default' and 'sphinxdoc'.
html_theme = "flask"

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
html_theme_options = {"index_sidebar_logo": False}
html_context = {
    "project_links": [
        ProjectLink("PyPI releases", "https://pypi.org/project/Flask-Security-Too/"),
        ProjectLink(
            "Source Code", "https://github.com/Flask-Middleware/flask-security/"
        ),
        ProjectLink(
            "Issue Tracker",
            "https://github.com/Flask-Middleware/flask-security/issues/",
        ),
        ProjectLink(
            "Changes",
            "https://flask-security-too.readthedocs.io/en/stable/changelog.html",
        ),
    ]
}

# The name for this set of Sphinx documents.  If None, it defaults to
# "<project> v<release> documentation".
# html_title = "Flask-Security Documentation ({}).format(version)"
html_logo = "_static/logo-owl-105.png"

# The name of an image file (within the static path) to use as favicon of the
# docs.  This file should be a Windows icon file (.ico) being 16x16 or 32x32
# pixels large.
# html_favicon = None

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ["_static", "openapi.yaml"]


# Custom sidebar templates, maps document names to template names.
html_sidebars = {
    "index": ["project.html", "localtoc.html", "searchbox.html"],
    "**": ["relations.html", "searchbox.html", "localtoc.html"],
}
singlehtml_sidebars = {"index": ["project.html", "localtoc.html"]}

# If true, links to the reST sources are added to the pages.
html_show_sourcelink = False

# Output file base name for HTML help builder.
htmlhelp_basename = "Flask-Securitydoc"


# -- Options for LaTeX output --------------------------------------------
latex_documents = [
    ("index", "Flask-Security.tex", "Flask-Security Documentation", author, "manual")
]

# -- Options for sphinx-issues ---------------------------------------------
# Github repo
issues_github_path = "Flask-Middleware/flask-security"
