/*
 * Decompiled with CFR 0.152.
 */
package bemused;

import bemused.BemusedProtocolException;
import bemused.Browser;
import bemused.Command;
import bemused.CommandTarget;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.Timer;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import protocol.MusicPlayer;
import protocol.ProtocolStatus;
import protocol.StatusUpdateListener;
import translate.Translate;

public class BemusedProtocol
implements MusicPlayer {
    String connectionURL;
    StreamConnection connection;
    DataInputStream iStream;
    DataOutputStream oStream;
    Display display;
    Thread readWriteThread;
    boolean reconnect;
    Integer runSignal;
    Vector statusUpdateListeners;
    ProtocolStatus status = new ProtocolStatus();
    Vector cmdQueue;
    MyCommandTarget commandTarget;
    Timer statusUpdateTimer = new Timer();
    public Browser fileBrowser;
    PlaybackStatus currentStatus = new PlaybackStatus();
    public ItemData itemdata;

    public BemusedProtocol(Display display) {
        this.commandTarget = new MyCommandTarget();
        this.currentStatus.playlist = new String[0];
        this.itemdata = new ItemData();
        this.display = display;
        this.runSignal = new Integer(0);
        this.statusUpdateListeners = new Vector();
        this.cmdQueue = new Vector();
        this.fileBrowser = new Browser(this);
        Runnable runnable = new Runnable(){

            public void run() {
                BemusedProtocol.this.run();
            }
        };
        this.reconnect = true;
        this.readWriteThread = new Thread(runnable);
        this.readWriteThread.start();
    }

    public void infoAlert(String string, String string2, int n) {
        Alert alert = new Alert(string, string2, null, AlertType.INFO);
        alert.setTimeout(n);
        this.display.setCurrent((Displayable)alert);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() {
        while (this.reconnect) {
            try {
                Integer n = this.runSignal;
                synchronized (n) {
                    this.runSignal.wait();
                }
                this.openConnection();
                do {
                    this.doNextCommand();
                    n = this.runSignal;
                    synchronized (n) {
                        this.runSignal.wait();
                    }
                } while (this.reconnect);
            }
            catch (IOException iOException) {
                this.closeConnection();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                throw new RuntimeException("InterruptedExcpetion caught: " + interruptedException.getMessage());
            }
        }
    }

    void openConnection() throws IOException {
        this.closeConnection();
        if (this.connectionURL == null) {
            throw new IOException("Bemused connection URL is null");
        }
        this.connection = (StreamConnection)Connector.open((String)this.connectionURL);
        this.iStream = this.connection.openDataInputStream();
        this.oStream = this.connection.openDataOutputStream();
        this.status.connected = true;
        this.notifyStatusUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnectionURL(String string) {
        this.closeConnection();
        Integer n = this.runSignal;
        synchronized (n) {
            this.runSignal.notifyAll();
        }
        this.connectionURL = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConnection() {
        try {
            if (this.iStream != null) {
                this.iStream.close();
            }
            if (this.oStream != null) {
                this.oStream.close();
            }
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.connection = null;
        this.iStream = null;
        this.oStream = null;
        Integer n = this.runSignal;
        synchronized (n) {
            this.runSignal.notifyAll();
        }
        this.status.connected = false;
        this.notifyStatusUpdate();
    }

    void doNextCommand() throws IOException {
        Command command = this.getNextCommand();
        while (command != null) {
            try {
                command.execute(this.commandTarget);
            }
            catch (BemusedProtocolException bemusedProtocolException) {
                throw new IOException("Bemused Exception: " + bemusedProtocolException.getMessage());
            }
            command = this.getNextCommand();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Command getNextCommand() {
        Vector vector = this.cmdQueue;
        synchronized (vector) {
            if (!this.cmdQueue.isEmpty()) {
                Command command = (Command)this.cmdQueue.elementAt(0);
                this.cmdQueue.removeElementAt(0);
                return command;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.closeConnection();
        this.statusUpdateTimer.cancel();
        Integer n = this.runSignal;
        synchronized (n) {
            this.runSignal.notifyAll();
        }
        try {
            this.readWriteThread.join();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            throw new RuntimeException("InterruptedException caught: " + interruptedException.getMessage());
        }
        this.statusUpdateListeners.removeAllElements();
    }

    public void registerStatusUpdateListener(StatusUpdateListener statusUpdateListener) {
        this.statusUpdateListeners.addElement(statusUpdateListener);
    }

    void notifyStatusUpdate() {
        this.display.callSerially(new Runnable(){

            public void run() {
                Enumeration enumeration = BemusedProtocol.this.statusUpdateListeners.elements();
                while (enumeration.hasMoreElements()) {
                    StatusUpdateListener statusUpdateListener = (StatusUpdateListener)enumeration.nextElement();
                    statusUpdateListener.bemusedStatusChanged(BemusedProtocol.this.status);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void appendCommand(Command command) {
        Serializable serializable = this.cmdQueue;
        synchronized (serializable) {
            this.cmdQueue.addElement(command);
        }
        serializable = this.runSignal;
        synchronized (serializable) {
            this.runSignal.notifyAll();
        }
    }

    public void play() {
        this.appendCommand(new Command("STRT"));
    }

    public void stop() {
        this.appendCommand(new Command("STOP"));
    }

    public void pause() {
        this.appendCommand(new Command("PAUS"));
    }

    public void next() {
        this.appendCommand(new Command("NEXT"));
    }

    public void previous() {
        this.appendCommand(new Command("PREV"));
    }

    public void shutdownSystem() {
        this.appendCommand(new Command("SHUT"));
    }

    public void rewind() {
        this.appendCommand(new Command("RWND"));
    }

    public void forward() {
        this.appendCommand(new Command("FFWD"));
    }

    public void submenu() {
        this.appendCommand(new Command("SLCT"));
    }

    public void mainMenu() {
        this.appendCommand(new Command("MAIN"));
    }

    public void volumeLouder() {
        this.appendCommand(new Command("VOL+"));
    }

    public void volumeQuieter() {
        this.appendCommand(new Command("VOL-"));
    }

    public void volumeMute() {
        this.appendCommand(new Command("VOLM"));
    }

    public void sendText(String string) {
        this.appendCommand(new Command("TEXT", string));
    }

    public void sendAction(String string) {
        this.appendCommand(new Command(string));
    }

    public void sendMenuItemSelected(String string) {
        this.appendCommand(new Command("MITM", string));
    }

    public void requestMenu() {
        this.appendCommand(new Command("MSND"));
    }

    public void requestItemData() {
        this.appendCommand(new Command("STAT"));
    }

    class MyCommandTarget
    implements CommandTarget {
        MyCommandTarget() {
        }

        public DataInputStream getInputStream() {
            return BemusedProtocol.this.iStream;
        }

        public DataOutputStream getOutputStream() {
            return BemusedProtocol.this.oStream;
        }

        public void setDirInfo(String[] stringArray) {
            BemusedProtocol.this.fileBrowser.setDirInfo(stringArray);
        }

        public void setStatus(String string) {
            BemusedProtocol.this.itemdata.data = string;
            BemusedProtocol.this.notifyStatusUpdate();
        }
    }

    public class ItemData {
        public String data;
        private Translate t = Translate.getInstance();

        public ItemData() {
            this.data = Translate.get("Press any key to control");
        }
    }

    public class PlaybackStatus {
        public boolean playing = false;
        public boolean shuffle = false;
        public boolean repeat = false;
        public Date startTime = new Date();
        public long songLengthSecs = 0L;
        public String title = "<no title>";
        public String[] playlist;
        public int playlistPos;
        public int volume;
    }
}

