<?php

/*
   ----------------------------------------------------------------------
   FusionInventory
   Copyright (C) 2010-2011 by the FusionInventory Development Team.

   http://www.fusioninventory.org/   http://forge.fusioninventory.org/
   ----------------------------------------------------------------------

   LICENSE

   This file is part of FusionInventory.

   FusionInventory is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 2 of the License, or
   any later version.

   FusionInventory is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with FusionInventory.  If not, see <http://www.gnu.org/licenses/>.

   ------------------------------------------------------------------------
   Original Author of file: Walid Nouh
   Co-authors of file:
   Purpose of file: REST communication
   ----------------------------------------------------------------------
 */

//This call is to check that the ESX inventory service is up and running
if (isset($_GET['status'])) {
   return 'ok';
}

if(!defined('GLPI_ROOT')) {
   define('GLPI_ROOT', '../../../..');
}
include (GLPI_ROOT."/inc/includes.php");

$response = false;
//Agent communication using REST protocol
if (isset($_GET['action']) && isset($_GET['machineid'])) {
   switch ($_GET['action']) {
      case 'getJobs':
         //Specific to ESX
         $PluginFusioninventoryAgent = new PluginFusioninventoryAgent();
         $PluginFusioninventoryTaskjobstatus = new PluginFusioninventoryTaskjobstatus();
         
         $a_agent = $PluginFusioninventoryAgent->InfosByKey(addslashes_deep($_GET['machineid']));
         $moduleRun = $PluginFusioninventoryTaskjobstatus->getTaskjobsAgent($a_agent['id']);
         foreach ($moduleRun as $className => $array) {
            if (class_exists($className)) {
               if ($className == "PluginFusinvinventoryESX") {
                  $class = new $className();
                  $response = $class->run($array, $response);
               }
            }
         }
         break;
      case 'setLog':
         //Generic method to update logs
         PluginFusioninventoryRestCommunication::updateLog($_GET);
         break;
   }
   
   if ($response) {
      echo json_encode($response);
   } else {
      PluginFusioninventoryRestCommunication::sendError();
    }

}

?>