from gi.repository import Gio, Gtk

from typing import Optional

import iotas.config_manager


@Gtk.Template(resource_path="/org/gnome/gitlab/cheywood/Iotas/ui/font_size_selector.ui")
class FontSizeSelector(Gtk.Box):
    __gtype_name__ = "FontSizeSelector"

    _label = Gtk.Template.Child()
    _increase_button = Gtk.Template.Child()
    _decrease_button = Gtk.Template.Child()

    VALID_SIZES = [
        6,
        7,
        8,
        9,
        10,
        11,
        12,
        13,
        14,
        15,
        16,
        17,
        18,
        20,
        22,
        24,
        26,
        28,
        30,
        34,
        38,
    ]

    def __init__(self):
        super().__init__()
        iotas.config_manager.settings.connect("changed::font-size", self.__populate)
        self.__populate(None, None)

    @Gtk.Template.Callback()
    def _increment(self, _button: Gtk.Button) -> None:
        prev_size = iotas.config_manager.get_font_size()
        ind = self.VALID_SIZES.index(prev_size)
        iotas.config_manager.set_font_size(self.VALID_SIZES[ind + 1])

    @Gtk.Template.Callback()
    def _decrement(self, _button: Gtk.Button) -> None:
        prev_size = iotas.config_manager.get_font_size()
        ind = self.VALID_SIZES.index(prev_size)
        iotas.config_manager.set_font_size(self.VALID_SIZES[ind - 1])

    def __populate(self, _settings: Optional[Gio.Settings] = None, _key: str = "") -> None:
        size = iotas.config_manager.get_font_size()
        self._label.set_label("{}pt".format(size))
        self.__update_enabled_actions(size)

    def __update_enabled_actions(self, size: int) -> None:
        ind = self.VALID_SIZES.index(size)
        self._increase_button.set_sensitive(ind + 1 < len(self.VALID_SIZES))
        self._decrease_button.set_sensitive(ind - 1 >= 0)
