/*----- PROTECTED REGION ID(TestCppTango1022Class.cpp) ENABLED START -----*/
/* clang-format on */
//=============================================================================
//
// file :        TestCppTango1022Class.cpp
//
// description : C++ source for the TestCppTango1022Class.
//               A singleton class derived from DeviceClass.
//               It implements the command and attribute list
//               and all properties and methods required
//               by the TestCppTango1022 once per process.
//
//
//
// This file is part of Tango device class.
//
// Tango is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Tango is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Tango.  If not, see <http://www.gnu.org/licenses/>.
//
//
// Copyright (C): 2022
//                European Synchrotron Radiation Facility
//                BP 220, Grenoble 38043
//                France
//
//=============================================================================
//                This file is generated by POGO
//        (Program Obviously used to Generate tango Object)
//=============================================================================


#include "TestCppTango1022Class.h"
/* clang-format off */
/*----- PROTECTED REGION END -----*/	//	TestCppTango1022Class.cpp

//-------------------------------------------------------------------
/**
 *	Create TestCppTango1022Class singleton and
 *	return it in a C function for Python usage
 */
//-------------------------------------------------------------------
extern "C" {
#ifdef _TG_WINDOWS_

__declspec(dllexport)

#endif

	Tango::DeviceClass *_create_TestCppTango1022_class(const char *name) {
		return TestCppTango1022_ns::TestCppTango1022Class::init(name);
	}
}

namespace TestCppTango1022_ns
{
//===================================================================
//	Initialize pointer for singleton pattern
//===================================================================
TestCppTango1022Class *TestCppTango1022Class::_instance = NULL;

//===================================================================
//	Class constants
//===================================================================
//--------------------------------------------------------
/**
 * method : 		TestCppTango1022Class::TestCppTango1022Class(std::string &s)
 * description : 	constructor for the TestCppTango1022Class
 *
 * @param s	The class name
 */
//--------------------------------------------------------
TestCppTango1022Class::TestCppTango1022Class(std::string &s):Tango::DeviceClass(s)
{
	TANGO_LOG_INFO << "Entering TestCppTango1022Class constructor" << std::endl;
	set_default_property();
	write_class_property();

	/*----- PROTECTED REGION ID(TestCppTango1022Class::constructor) ENABLED START -----*/
	/* clang-format on */
	/* clang-format off */
	/*----- PROTECTED REGION END -----*/	//	TestCppTango1022Class::constructor

	TANGO_LOG_INFO << "Leaving TestCppTango1022Class constructor" << std::endl;
}

//--------------------------------------------------------
/**
 * method : 		TestCppTango1022Class::~TestCppTango1022Class()
 * description : 	destructor for the TestCppTango1022Class
 */
//--------------------------------------------------------
TestCppTango1022Class::~TestCppTango1022Class()
{
	/*----- PROTECTED REGION ID(TestCppTango1022Class::destructor) ENABLED START -----*/
	/* clang-format on */
	/* clang-format off */
	/*----- PROTECTED REGION END -----*/	//	TestCppTango1022Class::destructor

	_instance = NULL;
}


//--------------------------------------------------------
/**
 * method : 		TestCppTango1022Class::init
 * description : 	Create the object if not already done.
 *                  Otherwise, just return a pointer to the object
 *
 * @param	name	The class name
 */
//--------------------------------------------------------
TestCppTango1022Class *TestCppTango1022Class::init(const char *name)
{
	if (_instance == NULL)
	{
		try
		{
			std::string s(name);
			_instance = new TestCppTango1022Class(s);
		}
		catch (std::bad_alloc &)
		{
			throw;
		}
	}
	return _instance;
}

//--------------------------------------------------------
/**
 * method : 		TestCppTango1022Class::instance
 * description : 	Check if object already created,
 *                  and return a pointer to the object
 */
//--------------------------------------------------------
TestCppTango1022Class *TestCppTango1022Class::instance()
{
	if (_instance == NULL)
	{
		std::cerr << "Class is not initialised !!" << std::endl;
		exit(-1);
	}
	return _instance;
}



//===================================================================
//	Command execution method calls
//===================================================================

//===================================================================
//	Properties management
//===================================================================
//--------------------------------------------------------
/**
 *	Method      : TestCppTango1022Class::get_class_property()
 * Description:  Get the class property for specified name.
 */
//--------------------------------------------------------
Tango::DbDatum TestCppTango1022Class::get_class_property(std::string &prop_name)
{
	for (unsigned int i=0 ; i<cl_prop.size() ; i++)
		if (cl_prop[i].name == prop_name)
			return cl_prop[i];
	//	if not found, returns  an empty DbDatum
	return Tango::DbDatum(prop_name);
}

//--------------------------------------------------------
/**
 *	Method      : TestCppTango1022Class::get_default_device_property()
 * Description:  Return the default value for device property.
 */
//--------------------------------------------------------
Tango::DbDatum TestCppTango1022Class::get_default_device_property(std::string &prop_name)
{
	for (unsigned int i=0 ; i<dev_def_prop.size() ; i++)
		if (dev_def_prop[i].name == prop_name)
			return dev_def_prop[i];
	//	if not found, return  an empty DbDatum
	return Tango::DbDatum(prop_name);
}

//--------------------------------------------------------
/**
 *	Method      : TestCppTango1022Class::get_default_class_property()
 * Description:  Return the default value for class property.
 */
//--------------------------------------------------------
Tango::DbDatum TestCppTango1022Class::get_default_class_property(std::string &prop_name)
{
	for (unsigned int i=0 ; i<cl_def_prop.size() ; i++)
		if (cl_def_prop[i].name == prop_name)
			return cl_def_prop[i];
	//	if not found, return  an empty DbDatum
	return Tango::DbDatum(prop_name);
}


//--------------------------------------------------------
/**
 *	Method      : TestCppTango1022Class::set_default_property()
 * Description:  Set default property (class and device) for wizard.
 *                For each property, add to wizard property name and description.
 *                If default value has been set, add it to wizard property and
 *                store it in a DbDatum.
 */
//--------------------------------------------------------
void TestCppTango1022Class::set_default_property()
{
	std::string	prop_name;
	std::string	prop_desc;
	std::string	prop_def;
	std::vector<std::string>	vect_data;

	//	Set Default Class Properties

	//	Set Default device Properties
}

//--------------------------------------------------------
/**
 *	Method      : TestCppTango1022Class::write_class_property()
 * Description:  Set class description fields as property in database
 */
//--------------------------------------------------------
void TestCppTango1022Class::write_class_property()
{
//	First time, check if database used
if (Tango::Util::_UseDb == false)
	return;

Tango::DbData	data;
std::string	classname = get_name();
std::string	header;

//	Put title
Tango::DbDatum	title("ProjectTitle");
std::string	str_title("");
title << str_title;
data.push_back(title);

//	Put Description
Tango::DbDatum	description("Description");
std::vector<std::string>	str_desc;
str_desc.push_back("");
description << str_desc;
data.push_back(description);

//  Put inheritance
Tango::DbDatum	inher_datum("InheritedFrom");
std::vector<std::string> inheritance;
inheritance.push_back("TANGO_BASE_CLASS");
inher_datum << inheritance;
data.push_back(inher_datum);

//	Call database and and values
get_db_class()->put_property(data);
}

//===================================================================
//	Factory methods
//===================================================================

//--------------------------------------------------------
/**
 *	Method      : TestCppTango1022Class::device_factory()
 * Description:  Create the device object(s)
 *                and store them in the device list
 */
//--------------------------------------------------------
void TestCppTango1022Class::device_factory(const Tango::DevVarStringArray *devlist_ptr)
{
/*----- PROTECTED REGION ID(TestCppTango1022Class::device_factory_before) ENABLED START -----*/
/* clang-format on */
//	Add your own code
/* clang-format off */
/*----- PROTECTED REGION END -----*/	//	TestCppTango1022Class::device_factory_before

//	Create devices and add it into the device list
for (unsigned long i=0 ; i<devlist_ptr->length() ; i++)
{
	TANGO_LOG_DEBUG << "Device name : " << (*devlist_ptr)[i].in() << std::endl;
	device_list.push_back(new TestCppTango1022(this, (*devlist_ptr)[i]));
}

//	Manage dynamic attributes if any
erase_dynamic_attributes(devlist_ptr, get_class_attr()->get_attr_list());

//	Export devices to the outside world
for (unsigned long i=1 ; i<=devlist_ptr->length() ; i++)
{
	//	Add dynamic attributes if any
	TestCppTango1022 *dev = static_cast<TestCppTango1022 *>(device_list[device_list.size()-i]);
	dev->add_dynamic_attributes();

	//	Check before if database used.
	if ((Tango::Util::_UseDb == true) && (Tango::Util::_FileDb == false))
		export_device(dev);
	else
		export_device(dev, dev->get_name().c_str());
}

/*----- PROTECTED REGION ID(TestCppTango1022Class::device_factory_after) ENABLED START -----*/
/* clang-format on */
//	Add your own code
/* clang-format off */
/*----- PROTECTED REGION END -----*/	//	TestCppTango1022Class::device_factory_after
}
//--------------------------------------------------------
/**
 *	Method      : TestCppTango1022Class::attribute_factory()
 * Description:  Create the attribute object(s)
 *                and store them in the attribute list
 */
//--------------------------------------------------------
void TestCppTango1022Class::attribute_factory(TANGO_UNUSED(std::vector<Tango::Attr *> &att_list))
{
	/*----- PROTECTED REGION ID(TestCppTango1022Class::attribute_factory_before) ENABLED START -----*/
	/* clang-format on */
	//	Add your own code
	/* clang-format off */
	/*----- PROTECTED REGION END -----*/	//	TestCppTango1022Class::attribute_factory_before

	//	Create a list of static attributes
	create_static_attribute_list(get_class_attr()->get_attr_list());
	/*----- PROTECTED REGION ID(TestCppTango1022Class::attribute_factory_after) ENABLED START -----*/
	/* clang-format on */
	//	Add your own code
	/* clang-format off */
	/*----- PROTECTED REGION END -----*/	//	TestCppTango1022Class::attribute_factory_after
}
//--------------------------------------------------------
/**
 *	Method      : TestCppTango1022Class::pipe_factory()
 * Description:  Create the pipe object(s)
 *                and store them in the pipe list
 */
//--------------------------------------------------------
void TestCppTango1022Class::pipe_factory()
{
	/*----- PROTECTED REGION ID(TestCppTango1022Class::pipe_factory_before) ENABLED START -----*/
	/* clang-format on */
	//	Add your own code
	/* clang-format off */
	/*----- PROTECTED REGION END -----*/	//	TestCppTango1022Class::pipe_factory_before
	/*----- PROTECTED REGION ID(TestCppTango1022Class::pipe_factory_after) ENABLED START -----*/
	/* clang-format on */
	//	Add your own code
	/* clang-format off */
	/*----- PROTECTED REGION END -----*/	//	TestCppTango1022Class::pipe_factory_after
}
//--------------------------------------------------------
/**
 *	Method      : TestCppTango1022Class::command_factory()
 * Description:  Create the command object(s)
 *                and store them in the command list
 */
//--------------------------------------------------------
void TestCppTango1022Class::command_factory()
{
	/*----- PROTECTED REGION ID(TestCppTango1022Class::command_factory_before) ENABLED START -----*/
	/* clang-format on */
	//	Add your own code
	/* clang-format off */
	/*----- PROTECTED REGION END -----*/	//	TestCppTango1022Class::command_factory_before


	/*----- PROTECTED REGION ID(TestCppTango1022Class::command_factory_after) ENABLED START -----*/
	/* clang-format on */
	//	Add your own code
	/* clang-format off */
	/*----- PROTECTED REGION END -----*/	//	TestCppTango1022Class::command_factory_after
}

//===================================================================
//	Dynamic attributes related methods
//===================================================================

//--------------------------------------------------------
/**
 * method : 		TestCppTango1022Class::create_static_attribute_list
 * description : 	Create the a list of static attributes
 *
 * @param	att_list	the created attribute list
 */
//--------------------------------------------------------
void TestCppTango1022Class::create_static_attribute_list(std::vector<Tango::Attr *> &att_list)
{
	for (unsigned long i=0 ; i<att_list.size() ; i++)
	{
		std::string att_name(att_list[i]->get_name());
		transform(att_name.begin(), att_name.end(), att_name.begin(), ::tolower);
		defaultAttList.push_back(att_name);
	}

	TANGO_LOG_INFO << defaultAttList.size() << " attributes in default list" << std::endl;

	/*----- PROTECTED REGION ID(TestCppTango1022Class::create_static_att_list) ENABLED START -----*/
	/* clang-format on */
	/* clang-format off */
	/*----- PROTECTED REGION END -----*/	//	TestCppTango1022Class::create_static_att_list
}


//--------------------------------------------------------
/**
 * method : 		TestCppTango1022Class::erase_dynamic_attributes
 * description : 	delete the dynamic attributes if any.
 *
 * @param	devlist_ptr	the device list pointer
 * @param	list of all attributes
 */
//--------------------------------------------------------
void TestCppTango1022Class::erase_dynamic_attributes(const Tango::DevVarStringArray *devlist_ptr, std::vector<Tango::Attr *> &att_list)
{
	Tango::Util *tg = Tango::Util::instance();

	for (unsigned long i=0 ; i<devlist_ptr->length() ; i++)
	{
		Tango::DeviceImpl *dev_impl = tg->get_device_by_name(((std::string)(*devlist_ptr)[i]).c_str());
		TestCppTango1022 *dev = static_cast<TestCppTango1022 *> (dev_impl);

		std::vector<Tango::Attribute *> &dev_att_list = dev->get_device_attr()->get_attribute_list();
		std::vector<Tango::Attribute *>::iterator ite_att;
		for (ite_att=dev_att_list.begin() ; ite_att != dev_att_list.end() ; ++ite_att)
		{
			std::string att_name((*ite_att)->get_name_lower());
			if ((att_name == "state") || (att_name == "status"))
				continue;
			std::vector<std::string>::iterator ite_str = find(defaultAttList.begin(), defaultAttList.end(), att_name);
			if (ite_str == defaultAttList.end())
			{
				TANGO_LOG_INFO << att_name << " is a UNWANTED dynamic attribute for device " << (*devlist_ptr)[i] << std::endl;
				Tango::Attribute &att = dev->get_device_attr()->get_attr_by_name(att_name.c_str());
				dev->remove_attribute(att_list[att.get_attr_idx()], true, false);
				--ite_att;
			}
		}
	}
	/*----- PROTECTED REGION ID(TestCppTango1022Class::erase_dynamic_attributes) ENABLED START -----*/
	/* clang-format on */
	/* clang-format off */
	/*----- PROTECTED REGION END -----*/	//	TestCppTango1022Class::erase_dynamic_attributes
}

//--------------------------------------------------------
/**
 *	Method      : TestCppTango1022Class::get_attr_object_by_name()
 * Description:  returns Tango::Attr * object found by name
 */
//--------------------------------------------------------
Tango::Attr *TestCppTango1022Class::get_attr_object_by_name(std::vector<Tango::Attr *> &att_list, std::string attname)
{
	std::vector<Tango::Attr *>::iterator it;
	for (it=att_list.begin() ; it<att_list.end() ; ++it)
		if ((*it)->get_name()==attname)
			return (*it);
	//	Attr does not exist
	return NULL;
}


/*----- PROTECTED REGION ID(TestCppTango1022Class::Additional Methods) ENABLED START -----*/
/* clang-format on */
/* clang-format off */
/*----- PROTECTED REGION END -----*/	//	TestCppTango1022Class::Additional Methods
} //	namespace
