package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteCustomerGateway invokes the vpc.DeleteCustomerGateway API synchronously
func (client *Client) DeleteCustomerGateway(request *DeleteCustomerGatewayRequest) (response *DeleteCustomerGatewayResponse, err error) {
	response = CreateDeleteCustomerGatewayResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteCustomerGatewayWithChan invokes the vpc.DeleteCustomerGateway API asynchronously
func (client *Client) DeleteCustomerGatewayWithChan(request *DeleteCustomerGatewayRequest) (<-chan *DeleteCustomerGatewayResponse, <-chan error) {
	responseChan := make(chan *DeleteCustomerGatewayResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteCustomerGateway(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteCustomerGatewayWithCallback invokes the vpc.DeleteCustomerGateway API asynchronously
func (client *Client) DeleteCustomerGatewayWithCallback(request *DeleteCustomerGatewayRequest, callback func(response *DeleteCustomerGatewayResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteCustomerGatewayResponse
		var err error
		defer close(result)
		response, err = client.DeleteCustomerGateway(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteCustomerGatewayRequest is the request struct for api DeleteCustomerGateway
type DeleteCustomerGatewayRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	CustomerGatewayId    string           `position:"Query" name:"CustomerGatewayId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DeleteCustomerGatewayResponse is the response struct for api DeleteCustomerGateway
type DeleteCustomerGatewayResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteCustomerGatewayRequest creates a request to invoke DeleteCustomerGateway API
func CreateDeleteCustomerGatewayRequest() (request *DeleteCustomerGatewayRequest) {
	request = &DeleteCustomerGatewayRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "DeleteCustomerGateway", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteCustomerGatewayResponse creates a response to parse from DeleteCustomerGateway response
func CreateDeleteCustomerGatewayResponse() (response *DeleteCustomerGatewayResponse) {
	response = &DeleteCustomerGatewayResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
