_Note: This is kind of a living document, which might not form part of the user-facing documentation._

# Textual Color System

Textual's color system is a palette of colors for building TUIs, and a set of guidelines for how they should be used. Based loosely on Google's Material color system, the Textual color system ensures that elements in the TUI look aesthetically pleasing while maximizing legibility

## The colors

There are 10 base colors specified in the Textual Color System. Although it is unlikely that all will need to be specified, since some may be derived from others, and some defaults may not need to be changed.

A dark mode is automatically derived from the base colors. See Dark Mode below.

### Shades

Each color has 6 additional shades (3 darker and 3 lighter), giving a total of 7 shades per color. These are calculated automatically from the base colors.

### Primary and Secondary

The _primary_ and _secondary_ colors are used as a background for large areas of the interface, such as headers and sidebars. The secondary color is optional, and if not supplied will be set to be the same as primary. If supplied, the secondary color should be compliment the primary, and together can be considered the _branding colors_ as they have the greatest influence over the look of the TUI.

### Background and Surface

The _surface_ colors is the base color which goes behind text. The _background_ color is typically the negative space where there is no content.

These two colors tend to be very similar, with just enough difference in lightness to tell them apart. They should be chosen for good contrast with the text.

In light mode the default background is #efefef (a bright grey) and the surface is #f5f5f5 (off white). In dark mode the default background is 100% black, and the default surface is #121212 (very dark grey).

Note that, although both background and surface support the full range of shades, it may not be possible to darken or lighten them further. i.e. you can't get any lighter than 100% white or darken than 100% black.

### Panel

The _panel_ color is typically used as a background to emphasize text on the default surface, or as a UI element that is above the regular UI, such as a menu.

The default panel color is derived from the surface color by blending it towards either white or black text (depending on mode).

Unlike background and surface, the panel color is automatically selected so that it can always be lightened or darkened by the full range.

### Accent

The _accent_ color should be a contrasting color use in UI elements that should stand out, such as selections, status bars, and underlines.

### Warning, Error, and Success

The _warning_, _error_, and _success_ colors have semantic meaning. While they could be any color, by convention warning should be amber / orange, error should be red, and success should be green.

### System

The system color is used for system controls such as scrollbars. The default is for the system color to be the same as accent, but it is recommended that a different color is chosen to differentiate app controls from those rendered by the Textual system.

## Text

For every color and shade there is an automatically calculated text color, which is either white or black, chosen to produce the greatest contrast.

The default text color as a slight alpha component, so that it not pure black or pure white, but a slight tint of the background showing through. Additionally, there are two text shades with increasingly greater alpha for reduced intensity text.

## Dark Mode

A dark mode is automatically generated from the theme. The dark variations of the primary and secondary colors are generated by blending with the background color. This ensures that the branding remains intact, while still providing dark backgrounds.

The dark variations of the background and surface color defaults are selected. The other colors remain the same as light mode. The overall effect is that the majority of the interface is dark, with small portions highlighted by color.

## Naming

The color system produces a number of constants which are exposed in the CSS via variables.

The name of the color will return one of the standard set of colors, for example `primary` or `panel`.

For one of the shade variations, you can append `-darken-1`, `-darken-2`, `-darken-3` for increasingly darker colors, and `-lighten-1`, `lighten-2`, `lighten-3` for increasingly light colors.

For the contrasting text color, prefix the name with `text-`, for instance `text-primary` or `text-panel`. Note that if the text is to be on top of a darkened or lightened color, it must also be included in the name. i.e. if the background is `primary-darken-2`, then the corresponding text color should be `text-primary-darken-2`.

The additional two levels of faded text may be requested by appending `-fade-1` or `-fade-2` for decreasing levels of text alpha.
