/*
 *	TICKR - GTK-based Feed Reader - Copyright (C) Emmanuel Thomas-Maurin 2009-2013
 *	<manutm007@gmail.com>
 *
 * 	This program is free software: you can redistribute it and/or modify
 * 	it under the terms of the GNU General Public License as published by
 * 	the Free Software Foundation, either version 3 of the License, or
 * 	(at your option) any later version.
 *
 * 	This program is distributed in the hope that it will be useful,
 * 	but WITHOUT ANY WARRANTY; without even the implied warranty of
 * 	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * 	GNU General Public License for more details.
 *
 * 	You should have received a copy of the GNU General Public License
 * 	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "tickr.h"

static const char *help_str0[] = {
"USER INTERFACE MAIN FEATURES:\n\n",

"- To open the main menu, right-click inside ticker area.\n\n",

"- You can import feed subscriptions with 'File > Import Feed List (OPML)',\n",
"for instance your Google Reader subscriptions.\n\n",

"- To open a link in your browser, left-click on text.\n\n",

"- Use mouse wheel to either adjust the ticker scrolling speed or open the\n",
"'Selected Feed Picker' window to quickly move between selected feeds (if set,\n",
"Ctrl + mouse wheel scrolling applies to other value.)\n",
"This behaviour is set in the 'Preferences' window as 'Mouse wheel scrolling\n",
"applies to'.\n\n",

"- Basically, you will use 'File > Open RSS Feed' to choose a feed from a\n",
"list, subscribe to a new one, manage your feed list, and 'Edit > Preferences'\n",
"to tweak the ticker appearance as well as other settings.\n\n",

"- 'Window - always on top' -> check this if you want the ticker to always\n",
"stay above your browser (and any other windows.)\n\n",

"- 'Window - decorated' -> if you want a 'draggable' ticker.\n\n",

"There is a sample list of already subscribed feeds that you can use.\n\n",

"***ONLY*** in case you're using the ticker inside a ***decorated*** window,\n",
"you can use these keyboard shortcuts:\n\n",

"- <Ctrl>R to open the 'RSS Feed Picker' window (to choose a feed or to\n",
"subscribe to a new one.)\n\n",

"- <Ctrl>T to open a text file.\n\n",

"- <Ctrl>I to import (and merge) an URL list from an OPML file.\n\n",

"- <Ctrl>E to export the URL list to an OPML file.\n\n",

"- <Ctrl>P to open the 'Resource Properties' window.\n\n",

"- <Ctrl>Q to quit.\n\n",

"- <Ctrl>S to open the 'Preferences' (Settings) window.\n\n",

"- <Ctrl>B to open the link displayed inside the ticker (in the middle.)\n\n",

"- <Ctrl>J to play the feed / <Ctrl>K to pause / <Ctrl>L to reload.\n\n",

"- <Ctrl>U (speed Up) / <Ctrl>D (speed Down) to adjust tscrolling speed on\n",
"the fly.\n\n",

"- F1 to open the 'Quick Help' window.\n\n",

"- <Ctrl>H to launch the 'Online Help' (this very page.)\n\n",

"- <Ctrl>A to open the 'About' window and the License window.\n\n\n",

"COMMAND LINE REFERENCE:\n\n",

NULL};

static const char *help_str1[] = {
	APP_NAME "-" APP_VERSION_NUMBER " - GTK-based highly graphically-customizable Feed Ticker\n",
	"Copyright (C) 2009-2013 Emmanuel Thomas-Maurin <manutm007@gmail.com>\n\n",
	APP_NAME " is a GTK-based RSS/Atom Reader that displays feeds as a smooth\n"
	"scrolling line on your Desktop, as known from TV stations. Open feed\n"
	"links in your favourite Browser. Graphics are highly customizable.\n\n"
	"Usage:\n",
	"        " APP_CMD " [-help/-version/-license/-instance-id=n/-no-ui/-dumpfontlist]\n",
	"              [options (-name[=value])...] [resource (file name or URL)]\n\n",
	"        help                           Get this help page\n\n",
	"        version                        Print out version number\n\n",
	"        license                        Print out license\n\n",
	"        instance-id=n                  n = 1 to 99 - Use this when launching\n",
	"                                       several instances simultaneously, each\n",
	"                                       instance using its own config and dump\n",
	"                                       files (to be effective, instance-id must\n",
	"                                       be the 1st argument)\n\n",
	"        no-ui                          Disable opening of UI elements which can\n",
	"                                       modify settings and/or URL list/\n",
	"                                       selection\n\n",
	"        dumpfontlist                   Send list of available fonts to stdout\n\n",
	"Options:\n",
	"        delay=n                        Delay in milliseconds\n\n",
	"        shiftsize=n                    Shift size in pixels\n\n",
	"        fgcolor=#rrggbbaa              Foreground 32-bit hexa color\n\n",
	"        bgcolor=#rrggbbaa              Background 32-bit hexa color\n\n",
	"        setgradientbg=[y/n]            Set gradient background\n\n",
	"        bgcolor2=#rrggbbaa             Background 32-bit hexa color2\n\n",
	"        fontname='str'                 Font name\n\n",
	"        fontsize=n                     Font size (can't be > 200)\n\n",	/* check this is up to date */
	"        disablescreenlimits=[y/n]      Allow win_y and win_w to be greater than\n"
	"                                       screen dimensions\n\n",
	"        win_x=n                        Window position - x\n\n",
	"        win_y=n                        Window position - y\n\n",
	"        win_w=n                        Window width\n\n",
	"        win_h=n                        Window height (compute font size if > 0)\n\n",
	"        windec=[y/n]                   Window decoration\n\n",
	"        alwaysontop=[y/n]              Window always-on-top\n\n",
	"        wintransparency=n              Actually window opacity from 1 to 10\n",
	"                                       (0 = none -> 10 = full)\n\n",
	"        iconintaskbar=[y/n]            Icon in taskbar\n\n",
	"        winsticky=[y/n]                Visible on all user desktops\n\n",
	"        shadow=[y/n]                   Apply shadow to text\n\n",
	"        shadowoffset_x=n               Shadow x offset in pixels\n\n",
	"        shadowoffset_y=n               Shadow y offset in pixels\n\n",
	"        shadowfx=n                     Shadow effect (0 = none -> 10 = full)\n\n",
	"        linedelimiter='str'            String to be appended at end of line\n\n",
	"        cutlinedelimiter='str'         String to be appended after a cut line\n\n",
	"        specialchars=[y/n]             Enable or disable special characters.\n",
	"                                       This is only useful when resource is a\n",
	"                                       file, not an URL\n\n",
	"        newpgchar=c                    'New page' special character\n\n",
	"        tabchar=c                      'Tab' (8 spaces) special character\n\n",
	"        rssrefresh=n                   Refresh rate in minutes (if no TTL\n",
	"                                       inside feed / always applies for files)\n\n",
	"        feedtitle=[y/n]                Show or hide feed title\n\n",
	"        feedtitledelimiter='str'       String to be appended after feed title\n\n",
	"        itemtitle=[y/n]                Show or hide item title\n\n",
	"        itemtitledelimiter='str'       String to be appended after item title\n\n",
	"        itemdescription=[y/n]          Show or hide item description\n\n",
	"        itemdescriptiondelimiter='str' String to be appended after item\n",
	"                                       description\n\n",
	"        nitemsperfeed=n                Read N items max per feed\n\n",
	"        rmtags=[y/n]                   Strip html tags\n\n",
	"        uppercasetext=[y/n]            Set all text to upper case\n\n",
	"        homefeed='str'                 Set URL as 'homefeed' = homepage\n",
	"                                       (from command line, not automatically\n",
	"                                       saved, so a little bit useless...)\n\n",
	"        openlinkcmd='str'              'Open in Browser' command line:\n",
	"                                       Application that will open active link\n",
	"                                       (may require path.) Most likely will\n",
	"                                       invoke your favourite browser\n\n",
	"        openlinkargs='str'             'Open in Browser' optional arguments\n\n",
	"        clock=[l/r/n]                  Clock location: left / right / none\n\n",
	"        clockfontname='str'            Clock font name\n\n",
	"        clockfontsize=n                Clock font size (can't be > ticker\n",
	"                                       height)\n\n",
	"        clockfgcolor=#rrggbbaa         Clock foreground 32-bit hexa color\n\n",
	"        clockbgcolor=#rrggbbaa         Clock background 32-bit hexa color\n\n",
	"        setclockgradientbg=[y/n]       Set clock gradient background\n\n",
	"        clockbgcolor2=#rrggbbaa        Clock background 32-bit hexa color2\n\n",
	"        disablepopups=[y/n]            Disable error/warning popup windows\n\n",
	"        pauseonmouseover=[y/n]         Pause ticker on mouseover\n\n",
	"        disableleftclick=[y/n]         Disable left-click\n\n",
	"        mousewheelscroll=[s/f/n]       Mouse wheel scrolling applies to:\n",
	"                                       (ticker-)speed / feed(-in-list) / none\n",
	"                                       (if set, Ctrl + mouse wheel scrolling\n",
	"                                       applies to other value)\n\n",
	"        sfpickercloseswhenpointerleaves=[y/n]\n",
	"                                       Selected feed picker closes when pointer\n",
	"                                       leaves\n\n",
	"        enablefeedordering=[y/n]       Enable feed re-ordering (by user)\n\n",
	"        useauth=[y/n]                  Use HTTP basic authentication\n\n",
	"        user='str'                     User\n\n",
	"        psw='str'                      Password (never saved)\n\n",
	"        useproxy=[y/n]                 Connect through proxy\n\n",
	"        proxyhost='str'                Proxy host\n\n",
	"        proxyport='str'                Proxy port\n\n",
	"        useproxyauth=[y/n]             Use proxy authentication\n\n",
	"        proxyuser='str'                Proxy user\n\n",
	"        proxypsw='str'                 Proxy password (never saved)\n\n",
	"Mouse usage:\n"
	"        To open the main menu, right-click inside ticker area.\n\n",
	"        You can import feed subscriptions from another feed reader with\n",
	"        'File > Import Feed List (OPML)'.\n\n",
	"        To open a link in your browser, left-click on text.\n\n",
	"        Use mouse wheel to either adjust ticker scrolling speed or open the\n",
	"        'Selected Feed Picker' window to quickly move between selected feeds\n",
	"        (and use Ctrl + mouse wheel for the other option.)\n\n",
	"The default browser is Firefox on Linux. You may change this setting to your\n",
	"favourite one in the Preferences window.\n\n",
	APP_NAME " parses command line arguments and looks for option(s) then for one\n",
	"resource, the rest of the line is ignored. It reads too configuration file\n",
#ifndef G_OS_WIN32
	"'" APP_CMD "-conf' located in /home/<user_name>/" TICKR_DIR_NAME "/ if it exists (or\n",
	"'" APP_CMD "-conf<n>' if an instance id has been set to n.)\n\n",
#else
	"'" APP_CMD "-conf' located in <Application Data directory>" TICKR_DIR_NAME "/ if it exists (or\n",
	"'" APP_CMD "-conf<n>' if an instance id has been set to n.)\n\n",
#endif
	"Command line options override configuration file ones which override default\n",
	"ones.\n\n",
	"Compiled with GTK+ and Libxml2 on " __DATE__ " - " __TIME__ "\n",
	"\nVisit " WEBSITE_URL " for more info.\n",
	NULL};

static const char *license_str1[] = {
	APP_NAME " version " APP_VERSION_NUMBER " - Copyright (C) Emmanuel Thomas-Maurin 2009-2013\n\n",
	APP_NAME " is free software: you can redistribute it and/or modify\n",
	"it under the terms of the GNU General Public License as published by\n",
	"the Free Software Foundation, either version 3 of the License, or\n",
	"(at your option) any later version.\n\n",
	APP_NAME " is distributed in the hope that it will be useful,\n",
	"but WITHOUT ANY WARRANTY; without even the implied warranty of\n",
	"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n",
	"GNU General Public License for more details.\n\n",
	"You should have received a copy of the GNU General Public License\n",
	"along with this program.  If not, see ",
	NULL};

static const char *license_str2 =
	"http://www.gnu.org/licenses/\n";

const char** get_help_str0()
{
	return help_str0;
}

const char** get_help_str1()
{
	return help_str1;
}

const char** get_license_str1()
{
	return license_str1;
}

const char* get_license_str2()
{
	return license_str2;
}
