/*
 *========================================================================
 * $Id: users.c 88 2004-09-28 22:49:38Z rgb $
 *
 * See copyright in copyright.h and the accompanying file COPYING
 *========================================================================
 */

#include <wulfware/libwulf.h>

/*
 * <users> tag init and update (same thing)
 */
void init_users(Host *hostptr)
{

 /* 
  * scratch: current timestamp and delta (to microsecond resolution) 
  */
 unsigned long seconds,useconds;

 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: Starting init_users().  Use -v %d to focus.\n",D_VALUES);
   
 }

 /* 
  * users - tv_sec and tv_usec timestamps.
  */
 /* <users tv_sec=?> */
 if(xtract_attribute(UNSIGNED_LONG,&seconds,value_xpath[USERS],
                      "tv_sec",hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",
         value_xpath[USERS]);
 }
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: seconds = %d\n",seconds);
 }
 hostptr->val.users_tv_sec = seconds;

 /* <users tv_usec=?> */
 if(xtract_attribute(UNSIGNED_LONG,&useconds,value_xpath[USERS],
                      "tv_usec",hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",
         value_xpath[USERS]);
 }
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: useconds = %d\n",useconds);
 }
 hostptr->val.users_tv_usec = useconds;
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: users_tv_sec = %ul users_tv_usec = %ul\n",hostptr->val.users_tv_sec,hostptr->val.users_tv_usec);
 }

 if(xtract(LONG,&hostptr->val.users,value_xpath[USERS],hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",
       value_xpath[USERS]);
 }
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: number of users = %d\n",hostptr->val.users);
 }

}


void update_users(Host *hostptr)
{

 /* 
  * scratch: current timestamp and delta (to microsecond resolution) 
  */
 unsigned long seconds,useconds;

 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: Starting init_users().  Use -v %d to focus.\n",D_VALUES);
   
 }

 /* 
  * users - tv_sec and tv_usec timestamps.
  */
 /* <users tv_sec=?> */
 if(xtract_attribute(UNSIGNED_LONG,&seconds,value_xpath[USERS],
                      "tv_sec",hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",
         value_xpath[USERS]);
 }
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: seconds = %d\n",seconds);
 }
 hostptr->val.users_tv_sec = seconds;

 /* <users tv_usec=?> */
 if(xtract_attribute(UNSIGNED_LONG,&useconds,value_xpath[USERS],
                      "tv_usec",hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",
         value_xpath[USERS]);
 }
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: useconds = %d\n",useconds);
 }
 hostptr->val.users_tv_usec = useconds;
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: users_tv_sec = %ul users_tv_usec = %ul\n",hostptr->val.users_tv_sec,hostptr->val.users_tv_usec);
 }

 if(xtract(LONG,&hostptr->val.users,value_xpath[USERS],hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",
       value_xpath[USERS]);
 }
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: number of users = %d\n",hostptr->val.users);
 }

}
